/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.servlet.http.HttpServletResponse;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.json.JSONObject;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.datamodel.ResBase;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticheGiornaliere;
import org.openspcoop2.web.monitor.statistiche.mbean.BaseStatsMBean;
import org.openspcoop2.web.monitor.statistiche.utils.ExportUtils;
import org.openspcoop2.web.monitor.statistiche.utils.JsonStatsUtils;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;

public class DistribuzionePerErroriBean<T extends ResBase>
extends BaseStatsMBean<T, Integer, IService<ResBase, Integer>> {
    private static final long serialVersionUID = 1L;

    public DistribuzionePerErroriBean() {
        this.initDpEB();
    }

    public DistribuzionePerErroriBean(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        super(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
        this.initDpEB();
    }

    private void initDpEB() {
        this.setChartId("distribuzioneErrori");
        this.setFilename("../FusionCharts/ScrollCombi2D.swf");
    }

    public void setStatisticheGiornaliereService(IStatisticheGiornaliere statisticheGiornaliereService) {
        this.service = statisticheGiornaliereService;
    }

    public String getXml() {
        List<ResDistribuzione> list;
        this.setVisualizzaComandiExport(false);
        try {
            list = ((IStatisticheGiornaliere)this.service).findAllDistribuzioneErrori();
        }
        catch (ServiceException e) {
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        TipoReport tipoReport = ((StatsSearchForm)this.search).getTipoReport();
        String xml = "";
        switch (tipoReport) {
            case BAR_CHART: {
                xml = StatsUtils.getXmlBarChartDistribuzione(list, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getSlice());
                break;
            }
            case PIE_CHART: {
                xml = StatsUtils.getXmlPieChartDistribuzione(list, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getSlice());
                break;
            }
        }
        if (list != null && list.size() > 0) {
            this.setVisualizzaComandiExport(true);
        }
        return xml;
    }

    public String getJson() {
        List<ResDistribuzione> list;
        JSONObject grafico = null;
        this.setVisualizzaComandiExport(false);
        try {
            list = ((IStatisticheGiornaliere)this.service).findAllDistribuzioneErrori();
        }
        catch (ServiceException e) {
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        TipoReport tipoReport = ((StatsSearchForm)this.search).getTipoReport();
        block1 : switch (tipoReport) {
            case BAR_CHART: {
                NumeroDimensioni numeroDimensioni = ((StatsSearchForm)this.search).getNumeroDimensioni();
                switch (numeroDimensioni) {
                    case DIMENSIONI_3: 
                    case DIMENSIONI_3_CUSTOM: {
                        StatisticType statisticType = StatsUtils.checkStatisticType((StatsSearchForm)this.search, false);
                        grafico = JsonStatsUtils.getJsonHeatmapChartDistribuzione(list, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getDirezioneLabel(), this.getSlice(), statisticType, this.isVisualizzaTotaleNelleCelleGraficoHeatmap(), DynamicPdDBean.log);
                        break block1;
                    }
                }
                grafico = JsonStatsUtils.getJsonBarChartDistribuzione(list, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getDirezioneLabel(), this.getSlice());
                break;
            }
            case PIE_CHART: {
                grafico = JsonStatsUtils.getJsonPieChartDistribuzione(list, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getSlice());
                break;
            }
        }
        if (list != null && !list.isEmpty()) {
            this.setVisualizzaComandiExport(true);
        }
        String json = grafico != null ? grafico.toString() : "";
        log.debug(json);
        return json;
    }

    @Override
    public String getData() {
        if (((StatsSearchForm)this.search).isUseGraficiSVG()) {
            return this.getJson();
        }
        return this.getXml();
    }

    public String getCaption() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.distribuzione.label")).append(" ");
        if (((StatsSearchForm)this.search).isShowUnitaTempo()) {
            if (StatisticType.GIORNALIERA.equals((Object)this.getTempo())) {
                sb.append("Giornaliera").append(" ");
            } else if (StatisticType.ORARIA.equals((Object)this.getTempo())) {
                sb.append("Oraria").append(" ");
            } else if (StatisticType.MENSILE.equals((Object)this.getTempo())) {
                sb.append("Mensile").append(" ");
            } else if (StatisticType.SETTIMANALE.equals((Object)this.getTempo())) {
                sb.append("Settimanale").append(" ");
            } else {
                sb.append("Giornaliera").append(" ");
            }
        }
        sb.append(MessageManager.getInstance().getMessage("stats.analisiStatistica.tipoDistribuzione.errori.label.suffix")).append(" ");
        return sb.toString();
    }

    public String getSubCaption() {
        String captionText = StatsUtils.getSubCaption((StatsSearchForm)this.search);
        StringBuilder caption = new StringBuilder(captionText);
        if (this.search.getDataInizio() != null && this.search.getDataFine() != null) {
            if (this.btnLblPrefix(this.search).toLowerCase().contains("ora")) {
                caption.append(MessageFormat.format(" ( dal {0} al {1} )", this.formatDate(this.search.getDataInizio(), true), this.formatDate(this.search.getDataFine(), true)));
            } else {
                caption.append(MessageFormat.format(" ( dal {0} al {1} )", this.formatDate(this.search.getDataInizio(), false), this.formatDate(this.search.getDataFine(), false)));
            }
        }
        return caption.toString();
    }

    public void newSearch(ActionEvent ae) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application app = facesContext.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        ValueExpression valueExp = elFactory.createValueExpression(elContext, "#{distribuzionePerErroriBean}", DistribuzionePerErroriBean.class);
        DistribuzionePerErroriBean<T> ab = new DistribuzionePerErroriBean<T>();
        valueExp.setValue(elContext, ab);
    }

    @Override
    public String submit() {
        return "distribErrori";
    }

    public String getSommaColumnHeader() {
        return StatsUtils.sommaColumnHeader((StatsSearchForm)this.search, "Transazioni");
    }

    @Override
    public String esportaCsv() {
        try {
            return this._esportaCsv(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaCsv(HttpServletResponse response) throws Exception {
        this._esportaCsv(response, false);
    }

    private String _esportaCsv(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato CSV in corso....");
        String fileExt = ".csv";
        String filename = this.getExportFilename() + fileExt;
        List<ResDistribuzione> list = null;
        try {
            list = ((IStatisticheGiornaliere)this.service).findAllDistribuzioneErrori();
            if (list == null || list.size() <= 0) {
                throw new NotFoundException("Dati non trovati");
            }
        }
        catch (Exception e) {
            if (useFaceContext) {
                DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                return null;
            }
            DynamicPdDBean.log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            String headerLabel = "Esito";
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), false);
            ExportUtils.esportaCsv((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato CSV.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaXls() {
        try {
            return this._esportaXls(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaXls(HttpServletResponse response) throws Exception {
        this._esportaXls(response, false);
    }

    private String _esportaXls(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato XLS in corso....");
        String fileExt = ".xls";
        String filename = this.getExportFilename() + fileExt;
        List<ResDistribuzione> list = null;
        try {
            list = ((IStatisticheGiornaliere)this.service).findAllDistribuzioneErrori();
            if (list == null || list.size() <= 0) {
                throw new NotFoundException("Dati non trovati");
            }
        }
        catch (Exception e) {
            if (useFaceContext) {
                DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                return null;
            }
            DynamicPdDBean.log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            String headerLabel = "Esito";
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), false);
            ExportUtils.esportaXls((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato XLS.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaPdf() {
        try {
            return this._esportaPdf(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaPdf(HttpServletResponse response) throws Exception {
        this._esportaPdf(response, false);
    }

    private String _esportaPdf(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato PDF in corso....");
        String fileExt = ".pdf";
        String filename = this.getExportFilename() + fileExt;
        List<ResDistribuzione> list = null;
        try {
            list = ((IStatisticheGiornaliere)this.service).findAllDistribuzioneErrori();
            if (list == null || list.size() <= 0) {
                throw new NotFoundException("Dati non trovati");
            }
        }
        catch (Exception e) {
            if (useFaceContext) {
                DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                return null;
            }
            DynamicPdDBean.log.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            String headerLabel = "Esito";
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), true);
            ExportUtils.esportaPdf((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato PDF.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaXml() {
        try {
            return this._esportaXml(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaXml(HttpServletResponse response) throws Exception {
        this._esportaXml(response, false);
    }

    private String _esportaXml(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato XML in corso....");
        String fileExt = ".xml";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            response.getOutputStream().write(this.getXml().getBytes());
            response.getOutputStream().flush();
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato XML.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaJson() {
        try {
            return this._esportaJson(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaJson(HttpServletResponse response) throws Exception {
        this._esportaJson(response, false);
    }

    private String _esportaJson(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato JSON in corso....");
        String fileExt = ".json";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            response.getOutputStream().write(this.getJson().getBytes());
            response.getOutputStream().flush();
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato JSON.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String getExportFilename() {
        return "distribuzione_errori";
    }

    public boolean isTimeoutEvent() {
        return ((IStatisticheGiornaliere)this.service).isTimeoutEvent();
    }
}

