/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.mbean;

import java.io.OutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import net.sf.dynamicreports.jasper.builder.JasperReportBuilder;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.plugins.dao.IServiceManager;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.monitor.engine.config.statistiche.ConfigurazioneStatistica;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.BaseSearchForm;
import org.openspcoop2.web.monitor.core.dao.IService;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.mbean.DynamicPdDBean;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePersonalizzateSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticaPersonalizzataService;
import org.openspcoop2.web.monitor.statistiche.dao.IStatisticheGiornaliere;
import org.openspcoop2.web.monitor.statistiche.mbean.BaseStatsMBean;
import org.openspcoop2.web.monitor.statistiche.utils.ExportUtils;
import org.openspcoop2.web.monitor.statistiche.utils.JsonStatsUtils;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;

public class StatsPersonalizzateBean
extends BaseStatsMBean<ConfigurazioneStatistica, Long, IService<ConfigurazioneStatistica, Long>> {
    private static final long serialVersionUID = 1L;
    private IStatisticheGiornaliere statisticheGiornaliereService;

    public StatsPersonalizzateBean() {
        this.initSPB();
    }

    public StatsPersonalizzateBean(org.openspcoop2.core.commons.search.dao.IServiceManager serviceManager, IServiceManager pluginsServiceManager, DriverRegistroServiziDB driverRegistroServiziDB, DriverConfigurazioneDB driverConfigurazioneDB) {
        super(serviceManager, pluginsServiceManager, driverRegistroServiziDB, driverConfigurazioneDB);
        this.initSPB();
    }

    private void initSPB() {
        this.setChartId("statistichePersonalizzate");
        this.setFilename("../FusionCharts/ScrollCombi2D.swf");
    }

    public void setStatisticheGiornaliereService(IStatisticheGiornaliere statisticheGiornaliereService) {
        this.statisticheGiornaliereService = statisticheGiornaliereService;
    }

    public void setSearch(BaseSearchForm search) {
        this.search = search;
        if (this.search instanceof StatistichePersonalizzateSearchForm) {
            ((StatistichePersonalizzateSearchForm)this.search).setService((IStatisticaPersonalizzataService)this.service);
            ((StatistichePersonalizzateSearchForm)this.search).setmBean(this);
        }
    }

    @Override
    public StatisticType getTempo() {
        return ((StatistichePersonalizzateSearchForm)this.search).getModalitaTemporale() == null ? StatisticType.GIORNALIERA : ((StatistichePersonalizzateSearchForm)this.search).getModalitaTemporale();
    }

    public String getXml() {
        StringBuilder sb = new StringBuilder();
        try {
            SimpleDateFormat sdf_last_hour = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            StatisticType tempo = this.getTempo();
            SimpleDateFormat sdf = StatisticType.MENSILE.equals((Object)tempo) ? new SimpleDateFormat("MM/yy", ApplicationBean.getInstance().getLocale()) : (StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale()));
            TipoReport tipoReport = ((StatistichePersonalizzateSearchForm)this.search).getTipoReport();
            if (tipoReport.equals((Object)TipoReport.ANDAMENTO_TEMPORALE)) {
                Map<String, List<Res>> results = null;
                try {
                    results = this.statisticheGiornaliereService.findAllAndamentoTemporalePersonalizzato();
                }
                catch (ServiceException e) {
                    MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                sb.append(StatsUtils.getXmlAndamentoTemporaleStatPersonalizzate(sdf, sdf_last_hour, tempo, results, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption()));
                if (results != null && results.size() > 0) {
                    this.setVisualizzaComandiExport(true);
                }
            } else {
                List<ResDistribuzione> list = null;
                try {
                    list = this.statisticheGiornaliereService.findAllDistribuzionePersonalizzata();
                }
                catch (ServiceException e) {
                    MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (tipoReport.equals((Object)TipoReport.PIE_CHART)) {
                    sb.append(StatsUtils.getXmlPieChartStatistichePersonalizzate(list, (StatsSearchForm)this.search, this.getSlice(), this.getCaption(), this.getSubCaption()));
                } else if (tipoReport.equals((Object)TipoReport.BAR_CHART)) {
                    sb.append(StatsUtils.getXmlBarChartStatistichePersonalizzate(list, (StatsSearchForm)this.search, this.getSlice(), this.getCaption(), this.getSubCaption()));
                }
                if (list != null && list.size() > 0) {
                    this.setVisualizzaComandiExport(true);
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getJson() {
        JSONObject grafico;
        block12: {
            grafico = null;
            try {
                SimpleDateFormat sdf_last_hour = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
                StatisticType tempo = this.getTempo();
                SimpleDateFormat sdf = StatisticType.MENSILE.equals((Object)tempo) ? new SimpleDateFormat("MM/yy", ApplicationBean.getInstance().getLocale()) : (StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale()));
                TipoReport tipoReport = ((StatistichePersonalizzateSearchForm)this.search).getTipoReport();
                if (tipoReport.equals((Object)TipoReport.ANDAMENTO_TEMPORALE)) {
                    Map<String, List<Res>> results = null;
                    try {
                        results = this.statisticheGiornaliereService.findAllAndamentoTemporalePersonalizzato();
                    }
                    catch (ServiceException e) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                        return null;
                    }
                    grafico = JsonStatsUtils.getJsonAndamentoTemporaleStatPersonalizzate(sdf, sdf_last_hour, tempo, results, (StatsSearchForm)this.search, this.getCaption(), this.getSubCaption(), this.getDirezioneLabel());
                    if (results != null && results.size() > 0) {
                        this.setVisualizzaComandiExport(true);
                    }
                    break block12;
                }
                List<ResDistribuzione> list = null;
                try {
                    list = this.statisticheGiornaliereService.findAllDistribuzionePersonalizzata();
                }
                catch (ServiceException e) {
                    MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
                if (tipoReport.equals((Object)TipoReport.PIE_CHART)) {
                    grafico = JsonStatsUtils.getJsonPieChartStatistichePersonalizzate(list, (StatsSearchForm)this.search, this.getSlice(), this.getCaption(), this.getSubCaption());
                } else if (tipoReport.equals((Object)TipoReport.BAR_CHART)) {
                    grafico = JsonStatsUtils.getJsonBarChartStatistichePersonalizzate(list, (StatsSearchForm)this.search, this.getDirezioneLabel(), this.getSlice(), this.getCaption(), this.getSubCaption());
                }
                if (list != null && list.size() > 0) {
                    this.setVisualizzaComandiExport(true);
                }
            }
            catch (Exception e) {
                DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            }
        }
        String json = grafico != null ? grafico.toString() : "";
        log.debug(json);
        return json;
    }

    @Override
    public String getData() {
        if (((StatsSearchForm)this.search).isUseGraficiSVG()) {
            return this.getJson();
        }
        return this.getXml();
    }

    public String getCaption() {
        String res = "";
        if (this.search != null && this.search.getStatisticaSelezionata() != null) {
            res = this.search.getStatisticaSelezionata().getLabel();
        }
        return StringEscapeUtils.escapeXml((String)res);
    }

    public String getSubCaption() {
        String captionText = StatsUtils.getSubCaption((StatsSearchForm)this.search);
        StringBuilder caption = new StringBuilder(captionText);
        if (this.search.getDataInizio() != null && this.search.getDataFine() != null) {
            if (this.btnLblPrefix(this.search).toLowerCase().contains("ora")) {
                caption.append(MessageFormat.format(" ( dal {0} al {1} )", this.formatDate(this.search.getDataInizio(), true), this.formatDate(this.search.getDataFine(), true)));
            } else {
                caption.append(MessageFormat.format(" ( dal {0} al {1} )", this.formatDate(this.search.getDataInizio(), false), this.formatDate(this.search.getDataFine(), false)));
            }
        }
        return StringEscapeUtils.escapeXml((String)caption.toString());
    }

    public void newSearch(ActionEvent ae) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Application app = facesContext.getApplication();
        ExpressionFactory elFactory = app.getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        ValueExpression valueExp = elFactory.createValueExpression(elContext, "#{statistichePersonalizzateBean}", StatsPersonalizzateBean.class);
        StatsPersonalizzateBean ab = new StatsPersonalizzateBean();
        valueExp.setValue(elContext, (Object)ab);
        ((StatistichePersonalizzateSearchForm)this.search).initSearchForm();
    }

    @Override
    public String submit() {
        return "statsPersonalizzate";
    }

    public String getSommaColumnHeader() {
        return StatsUtils.sommaColumnHeader((StatsSearchForm)this.search, "Messaggi");
    }

    public List<SelectItem> getValoriRisorse() {
        ArrayList<SelectItem> res = new ArrayList<SelectItem>();
        try {
            List<String> valRes = this.getValoriRisorseAsString();
            if (valRes != null && valRes.size() > 0) {
                for (String valore : valRes) {
                    res.add(new SelectItem((Object)valore, valore));
                }
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante la lettura dei valori risorse: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public List<String> getValoriRisorseAsString() throws ServiceException {
        if (this.search.getStatisticaSelezionata() != null) {
            List<String> valRes = this.statisticheGiornaliereService.getValoriRisorse();
            return valRes;
        }
        return null;
    }

    @Override
    public String esportaCsv() {
        try {
            return this._esportaCsv(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaCsv(HttpServletResponse response) throws Exception {
        this._esportaCsv(response, false);
    }

    private String _esportaCsv(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato CSV in corso....");
        String fileExt = ".csv";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = null;
            String headerLabel = null;
            TipoReport tipoReport = ((StatistichePersonalizzateSearchForm)this.search).getTipoReport();
            if (tipoReport.equals((Object)TipoReport.ANDAMENTO_TEMPORALE)) {
                headerLabel = "Data";
                Map<String, List<Res>> results = null;
                try {
                    results = this.statisticheGiornaliereService.findAllAndamentoTemporalePersonalizzato();
                    if (results == null || results.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                StatisticType modalitaTemporale = ((StatsSearchForm)this.search).getModalitaTemporale();
                report = ExportUtils.creaReportAndamentoTemporalePersonalizzato(results, titoloReport, log, tipoVisualizzazione, tipiBanda, tipiLatenza, modalitaTemporale, false);
                ExportUtils.esportaCsvAndamentoTemporalePersonalizzato((OutputStream)response.getOutputStream(), report, results, titoloReport, headerLabel, tipoVisualizzazione, tipiBanda, tipiLatenza);
            } else {
                List<ResDistribuzione> list = null;
                try {
                    list = this.statisticheGiornaliereService.findAllDistribuzionePersonalizzata();
                    if (list == null || list.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                headerLabel = "Nome";
                report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), false);
                ExportUtils.esportaCsv((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            }
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato CSV.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaXls() {
        try {
            return this._esportaXls(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaXls(HttpServletResponse response) throws Exception {
        this._esportaXls(response, false);
    }

    private String _esportaXls(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato XLS in corso....");
        String fileExt = ".xls";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = null;
            String headerLabel = null;
            TipoReport tipoReport = ((StatistichePersonalizzateSearchForm)this.search).getTipoReport();
            if (tipoReport.equals((Object)TipoReport.ANDAMENTO_TEMPORALE)) {
                headerLabel = "Data";
                Map<String, List<Res>> results = null;
                try {
                    results = this.statisticheGiornaliereService.findAllAndamentoTemporalePersonalizzato();
                    if (results == null || results.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                StatisticType modalitaTemporale = ((StatsSearchForm)this.search).getModalitaTemporale();
                report = ExportUtils.creaReportAndamentoTemporalePersonalizzato(results, titoloReport, log, tipoVisualizzazione, tipiBanda, tipiLatenza, modalitaTemporale, false);
                ExportUtils.esportaXlsAndamentoTemporalePersonalizzato((OutputStream)response.getOutputStream(), report, results, titoloReport, headerLabel, tipoVisualizzazione, tipiBanda, tipiLatenza);
            } else {
                List<ResDistribuzione> list = null;
                try {
                    list = this.statisticheGiornaliereService.findAllDistribuzionePersonalizzata();
                    if (list == null || list.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                headerLabel = "Nome";
                report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), false);
                ExportUtils.esportaXls((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            }
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato XLS.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaPdf() {
        try {
            return this._esportaPdf(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaPdf(HttpServletResponse response) throws Exception {
        this._esportaPdf(response, false);
    }

    private String _esportaPdf(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato PDF in corso....");
        String fileExt = ".pdf";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            String titoloReport = this.getCaption() + " " + this.getSubCaption();
            TipoVisualizzazione tipoVisualizzazione = ((StatsSearchForm)this.search).getTipoVisualizzazione();
            ArrayList<TipoBanda> tipiBanda = new ArrayList<TipoBanda>();
            tipiBanda.add(((StatsSearchForm)this.search).getTipoBanda());
            ArrayList<TipoLatenza> tipiLatenza = new ArrayList<TipoLatenza>();
            tipiLatenza.add(((StatsSearchForm)this.search).getTipoLatenza());
            JasperReportBuilder report = null;
            String headerLabel = null;
            TipoReport tipoReport = ((StatistichePersonalizzateSearchForm)this.search).getTipoReport();
            if (tipoReport.equals((Object)TipoReport.ANDAMENTO_TEMPORALE)) {
                headerLabel = "Data";
                Map<String, List<Res>> results = null;
                try {
                    results = this.statisticheGiornaliereService.findAllAndamentoTemporalePersonalizzato();
                    if (results == null || results.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                StatisticType modalitaTemporale = ((StatsSearchForm)this.search).getModalitaTemporale();
                report = ExportUtils.creaReportAndamentoTemporalePersonalizzato(results, titoloReport, log, tipoVisualizzazione, tipiBanda, tipiLatenza, modalitaTemporale, true);
                ExportUtils.esportaPdfAndamentoTemporalePersonalizzato((OutputStream)response.getOutputStream(), report, results, titoloReport, headerLabel, tipoVisualizzazione, tipiBanda, tipiLatenza);
            } else {
                List<ResDistribuzione> list = null;
                try {
                    list = this.statisticheGiornaliereService.findAllDistribuzionePersonalizzata();
                    if (list == null || list.size() <= 0) {
                        throw new NotFoundException("Dati non trovati");
                    }
                }
                catch (Exception e) {
                    DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
                    if (useFaceContext) {
                        MessageUtils.addErrorMsg((String)("Si e' verificato un errore durante il recupero dei dati:" + e.getMessage()));
                        return null;
                    }
                    throw e;
                }
                headerLabel = "Nome";
                report = ExportUtils.creaReportDistribuzione(list, titoloReport, log, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica(), true);
                ExportUtils.esportaPdf((OutputStream)response.getOutputStream(), report, titoloReport, headerLabel, tipoVisualizzazione, ((StatsSearchForm)this.search).getNumeroDimensioni(), ((StatsSearchForm)this.search).getNumeroDimensioniCustom(), tipiBanda, tipiLatenza, ((StatsSearchForm)this.search).getTipoStatistica());
            }
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato PDF.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaXml() {
        try {
            return this._esportaXml(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaXml(HttpServletResponse response) throws Exception {
        this._esportaXml(response, false);
    }

    private String _esportaXml(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato XML in corso....");
        String fileExt = ".xml";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            response.getOutputStream().write(this.getXml().getBytes());
            response.getOutputStream().flush();
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato XML.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String esportaJson() {
        try {
            return this._esportaJson(null, true);
        }
        catch (Exception e) {
            DynamicPdDBean.log.error(e.getMessage(), (Throwable)e);
            MessageUtils.addErrorMsg((String)("Si e' verificato un errore inatteso:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public void esportaJson(HttpServletResponse response) throws Exception {
        this._esportaJson(response, false);
    }

    private String _esportaJson(HttpServletResponse responseParam, boolean useFaceContext) throws Exception {
        log.debug("Export in formato JSON in corso....");
        String fileExt = ".json";
        String filename = this.getExportFilename() + fileExt;
        try {
            HttpServletResponse response = null;
            FacesContext context = null;
            if (useFaceContext) {
                context = FacesContext.getCurrentInstance();
                response = (HttpServletResponse)context.getExternalContext().getResponse();
            } else {
                response = responseParam;
            }
            response.reset();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)filename);
            response.setStatus(200);
            response.getOutputStream().write(this.getJson().getBytes());
            response.getOutputStream().flush();
            if (useFaceContext) {
                context.responseComplete();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (useFaceContext) {
                FacesContext.getCurrentInstance().responseComplete();
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante l'export in formato JSON.");
            }
            throw e;
        }
        return null;
    }

    @Override
    public String getExportFilename() {
        return "distribuzione_personalizzata";
    }

    public boolean isTimeoutEvent() {
        return ((IStatisticaPersonalizzataService)this.service).isTimeoutEvent();
    }
}

