/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.servlet;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoReport;
import org.openspcoop2.core.statistiche.constants.TipoStatistica;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.core.transazioni.constants.PddRuolo;
import org.openspcoop2.core.transazioni.utils.TipoCredenzialeMittente;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.transport.http.HttpServletCredential;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.CaseSensitiveMatch;
import org.openspcoop2.web.monitor.core.constants.TipoMatch;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.dao.DBLoginDAO;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.statistiche.bean.ConfigurazioniGeneraliSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.DimensioneCustom;
import org.openspcoop2.web.monitor.statistiche.bean.NumeroDimensioni;
import org.openspcoop2.web.monitor.statistiche.bean.StatistichePersonalizzateSearchForm;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.constants.CostantiExporter;
import org.openspcoop2.web.monitor.statistiche.dao.ConfigurazioniGeneraliService;
import org.openspcoop2.web.monitor.statistiche.dao.StatisticheGiornaliereService;
import org.openspcoop2.web.monitor.statistiche.mbean.AndamentoTemporaleBean;
import org.openspcoop2.web.monitor.statistiche.mbean.BaseStatsMBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerAzioneBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerErroriBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerSABean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerServizioBean;
import org.openspcoop2.web.monitor.statistiche.mbean.DistribuzionePerSoggettoBean;
import org.openspcoop2.web.monitor.statistiche.mbean.StatsPersonalizzateBean;
import org.openspcoop2.web.monitor.statistiche.servlet.ConfigurazioniExporter;
import org.openspcoop2.web.monitor.statistiche.servlet.ParameterUncorrectException;
import org.slf4j.Logger;

public class ReportExporter
extends HttpServlet {
    private static final long serialVersionUID = 1272767433184676700L;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private static boolean serviceEnabled = false;
    private static final String AUTENTICAZIONE_FALLITA = "Autenticazione fallita";
    private static final String SEND_ERROR = "sendError '";

    private static void logError(String msg) {
        ReportExporter.logError(msg, null);
    }

    private static void logError(String msg, Exception e) {
        if (log != null) {
            if (e != null) {
                log.error(msg, (Throwable)e);
            } else {
                log.error(msg);
            }
        }
    }

    private static void logDebug(String msg) {
        if (log != null) {
            log.debug(msg);
        }
    }

    public static void setServiceEnabled(boolean serviceEnabled) {
        ReportExporter.serviceEnabled = serviceEnabled;
    }

    public void init() throws ServletException {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            ReportExporter.setServiceEnabled(govwayMonitorProperties.isStatisticheAttivoServizioEsportazioneReport());
        }
        catch (Exception e) {
            ReportExporter.logError("Inizializzazione servlet fallita, setto enableHeaderInfo=false", e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest req, HttpServletResponse resp) {
        block22: {
            StringBuilder bfSource = new StringBuilder("");
            Object mittentePrefix = "";
            try {
                if (!serviceEnabled) {
                    resp.sendError(503, "Servizio non attivo");
                    return;
                }
                bfSource.append("remoteAddress: " + req.getRemoteAddr());
                String headerAddress = HttpUtilities.getClientAddress((HttpServletRequest)req);
                if (headerAddress != null) {
                    bfSource.append(", X-Forwarded-For: " + headerAddress);
                }
                HttpServletCredential identity = new HttpServletCredential(req, log);
                String username = identity.getUsername();
                String password = identity.getPassword();
                String principal = identity.getPrincipal();
                if (username == null && principal == null) {
                    username = req.getParameter("user");
                    password = req.getParameter("password");
                }
                if (username == null && password == null) {
                    ReportExporter.logError("Credenziali non fornita, mittente: " + bfSource.toString());
                    resp.sendError(401, "Autenticazione richiesta");
                    return;
                }
                mittentePrefix = "[mittente: " + bfSource.toString() + "] ";
                DBLoginDAO loginService = new DBLoginDAO();
                UserDetailsBean user = null;
                if (principal != null) {
                    try {
                        user = loginService.loadUserByUsername(principal);
                    }
                    catch (NotFoundException notFound) {
                        ReportExporter.logError((String)mittentePrefix + "Autenticazione fallita con il principal ottenuto [" + principal + "]: " + notFound.getMessage(), (Exception)((Object)notFound));
                        resp.sendError(403, AUTENTICAZIONE_FALLITA);
                        return;
                    }
                }
                boolean check = loginService.login(username, password);
                if (!check) {
                    ReportExporter.logError((String)mittentePrefix + "Autenticazione fallita con le credenziali fornite user[" + username + "] password[" + password + "]");
                    resp.sendError(403, AUTENTICAZIONE_FALLITA);
                    return;
                }
                try {
                    user = loginService.loadUserByUsername(username);
                }
                catch (NotFoundException notFound) {
                    ReportExporter.logError((String)mittentePrefix + "Autenticazione fallita con lo username [" + username + "]: " + notFound.getMessage(), (Exception)((Object)notFound));
                    resp.sendError(403, AUTENTICAZIONE_FALLITA);
                    return;
                }
                String r = this.getServletConfig().getInitParameter("resource");
                if ("config".equals(r)) {
                    ConfigurazioniGeneraliService service = new ConfigurazioniGeneraliService();
                    ReportExporter.generaConfigurazione(req, resp, user, service);
                    ReportExporter.logDebug((String)mittentePrefix + "richiesta report configurazione completata");
                    break block22;
                }
                if ("stat".equals(r)) {
                    StatisticheGiornaliereService service = new StatisticheGiornaliereService();
                    ReportExporter.generaStatistiche(req, resp, user, service);
                    ReportExporter.logDebug((String)mittentePrefix + "richiesta report statistica completata");
                    break block22;
                }
                throw new CoreException("InitParameter 'resource' with unknown resource [" + r + "]");
            }
            catch (ParameterUncorrectException e) {
                ReportExporter.logError((String)mittentePrefix + e.getMessage(), e);
                try {
                    resp.sendError(404, e.getMessage());
                }
                catch (Exception t) {
                    ReportExporter.logError((String)mittentePrefix + "sendError '404' " + e.getMessage(), e);
                }
            }
            catch (NotFoundException e) {
                ReportExporter.logError((String)mittentePrefix + e.getMessage(), (Exception)((Object)e));
                try {
                    resp.sendError(404, e.getMessage());
                }
                catch (Exception t) {
                    ReportExporter.logError((String)mittentePrefix + "sendError '404' " + e.getMessage(), (Exception)((Object)e));
                }
            }
            catch (Exception e) {
                ReportExporter.logError((String)mittentePrefix + e.getMessage(), e);
                try {
                    resp.sendError(503, e.getMessage());
                }
                catch (Exception t) {
                    ReportExporter.logError((String)mittentePrefix + "sendError '503' " + e.getMessage(), e);
                }
            }
        }
    }

    public static void generaConfigurazione(HttpServletRequest req, HttpServletResponse resp, UserDetailsBean user, ConfigurazioniGeneraliService service) throws Exception {
        try {
            String tipologiaTransazione;
            String servizio;
            String soggettoLocale;
            ConfigurazioniGeneraliSearchForm searchForm = new ConfigurazioniGeneraliSearchForm();
            searchForm.setUser(user.getUtente());
            service.setSearch(searchForm);
            searchForm.setTipologiaRicerca("ingresso");
            String protocollo = req.getParameter("protocollo");
            if (protocollo != null) {
                protocollo = protocollo.trim();
                try {
                    ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                }
                catch (Exception e) {
                    throw new ParameterUncorrectException("Parametro 'protocollo' fornito possiede un valore '" + protocollo + "' sconosciuto. I tipi supportati sono: " + ProtocolFactoryManager.getInstance().getProtocolNames());
                }
                searchForm.setProtocollo(protocollo);
            }
            if ((soggettoLocale = req.getParameter("soggettoLocale")) != null) {
                soggettoLocale = soggettoLocale.trim();
                searchForm.setTipoNomeSoggettoLocale(soggettoLocale);
            }
            if ((servizio = req.getParameter("servizio")) != null) {
                servizio = servizio.trim();
                searchForm.setNomeServizio(servizio);
            }
            if ((tipologiaTransazione = req.getParameter("tipologia")) != null) {
                tipologiaTransazione = tipologiaTransazione.trim();
                ArrayList<String> l = new ArrayList<String>();
                l.add("Erogazione");
                l.add("Fruizione");
                if (!l.contains(tipologiaTransazione)) {
                    throw new ParameterUncorrectException("Parametro 'tipologia' fornito possiede un valore '" + tipologiaTransazione + "' sconosciuto. I tipi supportati sono: " + l);
                }
            } else {
                throw new ParameterUncorrectException("Parametro obbligatorio 'tipologia' non fornito");
            }
            if ("Erogazione".equals(tipologiaTransazione)) {
                searchForm.setTipologiaRicerca("ingresso");
                searchForm.setTipologiaTransazioni(PddRuolo.APPLICATIVA);
            } else if ("Fruizione".equals(tipologiaTransazione)) {
                searchForm.setTipologiaRicerca("uscita");
                searchForm.setTipologiaTransazioni(PddRuolo.DELEGATA);
            }
            searchForm.saveProtocollo();
            String formatoExport = req.getParameter("formatoConfigurazione");
            if (formatoExport == null) {
                throw new ParameterUncorrectException("Parametro obbligatorio 'formatoConfigurazione' non fornito");
            }
            formatoExport = formatoExport.trim();
            if (!CostantiExporter.getTipiFormatoConfigurazione().contains(formatoExport)) {
                throw new ParameterUncorrectException("Parametro 'formatoConfigurazione' fornito possiede un valore '" + formatoExport + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiFormatoConfigurazione());
            }
            StringBuffer bf = new StringBuffer();
            ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)searchForm, ToStringStyle.MULTI_LINE_STYLE, bf, null, false, false);
            builder.toString();
            ReportExporter.logDebug("Lettura parametri completata, search form: " + bf.toString());
            ConfigurazioniExporter.export(req, resp, true, service, null, searchForm.getTipologiaTransazioni(), formatoExport);
        }
        catch (Exception e) {
            ReportExporter.logError(e.getMessage(), e);
            throw e;
        }
    }

    public static void generaStatistiche(HttpServletRequest req, HttpServletResponse resp, UserDetailsBean user, StatisticheGiornaliereService service) throws Exception {
        try {
            String tipoDistribuzioneReport = req.getParameter("distribuzione");
            if (tipoDistribuzioneReport == null) {
                throw new ParameterUncorrectException("Parametro obbligatorio 'distribuzione' non fornito");
            }
            tipoDistribuzioneReport = tipoDistribuzioneReport.trim();
            if (!CostantiExporter.getTipiDistribuzione().contains(tipoDistribuzioneReport)) {
                throw new ParameterUncorrectException("Parametro 'distribuzione' fornito possiede un valore '" + tipoDistribuzioneReport + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiDistribuzione());
            }
            String tipoFormato = req.getParameter("formato");
            if (tipoFormato == null) {
                throw new ParameterUncorrectException("Parametro obbligatorio 'formato' non fornito");
            }
            tipoFormato = tipoFormato.trim();
            if (!CostantiExporter.getTipiFormato().contains(tipoFormato)) {
                throw new ParameterUncorrectException("Parametro 'formato' fornito possiede un valore '" + tipoFormato + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiFormato());
            }
            String identificazioneApplicativo = null;
            if ("applicativo".equals(tipoDistribuzioneReport)) {
                String tipoIdentificazioneApplicativo = req.getParameter("tipo_identificazione_applicativo");
                if (tipoIdentificazioneApplicativo == null) {
                    throw new ParameterUncorrectException("Parametro obbligatorio 'tipo_identificazione_applicativo' non fornito");
                }
                tipoIdentificazioneApplicativo = tipoIdentificazioneApplicativo.trim();
                if (!CostantiExporter.getTipiIdentificazioneApplicativo().contains(tipoIdentificazioneApplicativo)) {
                    throw new ParameterUncorrectException("Parametro 'tipo_identificazione_applicativo' fornito possiede un valore '" + tipoIdentificazioneApplicativo + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiIdentificazioneApplicativo());
                }
                if ("trasporto".equals(tipoIdentificazioneApplicativo)) {
                    identificazioneApplicativo = "commons.identificazione.trasporto.label";
                } else if ("token".equals(tipoIdentificazioneApplicativo)) {
                    identificazioneApplicativo = "commons.identificazione.token.label";
                }
            }
            TipoCredenzialeMittente tokenClaim = null;
            if ("token_info".equals(tipoDistribuzioneReport)) {
                String claim = req.getParameter("claim");
                if (claim == null) {
                    throw new ParameterUncorrectException("Parametro obbligatorio 'claim' non fornito");
                }
                claim = claim.trim();
                if (!CostantiExporter.getClaims().contains(claim)) {
                    throw new ParameterUncorrectException("Parametro 'claim' fornito possiede un valore '" + claim + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getClaims());
                }
                if ("issuer".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.TOKEN_ISSUER;
                } else if ("subject".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.TOKEN_SUBJECT;
                } else if ("username".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.TOKEN_USERNAME;
                } else if ("clientId".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.TOKEN_CLIENT_ID;
                } else if ("eMail".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.TOKEN_EMAIL;
                } else if ("pdndOrganizationName".equals(claim)) {
                    tokenClaim = TipoCredenzialeMittente.PDND_ORGANIZATION_NAME;
                }
            }
            StatsSearchForm statSearchForm = null;
            statSearchForm = "personalizzata".equals(tipoDistribuzioneReport) ? new StatistichePersonalizzateSearchForm() : new StatsSearchForm();
            statSearchForm.setUser(user.getUtente());
            statSearchForm.setUsaSVG(true);
            statSearchForm.setUseGraficiSVG(true);
            statSearchForm.setAction(tipoDistribuzioneReport);
            String protocollo = ReportExporter.setProtocolParametersInSearchForm(req, statSearchForm);
            if (protocollo != null) {
                // empty if block
            }
            ReportExporter.logDebug("Inizializzazione bean [" + tipoDistribuzioneReport + "] in corso ...");
            BaseStatsMBean bean = null;
            if ("temporale".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.ANDAMENTO_TEMPORALE);
                statSearchForm.setAndamentoTemporalePerEsiti(false);
                service.setAndamentoTemporaleSearch(statSearchForm);
                bean = new AndamentoTemporaleBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((AndamentoTemporaleBean)bean).setStatisticheGiornaliereService(service);
                bean.setSearch(statSearchForm);
                ((AndamentoTemporaleBean)bean).initSearchListenerAndamentoTemporale(null);
            } else if ("esiti".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.ANDAMENTO_TEMPORALE);
                statSearchForm.setAndamentoTemporalePerEsiti(true);
                service.setAndamentoTemporaleSearch(statSearchForm);
                bean = new AndamentoTemporaleBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((AndamentoTemporaleBean)bean).setStatisticheGiornaliereService(service);
                bean.setSearch(statSearchForm);
                ((AndamentoTemporaleBean)bean).initSearchListenerDistribuzionePerEsiti(null);
            } else if ("errori".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_ERRORI);
                service.setDistribErroriSearch(statSearchForm);
                bean = new DistribuzionePerErroriBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerErroriBean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerErroriBean)bean).setSearch(statSearchForm);
                ((DistribuzionePerErroriBean)bean).getSearch().initSearchListener(null);
            } else if ("soggetto_remoto".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SOGGETTO);
                statSearchForm.setDistribuzionePerSoggettoRemota(true);
                service.setDistribSoggettoSearch(statSearchForm);
                bean = new DistribuzionePerSoggettoBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSoggettoBean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSoggettoBean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSoggettoBean)bean).initSearchListenerRemoto(null);
            } else if ("soggetto_locale".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SOGGETTO);
                statSearchForm.setDistribuzionePerSoggettoRemota(false);
                service.setDistribSoggettoSearch(statSearchForm);
                bean = new DistribuzionePerSoggettoBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSoggettoBean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSoggettoBean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSoggettoBean)bean).initSearchListenerLocale(null);
            } else if ("servizio".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SERVIZIO);
                service.setDistribServizioSearch(statSearchForm);
                bean = new DistribuzionePerServizioBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerServizioBean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerServizioBean)bean).setSearch(statSearchForm);
                ((DistribuzionePerServizioBean)bean).getSearch().initSearchListener(null);
            } else if ("azione".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_AZIONE);
                service.setDistribAzioneSearch(statSearchForm);
                bean = new DistribuzionePerAzioneBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerAzioneBean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerAzioneBean)bean).setSearch(statSearchForm);
                ((DistribuzionePerAzioneBean)bean).getSearch().initSearchListener(null);
            } else if ("applicativo".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO);
                statSearchForm.setRiconoscimento("applicativo");
                statSearchForm.setIdentificazione(identificazioneApplicativo);
                service.setDistribSaSearch(statSearchForm);
                bean = new DistribuzionePerSABean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSABean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSABean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSABean)bean).getSearch().initSearchListener(null);
                statSearchForm.setRiconoscimento("applicativo");
                statSearchForm.setIdentificazione(identificazioneApplicativo);
            } else if ("identificativo_autenticato".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO);
                statSearchForm.setRiconoscimento("identificativoAutenticato");
                service.setDistribSaSearch(statSearchForm);
                bean = new DistribuzionePerSABean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSABean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSABean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSABean)bean).getSearch().initSearchListener(null);
                statSearchForm.setRiconoscimento("identificativoAutenticato");
            } else if ("indirizzo_ip".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO);
                statSearchForm.setRiconoscimento("ip");
                service.setDistribSaSearch(statSearchForm);
                bean = new DistribuzionePerSABean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSABean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSABean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSABean)bean).getSearch().initSearchListener(null);
                statSearchForm.setRiconoscimento("ip");
            } else if ("token_info".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.DISTRIBUZIONE_SERVIZIO_APPLICATIVO);
                statSearchForm.setRiconoscimento("tokenInfo");
                statSearchForm.setTokenClaim(tokenClaim.getRawValue());
                service.setDistribSaSearch(statSearchForm);
                bean = new DistribuzionePerSABean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((DistribuzionePerSABean)bean).setStatisticheGiornaliereService(service);
                ((DistribuzionePerSABean)bean).setSearch(statSearchForm);
                ((DistribuzionePerSABean)bean).getSearch().initSearchListener(null);
                statSearchForm.setRiconoscimento("tokenInfo");
                statSearchForm.setTokenClaim(tokenClaim.getRawValue());
            } else if ("personalizzata".equals(tipoDistribuzioneReport)) {
                statSearchForm.setTipoStatistica(TipoStatistica.STATISTICA_PERSONALIZZATA);
                service.setStatistichePersonalizzateSearch((StatistichePersonalizzateSearchForm)statSearchForm);
                bean = new StatsPersonalizzateBean(service.getUtilsServiceManager(), service.getPluginsServiceManager(), service.getDriverRegistroServiziDB(), service.getDriverConfigurazioneDB());
                ((StatsPersonalizzateBean)bean).setStatisticheGiornaliereService(service);
                ((StatsPersonalizzateBean)bean).setSearch(statSearchForm);
                ((StatsPersonalizzateBean)bean).getSearch().initSearchListener(null);
            }
            ReportExporter.logDebug("Inizializzazione bean [" + tipoDistribuzioneReport + "] completata");
            ReportExporter.logDebug("Imposto parametri di ricerca nel search form ...");
            protocollo = ReportExporter.setProtocolParametersInSearchForm(req, statSearchForm);
            ReportExporter.setParametersInSearchForm(req, statSearchForm, protocollo);
            StringBuffer bf = new StringBuffer();
            ReflectionToStringBuilder builder = new ReflectionToStringBuilder((Object)statSearchForm, ToStringStyle.MULTI_LINE_STYLE, bf, null, false, false);
            builder.toString();
            ReportExporter.logDebug("Lettura parametri completata, search form: " + bf.toString());
            ReportExporter.logDebug("Esportazione[" + tipoFormato + "] tramite bean [" + tipoDistribuzioneReport + "] in corso ...");
            if ("csv".equals(tipoFormato)) {
                bean.esportaCsv(resp);
            } else if ("xls".equals(tipoFormato)) {
                bean.esportaXls(resp);
            } else if ("pdf".equals(tipoFormato)) {
                bean.esportaPdf(resp);
            } else if ("xml".equals(tipoFormato)) {
                bean.esportaXml(resp);
            } else if ("json".equals(tipoFormato)) {
                bean.esportaJson(resp);
            }
            ReportExporter.logDebug("Esportazione[" + tipoFormato + "] tramite bean [" + tipoDistribuzioneReport + "] completata");
        }
        catch (Exception e) {
            ReportExporter.logError(e.getMessage(), e);
            throw e;
        }
    }

    private static String setProtocolParametersInSearchForm(HttpServletRequest req, StatsSearchForm statSearchForm) throws Exception {
        String protocollo = req.getParameter("protocollo");
        if (protocollo != null) {
            protocollo = protocollo.trim();
            try {
                ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            }
            catch (Exception e) {
                throw new ParameterUncorrectException("Parametro 'protocollo' fornito possiede un valore '" + protocollo + "' sconosciuto. I tipi supportati sono: " + ProtocolFactoryManager.getInstance().getProtocolNames());
            }
        } else {
            throw new ParameterUncorrectException("Parametro obbligatorio 'protocollo' non fornito");
        }
        statSearchForm.setProtocollo(protocollo);
        String soggettoLocale = req.getParameter("soggettoLocale");
        if (soggettoLocale != null) {
            soggettoLocale = soggettoLocale.trim();
            statSearchForm.setTipoNomeSoggettoLocale(soggettoLocale);
        }
        statSearchForm.saveProtocollo();
        return protocollo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setParametersInSearchForm(HttpServletRequest req, StatsSearchForm statSearchForm, String protocollo) throws ParameterUncorrectException, RegExpException, RegExpNotValidException, RegExpNotFoundException, ProtocolException {
        int i;
        String[] tmp;
        String esito;
        String escludiRichiesteScartate;
        String tipoRicercaMittente;
        String azione;
        String servizio;
        String apiDistinguiImplementazione;
        String api;
        String gruppo;
        String trafficoPerSoggetto;
        String destinatario;
        String mittente;
        String dataInizio = req.getParameter("dataInizio");
        if (dataInizio == null) {
            throw new ParameterUncorrectException("Parametro obbligatorio 'dataInizio' non fornito");
        }
        dataInizio = dataInizio.trim();
        Date dInizio = null;
        try {
            SimpleDateFormat sdf;
            if (dataInizio.contains(":")) {
                sdf = DateUtils.getSimpleDateFormatMs();
                dInizio = sdf.parse(dataInizio);
            } else {
                sdf = DateUtils.getSimpleDateFormatDay();
                dInizio = sdf.parse(dataInizio);
                Calendar c = DateManager.getCalendar();
                c.setTime(dInizio);
                c.set(11, 0);
                c.set(12, 0);
                c.set(13, 0);
                c.set(14, 0);
                dInizio = c.getTime();
            }
        }
        catch (Exception e) {
            throw new ParameterUncorrectException("Parametro 'dataInizio' fornito possiede un valore '" + dataInizio + "' non valido. I formati supportati sono 'yyyy-MM-dd_HH:mm:ss.SSS' o 'yyyy-MM-dd'. Errore rilevato: " + e.getMessage(), e);
        }
        String dataFine = req.getParameter("dataFine");
        if (dataFine == null) {
            throw new ParameterUncorrectException("Parametro obbligatorio 'dataFine' non fornito");
        }
        dataFine = dataFine.trim();
        Date dFine = null;
        try {
            SimpleDateFormat sdf;
            if (dataFine.contains(":")) {
                sdf = DateUtils.getSimpleDateFormatMs();
                dFine = sdf.parse(dataFine);
            } else {
                sdf = DateUtils.getSimpleDateFormatDay();
                dFine = sdf.parse(dataFine);
                Calendar c = DateManager.getCalendar();
                c.setTime(dFine);
                c.set(11, 23);
                c.set(12, 59);
                c.set(13, 59);
                c.set(14, 999);
                dFine = c.getTime();
            }
        }
        catch (Exception e) {
            throw new ParameterUncorrectException("Parametro 'dataFine' fornito possiede un valore '" + dataFine + "' non valido. I formati supportati sono 'yyyy-MM-dd_HH:mm:ss.SSS' o 'yyyy-MM-dd'. Errore rilevato: " + e.getMessage(), e);
        }
        statSearchForm.setDataInizio(dInizio);
        statSearchForm.setDataFine(dFine);
        String tipologiaTransazione = req.getParameter("tipologia");
        if (tipologiaTransazione != null) {
            tipologiaTransazione = tipologiaTransazione.trim();
            if (!CostantiExporter.getTipologie().contains(tipologiaTransazione)) {
                throw new ParameterUncorrectException("Parametro 'tipologia' fornito possiede un valore '" + tipologiaTransazione + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipologie());
            }
        } else {
            tipologiaTransazione = "Erogazione/Fruizione";
        }
        if ("Erogazione/Fruizione".equals(tipologiaTransazione)) {
            statSearchForm.setTipologiaRicerca("all");
        } else if ("Erogazione".equals(tipologiaTransazione)) {
            statSearchForm.setTipologiaRicerca("ingresso");
        } else if ("Fruizione".equals(tipologiaTransazione)) {
            statSearchForm.setTipologiaRicerca("uscita");
        }
        String idCluster = req.getParameter("idCluster");
        if (idCluster != null) {
            idCluster = idCluster.trim();
            statSearchForm.setClusterId(idCluster);
        }
        if ((mittente = req.getParameter("mittente")) != null) {
            mittente = mittente.trim();
            statSearchForm.setTipoNomeMittente(mittente);
        }
        if ((destinatario = req.getParameter("destinatario")) != null) {
            destinatario = destinatario.trim();
            statSearchForm.setTipoNomeDestinatario(destinatario);
        }
        if ((trafficoPerSoggetto = req.getParameter("trafficoPerSoggetto")) != null) {
            trafficoPerSoggetto = trafficoPerSoggetto.trim();
            statSearchForm.setTipoNomeTrafficoPerSoggetto(trafficoPerSoggetto);
        }
        if ((gruppo = req.getParameter("tag")) != null) {
            gruppo = gruppo.trim();
            statSearchForm.setGruppo(gruppo);
        }
        if ((api = req.getParameter("api")) != null) {
            String pattern;
            if (!RegularExpressionEngine.isMatch((String)(api = api.trim()), (String)(pattern = "^[a-z]{2,20}/[0-9A-Za-z]+:[_A-Za-z][\\-\\._A-Za-z0-9]*:\\d$"))) {
                throw new ParameterUncorrectException("Parametro 'api' fornito possiede un valore '" + api + "' che non rispetta il formato atteso '" + pattern + "'");
            }
            statSearchForm.setApi(api);
        }
        if ((apiDistinguiImplementazione = req.getParameter("api_distingui_implementazione")) != null) {
            if ("true".equalsIgnoreCase(apiDistinguiImplementazione = apiDistinguiImplementazione.trim())) {
                statSearchForm.setDistribuzionePerImplementazioneApi(true);
            } else {
                if (!"false".equalsIgnoreCase(apiDistinguiImplementazione)) throw new ParameterUncorrectException("Parametro 'api_distingui_implementazione' contiene un valore non atteso '" + apiDistinguiImplementazione + "' (atteso: true/false)");
                statSearchForm.setDistribuzionePerImplementazioneApi(false);
            }
        }
        if ((servizio = req.getParameter("servizio")) != null) {
            servizio = servizio.trim();
            statSearchForm.setNomeServizio(servizio);
        }
        if ((azione = req.getParameter("azione")) != null) {
            azione = azione.trim();
            statSearchForm.setNomeAzione(azione);
        }
        if ((tipoRicercaMittente = req.getParameter("tipoRicercaMittente")) != null) {
            tipoRicercaMittente = tipoRicercaMittente.trim();
            if (!CostantiExporter.getTipiRicercaMittente().contains(tipoRicercaMittente)) {
                throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' fornito possiede un valore '" + tipoRicercaMittente + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiRicercaMittente());
            }
            statSearchForm.setRiconoscimento(tipoRicercaMittente);
            if ("soggetto".equals(tipoRicercaMittente)) {
                if (mittente == null || "".equals(mittente)) {
                    throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'mittente'");
                }
            } else if ("applicativo".equals(tipoRicercaMittente)) {
                String tipoIdentificazioneApplicativo;
                if ("Erogazione".equals(tipologiaTransazione)) {
                    if (mittente == null || "".equals(mittente)) {
                        throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'mittente'");
                    }
                } else {
                    String soggettoLocale = req.getParameter("soggettoLocale");
                    if (soggettoLocale == null || "".equals(soggettoLocale)) {
                        throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'soggettoLocale'");
                    }
                }
                if ((tipoIdentificazioneApplicativo = req.getParameter("tipo_identificazione_applicativo")) == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'tipo_identificazione_applicativo'");
                tipoIdentificazioneApplicativo = tipoIdentificazioneApplicativo.trim();
                if (!CostantiExporter.getTipiIdentificazioneApplicativo().contains(tipoIdentificazioneApplicativo)) {
                    throw new ParameterUncorrectException("Parametro 'tipo_identificazione_applicativo' fornito possiede un valore '" + tipoIdentificazioneApplicativo + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiIdentificazioneApplicativo());
                }
                if ("trasporto".equals(tipoIdentificazioneApplicativo)) {
                    statSearchForm.setIdentificazione("commons.identificazione.trasporto.label");
                } else if ("token".equals(tipoIdentificazioneApplicativo)) {
                    statSearchForm.setIdentificazione("commons.identificazione.token.label");
                }
                String applicativo = req.getParameter("applicativo");
                if (applicativo == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'applicativo'");
                applicativo = applicativo.trim();
                statSearchForm.setServizioApplicativo(applicativo);
            } else if ("identificativoAutenticato".equals(tipoRicercaMittente) || "tokenInfo".equals(tipoRicercaMittente) || "ip".equals(tipoRicercaMittente)) {
                if ("identificativoAutenticato".equals(tipoRicercaMittente)) {
                    String tipoAutenticazione = req.getParameter("tipoAutenticazioneRicercaMittente");
                    if (tipoAutenticazione == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'tipoAutenticazioneRicercaMittente'");
                    tipoAutenticazione = tipoAutenticazione.trim();
                    if (!CostantiExporter.getTipiAutenticazione().contains(tipoAutenticazione)) {
                        throw new ParameterUncorrectException("Parametro 'tipoAutenticazioneRicercaMittente' fornito possiede un valore '" + tipoAutenticazione + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiAutenticazione());
                    }
                    statSearchForm.setAutenticazione(tipoAutenticazione);
                } else if ("ip".equals(tipoRicercaMittente)) {
                    String tipoIndirizzoIP = req.getParameter("tipoIndirizzoIP");
                    if (tipoIndirizzoIP == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'tipoAutenticazioneRicercaMittente'");
                    tipoIndirizzoIP = tipoIndirizzoIP.trim();
                    if (!CostantiExporter.getTipiIndirizzoIp().contains(tipoIndirizzoIP)) {
                        throw new ParameterUncorrectException("Parametro 'tipoIndirizzoIP' fornito possiede un valore '" + tipoIndirizzoIP + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getTipiIndirizzoIp());
                    }
                    statSearchForm.setClientAddressMode(tipoIndirizzoIP);
                } else {
                    String tipoClaim = req.getParameter("claimRicercaMittente");
                    if (tipoClaim == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'claimRicercaMittente'");
                    tipoClaim = tipoClaim.trim();
                    if (!CostantiExporter.getClaims().contains(tipoClaim)) {
                        throw new ParameterUncorrectException("Parametro 'claimRicercaMittente' fornito possiede un valore '" + tipoClaim + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getClaims());
                    }
                    TipoCredenzialeMittente tokenClaim = null;
                    if ("issuer".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.TOKEN_ISSUER;
                    } else if ("subject".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.TOKEN_SUBJECT;
                    } else if ("username".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.TOKEN_USERNAME;
                    } else if ("clientId".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.TOKEN_CLIENT_ID;
                    } else if ("eMail".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.TOKEN_EMAIL;
                    } else if ("pdndOrganizationName".equals(tipoClaim)) {
                        tokenClaim = TipoCredenzialeMittente.PDND_ORGANIZATION_NAME;
                    } else {
                        TipoCredenzialeMittente[] values = TipoCredenzialeMittente.values();
                        StringBuilder sb = new StringBuilder();
                        if (values == null || values.length <= 0) throw new ParameterUncorrectException("Parametro 'claimRicercaMittente' fornito possiede un valore '" + tipoClaim + "' sconosciuto. I tipi supportati sono: " + sb.toString());
                        for (TipoCredenzialeMittente tipoCredenzialeMittente : values) {
                            if (sb.length() > 0) {
                                sb.append(",");
                            }
                            sb.append(tipoCredenzialeMittente);
                        }
                        throw new ParameterUncorrectException("Parametro 'claimRicercaMittente' fornito possiede un valore '" + tipoClaim + "' sconosciuto. I tipi supportati sono: " + sb.toString());
                    }
                    statSearchForm.setTokenClaim(tokenClaim.getRawValue());
                }
                String tipoMatch = req.getParameter("ricercaMittenteEsatta");
                TipoMatch tipoMatchEnum = TipoMatch.EQUALS;
                if (tipoMatch != null) {
                    if ("true".equalsIgnoreCase(tipoMatch = tipoMatch.trim())) {
                        tipoMatchEnum = TipoMatch.EQUALS;
                    } else {
                        if (!"false".equalsIgnoreCase(tipoMatch)) throw new ParameterUncorrectException("Parametro 'ricercaMittenteEsatta' contiene un valore non atteso '" + tipoMatch + "' (atteso: true/false)");
                        tipoMatchEnum = TipoMatch.LIKE;
                    }
                }
                statSearchForm.setMittenteMatchingType(tipoMatchEnum.name());
                String tipoCaseSensitive = req.getParameter("ricercaMittenteCaseSensitive");
                CaseSensitiveMatch tipoCaseSensitiveEnum = CaseSensitiveMatch.SENSITIVE;
                if (tipoCaseSensitive != null) {
                    if ("true".equalsIgnoreCase(tipoCaseSensitive = tipoCaseSensitive.trim())) {
                        tipoCaseSensitiveEnum = CaseSensitiveMatch.SENSITIVE;
                    } else {
                        if (!"false".equalsIgnoreCase(tipoCaseSensitive)) throw new ParameterUncorrectException("Parametro 'ricercaMittenteCaseSensitive' contiene un valore non atteso '" + tipoCaseSensitive + "' (atteso: true/false)");
                        tipoCaseSensitiveEnum = CaseSensitiveMatch.INSENSITIVE;
                    }
                }
                statSearchForm.setMittenteCaseSensitiveType(tipoCaseSensitiveEnum.name());
                String identificativoRicercato = req.getParameter("identificativoRicercaMittente");
                if (identificativoRicercato == null) throw new ParameterUncorrectException("Parametro 'tipoRicercaMittente' valorizzato con '" + tipoRicercaMittente + "' richiede la definizione del parametro 'identificativoRicercaMittente'");
                identificativoRicercato = identificativoRicercato.trim();
                statSearchForm.setValoreRiconoscimento(identificativoRicercato);
            }
        }
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)protocollo);
        statSearchForm.setEsitoGruppo(EsitoUtils.ALL_VALUE);
        statSearchForm.setEsitoDettaglio(EsitoUtils.ALL_VALUE);
        statSearchForm.setEscludiRichiesteScartate(true);
        String esitoGruppo = req.getParameter("esitoGruppo");
        if (esitoGruppo != null) {
            esitoGruppo = esitoGruppo.trim();
            if (!CostantiExporter.getEsitiGruppo().contains(esitoGruppo)) {
                throw new ParameterUncorrectException("Parametro 'esitoGruppo' fornito possiede un valore '" + esitoGruppo + "' sconosciuto. I tipi supportati sono: " + CostantiExporter.getEsitiGruppo());
            }
            if ("ok".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_OK_VALUE);
            } else if ("fault".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_FAULT_APPLICATIVO_VALUE);
            } else if ("fallite".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_ERROR_VALUE);
            } else if ("fallite_e_fault".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_ERROR_FAULT_APPLICATIVO_VALUE);
            } else if ("errori_consegna".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_ERROR_CONSEGNA_VALUE);
            } else if ("richieste_scartate".equals(esitoGruppo)) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_ERROR_RICHIESTE_SCARTATE_VALUE);
            }
        }
        if ((escludiRichiesteScartate = req.getParameter("escludiRichiesteScartate")) != null) {
            if (!"false".equals(escludiRichiesteScartate = escludiRichiesteScartate.trim()) && !"true".equals(escludiRichiesteScartate)) {
                throw new ParameterUncorrectException("Parametro 'escludiRichiesteScartate' fornito possiede un valore '" + escludiRichiesteScartate + "' non valido. Atteso true/false");
            }
            statSearchForm.setEscludiRichiesteScartate(Boolean.valueOf(escludiRichiesteScartate));
        }
        if ((esito = req.getParameter("esito")) != null) {
            esito = esito.trim();
            String[] split = null;
            Integer[] esiti = null;
            split = esito.contains(",") ? esito.split(",") : new String[]{esito};
            esiti = new Integer[split.length];
            for (int i2 = 0; i2 < split.length; ++i2) {
                int intValueEsito;
                split[i2] = split[i2].trim();
                try {
                    intValueEsito = Integer.parseInt(split[i2]);
                }
                catch (Exception e) {
                    throw new ParameterUncorrectException("Parametro 'esito' fornito possiede un valore '" + split[i2] + "' non corretto: " + e.getMessage(), e);
                }
                if (!esitiProperties.existsEsitoCode(Integer.valueOf(intValueEsito))) {
                    throw new ParameterUncorrectException("Parametro 'esito' fornito possiede un valore '" + split[i2] + "' sconosciuto. I valori supportati sono: " + esitiProperties.getEsitiCode());
                }
                esiti[i2] = intValueEsito;
            }
            if (esiti.length > 1) {
                statSearchForm.setEsitoGruppo(EsitoUtils.ALL_PERSONALIZZATO_VALUE);
                statSearchForm.setEsitoDettaglioPersonalizzato(esiti);
            } else {
                statSearchForm.setEsitoDettaglio(esiti[0]);
            }
        }
        String esitoContesto = esitiProperties.getEsitoTransactionContextDefault();
        String esitoContestoTmp = req.getParameter("contesto");
        if (esitoContestoTmp != null) {
            esitoContestoTmp = esitoContestoTmp.trim();
            if (!esitiProperties.getEsitiTransactionContextCode().contains(esitoContestoTmp)) {
                throw new ParameterUncorrectException("Parametro 'contesto' fornito possiede un valore '" + esitoContestoTmp + "' sconosciuto. I tipi supportati sono: " + esitiProperties.getEsitiTransactionContextCode());
            }
            esitoContesto = esitoContestoTmp;
        }
        if (esitoContesto != null) {
            statSearchForm.setEsitoContesto(esitoContesto);
        }
        TipoReport tipoReportEnum = CostantiExporter.TIPO_REPORT_DISTRIBUZIONE_OTHER_DEFAULT;
        if ("temporale".equals(statSearchForm.getAction())) {
            tipoReportEnum = CostantiExporter.TIPO_REPORT_DISTRIBUZIONE_TEMPORALE_DEFAULT;
        }
        statSearchForm.setTipoReport(tipoReportEnum);
        StatisticType modalitaTemporaleEnum = StatisticType.GIORNALIERA;
        String modalitaTemporale = req.getParameter("unitaTemporale");
        if (modalitaTemporale != null && (modalitaTemporaleEnum = StatisticType.valueOf((String)(modalitaTemporale = modalitaTemporale.trim()).toUpperCase())) == null) {
            ArrayList<String> types = new ArrayList<String>();
            for (StatisticType type : StatisticType.values()) {
                types.add(type.name().toLowerCase());
            }
            throw new ParameterUncorrectException("Parametro 'unitaTemporale' fornito possiede un valore '" + modalitaTemporaleEnum + "' sconosciuto. I tipi supportati sono: " + types);
        }
        statSearchForm.setModalitaTemporale(modalitaTemporaleEnum);
        String tipoVisualizzazione = req.getParameter("visualizza");
        TipoVisualizzazione tipoVisualizzazioneEnum = CostantiExporter.TIPO_INFORMAZIONE_VISUALIZZATA_DEFAULT;
        if (tipoVisualizzazione != null && (tipoVisualizzazioneEnum = TipoVisualizzazione.toEnumConstant((String)(tipoVisualizzazione = tipoVisualizzazione.trim()))) == null) {
            String[] values = TipoVisualizzazione.toArray();
            StringBuilder sb = ReportExporter.getAsStringBuilder(values);
            throw new ParameterUncorrectException("Parametro 'visualizza' fornito possiede un valore '" + tipoVisualizzazione + "' sconosciuto. I tipi supportati sono: " + sb.toString());
        }
        statSearchForm.setTipoVisualizzazione(tipoVisualizzazioneEnum);
        if (TipoVisualizzazione.DIMENSIONE_TRANSAZIONI.equals((Object)tipoVisualizzazioneEnum)) {
            String tipoBanda = req.getParameter("banda");
            TipoBanda tipoBandaEnum = CostantiExporter.TIPO_BANDA_VISUALIZZATA_DEFAULT;
            TipoBanda[] tipiBandaEnum = new TipoBanda[TipoBanda.values().length];
            tipiBandaEnum[0] = TipoBanda.COMPLESSIVA;
            tipiBandaEnum[1] = TipoBanda.INTERNA;
            tipiBandaEnum[2] = TipoBanda.ESTERNA;
            if (tipoBanda != null) {
                tipoBanda = tipoBanda.trim();
                tmp = null;
                if (tipoBanda.contains(",")) {
                    tmp = tipoBanda.split(",");
                    tipiBandaEnum = new TipoBanda[tmp.length];
                } else {
                    tmp = new String[1];
                    tipiBandaEnum = new TipoBanda[1];
                    tmp[0] = tipoBanda;
                }
                for (i = 0; i < tmp.length; ++i) {
                    tmp[i] = tmp[i].trim();
                    TipoBanda tmpBanda = TipoBanda.toEnumConstant((String)tmp[i]);
                    if (tmpBanda == null) {
                        String[] values = TipoBanda.toArray();
                        StringBuilder sb = ReportExporter.getAsStringBuilder(values);
                        throw new ParameterUncorrectException("Parametro 'banda' fornito possiede un valore '" + tmp[i] + "' sconosciuto. I tipi supportati sono: " + sb.toString());
                    }
                    if (i == 0) {
                        tipoBandaEnum = tmpBanda;
                    }
                    tipiBandaEnum[i] = tmpBanda;
                }
            }
            statSearchForm.setTipoBanda(tipoBandaEnum);
            String[] arrayBanda = new String[tipiBandaEnum.length];
            block22: for (i = 0; i < tipiBandaEnum.length; ++i) {
                switch (tipiBandaEnum[i]) {
                    case COMPLESSIVA: {
                        arrayBanda[i] = "0";
                        continue block22;
                    }
                    case INTERNA: {
                        arrayBanda[i] = "1";
                        continue block22;
                    }
                    case ESTERNA: {
                        arrayBanda[i] = "2";
                    }
                }
            }
            statSearchForm.setTipiBanda(arrayBanda);
        }
        if (TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA.equals((Object)tipoVisualizzazioneEnum)) {
            String tipoLatenza = req.getParameter("latenza");
            TipoLatenza tipoLatenzaEnum = CostantiExporter.TIPO_LATENZA_VISUALIZZATA_DEFAULT;
            TipoLatenza[] tipiLatenzaEnum = new TipoLatenza[TipoLatenza.values().length];
            tipiLatenzaEnum[0] = TipoLatenza.LATENZA_TOTALE;
            tipiLatenzaEnum[1] = TipoLatenza.LATENZA_SERVIZIO;
            tipiLatenzaEnum[2] = TipoLatenza.LATENZA_PORTA;
            if (tipoLatenza != null) {
                tipoLatenza = tipoLatenza.trim();
                tmp = null;
                if (tipoLatenza.contains(",")) {
                    tmp = tipoLatenza.split(",");
                    tipiLatenzaEnum = new TipoLatenza[tmp.length];
                } else {
                    tmp = new String[1];
                    tipiLatenzaEnum = new TipoLatenza[1];
                    tmp[0] = tipoLatenza;
                }
                for (i = 0; i < tmp.length; ++i) {
                    tmp[i] = tmp[i].trim();
                    TipoLatenza tmpLatenza = TipoLatenza.toEnumConstant((String)tmp[i]);
                    if (tmpLatenza == null) {
                        String[] values = TipoBanda.toArray();
                        StringBuilder sb = ReportExporter.getAsStringBuilder(values);
                        throw new ParameterUncorrectException("Parametro 'latenza' fornito possiede un valore '" + tmp[i] + "' sconosciuto. I tipi supportati sono: " + sb.toString());
                    }
                    if (i == 0) {
                        tipoLatenzaEnum = tmpLatenza;
                    }
                    tipiLatenzaEnum[i] = tmpLatenza;
                }
            }
            statSearchForm.setTipoLatenza(tipoLatenzaEnum);
            String[] arrayLatenza = new String[tipiLatenzaEnum.length];
            block24: for (i = 0; i < tipiLatenzaEnum.length; ++i) {
                switch (tipiLatenzaEnum[i]) {
                    case LATENZA_TOTALE: {
                        arrayLatenza[i] = "0";
                        continue block24;
                    }
                    case LATENZA_SERVIZIO: {
                        arrayLatenza[i] = "1";
                        continue block24;
                    }
                    case LATENZA_PORTA: {
                        arrayLatenza[i] = "2";
                    }
                }
            }
            statSearchForm.setTipiLatenza(arrayLatenza);
        }
        String dimensioniVisualizzate = req.getParameter("dimensioni");
        NumeroDimensioni dimensioniVisualizzateEnum = CostantiExporter.DIMENSIONI_VISUALIZZATE_DEFAULT;
        if (dimensioniVisualizzate != null && (dimensioniVisualizzateEnum = NumeroDimensioni.toEnumConstant(dimensioniVisualizzate = dimensioniVisualizzate.trim())) == null) {
            String[] values = NumeroDimensioni.toArray();
            StringBuilder sb = ReportExporter.getAsStringBuilder(values);
            throw new ParameterUncorrectException("Parametro 'dimensioni' fornito possiede un valore '" + dimensioniVisualizzate + "' sconosciuto. I tipi supportati sono: " + sb.toString());
        }
        statSearchForm.setNumeroDimensioni(dimensioniVisualizzateEnum);
        String dimensioniInfoCustom = req.getParameter("dimensioneInfoCustom");
        DimensioneCustom dimensioniInfoCustomEnum = null;
        if (dimensioniInfoCustom != null) {
            dimensioniInfoCustomEnum = DimensioneCustom.toEnumConstant(dimensioniInfoCustom = dimensioniInfoCustom.trim());
            if (dimensioniInfoCustomEnum == null) {
                String[] values = DimensioneCustom.toArray();
                StringBuilder sb = ReportExporter.getAsStringBuilder(values);
                throw new ParameterUncorrectException("Parametro 'dimensioneInfoCustom' fornito possiede un valore '" + dimensioniInfoCustom + "' sconosciuto. I tipi supportati sono: " + sb.toString());
            }
            statSearchForm.setNumeroDimensioniCustom(dimensioniInfoCustomEnum);
            try {
                SortedMap<String> map = statSearchForm.getDimensioniCustomDisponibiliAsMap();
                if (!map.containsKey(dimensioniInfoCustomEnum.toString())) {
                    throw new ParameterUncorrectException("Informazione custom '" + dimensioniInfoCustomEnum.toString() + "' non supportata dal tipo di report");
                }
            }
            catch (Exception e) {
                throw new ParameterUncorrectException("Parametro 'dimensioneInfoCustom' non corretto: " + e.getMessage(), e);
            }
        }
        statSearchForm.setNumeroDimensioniCustom(dimensioniInfoCustomEnum);
    }

    private static StringBuilder getAsStringBuilder(String[] values) {
        StringBuilder sb = new StringBuilder();
        if (values != null && values.length > 0) {
            for (String tipo : values) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(tipo);
            }
        }
        return sb;
    }
}

