/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.statistiche.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.statistiche.constants.TipoBanda;
import org.openspcoop2.core.statistiche.constants.TipoLatenza;
import org.openspcoop2.core.statistiche.constants.TipoVisualizzazione;
import org.openspcoop2.monitor.sdk.constants.StatisticType;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.datamodel.Res;
import org.openspcoop2.web.monitor.core.datamodel.ResBase;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3D;
import org.openspcoop2.web.monitor.core.datamodel.ResDistribuzione3DCustom;
import org.openspcoop2.web.monitor.statistiche.bean.StatsSearchForm;
import org.openspcoop2.web.monitor.statistiche.utils.StatsUtils;
import org.slf4j.Logger;

public class JsonStatsUtils {
    public static JSONObject getJsonPieChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, Integer slice) {
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"coloriAutomatici", (Object)true);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"clickItemLegenda", (Object)false);
        grafico.put((Object)"valoreRealeTorta", (Object)true);
        grafico.put((Object)"colonneLegenda", (Object)16);
        grafico.put((Object)"limiteColonneLegenda", (Object)16);
        grafico.put((Object)"valueOnLegend", (Object)true);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        JSONArray dati = new JSONArray();
        int maxLenghtLabel = 0;
        if (list != null && list.size() > 0) {
            int i = 0;
            long altri_sum = 0L;
            int altri_sum_numeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    if (r.length() > maxLenghtLabel) {
                        maxLenghtLabel = r.length();
                    }
                    String toolText = StatsUtils.getToolText(search, sum);
                    if (!entry.getParentMap().isEmpty()) {
                        toolText = StatsUtils.getToolTextConParent(search, r, entry.getParentMap(), sum);
                    }
                    JSONObject spicchio = new JSONObject();
                    spicchio.put((Object)"label", (Object)JsonStatsUtils.escapeJsonLabel(r));
                    spicchio.put((Object)"tooltip", (Object)toolText);
                    spicchio.put((Object)"value", (Object)sum);
                    dati.add((Object)spicchio);
                    continue;
                }
                altri_sum += sum.longValue();
                ++altri_sum_numeroItem;
            }
            if (i > slice) {
                long v = altri_sum;
                if (altri_sum_numeroItem > 1 && (occupazioneBanda || tempoMedio) && altri_sum_numeroItem > 0) {
                    v /= (long)altri_sum_numeroItem;
                }
                String toolText = StatsUtils.getToolText(search, v);
                JSONObject spicchio = new JSONObject();
                spicchio.put((Object)"label", (Object)"Altri");
                spicchio.put((Object)"tooltip", (Object)toolText);
                spicchio.put((Object)"value", (Object)v);
                dati.add((Object)spicchio);
            }
            grafico.put((Object)"dati", (Object)dati);
            if (maxLenghtLabel > 50) {
                grafico.put((Object)"limitLegenda", (Object)50);
            }
        } else {
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static JSONObject getJsonBarChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice) {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return JsonStatsUtils._getJsonBarChartDistribuzione(listI, search, caption, subCaption, direzioneLabelParam, slice, null, null, new String[0]);
    }

    public static JSONObject getJsonBarChartDistribuzione(List<Res> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice, Integer numeroLabel, StatisticType tempo) {
        ArrayList<ResBase> listI = new ArrayList<ResBase>();
        listI.addAll(list);
        return JsonStatsUtils._getJsonBarChartDistribuzione(listI, search, caption, subCaption, direzioneLabelParam, slice, numeroLabel, tempo, new String[0]);
    }

    private static JSONObject _getJsonBarChartDistribuzione(List<ResBase> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer sliceParam, Integer numeroLabel, StatisticType tempo, String ... series) {
        JSONObject categoria;
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"coloriAutomatici", (Object)false);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"xAxisLabelDirezione", (Object)JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf_last = null;
        if (tempo != null) {
            sdf_last = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        }
        JSONArray categorie = new JSONArray();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean showSeries = false;
        if (list != null && list.size() > 0) {
            JSONObject categoria2;
            String tipoLat;
            String[] strings;
            if (series != null && series.length > 0) {
                numeroCategorie = series.length;
                for (int i = 0; i < series.length; ++i) {
                    String string = series[i];
                    categoria = new JSONObject();
                    categoria.put((Object)"key", (Object)string);
                    categoria.put((Object)"label", (Object)string);
                    categoria.put((Object)"colore", (Object)"#3B83B7");
                    categorie.add((Object)categoria);
                }
                showSeries = true;
            } else if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                showSeries = true;
                JSONObject categoria3 = new JSONObject();
                categoria3.put((Object)"key", (Object)"ok");
                categoria3.put((Object)"label", (Object)"Ok");
                categoria3.put((Object)"colore", (Object)"#95B964");
                categorie.add((Object)categoria3);
                JSONObject categoria22 = new JSONObject();
                categoria22.put((Object)"key", (Object)"fault");
                categoria22.put((Object)"label", (Object)"Fault Applicativo");
                categoria22.put((Object)"colore", (Object)"#FF8F52");
                categorie.add((Object)categoria22);
                JSONObject categoria32 = new JSONObject();
                categoria32.put((Object)"key", (Object)"errore");
                categoria32.put((Object)"label", (Object)"Fallite");
                categoria32.put((Object)"colore", (Object)"#CD4A50");
                categorie.add((Object)categoria32);
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoBanda.COMPLESSIVA.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoBanda.COMPLESSIVA.getValue());
                        categoria2.put((Object)"colore", (Object)"#3B83B7");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoBanda.INTERNA.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoBanda.INTERNA.getValue());
                        categoria2.put((Object)"colore", (Object)"#FF8F52");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria2 = new JSONObject();
                    categoria2.put((Object)"key", (Object)TipoBanda.ESTERNA.getValue().toLowerCase().replace(" ", "_"));
                    categoria2.put((Object)"label", (Object)TipoBanda.ESTERNA.getValue());
                    categoria2.put((Object)"colore", (Object)"#95B964");
                    categorie.add(i, (Object)categoria2);
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_TOTALE.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoLatenza.LATENZA_TOTALE.getValue());
                        categoria2.put((Object)"colore", (Object)"#3B83B7");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_SERVIZIO.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)"Tempo Risposta Servizio");
                        categoria2.put((Object)"colore", (Object)"#FF8F52");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria2 = new JSONObject();
                    categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_PORTA.getValue().toLowerCase().replace(" ", "_"));
                    categoria2.put((Object)"label", (Object)TipoLatenza.LATENZA_PORTA.getValue());
                    categoria2.put((Object)"colore", (Object)"#95B964");
                    categorie.add(i, (Object)categoria2);
                }
            }
        }
        if (categorie.isEmpty()) {
            JSONObject categoria4 = new JSONObject();
            categoria4.put((Object)"key", (Object)"totale");
            categoria4.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria4.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria4);
        }
        grafico.put((Object)"categorie", (Object)categorie);
        grafico.put((Object)"mostraLegenda", (Object)showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put((Object)"yAxisLabel", (Object)yAxisName);
        JSONArray dati = new JSONArray();
        if (list != null && list.size() > 0) {
            int iterazione = 0;
            long altri_sum_serie1 = 0L;
            int altri_sum_serie1_numeroItem = 0;
            long altri_sum_serie2 = 0L;
            int altri_sum_serie2_numeroItem = 0;
            long altri_sum_serie3 = 0L;
            int altri_sum_serie3_numeroItem = 0;
            int slice = sliceParam;
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            int maxLenghtLabel = 0;
            List<Integer> posizioniDaVisualizzare = JsonStatsUtils.getListaIndiciLabelDaVisualizzare(list.size(), numeroLabel);
            boolean nascondiLabel = posizioniDaVisualizzare != null;
            for (int z = 0; z < list.size(); ++z) {
                ResBase entry = list.get(z);
                JSONObject bar = new JSONObject();
                for (int j = 0; j < numeroCategorie; ++j) {
                    String key = categorie.getJSONObject(j).getString("key");
                    Number sum = null;
                    if (entry instanceof ResDistribuzione) {
                        sum = entry.getSomma();
                    } else if (entry instanceof Res) {
                        sum = (Number)entry.getSomme().get(j);
                    }
                    if (++iterazione <= slice) {
                        Object r = null;
                        if (entry instanceof ResDistribuzione) {
                            r = ((ResDistribuzione)entry).getRisultato();
                        } else if (entry instanceof Res) {
                            Date rDate = ((Res)entry).getRisultato();
                            Calendar c = Calendar.getInstance();
                            c.setTime(rDate);
                            StringBuilder sb = new StringBuilder();
                            if (StatisticType.ORARIA.equals((Object)tempo)) {
                                sdf_last.applyPattern("HH");
                                c.add(10, 1);
                                sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                            } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                                sdf.applyPattern("dd/MM/yy");
                                sdf_last.applyPattern("dd/MM/yy");
                                c.add(4, 1);
                                c.add(7, -1);
                                sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                            } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                                sdf.applyPattern("MMM/yy");
                                sb.append(sdf.format(rDate));
                            } else {
                                sb.append(sdf.format(rDate));
                            }
                            r = sb.toString();
                        } else {
                            r = "ERROR: TIPO [" + entry.getClass().getName() + "] NON GESTITO";
                        }
                        if (j == 0) {
                            if (((String)r).length() > maxLenghtLabel) {
                                maxLenghtLabel = ((String)r).length();
                            }
                            bar.put((Object)"data", (Object)JsonStatsUtils.escapeJsonLabel((String)r));
                            if (!nascondiLabel) {
                                bar.put((Object)"dataLabel", (Object)JsonStatsUtils.escapeJsonLabel((String)r));
                            } else if (posizioniDaVisualizzare.contains(z)) {
                                bar.put((Object)"dataLabel", (Object)JsonStatsUtils.escapeJsonLabel((String)r));
                            } else {
                                bar.put((Object)"dataLabel", (Object)"");
                            }
                        }
                        String toolText = StatsUtils.getToolText(search, sum);
                        if (!entry.getParentMap().isEmpty()) {
                            toolText = StatsUtils.getToolTextConParent(search, (String)r, entry.getParentMap(), sum);
                        }
                        String value = StatsUtils.getValue(search, sum);
                        bar.put((Object)key, (Object)value);
                        bar.put((Object)(key + "_tooltip"), (Object)toolText);
                        if (j != numeroCategorie - 1) continue;
                        dati.add((Object)bar);
                        continue;
                    }
                    if (j == 0) {
                        if (sum != null) {
                            altri_sum_serie1 += sum.longValue();
                        }
                        ++altri_sum_serie1_numeroItem;
                        continue;
                    }
                    if (j == 1) {
                        if (sum != null) {
                            altri_sum_serie2 += sum.longValue();
                        }
                        ++altri_sum_serie2_numeroItem;
                        continue;
                    }
                    if (j != 2) continue;
                    if (sum != null) {
                        altri_sum_serie3 += sum.longValue();
                    }
                    ++altri_sum_serie3_numeroItem;
                }
            }
            if (iterazione > slice) {
                JSONObject bar = new JSONObject();
                bar.put((Object)"data", (Object)"Altri");
                bar.put((Object)"dataLabel", (Object)"Altri");
                for (int j = 0; j < numeroCategorie; ++j) {
                    String key = categorie.getJSONObject(j).getString("key");
                    long v = -1L;
                    if (j == 0) {
                        v = altri_sum_serie1;
                        if (altri_sum_serie1_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie1_numeroItem;
                        }
                    } else if (j == 1) {
                        v = altri_sum_serie2;
                        if (altri_sum_serie2_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie2_numeroItem;
                        }
                    } else if (j == 2) {
                        v = altri_sum_serie3;
                        if (altri_sum_serie3_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie3_numeroItem;
                        }
                    }
                    String toolText = StatsUtils.getToolText(search, v);
                    String value = StatsUtils.getValue(search, v);
                    bar.put((Object)key, (Object)value);
                    bar.put((Object)(key + "_tooltip"), (Object)toolText);
                }
                dati.add((Object)bar);
            }
            if (maxLenghtLabel > 50) {
                grafico.put((Object)"limit", (Object)50);
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            categorie.clear();
            categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static JSONObject getJsonHeatmapChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer slice, StatisticType tempo, boolean visualizzaTotaleNelleCelleGraficoHeatmap, Logger log) {
        return JsonStatsUtils._getJsonHeatmapChartDistribuzione(list, search, caption, subCaption, direzioneLabelParam, slice, null, tempo, visualizzaTotaleNelleCelleGraficoHeatmap, log);
    }

    private static String buildKeyJsonHeatmapChartDistribuzione(ResDistribuzione res) {
        StringBuilder sb = new StringBuilder(res.getRisultato());
        if (res.getParentMap() != null && !res.getParentMap().isEmpty()) {
            int i = 0;
            for (Map.Entry entry : res.getParentMap().entrySet()) {
                sb.append("_");
                sb.append(i);
                sb.append(":");
                sb.append((String)entry.getValue());
                ++i;
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static JSONObject _getJsonHeatmapChartDistribuzione(List<ResDistribuzione> list, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam, Integer sliceParam, Integer numeroLabel, StatisticType tempo, boolean visualizzaTotaleNelleCelleGraficoHeatmap, Logger log) {
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"coloriAutomatici", (Object)false);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"xAxisLabelDirezione", (Object)JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put((Object)"visualizzaValoreNellaCella", (Object)visualizzaTotaleNelleCelleGraficoHeatmap);
        try {
            grafico.put((Object)"visualizzaValoreZero", (Object)PddMonitorProperties.getInstance((Logger)log).isStatisticheVisualizzaValoreZeroNelGraficoHeatmap());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdf_last = null;
        if (tempo != null) {
            sdf_last = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        }
        JSONArray categorie = new JSONArray();
        boolean showSeries = false;
        if (categorie.isEmpty()) {
            JSONObject categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
        }
        grafico.put((Object)"categorie", (Object)categorie);
        grafico.put((Object)"mostraLegenda", (Object)showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put((Object)"yAxisLabel", (Object)yAxisName);
        Integer valoreMinimo = 0;
        Number valoreMassimo = 0;
        JSONArray dati = new JSONArray();
        if (list != null && !list.isEmpty()) {
            int slice = sliceParam;
            int maxLenghtLabel = 0;
            list = JsonStatsUtils.generaElementiMancanti(list, log);
            HashMap<String, List<ResDistribuzione>> elementiPerCategoria = new HashMap<String, List<ResDistribuzione>>();
            HashMap<String, Number> totaliPerCategoria = new HashMap<String, Number>();
            for (ResDistribuzione res : list) {
                void var26_32;
                String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(res);
                List list2 = (List)elementiPerCategoria.remove(key);
                if (list2 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var26_32.add(res);
                elementiPerCategoria.put(key, (List<ResDistribuzione>)var26_32);
                totaliPerCategoria.put(key, StatsUtils.sum(search, totaliPerCategoria.getOrDefault(key, 0), res.getSomma()));
            }
            for (List lista : elementiPerCategoria.values()) {
                JsonStatsUtils.ordinaElementiAsseYPerData(search, lista);
            }
            ArrayList<Map.Entry<String, Number>> totaliPerCategoriaEntryList = new ArrayList<Map.Entry<String, Number>>(totaliPerCategoria.entrySet());
            JsonStatsUtils.ordinaElementiAsseXPerSommaDecrescente(search, totaliPerCategoriaEntryList);
            list = JsonStatsUtils.valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescente(elementiPerCategoria, totaliPerCategoriaEntryList);
            if (totaliPerCategoriaEntryList.size() > slice) {
                ArrayList<String> sortedKeys = new ArrayList<String>();
                for (Map.Entry entry : totaliPerCategoriaEntryList) {
                    sortedKeys.add((String)entry.getKey());
                }
                List<String> categorieDaAccorpareComeAltri = sortedKeys.subList(slice, sortedKeys.size());
                list = JsonStatsUtils.valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescenteConElementoAltri(elementiPerCategoria, totaliPerCategoriaEntryList, categorieDaAccorpareComeAltri, search, log);
            }
            for (int z = 0; z < list.size(); ++z) {
                ResDistribuzione entry = list.get(z);
                JSONObject jSONObject = new JSONObject();
                Number sum = entry.getSomma();
                String r = entry.getRisultato();
                String dateS = null;
                if (entry instanceof ResDistribuzione3D) {
                    Date rDate = ((ResDistribuzione3D)entry).getData();
                    Calendar c = Calendar.getInstance();
                    c.setTime(rDate);
                    StringBuilder sb = new StringBuilder();
                    if (StatisticType.ORARIA.equals((Object)tempo)) {
                        sdf_last.applyPattern("HH");
                        c.add(10, 1);
                        sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                    } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                        sdf.applyPattern("dd/MM/yy");
                        sdf_last.applyPattern("dd/MM/yy");
                        c.add(4, 1);
                        c.add(7, -1);
                        sb.append(sdf.format(rDate) + "-").append(sdf_last.format(c.getTime()));
                    } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                        sdf.applyPattern("MMM/yy");
                        sb.append(sdf.format(rDate));
                    } else {
                        sb.append(sdf.format(rDate));
                    }
                    dateS = sb.toString();
                } else if (entry instanceof ResDistribuzione3DCustom) {
                    dateS = ((ResDistribuzione3DCustom)entry).getDatoCustom();
                }
                if (r.length() > maxLenghtLabel) {
                    maxLenghtLabel = r.length();
                }
                String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(entry);
                jSONObject.put((Object)"x", (Object)JsonStatsUtils.escapeJsonLabel(key));
                jSONObject.put((Object)"xLabel", (Object)JsonStatsUtils.escapeJsonLabel(r));
                jSONObject.put((Object)"y", (Object)JsonStatsUtils.escapeJsonLabel(dateS));
                jSONObject.put((Object)"yLabel", (Object)JsonStatsUtils.escapeJsonLabel(dateS));
                String toolText = StatsUtils.getToolText(search, sum);
                if (!entry.getParentMap().isEmpty()) {
                    toolText = StatsUtils.getToolTextConParent(search, r, entry.getParentMap(), sum);
                }
                if (r.equals("Altri")) {
                    toolText = StatsUtils.getToolTextCategoriaAltri(search, sum);
                }
                String value = StatsUtils.getValue(search, sum);
                jSONObject.put((Object)"totale", (Object)value);
                jSONObject.put((Object)"totale_tooltip", (Object)toolText);
                jSONObject.put((Object)"totale_label", (Object)StatsUtils.getToolText(search, sum));
                dati.add((Object)jSONObject);
                valoreMassimo = StatsUtils.getMax(search, sum, valoreMassimo);
            }
            if (maxLenghtLabel > 50) {
                grafico.put((Object)"limit", (Object)50);
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            categorie.clear();
            JSONObject categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        JSONObject scalaValori = new JSONObject();
        JSONObject min = new JSONObject();
        min.put((Object)"colore", (Object)"#FFFFFF");
        min.put((Object)"valore", (Object)valoreMinimo);
        scalaValori.put((Object)"min", (Object)min);
        JSONObject max = new JSONObject();
        max.put((Object)"colore", (Object)"#3B83B7");
        max.put((Object)"valore", (Object)StatsUtils.getValue(search, valoreMassimo));
        scalaValori.put((Object)"max", (Object)max);
        grafico.put((Object)"scalaValori", (Object)scalaValori);
        JSONArray labelsLegenda = new JSONArray();
        JSONObject minLabel = new JSONObject();
        minLabel.put((Object)"valore", (Object)StatsUtils.getValue(search, valoreMinimo));
        minLabel.put((Object)"label", (Object)StatsUtils.getToolText(search, valoreMinimo));
        labelsLegenda.add((Object)minLabel);
        Number unQuarto = StatsUtils.avg(search, valoreMassimo, 4);
        JSONObject unQuartoLabel = new JSONObject();
        unQuartoLabel.put((Object)"valore", (Object)StatsUtils.getValue(search, unQuarto));
        unQuartoLabel.put((Object)"label", (Object)StatsUtils.getToolText(search, unQuarto));
        labelsLegenda.add((Object)unQuartoLabel);
        Number number = StatsUtils.avg(search, valoreMassimo, 2);
        JSONObject unMezzoLabel = new JSONObject();
        unMezzoLabel.put((Object)"valore", (Object)StatsUtils.getValue(search, number));
        unMezzoLabel.put((Object)"label", (Object)StatsUtils.getToolText(search, number));
        labelsLegenda.add((Object)unMezzoLabel);
        Number treQuarti = StatsUtils.avg(search, StatsUtils.sum(search, valoreMassimo, number), 2);
        JSONObject treQuartiLabel = new JSONObject();
        treQuartiLabel.put((Object)"valore", (Object)StatsUtils.getValue(search, treQuarti));
        treQuartiLabel.put((Object)"label", (Object)StatsUtils.getToolText(search, treQuarti));
        labelsLegenda.add((Object)treQuartiLabel);
        JSONObject maxLabel = new JSONObject();
        maxLabel.put((Object)"valore", (Object)StatsUtils.getValue(search, valoreMassimo));
        maxLabel.put((Object)"label", (Object)StatsUtils.getToolText(search, valoreMassimo));
        labelsLegenda.add((Object)maxLabel);
        grafico.put((Object)"labelLegenda", (Object)labelsLegenda);
        return grafico;
    }

    public static List<ResDistribuzione> generaElementiMancanti(List<ResDistribuzione> origList, Logger log) {
        List<ResDistribuzione> lNull = null;
        if (origList == null) {
            return lNull;
        }
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        HashSet<String> existingXValues = new HashSet<String>();
        HashMap<String, String> existingXValuesOriginalKey = new HashMap<String, String>();
        HashSet<Date> existingYDateValues = new HashSet<Date>();
        HashSet<String> existingYCustomValues = new HashSet<String>();
        boolean customValues = false;
        HashMap mapParentMaps = new HashMap();
        Iterator<ResDistribuzione> iterator = origList.iterator();
        while (iterator.hasNext()) {
            ResDistribuzione resDistribuzione;
            ResDistribuzione resDistribuzione2 = resDistribuzione = iterator.next();
            destList.add(resDistribuzione2);
            Iterator key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione(resDistribuzione2);
            existingXValues.add((String)((Object)key));
            existingXValuesOriginalKey.put((String)((Object)key), resDistribuzione2.getRisultato());
            mapParentMaps.put(key, resDistribuzione2.getParentMap());
            if (resDistribuzione2 instanceof ResDistribuzione3D) {
                existingYDateValues.add(((ResDistribuzione3D)resDistribuzione2).getData());
                continue;
            }
            if (!(resDistribuzione2 instanceof ResDistribuzione3DCustom)) continue;
            customValues = true;
            existingYCustomValues.add(((ResDistribuzione3DCustom)resDistribuzione2).getDatoCustom());
        }
        ArrayList<ResDistribuzione3DCustom> missingTriples = new ArrayList<ResDistribuzione3DCustom>();
        for (String x : existingXValues) {
            ResDistribuzione3DCustom resDistribuzione3D;
            String originalKey;
            if (customValues) {
                for (String string : existingYCustomValues) {
                    if (JsonStatsUtils.containsTriple(destList, x, string)) continue;
                    originalKey = (String)existingXValuesOriginalKey.get(x);
                    resDistribuzione3D = new ResDistribuzione3DCustom(originalKey, string, (Number)0);
                    resDistribuzione3D.getParentMap().putAll((Map)mapParentMaps.get(x));
                    missingTriples.add(resDistribuzione3D);
                }
                continue;
            }
            for (Date date : existingYDateValues) {
                if (JsonStatsUtils.containsTriple(destList, x, date)) continue;
                originalKey = (String)existingXValuesOriginalKey.get(x);
                resDistribuzione3D = new ResDistribuzione3D(originalKey, date, (Number)0);
                resDistribuzione3D.getParentMap().putAll((Map)mapParentMaps.get(x));
                missingTriples.add(resDistribuzione3D);
            }
        }
        destList.addAll(missingTriples);
        long l = 0L;
        l = customValues ? (long)existingYCustomValues.size() : (long)existingYDateValues.size();
        long xYsize = (long)existingXValues.size() * l;
        if ((long)destList.size() != xYsize) {
            String msg = "generaElementiMancanti destListSize:" + destList.size() + " xYsize:" + xYsize + " existingXValues:" + existingXValues + " existingYValues:" + l;
            log.error(msg);
        }
        return destList;
    }

    private static boolean containsTriple(List<ResDistribuzione> valuesList, String x, Date y) {
        for (ResDistribuzione res : valuesList) {
            ResDistribuzione3D resDistribuzione3D = (ResDistribuzione3D)res;
            String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione((ResDistribuzione)resDistribuzione3D);
            if (!key.equals(x) || !resDistribuzione3D.getData().equals(y)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsTriple(List<ResDistribuzione> valuesList, String x, String y) {
        for (ResDistribuzione res : valuesList) {
            ResDistribuzione3DCustom resDistribuzione3D = (ResDistribuzione3DCustom)res;
            String key = JsonStatsUtils.buildKeyJsonHeatmapChartDistribuzione((ResDistribuzione)resDistribuzione3D);
            if (!key.equals(x) || !resDistribuzione3D.getDatoCustom().equals(y)) continue;
            return true;
        }
        return false;
    }

    private static List<ResDistribuzione> valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescente(Map<String, List<ResDistribuzione>> elementiPerCategoria, List<Map.Entry<String, Number>> entryList) {
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        for (Map.Entry<String, Number> entry : entryList) {
            destList.addAll((Collection<ResDistribuzione>)elementiPerCategoria.get(entry.getKey()));
        }
        return destList;
    }

    private static List<ResDistribuzione> valorizzaListaRisultatiConElementiOrdinatiPerSommaDecrescenteConElementoAltri(Map<String, List<ResDistribuzione>> elementiPerCategoria, List<Map.Entry<String, Number>> entryList, List<String> categorieDaAccorpareComeAltri, StatsSearchForm search, Logger log) {
        ArrayList<ResDistribuzione> destList = new ArrayList<ResDistribuzione>();
        for (Map.Entry<String, Number> entry : entryList) {
            if (categorieDaAccorpareComeAltri.contains(entry.getKey())) continue;
            destList.addAll((Collection)elementiPerCategoria.get(entry.getKey()));
        }
        ArrayList<ResDistribuzione> colonnaAltri = new ArrayList<ResDistribuzione>();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        for (String categoria : categorieDaAccorpareComeAltri) {
            List<ResDistribuzione> categoriaDaAccorpare = elementiPerCategoria.get(categoria);
            if (!colonnaAltri.isEmpty() && categoriaDaAccorpare.size() != colonnaAltri.size()) {
                log.error("Categoria '" + categoria + "' possiede una dimensione '" + categoriaDaAccorpare.size() + "' diversa da quella attesa '" + colonnaAltri.size() + "'");
            }
            if (colonnaAltri.isEmpty()) {
                for (ResDistribuzione resDistribuzione : categoriaDaAccorpare) {
                    resDistribuzione.setRisultato("Altri");
                    if (resDistribuzione.getParentMap() != null) {
                        resDistribuzione.getParentMap().clear();
                    }
                    colonnaAltri.add(resDistribuzione);
                }
                continue;
            }
            for (int i = 0; i < colonnaAltri.size(); ++i) {
                ResDistribuzione resDistribuzioneColonnaAltri = (ResDistribuzione)colonnaAltri.get(i);
                ResDistribuzione resDistribuzioneDaAccorpare = categoriaDaAccorpare.get(i);
                resDistribuzioneColonnaAltri.setSomma(StatsUtils.sum(search, resDistribuzioneDaAccorpare.getSomma(), resDistribuzioneColonnaAltri.getSomma()));
            }
        }
        if (occupazioneBanda || tempoMedio) {
            for (int i = 0; i < colonnaAltri.size(); ++i) {
                ResDistribuzione resDistribuzioneColonnaAltri = (ResDistribuzione)colonnaAltri.get(i);
                resDistribuzioneColonnaAltri.setSomma(StatsUtils.avg(search, resDistribuzioneColonnaAltri.getSomma(), categorieDaAccorpareComeAltri.size()));
            }
        }
        destList.addAll(colonnaAltri);
        return destList;
    }

    private static void ordinaElementiAsseXPerSommaDecrescente(final StatsSearchForm search, List<Map.Entry<String, Number>> entryList) {
        Collections.sort(entryList, new Comparator<Map.Entry<String, Number>>(){

            @Override
            public int compare(Map.Entry<String, Number> entry1, Map.Entry<String, Number> entry2) {
                TipoVisualizzazione tipoVisualizzazione = null;
                if (search != null) {
                    tipoVisualizzazione = search.getTipoVisualizzazione();
                }
                if (tipoVisualizzazione != null) {
                    switch (tipoVisualizzazione) {
                        case NUMERO_TRANSAZIONI: 
                        case TEMPO_MEDIO_RISPOSTA: {
                            return Long.compare(entry2.getValue().longValue(), entry1.getValue().longValue());
                        }
                    }
                    return Double.compare(entry2.getValue().doubleValue(), entry1.getValue().doubleValue());
                }
                return Long.compare(entry2.getValue().longValue(), entry1.getValue().longValue());
            }
        });
    }

    private static void ordinaElementiAsseYPerData(StatsSearchForm search, List<ResDistribuzione> list) {
        Collections.sort(list, new Comparator<ResDistribuzione>(){

            @Override
            public int compare(ResDistribuzione entry1, ResDistribuzione entry2) {
                if (entry1 instanceof ResDistribuzione3D) {
                    Date date1 = ((ResDistribuzione3D)entry1).getData();
                    Date date2 = ((ResDistribuzione3D)entry2).getData();
                    return date1.compareTo(date2);
                }
                String date1 = ((ResDistribuzione3DCustom)entry1).getDatoCustom();
                String date2 = ((ResDistribuzione3DCustom)entry2).getDatoCustom();
                return date1.compareTo(date2);
            }
        });
    }

    public static JSONObject getJsonAndamentoTemporale(List<Res> list, StatsSearchForm search, String caption, String subCaption, StatisticType tempo, String direzioneLabelParam, Integer numeroLabel) {
        JSONObject categoria;
        JSONObject grafico = new JSONObject();
        SimpleDateFormat sdf_last = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
        SimpleDateFormat sdf = StatisticType.ORARIA.equals((Object)tempo) ? new SimpleDateFormat("dd/MM/yy HH", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd/MM/yy", ApplicationBean.getInstance().getLocale());
        grafico.put((Object)"coloriAutomatici", (Object)false);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"xAxisLabelDirezione", (Object)JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        JSONArray categorie = new JSONArray();
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        boolean distribuzionePerEsiti = false;
        if (search.isAndamentoTemporalePerEsiti()) {
            distribuzionePerEsiti = true;
        } else {
            TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
            if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
                occupazioneBanda = true;
            } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
                tempoMedio = true;
            }
        }
        int numeroCategorie = 1;
        boolean showSeries = false;
        if (list != null && list.size() > 0) {
            JSONObject categoria2;
            String tipoLat;
            String[] strings;
            if (distribuzionePerEsiti) {
                numeroCategorie = 3;
                showSeries = true;
                categoria = new JSONObject();
                categoria.put((Object)"key", (Object)"ok");
                categoria.put((Object)"label", (Object)"Ok");
                categoria.put((Object)"colore", (Object)"#95B964");
                categorie.add((Object)categoria);
                JSONObject categoria22 = new JSONObject();
                categoria22.put((Object)"key", (Object)"fault");
                categoria22.put((Object)"label", (Object)"Fault Applicativo");
                categoria22.put((Object)"colore", (Object)"#FF8F52");
                categorie.add((Object)categoria22);
                JSONObject categoria3 = new JSONObject();
                categoria3.put((Object)"key", (Object)"errore");
                categoria3.put((Object)"label", (Object)"Fallite");
                categoria3.put((Object)"colore", (Object)"#CD4A50");
                categorie.add((Object)categoria3);
            } else if (occupazioneBanda) {
                numeroCategorie = search.getTipiBandaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiBanda();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoBanda.COMPLESSIVA.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoBanda.COMPLESSIVA.getValue());
                        categoria2.put((Object)"colore", (Object)"#3B83B7");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoBanda.INTERNA.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoBanda.INTERNA.getValue());
                        categoria2.put((Object)"colore", (Object)"#FF8F52");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria2 = new JSONObject();
                    categoria2.put((Object)"key", (Object)TipoBanda.ESTERNA.getValue().toLowerCase().replace(" ", "_"));
                    categoria2.put((Object)"label", (Object)TipoBanda.ESTERNA.getValue());
                    categoria2.put((Object)"colore", (Object)"#95B964");
                    categorie.add(i, (Object)categoria2);
                }
            } else if (tempoMedio) {
                numeroCategorie = search.getTipiLatenzaImpostati().size();
                showSeries = numeroCategorie > 1;
                for (int i = 0; i < numeroCategorie; ++i) {
                    strings = search.getTipiLatenza();
                    if (strings == null || strings.length != numeroCategorie || (tipoLat = strings[i]) == null) continue;
                    if (tipoLat.equals("0")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_TOTALE.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)TipoLatenza.LATENZA_TOTALE.getValue());
                        categoria2.put((Object)"colore", (Object)"#3B83B7");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (tipoLat.equals("1")) {
                        if (!showSeries) continue;
                        categoria2 = new JSONObject();
                        categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_SERVIZIO.getValue().toLowerCase().replace(" ", "_"));
                        categoria2.put((Object)"label", (Object)"Tempo Risposta Servizio");
                        categoria2.put((Object)"colore", (Object)"#FF8F52");
                        categorie.add(i, (Object)categoria2);
                        continue;
                    }
                    if (!tipoLat.equals("2") || !showSeries) continue;
                    categoria2 = new JSONObject();
                    categoria2.put((Object)"key", (Object)TipoLatenza.LATENZA_PORTA.getValue().toLowerCase().replace(" ", "_"));
                    categoria2.put((Object)"label", (Object)TipoLatenza.LATENZA_PORTA.getValue());
                    categoria2.put((Object)"colore", (Object)"#95B964");
                    categorie.add(i, (Object)categoria2);
                }
            }
        }
        if (categorie.isEmpty()) {
            categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
        }
        grafico.put((Object)"categorie", (Object)categorie);
        grafico.put((Object)"mostraLegenda", (Object)showSeries);
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put((Object)"yAxisLabel", (Object)yAxisName);
        JSONArray dati = new JSONArray();
        if (list != null && list.size() > 0) {
            List<Integer> posizioniDaVisualizzare = JsonStatsUtils.getListaIndiciLabelDaVisualizzare((list = StatsUtils.checkEstremi(list, search, tempo, sdf)).size(), numeroLabel);
            boolean nascondiLabel = posizioniDaVisualizzare != null;
            for (int z = 0; z < list.size(); ++z) {
                Res entry = list.get(z);
                JSONObject point = new JSONObject();
                Date r = entry.getRisultato();
                Calendar c = Calendar.getInstance();
                c.setTime(r);
                StringBuilder sb = new StringBuilder();
                if (StatisticType.ORARIA.equals((Object)tempo)) {
                    sdf_last.applyPattern("HH");
                    c.add(10, 1);
                    sb.append(sdf.format(r) + "-").append(sdf_last.format(c.getTime()));
                } else if (StatisticType.SETTIMANALE.equals((Object)tempo)) {
                    sdf.applyPattern("dd/MM/yy");
                    sdf_last.applyPattern("dd/MM/yy");
                    c.add(4, 1);
                    c.add(7, -1);
                    sb.append(sdf.format(r) + "-").append(sdf_last.format(c.getTime()));
                } else if (StatisticType.MENSILE.equals((Object)tempo)) {
                    sdf.applyPattern("MMM/yy");
                    sb.append(sdf.format(r));
                } else {
                    sb.append(sdf.format(r));
                }
                String label = sb.toString();
                point.put((Object)"data", (Object)JsonStatsUtils.escapeJsonLabel(label));
                if (!nascondiLabel) {
                    point.put((Object)"dataLabel", (Object)JsonStatsUtils.escapeJsonLabel(label));
                } else if (posizioniDaVisualizzare.contains(z)) {
                    point.put((Object)"dataLabel", (Object)JsonStatsUtils.escapeJsonLabel(label));
                } else {
                    point.put((Object)"dataLabel", (Object)"");
                }
                for (int j = 0; j < numeroCategorie; ++j) {
                    String key = categorie.getJSONObject(j).getString("key");
                    Number sum = (Number)entry.getSomme().get(j);
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    point.put((Object)key, (Object)value);
                    point.put((Object)(key + "_tooltip"), (Object)toolText);
                }
                dati.add((Object)point);
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            categorie.clear();
            JSONObject categoria3 = new JSONObject();
            categoria3.put((Object)"key", (Object)"totale");
            categoria3.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria3.put((Object)"colore", (Object)"#3B83B7");
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static JSONObject getJsonAndamentoTemporaleStatPersonalizzate(SimpleDateFormat sdf, SimpleDateFormat sdf_last_hour, StatisticType tempo, Map<String, List<Res>> results, StatsSearchForm search, String caption, String subCaption, String direzioneLabelParam) {
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"xAxisLabelDirezione", (Object)JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put((Object)"coloriAutomatici", (Object)true);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"colonneLegenda", (Object)16);
        grafico.put((Object)"limiteColonneLegenda", (Object)16);
        JSONArray categorie = new JSONArray();
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put((Object)"mostraLegenda", (Object)true);
        grafico.put((Object)"yAxisLabel", (Object)yAxisName);
        JSONArray dati = new JSONArray();
        if (results != null && results.size() > 0) {
            Set<String> keys = results.keySet();
            Iterator<String> it = keys.iterator();
            int i = 0;
            while (it.hasNext()) {
                JSONObject point;
                String key = it.next();
                String catKey = "cat_" + i;
                List<Res> list = results.get(key);
                JSONObject categoria = new JSONObject();
                categoria.put((Object)"key", (Object)catKey);
                categoria.put((Object)"label", (Object)JsonStatsUtils.escapeJsonLabel(key));
                categorie.add((Object)categoria);
                list = StatsUtils.checkEstremi(list, search, tempo, sdf);
                if (i < 1) {
                    for (Res entry : list) {
                        point = new JSONObject();
                        Date r = entry.getRisultato();
                        StringBuilder sb = new StringBuilder();
                        if (StatisticType.ORARIA.equals((Object)tempo)) {
                            Calendar c = Calendar.getInstance();
                            c.setTime(r);
                            c.add(10, 1);
                            sb.append(sdf.format(r) + "-" + sdf_last_hour.format(c.getTime()));
                        } else {
                            sb.append(sdf.format(r));
                        }
                        point.put((Object)"data", (Object)sb.toString());
                        point.put((Object)"dataLabel", (Object)sb.toString());
                        dati.add((Object)point);
                    }
                }
                for (int j = 0; j < list.size(); ++j) {
                    Res entry;
                    entry = list.get(j);
                    point = dati.getJSONObject(j);
                    Number sum = entry.getSomma();
                    String toolText = StatsUtils.getToolText(search, sum);
                    String value = StatsUtils.getValue(search, sum);
                    point.put((Object)catKey, (Object)value);
                    point.put((Object)(catKey + "_tooltip"), (Object)toolText);
                }
                ++i;
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            categorie.clear();
            JSONObject categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        grafico.put((Object)"categorie", (Object)categorie);
        return grafico;
    }

    public static JSONObject getJsonPieChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, int slice, String caption, String subCaption) {
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"coloriAutomatici", (Object)true);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        grafico.put((Object)"clickItemLegenda", (Object)false);
        grafico.put((Object)"valoreRealeTorta", (Object)true);
        grafico.put((Object)"colonneLegenda", (Object)16);
        grafico.put((Object)"limiteColonneLegenda", (Object)16);
        grafico.put((Object)"valueOnLegend", (Object)true);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        TipoVisualizzazione tipoVisualizzazione = search.getTipoVisualizzazione();
        if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.DIMENSIONE_TRANSAZIONI)) {
            occupazioneBanda = true;
        } else if (tipoVisualizzazione.equals((Object)TipoVisualizzazione.TEMPO_MEDIO_RISPOSTA)) {
            tempoMedio = true;
        }
        JSONArray dati = new JSONArray();
        int maxLenghtLabel = 0;
        if (list != null && list.size() > 0) {
            int i = 0;
            long altri_sum = 0L;
            int altri_sum_numeroItem = 0;
            for (ResDistribuzione entry : list) {
                String r = entry.getRisultato();
                Number sum = entry.getSomma();
                if (++i <= slice) {
                    if (r.length() > maxLenghtLabel) {
                        maxLenghtLabel = r.length();
                    }
                    String toolText = StatsUtils.getToolText(search, sum);
                    JSONObject spicchio = new JSONObject();
                    spicchio.put((Object)"label", (Object)JsonStatsUtils.escapeJsonLabel(r));
                    spicchio.put((Object)"tooltip", (Object)toolText);
                    spicchio.put((Object)"value", (Object)sum);
                    dati.add((Object)spicchio);
                    continue;
                }
                altri_sum += sum.longValue();
                ++altri_sum_numeroItem;
            }
            if (i > slice) {
                long v = altri_sum;
                if (altri_sum_numeroItem > 1 && (occupazioneBanda || tempoMedio) && altri_sum_numeroItem > 0) {
                    v /= (long)altri_sum_numeroItem;
                }
                String toolText = StatsUtils.getToolText(search, v);
                JSONObject spicchio = new JSONObject();
                spicchio.put((Object)"label", (Object)"Altri");
                spicchio.put((Object)"tooltip", (Object)toolText);
                spicchio.put((Object)"value", (Object)v);
                dati.add((Object)spicchio);
            }
            if (maxLenghtLabel > 50) {
                grafico.put((Object)"limitLegenda", (Object)50);
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        grafico.put((Object)"dati", (Object)dati);
        return grafico;
    }

    public static JSONObject getJsonBarChartStatistichePersonalizzate(List<ResDistribuzione> list, StatsSearchForm search, String direzioneLabelParam, int slice, String caption, String subCaption) {
        JSONObject grafico = new JSONObject();
        grafico.put((Object)"titolo", (Object)caption);
        grafico.put((Object)"sottotitolo", (Object)subCaption);
        grafico.put((Object)"xAxisLabelDirezione", (Object)JsonStatsUtils.getDirezioneLabel(direzioneLabelParam));
        grafico.put((Object)"coloriAutomatici", (Object)false);
        grafico.put((Object)"xAxisGridLines", (Object)true);
        JSONArray categorie = new JSONArray();
        JSONObject categoria = new JSONObject();
        categoria.put((Object)"key", (Object)"totale");
        categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
        categoria.put((Object)"colore", (Object)"#3B83B7");
        categorie.add((Object)categoria);
        boolean occupazioneBanda = false;
        boolean tempoMedio = false;
        int numeroCategorie = 1;
        String yAxisName = StatsUtils.getSubCaption(search, true);
        grafico.put((Object)"categorie", (Object)categorie);
        grafico.put((Object)"mostraLegenda", (Object)false);
        grafico.put((Object)"yAxisLabel", (Object)yAxisName);
        JSONArray dati = new JSONArray();
        int maxLenghtLabel = 0;
        if (list != null && list.size() > 0) {
            int iterazione = 0;
            long altri_sum_serie1 = 0L;
            int altri_sum_serie1_numeroItem = 0;
            if (slice != Integer.MAX_VALUE) {
                slice *= numeroCategorie;
            }
            for (int z = 0; z < list.size(); ++z) {
                ResDistribuzione entry = list.get(z);
                JSONObject bar = new JSONObject();
                for (int j = 0; j < numeroCategorie; ++j) {
                    String key = categorie.getJSONObject(j).getString("key");
                    Number sum = entry.getSomma();
                    if (++iterazione <= slice) {
                        String r = entry.getRisultato();
                        if (j == 0) {
                            if (r.length() > maxLenghtLabel) {
                                maxLenghtLabel = r.length();
                            }
                            bar.put((Object)"data", (Object)JsonStatsUtils.escapeJsonLabel(r));
                            bar.put((Object)"dataLabel", (Object)JsonStatsUtils.escapeJsonLabel(r));
                        }
                        String value = StatsUtils.getValue(search, sum);
                        String toolText = StatsUtils.getToolText(search, sum);
                        bar.put((Object)key, (Object)value);
                        bar.put((Object)(key + "_tooltip"), (Object)toolText);
                        if (j != numeroCategorie - 1) continue;
                        dati.add((Object)bar);
                        continue;
                    }
                    if (j != 0) continue;
                    altri_sum_serie1 += sum.longValue();
                    ++altri_sum_serie1_numeroItem;
                }
            }
            if (iterazione > slice) {
                JSONObject bar = new JSONObject();
                bar.put((Object)"data", (Object)"Altri");
                bar.put((Object)"dataLabel", (Object)"Altri");
                for (int j = 0; j < numeroCategorie; ++j) {
                    String key = categorie.getJSONObject(j).getString("key");
                    long v = -1L;
                    if (j == 0) {
                        v = altri_sum_serie1;
                        if (altri_sum_serie1_numeroItem > 1 && (occupazioneBanda || tempoMedio)) {
                            v /= (long)altri_sum_serie1_numeroItem;
                        }
                    }
                    String toolText = StatsUtils.getToolText(search, v);
                    String value = StatsUtils.getValue(search, v);
                    bar.put((Object)key, (Object)value);
                    bar.put((Object)(key + "_tooltip"), (Object)toolText);
                }
                dati.add((Object)bar);
            }
            if (maxLenghtLabel > 50) {
                grafico.put((Object)"limit", (Object)50);
            }
            grafico.put((Object)"dati", (Object)dati);
        } else {
            categorie.clear();
            categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"totale");
            categoria.put((Object)"label", (Object)StatsUtils.getSubCaption(search, true));
            categoria.put((Object)"colore", (Object)"#3B83B7");
            categorie.add((Object)categoria);
            grafico.put((Object)"noData", (Object)"Non esistono transazioni per il periodo selezionato");
        }
        return grafico;
    }

    public static int getDirezioneLabel(String direzione) {
        if (StringUtils.isNotEmpty((String)direzione)) {
            if ("Orizzontale".equals(direzione)) {
                return 0;
            }
            if ("Obliquo".equals(direzione)) {
                return -45;
            }
            if ("Verticale".equals(direzione)) {
                return -90;
            }
        }
        return 0;
    }

    public static String escapeJsonLabel(String label) {
        String escaped = StringEscapeUtils.escapeXml((String)label);
        escaped = escaped.replace("\\", "\\\\");
        return escaped;
    }

    public static List<Integer> getListaIndiciLabelDaVisualizzare(int size, Integer numeroLabel) {
        ArrayList<Integer> posizioni = null;
        if (numeroLabel != null && size > numeroLabel) {
            if (numeroLabel < 2) {
                numeroLabel = 2;
            }
            posizioni = new ArrayList<Integer>();
            posizioni.add(0);
            int denom = numeroLabel - 1;
            int numeroPosizioni = numeroLabel - 2;
            for (int j = 1; j <= numeroPosizioni; ++j) {
                int pos = j * size / denom;
                posizioni.add(pos);
            }
            posizioni.add(size - 1);
        }
        return posizioni;
    }
}

