/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.console.resource;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jminix.console.resource.AbstractTemplateResource;
import org.jminix.console.resource.ValueParser;
import org.jminix.type.AttributeFilter;
import org.restlet.data.Form;
import org.restlet.representation.Representation;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeResource
extends AbstractTemplateResource {
    private static Log log = LogFactory.getLog(AttributeResource.class);
    private AttributeFilter attributeFilter;
    private String templateName = "attribute";

    @Override
    protected void doInit() throws ResourceException {
        super.doInit();
        this.attributeFilter = (AttributeFilter)this.getContext().getAttributes().get("attributeFilter");
    }

    @Override
    public Map<String, Object> getModel() {
        String domain = this.unescape(this.getDecodedAttribute("domain"));
        String mbean = this.unescape(this.getDecodedAttribute("mbean"));
        String attribute = this.getDecodedAttribute("attribute");
        HashMap<String, Object> model = new HashMap<String, Object>();
        try {
            MBeanServerConnection server = this.getServer();
            MBeanAttributeInfo info = null;
            for (MBeanAttributeInfo i : server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getAttributes()) {
                if (!i.getName().equals(attribute)) continue;
                info = i;
            }
            Object value = server.getAttribute(new ObjectName(domain + ":" + mbean), attribute);
            model.put("attribute", info);
            if (value instanceof CompositeData && this.getAttribute("item") != null) {
                String item = this.getDecodedAttribute("item");
                log.debug((Object)("Reading key " + item + " from " + value));
                value = ((CompositeData)value).get(item);
            }
            if (value == null) {
                model.put("value", "<null>");
            } else if (value.getClass().isArray()) {
                this.templateName = "array-attribute";
                if (value.getClass().getComponentType().isAssignableFrom(CompositeData.class)) {
                    CompositeData[] data = (CompositeData[])value;
                    String[] values = new String[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        Set<String> keys = data[i].getCompositeType().keySet();
                        StringBuilder sb = new StringBuilder("{");
                        for (String key : keys) {
                            if (sb.length() > 1) {
                                sb.append(", ");
                            }
                            sb.append(key);
                            sb.append(": ");
                            sb.append(data[i].get(key));
                        }
                        sb.append("}");
                        values[i] = sb.toString();
                    }
                    model.put("items", values);
                } else {
                    model.put("items", value);
                }
            } else if (value instanceof CompositeData) {
                this.templateName = "composite-attribute";
                model.put("attribute", this.filter(value));
            } else if (value instanceof TabularData) {
                this.templateName = "tabular-attribute";
                model.put("attribute", this.filter(value));
            } else {
                model.put("value", this.filter(value));
            }
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            Exception targetException = e.getTargetException();
            if (targetException instanceof RuntimeErrorException) {
                throw new RuntimeException(targetException.getCause());
            }
            log.warn((Object)"Error accessing attribute", (Throwable)e);
            model.put("value", e.getTargetException().getCause().getMessage());
            return model;
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            model.put("value", e.getMessage());
            log.warn((Object)"Error accessing attribute", (Throwable)e);
            return model;
        }
    }

    @Post(value="*:txt|html|json")
    public void update(Representation entity) throws ResourceException {
        String value = new Form(entity).getFirstValue("value");
        String domain = this.unescape(this.getDecodedAttribute("domain"));
        String mbean = this.unescape(this.getDecodedAttribute("mbean"));
        String attributeName = this.getDecodedAttribute("attribute");
        MBeanServerConnection server = this.getServer();
        try {
            String queryString;
            String type = "java.lang.String";
            for (MBeanAttributeInfo info : server.getMBeanInfo(new ObjectName(domain + ":" + mbean)).getAttributes()) {
                if (!info.getName().equals(attributeName)) continue;
                type = info.getType();
            }
            Object attribute = new ValueParser().parse(value, type);
            if (attribute != null) {
                server.setAttribute(new ObjectName(domain + ":" + mbean), new Attribute(attributeName, attribute));
            }
            if (!(queryString = this.getQueryString()).contains("ok=1")) {
                queryString = queryString == null || "".equals(queryString) ? "?" : queryString + "&";
                queryString = queryString + "ok=1";
            }
            this.redirectPermanent(this.encoder.encode(attributeName) + queryString);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (AttributeNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAttributeValueException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        catch (MBeanException e) {
            throw new RuntimeException(e);
        }
        catch (ReflectionException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getTemplateName() {
        return this.templateName;
    }

    private Object filter(Object object) {
        if (this.attributeFilter != null) {
            return this.attributeFilter.filter(object);
        }
        return object;
    }
}

