/*
 * Decompiled with CFR 0.152.
 */
package org.jminix.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jminix.server.AbstractMapServerConnectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RmiServerConnectionProvider
extends AbstractMapServerConnectionProvider {
    private String serviceUrl;
    private String username;
    private String password;
    private Map<String, JMXConnector> jmxcs = new HashMap<String, JMXConnector>();

    @Override
    public List<String> getConnectionKeys() {
        String[] parts = this.serviceUrl.split("/");
        return Arrays.asList(parts[parts.length - 1]);
    }

    @Override
    public MBeanServerConnection getConnection(String name) {
        try {
            JMXServiceURL url = new JMXServiceURL(this.serviceUrl);
            JMXConnector jmxc = this.jmxcs.get(this.serviceUrl);
            if (jmxc == null) {
                if (this.username != null && this.password != null) {
                    String[] creds = new String[]{this.username, this.password};
                    HashMap<String, String[]> env = new HashMap<String, String[]>();
                    env.put("jmx.remote.credentials", creds);
                    jmxc = JMXConnectorFactory.connect(url, env);
                } else {
                    jmxc = JMXConnectorFactory.connect(url, null);
                }
                this.jmxcs.put(this.serviceUrl, jmxc);
            } else {
                jmxc.connect();
            }
            return jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

