/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.core;

import java.io.OutputStream;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.transazioni.DumpContenuto;
import org.openspcoop2.core.transazioni.DumpHeaderAllegato;
import org.openspcoop2.core.transazioni.DumpHeaderTrasporto;
import org.openspcoop2.core.transazioni.DumpMultipartHeader;
import org.openspcoop2.core.transazioni.constants.RuoloTransazione;
import org.openspcoop2.core.transazioni.constants.TipoAPI;
import org.openspcoop2.core.transazioni.utils.TransactionContentUtils;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.monitor.sdk.parameters.Parameter;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.xml.XMLUtils;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.core.contents.ContentType;
import org.openspcoop2.web.monitor.transazioni.core.contents.RisorsaType;
import org.openspcoop2.web.monitor.transazioni.core.header.HeaderType;
import org.openspcoop2.web.monitor.transazioni.core.header.ObjectFactory;
import org.openspcoop2.web.monitor.transazioni.core.manifest.DiagnosticaSerializationType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.ProtocolloType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.RuoloType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.SoggettoType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.TipoPortaType;
import org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType;
import org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ConsegnaType;
import org.openspcoop2.web.monitor.transazioni.core.search.FiltroContenuti;
import org.openspcoop2.web.monitor.transazioni.core.search.RicercaPersonalizzata;
import org.openspcoop2.web.monitor.transazioni.core.search.TipologiaRicercaTransazioniType;
import org.openspcoop2.web.monitor.transazioni.core.search.TipologiaTransazioniType;
import org.openspcoop2.web.monitor.transazioni.core.search.TransazioneType;
import org.slf4j.Logger;

public class UtilityTransazioni {
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final String FRUIZIONE = "Fruizione";
    private static final String EROGAZIONE = "Erogazione";
    private static final String ROUTER = "Router";
    private static final String IM = "I.M.";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_DIAG_SEPARATOR = "###";
    public static final String DIAGNOSTIC_WITH_DYNAMIC_INFO_TYPE_SEPARATOR = " ";

    public static String getHeaderTransazione(TransazioneBean t) {
        RuoloTransazione ruolo;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)t.getPddRuolo().toString())) {
            sb.append("Tipologia: ");
            switch (t.getPddRuolo()) {
                case APPLICATIVA: {
                    sb.append(EROGAZIONE);
                    break;
                }
                case DELEGATA: {
                    sb.append(FRUIZIONE);
                    break;
                }
                case INTEGRATION_MANAGER: {
                    sb.append(IM);
                    break;
                }
                case ROUTER: {
                    sb.append(ROUTER);
                }
            }
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getProtocollo())) {
            sb.append("Protocollo: ");
            sb.append(t.getProtocollo());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getPddCodice())) {
            sb.append("PdD (ID): ");
            sb.append(t.getPddCodice());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getPddTipoSoggetto()) && StringUtils.isNotEmpty((String)t.getPddNomeSoggetto())) {
            sb.append("PdD (Soggetto): ");
            sb.append(t.getPddTipoSoggetto()).append("/").append(t.getPddNomeSoggetto());
            sb.append("\n");
        }
        if (t.getEsito() >= 0) {
            sb.append("Esito: ");
            switch (t.getEsito()) {
                case 0: {
                    sb.append("Ok");
                    break;
                }
                case 1: {
                    sb.append("Errore Transazione Protocollo");
                    break;
                }
                case 2: {
                    sb.append("Errore Transazione Applicativa");
                    break;
                }
                case 4: {
                    sb.append("Errore Processamento PDD 4XX");
                    break;
                }
                case 5: {
                    sb.append("Errore Processamento PDD 5XX");
                    break;
                }
                case 6: {
                    sb.append("Autenticazione Fallita [IM]");
                    break;
                }
                case 7: {
                    sb.append("Autorizzazione Fallita [IM]");
                    break;
                }
                case 8: {
                    sb.append("Messaggi non Presenti [IM]");
                    break;
                }
                case 9: {
                    sb.append("Messaggio non Trovato [IM]");
                    break;
                }
                default: {
                    sb.append("Errore Generico");
                }
            }
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdportaSoggettoFruitore())) {
            sb.append("Fruitore (PdD ID): ");
            sb.append(t.getIdportaSoggettoFruitore());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getTipoSoggettoFruitore())) {
            sb.append("Fruitore (Soggetto): ");
            sb.append(t.getTipoSoggettoFruitore());
            sb.append("/");
            sb.append(t.getNomeSoggettoFruitore());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdportaSoggettoErogatore())) {
            sb.append("Erogatore (PdD ID): ");
            sb.append(t.getIdportaSoggettoErogatore());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getTipoSoggettoErogatore())) {
            sb.append("Erogatore (Soggetto): ");
            sb.append(t.getTipoSoggettoErogatore());
            sb.append("/");
            sb.append(t.getNomeSoggettoErogatore());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getTipoServizio())) {
            sb.append("Servizio: ");
            sb.append(t.getTipoServizio());
            sb.append("/");
            sb.append(t.getNomeServizio());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)("" + t.getVersioneServizio()))) {
            sb.append("Versione Servizio: ");
            sb.append(t.getVersioneServizio());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getAzione())) {
            sb.append("Azione: ");
            sb.append(t.getAzione());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdMessaggioRichiesta())) {
            sb.append("ID Messaggio richiesta: ");
            sb.append(t.getIdMessaggioRichiesta());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdMessaggioRisposta())) {
            sb.append("ID Messaggio risposta: ");
            sb.append(t.getIdMessaggioRisposta());
            sb.append("\n");
        }
        if (t.getRuoloTransazione() >= 0 && (ruolo = RuoloTransazione.toEnumConstant((int)t.getRuoloTransazione())) != null) {
            sb.append("Profilo: ");
            sb.append(ruolo.name());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdCollaborazione())) {
            sb.append("ID collaborazione: ");
            sb.append(t.getIdCollaborazione());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativa())) {
            sb.append("ID Applicativa Richiesta: ");
            sb.append(t.getIdCorrelazioneApplicativa());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativaRisposta())) {
            sb.append("ID Applicativa Risposta: ");
            sb.append(t.getIdCorrelazioneApplicativaRisposta());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getServizioApplicativoFruitore())) {
            sb.append("Servizio applicativo fruitore: ");
            sb.append(t.getServizioApplicativoFruitore());
            sb.append("\n");
        }
        if (StringUtils.isNotEmpty((String)t.getServizioApplicativoErogatore())) {
            sb.append("Servizio applicativo erogatore: ");
            sb.append(t.getServizioApplicativoErogatore());
            sb.append("\n");
        }
        if (sb.length() > 0) {
            sb.insert(0, "<!-- \n");
            sb.append(" -->\n\n");
        }
        return sb.toString();
    }

    public static void writeManifestTransazione(TransazioneBean t, OutputStream out) throws Exception {
        PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)LoggerManager.getPddMonitorCoreLogger());
        UtilityTransazioni.writeManifestTransazione(t, out, monitorProperties.isAttivoTransazioniDataAccettazione(), monitorProperties.isDataUscitaRispostaUseDateAfterResponseSent(), monitorProperties.isTransazioniLatenzaPortaEnabled());
    }

    public static void writeManifestTransazione(TransazioneBean t, OutputStream out, boolean isAttivoTransazioniDataAccettazione, boolean dataUscitaRispostaValorizzataDopoSpedizioneRisposta, boolean isTransazioniLatenzaPortaEnabled) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.manifest.ObjectFactory.class.getPackage().getName());
        Marshaller marshaller = jc.createMarshaller();
        org.openspcoop2.web.monitor.transazioni.core.manifest.ObjectFactory objFactory = new org.openspcoop2.web.monitor.transazioni.core.manifest.ObjectFactory();
        org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType transazione = new org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType();
        if (t.getStato() != null && StringUtils.isNotEmpty((String)t.getStato())) {
            transazione.setStato(UtilityTransazioni.escapeXmlValue(t.getStato()));
        }
        if (t.getRuoloTransazione() == -1) {
            transazione.setRuolo(RuoloType.SCONOSCIUTO);
        } else if (t.getRuoloTransazione() == 1) {
            transazione.setRuolo(RuoloType.INVOCAZIONE_ONEWAY);
        } else if (t.getRuoloTransazione() == 2) {
            transazione.setRuolo(RuoloType.INVOCAZIONE_SINCRONA);
        } else if (t.getRuoloTransazione() == 3) {
            transazione.setRuolo(RuoloType.INVOCAZIONE_ASINCRONA_SIMMETRICA);
        } else if (t.getRuoloTransazione() == 4) {
            transazione.setRuolo(RuoloType.RISPOSTA_ASINCRONA_SIMMETRICA);
        } else if (t.getRuoloTransazione() == 5) {
            transazione.setRuolo(RuoloType.INVOCAZIONE_ASINCRONA_ASIMMETRICA);
        } else if (t.getRuoloTransazione() == 6) {
            transazione.setRuolo(RuoloType.RICHIESTA_STATO_ASINCRONA_ASIMMETRICA);
        } else if (t.getRuoloTransazione() == 7) {
            transazione.setRuolo(RuoloType.INTEGRATION_MANAGER);
        }
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)t.getProtocollo());
        if (t.getEsito() >= 0) {
            TransazioneType.Esito esito = new TransazioneType.Esito();
            esito.setCodice(new BigInteger("" + t.getEsito()));
            esito.setValue(UtilityTransazioni.escapeXmlValue(esitiProperties.getEsitoLabel(Integer.valueOf(t.getEsito()))));
            if (t.getConsegneMultipleInCorso() > 0) {
                esito.setConsegneMultiple(new BigInteger("" + t.getConsegneMultipleInCorso()));
            }
            transazione.setEsito(esito);
        }
        if (t.getEsitoContesto() != null) {
            TransazioneType.Contesto contesto = new TransazioneType.Contesto();
            String code = t.getEsitoContesto();
            contesto.setCodice(code);
            boolean moreContext = esitiProperties.getEsitiTransactionContextCode().size() > 1;
            Object label = null;
            label = EsitoUtils.isFaseRequestIn((String)code) ? (String)(moreContext ? esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext((String)code)) + " - " : "") + "Richiesta ricevuta" : (EsitoUtils.isFaseRequestOut((String)code) ? (String)(moreContext ? esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext((String)code)) + " - " : "") + "Richiesta in consegna" : (EsitoUtils.isFaseResponseOut((String)code) ? (String)(moreContext ? esitiProperties.getEsitoTransactionContextLabel(EsitoUtils.getRawEsitoContext((String)code)) + " - " : "") + "Risposta in consegna" : esitiProperties.getEsitoTransactionContextLabel(code)));
            contesto.setValue(UtilityTransazioni.escapeXmlValue((String)label));
            transazione.setContesto(contesto);
        }
        UtilityTransazioni.fillProtocollo(t, transazione);
        if (t.getDataIngressoRichiesta() != null || t.getDataUscitaRichiesta() != null || t.getDataIngressoRisposta() != null || t.getDataUscitaRisposta() != null) {
            TransazioneType.TempiAttraversamento tempi = new TransazioneType.TempiAttraversamento();
            try {
                long latenza;
                if (isAttivoTransazioniDataAccettazione && t.getDataAccettazioneRichiesta() != null) {
                    tempi.setRichiestaAccettazione(XMLUtils.getInstance().toGregorianCalendar(t.getDataAccettazioneRichiesta()));
                }
                if (t.getDataIngressoRichiesta() != null) {
                    tempi.setRichiestaIngresso(XMLUtils.getInstance().toGregorianCalendar(t.getDataIngressoRichiesta()));
                }
                if (t.getDataIngressoRichiestaStream() != null) {
                    tempi.setRichiestaIngressoAcquisita(XMLUtils.getInstance().toGregorianCalendar(t.getDataIngressoRichiestaStream()));
                }
                if (t.getDataUscitaRichiesta() != null) {
                    tempi.setRichiestaUscita(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRichiesta()));
                }
                if (t.getDataUscitaRichiestaStream() != null) {
                    tempi.setRichiestaUscitaConsegnata(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRichiestaStream()));
                }
                if (isAttivoTransazioniDataAccettazione && t.getDataAccettazioneRisposta() != null) {
                    tempi.setRispostaAccettazione(XMLUtils.getInstance().toGregorianCalendar(t.getDataAccettazioneRisposta()));
                }
                if (t.getDataIngressoRisposta() != null) {
                    tempi.setRispostaIngresso(XMLUtils.getInstance().toGregorianCalendar(t.getDataIngressoRisposta()));
                }
                if (t.getDataIngressoRispostaStream() != null) {
                    tempi.setRispostaIngressoAcquisita(XMLUtils.getInstance().toGregorianCalendar(t.getDataIngressoRispostaStream()));
                }
                if (dataUscitaRispostaValorizzataDopoSpedizioneRisposta) {
                    if (t.getDataUscitaRispostaStream() != null) {
                        tempi.setRispostaUscita(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRispostaStream()));
                    }
                    if (t.getDataUscitaRisposta() != null) {
                        tempi.setRispostaUscitaConsegnata(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRisposta()));
                    }
                } else {
                    if (t.getDataUscitaRisposta() != null) {
                        tempi.setRispostaUscita(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRisposta()));
                    }
                    if (t.getDataUscitaRispostaStream() != null) {
                        tempi.setRispostaUscitaConsegnata(XMLUtils.getInstance().toGregorianCalendar(t.getDataUscitaRispostaStream()));
                    }
                }
                if (t.getDataUscitaRisposta() != null && t.getDataIngressoRichiesta() != null && (latenza = t.getDataUscitaRisposta().getTime() - t.getDataIngressoRichiesta().getTime()) >= 0L) {
                    tempi.setLatenzaTotale(latenza);
                }
                if (t.getDataUscitaRichiesta() != null && t.getDataIngressoRisposta() != null && (latenza = t.getDataIngressoRisposta().getTime() - t.getDataUscitaRichiesta().getTime()) >= 0L) {
                    tempi.setLatenzaServizio(latenza);
                }
                if (isTransazioniLatenzaPortaEnabled && tempi.getLatenzaTotale() != null && tempi.getLatenzaServizio() != null && (latenza = tempi.getLatenzaTotale() - tempi.getLatenzaServizio()) >= 0L) {
                    tempi.setLatenzaPorta(latenza);
                }
            }
            catch (Exception e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
            transazione.setTempiAttraversamento(tempi);
        }
        if (t.getRichiestaIngressoBytes() != null || t.getRichiestaUscitaBytes() != null || t.getRispostaIngressoBytes() != null || t.getRispostaUscitaBytes() != null) {
            TransazioneType.DimensioneMessaggi dm = new TransazioneType.DimensioneMessaggi();
            if (t.getRichiestaIngressoBytes() != null) {
                dm.setRichiestaIngresso(t.getRichiestaIngressoBytes());
            }
            if (t.getRichiestaUscitaBytes() != null) {
                dm.setRichiestaUscita(t.getRichiestaUscitaBytes());
            }
            if (t.getRispostaIngressoBytes() != null) {
                dm.setRispostaIngresso(t.getRispostaIngressoBytes());
            }
            if (t.getRispostaUscitaBytes() != null) {
                dm.setRispostaUscita(t.getRispostaUscitaBytes());
            }
            transazione.setDimensioneMessaggi(dm);
        }
        if (t.getPddCodice() != null && StringUtils.isNotEmpty((String)t.getPddCodice()) || t.getPddTipoSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddTipoSoggetto()) || t.getPddNomeSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddNomeSoggetto()) || t.getPddRuolo() != null || t.getClusterId() != null) {
            TransazioneType.Dominio dominio = new TransazioneType.Dominio();
            if (t.getPddCodice() != null && StringUtils.isNotEmpty((String)t.getPddCodice()) || t.getPddTipoSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddTipoSoggetto()) || t.getPddNomeSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddNomeSoggetto())) {
                SoggettoType soggetto = new SoggettoType();
                if (t.getPddTipoSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddTipoSoggetto())) {
                    soggetto.setTipo(UtilityTransazioni.escapeXmlValue(t.getPddTipoSoggetto()));
                }
                if (t.getPddNomeSoggetto() != null && StringUtils.isNotEmpty((String)t.getPddNomeSoggetto())) {
                    soggetto.setValue(UtilityTransazioni.escapeXmlValue(t.getPddNomeSoggetto()));
                }
                if (t.getPddCodice() != null && StringUtils.isNotEmpty((String)t.getPddCodice())) {
                    soggetto.setIdentificativoPorta(UtilityTransazioni.escapeXmlValue(t.getPddCodice()));
                }
                dominio.setSoggetto(soggetto);
            }
            if (t.getPddRuolo() != null) {
                switch (t.getPddRuolo()) {
                    case DELEGATA: {
                        dominio.setRuolo(TipoPortaType.DELEGATA);
                        break;
                    }
                    case APPLICATIVA: {
                        dominio.setRuolo(TipoPortaType.APPLICATIVA);
                        break;
                    }
                    case INTEGRATION_MANAGER: {
                        dominio.setRuolo(TipoPortaType.INTEGRATION_MANAGER);
                        break;
                    }
                    case ROUTER: {
                        dominio.setRuolo(TipoPortaType.ROUTER);
                    }
                }
            }
            dominio.setClusterId(t.getClusterId());
            transazione.setDominio(dominio);
        }
        UtilityTransazioni.fillDiagnostica(t, transazione);
        if (t.getIdCorrelazioneApplicativa() != null && StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativa()) || t.getIdCorrelazioneApplicativaRisposta() != null && StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativaRisposta())) {
            TransazioneType.CorrelazioneApplicativa correlazioneApplicativa = new TransazioneType.CorrelazioneApplicativa();
            if (t.getIdCorrelazioneApplicativa() != null && StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativa())) {
                correlazioneApplicativa.setIdRichiesta(UtilityTransazioni.escapeXmlValue(t.getIdCorrelazioneApplicativa()));
            }
            if (t.getIdCorrelazioneApplicativaRisposta() != null && StringUtils.isNotEmpty((String)t.getIdCorrelazioneApplicativaRisposta())) {
                correlazioneApplicativa.setIdRisposta(UtilityTransazioni.escapeXmlValue(t.getIdCorrelazioneApplicativaRisposta()));
            }
            transazione.setCorrelazioneApplicativa(correlazioneApplicativa);
        }
        if (t.getServizioApplicativoFruitore() != null && StringUtils.isNotEmpty((String)t.getServizioApplicativoFruitore())) {
            transazione.setServizioApplicativoFruitore(UtilityTransazioni.escapeXmlValue(t.getServizioApplicativoFruitore()));
        }
        if (t.getServizioApplicativoErogatore() != null && StringUtils.isNotEmpty((String)t.getServizioApplicativoErogatore())) {
            transazione.setServizioApplicativoErogatore(UtilityTransazioni.escapeXmlValue(t.getServizioApplicativoErogatore()));
        }
        if (t.getOperazioneIm() != null && StringUtils.isNotEmpty((String)t.getOperazioneIm())) {
            TransazioneType.IntegrationManager im = new TransazioneType.IntegrationManager();
            im.setOperazione(UtilityTransazioni.escapeXmlValue(t.getOperazioneIm()));
            transazione.setIntegrationManager(im);
        }
        if (t.getLocationRichiesta() != null && StringUtils.isNotEmpty((String)t.getLocationRichiesta()) || t.getLocationRisposta() != null && StringUtils.isNotEmpty((String)t.getLocationRisposta()) || t.getNomePorta() != null && StringUtils.isNotEmpty((String)t.getNomePorta()) || t.getCredenziali() != null && StringUtils.isNotEmpty((String)t.getCredenziali()) || t.getLocationConnettore() != null && StringUtils.isNotEmpty((String)t.getLocationConnettore())) {
            TransazioneType.DatiIntegrazione datiIntegrazione = new TransazioneType.DatiIntegrazione();
            if (t.getLocationRichiesta() != null && StringUtils.isNotEmpty((String)t.getLocationRichiesta())) {
                datiIntegrazione.setIndirizzoRichiesta(UtilityTransazioni.escapeXmlValue(t.getLocationRichiesta()));
            }
            if (t.getLocationRisposta() != null && StringUtils.isNotEmpty((String)t.getLocationRisposta())) {
                datiIntegrazione.setIndirizzoRisposta(UtilityTransazioni.escapeXmlValue(t.getLocationRisposta()));
            }
            if (t.getNomePorta() != null && StringUtils.isNotEmpty((String)t.getNomePorta())) {
                datiIntegrazione.setNomePorta(UtilityTransazioni.escapeXmlValue(t.getNomePorta()));
            }
            if (t.getCredenziali() != null && StringUtils.isNotEmpty((String)t.getCredenziali())) {
                datiIntegrazione.setCredenziali(UtilityTransazioni.escapeXmlValue(t.getCredenziali()));
            }
            if (t.getLocationConnettore() != null && StringUtils.isNotEmpty((String)t.getLocationConnettore())) {
                datiIntegrazione.setConnettore(UtilityTransazioni.escapeXmlValue(t.getLocationConnettore()));
            }
            if (t.getUrlInvocazione() != null && StringUtils.isNotEmpty((String)t.getUrlInvocazione())) {
                datiIntegrazione.setUrlInvocazione(UtilityTransazioni.escapeXmlValue(t.getUrlInvocazione()));
            }
            if (t.getSocketClientAddress() != null && StringUtils.isNotEmpty((String)t.getSocketClientAddress())) {
                datiIntegrazione.setIndirizzoClient(UtilityTransazioni.escapeXmlValue(t.getSocketClientAddress()));
            }
            if (t.getTransportClientAddress() != null && StringUtils.isNotEmpty((String)t.getTransportClientAddress())) {
                datiIntegrazione.setXForwardedFor(UtilityTransazioni.escapeXmlValue(t.getTransportClientAddress()));
            }
            if (t.getTipoRichiesta() != null && StringUtils.isNotEmpty((String)t.getTipoRichiesta())) {
                datiIntegrazione.setTipoRichiesta(UtilityTransazioni.escapeXmlValue(t.getTipoRichiesta()));
            }
            if (t.getCodiceRispostaIngresso() != null && StringUtils.isNotEmpty((String)t.getCodiceRispostaIngresso())) {
                datiIntegrazione.setCodiceRispostaIngresso(UtilityTransazioni.escapeXmlValue(t.getCodiceRispostaIngresso()));
            }
            if (t.getCodiceRispostaUscita() != null && StringUtils.isNotEmpty((String)t.getCodiceRispostaUscita())) {
                datiIntegrazione.setCodiceRispostaUscita(UtilityTransazioni.escapeXmlValue(t.getCodiceRispostaUscita()));
            }
            if (StringUtils.isNotEmpty((String)t.getTrasportoMittenteLabel())) {
                datiIntegrazione.setIdentificativoAutenticato(UtilityTransazioni.escapeXmlValue(t.getTrasportoMittenteLabel()));
            }
            if (StringUtils.isNotEmpty((String)t.getTokenIssuerLabel())) {
                datiIntegrazione.setTokenIssuer(UtilityTransazioni.escapeXmlValue(t.getTokenIssuerLabel()));
            }
            if (StringUtils.isNotEmpty((String)t.getTokenClientIdLabel())) {
                datiIntegrazione.setTokenClientId(UtilityTransazioni.escapeXmlValue(t.getTokenClientIdLabel()));
            }
            if (StringUtils.isNotEmpty((String)t.getTokenSubjectLabel())) {
                datiIntegrazione.setTokenSubject(UtilityTransazioni.escapeXmlValue(t.getTokenSubjectLabel()));
            }
            if (StringUtils.isNotEmpty((String)t.getTokenUsernameLabel())) {
                datiIntegrazione.setTokenUsername(UtilityTransazioni.escapeXmlValue(t.getTokenUsernameLabel()));
            }
            if (StringUtils.isNotEmpty((String)t.getTokenMailLabel())) {
                datiIntegrazione.setTokenEMail(UtilityTransazioni.escapeXmlValue(t.getTokenMailLabel()));
            }
            transazione.setDatiIntegrazione(datiIntegrazione);
        }
        if (t.getTokenClient() != null) {
            TransazioneType.ServizioApplicativoToken sa = new TransazioneType.ServizioApplicativoToken();
            sa.setNome(t.getTokenClient().getNome());
            sa.setTipoSoggetto(t.getTokenClient().getIdSoggettoProprietario().getTipo());
            sa.setNomeSoggetto(t.getTokenClient().getIdSoggettoProprietario().getNome());
            transazione.setServizioApplicativoToken(sa);
        }
        if (t.getEventiGestione() != null && StringUtils.isNotEmpty((String)t.getEventiGestione())) {
            transazione.setEventiGestione(UtilityTransazioni.escapeXmlValue(t.getEventiGestione()));
        }
        transazione.setUuid(t.getIdTransazione());
        marshaller.marshal(objFactory.createTransazione(transazione), out);
    }

    private static void fillProtocollo(TransazioneBean t, org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType transazione) throws Exception {
        SoggettoType soggetto;
        ProtocolloType protocollo = null;
        if (t.getTipoSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getTipoSoggettoFruitore()) || t.getNomeSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getNomeSoggettoFruitore()) || t.getIdportaSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getIdportaSoggettoFruitore()) || t.getIndirizzoSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getIndirizzoSoggettoFruitore())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            soggetto = new SoggettoType();
            if (t.getTipoSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getTipoSoggettoFruitore())) {
                soggetto.setTipo(UtilityTransazioni.escapeXmlValue(t.getTipoSoggettoFruitore()));
            }
            if (t.getNomeSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getNomeSoggettoFruitore())) {
                soggetto.setValue(UtilityTransazioni.escapeXmlValue(t.getNomeSoggettoFruitore()));
            }
            if (t.getIdportaSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getIdportaSoggettoFruitore())) {
                soggetto.setIdentificativoPorta(UtilityTransazioni.escapeXmlValue(t.getIdportaSoggettoFruitore()));
            }
            if (t.getIndirizzoSoggettoFruitore() != null && StringUtils.isNotEmpty((String)t.getIndirizzoSoggettoFruitore())) {
                soggetto.setIndirizzo(UtilityTransazioni.escapeXmlValue(t.getIndirizzoSoggettoFruitore()));
            }
            protocollo.setFruitore(soggetto);
        }
        if (t.getTipoSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getTipoSoggettoErogatore()) || t.getNomeSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getNomeSoggettoErogatore()) || t.getIdportaSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getIdportaSoggettoErogatore()) || t.getIndirizzoSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getIndirizzoSoggettoErogatore())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            soggetto = new SoggettoType();
            if (t.getTipoSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getTipoSoggettoErogatore())) {
                soggetto.setTipo(UtilityTransazioni.escapeXmlValue(t.getTipoSoggettoErogatore()));
            }
            if (t.getNomeSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getNomeSoggettoErogatore())) {
                soggetto.setValue(UtilityTransazioni.escapeXmlValue(t.getNomeSoggettoErogatore()));
            }
            if (t.getIdportaSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getIdportaSoggettoErogatore())) {
                soggetto.setIdentificativoPorta(UtilityTransazioni.escapeXmlValue(t.getIdportaSoggettoErogatore()));
            }
            if (t.getIndirizzoSoggettoErogatore() != null && StringUtils.isNotEmpty((String)t.getIndirizzoSoggettoErogatore())) {
                soggetto.setIndirizzo(UtilityTransazioni.escapeXmlValue(t.getIndirizzoSoggettoErogatore()));
            }
            protocollo.setErogatore(soggetto);
        }
        if (t.getTipoServizio() != null && StringUtils.isNotEmpty((String)t.getTipoServizio()) || t.getNomeServizio() != null && StringUtils.isNotEmpty((String)t.getNomeServizio()) || t.getVersioneServizio() > 0) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            ProtocolloType.Servizio servizio = new ProtocolloType.Servizio();
            if (t.getTipoServizio() != null && StringUtils.isNotEmpty((String)t.getTipoServizio())) {
                servizio.setTipo(UtilityTransazioni.escapeXmlValue(t.getTipoServizio()));
            }
            if (t.getNomeServizio() != null && StringUtils.isNotEmpty((String)t.getNomeServizio())) {
                servizio.setValue(UtilityTransazioni.escapeXmlValue(t.getNomeServizio()));
            }
            if (t.getVersioneServizio() > 0) {
                servizio.setVersione("" + t.getVersioneServizio());
            }
            protocollo.setServizio(servizio);
        }
        if (t.getAzione() != null && StringUtils.isNotEmpty((String)t.getAzione())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            protocollo.setAzione(UtilityTransazioni.escapeXmlValue(t.getAzione()));
        }
        TipoAPI tipoApi = null;
        if (t.getTipoApi() > 0) {
            tipoApi = TipoAPI.toEnumConstant((int)t.getTipoApi());
        }
        if (tipoApi != null || t.getUriAccordoServizio() != null && !"".equals(t.getUriAccordoServizio())) {
            ProtocolloType.Api api = new ProtocolloType.Api();
            if (tipoApi != null) {
                api.setTipo(tipoApi.name());
            }
            if (t.getUriAccordoServizio() != null && !"".equals(t.getUriAccordoServizio())) {
                api.setNome(t.getUriAccordoServizio());
            }
            if (t.getGruppi() != null && !"".equals(t.getGruppi())) {
                ProtocolloType.Api.Tags tags = new ProtocolloType.Api.Tags();
                String tmp = t.getGruppi().trim();
                if (tmp.contains(",")) {
                    String[] split = tmp.split(",");
                    if (split != null && split.length > 0) {
                        for (int i = 0; i < split.length; ++i) {
                            tags.getTag().add(split[i].trim());
                        }
                    }
                } else {
                    tags.getTag().add(tmp);
                }
                api.setTags(tags);
            }
            protocollo.setApi(api);
        }
        if (t.getIdMessaggioRichiesta() != null && StringUtils.isNotEmpty((String)t.getIdMessaggioRichiesta()) || t.getIdMessaggioRisposta() != null && StringUtils.isNotEmpty((String)t.getIdMessaggioRisposta()) || t.getDataIdMsgRichiesta() != null || t.getDataIdMsgRisposta() != null) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            if (t.getIdMessaggioRichiesta() != null && StringUtils.isNotEmpty((String)t.getIdMessaggioRichiesta())) {
                protocollo.setIdMessaggioRichiesta(UtilityTransazioni.escapeXmlValue(t.getIdMessaggioRichiesta()));
            }
            if (t.getIdMessaggioRisposta() != null && StringUtils.isNotEmpty((String)t.getIdMessaggioRisposta())) {
                protocollo.setIdMessaggioRisposta(UtilityTransazioni.escapeXmlValue(t.getIdMessaggioRisposta()));
            }
            try {
                if (t.getDataIdMsgRichiesta() != null) {
                    protocollo.setDataIdMsgRichiesta(XMLUtils.getInstance().toGregorianCalendar(t.getDataIdMsgRichiesta()));
                }
                if (t.getDataIdMsgRisposta() != null) {
                    protocollo.setDataIdMsgRisposta(XMLUtils.getInstance().toGregorianCalendar(t.getDataIdMsgRisposta()));
                }
            }
            catch (Exception e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
        }
        if (t.getProfiloCollaborazioneProt() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneProt()) || t.getProfiloCollaborazioneOp2() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneOp2()) || t.getIdCollaborazione() != null && StringUtils.isNotEmpty((String)t.getIdCollaborazione()) || t.getUriAccordoServizio() != null && StringUtils.isNotEmpty((String)t.getUriAccordoServizio())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            if (t.getProfiloCollaborazioneProt() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneProt()) || t.getProfiloCollaborazioneOp2() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneOp2())) {
                ProtocolloType.Profilo profilo = new ProtocolloType.Profilo();
                if (t.getProfiloCollaborazioneProt() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneProt())) {
                    profilo.setValue(UtilityTransazioni.escapeXmlValue(t.getProfiloCollaborazioneProt()));
                }
                if (t.getProfiloCollaborazioneOp2() != null && StringUtils.isNotEmpty((String)t.getProfiloCollaborazioneOp2())) {
                    profilo.setCodice(UtilityTransazioni.escapeXmlValue(t.getProfiloCollaborazioneOp2()));
                }
                protocollo.setProfilo(profilo);
            }
            if (t.getIdCollaborazione() != null && StringUtils.isNotEmpty((String)t.getIdCollaborazione())) {
                protocollo.setIdCollaborazione(UtilityTransazioni.escapeXmlValue(t.getIdCollaborazione()));
            }
            if (t.getUriAccordoServizio() != null && StringUtils.isNotEmpty((String)t.getUriAccordoServizio())) {
                protocollo.setUriAccordoServizio(UtilityTransazioni.escapeXmlValue(t.getUriAccordoServizio()));
            }
        }
        if (t.getIdAsincrono() != null && StringUtils.isNotEmpty((String)t.getIdAsincrono()) || t.getTipoServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getTipoServizioCorrelato()) || t.getNomeServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getNomeServizioCorrelato())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            ProtocolloType.ProfiloAsincrono profiloAsincrono = new ProtocolloType.ProfiloAsincrono();
            if (t.getIdAsincrono() != null && StringUtils.isNotEmpty((String)t.getIdAsincrono())) {
                profiloAsincrono.setIdCorrelazione(UtilityTransazioni.escapeXmlValue(t.getIdAsincrono()));
            }
            if (t.getTipoServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getTipoServizioCorrelato()) || t.getNomeServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getNomeServizioCorrelato())) {
                ProtocolloType.ProfiloAsincrono.ServizioCorrelato servizioCorrelato = new ProtocolloType.ProfiloAsincrono.ServizioCorrelato();
                if (t.getTipoServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getTipoServizioCorrelato())) {
                    servizioCorrelato.setTipo(UtilityTransazioni.escapeXmlValue(t.getTipoServizioCorrelato()));
                }
                if (t.getNomeServizioCorrelato() != null && StringUtils.isNotEmpty((String)t.getNomeServizioCorrelato())) {
                    servizioCorrelato.setValue(UtilityTransazioni.escapeXmlValue(t.getNomeServizioCorrelato()));
                }
                profiloAsincrono.setServizioCorrelato(servizioCorrelato);
            }
            protocollo.setProfiloAsincrono(profiloAsincrono);
        }
        if (t.getDigestRichiesta() != null && StringUtils.isNotEmpty((String)t.getDigestRichiesta()) || t.getDigestRisposta() != null && StringUtils.isNotEmpty((String)t.getDigestRisposta())) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            ProtocolloType.Digest digest = new ProtocolloType.Digest();
            if (t.getDigestRichiesta() != null && StringUtils.isNotEmpty((String)t.getDigestRichiesta())) {
                digest.setRichiesta(t.getDigestRichiesta());
            }
            if (t.getDigestRisposta() != null && StringUtils.isNotEmpty((String)t.getDigestRisposta())) {
                digest.setRisposta(t.getDigestRisposta());
            }
            protocollo.setDigest(digest);
        }
        if (t.getDuplicatiRichiesta() >= 0 || t.getDuplicatiRisposta() >= 0) {
            if (protocollo == null) {
                protocollo = new ProtocolloType();
            }
            ProtocolloType.Duplicati duplicati = new ProtocolloType.Duplicati();
            if (t.getDuplicatiRichiesta() >= 0) {
                duplicati.setRichiesta(t.getDuplicatiRichiesta());
            }
            if (t.getDuplicatiRisposta() >= 0) {
                duplicati.setRisposta(t.getDuplicatiRisposta());
            }
            protocollo.setDuplicati(duplicati);
        }
        if (protocollo != null) {
            protocollo.setName(t.getProtocollo());
            transazione.setProtocollo(protocollo);
        }
    }

    private static String buildInfoDiagnosticaOptimized(String info) {
        if (info == null) {
            return null;
        }
        String[] split = info.split(DIAGNOSTIC_WITH_DYNAMIC_INFO_DIAG_SEPARATOR);
        if (split != null && split.length > 0) {
            Integer count;
            HashMap<String, Integer> counters = new HashMap<String, Integer>();
            for (int i = 0; i < split.length; ++i) {
                String tipo;
                String[] tmp;
                if (split[i] == null || "".equals(split[i].trim()) || (tmp = split[i].trim().split(DIAGNOSTIC_WITH_DYNAMIC_INFO_TYPE_SEPARATOR)) == null || tmp.length <= 0 || tmp[0] == null || "".equals(tipo = tmp[0].trim())) continue;
                count = (Integer)counters.remove(tipo);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                counters.put(tipo, count);
            }
            if (counters.size() > 0) {
                StringBuilder bf = new StringBuilder();
                for (String tipo : counters.keySet()) {
                    count = (Integer)counters.get(tipo);
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append(tipo).append(":").append(count);
                }
                return bf.toString();
            }
        }
        return null;
    }

    private static void fillDiagnostica(TransazioneBean t, org.openspcoop2.web.monitor.transazioni.core.manifest.TransazioneType transazione) {
        String errorDiagnosticaMsg = " ... \nPer maggiori dettagli consultare i log della PdD";
        TransazioneType.Diagnostica diagnostica = new TransazioneType.Diagnostica();
        if (t.getDiagnostici() != null && StringUtils.isNotEmpty((String)t.getDiagnostici())) {
            if (t.getDiagnostici().startsWith("-")) {
                diagnostica.setMessaggi(DiagnosticaSerializationType.OPTIMIZED_NOT_FOUND);
            } else if (t.getDiagnostici().startsWith("N")) {
                diagnostica.setMessaggi(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setMessaggiErroreSerializzazione(t.getDiagnostici() + errorDiagnosticaMsg);
            } else if (t.getDiagnostici().startsWith("R")) {
                diagnostica.setMessaggi(DiagnosticaSerializationType.OPTIMIZED);
            } else {
                diagnostica.setMessaggi(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setMessaggiErroreSerializzazione(t.getDiagnostici() + errorDiagnosticaMsg);
            }
            diagnostica.setMessaggiInfoSerializzazione(UtilityTransazioni.buildInfoDiagnosticaOptimized(t.getDiagnosticiExt()));
        } else {
            diagnostica.setMessaggi(DiagnosticaSerializationType.STANDARD);
        }
        if (t.getTracciaRichiesta() != null && StringUtils.isNotEmpty((String)t.getTracciaRichiesta())) {
            if (t.getTracciaRichiesta().startsWith("-")) {
                diagnostica.setTracciaRichiesta(DiagnosticaSerializationType.OPTIMIZED_NOT_FOUND);
            } else if (t.getTracciaRichiesta().startsWith("N")) {
                diagnostica.setTracciaRichiesta(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setTracciaRichiestaErroreSerializzazione(t.getTracciaRichiesta() + errorDiagnosticaMsg);
            } else if (t.getTracciaRichiesta().startsWith("R")) {
                diagnostica.setTracciaRichiesta(DiagnosticaSerializationType.OPTIMIZED);
            } else {
                diagnostica.setTracciaRichiesta(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setTracciaRichiestaErroreSerializzazione(t.getTracciaRichiesta() + errorDiagnosticaMsg);
            }
        } else {
            diagnostica.setTracciaRichiesta(DiagnosticaSerializationType.STANDARD);
        }
        if (t.getTracciaRisposta() != null && StringUtils.isNotEmpty((String)t.getTracciaRisposta())) {
            if (t.getTracciaRisposta().startsWith("-")) {
                diagnostica.setTracciaRisposta(DiagnosticaSerializationType.OPTIMIZED_NOT_FOUND);
            } else if (t.getTracciaRisposta().startsWith("N")) {
                diagnostica.setTracciaRisposta(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setTracciaRispostaErroreSerializzazione(t.getTracciaRisposta() + errorDiagnosticaMsg);
            } else if (t.getTracciaRisposta().startsWith("R")) {
                diagnostica.setTracciaRisposta(DiagnosticaSerializationType.OPTIMIZED);
            } else {
                diagnostica.setTracciaRisposta(DiagnosticaSerializationType.OPTIMIZED_ERROR);
                diagnostica.setTracciaRispostaErroreSerializzazione(t.getTracciaRisposta() + errorDiagnosticaMsg);
            }
        } else {
            diagnostica.setTracciaRisposta(DiagnosticaSerializationType.STANDARD);
        }
        transazione.setDiagnostica(diagnostica);
    }

    public static String getExtension(String formato) {
        MessageType messageType = MessageType.BINARY;
        if (StringUtils.isNotEmpty((String)formato)) {
            messageType = MessageType.valueOf((String)formato);
        }
        switch (messageType) {
            case BINARY: 
            case MIME_MULTIPART: {
                return "bin";
            }
            case JSON: {
                return "json";
            }
            case SOAP_11: 
            case SOAP_12: 
            case XML: {
                return "xml";
            }
        }
        return "bin";
    }

    public static void writeManifestTransazioneApplicativoServer(TransazioneBean t, TransazioneApplicativoServerBean tAS, OutputStream out) throws Exception {
        PddMonitorProperties monitorProperties = PddMonitorProperties.getInstance((Logger)LoggerManager.getPddMonitorCoreLogger());
        UtilityTransazioni.writeManifestTransazioneApplicativoServer(t, tAS, out, monitorProperties.isAttivoTransazioniDataAccettazione());
    }

    public static void writeManifestTransazioneApplicativoServer(TransazioneBean tr, TransazioneApplicativoServerBean tAS, OutputStream out, boolean isAttivoTransazioniDataAccettazione) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ObjectFactory.class.getPackage().getName());
        Marshaller marshaller = jc.createMarshaller();
        org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ObjectFactory objFactory = new org.openspcoop2.web.monitor.transazioni.core.manifest_consegna.ObjectFactory();
        ConsegnaType consegna = new ConsegnaType();
        ConsegnaType.Esito esito = new ConsegnaType.Esito();
        EsitiProperties esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)LoggerManager.getPddMonitorCoreLogger(), (String)tr.getProtocollo());
        if (tAS.getDettaglioEsito() >= 0) {
            ConsegnaType.Esito.DettaglioEsito dettaglioEsito = new ConsegnaType.Esito.DettaglioEsito();
            dettaglioEsito.setCodice(new BigInteger("" + tAS.getDettaglioEsito()));
            dettaglioEsito.setValue(UtilityTransazioni.escapeXmlValue(esitiProperties.getEsitoLabel(Integer.valueOf(tAS.getDettaglioEsito()))));
            esito.setDettaglioEsito(dettaglioEsito);
        }
        esito.setConsegnaTerminata(tAS.getConsegnaTerminata());
        if (tAS.getDataMessaggioScaduto() != null) {
            esito.setDataMessaggioScaduto(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataMessaggioScaduto()));
        }
        esito.setConsegnaTrasparente(tAS.isConsegnaTrasparente());
        esito.setConsegnaIntegrationManager(tAS.isConsegnaIntegrationManager());
        consegna.setEsito(esito);
        if (tAS.getDataUscitaRichiesta() != null || tAS.getDataIngressoRisposta() != null) {
            ConsegnaType.TempiAttraversamento tempi = new ConsegnaType.TempiAttraversamento();
            try {
                long latenza;
                if (isAttivoTransazioniDataAccettazione && tAS.getDataAccettazioneRichiesta() != null) {
                    tempi.setRichiestaAccettazione(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataAccettazioneRichiesta()));
                }
                if (tAS.getDataUscitaRichiesta() != null) {
                    tempi.setRichiestaUscita(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataUscitaRichiesta()));
                }
                if (tAS.getDataUscitaRichiestaStream() != null) {
                    tempi.setRichiestaUscitaConsegnata(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataUscitaRichiestaStream()));
                }
                if (isAttivoTransazioniDataAccettazione && tAS.getDataAccettazioneRisposta() != null) {
                    tempi.setRispostaAccettazione(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataAccettazioneRisposta()));
                }
                if (tAS.getDataIngressoRisposta() != null) {
                    tempi.setRispostaIngresso(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataIngressoRisposta()));
                }
                if (tAS.getDataIngressoRispostaStream() != null) {
                    tempi.setRispostaIngressoAcquisita(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataIngressoRispostaStream()));
                }
                if (tAS.getDataUscitaRichiesta() != null && tAS.getDataIngressoRisposta() != null && (latenza = tAS.getDataIngressoRisposta().getTime() - tAS.getDataUscitaRichiesta().getTime()) >= 0L) {
                    tempi.setLatenzaServizio(latenza);
                }
            }
            catch (Exception e) {
                throw new JAXBException(e.getMessage(), (Throwable)e);
            }
            consegna.setTempiAttraversamento(tempi);
        }
        if (tAS.getRichiestaUscitaBytes() != null || tAS.getRispostaIngressoBytes() != null) {
            ConsegnaType.DimensioneMessaggi dm = new ConsegnaType.DimensioneMessaggi();
            if (tAS.getRichiestaUscitaBytes() != null) {
                dm.setRichiestaUscita(tAS.getRichiestaUscitaBytes());
            }
            if (tAS.getRispostaIngressoBytes() != null) {
                dm.setRispostaIngresso(tAS.getRispostaIngressoBytes());
            }
            consegna.setDimensioneMessaggi(dm);
        }
        if (tAS.isConsegnaTrasparente()) {
            ConsegnaType.DatiConsegna datiConsegna = new ConsegnaType.DatiConsegna();
            if (tAS.getUltimoErrore() != null && !"".equals(tAS.getUltimoErrore())) {
                ConsegnaType.DatiConsegna.UltimoErrore ultimoErrore = new ConsegnaType.DatiConsegna.UltimoErrore();
                ultimoErrore.setDettaglio(UtilityTransazioni.escapeXmlValue(tAS.getUltimoErrore()));
                if (tAS.getDettaglioEsitoUltimoErrore() >= 0) {
                    ConsegnaType.DatiConsegna.UltimoErrore.DettaglioEsito dettaglioEsito = new ConsegnaType.DatiConsegna.UltimoErrore.DettaglioEsito();
                    dettaglioEsito.setCodice(new BigInteger("" + tAS.getDettaglioEsitoUltimoErrore()));
                    dettaglioEsito.setValue(UtilityTransazioni.escapeXmlValue(esitiProperties.getEsitoLabel(Integer.valueOf(tAS.getDettaglioEsitoUltimoErrore()))));
                    ultimoErrore.setDettaglioEsito(dettaglioEsito);
                }
                if (tAS.getLocationUltimoErrore() != null && !"".equals(tAS.getLocationUltimoErrore())) {
                    ultimoErrore.setConnettore(UtilityTransazioni.escapeXmlValue(tAS.getLocationUltimoErrore()));
                }
                if (tAS.getCodiceRispostaUltimoErrore() != null && !"".equals(tAS.getCodiceRispostaUltimoErrore())) {
                    ultimoErrore.setCodiceRisposta(UtilityTransazioni.escapeXmlValue(tAS.getCodiceRispostaUltimoErrore()));
                }
                if (tAS.getDataUltimoErrore() != null) {
                    ultimoErrore.setData(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataUltimoErrore()));
                }
                if (tAS.getClusterIdUltimoErrore() != null && !"".equals(tAS.getClusterIdUltimoErrore())) {
                    ultimoErrore.setClusterId(UtilityTransazioni.escapeXmlValue(tAS.getClusterIdUltimoErrore()));
                }
                datiConsegna.setUltimoErrore(ultimoErrore);
            }
            if (tAS.getLocationConnettore() != null && !"".equals(tAS.getLocationConnettore())) {
                datiConsegna.setConnettore(UtilityTransazioni.escapeXmlValue(tAS.getLocationConnettore()));
            }
            if (tAS.getCodiceRisposta() != null && !"".equals(tAS.getCodiceRisposta())) {
                datiConsegna.setCodiceRisposta(UtilityTransazioni.escapeXmlValue(tAS.getCodiceRisposta()));
            }
            if (tAS.getDataPrimoTentativo() != null) {
                datiConsegna.setDataPrimoTentativo(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataPrimoTentativo()));
            }
            if (tAS.getNumeroTentativi() >= 0) {
                datiConsegna.setNumeroTentativi(new BigInteger("" + tAS.getNumeroTentativi()));
            }
            if (tAS.getClusterIdConsegna() != null && !"".equals(tAS.getClusterIdConsegna())) {
                datiConsegna.setClusterIdConsegna(UtilityTransazioni.escapeXmlValue(tAS.getClusterIdConsegna()));
            }
            consegna.setDatiConsegna(datiConsegna);
        }
        if (tAS.isConsegnaIntegrationManager()) {
            ConsegnaType.DatiIntegrationManager datiIM = new ConsegnaType.DatiIntegrationManager();
            if (tAS.getDataPrimoPrelievoIm() != null) {
                datiIM.setDataPrimoPrelievo(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataPrimoPrelievoIm()));
            }
            if (tAS.getDataPrelievoIm() != null) {
                datiIM.setDataPrelievo(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataPrelievoIm()));
            }
            if (tAS.getNumeroPrelieviIm() >= 0) {
                datiIM.setNumeroPrelievi(new BigInteger("" + tAS.getNumeroPrelieviIm()));
            }
            if (tAS.getClusterIdPrelievoIm() != null && !"".equals(tAS.getClusterIdPrelievoIm())) {
                datiIM.setClusterIdPrelievo(UtilityTransazioni.escapeXmlValue(tAS.getClusterIdPrelievoIm()));
            }
            if (tAS.getDataEliminazioneIm() != null) {
                datiIM.setDataEliminazione(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataEliminazioneIm()));
            }
            if (tAS.getClusterIdEliminazioneIm() != null && !"".equals(tAS.getClusterIdEliminazioneIm())) {
                datiIM.setClusterIdEliminazione(UtilityTransazioni.escapeXmlValue(tAS.getClusterIdEliminazioneIm()));
            }
            consegna.setDatiIntegrationManager(datiIM);
        }
        consegna.setIdTransazione(UtilityTransazioni.escapeXmlValue(tAS.getIdTransazione()));
        consegna.setServizioApplicativoErogatore(UtilityTransazioni.escapeXmlValue(tAS.getServizioApplicativoErogatore()));
        if (tAS.getConnettoreNome() != null && !"".equals(tAS.getConnettoreNome())) {
            consegna.setNomeConnettore(UtilityTransazioni.escapeXmlValue(tAS.getConnettoreNome()));
        }
        if (tAS.getDataRegistrazione() != null) {
            consegna.setDataRegistrazione(XMLUtils.getInstance().toGregorianCalendar(tAS.getDataRegistrazione()));
        }
        if (tAS.getIdentificativoMessaggio() != null && !"".equals(tAS.getIdentificativoMessaggio())) {
            consegna.setIdentificativoMessaggio(UtilityTransazioni.escapeXmlValue(tAS.getIdentificativoMessaggio()));
        }
        if (tAS.getClusterIdPresaInCarico() != null && !"".equals(tAS.getClusterIdPresaInCarico())) {
            consegna.setClusterIdInCoda(UtilityTransazioni.escapeXmlValue(tAS.getClusterIdPresaInCarico()));
        }
        marshaller.marshal(objFactory.createConsegna(consegna), out);
    }

    private static String convertSize(Long value) {
        MessageFormat mf = new MessageFormat("{0,number,#.##}");
        Double len = null;
        Object res = "";
        len = value.doubleValue();
        long d = Math.round(len / 1024.0);
        if (d <= 1L) {
            Object[] objs = new Object[]{len};
            res = mf.format(objs);
            res = (String)res + " B";
        } else if (d > 1L && d < 1000L) {
            Object[] objs = new Object[]{len / 1024.0};
            res = mf.format(objs);
            res = (String)res + " KB";
        } else {
            Object[] objs = new Object[]{len / 1048576.0};
            res = mf.format(objs);
            res = (String)res + " MB";
        }
        return res;
    }

    private static String escapeXmlValue(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    public static void writeSearchFilterXml(TransazioniSearchForm searchForm, OutputStream out) throws Exception {
        UtilityTransazioni.writeSearchFilterXml(searchForm, null, null, out);
    }

    public static void writeSearchFilterXml(TransazioniSearchForm searchForm, List<String> idTransazioni, Integer totTransazioni, OutputStream out) throws Exception {
        JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.search.ObjectFactory.class.getPackage().getName());
        Marshaller marshaller = jc.createMarshaller();
        org.openspcoop2.web.monitor.transazioni.core.search.ObjectFactory objFactory = new org.openspcoop2.web.monitor.transazioni.core.search.ObjectFactory();
        TransazioneType transazione = new TransazioneType();
        if (searchForm.getTipologiaTransazioneSPCoop() == null || searchForm.getTipologiaTransazioneSPCoop().getValue() == null) {
            transazione.setTipologiaTransazioni(TipologiaTransazioniType.PROXY_TRASPARENTE_INTEGRATION_MANAGER);
        } else if (searchForm.getTipologiaTransazioneSPCoop().getValue().booleanValue()) {
            transazione.setTipologiaTransazioni(TipologiaTransazioniType.PROXY_TRASPARENTE);
        } else {
            transazione.setTipologiaTransazioni(TipologiaTransazioniType.INTEGRATION_MANAGER);
        }
        if (searchForm.getTipologiaRicercaEnum() == null) {
            transazione.setTipologiaRicercaTransazioni(TipologiaRicercaTransazioniType.EROGAZIONE_FRUIZIONE);
        } else {
            switch (searchForm.getTipologiaRicercaEnum()) {
                case ingresso: {
                    transazione.setTipologiaRicercaTransazioni(TipologiaRicercaTransazioniType.EROGAZIONE);
                    break;
                }
                case uscita: {
                    transazione.setTipologiaRicercaTransazioni(TipologiaRicercaTransazioniType.FRUIZIONE);
                    break;
                }
                default: {
                    transazione.setTipologiaRicercaTransazioni(TipologiaRicercaTransazioniType.EROGAZIONE_FRUIZIONE);
                }
            }
        }
        TransazioneType.Periodo periodo = new TransazioneType.Periodo();
        periodo.setDataInizio(XMLUtils.getInstance().toGregorianCalendar(searchForm.getDataInizio()));
        periodo.setDataFine(XMLUtils.getInstance().toGregorianCalendar(searchForm.getDataFine()));
        transazione.setPeriodo(periodo);
        if (StringUtils.isNotEmpty((String)searchForm.getProtocollo())) {
            transazione.setProtocollo(UtilityTransazioni.escapeXmlValue(searchForm.getProtocollo()));
        }
        if (StringUtils.isNotEmpty((String)searchForm.getSoggettoLocale())) {
            TransazioneType.SoggettoLocale soggettoLocale = new TransazioneType.SoggettoLocale();
            soggettoLocale.setTipo(searchForm.getTipoSoggettoLocale());
            soggettoLocale.setValue(UtilityTransazioni.escapeXmlValue(searchForm.getSoggettoLocale()));
            transazione.setSoggettoLocale(soggettoLocale);
        }
        if (TipologiaRicerca.all.equals((Object)searchForm.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)searchForm.getTrafficoPerSoggetto())) {
            TransazioneType.SoggettoRemoto soggettoRemoto = new TransazioneType.SoggettoRemoto();
            soggettoRemoto.setTipo(searchForm.getTipoTrafficoPerSoggetto());
            soggettoRemoto.setValue(UtilityTransazioni.escapeXmlValue(searchForm.getTrafficoPerSoggetto()));
            transazione.setSoggettoRemoto(soggettoRemoto);
        }
        if (TipologiaRicerca.ingresso.equals((Object)searchForm.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)searchForm.getNomeMittente())) {
            TransazioneType.SoggettoMittente soggettoMittente = new TransazioneType.SoggettoMittente();
            soggettoMittente.setTipo(searchForm.getTipoMittente());
            soggettoMittente.setValue(UtilityTransazioni.escapeXmlValue(searchForm.getNomeMittente()));
            transazione.setSoggettoMittente(soggettoMittente);
        }
        if (TipologiaRicerca.uscita.equals((Object)searchForm.getTipologiaRicercaEnum()) && StringUtils.isNotEmpty((String)searchForm.getNomeDestinatario())) {
            TransazioneType.SoggettoDestinatario soggettoDestinatario = new TransazioneType.SoggettoDestinatario();
            soggettoDestinatario.setTipo(searchForm.getTipoDestinatario());
            soggettoDestinatario.setValue(UtilityTransazioni.escapeXmlValue(searchForm.getNomeDestinatario()));
            transazione.setSoggettoDestinatario(soggettoDestinatario);
        }
        if (StringUtils.isNotEmpty((String)searchForm.getServizioApplicativo())) {
            transazione.setServizioApplicativo(UtilityTransazioni.escapeXmlValue(searchForm.getServizioApplicativo()));
        }
        if (StringUtils.isNotEmpty((String)searchForm.getNomeServizio())) {
            transazione.setServizio(UtilityTransazioni.escapeXmlValue(searchForm.getNomeServizio()));
        }
        if (StringUtils.isNotEmpty((String)searchForm.getNomeAzione())) {
            transazione.setAzione(UtilityTransazioni.escapeXmlValue(searchForm.getNomeAzione()));
        }
        EsitoUtils esitoUtils = new EsitoUtils(LoggerManager.getPddMonitorCoreLogger(), searchForm.getProtocollo());
        TransazioneType.Esito esito = new TransazioneType.Esito();
        Integer esitoNumber = null;
        esitoNumber = searchForm.getEsitoDettaglio() != null && EsitoUtils.ALL_VALUE.intValue() != searchForm.getEsitoDettaglio().intValue() ? searchForm.getEsitoDettaglio() : searchForm.getEsitoGruppo();
        esito.setCodice(new BigInteger("" + esitoNumber));
        esito.setValue(UtilityTransazioni.escapeXmlValue(esitoUtils.getEsitoLabelFromValue((Object)esitoNumber, false)));
        transazione.setEsito(esito);
        TransazioneType.Contesto contesto = new TransazioneType.Contesto();
        contesto.setCodice(searchForm.getEsitoContesto());
        contesto.setValue(UtilityTransazioni.escapeXmlValue(esitoUtils.getEsitoContestoLabelFromValue((Object)searchForm.getEsitoContesto())));
        transazione.setContesto(contesto);
        if (StringUtils.isNotEmpty((String)searchForm.getIdEgov())) {
            transazione.setIdMessaggio(searchForm.getIdEgov());
        }
        if (StringUtils.isNotEmpty((String)searchForm.getEvento())) {
            transazione.setEvento(searchForm.getEvento());
        }
        if (StringUtils.isNotEmpty((String)searchForm.getIdCorrelazioneApplicativa())) {
            TransazioneType.IdApplicativo idApplicativo = new TransazioneType.IdApplicativo();
            idApplicativo.setModalita(searchForm.getCorrelazioneApplicativaMatchingType().toString());
            idApplicativo.setValue(searchForm.getIdCorrelazioneApplicativa());
            transazione.setIdApplicativo(idApplicativo);
        }
        FiltroContenuti filtroContenuti = null;
        if (StringUtils.isNotEmpty((String)searchForm.getNomeStato())) {
            if (filtroContenuti == null) {
                filtroContenuti = new FiltroContenuti();
            }
            filtroContenuti.setStato(searchForm.getNomeStato());
        }
        if (StringUtils.isNotEmpty((String)searchForm.getNomeRisorsa()) && StringUtils.isNotEmpty((String)searchForm.getValoreRisorsa())) {
            if (filtroContenuti == null) {
                filtroContenuti = new FiltroContenuti();
            }
            FiltroContenuti.Risorsa risorsa = new FiltroContenuti.Risorsa();
            risorsa.setNome(searchForm.getNomeRisorsa());
            risorsa.setValue(searchForm.getValoreRisorsa());
            filtroContenuti.setRisorsa(risorsa);
        }
        if (searchForm.getRicercaSelezionata() != null && searchForm.getRicercaSelezionata().getPlugin() != null) {
            if (filtroContenuti == null) {
                filtroContenuti = new FiltroContenuti();
            }
            RicercaPersonalizzata ricerca = new RicercaPersonalizzata();
            ricerca.setTipo(searchForm.getRicercaSelezionata().getPlugin().getTipo());
            ricerca.setClassName(searchForm.getRicercaSelezionata().getPlugin().getClassName());
            ricerca.setLabel(searchForm.getRicercaSelezionata().getPlugin().getLabel());
            if (searchForm.getRicercaSelezionataParameters() != null && searchForm.getRicercaSelezionataParameters().size() > 0) {
                for (Parameter<?> searchParam : searchForm.getRicercaSelezionataParameters()) {
                    RicercaPersonalizzata.Parameter par = new RicercaPersonalizzata.Parameter();
                    par.setTipo(searchParam.getType().getValue());
                    par.setNome(searchParam.getId());
                    par.setValue(searchParam.getValueAsString());
                    ricerca.getParameter().add(par);
                }
            }
            filtroContenuti.setRicercaPersonalizzata(ricerca);
        }
        transazione.setFiltroContenuti(filtroContenuti);
        if (idTransazioni != null && totTransazioni != null) {
            TransazioneType.TransazioniIdentificate transazioniIdentificate = new TransazioneType.TransazioniIdentificate();
            transazioniIdentificate.setSelezionate(idTransazioni.size());
            transazioniIdentificate.setTotale(totTransazioni);
            transazione.setTransazioniIdentificate(transazioniIdentificate);
        }
        marshaller.marshal(objFactory.createTransazione(transazione), out);
    }

    public static void writeHeadersTrasportoXml(List<DumpHeaderTrasporto> headers, OutputStream out, boolean asProperties) throws Exception {
        if (asProperties) {
            StringBuilder bf = new StringBuilder();
            if (headers != null) {
                for (DumpHeaderTrasporto dumpHeaderTrasporto : headers) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append(dumpHeaderTrasporto.getNome());
                    bf.append("=");
                    bf.append(dumpHeaderTrasporto.getValore());
                }
            }
            if (bf.length() > 0) {
                out.write(bf.toString().getBytes());
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            ObjectFactory objFactory = new ObjectFactory();
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = new org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType();
            if (headers != null) {
                for (DumpHeaderTrasporto dumpHeaderTrasporto : headers) {
                    HeaderType header = new HeaderType();
                    header.setNome(dumpHeaderTrasporto.getNome());
                    header.setValore(dumpHeaderTrasporto.getValore());
                    transazione.getHeader().add(header);
                }
            }
            marshaller.marshal(objFactory.createTransazione(transazione), out);
        }
    }

    public static void writeMultipartHeaderXml(List<DumpMultipartHeader> headers, OutputStream out, boolean asProperties) throws Exception {
        if (asProperties) {
            StringBuilder bf = new StringBuilder();
            if (headers != null) {
                for (DumpMultipartHeader dumpHeaderTrasporto : headers) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append(dumpHeaderTrasporto.getNome());
                    bf.append("=");
                    bf.append(dumpHeaderTrasporto.getValore());
                }
            }
            if (bf.length() > 0) {
                out.write(bf.toString().getBytes());
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            ObjectFactory objFactory = new ObjectFactory();
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = new org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType();
            if (headers != null) {
                for (DumpMultipartHeader dumpHeaderTrasporto : headers) {
                    HeaderType header = new HeaderType();
                    header.setNome(dumpHeaderTrasporto.getNome());
                    header.setValore(dumpHeaderTrasporto.getValore());
                    transazione.getHeader().add(header);
                }
            }
            marshaller.marshal(objFactory.createTransazione(transazione), out);
        }
    }

    public static void writeAllegatoHeaderXml(List<DumpHeaderAllegato> headers, OutputStream out, boolean asProperties) throws Exception {
        if (asProperties) {
            StringBuilder bf = new StringBuilder();
            if (headers != null) {
                for (DumpHeaderAllegato dumpHeaderTrasporto : headers) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append(dumpHeaderTrasporto.getNome());
                    bf.append("=");
                    bf.append(dumpHeaderTrasporto.getValore());
                }
            }
            if (bf.length() > 0) {
                out.write(bf.toString().getBytes());
            }
        } else {
            JAXBContext jc = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            ObjectFactory objFactory = new ObjectFactory();
            org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType transazione = new org.openspcoop2.web.monitor.transazioni.core.header.TransazioneType();
            if (headers != null) {
                for (DumpHeaderAllegato dumpHeaderTrasporto : headers) {
                    HeaderType header = new HeaderType();
                    header.setNome(dumpHeaderTrasporto.getNome());
                    header.setValore(dumpHeaderTrasporto.getValore());
                    transazione.getHeader().add(header);
                }
            }
            marshaller.marshal(objFactory.createTransazione(transazione), out);
        }
    }

    public static void writeContenutiXml(List<DumpContenuto> contenuti, OutputStream out, boolean asProperties) throws Exception {
        if (asProperties) {
            StringBuilder bf = new StringBuilder();
            if (contenuti != null) {
                for (DumpContenuto dumpContenuto : contenuti) {
                    if (bf.length() > 0) {
                        bf.append("\n");
                    }
                    bf.append(dumpContenuto.getNome());
                    bf.append("=");
                    bf.append(TransactionContentUtils.getDumpContenutoValue((DumpContenuto)dumpContenuto));
                }
            }
            if (bf.length() > 0) {
                out.write(bf.toString().getBytes());
            }
        } else {
            ContentType content = new ContentType();
            JAXBContext jc = JAXBContext.newInstance((String)org.openspcoop2.web.monitor.transazioni.core.contents.ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = jc.createMarshaller();
            org.openspcoop2.web.monitor.transazioni.core.contents.ObjectFactory objFactory = new org.openspcoop2.web.monitor.transazioni.core.contents.ObjectFactory();
            if (contenuti != null) {
                for (DumpContenuto dumpContenuto : contenuti) {
                    RisorsaType risorsa = new RisorsaType();
                    risorsa.setNome(dumpContenuto.getNome());
                    risorsa.setValore(TransactionContentUtils.getDumpContenutoValue((DumpContenuto)dumpContenuto));
                    content.getRisorsa().add(risorsa);
                }
            }
            marshaller.marshal(objFactory.createTransazione(content), out);
        }
    }
}

