/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.dao;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.TransazioneApplicativoServer;
import org.openspcoop2.core.transazioni.dao.IDBTransazioneApplicativoServerServiceSearch;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.dao.ITransazioneApplicativoServerServiceSearch;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.slf4j.Logger;

public class TransazioniApplicativoServerService
implements ITransazioniApplicativoServerService {
    private transient Logger log = LoggerManager.getPddMonitorSqlLogger();
    private String idTransazione = null;
    private String protocollo = null;
    private DAOFactory daoFactory;
    private IServiceManager transazioniServiceManager;
    private ITransazioneApplicativoServerServiceSearch transazioniSASearch;

    public TransazioniApplicativoServerService() {
        try {
            this.daoFactory = DAOFactory.getInstance((Logger)this.log);
            this.transazioniServiceManager = (IServiceManager)this.daoFactory.getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.log);
            this.transazioniSASearch = this.transazioniServiceManager.getTransazioneApplicativoServerServiceSearch();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected TransazioniApplicativoServerService(DAOFactory daoFactory, IServiceManager transazioniServiceManager, ITransazioneApplicativoServerServiceSearch transazioniSASearch) {
        try {
            this.daoFactory = daoFactory;
            this.transazioniServiceManager = transazioniServiceManager;
            this.transazioniSASearch = transazioniSASearch;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<TransazioneApplicativoServerBean> findAll(int start, int limit) {
        return this._findAll(start, limit);
    }

    public int totalCount() {
        try {
            this.log.debug("Count Transazioni Applicativo Server per la Transazione [" + this.idTransazione + "]");
            IExpression expr = this.createFilter();
            NonNegativeNumber res = this.transazioniSASearch.count(expr);
            return (int)res.longValue();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public TransazioneApplicativoServerBean findById(Long key) {
        try {
            this.log.info("Find By Id: [" + key + "]");
            TransazioneApplicativoServer transazione = (TransazioneApplicativoServer)((IDBTransazioneApplicativoServerServiceSearch)this.transazioniSASearch).get(key.longValue());
            transazione.setProtocollo(this.protocollo);
            return new TransazioneApplicativoServerBean(transazione);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public TransazioneApplicativoServerBean findByServizioApplicativoErogatore(String nomeServizioApplicativoErogatore) throws Exception {
        try {
            this.log.info("Find By Servizio Applicativo Erogatore: [" + nomeServizioApplicativoErogatore + "]");
            IExpression expr = this.createFilter();
            if (nomeServizioApplicativoErogatore == null) {
                expr.isNull(TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE);
            } else {
                expr.equals(TransazioneApplicativoServer.model().SERVIZIO_APPLICATIVO_EROGATORE, (Object)nomeServizioApplicativoErogatore);
            }
            TransazioneApplicativoServer transazione = (TransazioneApplicativoServer)this.transazioniSASearch.find(expr);
            transazione.setProtocollo(this.protocollo);
            return new TransazioneApplicativoServerBean(transazione);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<TransazioneApplicativoServerBean> findAll() {
        return this._findAll(null, null);
    }

    private List<TransazioneApplicativoServerBean> _findAll(Integer start, Integer limit) {
        ArrayList<TransazioneApplicativoServerBean> listaBean = new ArrayList<TransazioneApplicativoServerBean>();
        try {
            List list;
            this.log.debug("Find All + Limit Applicativo Server per la Transazione [" + this.idTransazione + "]");
            IExpression expr = this.createFilter();
            expr.sortOrder(SortOrder.ASC).addOrder(TransazioneApplicativoServer.model().DATA_REGISTRAZIONE);
            IPaginatedExpression pagExpr = this.transazioniSASearch.toPaginatedExpression(expr);
            if (start != null) {
                pagExpr.offset(start.intValue());
            }
            if (limit != null) {
                pagExpr.limit(limit.intValue());
            }
            if ((list = this.transazioniSASearch.findAll(pagExpr)) != null && list.size() > 0) {
                for (TransazioneApplicativoServer transazione : list) {
                    transazione.setProtocollo(this.protocollo);
                    TransazioneApplicativoServerBean bean = new TransazioneApplicativoServerBean(transazione);
                    listaBean.add(bean);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return listaBean;
    }

    private IExpression createFilter() throws ServiceException, NotImplementedException, ExpressionNotImplementedException, ExpressionException {
        IExpression newExpression = this.transazioniSASearch.newExpression();
        if (this.idTransazione != null) {
            newExpression.equals(TransazioneApplicativoServer.model().ID_TRANSAZIONE, (Object)this.idTransazione);
        }
        return newExpression;
    }

    public void store(TransazioneApplicativoServerBean obj) throws Exception {
    }

    public void deleteById(Long key) {
    }

    public void delete(TransazioneApplicativoServerBean obj) throws Exception {
    }

    public void deleteAll() throws Exception {
    }

    public String getIdTransazione() {
        return this.idTransazione;
    }

    @Override
    public void setIdTransazione(String idTransazione) {
        this.idTransazione = idTransazione;
    }

    @Override
    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
    }

    public String getProtocollo() {
        return this.protocollo;
    }
}

