/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.dao;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openspcoop2.core.commons.dao.DAOFactory;
import org.openspcoop2.core.transazioni.TransazioneExport;
import org.openspcoop2.core.transazioni.constants.DeleteState;
import org.openspcoop2.core.transazioni.constants.ExportState;
import org.openspcoop2.core.transazioni.dao.IDBTransazioneExportServiceSearch;
import org.openspcoop2.core.transazioni.dao.IServiceManager;
import org.openspcoop2.core.transazioni.dao.ITransazioneExportService;
import org.openspcoop2.core.transazioni.dao.ITransazioneExportServiceSearch;
import org.openspcoop2.core.transazioni.utils.ProjectInfo;
import org.openspcoop2.generic_project.beans.IProjectInfo;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.NotImplementedException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniExportService;
import org.slf4j.Logger;

public class TransazioniExportService
implements ITransazioniExportService {
    private transient Logger log = null;
    private IServiceManager transazioniServiceManager;
    private ITransazioneExportService transazioneExportDAO;
    private ITransazioneExportServiceSearch transazioneExportSearchDAO;

    public TransazioniExportService() {
        this.log = LoggerManager.getPddMonitorSqlLogger();
        try {
            this.transazioniServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.log);
            this.transazioneExportDAO = this.transazioniServiceManager.getTransazioneExportService();
            this.transazioneExportSearchDAO = this.transazioniServiceManager.getTransazioneExportServiceSearch();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TransazioniExportService(Connection con, boolean autoCommit, Logger log) {
        this.log = log;
        try {
            this.transazioniServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), con, autoCommit, this.log);
            this.transazioneExportDAO = this.transazioniServiceManager.getTransazioneExportService();
            this.transazioneExportSearchDAO = this.transazioniServiceManager.getTransazioneExportServiceSearch();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public TransazioniExportService(Logger log) {
        this.log = log;
        try {
            this.transazioniServiceManager = (IServiceManager)DAOFactory.getInstance((Logger)this.log).getServiceManager((IProjectInfo)ProjectInfo.getInstance(), this.log);
            this.transazioneExportDAO = this.transazioniServiceManager.getTransazioneExportService();
            this.transazioneExportSearchDAO = this.transazioniServiceManager.getTransazioneExportServiceSearch();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public List<TransazioneExport> findAll(int start, int limit) {
        try {
            this.log.info("Find All");
            IPaginatedExpression pagExpr = this.transazioneExportSearchDAO.newPaginatedExpression();
            pagExpr.offset(start).limit(limit);
            return this.transazioneExportSearchDAO.findAll(pagExpr);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<TransazioneExport>();
        }
    }

    public int totalCount() {
        try {
            this.log.info("Count");
            IExpression expr = this.transazioneExportSearchDAO.newExpression();
            NonNegativeNumber nnn = this.transazioneExportSearchDAO.count(expr);
            return nnn != null ? (int)nnn.longValue() : 0;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }

    public void store(TransazioneExport obj) throws Exception {
        try {
            this.log.info("Store");
            if (obj.getId() == -1L) {
                this.transazioneExportDAO.create((Object)obj);
            } else {
                this.transazioneExportDAO.update((Object)obj);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteById(Long key) {
        try {
            this.log.info("Delete By Id [" + key + "]");
            TransazioneExport obj = this.findById(key);
            this.transazioneExportDAO.delete((Object)obj);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void delete(TransazioneExport obj) throws Exception {
        try {
            this.log.info("Delete: " + obj.getId());
            this.transazioneExportDAO.delete((Object)obj);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void deleteAll() throws Exception {
        throw new Exception("Metodo non implementato.");
    }

    public TransazioneExport findById(Long key) {
        try {
            this.log.info("Find By Id: [" + key + "]");
            return (TransazioneExport)((IDBTransazioneExportServiceSearch)this.transazioneExportSearchDAO).get(key.longValue());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<TransazioneExport> findAll() {
        try {
            this.log.info("Find All");
            IPaginatedExpression pagExpr = this.transazioneExportSearchDAO.newPaginatedExpression();
            return this.transazioneExportSearchDAO.findAll(pagExpr);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return new ArrayList<TransazioneExport>();
        }
    }

    @Override
    public TransazioneExport getByIntervallo(Date dataInizio, Date dataFine) {
        TransazioneExport t = null;
        try {
            this.log.info("Find By Intervallo Date [inizio: " + dataInizio + " fine: " + dataFine + " ]");
            IExpression expr = this.transazioneExportSearchDAO.newExpression();
            expr.equals(TransazioneExport.model().INTERVALLO_INIZIO, (Object)dataInizio);
            expr.and().equals(TransazioneExport.model().INTERVALLO_FINE, (Object)dataFine);
            t = (TransazioneExport)this.transazioneExportSearchDAO.find(expr);
        }
        catch (NotFoundException nre) {
            t = new TransazioneExport();
            t.setIntervalloInizio(dataInizio);
            t.setIntervalloFine(dataFine);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return t;
    }

    @Override
    public TransazioneExport getOldestForDelete() throws Exception {
        this.log.info("Find By Oldest For Delete");
        try {
            IExpression expr = this.transazioneExportSearchDAO.newExpression();
            expr.equals(TransazioneExport.model().EXPORT_STATE, (Object)ExportState.COMPLETED);
            expr.and().notEquals(TransazioneExport.model().DELETE_STATE, (Object)DeleteState.COMPLETED);
            expr.sortOrder(SortOrder.ASC).addOrder(TransazioneExport.model().EXPORT_TIME_START);
            IPaginatedExpression pagExpr = this.transazioneExportSearchDAO.toPaginatedExpression(expr);
            pagExpr.limit(1);
            List lst = this.transazioneExportSearchDAO.findAll(pagExpr);
            if (lst != null && lst.size() > 0) {
                return (TransazioneExport)lst.get(0);
            }
        }
        catch (ServiceException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (NotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionNotImplementedException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (ExpressionException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

