/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.exporter;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.transazioni.TransazioneExport;
import org.openspcoop2.core.transazioni.constants.DeleteState;
import org.openspcoop2.core.transazioni.constants.ExportState;
import org.openspcoop2.core.transazioni.constants.TipoMessaggio;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.protocol.basic.archive.ZIPUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.RuoloMessaggio;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.diagnostica.FiltroRicercaDiagnosticiConPaginazione;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticDriver;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.diagnostica.MsgDiagnostico;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoException;
import org.openspcoop2.protocol.sdk.tracciamento.DriverTracciamentoNotFoundException;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaDriver;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneApplicativoServerBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioneBean;
import org.openspcoop2.web.monitor.transazioni.bean.TransazioniSearchForm;
import org.openspcoop2.web.monitor.transazioni.core.UtilityTransazioni;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniApplicativoServerService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniExportService;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.openspcoop2.web.monitor.transazioni.exporter.ExportException;
import org.openspcoop2.web.monitor.transazioni.exporter.IExporter;
import org.openspcoop2.web.monitor.transazioni.exporter.MultiExporterProperties;
import org.openspcoop2.web.monitor.transazioni.exporter.SingleFileExporter;
import org.slf4j.Logger;

public class MultiFileExporter
implements IExporter {
    private transient Logger log = null;
    private boolean exportTracce = false;
    private boolean exportDiagnostici = false;
    private boolean exportContenuti = false;
    private boolean enableHeaderInfo = false;
    private boolean enableConsegneInfo = false;
    private boolean mimeThrowExceptionIfNotFound = false;
    private boolean abilitaMarcamentoTemporale = false;
    private int maxTransactionPerFile;
    private boolean headersAsProperties = true;
    private boolean contenutiAsProperties = false;
    private ITransazioniService transazioniService;
    private ITransazioniApplicativoServerService transazioniApplicativoService;
    private ITracciaDriver tracciamentoService;
    private IDiagnosticDriver diagnosticiService;
    private ITransazioniExportService transazioniExporterService;
    private String filePrefix = null;
    private String exportDir = null;

    private void _MultiFileExporter(MultiExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) {
        this.enableHeaderInfo = properties.isEnableHeaderInfo();
        this.enableConsegneInfo = properties.isEnableConsegneInfo();
        this.exportTracce = properties.isExportTracce();
        this.exportDiagnostici = properties.isExportDiagnostici();
        this.exportContenuti = properties.isExportContenuti();
        this.mimeThrowExceptionIfNotFound = properties.isMimeThrowExceptionIfNotFound();
        this.abilitaMarcamentoTemporale = properties.isAbilitaMarcamentoTemporaleEsportazione();
        this.headersAsProperties = properties.isHeadersAsProperties();
        this.contenutiAsProperties = properties.isContenutiAsProperties();
        this.maxTransactionPerFile = properties.getMaxTransazioniPerFile() > 0 ? properties.getMaxTransazioniPerFile() : 100;
        this.tracciamentoService = tracciamentoService;
        this.transazioniService = transazioniService;
        this.transazioniApplicativoService = transazioniService.getTransazioniApplicativoServerService();
        this.diagnosticiService = diagnosticiService;
        this.transazioniExporterService = transazioniExport;
        this.log.info("Multi File Exporter inizializzato:");
        this.log.info("\t -esportazione Consegne    abilitata: " + this.enableConsegneInfo);
        this.log.info("\t -esportazione Tracce      abilitata: " + this.exportTracce);
        this.log.info("\t -esportazione Contenuti   abilitata: " + this.exportContenuti);
        this.log.info("\t -esportazione Diagnostici abilitata: " + this.exportDiagnostici);
        this.log.info("\t -max transazioni per file : " + this.maxTransactionPerFile);
        this.log.info("\t -abilita marcamento temporale : " + this.abilitaMarcamentoTemporale);
        this.log.info("\t -MimeType handling (mime.throwExceptionIfMappingNotFound):" + this.mimeThrowExceptionIfNotFound);
    }

    public MultiFileExporter(String exportDir, String fileName, MultiExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport, Logger log) throws Exception {
        this.log = log;
        if (this.log == null) {
            this.log = LoggerManager.getPddMonitorCoreLogger();
        }
        this._MultiFileExporter(properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport);
        this.filePrefix = fileName.endsWith(".zip") ? fileName.substring(0, fileName.lastIndexOf(".")) : fileName;
        this.exportDir = exportDir;
    }

    public MultiFileExporter(String exportDir, String fileName, MultiExporterProperties properties, ITransazioniService transazioniService, ITracciaDriver tracciamentoService, IDiagnosticDriver diagnosticiService, ITransazioniExportService transazioniExport) throws Exception {
        this(exportDir, fileName, properties, transazioniService, tracciamentoService, diagnosticiService, transazioniExport, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void export(String rootDir, ZipOutputStream zip, List<TransazioneBean> transazioni) throws Exception {
        buf = new byte[1024];
        in = null;
        var6_6 = transazioni.iterator();
        block22: while (true) {
            block39: {
                if (!var6_6.hasNext()) {
                    return;
                }
                t = var6_6.next();
                transazioneDir = rootDir + t.getIdTransazione() + File.separatorChar;
                consegnaMultipla = false;
                try {
                    esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)this.log, (String)t.getProtocollo());
                    esitoTransactionName = esitiProperties.getEsitoTransazioneName(Integer.valueOf(t.getEsito()));
                    if (EsitoTransazioneName.isConsegnaMultipla((EsitoTransazioneName)esitoTransactionName)) {
                        consegnaMultipla = true;
                    }
                }
                catch (Exception e) {
                    msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a comprendere l'esito della transazione (" + e.getMessage() + ")";
                    this.log.error(msg, (Throwable)e);
                    throw new ExportException(msg, e);
                }
                if (this.enableHeaderInfo) {
                    try {
                        zip.putNextEntry(new ZipEntry(transazioneDir + "manifest.xml"));
                        UtilityTransazioni.writeManifestTransazione(t, zip);
                        zip.flush();
                        zip.closeEntry();
                    }
                    catch (Exception ioe) {
                        msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                        msg = msg + " Non sono riuscito a creare il file manifest.xml (" + ioe.getMessage() + ")";
                        this.log.error(msg, (Throwable)ioe);
                        throw new ExportException(msg, ioe);
                    }
                }
                if (consegnaMultipla && this.enableConsegneInfo) {
                    try {
                        dir = transazioneDir + "consegne" + File.separator;
                        this.transazioniApplicativoService.setIdTransazione(t.getIdTransazione());
                        this.transazioniApplicativoService.setProtocollo(t.getProtocollo());
                        listConsegne = this.transazioniApplicativoService.findAll();
                        if (listConsegne == null || listConsegne.isEmpty()) break block39;
                        for (TransazioneApplicativoServerBean tAS : listConsegne) {
                            connettoreNome = ZIPUtils.convertNameToSistemaOperativoCompatible((String)(tAS.getConnettoreNome() != null ? tAS.getConnettoreNome() : "Default"));
                            dirConsegna = dir + connettoreNome + File.separator;
                            zip.putNextEntry(new ZipEntry(dirConsegna + "manifest.xml"));
                            UtilityTransazioni.writeManifestTransazioneApplicativoServer(t, tAS, zip);
                            zip.flush();
                            zip.closeEntry();
                            if (this.exportDiagnostici) {
                                this.exportDiagnostici(zip, t, dirConsegna, false, tAS.getServizioApplicativoErogatore());
                            }
                            if (!this.exportContenuti) continue;
                            fault = tAS.getFault();
                            if (StringUtils.isNotBlank((String)fault)) {
                                try {
                                    ext = UtilityTransazioni.getExtension(tAS.getFormatoFault());
                                    zip.putNextEntry(new ZipEntry(dirConsegna + "fault." + ext));
                                    zip.write(fault != null ? fault.getBytes() : "".getBytes());
                                    zip.flush();
                                    zip.closeEntry();
                                }
                                catch (Exception ioe) {
                                    msg = "Si e' verificato un errore durante l'esportazione dei contenuti della transazione con id:" + t.getIdTransazione();
                                    msg = msg + " Non sono riuscito a creare il file fault (" + ioe.getMessage() + ")";
                                    this.log.error(msg, (Throwable)ioe);
                                    throw new ExportException(msg, ioe);
                                }
                            }
                            if (!StringUtils.isNotBlank((String)(faultErrore = tAS.getFaultUltimoErrore()))) continue;
                            try {
                                ext = UtilityTransazioni.getExtension(tAS.getFormatoFaultUltimoErrore());
                                zip.putNextEntry(new ZipEntry(dirConsegna + "faultUltimoErrore." + ext));
                                zip.write(faultErrore != null ? faultErrore.getBytes() : "".getBytes());
                                zip.flush();
                                zip.closeEntry();
                            }
                            catch (Exception ioe) {
                                msg = "Si e' verificato un errore durante l'esportazione dei contenuti della transazione con id:" + t.getIdTransazione();
                                msg = msg + " Non sono riuscito a creare il file faultUltimoErrore (" + ioe.getMessage() + ")";
                                this.log.error(msg, (Throwable)ioe);
                                throw new ExportException(msg, ioe);
                            }
                        }
                    }
                    catch (Exception e) {
                        msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                        msg = msg + " Non sono riuscito a recuperare le informazioni sulle consegne (" + e.getMessage() + ")";
                        this.log.error(msg, (Throwable)e);
                        throw new ExportException(msg, e);
                    }
                }
            }
            if (this.exportTracce) {
                properties = new HashMap<String, String>();
                properties.put("id_transazione", t.getIdTransazione());
                tracciaRichiesta = null;
                tracciaRisposta = null;
                tracce = new ArrayList<Traccia>();
                try {
                    tracciaRichiesta = this.tracciamentoService.getTraccia(RuoloMessaggio.RICHIESTA, properties);
                    tracce.add(tracciaRichiesta);
                }
                catch (DriverTracciamentoException e) {
                    msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a recuperare la traccia di richiesta (" + e.getMessage() + ")";
                    throw new ExportException(msg, e);
                }
                catch (DriverTracciamentoNotFoundException e) {
                    // empty catch block
                }
                try {
                    tracciaRisposta = this.tracciamentoService.getTraccia(RuoloMessaggio.RISPOSTA, properties);
                    tracce.add(tracciaRisposta);
                }
                catch (DriverTracciamentoException e) {
                    msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a recuperare la traccia di risposta (" + e.getMessage() + ")";
                    throw new ExportException(msg, e);
                }
                catch (DriverTracciamentoNotFoundException e) {
                    // empty catch block
                }
                if (tracce.size() > 0) {
                    try {
                        zip.putNextEntry(new ZipEntry(transazioneDir + "tracce.xml"));
                        for (j = 0; j < tracce.size(); ++j) {
                            tr = (Traccia)tracce.get(j);
                            newLine = j > 0 ? "\n\n" : "";
                            pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tr.getProtocollo());
                            tracciaBuilder = pf.createTracciaSerializer();
                            tracciaBuilder.setOmitXmlDeclaration(true);
                            traccia = tracciaBuilder.toString(tr, TipoSerializzazione.DEFAULT);
                            in = new ByteArrayInputStream((newLine + traccia).getBytes());
                            while ((len = in.read(buf)) > 0) {
                                zip.write(buf, 0, len);
                            }
                        }
                        zip.flush();
                        zip.closeEntry();
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
                        msg = msg + " Non sono riuscito a creare il file tracce.xml (" + e.getMessage() + ")";
                        throw new ExportException(msg, e);
                    }
                }
            }
            if (this.exportDiagnostici) {
                this.exportDiagnostici(zip, t, transazioneDir, consegnaMultipla, null);
            }
            if (!this.exportContenuti) continue;
            fault = t.getFaultIntegrazione();
            if (StringUtils.isNotBlank((String)fault)) {
                try {
                    ext = UtilityTransazioni.getExtension(t.getFormatoFaultIntegrazione());
                    zip.putNextEntry(new ZipEntry(transazioneDir + "faultIntegrazione." + ext));
                    zip.write(fault != null ? fault.getBytes() : "".getBytes());
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    msg = "Si e' verificato un errore durante l'esportazione dei contenuti della transazione con id:" + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a creare il file faultIntegrazione (" + ioe.getMessage() + ")";
                    this.log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            if (StringUtils.isNotBlank((String)(fault = t.getFaultCooperazione()))) {
                try {
                    ext = UtilityTransazioni.getExtension(t.getFormatoFaultCooperazione());
                    zip.putNextEntry(new ZipEntry(transazioneDir + "faultCooperazione." + ext));
                    zip.write(fault != null ? fault.getBytes() : "".getBytes());
                    zip.flush();
                    zip.closeEntry();
                }
                catch (Exception ioe) {
                    msg = "Si e' verificato un errore durante l'esportazione dei contenuti della transazione con id:" + t.getIdTransazione();
                    msg = msg + " Non sono riuscito a creare il file faultCooperazione (" + ioe.getMessage() + ")";
                    this.log.error(msg, (Throwable)ioe);
                    throw new ExportException(msg, ioe);
                }
            }
            listTipiDaEsportare = TipoMessaggio.values();
            i = 0;
            while (true) {
                if (i < listTipiDaEsportare.length) ** break;
                continue block22;
                SingleFileExporter.exportContenuti(this.log, t, zip, transazioneDir, this.transazioniService, listTipiDaEsportare[i], this.headersAsProperties, this.contenutiAsProperties);
                ++i;
            }
            break;
        }
    }

    private void exportDiagnostici(ZipOutputStream zip, TransazioneBean t, String dir, boolean forceNullApplicativo, String servizioApplicativo) throws ExportException {
        InputStream in = null;
        byte[] buf = new byte[1024];
        try {
            FiltroRicercaDiagnosticiConPaginazione filter = new FiltroRicercaDiagnosticiConPaginazione();
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("id_transazione", t.getIdTransazione());
            filter.setProperties(properties);
            List list = this.diagnosticiService.getMessaggiDiagnostici(filter);
            zip.putNextEntry(new ZipEntry(dir + "diagnostici.xml"));
            for (int j = 0; j < list.size(); ++j) {
                int len;
                MsgDiagnostico msg = (MsgDiagnostico)list.get(j);
                String newLine = j > 0 ? "\n\n" : "";
                IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(msg.getProtocollo());
                IDiagnosticSerializer diagnosticoBuilder = pf.createDiagnosticSerializer();
                diagnosticoBuilder.setOmitXmlDeclaration(true);
                String diagnostico = diagnosticoBuilder.toString(msg, TipoSerializzazione.XML);
                in = new ByteArrayInputStream((newLine + diagnostico).getBytes());
                while ((len = in.read(buf)) > 0) {
                    zip.write(buf, 0, len);
                }
            }
            zip.flush();
            zip.closeEntry();
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            String msg = "Si e' verificato un errore durante l'esportazione della transazione con id:" + t.getIdTransazione();
            msg = msg + " Non sono riuscito a creare il file diagnostici.xml (" + e.getMessage() + ")";
            throw new ExportException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws Exception {
        Date startTime = Calendar.getInstance().getTime();
        TransazioneExport te = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            SimpleDateFormat time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            this.log.debug("Avvio esportazione ...");
            this.log.debug("Inizio esportazione alle:" + time.format(startTime));
            ArrayList<TransazioneBean> transazioni = new ArrayList();
            int totCount = this.transazioniService.totalCount();
            double div = (double)totCount / (double)this.maxTransactionPerFile;
            double totFile = Math.ceil(div);
            File exportDir = new File(this.exportDir);
            if (!exportDir.exists()) {
                exportDir.mkdir();
            }
            if (this.abilitaMarcamentoTemporale) {
                te = this.transazioniExporterService.getByIntervallo(((TransazioniSearchForm)this.transazioniService.getSearch()).getDataInizio(), ((TransazioniSearchForm)this.transazioniService.getSearch()).getDataFine());
                te.setExportState(ExportState.EXECUTING);
                te.setExportTimeStart(startTime);
                te.setDeleteState(DeleteState.UNDEFINED);
                if (this.filePrefix != null) {
                    te.setNome(this.filePrefix);
                }
                this.transazioniExporterService.store(te);
            }
            this.log.debug("Ho trovato " + totCount + " transazioni che verranno inserite su " + totFile + " file con max " + this.maxTransactionPerFile + " transazioni per file.");
            int limit = this.maxTransactionPerFile > 100 ? 100 : this.maxTransactionPerFile;
            int remaining = totCount;
            int i = 0;
            while ((double)i < totFile) {
                File searchFilter;
                String fileName = this.filePrefix + "_" + (i + 1) + ".zip";
                String filesDirPath = exportDir + File.separator + this.filePrefix;
                File filesDir = new File(filesDirPath);
                if (!filesDir.exists()) {
                    this.log.debug("creo directory " + filesDir.getAbsolutePath());
                    filesDir.mkdir();
                }
                if (!(searchFilter = new File(filesDirPath + File.separator + "SearchFilter.xml")).exists()) {
                    try (FileOutputStream fos = new FileOutputStream(searchFilter);){
                        UtilityTransazioni.writeSearchFilterXml((TransazioniSearchForm)this.transazioniService.getSearch(), fos);
                        fos.flush();
                    }
                }
                String filePath = exportDir + File.separator + this.filePrefix + File.separator + fileName;
                File f = new File(filePath);
                this.log.debug("creo nuovo file " + f.getAbsolutePath());
                FileOutputStream fos = null;
                ZipOutputStream zip = null;
                try {
                    fos = new FileOutputStream(f);
                    zip = new ZipOutputStream(fos);
                    String rootDir = "Transazioni" + File.separatorChar;
                    int lette = 0;
                    int start = i * this.maxTransactionPerFile;
                    while ((transazioni = this.transazioniService.findAll(start, limit, SortOrder.ASC)).size() > 0) {
                        this.log.debug(" lette [ " + start + " - " + (start + limit) + "] di " + totCount + " transazioni da inserire in file " + fileName + "...");
                        this.export(rootDir, zip, transazioni);
                        this.log.debug(" inserite [" + transazioni.size() + "] nel file " + fileName + ".");
                        start += limit;
                        remaining -= transazioni.size();
                        if ((lette += transazioni.size()) >= this.maxTransactionPerFile) {
                            this.log.debug("Ho inserito il numero massimo di transazioni ammesse (" + lette + ") nel file " + fileName + " chiudo file.");
                            break;
                        }
                        this.log.debug(" transazioni rimanenti da processare " + remaining);
                        if (remaining > limit) continue;
                        limit = remaining;
                        this.log.debug("devo leggere ancora " + remaining + " transazioni partendo da offset:" + start);
                    }
                    zip.flush();
                }
                finally {
                    try {
                        if (zip != null) {
                            zip.close();
                        }
                    }
                    catch (Throwable throwable) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Throwable throwable) {}
                }
                ++i;
            }
            Date dataFine = Calendar.getInstance().getTime();
            if (this.abilitaMarcamentoTemporale) {
                te.setExportState(ExportState.COMPLETED);
                te.setExportTimeEnd(dataFine);
                this.transazioniExporterService.store(te);
            }
            this.log.debug("Fine esportazione alle:" + formatter.format(Calendar.getInstance().getTime()));
            this.log.debug("Esportazione completata.");
        }
        catch (Exception e) {
            this.log.error("Errore durante esportazione su file", (Throwable)e);
            if (this.abilitaMarcamentoTemporale) {
                try {
                    te.setExportState(ExportState.ERROR);
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    te.setExportError(sw.toString());
                    this.transazioniExporterService.store(te);
                }
                catch (Exception ex) {
                    this.log.error("Errore durante il marcamento temporale.", (Throwable)ex);
                }
            }
            throw e;
        }
    }

    @Override
    public String getFileName() {
        return this.filePrefix;
    }

    @Override
    public boolean isAbilitaMarcamentoTemporale() {
        return this.abilitaMarcamentoTemporale;
    }
}

