/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.search.AccordoServizioParteSpecifica;
import org.openspcoop2.core.commons.search.Soggetto;
import org.openspcoop2.core.commons.search.constants.TipoPdD;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.monitor.engine.condition.EsitoUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.lib.users.dao.Stato;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.monitor.core.bean.AbstractDateSearchForm;
import org.openspcoop2.web.monitor.core.bean.ApplicationBean;
import org.openspcoop2.web.monitor.core.bean.SelectItem;
import org.openspcoop2.web.monitor.core.bean.UserDetailsBean;
import org.openspcoop2.web.monitor.core.constants.Costanti;
import org.openspcoop2.web.monitor.core.constants.TipologiaRicerca;
import org.openspcoop2.web.monitor.core.core.PddMonitorProperties;
import org.openspcoop2.web.monitor.core.core.PermessiUtenteOperatore;
import org.openspcoop2.web.monitor.core.core.Utility;
import org.openspcoop2.web.monitor.core.core.Utils;
import org.openspcoop2.web.monitor.core.dao.DynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.IDynamicUtilsService;
import org.openspcoop2.web.monitor.core.dao.IUserService;
import org.openspcoop2.web.monitor.core.dao.UserService;
import org.openspcoop2.web.monitor.core.datamodel.ResLive;
import org.openspcoop2.web.monitor.core.filters.BrowserFilter;
import org.openspcoop2.web.monitor.core.logger.LoggerManager;
import org.openspcoop2.web.monitor.core.report.ILiveReport;
import org.openspcoop2.web.monitor.core.report.ReportFactory;
import org.openspcoop2.web.monitor.core.utils.BrowserInfo;
import org.openspcoop2.web.monitor.core.utils.DynamicPdDBeanUtils;
import org.openspcoop2.web.monitor.core.utils.MessageManager;
import org.openspcoop2.web.monitor.core.utils.MessageUtils;
import org.openspcoop2.web.monitor.core.utils.ParseUtility;
import org.openspcoop2.web.monitor.transazioni.dao.ITransazioniService;
import org.slf4j.Logger;

public class SummaryBean
implements Serializable {
    private static final String STATO_PERIODO = Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE;
    private static final long serialVersionUID = 1L;
    private List<ResLive> dataLive = new ArrayList<ResLive>();
    private int maxDataStored = 15;
    private Date lastRequest = new Date();
    private Date minDate;
    private Date maxDate;
    private String periodo;
    private String periodoDefault = "--";
    private volatile int offset;
    private String soggettoLocale;
    private String labelSoggettoLocale;
    private String intervalloRefresh = null;
    private transient ILiveReport report = null;
    private static Logger log = LoggerManager.getPddMonitorCoreLogger();
    private String esitoContesto;
    private transient EsitiProperties esitiProperties;
    private List<javax.faces.model.SelectItem> soggettiAssociati = null;
    private Integer soggettiAssociatiSelectItemsWidth = 0;
    private Integer soggettiSelectItemsWidth = 0;
    private volatile boolean soggettiAssociatiSelectItemsWidthCheck = false;
    private volatile boolean soggettiSelectItemsWidthCheck = false;
    private volatile boolean showTipologiaRicerca;
    private boolean tipologiaRicercaEntrambiEnabled;
    private TipologiaRicerca defaultTipologiaRicerca;
    private TipologiaRicerca tipologiaRicerca;
    private Integer maxSelectItemsWidth = 900;
    private Integer defaultSelectItemsWidth = 412;
    private transient ITransazioniService transazioniService;
    private transient IDynamicUtilsService dynamicUtilsService;
    private transient IUserService userService;
    private boolean funzionalitaStatisticaAbilitata;
    private volatile boolean useGraficiSVG = false;
    private DynamicPdDBeanUtils dynamicUtils = null;
    private int protocolliSupportati = 0;
    private String protocollo;
    private String protocolloDefault;
    private List<javax.faces.model.SelectItem> protocolli = null;
    private boolean salvaModificheProfiloSuDB = false;
    private Date startDateForLabel;
    private Date endDateForLabel;

    public SummaryBean() {
        try {
            PddMonitorProperties govwayMonitorProperties = PddMonitorProperties.getInstance((Logger)log);
            this.salvaModificheProfiloSuDB = govwayMonitorProperties.isModificaProfiloUtenteDaLinkAggiornaDB();
            this.intervalloRefresh = govwayMonitorProperties.getIntervalloRefreshEsitiLive();
            this.intervalloRefresh = "" + Integer.parseInt(this.intervalloRefresh);
            this.dynamicUtils = new DynamicPdDBeanUtils(log);
            this.dynamicUtilsService = new DynamicUtilsService();
            this.userService = new UserService();
            this.funzionalitaStatisticaAbilitata = ApplicationBean.getInstance().isFunzionalitaAbilitata("statistiche_base");
            if (this.funzionalitaStatisticaAbilitata) {
                this.periodoDefault = this.leggiStatoPeriodo();
                if (this.periodoDefault == null) {
                    this.periodoDefault = "Ultimi 7 giorni";
                }
                this.report = ReportFactory.getInstance().getStatisticaReportManager();
            } else {
                this.periodoDefault = "--";
                this.report = ReportFactory.getInstance().getTransazioniReportManager();
            }
            IProtocolFactory protocolFactory = null;
            User utente = Utility.getLoggedUtente();
            this.protocolliSupportati = utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0 ? utente.getProtocolliSupportati().size() : ProtocolFactoryManager.getInstance().getProtocolFactories().size();
            boolean utenteNonHaSelezionatoUnProtocolloInAltoADestra = false;
            if (this.isShowListaProtocolli()) {
                String loggedUtenteModalita = Utility.getLoggedUtenteModalita();
                if ("qualsiasi".equals(loggedUtenteModalita)) {
                    utenteNonHaSelezionatoUnProtocolloInAltoADestra = true;
                    if (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0) {
                        protocolFactory = utente.getProtocolliSupportati().contains(ProtocolFactoryManager.getInstance().getDefaultProtocolFactory().getProtocol()) ? ProtocolFactoryManager.getInstance().getDefaultProtocolFactory() : ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)utente.getProtocolliSupportati().get(0));
                    } else {
                        try {
                            protocolFactory = ProtocolFactoryManager.getInstance().getDefaultProtocolFactory();
                        }
                        catch (Exception e) {
                            log.error("Errore durante l'impostazione del default per il protocollo: " + e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(loggedUtenteModalita);
                }
            } else {
                protocolFactory = utente.getProtocolloSelezionatoPddMonitor() != null ? ProtocolFactoryManager.getInstance().getProtocolFactoryByName(utente.getProtocolloSelezionatoPddMonitor()) : (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0 ? ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)utente.getProtocolliSupportati().get(0)) : ProtocolFactoryManager.getInstance().getDefaultProtocolFactory());
            }
            if (protocolFactory != null) {
                this.protocollo = protocolFactory.getProtocol();
                this.protocolloDefault = protocolFactory.getProtocol();
            }
            if (utenteNonHaSelezionatoUnProtocolloInAltoADestra && this.protocolliSupportati > 1) {
                this.protocollo = "qualsiasi";
            }
            this.showTipologiaRicerca = govwayMonitorProperties.isVisualizzaFiltroRuoloSummary();
            if (this.showTipologiaRicerca) {
                this.tipologiaRicercaEntrambiEnabled = govwayMonitorProperties.isVisualizzaVoceEntrambiFiltroRuoloSummary();
                this.tipologiaRicerca = this.getDefaultTipologiaRicercaEnum();
            }
        }
        catch (Exception e) {
            log.error("Errore durante la init del SummaryBean: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.esitiProperties = EsitiProperties.getInstanceFromProtocolName((Logger)log, (String)this.protocolloDefault);
        }
        catch (Exception e) {
            log.error("Errore durante la creazione del form: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.esitoContesto = this.esitiProperties.getEsitoTransactionContextDefault() != null ? this.esitiProperties.getEsitoTransactionContextDefault() : "-";
        }
        catch (Exception e) {
            log.error("Errore durante l'impostazione del default per il contesto: " + e.getMessage(), (Throwable)e);
            this.esitoContesto = "-";
        }
        this.setPeriodo(this.periodoDefault);
    }

    public void setTransazioniService(ITransazioniService transazioniService) {
        this.transazioniService = transazioniService;
    }

    public String getEsitoContesto() {
        return this.esitoContesto;
    }

    public void setEsitoContesto(String esitoContesto) {
        this.esitoContesto = esitoContesto;
    }

    public boolean isShowTipologiaRicerca() {
        return this.showTipologiaRicerca;
    }

    public void setShowTipologiaRicerca(boolean showTipologiaRicerca) {
        this.showTipologiaRicerca = showTipologiaRicerca;
    }

    public String getTipologiaRicerca() {
        return this.getTipologiaRicercaEnum() != null ? this.getTipologiaRicercaEnum().toString() : "";
    }

    public void setTipologiaRicerca(String tipologiaRicerca) {
        if (StringUtils.isEmpty((String)tipologiaRicerca) || "--".equals(tipologiaRicerca)) {
            this.tipologiaRicerca = null;
        } else {
            this.setTipologiaRicerca(TipologiaRicerca.valueOf((String)tipologiaRicerca));
        }
    }

    public TipologiaRicerca getTipologiaRicercaEnum() {
        return this.tipologiaRicerca;
    }

    public void setTipologiaRicerca(TipologiaRicerca tipologiaRicerca) {
        this.tipologiaRicerca = tipologiaRicerca;
    }

    public String getDefaultTipologiaRicerca() {
        return this.getDefaultTipologiaRicercaEnum() != null ? this.getDefaultTipologiaRicercaEnum().toString() : "";
    }

    public TipologiaRicerca getDefaultTipologiaRicercaEnum() {
        if (this.defaultTipologiaRicerca != null) {
            return this.defaultTipologiaRicerca;
        }
        if (this.tipologiaRicercaEntrambiEnabled) {
            return TipologiaRicerca.all;
        }
        return TipologiaRicerca.ingresso;
    }

    public void setDefaultTipologiaRicerca(TipologiaRicerca defaultTipologiaRicerca) {
        this.defaultTipologiaRicerca = defaultTipologiaRicerca;
    }

    public void setDefaultTipologiaRicerca(String defaultTipologiaRicerca) {
        if (StringUtils.isEmpty((String)defaultTipologiaRicerca) || "--".equals(defaultTipologiaRicerca)) {
            this.defaultTipologiaRicerca = null;
        } else {
            this.setDefaultTipologiaRicerca(TipologiaRicerca.valueOf((String)defaultTipologiaRicerca));
        }
    }

    public List<javax.faces.model.SelectItem> getTipologieRicerca() throws Exception {
        ArrayList<javax.faces.model.SelectItem> listaTipologie = new ArrayList<javax.faces.model.SelectItem>();
        listaTipologie.add(new javax.faces.model.SelectItem((Object)TipologiaRicerca.ingresso.toString(), "Erogazione"));
        listaTipologie.add(new javax.faces.model.SelectItem((Object)TipologiaRicerca.uscita.toString(), "Fruizione"));
        if (this.tipologiaRicercaEntrambiEnabled) {
            listaTipologie.add(new javax.faces.model.SelectItem((Object)TipologiaRicerca.all.toString(), "Erogazione/Fruizione"));
        }
        return listaTipologie;
    }

    public void tipologiaRicercaListener(ActionEvent ae) {
        this.soggettoLocale = null;
    }

    public String getPrintPeriodo() {
        Calendar max = Calendar.getInstance();
        this.endDateForLabel = max.getTime();
        Calendar min = (Calendar)max.clone();
        if ("Ultimo anno".equals(this.periodo)) {
            min.add(2, -11);
            min.set(5, min.getActualMinimum(5));
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
        } else if ("Ultimi 30 giorni".equals(this.periodo)) {
            min.add(5, -30);
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
        } else if ("Ultimi 7 giorni".equals(this.periodo)) {
            min.add(5, -6);
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
        } else if ("Ultime 24 ore".equals(this.periodo)) {
            min.add(11, 1);
            min.add(11, -24);
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
        }
        this.startDateForLabel = min.getTime();
        return AbstractDateSearchForm.printPeriodo((Date)this.startDateForLabel, (Date)this.endDateForLabel);
    }

    public void periodoListener(ActionEvent ae) {
        this.getPrintPeriodo();
    }

    public String getXml() {
        int i;
        if ("--".equals(this.periodo)) {
            return "<chart></chart>";
        }
        int[] error_array = new int[this.offset];
        int[] fault_array = new int[this.offset];
        int[] ok_array = new int[this.offset];
        String[] labelArray = new String[this.offset];
        SimpleDateFormat sdf = null;
        SimpleDateFormat sdfend = null;
        Calendar w_end = null;
        Calendar w_start = null;
        Calendar actualStart = null;
        int field = 5;
        int increment = 0;
        w_end = Calendar.getInstance();
        w_end.setTime(this.maxDate);
        w_start = (Calendar)w_end.clone();
        w_start.setTime(this.minDate);
        boolean clearEndMs = false;
        if ("Ultimo anno".equals(this.periodo)) {
            sdf = new SimpleDateFormat("MMM/yy", ApplicationBean.getInstance().getLocale());
            field = 2;
            increment = 1;
            actualStart = (Calendar)w_start.clone();
            actualStart.set(5, actualStart.getActualMinimum(5));
            actualStart.set(11, actualStart.getActualMinimum(11));
            actualStart.set(12, actualStart.getActualMinimum(12));
            actualStart.clear(13);
            actualStart.clear(14);
        } else if ("Ultimi 30 giorni".equals(this.periodo)) {
            sdf = new SimpleDateFormat("dd/MM", ApplicationBean.getInstance().getLocale());
            sdfend = new SimpleDateFormat("dd/MM", ApplicationBean.getInstance().getLocale());
            field = 3;
            increment = 1;
            actualStart = (Calendar)w_start.clone();
            actualStart.set(11, actualStart.getActualMinimum(11));
            actualStart.set(12, actualStart.getActualMinimum(12));
            actualStart.clear(13);
            actualStart.clear(14);
        } else if ("Ultimi 7 giorni".equals(this.periodo)) {
            sdf = new SimpleDateFormat("EEE dd/MM", ApplicationBean.getInstance().getLocale());
            field = 5;
            increment = 1;
            actualStart = (Calendar)w_start.clone();
            actualStart.set(11, actualStart.getActualMinimum(11));
            actualStart.set(12, actualStart.getActualMinimum(12));
            actualStart.clear(13);
            actualStart.clear(14);
        } else if ("Ultime 24 ore".equals(this.periodo)) {
            sdf = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            sdfend = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
            field = 11;
            increment = 1;
            actualStart = (Calendar)w_start.clone();
            actualStart.set(12, actualStart.getActualMinimum(12));
            actualStart.clear(13);
            actualStart.clear(14);
            clearEndMs = true;
        }
        for (int i2 = 0; i2 < this.offset; ++i2) {
            Calendar actualEnd = (Calendar)actualStart.clone();
            actualEnd.add(field, increment);
            actualEnd.add(14, -1);
            Date s = actualStart.getTime();
            Date e = actualEnd.getTime();
            if (i2 == 0) {
                this.startDateForLabel = (Date)s.clone();
            }
            if (i2 == this.offset - 1) {
                this.endDateForLabel = (Date)e.clone();
            }
            ResLive r = null;
            try {
                String protocolloSelected = this.isSelectedShowAllProtocols() ? null : this.protocollo;
                r = this.report.getEsiti(this.getPermessiUtenteOperatore(), s, e, this.periodo, this.esitoContesto, protocolloSelected, this.protocolloDefault, this.tipologiaRicerca);
            }
            catch (CoreException er) {
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il recupero degli esiti");
                log.error(er.getMessage(), (Throwable)er);
                return null;
            }
            error_array[i2] = r.getEsitoKo().intValue();
            fault_array[i2] = r.getEsitoFault().intValue();
            ok_array[i2] = r.getEsitoOk().intValue();
            if (sdfend != null) {
                if (clearEndMs) {
                    actualEnd.add(14, 1);
                    e = actualEnd.getTime();
                }
                labelArray[i2] = MessageFormat.format("[{0}-{1})", sdf.format(s), sdfend.format(e));
            } else {
                labelArray[i2] = sdf.format(s);
            }
            actualStart.add(field, increment);
        }
        String color = "95B964,FF8F52,CD4A50";
        sdf = new SimpleDateFormat("dd MMMMM yyyy HH:mm", ApplicationBean.getInstance().getLocale());
        StringBuilder sb = new StringBuilder();
        sb.append("<chart pallete='3' caption='");
        sb.append(this.getCaption());
        sb.append("' subCaption='");
        sb.append(this.getSubCaption());
        sb.append("' ");
        sb.append("decimals='0' decimalSeparator=',' thousandSeparator='.' useRoundEdges='1' showSum='1' formatNumber='1' formatNumberScale='0' paletteColors='" + color + "' labelDisplay='Rotate' slantLabels='1'>");
        sb.append("<categories>");
        for (int i3 = 0; i3 < this.offset; ++i3) {
            sb.append("<category label='");
            sb.append(labelArray[i3]);
            sb.append("' />");
        }
        sb.append("</categories>");
        int showValues = 0;
        sb.append("<dataset seriesName='Ok' showValues='" + showValues + "' showLabels='1'>");
        for (i = 0; i < this.offset; ++i) {
            sb.append("<set value='");
            sb.append(ok_array[i]);
            sb.append("' />");
        }
        sb.append("</dataset>");
        sb.append("<dataset seriesName='Fault Applicativo' showValues='" + showValues + "' showLabels='1'>");
        for (i = 0; i < this.offset; ++i) {
            sb.append("\t<set value='");
            sb.append(fault_array[i]);
            sb.append("' />");
        }
        sb.append("</dataset>");
        sb.append("<dataset seriesName='Fallite' showValues='" + showValues + "' showLabels='1'>");
        for (i = 0; i < this.offset; ++i) {
            sb.append("\t<set value='");
            sb.append(error_array[i]);
            sb.append("' />");
        }
        sb.append("</dataset>");
        sb.append("</chart> ");
        return sb.toString();
    }

    public String getJson() {
        JSONObject grafico = new JSONObject();
        if (!"--".equals(this.periodo)) {
            grafico.put((Object)"coloriAutomatici", (Object)false);
            grafico.put((Object)"titolo", (Object)this.getCaption());
            grafico.put((Object)"sottotitolo", (Object)this.getSubCaption());
            grafico.put((Object)"yAxisLabel", (Object)"Numero Esiti");
            grafico.put((Object)"mostraLegenda", (Object)true);
            JSONArray categorie = new JSONArray();
            JSONObject categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"ok");
            categoria.put((Object)"label", (Object)"Ok");
            categoria.put((Object)"colore", (Object)"#95B964");
            categorie.add((Object)categoria);
            JSONObject categoria2 = new JSONObject();
            categoria2.put((Object)"key", (Object)"fault");
            categoria2.put((Object)"label", (Object)"Fault Applicativo");
            categoria2.put((Object)"colore", (Object)"#FF8F52");
            categorie.add((Object)categoria2);
            JSONObject categoria3 = new JSONObject();
            categoria3.put((Object)"key", (Object)"errore");
            categoria3.put((Object)"label", (Object)"Fallite");
            categoria3.put((Object)"colore", (Object)"#CD4A50");
            categorie.add((Object)categoria3);
            grafico.put((Object)"categorie", (Object)categorie);
            try {
                JSONArray dati = new JSONArray();
                int[] error_array = new int[this.offset];
                int[] fault_array = new int[this.offset];
                int[] ok_array = new int[this.offset];
                String[] labelArray = new String[this.offset];
                SimpleDateFormat sdf = null;
                SimpleDateFormat sdfend = null;
                Calendar w_end = null;
                Calendar w_start = null;
                Calendar actualStart = null;
                int field = 5;
                int increment = 0;
                w_end = Calendar.getInstance();
                w_end.setTime(this.maxDate);
                w_start = (Calendar)w_end.clone();
                w_start.setTime(this.minDate);
                boolean clearEndMs = false;
                if ("Ultimo anno".equals(this.periodo)) {
                    sdf = new SimpleDateFormat("MMM/yy", ApplicationBean.getInstance().getLocale());
                    field = 2;
                    increment = 1;
                    actualStart = (Calendar)w_start.clone();
                    actualStart.set(5, actualStart.getActualMinimum(5));
                    actualStart.set(11, actualStart.getActualMinimum(11));
                    actualStart.set(12, actualStart.getActualMinimum(12));
                    actualStart.clear(13);
                    actualStart.clear(14);
                } else if ("Ultimi 30 giorni".equals(this.periodo)) {
                    sdf = new SimpleDateFormat("dd/MM", ApplicationBean.getInstance().getLocale());
                    sdfend = new SimpleDateFormat("dd/MM", ApplicationBean.getInstance().getLocale());
                    field = 3;
                    increment = 1;
                    actualStart = (Calendar)w_start.clone();
                    actualStart.set(11, actualStart.getActualMinimum(11));
                    actualStart.set(12, actualStart.getActualMinimum(12));
                    actualStart.clear(13);
                    actualStart.clear(14);
                } else if ("Ultimi 7 giorni".equals(this.periodo)) {
                    sdf = new SimpleDateFormat("EEE dd/MM", ApplicationBean.getInstance().getLocale());
                    field = 5;
                    increment = 1;
                    actualStart = (Calendar)w_start.clone();
                    actualStart.set(11, actualStart.getActualMinimum(11));
                    actualStart.set(12, actualStart.getActualMinimum(12));
                    actualStart.clear(13);
                    actualStart.clear(14);
                } else if ("Ultime 24 ore".equals(this.periodo)) {
                    sdf = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
                    sdfend = new SimpleDateFormat("HH", ApplicationBean.getInstance().getLocale());
                    field = 11;
                    increment = 1;
                    actualStart = (Calendar)w_start.clone();
                    actualStart.set(12, actualStart.getActualMinimum(12));
                    actualStart.clear(13);
                    actualStart.clear(14);
                    clearEndMs = true;
                }
                for (int i = 0; i < this.offset; ++i) {
                    Calendar actualEnd = (Calendar)actualStart.clone();
                    actualEnd.add(field, increment);
                    actualEnd.add(14, -1);
                    Date s = actualStart.getTime();
                    Date e = actualEnd.getTime();
                    ResLive r = null;
                    try {
                        String protocolloSelected = this.isSelectedShowAllProtocols() ? null : this.protocollo;
                        r = this.report.getEsiti(this.getPermessiUtenteOperatore(), s, e, this.periodo, this.esitoContesto, protocolloSelected, this.protocolloDefault, this.tipologiaRicerca);
                    }
                    catch (CoreException er) {
                        MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il recupero degli esiti");
                        log.error(er.getMessage(), (Throwable)er);
                        return null;
                    }
                    error_array[i] = r.getEsitoKo().intValue();
                    fault_array[i] = r.getEsitoFault().intValue();
                    ok_array[i] = r.getEsitoOk().intValue();
                    if (sdfend != null) {
                        if (clearEndMs) {
                            actualEnd.add(14, 1);
                            e = actualEnd.getTime();
                        }
                        labelArray[i] = MessageFormat.format("[{0}-{1})", sdf.format(s), sdfend.format(e));
                    } else {
                        labelArray[i] = sdf.format(s);
                    }
                    actualStart.add(field, increment);
                    JSONObject bar = new JSONObject();
                    bar.put((Object)"data", (Object)labelArray[i]);
                    bar.put((Object)"dataLabel", (Object)labelArray[i]);
                    bar.put((Object)"ok", (Object)ok_array[i]);
                    bar.put((Object)"fault", (Object)fault_array[i]);
                    bar.put((Object)"errore", (Object)error_array[i]);
                    bar.put((Object)"ok_tooltip", (Object)("Ok, " + labelArray[i] + ", " + Utility.numberConverter((Number)ok_array[i])));
                    bar.put((Object)"fault_tooltip", (Object)("Fault Applicativo, " + labelArray[i] + ", " + Utility.numberConverter((Number)fault_array[i])));
                    bar.put((Object)"errore_tooltip", (Object)("Fallite, " + labelArray[i] + ", " + Utility.numberConverter((Number)error_array[i])));
                    dati.add((Object)bar);
                }
                grafico.put((Object)"dati", (Object)dati);
                grafico.put((Object)"xAxisLabelDirezione", (Object)(dati.size() > 12 ? -45 : 0));
                grafico.put((Object)"xAxisGridLines", (Object)true);
            }
            catch (Exception e) {
                log.error("Errore durante la generazione del json: " + e.getMessage(), (Throwable)e);
                return "";
            }
            return grafico.toString();
        }
        return "";
    }

    public String getData() {
        if (this.isUseGraficiSVG()) {
            return this.getJson();
        }
        return this.getXml();
    }

    private PermessiUtenteOperatore getPermessiUtenteOperatore() throws CoreException {
        int foundServizi;
        UserDetailsBean loggedUser = Utility.getLoggedUser();
        String loggedUtenteSoggettoPddMonitor = Utility.getLoggedUtenteSoggettoPddMonitor();
        String forceSoggettoLocale = null;
        if (!this.isShowFiltroSoggettoLocale() || !"qualsiasi".equals(loggedUtenteSoggettoPddMonitor)) {
            forceSoggettoLocale = loggedUtenteSoggettoPddMonitor;
        }
        String tipoProtocollo = this.getProtocollo();
        int foundSoggetti = loggedUser.getUtenteSoggettoProtocolliMap().containsKey(tipoProtocollo) ? ((List)loggedUser.getUtenteSoggettoProtocolliMap().get(tipoProtocollo)).size() : 0;
        int n = foundServizi = loggedUser.getUtenteServizioProtocolliMap().containsKey(tipoProtocollo) ? ((List)loggedUser.getUtenteServizioProtocolliMap().get(tipoProtocollo)).size() : 0;
        if (foundServizi + foundSoggetti == 1) {
            IDServizio idServizio = null;
            if (foundServizi == 1) {
                idServizio = (IDServizio)((List)loggedUser.getUtenteServizioProtocolliMap().get(tipoProtocollo)).get(0);
            } else {
                idServizio = new IDServizio();
                idServizio.setSoggettoErogatore((IDSoggetto)((List)loggedUser.getUtenteSoggettoProtocolliMap().get(tipoProtocollo)).get(0));
            }
            this.soggettoLocale = Utility.convertToSoggettoServizio((IDServizio)idServizio);
        }
        String tipoSoggettoLocale = null;
        String nomeSoggettoLocale = null;
        String tipoServizio = null;
        String nomeServizio = null;
        Integer versioneServizio = null;
        IDServizio idServizio = null;
        if (this.soggettoLocale != null && !StringUtils.isEmpty((String)this.soggettoLocale) && !"--".equals(this.soggettoLocale)) {
            idServizio = Utility.parseSoggettoServizio((String)this.soggettoLocale);
        } else if (!"qualsiasi".equals(loggedUtenteSoggettoPddMonitor)) {
            idServizio = Utility.parseSoggettoServizio((String)forceSoggettoLocale);
        }
        if (idServizio != null) {
            tipoSoggettoLocale = idServizio.getSoggettoErogatore().getTipo();
            nomeSoggettoLocale = idServizio.getSoggettoErogatore().getNome();
            versioneServizio = idServizio.getVersione();
            tipoServizio = idServizio.getTipo();
            nomeServizio = idServizio.getNome();
        }
        return PermessiUtenteOperatore.getPermessiUtenteOperatore((UserDetailsBean)loggedUser, (String)tipoSoggettoLocale, nomeSoggettoLocale, tipoServizio, nomeServizio, versioneServizio);
    }

    private String getSubCaption() {
        SimpleDateFormat sdf = null;
        sdf = !"Ultime 24 ore".equals(this.periodo) ? new SimpleDateFormat("dd MMMMM yyyy", ApplicationBean.getInstance().getLocale()) : new SimpleDateFormat("dd MMMMM yyyy', ore' HH:mm", ApplicationBean.getInstance().getLocale());
        String res = MessageFormat.format(" ( dal {0} al {1} )", sdf.format(this.getMinDate()), sdf.format(this.getMaxDate()));
        return StringEscapeUtils.escapeXml((String)res);
    }

    private Date getMinDate() {
        return this.minDate;
    }

    private Date getMaxDate() {
        return this.maxDate;
    }

    private String getCaption() {
        return StringEscapeUtils.escapeXml((String)"Distribuzione Esito dei messaggi nell'ultimo periodo.");
    }

    public String getDataLive() {
        if (this.isUseGraficiSVG()) {
            return this.getJsonLive();
        }
        return this.getXmlLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlLive() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
        ResLive esiti = null;
        try {
            String protocolloSelected = this.isSelectedShowAllProtocols() ? null : this.protocollo;
            esiti = this.transazioniService.getEsitiInfoLive(this.getPermessiUtenteOperatore(), this.lastRequest, protocolloSelected, this.protocolloDefault);
        }
        catch (CoreException e) {
            MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il recupero degli esiti");
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        this.lastRequest = esiti.getRisultato();
        List<ResLive> e = this.dataLive;
        synchronized (e) {
            this.dataLive.add(esiti);
            if (this.dataLive.size() > this.maxDataStored) {
                this.dataLive.remove(0);
            }
        }
        String url = FacesContext.getCurrentInstance().getExternalContext().getRequestContextPath() + "/pages/list/transazioni.jsf";
        String color = "95B964,FF8F52,CD4A50";
        StringBuilder sb = new StringBuilder();
        sb.append("<chart clickURL='");
        sb.append(url);
        sb.append("' caption='Esito Transazioni' animation='0' rotateLabels='1' slantLabels='1' xAxisName='Tempo' yAxisName='Totale Transazioni' showValues='0' numberPrefix='#' paletteColors='" + color + "' >");
        StringBuilder categories = new StringBuilder();
        StringBuilder ok = new StringBuilder();
        StringBuilder fault = new StringBuilder();
        StringBuilder ko = new StringBuilder();
        for (ResLive res : this.dataLive) {
            categories.append("<category label='" + formatter.format(res.getRisultato()) + "' />");
            ok.append("<set value='" + res.getEsitoOk() + "' />");
            fault.append("<set value='" + res.getEsitoFault() + "' />");
            ko.append("<set value='" + res.getEsitoKo() + "' />");
        }
        sb.append("<categories>");
        sb.append(categories.toString());
        sb.append("</categories>");
        sb.append("<dataset seriesName='Ok'>");
        sb.append(ok.toString());
        sb.append("</dataset>");
        sb.append("<dataset seriesName='Fault Applicativo'>");
        sb.append(fault.toString());
        sb.append("</dataset>");
        sb.append("<dataset seriesName='Fallite'>");
        sb.append(ko.toString());
        sb.append("</dataset>");
        sb.append("</chart>");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJsonLive() {
        JSONObject grafico = new JSONObject();
        try {
            grafico.put((Object)"coloriAutomatici", (Object)false);
            grafico.put((Object)"titolo", (Object)"Esito Transazioni");
            grafico.put((Object)"sottotitolo", (Object)"");
            grafico.put((Object)"yAxisLabel", (Object)"Totale Transazioni");
            grafico.put((Object)"mostraLegenda", (Object)true);
            JSONArray categorie = new JSONArray();
            JSONObject categoria = new JSONObject();
            categoria.put((Object)"key", (Object)"ok");
            categoria.put((Object)"label", (Object)"Ok");
            categoria.put((Object)"colore", (Object)"#95B964");
            categorie.add((Object)categoria);
            JSONObject categoria2 = new JSONObject();
            categoria2.put((Object)"key", (Object)"fault");
            categoria2.put((Object)"label", (Object)"Fault Applicativo");
            categoria2.put((Object)"colore", (Object)"#FF8F52");
            categorie.add((Object)categoria2);
            JSONObject categoria3 = new JSONObject();
            categoria3.put((Object)"key", (Object)"errore");
            categoria3.put((Object)"label", (Object)"Fallite");
            categoria3.put((Object)"colore", (Object)"#CD4A50");
            categorie.add((Object)categoria3);
            grafico.put((Object)"categorie", (Object)categorie);
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            ResLive esiti = null;
            try {
                String protocolloSelected = this.isSelectedShowAllProtocols() ? null : this.protocollo;
                esiti = this.transazioniService.getEsitiInfoLive(this.getPermessiUtenteOperatore(), this.lastRequest, protocolloSelected, this.protocolloDefault);
            }
            catch (CoreException e) {
                MessageUtils.addErrorMsg((String)"Si e' verificato un errore durante il recupero degli esiti");
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
            this.lastRequest = esiti.getRisultato();
            List<ResLive> e = this.dataLive;
            synchronized (e) {
                this.dataLive.add(esiti);
                if (this.dataLive.size() > this.maxDataStored) {
                    this.dataLive.remove(0);
                }
            }
            JSONArray dati = new JSONArray();
            for (ResLive res : this.dataLive) {
                String data = formatter.format(res.getRisultato());
                String nOk = "" + res.getEsitoOk();
                String nFault = "" + res.getEsitoFault();
                String nKo = "" + res.getEsitoKo();
                JSONObject bar = new JSONObject();
                bar.put((Object)"data", (Object)data);
                bar.put((Object)"ok", (Object)nOk);
                bar.put((Object)"fault", (Object)nFault);
                bar.put((Object)"errore", (Object)nKo);
                bar.put((Object)"ok_tooltip", (Object)("Ok, " + data + ", " + nOk));
                bar.put((Object)"fault_tooltip", (Object)("Fault Applicativo, " + data + ", " + nFault));
                bar.put((Object)"errore_tooltip", (Object)("Fallite, " + data + ", " + nKo));
                dati.add((Object)bar);
            }
            grafico.put((Object)"dati", (Object)dati);
            grafico.put((Object)"xAxisLabelDirezione", (Object)(dati.size() > 12 ? -45 : 0));
            grafico.put((Object)"xAxisGridLines", (Object)true);
        }
        catch (Exception e) {
            log.error("Errore durante la generazione del json live: " + e.getMessage(), (Throwable)e);
            return "";
        }
        return grafico.toString();
    }

    public String getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(String periodo) {
        this.periodo = periodo;
        if ("Ultimo anno".equals(periodo)) {
            Calendar max = Calendar.getInstance();
            this.maxDate = max.getTime();
            Calendar min = (Calendar)max.clone();
            min.add(2, -11);
            min.set(5, min.getActualMinimum(5));
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
            this.minDate = min.getTime();
            this.offset = 12;
        } else if ("Ultimi 30 giorni".equals(periodo)) {
            Calendar max = Calendar.getInstance();
            this.maxDate = max.getTime();
            Calendar min = (Calendar)max.clone();
            min.add(5, -30);
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
            this.minDate = min.getTime();
            this.offset = 5;
        } else if ("Ultimi 7 giorni".equals(periodo)) {
            Calendar max = Calendar.getInstance();
            this.maxDate = max.getTime();
            Calendar min = (Calendar)max.clone();
            min.add(5, -6);
            min.set(11, min.getActualMinimum(11));
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
            this.minDate = min.getTime();
            this.offset = 7;
        } else if ("Ultime 24 ore".equals(periodo)) {
            Calendar max = Calendar.getInstance();
            this.maxDate = max.getTime();
            Calendar min = (Calendar)max.clone();
            min.add(11, 1);
            min.add(11, -24);
            min.set(12, min.getActualMinimum(12));
            min.clear(13);
            min.clear(14);
            this.minDate = min.getTime();
            this.offset = 24;
        }
        this.salvaStatoPeriodo(this.periodo);
    }

    public String getSoggettoLocale() {
        return this.soggettoLocale;
    }

    public void setSoggettoLocale(String soggettoLocale) {
        this.soggettoLocale = soggettoLocale;
        if (StringUtils.isEmpty((String)soggettoLocale) || "--".equals(soggettoLocale)) {
            this.soggettoLocale = null;
        }
    }

    public String getLabelSoggettoLocale() {
        return this.labelSoggettoLocale;
    }

    public void setLabelSoggettoLocale(String labelSoggettoLocale) {
        this.labelSoggettoLocale = labelSoggettoLocale;
        if (StringUtils.isEmpty((String)this.labelSoggettoLocale) || "--".equals(this.labelSoggettoLocale)) {
            this.labelSoggettoLocale = null;
        }
    }

    public String getSoggettoLocaleTooltip() {
        if (this.soggettoLocale != null && !StringUtils.isEmpty((String)this.soggettoLocale) && !"--".equals(this.soggettoLocale)) {
            try {
                String tipoProtocollo = this.getProtocollo();
                IDServizio idServizio = Utility.parseSoggettoServizio((String)this.soggettoLocale);
                String nomeServizio = idServizio.getNome();
                String label = nomeServizio == null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idServizio.getSoggettoErogatore()) : NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio);
                return label;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.soggettoLocale;
    }

    public List<Soggetto> soggettiAutoComplete(Object val) {
        List<Object> list = null;
        Soggetto s = new Soggetto();
        s.setNomeSoggetto("--");
        String tipoProtocollo = this.getProtocollo();
        list = val == null || StringUtils.isEmpty((String)((String)val)) ? new ArrayList<Soggetto>() : this.dynamicUtilsService.soggettiAutoComplete(tipoProtocollo, (String)val);
        list.add(0, s);
        return list;
    }

    public List<javax.faces.model.SelectItem> getTipiNomiSoggettiAssociati() throws Exception {
        return this._getTipiNomiSoggettiAssociati(false);
    }

    public List<javax.faces.model.SelectItem> _getTipiNomiSoggettiAssociati(boolean soloOperativi) throws Exception {
        if (!this.soggettiAssociatiSelectItemsWidthCheck) {
            this.soggettiAssociati = new ArrayList<javax.faces.model.SelectItem>();
            ArrayList<IDSoggetto> lstSoggTmp = new ArrayList<IDSoggetto>();
            ArrayList<IDServizio> lstServTmp = new ArrayList<IDServizio>();
            UserDetailsBean loggedUser = Utility.getLoggedUser();
            if (loggedUser != null) {
                String tipoProtocollo = this.getProtocollo();
                HashMap<String, String> mapInternal = new HashMap<String, String>();
                if (tipoProtocollo != null) {
                    ArrayList tipiNomiServiziAssociati;
                    Iterator tipiNomiSoggettiAssociati = loggedUser.getUtenteSoggettoProtocolliMap().containsKey(tipoProtocollo) ? (List)loggedUser.getUtenteSoggettoProtocolliMap().get(tipoProtocollo) : new ArrayList();
                    List list = tipiNomiServiziAssociati = loggedUser.getUtenteServizioProtocolliMap().containsKey(tipoProtocollo) ? (List)loggedUser.getUtenteServizioProtocolliMap().get(tipoProtocollo) : new ArrayList();
                    if (tipiNomiSoggettiAssociati != null && tipiNomiSoggettiAssociati.size() > 0) {
                        Iterator<Object> iterator = tipiNomiSoggettiAssociati.iterator();
                        while (iterator.hasNext()) {
                            IDSoggetto iDSoggetto = (IDSoggetto)iterator.next();
                            boolean add = true;
                            if (soloOperativi) {
                                String nomePddFromSoggetto = this.dynamicUtils.getServerFromSoggetto(iDSoggetto.getTipo(), iDSoggetto.getNome());
                                add = this.dynamicUtils.checkTipoPdd(nomePddFromSoggetto, TipoPdD.OPERATIVO);
                            }
                            if (!add) continue;
                            lstSoggTmp.add(iDSoggetto);
                        }
                    }
                    if (tipiNomiServiziAssociati != null && tipiNomiServiziAssociati.size() > 0) {
                        for (IDServizio iDServizio : tipiNomiServiziAssociati) {
                            lstServTmp.add(iDServizio);
                        }
                    }
                }
                if (lstSoggTmp != null && lstSoggTmp.size() > 0) {
                    for (IDSoggetto idSoggetto : lstSoggTmp) {
                        IDServizio idServizio = new IDServizio();
                        idServizio.setSoggettoErogatore(idSoggetto);
                        String string = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)idSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
                        mapInternal.put(ParseUtility.convertToSoggettoServizio((IDServizio)idServizio), string);
                    }
                }
                if (lstServTmp != null && lstServTmp.size() > 0) {
                    for (IDServizio idServizio : lstServTmp) {
                        String label = tipoProtocollo != null ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
                        mapInternal.put(ParseUtility.convertToSoggettoServizio((IDServizio)idServizio), label);
                    }
                }
                if (mapInternal.size() > 0) {
                    LinkedList tmpList = new LinkedList(mapInternal.entrySet());
                    Collections.sort(tmpList, new Comparator<Map.Entry<String, String>>(){

                        @Override
                        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                            return o1.getValue().compareTo(o2.getValue());
                        }
                    });
                    LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : tmpList) {
                        sortedMap.put((String)entry.getKey(), (String)entry.getValue());
                    }
                    for (String string : sortedMap.keySet()) {
                        this.soggettiAssociati.add(new javax.faces.model.SelectItem((Object)string, (String)sortedMap.get(string)));
                    }
                }
                Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(this.soggettiAssociati);
                this.soggettiAssociatiSelectItemsWidth = Math.max(this.soggettiAssociatiSelectItemsWidth, lunghezzaSelectList);
            }
        }
        return this.soggettiAssociati;
    }

    public List<SelectItem> soggettiServiziAutoComplete(Object val) throws Exception {
        ArrayList<SelectItem> listaServizi = new ArrayList<SelectItem>();
        List<Object> listaServiziTmp = new ArrayList();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            listaServiziTmp = this._soggettiServiziAutoComplete((String)val);
        }
        for (javax.faces.model.SelectItem selectItem : listaServiziTmp) {
            String label = selectItem.getLabel();
            String value = (String)selectItem.getValue();
            SelectItem newItem = new SelectItem(value, label);
            listaServizi.add(newItem);
        }
        return listaServizi;
    }

    public List<javax.faces.model.SelectItem> _soggettiServiziAutoComplete(Object val) throws Exception {
        this.soggettiSelectItemsWidth = 0;
        ArrayList<javax.faces.model.SelectItem> list = new ArrayList<javax.faces.model.SelectItem>();
        list.add(new javax.faces.model.SelectItem((Object)"--", "--"));
        String tipoProtocollo = this.getProtocollo();
        if (val != null && !StringUtils.isEmpty((String)((String)val))) {
            List listServizi;
            String loggedUtenteSoggettoPddMonitor;
            IDServizio idServizio;
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            HashMap<String, String> mapInternal = new HashMap<String, String>();
            if (this.isShowFiltroSoggettoLocale()) {
                List listSoggetti = this.dynamicUtilsService.soggettiAutoComplete(tipoProtocollo, (String)val);
                if (listSoggetti != null && listSoggetti.size() > 0) {
                    for (Soggetto soggetto : listSoggetti) {
                        idServizio = new IDServizio();
                        IDSoggetto iDSoggetto = new IDSoggetto(soggetto.getTipoSoggetto(), soggetto.getNomeSoggetto());
                        idServizio.setSoggettoErogatore(iDSoggetto);
                        String label = tipoProtocollo != null ? NamingUtils.getLabelSoggetto((String)tipoProtocollo, (IDSoggetto)iDSoggetto) : NamingUtils.getLabelSoggetto((IDSoggetto)iDSoggetto);
                        mapInternal.put(ParseUtility.convertToSoggettoServizio((IDServizio)idServizio), label);
                    }
                }
            } else if (this.tipologiaRicerca != null && TipologiaRicerca.ingresso.equals((Object)this.tipologiaRicerca) && !"qualsiasi".equals(loggedUtenteSoggettoPddMonitor = Utility.getLoggedUtenteSoggettoPddMonitor())) {
                tipoSoggetto = Utility.parseTipoSoggetto((String)loggedUtenteSoggettoPddMonitor);
                nomeSoggetto = Utility.parseNomeSoggetto((String)loggedUtenteSoggettoPddMonitor);
            }
            if ((listServizi = this.dynamicUtilsService.getServizi(tipoProtocollo, null, tipoSoggetto, nomeSoggetto, (String)val, Boolean.valueOf(false))) != null && listServizi.size() > 0) {
                for (AccordoServizioParteSpecifica asps : listServizi) {
                    idServizio = new IDServizio();
                    idServizio.setSoggettoErogatore(new IDSoggetto(asps.getIdErogatore().getTipo(), asps.getIdErogatore().getNome()));
                    idServizio.setTipo(asps.getTipo());
                    idServizio.setNome(asps.getNome());
                    idServizio.setVersione(asps.getVersione());
                    String string = tipoProtocollo != null ? NamingUtils.getLabelAccordoServizioParteSpecifica((String)tipoProtocollo, (IDServizio)idServizio) : NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
                    mapInternal.put(ParseUtility.convertToSoggettoServizio((IDServizio)idServizio), string);
                }
            }
            if (mapInternal.size() > 0) {
                LinkedList tmpList = new LinkedList(mapInternal.entrySet());
                Collections.sort(tmpList, new Comparator<Map.Entry<String, String>>(){

                    @Override
                    public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                });
                LinkedHashMap<String, String> sortedMap = new LinkedHashMap<String, String>();
                for (Map.Entry entry : tmpList) {
                    sortedMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                for (String string : sortedMap.keySet()) {
                    list.add(new javax.faces.model.SelectItem((Object)string, (String)sortedMap.get(string)));
                }
            }
        }
        Integer lunghezzaSelectList = this.dynamicUtils.getLunghezzaSelectList(list);
        this.soggettiSelectItemsWidth = Math.max(this.soggettiSelectItemsWidth, lunghezzaSelectList);
        return list;
    }

    public String getIntervalloRefresh() {
        return this.intervalloRefresh;
    }

    public void setIntervalloRefresh(String intervalloRefresh) {
        this.intervalloRefresh = intervalloRefresh;
    }

    public void salvaStatoPeriodo(String statoPeriodo) {
        if (this.funzionalitaStatisticaAbilitata) {
            String p = statoPeriodo;
            p = Utils.incapsulaValoreStato((String)p);
            if (this.salvaModificheProfiloSuDB) {
                Stato state = this.userService.getTableState(STATO_PERIODO, Utility.getLoggedUtente());
                state.setStato(p);
                this.userService.saveTableState(STATO_PERIODO, Utility.getLoggedUtente(), state);
            } else {
                for (Stato stato : Utility.getLoggedUtente().getStati()) {
                    if (!stato.getOggetto().equals(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE)) continue;
                    stato.setStato(p);
                    break;
                }
            }
        }
    }

    public String leggiStatoPeriodo() {
        Stato state = null;
        if (this.salvaModificheProfiloSuDB) {
            state = this.userService.getTableState(STATO_PERIODO, Utility.getLoggedUtente());
        } else {
            for (Stato stato : Utility.getLoggedUtente().getStati()) {
                if (!stato.getOggetto().equals(Costanti.OGGETTO_STATO_UTENTE_INTERVALLO_TEMPORALE_HOME_PAGE)) continue;
                state = stato;
                break;
            }
        }
        if (state == null) {
            return null;
        }
        String statoPeriodo = state.getStato();
        return Utils.extractValoreStato((String)statoPeriodo);
    }

    public boolean isShowEsitiContesto() {
        return this.getEsitiContesto().size() > 2;
    }

    public List<javax.faces.model.SelectItem> getEsitiContesto() {
        ArrayList<javax.faces.model.SelectItem> list = new ArrayList<javax.faces.model.SelectItem>();
        try {
            String protocolloSelected = this.isSelectedShowAllProtocols() ? this.protocolloDefault : this.protocollo;
            EsitoUtils esitoUtils = new EsitoUtils(log, protocolloSelected);
            list.add(new javax.faces.model.SelectItem((Object)"-", esitoUtils.getEsitoContestoLabelFromValue((Object)"-")));
            List esiti = this.esitiProperties.getEsitiTransactionContextCodeOrderLabel();
            for (String esito : esiti) {
                javax.faces.model.SelectItem si = new javax.faces.model.SelectItem((Object)esito, esitoUtils.getEsitoContestoLabelFromValue((Object)esito));
                list.add(si);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return list;
    }

    public boolean isUseGraficiSVG() {
        BrowserInfo browserInfo = ApplicationBean.getInstance().getBrowserInfo();
        this.useGraficiSVG = ApplicationBean.getInstance().isGraficiSvgEnabled() && !BrowserFilter.disabilitaGraficiSVG((BrowserInfo)browserInfo);
        LoggerManager.getPddMonitorCoreLogger().trace("Usa grafici SVG [" + this.useGraficiSVG + "]");
        return this.useGraficiSVG;
    }

    public void setUseGraficiSVG(boolean useGraficiSVG) {
        this.useGraficiSVG = useGraficiSVG;
    }

    public String getSoggettiAssociatiSelectItemsWidth() throws Exception {
        this.soggettiAssociatiSelectItemsWidthCheck = false;
        this.getTipiNomiSoggettiAssociati();
        this.soggettiAssociatiSelectItemsWidthCheck = true;
        return this.checkWidthLimits(this.soggettiAssociatiSelectItemsWidth).toString();
    }

    public Integer getSoggettiAssociatiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.soggettiAssociatiSelectItemsWidth);
    }

    public boolean isSoggettiAssociatiSelectItemsWidthCheck() {
        return this.soggettiAssociatiSelectItemsWidthCheck;
    }

    public void setSoggettiAssociatiSelectItemsWidthCheck(boolean soggettiAssociatiSelectItemsWidthCheck) {
        this.soggettiAssociatiSelectItemsWidthCheck = soggettiAssociatiSelectItemsWidthCheck;
    }

    public String getSoggettiSelectItemsWidth() throws Exception {
        return this.checkWidthLimits(this.soggettiSelectItemsWidth).toString();
    }

    public Integer getSoggettiSelectItemsWidthAsInteger() throws Exception {
        return this.checkWidthLimits(this.soggettiSelectItemsWidth);
    }

    public boolean isSoggettiSelectItemsWidthCheck() {
        return this.soggettiSelectItemsWidthCheck;
    }

    public void setSoggettiSelectItemsWidthCheck(boolean soggettiSelectItemsWidthCheck) {
        this.soggettiSelectItemsWidthCheck = soggettiSelectItemsWidthCheck;
    }

    public Integer checkWidthLimits(Integer value) {
        Integer toRet = Math.max(this.defaultSelectItemsWidth, value);
        toRet = Math.min(toRet, this.maxSelectItemsWidth);
        return toRet;
    }

    public List<Soggetto> getSoggettiGestione() {
        User u = Utility.getLoggedUtente();
        return Utility.getSoggettiGestione((User)u, (String)this.soggettoLocale);
    }

    public String getProtocollo() {
        if (this.isShowListaProtocolli()) {
            if (!Utility.getLoginBean().getModalita().equals("qualsiasi")) {
                this.setProtocollo(Utility.getLoginBean().getModalita());
            }
        } else {
            User utente = Utility.getLoggedUtente();
            if (utente.getProtocolloSelezionatoPddMonitor() != null) {
                this.setProtocollo(utente.getProtocolloSelezionatoPddMonitor());
            } else if (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() > 0) {
                this.setProtocollo((String)utente.getProtocolliSupportati().get(0));
            } else {
                try {
                    this.setProtocollo(ProtocolFactoryManager.getInstance().getDefaultProtocolFactory().getProtocol());
                }
                catch (ProtocolException e) {
                    this.setProtocollo(null);
                }
            }
        }
        return this.protocollo;
    }

    public void setProtocollo(String protocollo) {
        this.protocollo = protocollo;
        if (StringUtils.isEmpty((String)protocollo) || "*".equals(protocollo)) {
            this.protocollo = null;
        }
    }

    public List<javax.faces.model.SelectItem> getProtocolli() throws Exception {
        this.protocolli = new ArrayList<javax.faces.model.SelectItem>();
        if (this.protocolliSupportati > 1) {
            this.protocolli.add(new javax.faces.model.SelectItem((Object)"qualsiasi", "Tutti"));
        }
        try {
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            User utente = Utility.getLoggedUtente();
            List listaNomiProtocolli = Utility.getProtocolli((User)utente, (ProtocolFactoryManager)pfManager, (MapReader)protocolFactories, (boolean)true);
            for (String protocolKey : listaNomiProtocolli) {
                IProtocolFactory protocollo = (IProtocolFactory)protocolFactories.get((Object)protocolKey);
                this.protocolli.add(new javax.faces.model.SelectItem((Object)protocollo.getProtocol(), NamingUtils.getLabelProtocollo((String)protocollo.getProtocol())));
            }
        }
        catch (ProtocolException e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return this.protocolli;
    }

    public boolean isSelectedShowAllProtocols() {
        return "qualsiasi".contentEquals(this.protocollo);
    }

    public boolean isShowListaProtocolli() {
        try {
            ProtocolFactoryManager pfManager = ProtocolFactoryManager.getInstance();
            MapReader protocolFactories = pfManager.getProtocolFactories();
            int numeroProtocolli = protocolFactories.size();
            if (numeroProtocolli == 1) {
                return false;
            }
            User utente = Utility.getLoggedUtente();
            if (utente.getProtocolloSelezionatoPddMonitor() != null) {
                return false;
            }
            if (utente.getProtocolliSupportati() != null && utente.getProtocolliSupportati().size() <= 1) {
                return false;
            }
            List listaNomiProtocolli = Utility.getProtocolli((User)utente, (ProtocolFactoryManager)pfManager, (MapReader)protocolFactories, (boolean)true);
            numeroProtocolli = listaNomiProtocolli.size();
            if (numeroProtocolli == 1) {
                return false;
            }
        }
        catch (Exception e) {
            log.error("Si e' verificato un errore durante il caricamento della lista protocolli: " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public boolean isSetFiltroProtocollo() {
        boolean setFilter = StringUtils.isNotEmpty((String)this.getProtocollo()) && (this.isShowListaProtocolli() || !Utility.getLoginBean().getModalita().equals("qualsiasi"));
        return setFilter;
    }

    public void protocolloSelected(ActionEvent ae) {
        this.soggettoLocale = null;
        this.labelSoggettoLocale = null;
    }

    public String getLabelServizio() {
        return !this.isShowFiltroSoggettoLocale() ? MessageManager.getInstance().getMessage("commons.api.label") : MessageManager.getInstance().getMessage("transazioni.summary.soggettoLocaleServizio.label");
    }

    public boolean isShowFiltroSoggettoLocale() {
        return Utility.getLoginBean().isShowFiltroSoggettoLocale();
    }

    public String getLabelTipiNomiSoggettiServiziAssociati() {
        boolean foundServizi;
        User utente = Utility.getLoggedUtente();
        boolean foundSoggetti = utente.getSoggetti() != null && utente.getSoggetti().size() > 0;
        boolean bl = foundServizi = utente.getServizi() != null && utente.getServizi().size() > 0;
        if (foundSoggetti && foundServizi) {
            return MessageManager.getInstance().getMessage("transazioni.summary.soggettoLocaleServizio.label");
        }
        if (foundServizi) {
            return MessageManager.getInstance().getMessage("commons.api.label");
        }
        return MessageManager.getInstance().getMessage("commons.soggettoLocale.label");
    }
}

