/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.monitor.transazioni.mbean;

import java.util.ArrayList;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Trasmissione;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.utils.beans.BlackListElement;
import org.openspcoop2.web.monitor.core.utils.BeanUtils;

public class TrasmissioneBean
extends Trasmissione {
    private static final long serialVersionUID = 1L;
    private transient IProtocolFactory<?> protocolFactory;
    private transient ITraduttore traduttore;

    public TrasmissioneBean(Trasmissione trasmissione, IProtocolFactory<?> protocolFactory) {
        this.protocolFactory = protocolFactory;
        try {
            this.traduttore = this.protocolFactory.createTraduttore();
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
        ArrayList<BlackListElement> metodiEsclusi = new ArrayList<BlackListElement>(0);
        metodiEsclusi.add(new BlackListElement("setProtocolFactory", new Class[]{IProtocolFactory.class}));
        metodiEsclusi.add(new BlackListElement("setTempoValue", new Class[]{String.class}));
        BeanUtils.copy((Object)((Object)this), (Object)trasmissione, metodiEsclusi);
        this.setTempo(trasmissione.getTempo());
        try {
            if (this.getTempo() != null) {
                this.setTempoValue(trasmissione.getTempoValue(protocolFactory));
            }
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    public String getTempoRicavato() {
        if (this.getTempoValue() != null) {
            return this.getTempoValue();
        }
        if (this.getTempo() != null) {
            return this.getTempo().getEngineValue();
        }
        return null;
    }

    public String getTempoValue() {
        try {
            return super.getTempoValue(this.protocolFactory) == null ? this.traduttore.toString(this.getTempo()) : super.getTempoValue(this.protocolFactory);
        }
        catch (Exception e) {
            if (this.protocolFactory != null && this.protocolFactory.getLogger() != null) {
                this.protocolFactory.getLogger().error(e.getMessage(), (Throwable)e);
            } else {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }
}

