/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.BYOKLocalEncrypt;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKConfig;
import org.openspcoop2.utils.certificate.byok.BYOKInstance;
import org.openspcoop2.utils.certificate.byok.BYOKMode;
import org.openspcoop2.utils.certificate.byok.BYOKRemoteUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class BYOKStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] storeBytes;
    private BYOKConfig config;
    private String key;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("BYOKStore (").append(this.config.getLabel()).append(") ").append(this.key);
        return bf.toString();
    }

    public BYOKStore(String key, BYOKInstance instance) throws SecurityException {
        this.key = key;
        try {
            if (instance == null) {
                throw new SecurityException("Instance non fornita");
            }
            this.config = instance.getConfig();
            if (instance.getHttpRequest() != null) {
                this.remoteProcess(instance);
            } else {
                BYOKLocalEncrypt localEncrypt = new BYOKLocalEncrypt();
                this.storeBytes = BYOKMode.WRAP.equals((Object)this.config.getMode()) ? localEncrypt.wrap(instance.getLocalConfigResolved(), instance.getLocalKey()).getBytes() : localEncrypt.unwrap(instance.getLocalConfigResolved(), instance.getLocalKey());
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private void remoteProcess(BYOKInstance instance) throws UtilsException, SecurityException {
        HttpResponse httpResponse = HttpUtilities.httpInvoke((HttpRequest)instance.getHttpRequest());
        if (httpResponse == null || httpResponse.getContent() == null) {
            throw new SecurityException("Store '" + this.config.getLabel() + "' (endpoint:" + instance.getHttpRequest().getUrl() + ") unavailable");
        }
        if (httpResponse.getResultHTTPOperation() != 200) {
            throw new SecurityException("Retrieve store '" + this.config.getLabel() + "' (endpoint:" + instance.getHttpRequest().getUrl() + ") failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
        }
        this.storeBytes = httpResponse.getContent();
        if (this.storeBytes != null && this.storeBytes.length > 0) {
            this.storeBytes = BYOKRemoteUtils.normalizeResponse((BYOKInstance)instance, (byte[])this.storeBytes, (Logger)LoggerWrapperFactory.getLogger(BYOKStore.class));
        }
    }

    public byte[] getStoreBytes() {
        return this.storeBytes;
    }
}

