/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Properties;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.FixTrustAnchorsNotEmpty;
import org.openspcoop2.security.keystore.StoreUtils;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.byok.BYOKRequestParams;
import org.openspcoop2.utils.certificate.hsm.HSMManager;

public class MerlinKeystore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient org.openspcoop2.utils.certificate.KeyStore ks = null;
    private byte[] ksBytes;
    private String tipoStore = null;
    private String pathStore = null;
    private String passwordStore = null;
    private String passwordPrivateKey = null;
    private volatile boolean hsm;

    public String toString() {
        StringBuilder bf = new StringBuilder();
        bf.append("KeyStore (").append(this.tipoStore).append(") ").append(this.pathStore);
        return bf.toString();
    }

    public MerlinKeystore(String propertyFilePath) throws SecurityException {
        this.initMerlinKeystoreEngine(propertyFilePath, null, false, null);
    }

    public MerlinKeystore(String propertyFilePath, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(propertyFilePath, null, false, requestParams);
    }

    public MerlinKeystore(String propertyFilePath, String passwordPrivateKey) throws SecurityException {
        this.initMerlinKeystoreEngine(propertyFilePath, passwordPrivateKey, true, null);
    }

    public MerlinKeystore(String propertyFilePath, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(propertyFilePath, passwordPrivateKey, true, requestParams);
    }

    private void initMerlinKeystoreEngine(String propertyFilePath, String passwordPrivateKey, boolean privatePasswordRequired, BYOKRequestParams requestParams) throws SecurityException {
        Properties propStore = StoreUtils.readProperties("PropertyFilePath", propertyFilePath);
        this.initMerlinKeystoreEngine(propStore, passwordPrivateKey, privatePasswordRequired, requestParams);
    }

    public MerlinKeystore(Properties propStore) throws SecurityException {
        this.initMerlinKeystoreEngine(propStore, null, false, null);
    }

    public MerlinKeystore(Properties propStore, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(propStore, null, false, requestParams);
    }

    public MerlinKeystore(Properties propStore, String passwordPrivateKey) throws SecurityException {
        this.initMerlinKeystoreEngine(propStore, passwordPrivateKey, true, null);
    }

    public MerlinKeystore(Properties propStore, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(propStore, passwordPrivateKey, true, requestParams);
    }

    private void initMerlinKeystoreEngine(Properties propStore, String passwordPrivateKey, boolean privatePasswordRequired, BYOKRequestParams requestParams) throws SecurityException {
        try {
            if (propStore == null) {
                throw new SecurityException("Properties per lo Store non indicato");
            }
            this.tipoStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.type");
            this.tipoStore = this.tipoStore != null ? this.tipoStore.trim() : KeyStore.getDefaultType();
            this.pathStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.file");
            this.passwordStore = propStore.getProperty("org.apache.ws.security.crypto.merlin.keystore.password");
            this.init(passwordPrivateKey, privatePasswordRequired, requestParams);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public MerlinKeystore(String pathStore, String tipoStore, String passwordStore) throws SecurityException {
        this.initMerlinKeystoreEngine(pathStore, tipoStore, passwordStore, null, false, null);
    }

    public MerlinKeystore(String pathStore, String tipoStore, String passwordStore, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(pathStore, tipoStore, passwordStore, null, false, requestParams);
    }

    public MerlinKeystore(String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        this.initMerlinKeystoreEngine(pathStore, tipoStore, passwordStore, passwordPrivateKey, true, null);
    }

    public MerlinKeystore(String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(pathStore, tipoStore, passwordStore, passwordPrivateKey, true, requestParams);
    }

    public void initMerlinKeystoreEngine(String pathStore, String tipoStore, String passwordStore, String passwordPrivateKey, boolean privatePasswordRequired, BYOKRequestParams requestParams) throws SecurityException {
        this.pathStore = pathStore;
        this.tipoStore = tipoStore;
        this.passwordStore = passwordStore;
        this.init(passwordPrivateKey, privatePasswordRequired, requestParams);
    }

    public MerlinKeystore(byte[] bytesKeystore, String tipoStore, String passwordStore) throws SecurityException {
        this.initMerlinKeystoreEngine(bytesKeystore, tipoStore, passwordStore, null, false, null);
    }

    public MerlinKeystore(byte[] bytesKeystore, String tipoStore, String passwordStore, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(bytesKeystore, tipoStore, passwordStore, null, false, requestParams);
    }

    public MerlinKeystore(byte[] bytesKeystore, String tipoStore, String passwordStore, String passwordPrivateKey) throws SecurityException {
        this.initMerlinKeystoreEngine(bytesKeystore, tipoStore, passwordStore, passwordPrivateKey, true, null);
    }

    public MerlinKeystore(byte[] bytesKeystore, String tipoStore, String passwordStore, String passwordPrivateKey, BYOKRequestParams requestParams) throws SecurityException {
        this.initMerlinKeystoreEngine(bytesKeystore, tipoStore, passwordStore, passwordPrivateKey, true, requestParams);
    }

    public void initMerlinKeystoreEngine(byte[] bytesKeystore, String tipoStore, String passwordStore, String passwordPrivateKey, boolean privatePasswordRequired, BYOKRequestParams requestParams) throws SecurityException {
        this.ksBytes = bytesKeystore;
        this.tipoStore = tipoStore;
        this.passwordStore = passwordStore;
        this.init(passwordPrivateKey, privatePasswordRequired, requestParams);
    }

    private void init(String passwordPrivateKey, boolean privatePasswordRequired, BYOKRequestParams requestParams) throws SecurityException {
        try {
            HSMManager hsmManager;
            if (this.tipoStore == null) {
                throw new SecurityException("Tipo dello Store non indicato");
            }
            if (this.passwordStore == null) {
                boolean required = true;
                if (KeystoreType.JKS.isType(this.tipoStore)) {
                    required = DBUtils.isKeystoreJksPasswordRequired();
                } else if (KeystoreType.PKCS12.isType(this.tipoStore)) {
                    required = DBUtils.isKeystorePkcs12PasswordRequired();
                }
                if (required) {
                    throw new SecurityException("Password dello Store non indicata");
                }
            }
            if ((hsmManager = HSMManager.getInstance()) != null) {
                this.hsm = hsmManager.existsKeystoreType(this.tipoStore);
            }
            if (!this.hsm) {
                this.initKsBytes(requestParams);
            }
            this.initKS();
            this.initPrivateKey(passwordPrivateKey, privatePasswordRequired);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    private void initPrivateKey(String passwordPrivateKey, boolean privatePasswordRequired) throws SecurityException {
        if (passwordPrivateKey == null && privatePasswordRequired) {
            boolean required = true;
            if (KeystoreType.JKS.isType(this.tipoStore)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(this.tipoStore)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                if (this.pathStore != null) {
                    throw new SecurityException("Password chiave privata non indicata per lo Store [" + this.pathStore + "] ");
                }
                throw new SecurityException("Password chiave privata non indicata per lo Store ");
            }
        }
        this.passwordPrivateKey = passwordPrivateKey;
    }

    private void initKsBytes(BYOKRequestParams requestParams) throws SecurityException {
        if (this.ksBytes == null && this.pathStore == null) {
            throw new SecurityException("Path per lo Store non indicato");
        }
        if (this.ksBytes == null) {
            this.ksBytes = StoreUtils.readContent("Path", this.pathStore);
        }
        if (requestParams != null) {
            this.ksBytes = StoreUtils.unwrapBYOK(this.ksBytes, requestParams);
        }
    }

    public boolean isHsm() {
        return this.hsm;
    }

    private void checkInit() throws SecurityException {
        if (this.ks == null) {
            this.initKS();
        }
    }

    private synchronized void initKS() throws SecurityException {
        if (this.ks == null) {
            try {
                if (this.hsm) {
                    this.ks = HSMManager.getInstance().getKeystore(this.tipoStore);
                } else {
                    this.ks = new org.openspcoop2.utils.certificate.KeyStore(this.ksBytes, this.tipoStore, this.passwordStore);
                    FixTrustAnchorsNotEmpty.addCertificate(this.ks.getKeystore());
                }
            }
            catch (Exception e) {
                throw new SecurityException(e.getMessage(), e);
            }
        }
    }

    public Key getKey(String alias) throws SecurityException {
        return this.getKey(alias, this.passwordPrivateKey);
    }

    public Key getKey(String alias, String password) throws SecurityException {
        if (alias == null) {
            throw new SecurityException("Alias della chiave non fornita");
        }
        if (password == null) {
            boolean required = true;
            if (KeystoreType.JKS.isType(this.tipoStore)) {
                required = DBUtils.isKeystoreJksKeyPasswordRequired();
            } else if (KeystoreType.PKCS12.isType(this.tipoStore)) {
                required = DBUtils.isKeystorePkcs12KeyPasswordRequired();
            }
            if (required) {
                throw new SecurityException("Password della chiave non fornita");
            }
        }
        this.checkInit();
        try {
            return this.ks.getPrivateKey(alias, password);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public Certificate getCertificate(String alias) throws SecurityException {
        if (alias == null) {
            throw new SecurityException("Alias non fornito");
        }
        this.checkInit();
        try {
            return this.ks.getCertificate(alias);
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    public org.openspcoop2.utils.certificate.KeyStore getKeyStore() throws SecurityException {
        this.checkInit();
        try {
            return this.ks;
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

