/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.keystore;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import org.openspcoop2.utils.transport.http.IOCSPValidator;
import org.openspcoop2.utils.transport.http.OCSPResponseException;

public class OCSPResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean valid = false;
    private Throwable exception = null;

    public OCSPResponse(IOCSPValidator ocspValidator, X509Certificate cert) throws SecurityException {
        try {
            ocspValidator.valid(cert);
            this.valid = true;
        }
        catch (OCSPResponseException t) {
            this.valid = false;
            this.exception = t;
        }
        catch (Exception t) {
            throw new SecurityException(t.getMessage(), t);
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public Throwable getException() {
        return this.exception;
    }
}

