/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.constants;

import org.openspcoop2.generic_project.exception.NotFoundException;

public enum SignatureDigestAlgorithm {
    SHA1("http://www.w3.org/2000/09/xmldsig#sha1"),
    SHA224("http://www.w3.org/2001/04/xmldsig-more#sha224"),
    SHA256("http://www.w3.org/2001/04/xmlenc#sha256"),
    SHA384("http://www.w3.org/2000/09/xmldsig#sha384"),
    SHA512("http://www.w3.org/2001/04/xmlenc#sha512");

    private String uri;

    private SignatureDigestAlgorithm(String uri) {
        this.uri = uri;
    }

    public String getUri() {
        return this.uri;
    }

    public static SignatureDigestAlgorithm toEnumConstant(String uri) {
        try {
            return SignatureDigestAlgorithm.toEnumConstant(uri, false);
        }
        catch (NotFoundException notFound) {
            return null;
        }
    }

    public static SignatureDigestAlgorithm toEnumConstant(String uri, boolean throwNotFoundException) throws NotFoundException {
        SignatureDigestAlgorithm res = null;
        for (SignatureDigestAlgorithm tmp : SignatureDigestAlgorithm.values()) {
            if (!tmp.getUri().equals(uri)) continue;
            res = tmp;
            break;
        }
        if (res == null && throwNotFoundException) {
            throw new NotFoundException("Enum with uri [" + uri + "] not found");
        }
        return res;
    }
}

