/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.engine;

import java.util.Arrays;
import org.apache.commons.lang3.math.NumberUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.IMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.MessageSecurityUtilities;
import org.openspcoop2.security.message.engine.MessageSecuritySender;
import org.openspcoop2.security.message.engine.MessageUtilities;
import org.openspcoop2.utils.Map;

public class MessageSecuritySender_impl
extends MessageSecuritySender {
    protected MessageSecuritySender_impl(MessageSecurityContext messageSecurityContext) {
        super(messageSecurityContext);
    }

    @Override
    protected boolean process(OpenSPCoop2Message message, Map<Object> ctx) {
        try {
            boolean skipRestProblemDetail;
            String responseCode;
            Integer code;
            IMessageSecuritySender senderInterface = this.messageSecurityContext.getMessageSecuritySender();
            String codeRanges = MessageUtilities.getOutgoingProperty(this.messageSecurityContext, "messageSecurity.apply.onBackendReturnCode");
            if (codeRanges != null && (code = Integer.valueOf(NumberUtils.toInt((String)(responseCode = message.getTransportResponseContext() != null ? message.getTransportResponseContext().getCodiceTrasporto() : message.getForcedResponseCode()), (int)-1))) >= 0 && !MessageUtilities.isIntegerInRanges(code, codeRanges)) {
                return true;
            }
            boolean skipSoapFault = ServiceBinding.SOAP.equals((Object)message.getServiceBinding()) && (message.isFault() || message.castAsSoap().getSOAPBody().hasFault()) && !MessageSecurityUtilities.processSOAPFault(this.messageSecurityContext.getOutgoingProperties());
            boolean bl = skipRestProblemDetail = ServiceBinding.REST.equals((Object)message.getServiceBinding()) && (message.isFault() || message.castAsRest().isProblemDetailsForHttpApis_RFC7807()) && !MessageSecurityUtilities.processProblemDetails(this.messageSecurityContext.getOutgoingProperties());
            if (skipSoapFault || skipRestProblemDetail) {
                return true;
            }
            String action = MessageUtilities.getOutgoingProperty(this.messageSecurityContext, "action");
            if (action == null || "".equals(action.trim())) {
                return true;
            }
            if (Arrays.stream(action.split(" ")).anyMatch(a -> a.trim().contains("Signature")) && MessageType.JSON.equals((Object)message.getMessageType())) {
                MessageUtilities.addJSONClaims(this.messageSecurityContext, message, ctx);
            }
            senderInterface.process(this.messageSecurityContext, message, ctx);
        }
        catch (Exception e) {
            String prefix = "Generatosi errore durante il processamento Message-Security(Sender): ";
            this.messageSecurityContext.getLog().error(prefix + e.getMessage(), (Throwable)e);
            this.msgErrore = prefix + e.getMessage();
            this.codiceErrore = CodiceErroreCooperazione.SICUREZZA;
            if (e instanceof SecurityException) {
                SecurityException securityException = (SecurityException)e;
                if (securityException.getMsgErrore() != null) {
                    this.msgErrore = prefix + securityException.getMsgErrore();
                }
                if (securityException.getCodiceErrore() != null) {
                    this.codiceErrore = securityException.getCodiceErrore();
                }
            }
            return false;
        }
        return true;
    }
}

