/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.jose;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.jose.JOSEUtils;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;
import org.openspcoop2.security.utils.SignatureAlgorithmUtilities;
import org.openspcoop2.utils.security.JOSESerialization;
import org.openspcoop2.utils.security.JWTOptions;

public class SecurityProvider
extends AbstractSecurityProvider {
    private boolean addSecretKey = false;

    public void addSecretKey() {
        this.addSecretKey = true;
    }

    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        JWTOptions jwtOptions = new JWTOptions(JOSESerialization.COMPACT);
        boolean useHeaders = JOSEUtils.useJwtHeadersMapProperties(mapProperties, jwtOptions);
        if (!(!useHeaders || jwtOptions.isPermitUseHeaderJKU() || jwtOptions.isPermitUseHeaderJWK() || jwtOptions.isPermitUseHeaderX5C() || jwtOptions.isPermitUseHeaderX5U() || jwtOptions.isPermitUseHeaderX5T() || jwtOptions.isPermitUseHeaderX5T_256() || jwtOptions.isPermitUseHeaderKID())) {
            throw new ProviderValidationException("Selezionare almeno un header");
        }
        super.validate(mapProperties);
    }

    @Override
    public List<String> getValues(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            List<String> l = SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(true, false);
            l.addAll(SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(false, false));
            return l;
        }
        if ("symmSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(true, false);
        }
        if ("asyncSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(false, false);
        }
        if ("jwtAsyncSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(false, true);
        }
        if ("encryptionKeyAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            KeyAlgorithm[] tmp = KeyAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].name());
            }
            return l;
        }
        if ("encryptionContentAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            ContentAlgorithm[] tmp = ContentAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].name());
            }
            return l;
        }
        if ("keystoreType".equals(id) || "secretkeystoreType".equals(id) || "truststoreType".equals(id)) {
            List<String> lSecret;
            List<String> l = super.getValues(id);
            l.add(0, SecurityConstants.KEYSTORE_TYPE_JWK_VALUE);
            if ("keystoreType".equals(id) && !this.isAsTruststore()) {
                l.add(1, SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE);
            }
            if (("truststoreType".equals(id) || "keystoreType".equals(id) && (this.isAsTruststore() || this.addSecretKey)) && (lSecret = super.getValues("secretkeystoreType")) != null && !lSecret.isEmpty()) {
                for (String type : lSecret) {
                    if (l.contains(type)) continue;
                    l.add(type);
                }
            }
            return l;
        }
        return super.getValues(id);
    }

    @Override
    public List<String> getLabels(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            List<String> l = SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(true, false);
            l.addAll(SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(false, false));
            return l;
        }
        if ("symmSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(true, false);
        }
        if ("asyncSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(false, false);
        }
        if ("jwtAsyncSignatureAlgorithm".equals(id)) {
            return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(false, true);
        }
        if ("encryptionKeyAlgorithm".equals(id) || "encryptionContentAlgorithm".equals(id)) {
            List<String> l = this.getValues(id);
            ArrayList<String> labels = new ArrayList<String>();
            for (String value : l) {
                if (value.contains("_")) {
                    String t = new String(value);
                    while (t.contains("_")) {
                        t = t.replace("_", "-");
                    }
                    labels.add(t);
                    continue;
                }
                labels.add(value);
            }
            return labels;
        }
        if ("keystoreType".equals(id) || "secretkeystoreType".equals(id) || "truststoreType".equals(id)) {
            List<String> lSecret;
            List<String> l = super.getLabels(id);
            l.add(0, SecurityConstants.KEYSTORE_TYPE_JWK_LABEL);
            if ("keystoreType".equals(id) && !this.isAsTruststore()) {
                l.add(1, SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_LABEL);
            }
            if (("truststoreType".equals(id) || "keystoreType".equals(id) && (this.isAsTruststore() || this.addSecretKey)) && (lSecret = super.getLabels("secretkeystoreType")) != null && !lSecret.isEmpty()) {
                for (String type : lSecret) {
                    if (l.contains(type)) continue;
                    l.add(type);
                }
            }
            return l;
        }
        return super.getLabels(id);
    }

    @Override
    public String getDefault(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            return SignatureAlgorithm.RS256.name();
        }
        if ("encryptionKeyAlgorithm".equals(id)) {
            return KeyAlgorithm.RSA_OAEP_256.name();
        }
        if ("encryptionContentAlgorithm".equals(id)) {
            return ContentAlgorithm.A256GCM.name();
        }
        return super.getDefault(id);
    }
}

