/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.MessageSecurityFlowParameter;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.utils.certificate.KeystoreParams;

public class SecurityUtils {
    private SecurityUtils() {
    }

    public static List<KeystoreParams> readRequestKeystoreParams(PortaApplicativa porta) {
        ArrayList<KeystoreParams> listKP = new ArrayList<KeystoreParams>();
        if (porta != null && porta.getMessageSecurity() != null && porta.getMessageSecurity().getRequestFlow() != null && porta.getMessageSecurity().getRequestFlow().sizeParameterList() > 0) {
            SecurityUtils.readStoreParams(listKP, porta.getMessageSecurity().getRequestFlow().getParameterList());
        }
        return listKP;
    }

    public static List<KeystoreParams> readResponseKeystoreParams(PortaApplicativa porta) {
        ArrayList<KeystoreParams> listKP = new ArrayList<KeystoreParams>();
        if (porta != null && porta.getMessageSecurity() != null && porta.getMessageSecurity().getResponseFlow() != null && porta.getMessageSecurity().getResponseFlow().sizeParameterList() > 0) {
            SecurityUtils.readStoreParams(listKP, porta.getMessageSecurity().getResponseFlow().getParameterList());
        }
        return listKP;
    }

    public static List<KeystoreParams> readRequestKeystoreParams(PortaDelegata porta) {
        ArrayList<KeystoreParams> listKP = new ArrayList<KeystoreParams>();
        if (porta != null && porta.getMessageSecurity() != null && porta.getMessageSecurity().getRequestFlow() != null && porta.getMessageSecurity().getRequestFlow().sizeParameterList() > 0) {
            SecurityUtils.readStoreParams(listKP, porta.getMessageSecurity().getRequestFlow().getParameterList());
        }
        return listKP;
    }

    public static List<KeystoreParams> readResponseKeystoreParams(PortaDelegata porta) {
        ArrayList<KeystoreParams> listKP = new ArrayList<KeystoreParams>();
        if (porta != null && porta.getMessageSecurity() != null && porta.getMessageSecurity().getResponseFlow() != null && porta.getMessageSecurity().getResponseFlow().sizeParameterList() > 0) {
            SecurityUtils.readStoreParams(listKP, porta.getMessageSecurity().getResponseFlow().getParameterList());
        }
        return listKP;
    }

    private static void readStoreParams(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        SecurityUtils.readKestoreParamsJose(listKP, list);
        SecurityUtils.readTruststoreParamsJoseTls(listKP, list);
        SecurityUtils.readTruststoreParamsJoseUseHeaders(listKP, list);
        SecurityUtils.readKeystoreParamsJoseUseHeaders(listKP, list);
        SecurityUtils.readKeystoreParamsMerlin(listKP, list);
    }

    private static void readKestoreParamsJose(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        String pathJose = SecurityUtils.readProperty(list, "rs.security.keystore.file");
        if (pathJose != null && StringUtils.isNotEmpty((String)pathJose)) {
            KeystoreParams kp = new KeystoreParams();
            kp.setPath(pathJose);
            kp.setType(SecurityUtils.readProperty(list, "rs.security.keystore.type"));
            kp.setPassword(SecurityUtils.readProperty(list, "rs.security.keystore.password"));
            kp.setCrls(SecurityUtils.readProperty(list, "rs.security.keystore.crl"));
            kp.setOcspPolicy(SecurityUtils.readProperty(list, "rs.security.keystore.ocsp"));
            kp.setByokPolicy(SecurityUtils.readProperty(list, "rs.security.keystore.file.byok"));
            kp.setKeyAlias(SecurityUtils.readProperty(list, "rs.security.keystore.alias"));
            kp.setKeyPassword(SecurityUtils.readProperty(list, "rs.security.key.password"));
            kp.setKeyPairPublicKeyPath(SecurityUtils.readProperty(list, "rs.security.keystore.file.public"));
            kp.setKeyPairAlgorithm(SecurityUtils.readProperty(list, "rs.security.keystore.file.algorithm"));
            listKP.add(kp);
        }
    }

    private static void readTruststoreParamsJoseTls(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        String pathJose = SecurityUtils.readProperty(list, "rs.security.keystore.file.ssl");
        if (pathJose != null && StringUtils.isNotEmpty((String)pathJose)) {
            KeystoreParams kp = new KeystoreParams();
            kp.setPath(pathJose);
            kp.setType(SecurityUtils.readProperty(list, "rs.security.keystore.type.ssl"));
            kp.setPassword(SecurityUtils.readProperty(list, "rs.security.keystore.password.ssl"));
            kp.setCrls(SecurityUtils.readProperty(list, "rs.security.keystore.ssl.crl"));
            kp.setOcspPolicy(SecurityUtils.readProperty(list, "rs.security.keystore.ssl.ocsp"));
            kp.setDescription("TLS TrustStore");
            listKP.add(kp);
        }
    }

    private static void readTruststoreParamsJoseUseHeaders(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        String pathJose = SecurityUtils.readProperty(list, "joseUseHeaders.truststore.file");
        if (pathJose != null && StringUtils.isNotEmpty((String)pathJose)) {
            KeystoreParams kp = new KeystoreParams();
            kp.setPath(pathJose);
            kp.setType(SecurityUtils.readProperty(list, "joseUseHeaders.truststore.type"));
            kp.setPassword(SecurityUtils.readProperty(list, "joseUseHeaders.truststore.password"));
            kp.setCrls(SecurityUtils.readProperty(list, "joseUseHeaders.truststore.crl"));
            kp.setOcspPolicy(SecurityUtils.readProperty(list, "joseUseHeaders.truststore.ocsp"));
            kp.setKeyPairAlgorithm(SecurityUtils.readProperty(list, "joseUseHeaders.truststore.file.algorithm"));
            kp.setDescription("TrustStore Certificati X.509");
            listKP.add(kp);
        }
    }

    private static void readKeystoreParamsJoseUseHeaders(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        String pathJose = SecurityUtils.readProperty(list, "joseUseHeaders.keystore.file");
        if (pathJose != null && StringUtils.isNotEmpty((String)pathJose)) {
            for (int i = 1; i < 11; ++i) {
                String user = SecurityUtils.readProperty(list, "joseUseHeaders.key." + i + ".alias");
                if (user == null) continue;
                KeystoreParams kp = new KeystoreParams();
                kp.setPath(pathJose);
                kp.setType(SecurityUtils.readProperty(list, "joseUseHeaders.keystore.type"));
                kp.setPassword(SecurityUtils.readProperty(list, "joseUseHeaders.keystore.password"));
                kp.setKeyAlias(user);
                kp.setKeyPassword(SecurityUtils.readProperty(list, "joseUseHeaders.key." + i + ".password"));
                kp.setDescription("KeyStore Certificati X.509");
                listKP.add(kp);
            }
        }
    }

    private static void readKeystoreParamsMerlin(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list) {
        String prefix = SecurityUtils.readPrefix(list);
        if (prefix == null || StringUtils.isEmpty((String)prefix)) {
            return;
        }
        String pathKeystore = SecurityUtils.readProperty(list, prefix + "keystore.file");
        if (pathKeystore == null || StringUtils.isEmpty((String)pathKeystore)) {
            pathKeystore = SecurityUtils.readProperty(list, prefix + "file");
        }
        if (pathKeystore != null && StringUtils.isNotEmpty((String)pathKeystore)) {
            SecurityUtils.readKeystoreParamsMerlin(listKP, list, prefix, pathKeystore);
        }
    }

    private static void readKeystoreParamsMerlin(List<KeystoreParams> listKP, List<MessageSecurityFlowParameter> list, String prefix, String pathKeystore) {
        KeystoreParams kp = new KeystoreParams();
        kp.setPath(pathKeystore);
        String keyStoreType = SecurityUtils.readProperty(list, prefix + "keystore.type");
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        kp.setType(keyStoreType);
        kp.setPassword(SecurityUtils.readProperty(list, prefix + "keystore.password"));
        String crlLocations = SecurityUtils.readProperty(list, prefix + "x509crl.file");
        if (crlLocations == null || StringUtils.isEmpty((String)crlLocations)) {
            crlLocations = SecurityUtils.readProperty(list, "signatureCRL");
        }
        kp.setCrls(crlLocations);
        kp.setOcspPolicy(SecurityUtils.readProperty(list, "signatureOCSP"));
        String keyStoreByokPolicy = SecurityUtils.readProperty(list, prefix + "keystore.file.byok");
        if (keyStoreByokPolicy == null || StringUtils.isEmpty((String)keyStoreByokPolicy)) {
            keyStoreByokPolicy = SecurityUtils.readProperty(list, prefix + "file.byok");
        }
        kp.setByokPolicy(keyStoreByokPolicy);
        listKP.add(kp);
        SecurityUtils.readKeystoreAliasParamsMerlin(list, kp);
    }

    private static void readKeystoreAliasParamsMerlin(List<MessageSecurityFlowParameter> list, KeystoreParams kp) {
        if (SecurityUtils.readKeystoreSignatureAliasParamsMerlin(list, kp)) {
            return;
        }
        if (SecurityUtils.readKeystoreEncryptAliasParamsMerlin(list, kp)) {
            return;
        }
        if (SecurityUtils.readKeystoreUserAliasParamsMerlin(list, kp)) {
            // empty if block
        }
    }

    private static boolean readKeystoreSignatureAliasParamsMerlin(List<MessageSecurityFlowParameter> list, KeystoreParams kp) {
        String alias = SecurityUtils.readProperty(list, "signatureUser");
        if (alias != null && StringUtils.isNotEmpty((String)alias)) {
            kp.setKeyAlias(alias);
            kp.setKeyPassword(SecurityUtils.readProperty(list, "signaturePassword"));
            return true;
        }
        return false;
    }

    private static boolean readKeystoreEncryptAliasParamsMerlin(List<MessageSecurityFlowParameter> list, KeystoreParams kp) {
        String alias = SecurityUtils.readProperty(list, "encryptionUser");
        if (alias != null && StringUtils.isNotEmpty((String)alias)) {
            kp.setKeyAlias(alias);
            String pwd = SecurityUtils.readProperty(list, "encryptionPassword");
            if (pwd == null || StringUtils.isEmpty((String)pwd)) {
                pwd = SecurityUtils.readProperty(list, "decryptionPassword");
            }
            kp.setKeyPassword(pwd);
            return true;
        }
        alias = SecurityUtils.readProperty(list, "decryptionUser");
        if (alias != null && StringUtils.isNotEmpty((String)alias)) {
            kp.setKeyAlias(alias);
            String pwd = SecurityUtils.readProperty(list, "decryptionPassword");
            if (pwd == null || StringUtils.isEmpty((String)pwd)) {
                pwd = SecurityUtils.readProperty(list, "encryptionPassword");
            }
            kp.setKeyPassword(pwd);
            return true;
        }
        return false;
    }

    private static boolean readKeystoreUserAliasParamsMerlin(List<MessageSecurityFlowParameter> list, KeystoreParams kp) {
        String alias = SecurityUtils.readProperty(list, "user");
        if (alias != null && StringUtils.isNotEmpty((String)alias)) {
            kp.setKeyAlias(alias);
            String pwd = SecurityUtils.readProperty(list, "signaturePassword");
            if (pwd == null || StringUtils.isEmpty((String)pwd)) {
                pwd = SecurityUtils.readProperty(list, "encryptionPassword");
            }
            if (pwd == null || StringUtils.isEmpty((String)pwd)) {
                pwd = SecurityUtils.readProperty(list, "decryptionPassword");
            }
            kp.setKeyPassword(pwd);
            return true;
        }
        return false;
    }

    private static String readPrefix(List<MessageSecurityFlowParameter> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        String prefix = null;
        for (MessageSecurityFlowParameter p : list) {
            String propKey = p.getNome();
            if (SecurityUtils.startsWith(propKey, "org.apache.wss4j.crypto.merlin.")) {
                prefix = "org.apache.wss4j.crypto.merlin.";
                return prefix;
            }
            if (!SecurityUtils.startsWith(propKey, "org.apache.ws.security.crypto.merlin.")) continue;
            prefix = "org.apache.ws.security.crypto.merlin.";
            return prefix;
        }
        return prefix;
    }

    private static boolean startsWith(String propKey, String check) {
        return propKey.startsWith(check) || propKey.contains("_@@@_") && SecurityUtils.isStartsWithConfidentialPropertyCustomSeparator(propKey, check) || propKey.contains("_@@_") && SecurityUtils.isStartsWithConfidentialPropertyDefaultSeparator(propKey, check);
    }

    private static String readProperty(List<MessageSecurityFlowParameter> list, String name) {
        if (list != null && !list.isEmpty()) {
            for (MessageSecurityFlowParameter messageSecurityFlowParameter : list) {
                if (!SecurityUtils.isProperty(messageSecurityFlowParameter, name)) continue;
                if (messageSecurityFlowParameter.getValore() != null && StringUtils.isNotEmpty((String)messageSecurityFlowParameter.getValore())) {
                    return messageSecurityFlowParameter.getValore();
                }
                return null;
            }
        }
        return null;
    }

    private static boolean isProperty(MessageSecurityFlowParameter messageSecurityFlowParameter, String name) {
        return messageSecurityFlowParameter.getNome() != null && (messageSecurityFlowParameter.getNome().equals(name) || messageSecurityFlowParameter.getNome().contains("_@@@_") && SecurityUtils.isConfidentialPropertyCustomSeparator(messageSecurityFlowParameter.getNome(), name) || messageSecurityFlowParameter.getNome().contains("_@@_") && SecurityUtils.isConfidentialPropertyDefaultSeparator(messageSecurityFlowParameter.getNome(), name));
    }

    private static boolean isConfidentialPropertyCustomSeparator(String nome, String check) {
        String[] tmp = nome.split("_@@@_");
        return tmp != null && tmp.length > 1 && tmp[1] != null && tmp[1].equals(check);
    }

    private static boolean isConfidentialPropertyDefaultSeparator(String nome, String check) {
        String[] tmp = nome.split("_@@_");
        return tmp != null && tmp.length > 1 && tmp[1] != null && tmp[1].equals(check);
    }

    private static boolean isStartsWithConfidentialPropertyCustomSeparator(String nome, String check) {
        String[] tmp = nome.split("_@@@_");
        return tmp != null && tmp.length > 1 && tmp[1] != null && tmp[1].startsWith(check);
    }

    private static boolean isStartsWithConfidentialPropertyDefaultSeparator(String nome, String check) {
        String[] tmp = nome.split("_@@_");
        return tmp != null && tmp.length > 1 && tmp[1] != null && tmp[1].startsWith(check);
    }

    public static void dynamicUpdateKeyPairAlgorithm(Properties p, String signatureAlgorithm) {
        String type;
        if (signatureAlgorithm != null && p != null && (SecurityConstants.KEYSTORE_TYPE_KEY_PAIR_VALUE.equalsIgnoreCase(type = p.getProperty("rs.security.keystore.type")) || SecurityConstants.KEYSTORE_TYPE_PUBLIC_KEY_VALUE.equalsIgnoreCase(type))) {
            String keyPairAlgorithm = "RSA";
            if (signatureAlgorithm.toUpperCase().startsWith("ES")) {
                keyPairAlgorithm = "EC";
            }
            p.put("rs.security.keystore.file.algorithm", keyPairAlgorithm);
        }
    }
}

