/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.wss4j;

import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPMessage;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.openspcoop2.core.constants.Costanti;
import org.openspcoop2.message.MessageUtils;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.state.RequestInfo;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.keystore.KeystoreConstants;
import org.openspcoop2.security.message.IMessageSecuritySender;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.saml.SAMLBuilderConfig;
import org.openspcoop2.security.message.saml.SAMLCallbackHandler;
import org.openspcoop2.security.message.saml.SAMLUtilities;
import org.openspcoop2.security.message.utils.AttachmentProcessingPart;
import org.openspcoop2.security.message.utils.AttachmentsConfigReaderUtils;
import org.openspcoop2.security.message.utils.BaseSecurityBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.wss4j.WSSUtilities;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.IDUtilities;

public class MessageSecuritySender_wss4j
implements IMessageSecuritySender {
    @Override
    public void process(MessageSecurityContext wssContext, OpenSPCoop2Message messageParam, org.openspcoop2.utils.Map<Object> ctx) throws SecurityException {
        try {
            if (!ServiceBinding.SOAP.equals((Object)messageParam.getServiceBinding())) {
                throw new SecurityException("WSS4J Engine usable only with SOAP Binding");
            }
            OpenSPCoop2SoapMessage message = messageParam.castAsSoap();
            RequestInfo requestInfo = null;
            if (ctx != null && ctx.containsKey(Costanti.REQUEST_INFO)) {
                requestInfo = (RequestInfo)ctx.get(Costanti.REQUEST_INFO);
            }
            WSS4JOutInterceptor ohandler = new WSS4JOutInterceptor();
            WSS4JOutInterceptor.WSS4JOutInterceptorInternal handler = ohandler.createEndingInterceptor();
            SoapMessage msgCtx = new SoapMessage((Message)new MessageImpl());
            msgCtx.setVersion((SoapVersion)(MessageType.SOAP_12.equals((Object)message.getMessageType()) ? Soap12.getInstance() : Soap11.getInstance()));
            ExchangeImpl ex = new ExchangeImpl();
            ex.setInMessage((Message)msgCtx);
            SOAPMessage soapMessage = MessageUtils.getSOAPMessage((OpenSPCoop2SoapMessage)message, (boolean)false, (String)message.getTransactionId());
            msgCtx.setContent(SOAPMessage.class, (Object)soapMessage);
            ArrayList results = new ArrayList();
            msgCtx.put("RECV_RESULTS", results);
            AttachmentProcessingPart app = AttachmentsConfigReaderUtils.getSecurityOnAttachments(wssContext);
            this.setOutgoingProperties(wssContext, msgCtx, messageParam, requestInfo, ctx);
            List<Attachment> listAttachments = null;
            if (app != null && (listAttachments = WSSUtilities.readAttachments(app, message, msgCtx)) != null && listAttachments.size() > 0) {
                msgCtx.setAttachments(listAttachments);
            }
            handler.handleMessage((Message)msgCtx);
            wssContext.getLog().debug("Print wssSender results...");
            WSSUtilities.printWSResult(wssContext.getLog(), results);
            WSSUtilities.updateAttachments(listAttachments, message, msgCtx);
        }
        catch (Exception e) {
            Throwable t;
            String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
            Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
            String innerMsg = null;
            if (innerExc != null) {
                innerMsg = innerExc.getMessage();
            }
            Object messaggio = null;
            if (msg != null) {
                messaggio = new String(msg);
                if (innerMsg != null && !innerMsg.equals(msg)) {
                    messaggio = (String)messaggio + " ; " + innerMsg;
                }
            } else if (innerMsg != null) {
                messaggio = innerMsg;
            }
            if (Utilities.existsInnerException((Throwable)e, WSSecurityException.class) && (t = Utilities.getLastInnerException((Throwable)e)) instanceof WSSecurityException) {
                messaggio = messaggio != null ? (String)messaggio + " ; " + t.getMessage() : t.getMessage();
            }
            SecurityException wssException = new SecurityException((String)messaggio, e);
            wssException.setMsgErrore((String)messaggio);
            throw wssException;
        }
    }

    private void setOutgoingProperties(MessageSecurityContext wssContext, SoapMessage msgCtx, OpenSPCoop2Message message, RequestInfo requestInfo, org.openspcoop2.utils.Map<Object> ctx) throws Exception {
        boolean mustUnderstand = false;
        boolean signatureUser = false;
        boolean user = false;
        Map<String, Object> wssOutgoingProperties = wssContext.getOutgoingProperties();
        if (wssOutgoingProperties != null && wssOutgoingProperties.size() > 0) {
            SAMLUtilities.injectSignaturePropRefIdIntoSamlConfig(wssOutgoingProperties);
            this.preprocessMultipropFile(wssContext, msgCtx, wssOutgoingProperties, requestInfo, ctx);
            for (String key : wssOutgoingProperties.keySet()) {
                Object oValue = wssOutgoingProperties.get(key);
                String value = null;
                if (oValue != null && oValue instanceof String) {
                    value = (String)oValue;
                }
                if ("samlPropFile".equals(key)) {
                    SAMLBuilderConfig config = SAMLBuilderConfig.getSamlConfig(value, requestInfo);
                    SAMLCallbackHandler samlCallbackHandler = new SAMLCallbackHandler(config);
                    msgCtx.put("samlCallbackRef", (Object)samlCallbackHandler);
                    continue;
                }
                if ("samlPropRefId".equals(key)) {
                    if (oValue != null && oValue instanceof Properties) {
                        Properties p = (Properties)oValue;
                        SAMLBuilderConfig config = SAMLBuilderConfig.getSamlConfig(p, requestInfo);
                        SAMLCallbackHandler samlCallbackHandler = new SAMLCallbackHandler(config);
                        msgCtx.put("samlCallbackRef", (Object)samlCallbackHandler);
                        continue;
                    }
                    throw new Exception("Property [" + key + "] with uncorrect type: " + (oValue != null ? oValue.getClass().getName() : "value is null"));
                }
                if ("encryptionParts".equals(key) || "signatureParts".equals(key)) {
                    if (value == null) continue;
                    msgCtx.put(key, (Object)this.normalizeWss4jParts(value, message));
                    continue;
                }
                if ("passwordCallbackRef".equals(key)) {
                    msgCtx.put(key, oValue);
                    continue;
                }
                if ("signaturePropRefId".equals(key) || "signatureVerificationPropRefId".equals(key) || "encryptionPropRefId".equals(key) || "decryptionPropRefId".equals(key)) {
                    if (value != null) {
                        msgCtx.put(key, (Object)value);
                        continue;
                    }
                    String id = key + "_" + IDUtilities.getUniqueSerialNumber((String)"wssSecurity.setOutgoingProperties");
                    msgCtx.put(key, (Object)id);
                    msgCtx.put(id, oValue);
                    if (oValue == null || !(oValue instanceof Properties)) continue;
                    Properties p = (Properties)oValue;
                    p.put("requestInfo", requestInfo);
                    continue;
                }
                if ("Encrypt".equals(key)) {
                    msgCtx.put("Encryption", (Object)value);
                    continue;
                }
                msgCtx.put(key, (Object)value);
                if ("mustUnderstand".equals(key)) {
                    mustUnderstand = true;
                    continue;
                }
                if ("signatureUser".equals(key)) {
                    signatureUser = true;
                    continue;
                }
                if (!"user".equals(key)) continue;
                user = true;
            }
        }
        if (!mustUnderstand) {
            msgCtx.put("mustUnderstand", (Object)"false");
        }
        if (wssContext.getActor() != null) {
            msgCtx.put("actor", (Object)wssContext.getActor());
        }
        if (signatureUser && !user) {
            msgCtx.put("user", (Object)((String)msgCtx.get((Object)"signatureUser")));
        }
    }

    private void preprocessMultipropFile(MessageSecurityContext wssContext, SoapMessage msgCtx, Map<String, Object> wssOutgoingProperties, RequestInfo requestInfo, org.openspcoop2.utils.Map<Object> ctx) throws FileNotFoundException, UtilsException, SecurityException, URISyntaxException {
        String forceSignatureUser = null;
        String forceEncryptionUser = null;
        HashMap<String, String> mapAliasToPassword = new HashMap<String, String>();
        for (String key : wssOutgoingProperties.keySet()) {
            String password;
            String id;
            Properties p;
            String internalAlias;
            String keyAlias;
            BaseSecurityBean bean;
            if ("signatureMultiPropFile".equals(key)) {
                bean = KeystoreUtils.getSenderSignatureBean(wssContext, ctx);
                if (bean.getMultiKeystore() == null) {
                    throw new SecurityException("Multiproperty config not exists");
                }
                keyAlias = bean.getUser();
                internalAlias = bean.getMultiKeystore().getInternalConfigAlias(keyAlias);
                p = new Properties();
                p.put("org.apache.ws.security.crypto.merlin.file", bean.getMultiKeystore().getKeystorePath(internalAlias));
                p.put("org.apache.ws.security.crypto.merlin.keystore.password", bean.getMultiKeystore().getKeystorePassword(internalAlias));
                p.put("org.apache.ws.security.crypto.merlin.keystore.type", bean.getMultiKeystore().getKeystoreType(internalAlias));
                p.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
                p.put("requestInfo", requestInfo);
                id = "signaturePropRefId_" + IDUtilities.getUniqueSerialNumber((String)"wssSecurity.setOutgoingProperties");
                msgCtx.put("signaturePropRefId", (Object)id);
                msgCtx.put(id, (Object)p);
                password = bean.getPassword();
                msgCtx.put("signaturePassword", (Object)bean.getPassword());
                mapAliasToPassword.put(keyAlias, password);
                forceSignatureUser = keyAlias;
                continue;
            }
            if (!"encryptionMultiPropFile".equals(key)) continue;
            bean = KeystoreUtils.getSenderEncryptionBean(wssContext, ctx);
            if (bean.getMultiKeystore() == null) {
                throw new SecurityException("Multiproperty config not exists");
            }
            keyAlias = bean.getUser();
            internalAlias = bean.getMultiKeystore().getInternalConfigAlias(keyAlias);
            p = new Properties();
            p.put("org.apache.ws.security.crypto.merlin.file", bean.getMultiKeystore().getKeystorePath(internalAlias));
            p.put("org.apache.ws.security.crypto.merlin.keystore.password", bean.getMultiKeystore().getKeystorePassword(internalAlias));
            p.put("org.apache.ws.security.crypto.merlin.keystore.type", bean.getMultiKeystore().getKeystoreType(internalAlias));
            p.put("org.apache.ws.security.crypto.provider", KeystoreConstants.PROVIDER_GOVWAY);
            p.put("requestInfo", requestInfo);
            id = "encryptionPropRefId_" + IDUtilities.getUniqueSerialNumber((String)"wssSecurity.setOutgoingProperties");
            msgCtx.put("encryptionPropRefId", (Object)id);
            msgCtx.put(id, (Object)p);
            password = bean.getPassword();
            mapAliasToPassword.put(keyAlias, password);
            forceEncryptionUser = keyAlias;
        }
        if (!mapAliasToPassword.isEmpty()) {
            CallbackHandler pwCallbackHandler = MessageSecurityContext.newCallbackHandler(mapAliasToPassword);
            msgCtx.put("passwordCallbackRef", (Object)pwCallbackHandler);
        }
        if (forceSignatureUser != null) {
            wssOutgoingProperties.remove("signatureUser");
            wssOutgoingProperties.put("signatureUser", forceSignatureUser);
        }
        if (forceEncryptionUser != null) {
            wssOutgoingProperties.remove("encryptionUser");
            wssOutgoingProperties.put("encryptionUser", forceEncryptionUser);
        }
    }

    private String normalizeWss4jParts(String parts, OpenSPCoop2Message message) {
        StringBuilder bf = new StringBuilder();
        String[] split = parts.split(";");
        for (int i = 0; i < split.length; ++i) {
            String n;
            if (i > 0) {
                bf.append(";");
            }
            if ((n = split[i].trim()).contains("{Attach}")) {
                if (n.startsWith("{Element}")) {
                    bf.append("{Element}cid:Attachments");
                    continue;
                }
                bf.append("{Content}cid:Attachments");
                continue;
            }
            bf.append(n);
        }
        String newParts = bf.toString();
        while (newParts.contains("SOAP_TEMPLATE_NS")) {
            String namespace = MessageType.SOAP_11.equals((Object)message.getMessageType()) ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            newParts = newParts.replace("SOAP_TEMPLATE_NS", namespace);
        }
        return newParts;
    }
}

