/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.security.message.constants.EncryptionAlgorithm;
import org.openspcoop2.security.message.constants.EncryptionC14NAlgorithm;
import org.openspcoop2.security.message.constants.EncryptionDigestAlgorithm;
import org.openspcoop2.security.message.constants.EncryptionKeyTransportAlgorithm;
import org.openspcoop2.security.message.constants.EncryptionSymmetricKeyWrapAlgorithm;
import org.openspcoop2.security.message.constants.KeyAlgorithm;
import org.openspcoop2.security.message.constants.SignatureAlgorithm;
import org.openspcoop2.security.message.constants.SignatureC14NAlgorithm;
import org.openspcoop2.security.message.constants.SignatureDigestAlgorithm;
import org.openspcoop2.security.message.utils.AbstractSecurityProvider;

public class SecurityProvider
extends AbstractSecurityProvider {
    @Override
    public void validate(Map<String, Properties> mapProperties) throws ProviderException, ProviderValidationException {
        super.validate(mapProperties);
    }

    @Override
    public List<String> getValues(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureAlgorithm[] tmp = SignatureAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("signatureDigestAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureDigestAlgorithm[] tmp = SignatureDigestAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("signatureC14nAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureC14NAlgorithm[] tmp = SignatureC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("signatureC14nAlgorithmExclusive".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureC14NAlgorithm[] tmp = SignatureC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                if (!tmp[i].name().startsWith("EXCLUSIVE")) continue;
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("signatureC14nAlgorithmInclusive".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureC14NAlgorithm[] tmp = SignatureC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                if (!tmp[i].name().startsWith("INCLUSIVE")) continue;
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionKeyAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            KeyAlgorithm[] tmp = KeyAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].name());
            }
            return l;
        }
        if ("encryptionSymAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionSymmetricKeyWrapAlgorithm[] tmp = EncryptionSymmetricKeyWrapAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionKeyTransportAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionKeyTransportAlgorithm[] tmp = EncryptionKeyTransportAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionAlgorithm[] tmp = EncryptionAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionDigestAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionDigestAlgorithm[] tmp = EncryptionDigestAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionC14nAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionC14NAlgorithm[] tmp = EncryptionC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionC14nAlgorithmOnlyExclusive".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionC14NAlgorithm[] tmp = EncryptionC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                if (!tmp[i].name().startsWith("EXCLUSIVE")) continue;
                l.add(tmp[i].getUri());
            }
            return l;
        }
        if ("encryptionC14nAlgorithmInclusive".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionC14NAlgorithm[] tmp = EncryptionC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                if (!tmp[i].name().startsWith("INCLUSIVE")) continue;
                l.add(tmp[i].getUri());
            }
            return l;
        }
        return super.getValues(id);
    }

    @Override
    public List<String> getLabels(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureAlgorithm[] tmp = SignatureAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("signatureDigestAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureDigestAlgorithm[] tmp = SignatureDigestAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("signatureC14nAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            SignatureC14NAlgorithm[] tmp = SignatureC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getLabel());
            }
            return l;
        }
        if ("encryptionKeyAlgorithm".equals(id)) {
            return this.getValues(id);
        }
        if ("encryptionSymAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionSymmetricKeyWrapAlgorithm[] tmp = EncryptionSymmetricKeyWrapAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("encryptionKeyTransportAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionKeyTransportAlgorithm[] tmp = EncryptionKeyTransportAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("encryptionAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionAlgorithm[] tmp = EncryptionAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("encryptionDigestAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionDigestAlgorithm[] tmp = EncryptionDigestAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(this.convertEnumName(tmp[i].name()));
            }
            return l;
        }
        if ("encryptionC14nAlgorithm".equals(id)) {
            ArrayList<String> l = new ArrayList<String>();
            EncryptionC14NAlgorithm[] tmp = EncryptionC14NAlgorithm.values();
            for (int i = 0; i < tmp.length; ++i) {
                l.add(tmp[i].getLabel());
            }
            return l;
        }
        return super.getLabels(id);
    }

    private String convertEnumName(String name) {
        if (name.contains("_")) {
            String t = new String(name);
            while (t.contains("_")) {
                t = t.replace("_", "-");
            }
            return t;
        }
        return name;
    }

    @Override
    public String getDefault(String id) throws ProviderException {
        if ("signatureAlgorithm".equals(id)) {
            return SignatureAlgorithm.RSA_SHA256.getUri();
        }
        if ("signatureDigestAlgorithm".equals(id)) {
            return SignatureDigestAlgorithm.SHA256.getUri();
        }
        if ("signatureC14nAlgorithm".equals(id)) {
            return SignatureC14NAlgorithm.EXCLUSIVE_C14N_10_OMITS_COMMENTS.getUri();
        }
        if ("encryptionKeyAlgorithm".equals(id)) {
            return KeyAlgorithm.AES.name();
        }
        if ("encryptionSymAlgorithm".equals(id)) {
            return EncryptionSymmetricKeyWrapAlgorithm.AES_256.getUri();
        }
        if ("encryptionAlgorithm".equals(id)) {
            return EncryptionAlgorithm.AES_256.getUri();
        }
        if ("encryptionKeyTransportAlgorithm".equals(id)) {
            return EncryptionKeyTransportAlgorithm.RSA_v1dot5.getUri();
        }
        if ("encryptionDigestAlgorithm".equals(id)) {
            return EncryptionDigestAlgorithm.SHA256.getUri();
        }
        if ("encryptionC14nAlgorithm".equals(id)) {
            return EncryptionC14NAlgorithm.INCLUSIVE_C14N_10_WITH_COMMENTS.getUri();
        }
        return super.getDefault(id);
    }
}

