/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;

public class SignatureAlgorithmUtilities {
    public static final String LABEL_DEFINITO_HEANDER = "Definito nel token (alg)";
    public static final String VALUE_DEFINITO_HEANDER = "alg";

    private SignatureAlgorithmUtilities() {
    }

    public static List<String> getValuesSignatureAlgorithm(boolean symmetric) {
        return SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(symmetric, false);
    }

    public static List<String> getValuesSignatureAlgorithm(boolean symmetric, boolean addDefinitoHeader) {
        ArrayList<String> l = new ArrayList<String>();
        if (addDefinitoHeader) {
            l.add(VALUE_DEFINITO_HEANDER);
        }
        SignatureAlgorithm[] tmp = SignatureAlgorithm.values();
        for (int i = 0; i < tmp.length; ++i) {
            if (SignatureAlgorithm.NONE.equals((Object)tmp[i])) continue;
            if (symmetric) {
                if (!tmp[i].name().toLowerCase().startsWith("hs")) continue;
                l.add(tmp[i].name());
                continue;
            }
            if (tmp[i].name().toLowerCase().startsWith("hs")) continue;
            l.add(tmp[i].name());
        }
        return l;
    }

    public static List<String> getLabelsSignatureAlgorithm(boolean symmetric) {
        return SignatureAlgorithmUtilities.getLabelsSignatureAlgorithm(symmetric, false);
    }

    public static List<String> getLabelsSignatureAlgorithm(boolean symmetric, boolean addDefinitoHeader) {
        List<String> l = SignatureAlgorithmUtilities.getValuesSignatureAlgorithm(symmetric, false);
        ArrayList<String> labels = new ArrayList<String>();
        if (addDefinitoHeader) {
            labels.add(LABEL_DEFINITO_HEANDER);
        }
        for (String value : l) {
            if (value.contains("_")) {
                Object t = value;
                while (((String)t).contains("_")) {
                    t = ((String)t).replace("_", "-");
                }
                labels.add((String)t);
                continue;
            }
            labels.add(value);
        }
        return labels;
    }

    public static String covertToKeyPairAlgorithm(String signatureAlgorithm) {
        if (signatureAlgorithm == null) {
            return null;
        }
        if (signatureAlgorithm.toLowerCase().startsWith("es")) {
            return "EC";
        }
        if (signatureAlgorithm.toLowerCase().startsWith("rs") || signatureAlgorithm.toLowerCase().startsWith("ps")) {
            return "RSA";
        }
        return null;
    }
}

