/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.config.DatasourceInstanceProperties;
import org.slf4j.Logger;

public class DatasourceProperties {
    private Logger log = null;
    private DatasourceInstanceProperties reader;
    private static DatasourceProperties datasourceProperties = null;

    private DatasourceProperties(String confDir, String confPropertyName, String confLocalPathPrefix, Logger log) throws Exception {
        this.log = log != null ? log : LoggerWrapperFactory.getLogger(DatasourceProperties.class);
        Properties propertiesReader = new Properties();
        InputStream properties = null;
        try {
            properties = DatasourceProperties.class.getResourceAsStream("/console.datasource.properties");
            if (properties == null) {
                throw new Exception("File '/console.datasource.properties' not found");
            }
            propertiesReader.load(properties);
        }
        catch (Exception e) {
            this.log.error("Riscontrato errore durante la lettura del file 'console.datasource.properties': \n\n" + e.getMessage());
            throw new Exception("ConsoleProperties initialize error: " + e.getMessage());
        }
        finally {
            try {
                if (properties != null) {
                    properties.close();
                }
            }
            catch (Exception exception) {}
        }
        this.reader = new DatasourceInstanceProperties(propertiesReader, this.log, confDir, confPropertyName, confLocalPathPrefix);
    }

    private DatasourceProperties(Properties properties) throws Exception {
        this.reader = new DatasourceInstanceProperties(properties, this.log, "undefined", "undefined", "undefined");
    }

    public static synchronized boolean initialize(String confDir, String confPropertyName, String confLocalPathPrefix, Logger log) {
        try {
            if (datasourceProperties == null) {
                datasourceProperties = new DatasourceProperties(confDir, confPropertyName, confLocalPathPrefix, log);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static synchronized boolean initialize(Properties properties, Logger log) {
        try {
            if (datasourceProperties == null) {
                datasourceProperties = new DatasourceProperties(properties);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Inizializzazione fallita: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static DatasourceProperties getInstance() throws OpenSPCoop2ConfigurationException {
        if (datasourceProperties == null) {
            Class<DatasourceProperties> clazz = DatasourceProperties.class;
            synchronized (DatasourceProperties.class) {
                throw new OpenSPCoop2ConfigurationException("DatasourceProperties non inizializzato");
            }
        }
        return datasourceProperties;
    }

    public static void updateLocalImplementation(Properties prop) {
        DatasourceProperties.datasourceProperties.reader.setLocalObjectImplementation(prop);
    }

    private String readProperty(boolean required, String property) throws UtilsException {
        String tmp = this.reader.getValueConvertEnvProperties(property);
        if (tmp == null) {
            if (required) {
                throw new UtilsException("Property [" + property + "] not found");
            }
            return null;
        }
        return tmp.trim();
    }

    private Boolean readBooleanProperty(boolean required, String property) throws UtilsException {
        String tmp = this.readProperty(required, property);
        if (!"true".equalsIgnoreCase(tmp) && !"false".equalsIgnoreCase(tmp)) {
            throw new UtilsException("Property [" + property + "] with uncorrect value [" + tmp + "] (true/value expected)");
        }
        return Boolean.parseBoolean(tmp);
    }

    public String getDataSource() throws UtilsException {
        return this.readProperty(true, "dataSource");
    }

    public Properties getDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("dataSource.property.");
    }

    public String getTipoDatabase() throws UtilsException {
        return this.readProperty(true, "tipoDatabase");
    }

    public List<String> getSinglePddMonitorSorgentiDati() throws UtilsException {
        ArrayList<String> l = new ArrayList<String>();
        String p = this.readProperty(false, "singlePdD.monitor.sorgentiDati");
        if (p != null && !"".equals(p.trim())) {
            String[] tmp = p.trim().split(",");
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].trim();
                l.add(tmp[i]);
            }
        }
        return l;
    }

    public String getSinglePddMonitorLabel(String source) throws UtilsException {
        return this.readProperty(true, "singlePdD.monitor." + source + ".label");
    }

    public String getSinglePddMonitorDataSource(String source) throws UtilsException {
        return this.readProperty(true, "singlePdD.monitor." + source + ".dataSource");
    }

    public Properties getSinglePddMonitorDataSourceContext(String source) throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("singlePdD.monitor." + source + ".dataSource.property.");
    }

    public String getSinglePddMonitorTipoDatabase(String source) throws UtilsException {
        return this.readProperty(true, "singlePdD.monitor." + source + ".tipoDatabase");
    }

    public Boolean isSinglePddTracceStessoDBConsole() throws UtilsException {
        return this.readBooleanProperty(true, "singlePdD.tracce.sameDBWebUI");
    }

    public String getSinglePddTracceDataSource() throws UtilsException {
        return this.readProperty(true, "singlePdD.tracce.dataSource");
    }

    public Properties getSinglePddTracceDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("singlePdD.tracce.dataSource.property.");
    }

    public String getSinglePddTracceTipoDatabase() throws UtilsException {
        return this.readProperty(true, "singlePdD.tracce.tipoDatabase");
    }

    public Boolean isSinglePddMessaggiDiagnosticiStessoDBConsole() throws UtilsException {
        return this.readBooleanProperty(true, "singlePdD.msgDiagnostici.sameDBWebUI");
    }

    public String getSinglePddMessaggiDiagnosticiDataSource() throws UtilsException {
        return this.readProperty(true, "singlePdD.msgDiagnostici.dataSource");
    }

    public Properties getSinglePddMessaggiDiagnosticiDataSourceContext() throws UtilsException {
        return this.reader.readPropertiesConvertEnvProperties("singlePdD.msgDiagnostici.dataSource.property.");
    }

    public String getSinglePddMessaggiDiagnosticiTipoDatabase() throws UtilsException {
        return this.readProperty(true, "singlePdD.msgDiagnostici.tipoDatabase");
    }
}

