/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.OperazioneDaSmistare;
import org.openspcoop2.web.ctrlstat.costanti.OperationsParameter;
import org.openspcoop2.web.ctrlstat.costanti.TipoOggettoDaSmistare;
import org.openspcoop2.web.lib.queue.costanti.Operazione;

public class ControlStationJMSCore {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDati(OperazioneDaSmistare operazioneDaSmistare, String smistatoreQueue, String cfName, Properties cfProp) throws Exception {
        QueueConnection qc = null;
        QueueSession qs = null;
        QueueSender sender = null;
        try {
            long idTable = operazioneDaSmistare.getIDTable();
            Operazione operazione = operazioneDaSmistare.getOperazione();
            String pdd = operazioneDaSmistare.getPdd();
            TipoOggettoDaSmistare oggettoDaSmistare = operazioneDaSmistare.getOggetto();
            ControlStationCore.log.debug("[ControlStationCore::setDati] id[" + idTable + "] operazione[" + operazione.name() + "] pdd[" + pdd + "] oggetto[" + oggettoDaSmistare.name() + "]");
            InitialContext ctx = new InitialContext(cfProp);
            Queue queue = (Queue)ctx.lookup(smistatoreQueue);
            QueueConnectionFactory qcf = (QueueConnectionFactory)ctx.lookup(cfName);
            qc = qcf.createQueueConnection();
            qs = qc.createQueueSession(false, 1);
            sender = qs.createSender(queue);
            ctx.close();
            ObjectMessage message = qs.createObjectMessage((Serializable)operazioneDaSmistare);
            StringBuilder idOperazione = new StringBuilder();
            idOperazione.append("[" + operazione.name() + "]");
            idOperazione.append("[" + oggettoDaSmistare.name() + "]");
            Map<OperationsParameter, List<String>> params = operazioneDaSmistare.getParameters();
            if (params != null && !params.isEmpty()) {
                for (OperationsParameter key : params.keySet()) {
                    List<String> values = params.get((Object)key);
                    for (String value : values) {
                        idOperazione.append("[" + value + "]");
                    }
                }
            }
            ControlStationCore.log.debug("[ControlStationCore::setDati] id=[" + idOperazione.toString() + "]");
            message.setStringProperty("ID", idOperazione.toString());
            sender.send((Message)message);
        }
        finally {
            try {
                if (sender != null) {
                    sender.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (qs != null) {
                    qs.close();
                }
            }
            catch (Throwable throwable) {}
            try {
                if (qc != null) {
                    qc.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

