/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.slf4j.Logger;

public class DBManager {
    private static Logger checkLogger = null;
    private static volatile boolean checkIsClosed = true;
    private static volatile boolean checkAutocommit = true;
    private static Logger log = null;
    private static DBManager manager = null;
    private static boolean initialized = false;
    private DataSource dataSource = null;
    private String dataSourceName = null;
    private Properties dataSourceContext = null;

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        DBManager.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        DBManager.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        DBManager.checkLogger = checkLogger;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public Properties getDataSourceContext() {
        return this.dataSourceContext;
    }

    private DBManager(String jndiName, Properties context) throws Exception {
        try {
            log = ControlStationLogger.getPddConsoleCoreLogger();
            this.dataSourceName = jndiName;
            this.dataSourceContext = context;
            if (context != null) {
                log.info("Proprieta' di contesto:" + context.size());
                Enumeration<Object> en = context.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    log.info("\tNome[" + key + "] Valore[" + context.getProperty(key) + "]");
                }
            } else {
                log.info("Proprieta' di contesto non fornite");
            }
            log.info("Nome dataSource:" + jndiName);
            InitialContext initC = null;
            initC = context != null && context.size() > 0 ? new InitialContext(context) : new InitialContext();
            this.dataSource = (DataSource)initC.lookup(jndiName);
            initC.close();
        }
        catch (Exception e) {
            log.error("Lookup datasource non riuscita", (Throwable)e);
            throw e;
        }
    }

    public static boolean initialize(String jndiName, Properties context) throws Exception {
        if (manager == null) {
            DBManager.initializeEngine(jndiName, context);
        }
        return initialized;
    }

    private static synchronized void initializeEngine(String jndiName, Properties context) throws Exception {
        try {
            if (manager == null) {
                manager = new DBManager(jndiName, context);
                DBManager.setInitialized(true);
            }
        }
        catch (Exception e) {
            DBManager.setInitialized(false);
            log.debug("Errore di inizializzazione del Database", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBManager getInstance() {
        if (manager == null) {
            Class<DBManager> clazz = DBManager.class;
            synchronized (DBManager.class) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return manager;
            }
        }
        return manager;
    }

    public Connection getConnection() {
        if (this.dataSource == null) {
            return null;
        }
        Connection connectionDB = null;
        try {
            connectionDB = this.dataSource.getConnection();
        }
        catch (Exception e) {
            log.error("getConnection from db", (Throwable)e);
            return null;
        }
        return connectionDB;
    }

    public void releaseConnection(Connection connectionDB) {
        try {
            JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)connectionDB, (boolean)checkAutocommit, (boolean)checkIsClosed);
        }
        catch (SQLException e) {
            log.error("closeConnection db", (Throwable)e);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void setInitialized(boolean initialized) {
        DBManager.initialized = initialized;
    }
}

