/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.driver;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.TipoAllarme;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.search.utils.RegistroCore;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.controllo_traffico.utils.ControlloTrafficoDriverUtils;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortTypeAzione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDResource;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.PluginsDriverUtils;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.core.plugins.utils.handlers.HandlersDriverUtils;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiDriverUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeHistoryBean;
import org.openspcoop2.protocol.engine.archive.UtilitiesMappingFruizioneErogazione;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB_LIB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.lib.audit.DriverAudit;
import org.openspcoop2.web.lib.audit.DriverAuditDBAppender;
import org.openspcoop2.web.lib.users.DriverUsersDB;
import org.slf4j.Logger;

public class DriverControlStationDB {
    private static Logger checkLogger = null;
    private static boolean checkIsClosed = true;
    private static boolean checkAutocommit = true;
    public boolean create = false;
    public DataSource datasource = null;
    private Connection globalConnection = null;
    private boolean atomica = true;
    private Logger log = ControlStationLogger.getDriverDBPddConsoleLogger();
    private String tipoDB = null;
    private DriverConfigurazioneDB configDB = null;
    private DriverRegistroServiziDB regservDB = null;
    private DriverUsersDB usersDB = null;
    private DriverAudit auditDB = null;
    private DriverAuditDBAppender auditDBappender = null;
    private JDBCServiceManager jdbcServiceManagerControlloTraffico = null;
    private org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager jdbcServiceManagerPlugins;
    private org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager jdbcServiceManagerAllarmi;
    private IDAccordoFactory idAccordoFactory = null;
    private IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = null;

    public static boolean isCheckIsClosed() {
        return checkIsClosed;
    }

    public static void setCheckIsClosed(boolean checkIsClosed) {
        DriverControlStationDB.checkIsClosed = checkIsClosed;
    }

    public static boolean isCheckAutocommit() {
        return checkAutocommit;
    }

    public static void setCheckAutocommit(boolean checkAutocommit) {
        DriverControlStationDB.checkAutocommit = checkAutocommit;
    }

    public static Logger getCheckLogger() {
        return checkLogger;
    }

    public static void setCheckLogger(Logger checkLogger) {
        DriverControlStationDB.checkLogger = checkLogger;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    public void logDebug(String msg) {
        if (this.log != null) {
            this.log.debug(msg);
        }
    }

    public void logDebug(String msg, Exception e) {
        if (this.log != null) {
            this.log.debug(msg, (Throwable)e);
        }
    }

    public String getTipoDatabase() {
        return this.tipoDB;
    }

    public DriverConfigurazioneDB getDriverConfigurazioneDB() {
        return this.configDB;
    }

    public DriverRegistroServiziDB getDriverRegistroServiziDB() {
        return this.regservDB;
    }

    public DriverUsersDB getDriverUsersDB() {
        return this.usersDB;
    }

    public DriverAudit getDriverAuditDB() {
        return this.auditDB;
    }

    public DriverAuditDBAppender getDriverAuditDBAppender() {
        return this.auditDBappender;
    }

    public JDBCServiceManager getJdbcServiceManagerControlloTraffico() {
        return this.jdbcServiceManagerControlloTraffico;
    }

    public org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager getJdbcServiceManagerPlugins() {
        return this.jdbcServiceManagerPlugins;
    }

    public org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager getJdbcServiceManagerAllarmi() {
        return this.jdbcServiceManagerAllarmi;
    }

    public DriverControlStationDB(Connection connection, Properties context, String tipoDB) throws DriverControlStationException {
        if (connection == null) {
            this.create = false;
            throw new DriverControlStationException("[DriverControlStationDB::DriverControlStation(Connection con, Properties context, String tipoDB) La connection non puo essere null.");
        }
        if (tipoDB == null) {
            this.create = false;
            throw new DriverControlStationException("[DriverControlStationDB::DriverControlStation(Connection con, Properties context, String tipoDB) Il tipoDatabase non puo essere null.");
        }
        this.globalConnection = connection;
        this.create = true;
        this.atomica = false;
        this.tipoDB = tipoDB;
        try {
            this.configDB = new DriverConfigurazioneDB(connection, this.tipoDB);
            this.regservDB = new DriverRegistroServiziDB(connection, this.tipoDB);
            boolean useSuperUser = false;
            if (!ControlStationCore.isAPIMode()) {
                useSuperUser = ConsoleProperties.getInstance().isVisibilitaOggettiGlobale() == false;
            }
            this.configDB.setUseSuperUser(useSuperUser);
            this.regservDB.setUseSuperUser(useSuperUser);
            this.usersDB = new DriverUsersDB(connection, this.tipoDB, this.log);
            this.auditDB = new DriverAudit(connection, this.tipoDB);
            this.auditDBappender = new DriverAuditDBAppender(connection, this.tipoDB);
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(this.tipoDB);
            properties.setShowSql(true);
            this.jdbcServiceManagerControlloTraffico = new JDBCServiceManager(connection, properties, this.log);
            this.jdbcServiceManagerPlugins = new org.openspcoop2.core.plugins.dao.jdbc.JDBCServiceManager(connection, properties, this.log);
            this.jdbcServiceManagerAllarmi = new org.openspcoop2.core.allarmi.dao.jdbc.JDBCServiceManager(connection, properties, this.log);
            this.idAccordoFactory = IDAccordoFactory.getInstance();
            this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        }
        catch (Exception e) {
            throw new DriverControlStationException("[DriverControlStationDB::DriverControlStation(Connection con, Properties context, String tipoDB) Errore creando i driver ausiliari.");
        }
        DriverControlStationDB_LIB.setTipoDB(tipoDB);
        this.log.info("Creato DriverControlStationDB");
    }

    private Connection getConnection(String nomeMetodo) throws DriverControlStationException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (SQLException e) {
                throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        } else {
            con = this.globalConnection;
        }
        return con;
    }

    private Connection getConnection(String nomeMetodo, BooleanNullable setAutoCommit) throws DriverControlStationException {
        Connection con = this.getConnection(nomeMetodo);
        if (this.atomica && setAutoCommit != null && setAutoCommit.getValue() != null) {
            try {
                con.setAutoCommit(setAutoCommit.getValue());
            }
            catch (SQLException e) {
                throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] SQLException accedendo al datasource :" + e.getMessage());
            }
        }
        return con;
    }

    private void releaseConnection(Connection con) {
        try {
            if (this.atomica) {
                this.logDebug("rilascio connessione al db...");
                JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createPdDControlStation(PdDControlStation pdd) throws DriverControlStationException {
        String nomeMetodo = "createPdd";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DriverControlStationDB_LIB.CRUDPdd(1, pdd, con);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deletePdDControlStation(PdDControlStation pdd) throws DriverControlStationException {
        String nomeMetodo = "deletePdd";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DriverControlStationDB_LIB.CRUDPdd(3, pdd, con);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void updatePdDControlStation(PdDControlStation pdd) throws DriverControlStationException {
        String nomeMetodo = "updatePdd";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DriverControlStationDB_LIB.CRUDPdd(2, pdd, con);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<PdDControlStation> pddList(String superuser, ISearch ricerca) throws DriverControlStationException {
        String nomeMetodo = "pddList";
        int idLista = Liste.PDD;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        con = this.getConnection(nomeMetodo);
        try {
            String queryString;
            ISQLQueryObject sqlQueryObject;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectCountField("*", "cont");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addWhereLikeCondition("nome", search, true, true);
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("pdd");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("nome");
                if (superuser != null && !superuser.equals("")) {
                    sqlQueryObject.addWhereCondition("superuser = ?");
                }
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            if (superuser != null && !superuser.equals("")) {
                stmt.setString(1, superuser);
            }
            risultato = stmt.executeQuery();
            ArrayList<PdDControlStation> lista = new ArrayList<PdDControlStation>();
            PdDControlStation pdd = null;
            while (risultato.next()) {
                long id = risultato.getLong("id");
                pdd = this.getPdDControlStation(id);
                lista.add(pdd);
            }
            risultato.close();
            stmt.close();
            ArrayList<PdDControlStation> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public PdDControlStation getPdDControlStation(long idPdd) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "pddList(long idPdd)";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        con = this.getConnection(nomeMetodo);
        try {
            PdDControlStation pdd = new PdDControlStation();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                pdd.setId(risultato.getLong("id"));
                pdd.setNome(risultato.getString("nome"));
                pdd.setDescrizione(risultato.getString("descrizione"));
                pdd.setIp(risultato.getString("ip"));
                pdd.setPorta(risultato.getInt("porta"));
                pdd.setIpGestione(risultato.getString("ip_gestione"));
                pdd.setPortaGestione(risultato.getInt("porta_gestione"));
                pdd.setProtocollo(risultato.getString("protocollo"));
                pdd.setProtocolloGestione(risultato.getString("protocollo_gestione"));
                pdd.setTipo(risultato.getString("tipo"));
                pdd.setImplementazione(risultato.getString("implementazione"));
                pdd.setPassword(risultato.getString("password"));
                pdd.setSubject(risultato.getString("subject"));
                pdd.setClientAuth(DriverRegistroServiziDB_LIB.getEnumStatoFunzionalita((String)risultato.getString("client_auth")));
                if (risultato.getTimestamp("ora_registrazione") != null) {
                    pdd.setOraRegistrazione(new Date(risultato.getTimestamp("ora_registrazione").getTime()));
                }
            } else {
                throw new DriverControlStationNotFound("Porta di dominio con id " + idPdd + " non trovata.");
            }
            pdd.setSuperUser(risultato.getString("superuser"));
            risultato.close();
            stmt.close();
            PdDControlStation pdDControlStation = pdd;
            return pdDControlStation;
        }
        catch (DriverControlStationNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public List<Soggetto> pddSoggettiList(long idPdd, ISearch ricerca) throws DriverControlStationException {
        String nomeMetodo = "pddSoggettiList";
        int idLista = Liste.PDD_SOGGETTI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        ricerca.getSearchString(idLista);
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        con = this.getConnection(nomeMetodo);
        ArrayList<Soggetto> lista = null;
        try {
            String nomePdd = "";
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idPdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                nomePdd = risultato.getString("nome");
            }
            risultato.close();
            stmt.close();
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("server = ?");
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("nome_soggetto", search, true, true), sqlQueryObject.getWhereLikeCondition("tipo_soggetto", search, true, true)});
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectField("server");
                sqlQueryObject.addSelectField("nome_soggetto");
                sqlQueryObject.addSelectField("tipo_soggetto");
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("descrizione");
                sqlQueryObject.addSelectField("identificativo_porta");
                sqlQueryObject.addWhereCondition("server = ?");
                sqlQueryObject.addOrderBy("tipo_soggetto");
                sqlQueryObject.addOrderBy("nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Soggetto>();
            Soggetto sog = null;
            while (risultato.next()) {
                sog = new Soggetto();
                sog.setId(Long.valueOf(risultato.getLong("id")));
                sog.setNome(risultato.getString("nome_soggetto"));
                sog.setTipo(risultato.getString("tipo_soggetto"));
                sog.setDescrizione(risultato.getString("descrizione"));
                sog.setIdentificativoPorta(risultato.getString("identificativo_porta"));
                lista.add(sog);
            }
            ArrayList<Soggetto> arrayList = lista;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public PdDControlStation getPdDControlStation(String nomePdd) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "pddList(String nomePdd)";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        con = this.getConnection(nomeMetodo);
        try {
            PdDControlStation pdd = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            if (!risultato.next()) {
                throw new DriverControlStationNotFound("Porta di dominio con nome " + nomePdd + " non trovata.");
            }
            long id = risultato.getLong("id");
            pdd = this.getPdDControlStation(id);
            risultato.close();
            stmt.close();
            PdDControlStation pdDControlStation = pdd;
            return pdDControlStation;
        }
        catch (DriverControlStationNotFound e) {
            throw e;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public List<SoggettoCtrlStat> soggettiWithServer(String nomePdD) throws DriverControlStationException {
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        String queryString = "";
        String nomeMetodo = "soggettiWithServer";
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            SoggettoCtrlStat scs = null;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("server=?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdD);
            ArrayList<SoggettoCtrlStat> scsList = new ArrayList<SoggettoCtrlStat>();
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Soggetto soggConf = this.getDriverConfigurazioneDB().getSoggetto(risultato.getLong("id"));
                org.openspcoop2.core.registry.Soggetto soggReg = this.getDriverRegistroServiziDB().getSoggetto(risultato.getLong("id"));
                scs = new SoggettoCtrlStat(soggReg, soggConf);
                scsList.add(scs);
            }
            risultato.close();
            stmt.close();
            ArrayList<SoggettoCtrlStat> arrayList = scsList;
            return arrayList;
        }
        catch (Exception se) {
            throw new DriverControlStationException(se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public void createMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping) throws DriverControlStationException {
        String nomeMetodo = "createMappingFruizionePortaDelegata";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DBMappingUtils.createMappingFruizione((String)mapping.getNome(), (String)mapping.getDescrizione(), (boolean)mapping.isDefault(), (IDServizio)mapping.getIdServizio(), (IDSoggetto)mapping.getIdFruitore(), (IDPortaDelegata)mapping.getIdPortaDelegata(), (Connection)con, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        mapping.setTableId(this.getTableIdMappingFruizionePortaDelegata(mapping));
    }

    public void deleteMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping) throws DriverControlStationException {
        String nomeMetodo = "deleteMappingFruizionePortaDelegata";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DBMappingUtils.deleteMappingFruizione((IDServizio)mapping.getIdServizio(), (IDSoggetto)mapping.getIdFruitore(), (IDPortaDelegata)mapping.getIdPortaDelegata(), (Connection)con, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataDefault(IDServizio idServizio, IDSoggetto idFruitore) throws DriverControlStationException {
        String nomeMetodo = "getIDPortaDelegataAssociataDefault";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            IDPortaDelegata iDPortaDelegata = DBMappingUtils.getIDPortaDelegataAssociataDefault((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            return iDPortaDelegata;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public IDPortaDelegata getIDPortaDelegataAssociataAzione(IDServizio idServizio, IDSoggetto idFruitore) throws DriverControlStationException {
        String nomeMetodo = "getIDPortaDelegataAssociataAzione";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            IDPortaDelegata iDPortaDelegata = DBMappingUtils.getIDPortaDelegataAssociataAzione((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            return iDPortaDelegata;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDPortaDelegata> getIDPorteDelegateAssociate(IDServizio idServizio, IDSoggetto idFruitore) throws DriverControlStationException {
        String nomeMetodo = "getIDPorteDelegateAssociate";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List list = DBMappingUtils.getIDPorteDelegateAssociate((IDServizio)idServizio, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            return list;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long getTableIdMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping) throws DriverControlStationException {
        String nomeMetodo = "getTableIdMappingFruizionePortaDelegata";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBMappingUtils.getTableIdMappingFruizione((IDServizio)mapping.getIdServizio(), (IDSoggetto)mapping.getIdFruitore(), (IDPortaDelegata)mapping.getIdPortaDelegata(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsMappingFruizionePortaDelegata(MappingFruizionePortaDelegata mapping) throws DriverControlStationException {
        String nomeMetodo = "existsMappingFruizionePortaDelegata";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBMappingUtils.existsMappingFruizione((IDServizio)mapping.getIdServizio(), (IDSoggetto)mapping.getIdFruitore(), (IDPortaDelegata)mapping.getIdPortaDelegata(), (Connection)con, (String)this.tipoDB);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void createMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping) throws DriverControlStationException {
        String nomeMetodo = "createMappingErogazionePortaApplicativa";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DBMappingUtils.createMappingErogazione((String)mapping.getNome(), (String)mapping.getDescrizione(), (boolean)mapping.isDefault(), (IDServizio)mapping.getIdServizio(), (IDPortaApplicativa)mapping.getIdPortaApplicativa(), (Connection)con, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        mapping.setTableId(mapping.getTableId());
    }

    public void deleteMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping) throws DriverControlStationException {
        String nomeMetodo = "deleteMappingErogazionePortaApplicativa";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            DBMappingUtils.deleteMappingErogazione((IDServizio)mapping.getIdServizio(), (IDPortaApplicativa)mapping.getIdPortaApplicativa(), (Connection)con, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public IDPortaApplicativa getIDPortaApplicativaAssociataDefault(IDServizio idServizio) throws DriverControlStationException {
        String nomeMetodo = "getIDPortaApplicativaAssociataDefault";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            IDPortaApplicativa iDPortaApplicativa = DBMappingUtils.getIDPortaApplicativaAssociataDefault((IDServizio)idServizio, (Connection)con, (String)this.tipoDB);
            return iDPortaApplicativa;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public IDPortaApplicativa getIDPortaApplicativaAssociataAzione(IDServizio idServizio) throws DriverControlStationException {
        String nomeMetodo = "getIDPortaApplicativaAssociataAzione";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            IDPortaApplicativa iDPortaApplicativa = DBMappingUtils.getIDPortaApplicativaAssociataAzione((IDServizio)idServizio, (Connection)con, (String)this.tipoDB);
            return iDPortaApplicativa;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDPortaApplicativa> getIDPorteApplicativeAssociate(IDServizio idServizio) throws DriverControlStationException {
        String nomeMetodo = "getIDPorteApplicativeAssociate";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List list = DBMappingUtils.getIDPorteApplicativeAssociate((IDServizio)idServizio, (Connection)con, (String)this.tipoDB);
            return list;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long getTableIdMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping) throws DriverControlStationException {
        String nomeMetodo = "getTableIdMappingErogazionePortaApplicativa";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBMappingUtils.getTableIdMappingErogazione((IDServizio)mapping.getIdServizio(), (IDPortaApplicativa)mapping.getIdPortaApplicativa(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsMappingErogazionePortaApplicativa(MappingErogazionePortaApplicativa mapping) throws DriverControlStationException {
        String nomeMetodo = "existsMappingErogazionePortaApplicativa";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBMappingUtils.existsMappingErogazione((IDServizio)mapping.getIdServizio(), (IDPortaApplicativa)mapping.getIdPortaApplicativa(), (Connection)con, (String)this.tipoDB);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    private void initMappingErogazione_releaseConnectionGestioneErrore(boolean error, Connection con) {
        try {
            if (error && this.atomica) {
                this.logDebug("eseguo rollback a causa di errori e rilascio connessioni...");
                if (con != null) {
                    con.rollback();
                    con.setAutoCommit(true);
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
            } else if (!error && this.atomica) {
                this.logDebug("eseguo commit e rilascio connessioni...");
                if (con != null) {
                    con.commit();
                    con.setAutoCommit(true);
                    JDBCUtilities.closeConnection((Logger)checkLogger, (Connection)con, (boolean)checkAutocommit, (boolean)checkIsClosed);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initMappingErogazione(Logger log) throws DriverControlStationException {
        this._initMapping(true, false, log);
    }

    public void initMappingErogazione(boolean forceMapping, Logger log) throws DriverControlStationException {
        this._initMapping(true, forceMapping, log);
    }

    public void initMappingFruizione(Logger log) throws DriverControlStationException {
        this._initMapping(false, false, log);
    }

    public void initMappingFruizione(boolean forceMapping, Logger log) throws DriverControlStationException {
        this._initMapping(false, forceMapping, log);
    }

    private void _initMapping(boolean erogazione, boolean forceMapping, Logger log) throws DriverControlStationException {
        String nomeMetodo = "initMappingErogazione";
        if (!erogazione) {
            nomeMetodo = "initMappingFruizione";
        }
        Connection con = null;
        boolean error = false;
        con = this.getConnection(nomeMetodo, BooleanNullable.FALSE());
        log.debug("operazione this.atomica = " + this.atomica);
        try {
            int countMapping = -1;
            countMapping = erogazione ? DBMappingUtils.countMappingErogazione((Connection)con, (String)this.tipoDB) : DBMappingUtils.countMappingFruizione((Connection)con, (String)this.tipoDB);
            log.debug("Count [" + nomeMetodo + "]: " + countMapping);
            if (countMapping <= 0 || forceMapping) {
                log.debug("Controllo Consistenza Dati [" + nomeMetodo + "] ...");
                DriverRegistroServiziDB driverRegistry = new DriverRegistroServiziDB(con, this.tipoDB);
                DriverConfigurazioneDB driverConfig = new DriverConfigurazioneDB(con, this.tipoDB);
                UtilitiesMappingFruizioneErogazione utilities = new UtilitiesMappingFruizioneErogazione(driverConfig, driverRegistry, log);
                if (erogazione) {
                    utilities.initMappingErogazione();
                } else {
                    utilities.initMappingFruizione();
                }
                log.debug("Controllo Consistenza Dati [" + nomeMetodo + "] terminato");
            }
        }
        catch (Throwable se) {
            log.error("Controllo Consistenza Dati [" + nomeMetodo + "] terminato con errore: " + se.getMessage(), se);
            error = true;
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.initMappingErogazione_releaseConnectionGestioneErrore(error, con);
        }
    }

    public long getTableIdSoggetto(IDSoggetto idSoggetto) throws DriverControlStationException {
        String nomeMetodo = "getTableIdSoggetto";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBUtils.getIdSoggetto((String)idSoggetto.getNome(), (String)idSoggetto.getTipo(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long getTableIdAccordoServizioParteSpecifica(IDServizio idAccordoServizioParteSpecifica) throws DriverControlStationException {
        String nomeMetodo = "getTableIdAccordoServizioParteSpecifica";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBUtils.getIdAccordoServizioParteSpecifica((IDServizio)idAccordoServizioParteSpecifica, (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long getTableIdPortaDelegata(IDPortaDelegata idPD) throws DriverControlStationException {
        String nomeMetodo = "getTableIdPortaDelegata";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBUtils.getIdPortaDelegata((String)idPD.getNome(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long getTableIdPortaApplicativa(IDPortaApplicativa idPA) throws DriverControlStationException {
        String nomeMetodo = "getTableIdPortaApplicativa";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = DBUtils.getIdPortaApplicativa((String)idPA.getNome(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isAccordoInUso(IDAccordo idAccordo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        try {
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso((Connection)con, (String)this.tipoDB, (IDAccordo)idAccordo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isAccordoInUso(AccordoServizioParteComune as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isAccordoInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        try {
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteComuneInUso((Connection)con, (String)this.tipoDB, (IDAccordo)this.idAccordoFactory.getIDAccordoFromAccordo(as), whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isAccordoCooperazioneInUso(AccordoCooperazione as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isAccordoCooperazioneInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        try {
            boolean bl = DBOggettiInUsoUtils.isAccordoCooperazioneInUso((Connection)con, (String)this.tipoDB, (IDAccordoCooperazione)this.idAccordoCooperazioneFactory.getIDAccordoFromAccordo(as), whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isPddInUso(PdDControlStation pdd, List<String> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "pddInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        try {
            boolean bl = DBOggettiInUsoUtils.isPddInUso((Connection)con, (String)this.tipoDB, (String)pdd.getNome(), whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isSoggettoInUso(Soggetto soggettoConfig, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverControlStationException {
        return this.isSoggettoInUso(soggettoConfig, null, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    public boolean isSoggettoInUso(org.openspcoop2.core.registry.Soggetto soggettoRegistro, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverControlStationException {
        return this.isSoggettoInUso(null, soggettoRegistro, whereIsInUso, normalizeObjectIds, verificaRuoli);
    }

    private boolean isSoggettoInUso(Soggetto soggettoConfig, org.openspcoop2.core.registry.Soggetto soggettoRegistro, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverControlStationException {
        String nomeMetodo = "isSoggettoInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (soggettoRegistro != null) {
                tipoSoggetto = soggettoRegistro.getTipo();
                nomeSoggetto = soggettoRegistro.getNome();
            } else {
                tipoSoggetto = soggettoConfig.getTipo();
                nomeSoggetto = soggettoConfig.getNome();
            }
            IDSoggetto idSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
            if (soggettoRegistro != null) {
                boolean bl = DBOggettiInUsoUtils.isSoggettoRegistryInUso((Connection)con, (String)this.tipoDB, (IDSoggetto)idSoggetto, (boolean)true, whereIsInUso, (boolean)normalizeObjectIds, (boolean)verificaRuoli);
                return bl;
            }
            boolean bl = DBOggettiInUsoUtils.isSoggettoConfigInUso((Connection)con, (String)this.tipoDB, (IDSoggetto)idSoggetto, (boolean)true, whereIsInUso, (boolean)normalizeObjectIds, (boolean)verificaRuoli);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isRuoloInUso(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isRuoloInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isRuoloInUso((Connection)con, (String)this.tipoDB, (IDRuolo)idRuolo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isRuoloConfigInUso(IDRuolo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isRuoloConfigInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isRuoloConfigInUso((Connection)con, (String)this.tipoDB, (IDRuolo)idRuolo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isScopeInUso(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isScopeInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isScopeInUso((Connection)con, (String)this.tipoDB, (IDScope)idScope, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isScopeConfigInUso(IDScope idScope, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isScopeConfigInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isScopeConfigInUso((Connection)con, (String)this.tipoDB, (IDScope)idScope, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long existServizio(String nomeServizio, String tipoServizio, int versioneServizio, long idSoggettoErogatore) throws DriverControlStationException {
        String nomeMetodo = "existServizio";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        con = this.getConnection(nomeMetodo);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("nome_servizio = ?");
            sqlQueryObject.addWhereCondition("tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("versione_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggettoErogatore);
            stmt.setString(2, nomeServizio);
            stmt.setString(3, tipoServizio);
            stmt.setInt(4, versioneServizio);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                long l = risultato.getLong("id");
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public long existPdd(String nomePdd) throws DriverControlStationException {
        String nomeMetodo = "existPdd";
        Connection con = null;
        Statement stmt = null;
        ResultSet risultato = null;
        String queryString = "";
        con = this.getConnection(nomeMetodo);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.tipoDB);
            sqlQueryObject.addFromTable("pdd");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("nome = ?");
            queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, nomePdd);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                long l = risultato.getLong("id");
                return l;
            }
            long l = 0L;
            return l;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
            this.releaseConnection(con);
        }
    }

    public ConfigurazioneGenerale getConfigurazioneControlloTraffico() throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getConfigurazioneControlloTraffico";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ConfigurazioneGenerale config = null;
        try {
            config = ControlloTrafficoDriverUtils.getConfigurazioneControlloTraffico((Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        return config;
    }

    public void updateConfigurazioneControlloTraffico(ConfigurazioneGenerale configurazioneControlloTraffico) throws DriverControlStationException {
        String nomeMetodo = "updateConfigurazioneControlloTraffico";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.updateConfigurazioneControlloTraffico((ConfigurazioneGenerale)configurazioneControlloTraffico, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<Proprieta> getProprietaRateLimiting() throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getProprietaRateLimiting";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        List l = null;
        try {
            l = ControlloTrafficoDriverUtils.getProprietaRateLimiting((Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        return l;
    }

    public long countConfigurazioneControlloTrafficoConfigurazionePolicy(ISearch ricerca) throws DriverControlStationException {
        String nomeMetodo = "countConfigurazioneControlloTrafficoConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        long count = 0L;
        try {
            count = ControlloTrafficoDriverUtils.countConfigurazioneControlloTrafficoConfigurazionePolicy((ISearch)ricerca, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        return count;
    }

    public long countConfigurazioneControlloTrafficoAttivazionePolicy(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException {
        String nomeMetodo = "countConfigurazioneControlloTrafficoAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        long count = 0L;
        try {
            count = ControlloTrafficoDriverUtils.countConfigurazioneControlloTrafficoAttivazionePolicy((ISearch)ricerca, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
        return count;
    }

    public List<ConfigurazionePolicy> configurazioneControlloTrafficoConfigurazionePolicyList(ConsoleSearch ricerca) throws DriverControlStationException {
        String nomeMetodo = "configurazioneControlloTrafficoConfigurazionePolicyList";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ArrayList<ConfigurazionePolicy> listaPolicy = new ArrayList();
        try {
            listaPolicy = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoConfigurazionePolicyList((ISearch)ricerca, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return listaPolicy;
    }

    public List<ConfigurazionePolicy> configurazioneControlloTrafficoConfigurazionePolicyList_conApplicabilitaAllarme(String idAllarme) throws DriverControlStationException {
        String nomeMetodo = "configurazioneControlloTrafficoConfigurazionePolicyList_conApplicabilitaAllarme";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ArrayList<ConfigurazionePolicy> listaPolicy = new ArrayList();
        try {
            listaPolicy = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoConfigurazionePolicyList_conApplicabilitaAllarme((String)idAllarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return listaPolicy;
    }

    public void updatePosizioneAttivazionePolicy(InfoPolicy infoPolicy, AttivazionePolicy policy, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException {
        String nomeMetodo = "updatePosizioneAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.updatePosizioneAttivazionePolicy((InfoPolicy)infoPolicy, (AttivazionePolicy)policy, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<AttivazionePolicy> configurazioneControlloTrafficoAttivazionePolicyList(ConsoleSearch ricerca, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException {
        return (List)this._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, false, "configurazioneControlloTrafficoAttivazionePolicyList", null, null, null, null, null, null, null);
    }

    public List<AttivazionePolicy> configurazioneControlloTrafficoAttivazionePolicyListByFilter(ConsoleSearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws DriverControlStationException {
        return (List)this._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, false, "configurazioneControlloTrafficoAttivazionePolicyListByFilter", filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
    }

    public List<TipoRisorsaPolicyAttiva> configurazioneControlloTrafficoAttivazionePolicyTipoRisorsaList(ConsoleSearch ricerca, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException {
        return (List)this._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, true, "configurazioneControlloTrafficoAttivazionePolicyTipoRisorsaList", null, null, null, null, null, null, null);
    }

    private Object _configurazioneControlloTrafficoAttivazionePolicyList(ConsoleSearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, boolean tipoRisorsa, String nomeMetodo, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws DriverControlStationException {
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        List listaPolicy = null;
        List listaTipoRisorsa = null;
        try {
            Object o = ControlloTrafficoDriverUtils._configurazioneControlloTrafficoAttivazionePolicyList((ISearch)ricerca, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB, (boolean)tipoRisorsa, (String)nomeMetodo, (IDSoggetto)filtroSoggettoFruitore, (IDServizioApplicativo)filtroApplicativoFruitore, (String)filtroRuoloFruitore, (IDSoggetto)filtroSoggettoErogatore, (String)filtroRuoloErogatore, (IDServizio)filtroServizioAzione, (String)filtroRuolo);
            if (tipoRisorsa) {
                listaTipoRisorsa = (List)o;
            } else {
                listaPolicy = (List)o;
            }
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        if (tipoRisorsa) {
            return listaTipoRisorsa;
        }
        return listaPolicy;
    }

    public AttivazionePolicy getAttivazionePolicy(String alias, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException, NotFoundException {
        String nomeMetodo = "configurazioneControlloTrafficoAttivazionePolicyList";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        AttivazionePolicy policy = null;
        try {
            policy = ControlloTrafficoDriverUtils.getAttivazionePolicy((String)alias, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException notFound) {
            throw notFound;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return policy;
    }

    public List<InfoPolicy> getInfoPolicyList(Boolean builtIn, String idPolicyParam) throws DriverControlStationException {
        String nomeMetodo = "getInfoPolicyList";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ArrayList<InfoPolicy> listaPolicy = new ArrayList();
        try {
            listaPolicy = ControlloTrafficoDriverUtils.getInfoPolicyList((Boolean)builtIn, (String)idPolicyParam, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return listaPolicy;
    }

    public List<AttivazionePolicy> findInUseAttivazioni(String idPolicy, boolean escludiDisabilitate) throws DriverControlStationException {
        String nomeMetodo = "findInUseAttivazioni";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ArrayList<AttivazionePolicy> listaPolicy = new ArrayList();
        try {
            listaPolicy = ControlloTrafficoDriverUtils.findInUseAttivazioni((String)idPolicy, (boolean)escludiDisabilitate, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return listaPolicy;
    }

    public long countInUseAttivazioni(String idPolicy, boolean escludiDisabilitate) throws DriverControlStationException {
        String nomeMetodo = "countInUseAttivazioni";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long l = ControlloTrafficoDriverUtils.countInUseAttivazioni((String)idPolicy, (boolean)escludiDisabilitate, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return l;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public ConfigurazionePolicy getConfigurazionePolicy(long id) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ConfigurazionePolicy policy = null;
        try {
            policy = ControlloTrafficoDriverUtils.getConfigurazionePolicy((long)id, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return policy;
    }

    public ConfigurazionePolicy getConfigurazionePolicy(String nomePolicy) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        ConfigurazionePolicy policy = null;
        try {
            policy = ControlloTrafficoDriverUtils.getConfigurazionePolicy((String)nomePolicy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return policy;
    }

    public void createConfigurazionePolicy(ConfigurazionePolicy policy) throws DriverControlStationException {
        String nomeMetodo = "createConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.createConfigurazionePolicy((ConfigurazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void createAttivazionePolicy(AttivazionePolicy policy) throws DriverControlStationException {
        String nomeMetodo = "createAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.createAttivazionePolicy((AttivazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void updateConfigurazionePolicy(ConfigurazionePolicy policy) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "updateConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.updateConfigurazionePolicy((ConfigurazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void updateAttivazionePolicy(AttivazionePolicy policy) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "updateAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.updateAttivazionePolicy((AttivazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deleteConfigurazionePolicy(ConfigurazionePolicy policy) throws DriverControlStationException {
        String nomeMetodo = "deleteConfigurazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.deleteConfigurazionePolicy((ConfigurazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deleteAttivazionePolicy(AttivazionePolicy policy) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "deleteAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ControlloTrafficoDriverUtils.deleteAttivazionePolicy((AttivazionePolicy)policy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public AttivazionePolicy getAttivazionePolicy(long id) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        AttivazionePolicy policy = null;
        try {
            policy = ControlloTrafficoDriverUtils.getAttivazionePolicy((long)id, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return policy;
    }

    public AttivazionePolicy getAttivazionePolicy(String nomePolicy) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        AttivazionePolicy policy = null;
        try {
            policy = ControlloTrafficoDriverUtils.getAttivazionePolicy((String)nomePolicy, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return policy;
    }

    public String getNextPolicyInstanceSerialId(String policyId) throws DriverControlStationException {
        String nomeMetodo = "getNextPolicyInstanceSerialId";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            String string = ControlloTrafficoDriverUtils.getNextPolicyInstanceSerialId((String)policyId, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return string;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public AttivazionePolicy getPolicy(String policyId, AttivazionePolicyFiltro filtroParam, AttivazionePolicyRaggruppamento groupBy, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getPolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            AttivazionePolicy attivazionePolicy = ControlloTrafficoDriverUtils.getPolicy((String)policyId, (AttivazionePolicyFiltro)filtroParam, (AttivazionePolicyRaggruppamento)groupBy, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return attivazionePolicy;
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public AttivazionePolicy getPolicyByAlias(String alias, RuoloPolicy ruoloPorta, String nomePorta) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getPolicyByAlias";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            AttivazionePolicy attivazionePolicy = ControlloTrafficoDriverUtils.getPolicyByAlias((String)alias, (RuoloPolicy)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return attivazionePolicy;
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<AttivazionePolicy> getPolicyByServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverControlStationException, DriverControlStationNotFound {
        String nomeMetodo = "getPolicyByServizioApplicativo";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List list = ControlloTrafficoDriverUtils.getPolicyByServizioApplicativo((IDServizioApplicativo)idServizioApplicativo, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return list;
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean usedInConfigurazioneControlloTrafficoAttivazionePolicy(RuoloPolicy ruoloPorta, String nomePorta, String azione) throws DriverControlStationException {
        String nomeMetodo = "usedInConfigurazioneControlloTrafficoAttivazionePolicy";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = ControlloTrafficoDriverUtils.usedInConfigurazioneControlloTrafficoAttivazionePolicy((RuoloPolicy)ruoloPorta, (String)nomePorta, (String)azione, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return bl;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDSoggetto> getSoggettiErogatori(String protocolloSelezionato, List<String> protocolliSupportati) throws DriverControlStationException {
        String nomeMetodo = "getSoggettiErogatori";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getSoggettiErogatori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato);
                return list;
            }
            List list = RegistroCore.getSoggettiErogatori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizio> getServizi(String protocolloSelezionato, List<String> protocolliSupportati, String tipoErogatore, String nomeErogatore, String tag) throws DriverControlStationException {
        String nomeMetodo = "getServizi";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServizi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoErogatore, (String)nomeErogatore, (String)tag);
                return list;
            }
            List list = RegistroCore.getServizi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoErogatore, (String)nomeErogatore, (String)tag);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizio> getServizi(String protocolloSelezionato, List<String> protocolliSupportati, String tipoServizio, String nomeServizio, Integer versioneServizio, String tag) throws DriverControlStationException {
        String nomeMetodo = "getServizi";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServizi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)tag);
                return list;
            }
            List list = RegistroCore.getServizi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)tag);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<String> getAzioni(String protocolloSelezionato, List<String> protocolliSupportati, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverControlStationException {
        String nomeMetodo = "getAzioni";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getAzioni((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio);
                return list;
            }
            List list = RegistroCore.getAzioni((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativo> getServiziApplicativiErogatori(String protocolloSelezionato, List<String> protocolliSupportati, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws DriverControlStationException {
        String nomeMetodo = "getServiziApplicativiErogatori";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServiziApplicativiErogatori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)azione);
                return list;
            }
            List list = RegistroCore.getServiziApplicativiErogatori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)azione);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDSoggetto> getSoggetti(String protocolloSelezionato, List<String> protocolliSupportati) throws DriverControlStationException {
        String nomeMetodo = "getSoggetti";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getSoggetti((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato);
                return list;
            }
            List list = RegistroCore.getSoggetti((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDSoggetto> getSoggettiFruitori(String protocolloSelezionato, List<String> protocolliSupportati, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio) throws DriverControlStationException {
        String nomeMetodo = "getSoggettiFruitori";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getSoggettiFruitori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio);
                return list;
            }
            List list = RegistroCore.getSoggettiFruitori((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativo> getServiziApplicativiFruitore(String protocolloSelezionato, List<String> protocolliSupportati, String tipoFruitore, String nomeFruitore, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String azione) throws DriverControlStationException {
        String nomeMetodo = "getServiziApplicativiFruitore";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServiziApplicativiFruitore((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoFruitore, (String)nomeFruitore, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)azione);
                return list;
            }
            List list = RegistroCore.getServiziApplicativiFruitore((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoFruitore, (String)nomeFruitore, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)azione);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativo> getServiziApplicativiFruitore(String protocolloSelezionato, List<String> protocolliSupportati, String tipoFruitore, String nomeFruitore) throws DriverControlStationException {
        String nomeMetodo = "getServiziApplicativiFruitore";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServiziApplicativiFruitore((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoFruitore, (String)nomeFruitore);
                return list;
            }
            List list = RegistroCore.getServiziApplicativiFruitore((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoFruitore, (String)nomeFruitore);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizioApplicativo> getServiziApplicativi(String protocolloSelezionato, List<String> protocolliSupportati, String tipoProprietario, String nomeProprietario) throws DriverControlStationException {
        String nomeMetodo = "getServiziApplicativi";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            if (protocolloSelezionato != null) {
                List list = RegistroCore.getServiziApplicativi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, (String)protocolloSelezionato, (String)tipoProprietario, (String)nomeProprietario);
                return list;
            }
            List list = RegistroCore.getServiziApplicativi((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolliSupportati, (String)tipoProprietario, (String)nomeProprietario);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDServizio> getErogazioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws Exception {
        return this.getErogazioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto, null, null, null, null);
    }

    public List<IDServizio> getErogazioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws DriverControlStationException {
        String nomeMetodo = "getErogazioni";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            List list = RegistroCore.getErogazioni((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolli, (String)gruppo, (String)tipoSoggetto, (String)nomeSoggetto, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)nomeAzione);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<IDFruizione> getFruizioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws Exception {
        return this.getFruizioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto, null, null, null, null, null, null);
    }

    public List<IDFruizione> getFruizioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws DriverControlStationException {
        String nomeMetodo = "getFruizioni";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager serviceManager = RegistroCore.getServiceManager((Logger)this.log, (String)this.tipoDB, (Connection)con);
            List list = RegistroCore.getFruizioni((org.openspcoop2.core.commons.search.dao.jdbc.JDBCServiceManager)serviceManager, protocolli, (String)gruppo, (String)tipoSoggetto, (String)nomeSoggetto, (String)tipoErogatore, (String)nomeErogatore, (String)tipoServizio, (String)nomeServizio, (Integer)versioneServizio, (String)nomeAzione);
            return list;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isGruppoInUso(IDGruppo idGruppo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isGruppoInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isGruppoInUso((Connection)con, (String)this.tipoDB, (IDGruppo)idGruppo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isGruppoConfigInUso(IDGruppo idRuolo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isGruppoConfigInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isGruppoConfigInUso((Connection)con, (String)this.tipoDB, (IDGruppo)idRuolo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isRisorsaInUso(IDResource idRisorsa, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isRisorsaInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isRisorsaInUso((Connection)con, (String)this.tipoDB, (IDResource)idRisorsa, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isPortTypeInUso(IDPortType idPT, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isPortTypeInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isPortTypeInUso((Connection)con, (String)this.tipoDB, (IDPortType)idPT, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isOperazioneInUso(IDPortTypeAzione idOperazione, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isOperazioneInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isOperazioneInUso((Connection)con, (String)this.tipoDB, (IDPortTypeAzione)idOperazione, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public int numeroPluginsClassiList() throws DriverConfigurazioneException {
        String nomeMetodo = "numeroPluginsClassiList";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            int e = PluginsDriverUtils.numeroPluginsClassiList((Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<Plugin> pluginsClassiList(ISearch ricerca) throws DriverConfigurazioneException {
        String nomeMetodo = "pluginsClassiList";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = PluginsDriverUtils.pluginsClassiList((ISearch)ricerca, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void createPluginClassi(Plugin plugin) throws DriverConfigurazioneException {
        String nomeMetodo = "createPluginClassi";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            PluginsDriverUtils.createPluginClassi((Plugin)plugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void updatePluginClassi(Plugin plugin) throws DriverConfigurazioneException {
        String nomeMetodo = "updatePluginClassi";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            PluginsDriverUtils.updatePluginClassi((Plugin)plugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deletePluginClassi(Plugin plugin) throws DriverConfigurazioneException {
        String nomeMetodo = "deletePluginClassi";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            PluginsDriverUtils.deletePluginClassi((Plugin)plugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsPlugin(TipoPlugin tipoPlugin, String tipo, String label, String className) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPlugin";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = PluginsDriverUtils.existsPlugin((TipoPlugin)tipoPlugin, (String)tipo, (String)label, (String)className, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsPluginConTipo(TipoPlugin tipoPlugin, String tipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPluginConTipo";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = PluginsDriverUtils.existsPluginConTipo((TipoPlugin)tipoPlugin, (String)tipo, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsPluginConLabel(TipoPlugin tipoPlugin, String label) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPluginConLabel";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = PluginsDriverUtils.existsPluginConLabel((TipoPlugin)tipoPlugin, (String)label, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsPluginConClassName(TipoPlugin tipoPlugin, String className) throws DriverConfigurazioneException {
        String nomeMetodo = "existsPluginConClassName";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = PluginsDriverUtils.existsPluginConClassName((TipoPlugin)tipoPlugin, (String)className, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public Plugin getPlugin(long idPlugin) throws DriverConfigurazioneException {
        String nomeMetodo = "getPlugin";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            Plugin e = PluginsDriverUtils.getPlugin((long)idPlugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public Plugin getPlugin(TipoPlugin tipoPlugin, String tipo, boolean throwNotFound) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String nomeMetodo = "getPlugin";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            Plugin e = PluginsDriverUtils.getPlugin((TipoPlugin)tipoPlugin, (String)tipo, (boolean)throwNotFound, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (NotFoundException notFound) {
            throw new DriverConfigurazioneNotFound("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + notFound.getMessage(), (Throwable)notFound);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean isPluginInUso(String className, String label, String tipoPlugin, String tipo, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverControlStationException {
        String nomeMetodo = "isPluginInUso";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean bl = DBOggettiInUsoUtils.isPluginInUso((Connection)con, (String)this.tipoDB, (String)className, (String)label, (String)tipoPlugin, (String)tipo, whereIsInUso, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<ConfigurazioneAllarmeBean> allarmiList(ConsoleSearch ricerca, RuoloPorta ruoloPorta, String nomePorta) throws DriverConfigurazioneException {
        String nomeMetodo = "allarmiList";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = AllarmiDriverUtils.allarmiList((ISearch)ricerca, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<Allarme> allarmiSenzaPluginList(ConsoleSearch ricerca, RuoloPorta ruoloPorta, String nomePorta) throws DriverConfigurazioneException {
        String nomeMetodo = "allarmiSenzaPluginList";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.allarmiList((ISearch)ricerca, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsAllarmi(TipoAllarme tipoAllarme) throws DriverConfigurazioneException {
        String nomeMetodo = "existsAllarmi";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.existsAllarmi((TipoAllarme)tipoAllarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public long countAllarmi(TipoAllarme tipoAllarme) throws DriverConfigurazioneException {
        String nomeMetodo = "countAllarmi";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            long e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.countAllarmi((TipoAllarme)tipoAllarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void createAllarme(Allarme allarme) throws DriverConfigurazioneException {
        String nomeMetodo = "createAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.createAllarme((Allarme)allarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void updateAllarme(Allarme allarme) throws DriverConfigurazioneException {
        String nomeMetodo = "updateAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.updateAllarme((Allarme)allarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void deleteAllarme(Allarme allarme) throws DriverConfigurazioneException {
        String nomeMetodo = "deleteAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.deleteAllarme((Allarme)allarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsAllarme(String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "existsAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.existsAllarme((String)nome, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public void createHistoryAllarme(AllarmeHistory allarme) throws DriverConfigurazioneException {
        String nomeMetodo = "createHistoryAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.createHistoryAllarme((AllarmeHistory)allarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public Allarme getAllarmeSenzaPlugin(Long id) throws DriverConfigurazioneException {
        String nomeMetodo = "getAllarmeSenzaPlugin";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            Allarme e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getAllarme((Long)id, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public Allarme getAllarmeSenzaPlugin(String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getAllarmeSenzaPluginByNome";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            Allarme e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getAllarme((String)nome, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public ConfigurazioneAllarmeBean getAllarme(Long id) throws DriverConfigurazioneException {
        String nomeMetodo = "getAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ConfigurazioneAllarmeBean e = AllarmiDriverUtils.getAllarme((Long)id, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public ConfigurazioneAllarmeBean getAllarme(String nome) throws DriverConfigurazioneException {
        String nomeMetodo = "getAllarmeByNome";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ConfigurazioneAllarmeBean e = AllarmiDriverUtils.getAllarme((String)nome, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public ConfigurazioneAllarmeBean getAllarme(Allarme allarme) throws DriverConfigurazioneException {
        String nomeMetodo = "convertAllarme";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ConfigurazioneAllarmeBean e = AllarmiDriverUtils.getAllarme((Allarme)allarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public Allarme getAllarmeByAlias(String alias, RuoloPorta ruoloPorta, String nomePorta) throws DriverControlStationNotFound, DriverConfigurazioneException {
        String nomeMetodo = "getAllarmeByAlias";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            Allarme e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getAllarmeByAlias((String)alias, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (NotFoundException e) {
            throw new DriverControlStationNotFound("[DriverControlStationDB::" + nomeMetodo + "] Allarme non presente.");
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<ConfigurazioneAllarmeHistoryBean> allarmiHistoryList(ConsoleSearch ricerca, Long idAllarme) throws DriverConfigurazioneException {
        String nomeMetodo = "allarmiHistoryList";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = AllarmiDriverUtils.allarmiHistoryList((ISearch)ricerca, (Long)idAllarme, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public String getNextAlarmInstanceSerialId(String tipoPlugin) throws DriverControlStationException {
        String nomeMetodo = "getNextAlarmInstanceSerialId";
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            String string = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.getNextAlarmInstanceSerialId((String)tipoPlugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return string;
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<ConfigurazioneAllarmeBean> configurazioneAllarmiList(ConsoleSearch ricerca, RuoloPorta ruoloPorta, String nomePorta) throws DriverControlStationException {
        return this._configurazioneAllarmiList(ricerca, ruoloPorta, nomePorta, "configurazioneControlloTrafficoAttivazionePolicyList", null, null, null, null, null, null, null);
    }

    public List<ConfigurazioneAllarmeBean> configurazioneAllarmiListByFilter(ConsoleSearch ricerca, RuoloPorta ruoloPorta, String nomePorta, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws DriverControlStationException {
        return this._configurazioneAllarmiList(ricerca, ruoloPorta, nomePorta, "configurazioneControlloTrafficoAttivazionePolicyListByFilter", filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
    }

    private List<ConfigurazioneAllarmeBean> _configurazioneAllarmiList(ConsoleSearch ricerca, RuoloPorta ruoloPorta, String nomePorta, String nomeMetodo, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws DriverControlStationException {
        Connection con = null;
        con = this.getConnection(nomeMetodo);
        this.logDebug("operazione this.atomica = " + this.atomica);
        List listaAllarmi = null;
        try {
            listaAllarmi = AllarmiDriverUtils.configurazioneAllarmiList((ISearch)ricerca, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB, (String)nomeMetodo, (IDSoggetto)filtroSoggettoFruitore, (IDServizioApplicativo)filtroApplicativoFruitore, (String)filtroRuoloFruitore, (IDSoggetto)filtroSoggettoErogatore, (String)filtroRuoloErogatore, (IDServizio)filtroServizioAzione, (String)filtroRuolo);
        }
        catch (Exception qe) {
            throw new DriverControlStationException("[DriverControlStationDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            this.releaseConnection(con);
        }
        return listaAllarmi;
    }

    public List<Allarme> allarmiForPolicyRateLimiting(String activeIdPolicy, RuoloPorta ruoloPorta, String nomePorta) throws DriverConfigurazioneException {
        String nomeMetodo = "allarmiForPolicyRateLimiting";
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = org.openspcoop2.core.allarmi.utils.AllarmiDriverUtils.allarmiForPolicyRateLimiting((String)activeIdPolicy, (RuoloPorta)ruoloPorta, (String)nomePorta, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public int numeroHandlersRichiestaList(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "numeroHandlersRichiestaList";
        return this.numeroHandlersList(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public int numeroHandlersRispostaList(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "numeroHandlersRispostaList";
        return this.numeroHandlersList(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public int numeroHandlersServizioList(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "numeroHandlersServizioList";
        return this.numeroHandlersList(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.SERVICE_HANDLER);
    }

    private int numeroHandlersList(String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, TipoPlugin tipoPlugin) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            int e = HandlersDriverUtils.numeroHandlerList((String)tipologia, (TipoPdD)ruoloPorta, (Long)idPorta, (TipoPlugin)tipoPlugin, (String)nomeMetodo, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public List<ConfigurazioneHandlerBean> handlersRichiestaList(ISearch ricerca, String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "handlersRichiestaList";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_RICHIESTA;
        return this.handlersList(ricerca, tipologia, ruoloPorta, idPorta, nomeMetodo, idLista, TipoPlugin.MESSAGE_HANDLER);
    }

    public List<ConfigurazioneHandlerBean> handlersRispostaList(ISearch ricerca, String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "handlersRispostaList";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_RISPOSTA;
        return this.handlersList(ricerca, tipologia, ruoloPorta, idPorta, nomeMetodo, idLista, TipoPlugin.MESSAGE_HANDLER);
    }

    public List<ConfigurazioneHandlerBean> handlersServizioList(ISearch ricerca, String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "handlersServizioList";
        int idLista = Liste.CONFIGURAZIONE_HANDLERS_SERVIZIO;
        return this.handlersList(ricerca, tipologia, ruoloPorta, idPorta, nomeMetodo, idLista, TipoPlugin.SERVICE_HANDLER);
    }

    private List<ConfigurazioneHandlerBean> handlersList(ISearch ricerca, String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, int idLista, TipoPlugin tipoPlugin) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            List e = HandlersDriverUtils.handlerList((ISearch)ricerca, (String)tipologia, (TipoPdD)ruoloPorta, (Long)idPorta, (String)nomeMetodo, (int)idLista, (TipoPlugin)tipoPlugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public int getMaxPosizioneHandlersRichiesta(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "getMaxPosizioneHandlersRichiesta";
        return this.getMaxPosizioneHandlers(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public int getMaxPosizioneHandlersRisposta(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "getMaxPosizioneHandlersRisposta";
        return this.getMaxPosizioneHandlers(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public int getMaxPosizioneHandlersServizio(String tipologia, TipoPdD ruoloPorta, Long idPorta) throws DriverConfigurazioneException {
        String nomeMetodo = "getMaxPosizioneHandlersServizio";
        return this.getMaxPosizioneHandlers(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.SERVICE_HANDLER);
    }

    private int getMaxPosizioneHandlers(String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, TipoPlugin tipoPlugin) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            int e = HandlersDriverUtils.getMaxPosizioneHandlers((String)tipologia, (TipoPdD)ruoloPorta, (Long)idPorta, (String)nomeMetodo, (TipoPlugin)tipoPlugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public boolean existsHandlerRichiesta(String tipologia, TipoPdD ruoloPorta, Long idPorta, String tipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsHandlerRichiesta";
        return this.existsHandler(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER, tipo);
    }

    public boolean existsHandlerRisposta(String tipologia, TipoPdD ruoloPorta, Long idPorta, String tipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsHandlerRisposta";
        return this.existsHandler(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.MESSAGE_HANDLER, tipo);
    }

    public boolean existsHandlerServizio(String tipologia, TipoPdD ruoloPorta, Long idPorta, String tipo) throws DriverConfigurazioneException {
        String nomeMetodo = "existsHandlerServizio";
        return this.existsHandler(tipologia, ruoloPorta, idPorta, nomeMetodo, TipoPlugin.SERVICE_HANDLER, tipo);
    }

    private boolean existsHandler(String tipologia, TipoPdD ruoloPorta, Long idPorta, String nomeMetodo, TipoPlugin tipoPlugin, String tipo) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            boolean e = HandlersDriverUtils.existsHandler((String)tipologia, (TipoPdD)ruoloPorta, (Long)idPorta, (String)nomeMetodo, (TipoPlugin)tipoPlugin, (String)tipo, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    public ConfigurazioneHandlerBean getHandlerRichiesta(String tipologia, TipoPdD ruoloPorta, Long idPorta, Long idHandler) throws DriverConfigurazioneException {
        String nomeMetodo = "getHandlerRichiesta";
        return this.getHandler(tipologia, ruoloPorta, idPorta, idHandler, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public ConfigurazioneHandlerBean getHandlerRisposta(String tipologia, TipoPdD ruoloPorta, Long idPorta, Long idHandler) throws DriverConfigurazioneException {
        String nomeMetodo = "getHandlerRisposta";
        return this.getHandler(tipologia, ruoloPorta, idPorta, idHandler, nomeMetodo, TipoPlugin.MESSAGE_HANDLER);
    }

    public ConfigurazioneHandlerBean getHandlerServizio(String tipologia, TipoPdD ruoloPorta, Long idPorta, Long idHandler) throws DriverConfigurazioneException {
        String nomeMetodo = "getHandlerServizio";
        return this.getHandler(tipologia, ruoloPorta, idPorta, idHandler, nomeMetodo, TipoPlugin.SERVICE_HANDLER);
    }

    private ConfigurazioneHandlerBean getHandler(String tipologia, TipoPdD ruoloPorta, Long idPorta, Long idHandler, String nomeMetodo, TipoPlugin tipoPlugin) throws DriverConfigurazioneException {
        Connection con = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        this.logDebug("operazione this.atomica = " + this.atomica);
        try {
            ConfigurazioneHandlerBean e = HandlersDriverUtils.getHandler((String)tipologia, (TipoPdD)ruoloPorta, (Long)idPorta, (Long)idHandler, (String)nomeMetodo, (TipoPlugin)tipoPlugin, (Connection)con, (Logger)this.log, (String)this.tipoDB);
            return e;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProprietaOggettoErogazione(IDServizio idServizio, String user, boolean throwException) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggettoErogazione";
        DriverRegistroServiziDB driver = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            this.logDebug("operazione this.atomica = " + this.atomica);
            driver = new DriverRegistroServiziDB(con, this.log, this.tipoDB);
            driver.updateProprietaOggettoErogazione(idServizio, user);
        }
        catch (Exception e) {
            String msgError = "[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + e.getMessage();
            ControlStationCore.logError(msgError, e);
            if (throwException) {
                throw new DriverRegistroServiziException(msgError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProprietaOggettoErogazione(long idServizio, String user, boolean throwException) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggettoErogazione";
        DriverRegistroServiziDB driver = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            this.logDebug("operazione this.atomica = " + this.atomica);
            driver = new DriverRegistroServiziDB(con, this.log, this.tipoDB);
            driver.updateProprietaOggettoErogazione(idServizio, user);
        }
        catch (Exception e) {
            String msgError = "[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + e.getMessage();
            ControlStationCore.logError(msgError, e);
            if (throwException) {
                throw new DriverRegistroServiziException(msgError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProprietaOggettoFruizione(IDServizio idServizio, IDSoggetto idFruitore, String user, boolean throwException) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggettoFruizione";
        DriverRegistroServiziDB driver = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            this.logDebug("operazione this.atomica = " + this.atomica);
            driver = new DriverRegistroServiziDB(con, this.log, this.tipoDB);
            driver.updateProprietaOggettoFruizione(idServizio, idFruitore, user);
        }
        catch (Exception e) {
            String msgError = "[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + e.getMessage();
            ControlStationCore.logError(msgError, e);
            if (throwException) {
                throw new DriverRegistroServiziException(msgError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProprietaOggettoFruizione(long idFruizione, String user, boolean throwException) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "updateProprietaOggettoFruizione";
        DriverRegistroServiziDB driver = null;
        if (this.atomica) {
            try {
                con = this.datasource.getConnection();
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), (Throwable)e);
            }
        } else {
            con = this.globalConnection;
        }
        try {
            this.logDebug("operazione this.atomica = " + this.atomica);
            driver = new DriverRegistroServiziDB(con, this.log, this.tipoDB);
            driver.updateProprietaOggettoFruizione(idFruizione, user);
        }
        catch (Exception e) {
            String msgError = "[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + e.getMessage();
            ControlStationCore.logError(msgError, e);
            if (throwException) {
                throw new DriverRegistroServiziException(msgError, (Throwable)e);
            }
        }
        finally {
            this.releaseConnection(con);
        }
    }
}

