/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.slf4j.Logger;

public class DriverControlStationDB_LIB {
    private static Logger log = null;
    private static String tipoDB = null;

    public static void initialize(Logger logParam) {
        log = logParam;
    }

    public static void setTipoDB(String tipoDatabase) {
        tipoDB = tipoDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void CRUDPdd(int type, PdDControlStation pdd, Connection con) throws DriverControlStationException {
        if (pdd == null) {
            throw new DriverControlStationException("[DriverControlStationDB_LIB::CRUDPdd] Parametro non valido.");
        }
        if (type != 1 && pdd.getId() <= 0L) {
            throw new DriverControlStationException("[DriverControlStationDB_LIB::CRUDPdd] ID Pdd non valido.");
        }
        String nome = pdd.getNome();
        String descrizione = pdd.getDescrizione();
        String ip = pdd.getIp();
        int porta = pdd.getPorta();
        String ipGestione = pdd.getIpGestione();
        int portaGestione = pdd.getPortaGestione();
        String protocollo = pdd.getProtocollo();
        String protocolloGestione = pdd.getProtocolloGestione();
        String tipo = pdd.getTipo();
        String implementazione = pdd.getImplementazione();
        String subject = pdd.getSubject();
        String password = pdd.getPassword();
        StatoFunzionalita client_auth = pdd.getClientAuth();
        String superuser = pdd.getSuperUser();
        Statement updateStmt = null;
        String updateQuery = "";
        Statement selectStmt = null;
        String selectQuery = "";
        ResultSet selectRS = null;
        int n = 0;
        try {
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addInsertTable("pdd");
                    sqlQueryObject.addInsertField("nome", "?");
                    sqlQueryObject.addInsertField("descrizione", "?");
                    sqlQueryObject.addInsertField("ip", "?");
                    sqlQueryObject.addInsertField("porta", "?");
                    sqlQueryObject.addInsertField("ip_gestione", "?");
                    sqlQueryObject.addInsertField("porta_gestione", "?");
                    sqlQueryObject.addInsertField("protocollo", "?");
                    sqlQueryObject.addInsertField("protocollo_gestione", "?");
                    sqlQueryObject.addInsertField("tipo", "?");
                    sqlQueryObject.addInsertField("implementazione", "?");
                    sqlQueryObject.addInsertField("subject", "?");
                    sqlQueryObject.addInsertField("password", "?");
                    sqlQueryObject.addInsertField("client_auth", "?");
                    sqlQueryObject.addInsertField("superuser", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addInsertField("ora_registrazione", "?");
                    }
                    updateQuery = sqlQueryObject.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, ip);
                    updateStmt.setInt(index++, porta);
                    updateStmt.setString(index++, ipGestione);
                    updateStmt.setInt(index++, portaGestione);
                    updateStmt.setString(index++, protocollo);
                    updateStmt.setString(index++, protocolloGestione);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setString(index++, implementazione);
                    updateStmt.setString(index++, subject != null ? CertificateUtils.formatPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    updateStmt.setString(index++, password);
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue((StatoFunzionalita)client_auth));
                    updateStmt.setString(index++, superuser);
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug("CRUDPdd type = " + type + " row affected =" + n);
                    log.debug("CRUDPdd CREATE : \n" + DriverControlStationDB_LIB.formatSQLString(updateQuery, nome, descrizione, ip, porta, ipGestione, portaGestione, protocollo, protocolloGestione, tipo, implementazione, subject, password, client_auth));
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addFromTable("pdd");
                    sqlQueryObject.addSelectField("id");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    selectQuery = sqlQueryObject.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, nome);
                    selectRS = selectStmt.executeQuery();
                    if (selectRS.next()) {
                        pdd.setId(selectRS.getLong("id"));
                    }
                    selectRS.close();
                    selectStmt.close();
                    return;
                }
                case 2: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addUpdateTable("pdd");
                    sqlQueryObject.addUpdateField("descrizione", "?");
                    sqlQueryObject.addUpdateField("ip", "?");
                    sqlQueryObject.addUpdateField("porta", "?");
                    sqlQueryObject.addUpdateField("ip_gestione", "?");
                    sqlQueryObject.addUpdateField("porta_gestione", "?");
                    sqlQueryObject.addUpdateField("protocollo", "?");
                    sqlQueryObject.addUpdateField("protocollo_gestione", "?");
                    sqlQueryObject.addUpdateField("tipo", "?");
                    sqlQueryObject.addUpdateField("implementazione", "?");
                    sqlQueryObject.addUpdateField("subject", "?");
                    sqlQueryObject.addUpdateField("password", "?");
                    sqlQueryObject.addUpdateField("client_auth", "?");
                    sqlQueryObject.addUpdateField("superuser", "?");
                    sqlQueryObject.addUpdateField("nome", "?");
                    if (pdd.getOraRegistrazione() != null) {
                        sqlQueryObject.addUpdateField("ora_registrazione", "?");
                    }
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, ip);
                    updateStmt.setInt(index++, porta);
                    updateStmt.setString(index++, ipGestione);
                    updateStmt.setInt(index++, portaGestione);
                    updateStmt.setString(index++, protocollo);
                    updateStmt.setString(index++, protocolloGestione);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setString(index++, implementazione);
                    updateStmt.setString(index++, subject != null ? CertificateUtils.formatPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT) : null);
                    updateStmt.setString(index++, password);
                    updateStmt.setString(index++, DriverRegistroServiziDB_LIB.getValue((StatoFunzionalita)client_auth));
                    updateStmt.setString(index++, superuser);
                    updateStmt.setString(index++, nome);
                    if (pdd.getOraRegistrazione() != null) {
                        updateStmt.setTimestamp(index++, new Timestamp(pdd.getOraRegistrazione().getTime()));
                    }
                    updateStmt.setLong(index++, pdd.getId());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug("CRUDPdd type = " + type + " row affected =" + n);
                    log.debug("CRUDPdd UPDATE : \n" + DriverControlStationDB_LIB.formatSQLString(updateQuery, descrizione, ip, porta, ipGestione, portaGestione, protocollo, protocolloGestione, tipo, implementazione, subject, password, client_auth, pdd.getId()));
                    return;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                    sqlQueryObject.addDeleteTable("pdd");
                    sqlQueryObject.addWhereCondition("id=?");
                    updateQuery = sqlQueryObject.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setLong(1, pdd.getId());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    log.debug("CRUDPdd type = " + type + " row affected =" + n);
                    log.debug("CRUDPdd DELETE : \n" + DriverControlStationDB_LIB.formatSQLString(updateQuery, pdd.getId()));
                    return;
                }
            }
            return;
        }
        catch (SQLException se) {
            throw new DriverControlStationException("[DriverControlStationDB_LIB::CRUDPdd] SQLException [" + se.getMessage() + "].");
        }
        catch (Exception se) {
            throw new DriverControlStationException("[DriverControlStationDB_LIB::CRUDPdd] Exception [" + se.getMessage() + "].");
        }
        finally {
            try {
                if (updateStmt != null) {
                    updateStmt.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (selectRS != null) {
                    selectRS.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (selectStmt != null) {
                    selectStmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String formatSQLString(String sql, Object ... params) {
        String res = sql;
        for (int i = 0; i < params.length; ++i) {
            res = res.replaceFirst("\\?", "{" + i + "}");
        }
        return MessageFormat.format(res, params);
    }
}

