/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import org.openspcoop2.web.ctrlstat.gestori.IGestore;
import org.openspcoop2.web.lib.queue.ClassQueue;
import org.openspcoop2.web.lib.queue.dao.Operation;
import org.slf4j.Logger;

public abstract class GestoreGeneral
implements IGestore,
Runnable {
    public List<Operation> filterOperations(String idOperazione, ClassQueue operationManager, Operation originalOperation, QueueSession qs, Queue queue, Logger log) throws Exception {
        ArrayList<Operation> filteredOperations = new ArrayList<Operation>();
        String escapedFilter = idOperazione.replaceAll("'", "''");
        String strMessageSelector = "ID = '" + escapedFilter + "'";
        QueueReceiver filtro = null;
        try {
            filtro = qs.createReceiver(queue, strMessageSelector);
            ObjectMessage operazioneFiltrata = (ObjectMessage)filtro.receive(100L);
            while (operazioneFiltrata != null) {
                Serializable objFilter;
                try {
                    objFilter = operazioneFiltrata.getObject();
                }
                catch (Exception e) {
                    log.error(this.getName() + ": Impossibile recuperare il messaggio :" + e.toString(), (Throwable)e);
                    continue;
                }
                int idOpFiltrata = Integer.parseInt(objFilter.toString());
                if (idOpFiltrata == 0) {
                    log.error(this.getName() + ": Impossibile recuperare l'id del messaggio da filtrare.");
                    continue;
                }
                Operation operazioneDaFiltrare = operationManager.getOperation((long)idOpFiltrata);
                operationManager.filterOperation(operazioneDaFiltrare, originalOperation);
                filteredOperations.add(operazioneDaFiltrare);
                operazioneFiltrata = (ObjectMessage)filtro.receive(100L);
            }
            ArrayList<Operation> arrayList = filteredOperations;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (filtro != null) {
                    filtro.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected abstract String getName();
}

