/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.gestori.GestoreNonAttivoException;
import org.openspcoop2.web.ctrlstat.gestori.GestorePdDThread;
import org.openspcoop2.web.ctrlstat.gestori.IGestore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.slf4j.Logger;

public class GestorePdDInitThread
extends Thread {
    private ConsoleProperties consoleProperties;
    private static Logger log = null;
    private static Map<String, IGestore> gestoriPdd = new HashMap<String, IGestore>();
    private volatile boolean singlePdD = false;
    private boolean enginePDD = false;

    public GestorePdDInitThread() throws OpenSPCoop2ConfigurationException {
        log = ControlStationLogger.getGestorePddLogger();
        this.consoleProperties = ConsoleProperties.getInstance();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            this.initGestore();
            if (this.singlePdD) {
                GestorePdDInitThread.log.warn("GestorePdDInitThread non avviato: govwayConsole avviata in singlePdD mode.");
                return;
            }
        }
        catch (GestoreNonAttivoException e) {
            GestorePdDInitThread.log.warn("Inizializzazione GestorePdDInitThread non effettuata : " + e.getMessage());
            return;
        }
        catch (Exception e) {
            GestorePdDInitThread.log.error("Inizializzazione Gestore PdD Init Thread Fallita : " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            if (!DBManager.isInitialized()) {
                GestorePdDInitThread.log.info("Inizializzazione di " + this.getClass().getSimpleName() + " non riuscito perche' DBManager non INIZIALIZZATO");
                GestorePdDInitThread.log.info("Gestore Pdd non avviato!");
                return;
            }
            dbm = DBManager.getInstance();
            con = dbm.getConnection();
            core = new PddCore();
            if (!core.isSinglePdD()) {
                pddList = core.getAllIdPorteDominio(null);
                if (pddList != null && pddList.size() > 0) {
                    GestorePdDInitThread.log.info("Trovate " + pddList.size() + " pdd su cui avviare il thread di gestione");
                } else {
                    GestorePdDInitThread.log.info("Non sono state trovate pdd da gestire");
                }
                ** if (pddList == null) goto lbl38
                for (i = 0; i < pddList.size(); ++i) {
                    pdd = null;
                    try {
                        pdd = core.getPdDControlStation(pddList.get(i));
                    }
                    catch (DriverControlStationNotFound dNot) {
                        GestorePdDInitThread.log.error("Errore durante la lettura dei dati della pdd [" + pddList.get(i) + "]: " + dNot.getMessage());
                    }
                    if (pdd == null) continue;
                    GestorePdDInitThread.addGestore(pdd);
lbl-1000:
                    // 2 sources

                    {
                        continue;
                    }
                }
            }
lbl38:
            // 4 sources

            dbm.releaseConnection(con);
        }
        catch (ControlStationCoreException csce) {
            GestorePdDInitThread.log.error("ControlStationCoreException: " + csce.getMessage());
        }
        catch (DriverControlStationException dcse) {
            GestorePdDInitThread.log.error("DriverControlStationException: " + dcse.getMessage());
        }
        catch (Exception dcse) {
            GestorePdDInitThread.log.error("DriverControlStationException: " + dcse.getMessage());
        }
    }

    public static void startPdD(String nomeCoda) throws OpenSPCoop2ConfigurationException {
        GestorePdDThread pdd = new GestorePdDThread(nomeCoda);
        gestoriPdd.put(nomeCoda, pdd);
        new Thread(pdd).start();
    }

    public void stopGestore() {
        if (gestoriPdd != null && !gestoriPdd.isEmpty()) {
            for (String pdd : gestoriPdd.keySet()) {
                GestorePdDInitThread.deleteGestore(pdd);
            }
        }
    }

    public void initGestore() throws Exception {
        this.enginePDD = this.consoleProperties.isGestioneCentralizzataSincronizzazionePdd();
        this.singlePdD = this.consoleProperties.isSinglePdD();
        if (!this.enginePDD) {
            throw new GestoreNonAttivoException("Motore di sincronizzazione verso le Porte di Dominio non attivo.");
        }
    }

    public static void addGestore(PdDControlStation pdd) throws Exception {
        block5: {
            if (!gestoriPdd.containsKey(pdd.getNome())) {
                try {
                    String tipoPdd = pdd.getTipo();
                    if (tipoPdd != null && PddTipologia.OPERATIVO.toString().equals(tipoPdd)) {
                        log.info("Avvio thread di gestione per la porta di dominio [" + pdd.getNome() + "] ...");
                        String nomeCoda = pdd.getNome();
                        GestorePdDInitThread.startPdD(nomeCoda);
                        log.info("Avviato thread di gestione per la porta di dominio [" + pdd.getNome() + "]");
                        break block5;
                    }
                    log.info("Thread di gestione per la porta di dominio [" + pdd.getNome() + "] non avviato poiche' la porta di dominio non possiede tipo " + PddTipologia.OPERATIVO.toString() + " (tipo:" + pdd.getTipo() + ")");
                }
                catch (Exception e) {
                    log.error("Thread di gestione per la porta di dominio [" + pdd.getNome() + "] non avviato: " + e.getMessage());
                }
            } else {
                log.debug("Thread di gestione per la porta di dominio [" + pdd.getNome() + "] gia' in esecuzione");
            }
        }
    }

    public static void deleteGestore(String pdd) {
        if (!gestoriPdd.containsKey(pdd)) {
            log.debug("Thread di gestione per la porta di dominio [" + pdd + "] non risulta in esecuzione");
        } else {
            log.debug("Fermo il thread di gestione per la porta di dominio [" + pdd + "] ...");
            GestorePdDThread gestore = (GestorePdDThread)gestoriPdd.get(pdd);
            gestore.stopGestore();
            int timeout = 60;
            for (int i = 0; i < timeout && gestore.isRunning(); ++i) {
                Utilities.sleep((long)1000L);
            }
            log.debug("Thread di gestione per la porta di dominio [" + pdd + "] terminato");
            gestoriPdd.remove(pdd);
        }
    }
}

