/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.sql.Connection;
import javax.jms.ExceptionListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.xml.ws.BindingProvider;
import org.openspcoop2.core.config.ws.client.portaapplicativa.all.PortaApplicativa;
import org.openspcoop2.core.config.ws.client.portaapplicativa.all.PortaApplicativaSoap11Service;
import org.openspcoop2.core.config.ws.client.portadelegata.all.PortaDelegata;
import org.openspcoop2.core.config.ws.client.portadelegata.all.PortaDelegataSoap11Service;
import org.openspcoop2.core.config.ws.client.servizioapplicativo.all.ServizioApplicativo;
import org.openspcoop2.core.config.ws.client.servizioapplicativo.all.ServizioApplicativoSoap11Service;
import org.openspcoop2.core.config.ws.client.soggetto.all.Soggetto;
import org.openspcoop2.core.config.ws.client.soggetto.all.SoggettoSoap11Service;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.jms.ExceptionListenerJMS;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.core.QueueManager;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.gestori.GestoreGeneral;
import org.openspcoop2.web.ctrlstat.gestori.GestoreNonAttivoException;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.slf4j.Logger;

public class GestorePdDThread
extends GestoreGeneral {
    private ConsoleProperties consoleProperties;
    private DatasourceProperties datasourceProperties;
    private Logger log = null;
    private volatile boolean stop = false;
    private volatile boolean isRunning = false;
    private PddCore pddCore;
    private SoggettiCore soggettiCore;
    private PorteApplicativeCore paCore;
    private PorteDelegateCore pdCore;
    private ServiziApplicativiCore saCore;
    private String pddName;
    private String nomeThread;
    private QueueReceiver receiver = null;
    private Queue queue = null;
    private QueueConnectionFactory qcf = null;
    private QueueConnection qc = null;
    private QueueSession qs = null;
    private DBManager dbm;
    private Connection con;
    private volatile boolean singlePdD = false;
    private PortaApplicativaSoap11Service portaApplicativaService;
    private PortaDelegataSoap11Service portaDelegataService;
    private ServizioApplicativoSoap11Service servizioApplicativoService;
    private SoggettoSoap11Service soggettoService;
    private PortaApplicativa portaApplicativaPort;
    private PortaDelegata portaDelegataPort;
    private ServizioApplicativo servizioApplicativoPort;
    private Soggetto soggettoPort;
    private ExceptionListenerJMS exceptionListenerJMS = new ExceptionListenerJMS();

    public boolean isRunning() {
        return this.isRunning;
    }

    public GestorePdDThread(String nomeCoda) throws OpenSPCoop2ConfigurationException {
        this.log = ControlStationLogger.getGestorePddLogger();
        this.pddName = nomeCoda;
        this.nomeThread = "GestorePDD[" + this.pddName + "]";
        this.consoleProperties = ConsoleProperties.getInstance();
        this.datasourceProperties = DatasourceProperties.getInstance();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void initGestore() throws Exception {
        if (!DBManager.isInitialized()) {
            this.log.info("Inizializzazione di " + this.getClass().getSimpleName() + " non riuscito perche' DBManager non INIZIALIZZATO");
            throw new Exception("Inizializzazione di " + this.getClass().getSimpleName() + "FALLITA");
        }
        String pddQueuePrefix = this.consoleProperties.getGestioneCentralizzataPrefissoNomeCodaConfigurazionePdd();
        boolean enginePDD = this.consoleProperties.isGestioneCentralizzataSincronizzazionePdd();
        this.singlePdD = this.consoleProperties.isSinglePdD();
        if (!enginePDD) {
            throw new GestoreNonAttivoException("Motore di sincronizzazione verso le Porte di Dominio non attivo.");
        }
        QueueManager queueMan = QueueManager.getInstance();
        if (queueMan == null) {
            this.log.debug("Impossibile avviare " + this.getClass().getSimpleName() + "QueueManager non inizializzato.");
            throw new Exception("Impossibile avviare " + this.getClass().getSimpleName() + "QueueManager non inizializzato.");
        }
        boolean trovato = false;
        int i = 0;
        this.log.debug("Inizializzazione Receiver [" + this.nomeThread + "] ...");
        while (!trovato && i < 600000) {
            try {
                this.queue = queueMan.getQueue(pddQueuePrefix + this.pddName);
                this.qcf = queueMan.getQueueConnectionFactory();
                this.qc = this.qcf.createQueueConnection();
                this.qc.setExceptionListener((ExceptionListener)this.exceptionListenerJMS);
                this.qs = this.qc.createQueueSession(true, -1);
                this.receiver = this.qs.createReceiver(this.queue);
                this.qc.start();
                this.log.debug("GestorePdD: Inizializzazione Receiver [" + this.nomeThread + "] effettuata.");
                trovato = true;
            }
            catch (Exception e) {
                i += 10000;
                Utilities.sleep((long)10000L);
                this.log.debug("Ritento Inizializzazione Receiver [" + this.nomeThread + "] ... causa: " + e.getMessage());
            }
        }
        if (!trovato) {
            this.log.error("Inizializzazione Receiver [" + this.nomeThread + "] non effettuata");
            throw new Exception("Inizializzazione Receiver [" + this.nomeThread + "] non effettuata");
        }
        try {
            this.pddCore = new PddCore();
            this.soggettiCore = new SoggettiCore(this.pddCore);
            this.paCore = new PorteApplicativeCore(this.pddCore);
            this.pdCore = new PorteDelegateCore(this.pddCore);
            this.saCore = new ServiziApplicativiCore(this.pddCore);
            this.log.debug("GestorePdD-" + this.pddName + ": Inizializzato Core. ");
        }
        catch (Exception e) {
            this.log.error("Riscontrato Errore durante l'inizializzazione di ControlStationCore.", (Throwable)e);
            this.log.info("GestorePdD-" + this.pddName + " non avviato.");
            throw new ControlStationCoreException("Riscontrato Errore durante l'inizializzazione di ControlStationCore.", e);
        }
        try {
            String ipPdd = null;
            String protocollo = null;
            int porta = 80;
            try {
                PdDControlStation pdd = this.pddCore.getPdDControlStation(this.pddName);
                ipPdd = pdd.getIpGestione();
                protocollo = pdd.getProtocolloGestione();
                porta = pdd.getPortaGestione();
                if (ipPdd == null || protocollo == null || porta <= 0) {
                    throw new Exception("Parametri Porta di Dominio non validi.");
                }
            }
            catch (Exception e) {
                this.log.error("Riscontrato errore durante la get dell'ip del pdd(" + this.pddName + "): " + e.toString(), (Throwable)e);
                throw new Exception("Riscontrato errore durante la get dell'ip del pdd(" + this.pddName + "): " + e.toString(), e);
            }
            String prefixUrl = protocollo + "://" + ipPdd + ":" + porta + "/";
            this.portaApplicativaService = new PortaApplicativaSoap11Service();
            this.portaDelegataService = new PortaDelegataSoap11Service();
            this.servizioApplicativoService = new ServizioApplicativoSoap11Service();
            this.soggettoService = new SoggettoSoap11Service();
            this.portaApplicativaPort = this.portaApplicativaService.getPortaApplicativaPortSoap11();
            this.portaDelegataPort = this.portaDelegataService.getPortaDelegataPortSoap11();
            this.servizioApplicativoPort = this.servizioApplicativoService.getServizioApplicativoPortSoap11();
            this.soggettoPort = this.soggettoService.getSoggettoPortSoap11();
            ((BindingProvider)this.portaApplicativaPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", prefixUrl + this.consoleProperties.getGestioneCentralizzataWSConfigurazioneEndpointSuffixPortaApplicativa());
            ((BindingProvider)this.portaDelegataPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", prefixUrl + this.consoleProperties.getGestioneCentralizzataWSConfigurazioneEndpointSuffixPortaDelegata());
            ((BindingProvider)this.servizioApplicativoPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", prefixUrl + this.consoleProperties.getGestioneCentralizzataWSConfigurazioneEndpointSuffixServizioApplicativo());
            ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", prefixUrl + this.consoleProperties.getGestioneCentralizzataWSConfigurazioneEndpointSuffixSoggetto());
            ((BindingProvider)this.portaApplicativaPort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.portaDelegataPort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.servizioApplicativoPort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.soggettoPort).getRequestContext().put("schema-validation-enabled", true);
            String username = this.consoleProperties.getGestioneCentralizzataWSConfigurazioneCredenzialiBasicUsername();
            String password = this.consoleProperties.getGestioneCentralizzataWSConfigurazioneCredenzialiBasicPassword();
            if (username != null && password != null) {
                ((BindingProvider)this.portaApplicativaPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.portaApplicativaPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.portaDelegataPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.portaDelegataPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.servizioApplicativoPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.servizioApplicativoPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
            }
            this.log.debug("GestorePdD-" + this.pddName + ": Inizializzato WebService. PortaApplicativa: " + this.portaApplicativaService.getClass().getSimpleName());
            this.log.debug("GestorePdD-" + this.pddName + ": Inizializzato WebService. PortaDelegata: " + this.portaDelegataService.getClass().getSimpleName());
            this.log.debug("GestorePdD-" + this.pddName + ": Inizializzato WebService. ServizioApplicativo: " + this.servizioApplicativoService.getClass().getSimpleName());
            this.log.debug("GestorePdD-" + this.pddName + ": Inizializzato WebService. Soggetto: " + this.soggettoService.getClass().getSimpleName());
        }
        catch (Exception e) {
            this.log.error("Riscontrato Errore durante la connessione al WebService.", (Throwable)e);
            this.log.info("GestorePdD-" + this.pddName + " non avviato.");
            throw new Exception("Riscontrato Errore durante la connessione al WebService.", e);
        }
    }

    @Override
    public void stopGestore() {
        this.stop = true;
    }

    @Override
    protected String getName() {
        return this.nomeThread;
    }
}

