/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.sql.Connection;
import javax.jms.ExceptionListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.xml.ws.BindingProvider;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.ws.client.accordocooperazione.all.AccordoCooperazione;
import org.openspcoop2.core.registry.ws.client.accordocooperazione.all.AccordoCooperazioneSoap11Service;
import org.openspcoop2.core.registry.ws.client.accordoserviziopartecomune.all.AccordoServizioParteComune;
import org.openspcoop2.core.registry.ws.client.accordoserviziopartecomune.all.AccordoServizioParteComuneSoap11Service;
import org.openspcoop2.core.registry.ws.client.accordoserviziopartespecifica.all.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ws.client.accordoserviziopartespecifica.all.AccordoServizioParteSpecificaSoap11Service;
import org.openspcoop2.core.registry.ws.client.portadominio.all.PortaDominioSoap11Service;
import org.openspcoop2.core.registry.ws.client.soggetto.all.Soggetto;
import org.openspcoop2.core.registry.ws.client.soggetto.all.SoggettoSoap11Service;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.jms.ExceptionListenerJMS;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.core.QueueManager;
import org.openspcoop2.web.ctrlstat.gestori.GestoreGeneral;
import org.openspcoop2.web.ctrlstat.gestori.GestoreNonAttivoException;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.slf4j.Logger;

public class GestoreRegistroThread
extends GestoreGeneral {
    private ConsoleProperties consoleProperties;
    private DatasourceProperties datasourceProperties;
    private String name = "GestoreRegistro";
    public volatile boolean stop = false;
    private volatile boolean isRunning = false;
    private SoggettiCore soggettiCore;
    private PddCore pddCore;
    private AccordiServizioParteComuneCore apcCore;
    private AccordiServizioParteSpecificaCore apsCore;
    private AccordiCooperazioneCore acCore;
    private QueueReceiver receiver = null;
    private Queue queue = null;
    private QueueConnectionFactory qcf = null;
    private QueueConnection qc = null;
    private QueueSession qs = null;
    private DBManager dbm;
    private Connection con;
    private AccordoCooperazioneSoap11Service accordoCooperazioneService;
    private AccordoServizioParteComuneSoap11Service accordoServizioParteComuneService;
    private AccordoServizioParteSpecificaSoap11Service accordoServizioParteSpecificaService;
    private SoggettoSoap11Service soggettoService;
    private PortaDominioSoap11Service pddService;
    private AccordoCooperazione accordoCooperazionePort;
    private AccordoServizioParteComune accordoServizioParteComunePort;
    private AccordoServizioParteSpecifica accordoServizioParteSpecificaPort;
    private Soggetto soggettoPort;
    private org.openspcoop2.core.registry.ws.client.portadominio.all.PortaDominio pddPort;
    private volatile boolean singlePdD = false;
    private Logger log;
    private ExceptionListenerJMS exceptionListenerJMS = new ExceptionListenerJMS();

    public boolean isRunning() {
        return this.isRunning;
    }

    public GestoreRegistroThread() throws OpenSPCoop2ConfigurationException {
        this.log = ControlStationLogger.getGestoreRegistroLogger();
        this.consoleProperties = ConsoleProperties.getInstance();
        this.datasourceProperties = DatasourceProperties.getInstance();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void initGestore() throws Exception {
        if (!DBManager.isInitialized()) {
            this.log.info("Inizializzazione di " + this.getClass().getSimpleName() + " non riuscito perche' DBManager non INIZIALIZZATO");
            throw new Exception("Inizializzazione di " + this.getClass().getSimpleName() + "FALLITA");
        }
        this.log.debug("Lettura dei parametri da console.properties");
        String registroServiziQueue = this.consoleProperties.getGestioneCentralizzataNomeCodaRegistroServizi();
        boolean engineRegistro = this.consoleProperties.isGestioneCentralizzataSincronizzazioneRegistro();
        this.singlePdD = this.consoleProperties.isSinglePdD();
        boolean trovato = false;
        if (!engineRegistro) {
            throw new GestoreNonAttivoException("Motore di sincronizzazione verso il Registro dei Servizi non attivo.");
        }
        QueueManager queueMan = QueueManager.getInstance();
        if (queueMan == null) {
            this.log.debug("Impossibile avviare " + this.getClass().getSimpleName() + "QueueManager non inizializzato.");
            throw new Exception("Impossibile avviare " + this.getClass().getSimpleName() + "QueueManager non inizializzato.");
        }
        trovato = false;
        int i = 0;
        this.log.debug("Inizializzazione Receiver ...");
        while (!trovato && i < 600000) {
            try {
                this.qcf = queueMan.getQueueConnectionFactory();
                this.queue = queueMan.getQueue(registroServiziQueue);
                this.qc = this.qcf.createQueueConnection();
                this.qc.setExceptionListener((ExceptionListener)this.exceptionListenerJMS);
                this.qs = this.qc.createQueueSession(true, -1);
                this.receiver = this.qs.createReceiver(this.queue);
                this.qc.start();
                this.log.debug("GestoreRegistro: Inizializzazione Receiver effettuata.");
                trovato = true;
            }
            catch (Exception e) {
                i += 10000;
                Utilities.sleep((long)10000L);
                this.log.debug("Ritento Inizializzazione Receiver ... causa: " + e.getMessage());
            }
        }
        if (!trovato) {
            this.log.error("Inizializzazione Receiver non effettuata");
            throw new Exception("Inizializzazione Receiver non effettuata");
        }
        try {
            this.accordoCooperazioneService = new AccordoCooperazioneSoap11Service();
            this.accordoServizioParteComuneService = new AccordoServizioParteComuneSoap11Service();
            this.accordoServizioParteSpecificaService = new AccordoServizioParteSpecificaSoap11Service();
            this.soggettoService = new SoggettoSoap11Service();
            this.pddService = new PortaDominioSoap11Service();
            this.accordoCooperazionePort = this.accordoCooperazioneService.getAccordoCooperazionePortSoap11();
            this.accordoServizioParteComunePort = this.accordoServizioParteComuneService.getAccordoServizioParteComunePortSoap11();
            this.accordoServizioParteSpecificaPort = this.accordoServizioParteSpecificaService.getAccordoServizioParteSpecificaPortSoap11();
            this.soggettoPort = this.soggettoService.getSoggettoPortSoap11();
            this.pddPort = this.pddService.getPortaDominioPortSoap11();
            ((BindingProvider)this.accordoCooperazionePort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.consoleProperties.getGestioneCentralizzataWSRegistroServiziEndpointAccordoCooperazione());
            ((BindingProvider)this.accordoServizioParteComunePort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.consoleProperties.getGestioneCentralizzataWSRegistroServiziEndpointAccordoServizioParteComune());
            ((BindingProvider)this.accordoServizioParteSpecificaPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.consoleProperties.getGestioneCentralizzataWSRegistroServiziEndpointAccordoServizioParteSpecifica());
            ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.consoleProperties.getGestioneCentralizzataWSRegistroServiziEndpointSoggetto());
            ((BindingProvider)this.pddPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", this.consoleProperties.getGestioneCentralizzataWSRegistroServiziEndpointPdd());
            ((BindingProvider)this.accordoCooperazionePort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.accordoServizioParteComunePort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.accordoServizioParteSpecificaPort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.soggettoPort).getRequestContext().put("schema-validation-enabled", true);
            ((BindingProvider)this.pddPort).getRequestContext().put("schema-validation-enabled", true);
            String username = this.consoleProperties.getGestioneCentralizzataWSRegistroServiziCredenzialiBasicUsername();
            String password = this.consoleProperties.getGestioneCentralizzataWSRegistroServiziCredenzialiBasicPassword();
            if (username != null && password != null) {
                ((BindingProvider)this.accordoCooperazionePort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.accordoCooperazionePort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.accordoServizioParteComunePort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.accordoServizioParteComunePort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.accordoServizioParteSpecificaPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.accordoServizioParteSpecificaPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.soggettoPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
                ((BindingProvider)this.pddPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
                ((BindingProvider)this.pddPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
            }
            this.log.debug("GestoreRegistro: Inizializzato WebService. AccordoCooperazione: " + this.accordoCooperazioneService.getClass().getSimpleName());
            this.log.debug("GestoreRegistro: Inizializzato WebService. AccordoServizioParteComune: " + this.accordoServizioParteComuneService.getClass().getSimpleName());
            this.log.debug("GestoreRegistro: Inizializzato WebService. AccordoServizioParteSpecifica: " + this.accordoServizioParteSpecificaService.getClass().getSimpleName());
            this.log.debug("GestoreRegistro: Inizializzato WebService. Soggetto: " + this.soggettoService.getClass().getSimpleName());
            this.log.debug("GestoreRegistro: Inizializzato WebService. PortaDominio: " + this.pddService.getClass().getSimpleName());
        }
        catch (Exception e) {
            this.log.error("Riscontrato Errore durante la connessione al WebService.", (Throwable)e);
            this.log.info("GestoreRegistro non avviato.");
            throw new Exception("Riscontrato Errore durante la connessione al WebService.", e);
        }
        try {
            this.soggettiCore = new SoggettiCore();
            this.pddCore = new PddCore(this.soggettiCore);
            this.apcCore = new AccordiServizioParteComuneCore(this.soggettiCore);
            this.apsCore = new AccordiServizioParteSpecificaCore(this.soggettiCore);
            this.acCore = new AccordiCooperazioneCore(this.soggettiCore);
            this.log.debug("GestoreRegistro: Inizializzato Core. ");
        }
        catch (Exception e) {
            this.log.error("Riscontrato Errore durante l'inizializzazione di ControlStationCore.", (Throwable)e);
            this.log.info("GestoreRegistro non avviato.");
            throw new ControlStationCoreException("Riscontrato Errore durante l'inizializzazione di ControlStationCore.", e);
        }
    }

    @Override
    public void stopGestore() {
        this.stop = true;
        this.log.debug("Fermo il thread ...");
        int timeout = 60;
        for (int i = 0; i < timeout && this.isRunning(); ++i) {
            Utilities.sleep((long)1000L);
        }
        if (this.isRunning) {
            this.log.debug("Sono trascorsi 60 secondi ed il thread non \u00e8 ancora terminato??");
        }
    }

    @Override
    protected String getName() {
        return this.name;
    }

    private void validazionePortaDominio(PortaDominio pdd) throws Exception {
        if (pdd.getNome() == null || "".equals(pdd.getNome())) {
            throw new Exception("Riscontrato errore: Nome Porta di dominio, non definito");
        }
    }
}

