/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.gestori.GestorePdDInitThread;
import org.openspcoop2.web.ctrlstat.gestori.GestoreRegistroThread;
import org.openspcoop2.web.ctrlstat.gestori.SmistatoreThread;
import org.slf4j.Logger;

public class GestoriStartupThread
implements Runnable {
    private Logger log = ControlStationLogger.getPddConsoleCoreLogger();
    private GestorePdDInitThread pddInit;
    private GestoreRegistroThread registro;
    private SmistatoreThread smistatore;

    @Override
    public void run() {
        try {
            new ControlStationCore();
            this.log.info("Inizializzazione Gestori....");
            this.pddInit = new GestorePdDInitThread();
            this.log.info("Avvio " + this.pddInit.getClass().getName());
            new Thread(this.pddInit).start();
            this.registro = new GestoreRegistroThread();
            this.log.info("Avvio " + this.registro.getClass().getName());
            new Thread(this.registro).start();
            this.smistatore = new SmistatoreThread();
            this.log.info("Avvio " + this.smistatore.getClass().getName());
            new Thread(this.smistatore).start();
            this.log.info("Inizializzazione Gestori effettuata con successo.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void stopGestori() {
        this.log.info("Terminazione Gestori in corso...");
        this.pddInit.stopGestore();
        this.registro.stopGestore();
        this.smistatore.stopGestore();
        this.log.info("Terminazione gestori effettuata con successo.");
    }
}

