/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.gestori;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.transport.jms.ExceptionListenerJMS;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.core.OperazioneDaSmistare;
import org.openspcoop2.web.ctrlstat.costanti.OperationsParameter;
import org.openspcoop2.web.ctrlstat.costanti.TipoOggettoDaSmistare;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.lib.queue.ClassQueue;
import org.openspcoop2.web.lib.queue.QueueOperation;
import org.openspcoop2.web.lib.queue.QueueParameter;
import org.openspcoop2.web.lib.queue.config.QueueProperties;
import org.openspcoop2.web.lib.queue.costanti.Operazione;
import org.openspcoop2.web.lib.queue.costanti.TipoOperazione;
import org.slf4j.Logger;

public class SmistatoreThread
extends Thread {
    private static Logger log = null;
    private volatile boolean stop = false;
    private volatile boolean isRunning = false;
    private DBManager dbm;
    private Connection con;
    private ExceptionListenerJMS exceptionListenerJMS = new ExceptionListenerJMS();
    private ConsoleProperties consoleProperties;
    private QueueProperties queueProperties;
    private DatasourceProperties datasourceProperties;

    public boolean isRunning() {
        return this.isRunning;
    }

    public SmistatoreThread() throws OpenSPCoop2ConfigurationException {
        log = ControlStationLogger.getSmistatoreLogger();
        this.dbm = DBManager.getInstance();
        this.consoleProperties = ConsoleProperties.getInstance();
        this.queueProperties = QueueProperties.getInstance();
        this.datasourceProperties = DatasourceProperties.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        if (!DBManager.isInitialized()) {
            log.info("Inizializzazione di " + this.getClass().getSimpleName() + " non riuscito perche' DBManager non INIZIALIZZATO");
            log.info(this.getClass().getName() + " Non AVVIATO!");
            return;
        }
        String jmsConnectionFactory = null;
        Properties jmsConnectionFactoryContext = null;
        String smistatoreQueue = null;
        String registroServiziQueue = null;
        String gestoreEventiQueue = null;
        String pddQueuePrefix = null;
        boolean enginePDD = false;
        boolean engineRegistro = false;
        boolean engineGestoreEventi = false;
        boolean singlePdD = true;
        String tipoDatabase = null;
        try {
            jmsConnectionFactory = this.queueProperties.getConnectionFactory();
            jmsConnectionFactoryContext = this.queueProperties.getConnectionFactoryContext();
            smistatoreQueue = this.consoleProperties.getGestioneCentralizzataNomeCodaSmistatore();
            registroServiziQueue = this.consoleProperties.getGestioneCentralizzataNomeCodaRegistroServizi();
            gestoreEventiQueue = this.consoleProperties.getGestioneCentralizzataNomeCodaGestoreEventi();
            pddQueuePrefix = this.consoleProperties.getGestioneCentralizzataPrefissoNomeCodaConfigurazionePdd();
            enginePDD = this.consoleProperties.isGestioneCentralizzataSincronizzazionePdd();
            engineRegistro = this.consoleProperties.isGestioneCentralizzataSincronizzazioneRegistro();
            engineGestoreEventi = this.consoleProperties.isGestioneCentralizzataSincronizzazioneGestoreEventi();
            singlePdD = this.consoleProperties.isSinglePdD();
            tipoDatabase = this.datasourceProperties.getTipoDatabase();
        }
        catch (Exception e) {
            log.info("Smistatore non avviato, sono stati rilevati errori durante la lettura delle configurazione: " + e.getMessage(), (Throwable)e);
            return;
        }
        if (singlePdD) {
            log.info("Smistatore non avviato: govwayConsole avviata in singlePdD mode.");
            return;
        }
        log.debug("Smistatore: Avvio Servizio di Gestione Operazioni, Registro[" + engineRegistro + "] Pdd[" + enginePDD + "] GestoreEventi[" + engineGestoreEventi + "]");
        QueueReceiver receiver = null;
        Queue queue = null;
        QueueConnectionFactory qcf = null;
        QueueConnection qc = null;
        QueueSession qs = null;
        boolean trovato = false;
        int i = 0;
        log.debug("Smistatore: Inizializzazione Receiver ...");
        while (!trovato && i < 600000) {
            try {
                InitialContext ctx = new InitialContext(jmsConnectionFactoryContext);
                queue = (Queue)ctx.lookup(smistatoreQueue);
                qcf = (QueueConnectionFactory)ctx.lookup(jmsConnectionFactory);
                qc = qcf.createQueueConnection();
                qc.setExceptionListener((ExceptionListener)this.exceptionListenerJMS);
                qs = qc.createQueueSession(true, -1);
                receiver = qs.createReceiver(queue);
                qc.start();
                ctx.close();
                log.debug("Smistatore: Inizializzazione Receiver effettuata.");
                trovato = true;
            }
            catch (Exception e) {
                i += 10000;
                Utilities.sleep((long)10000L);
            }
        }
        if (!trovato) {
            log.error("Smistatore: Inizializzazione Receiver non effettuata");
            return;
        }
        boolean riconnessioneConErrore = false;
        while (!this.stop) {
            try {
                if (riconnessioneConErrore) {
                    throw new JMSException("RiconnessioneJMS non riuscita...");
                }
                if (this.exceptionListenerJMS.isConnessioneCorrotta()) {
                    log.error("ExceptionJMSListener ha rilevato una connessione jms corrotta", (Throwable)this.exceptionListenerJMS.getException());
                    throw new JMSException("ExceptionJMSListener ha rilevato una connessione jms corrotta: " + this.exceptionListenerJMS.getException().getMessage());
                }
                log.info("Smistatore: Ricezione operazione...");
                ObjectMessage richiesta = null;
                while (!this.stop && (richiesta = (ObjectMessage)receiver.receive(10000L)) == null) {
                }
                if (this.stop) break;
                OperazioneDaSmistare operazione = null;
                try {
                    operazione = (OperazioneDaSmistare)richiesta.getObject();
                }
                catch (Exception e) {
                    log.error("Smistatore: Ricevuta richiesta con tipo errato:" + e.toString());
                    qs.commit();
                    try {
                        this.dbm.releaseConnection(this.con);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                String idOperazione = richiesta.getStringProperty("ID");
                log.info("\n--------------------------------------------\n\nSmistatore: Ricevuta richiesta di operazione con ID: " + idOperazione);
                log.debug("Smistatore: Dati operazione ricevuta idTab[" + operazione.getIDTable() + "] operazione[" + operazione.getOperazione() + "] pdd[" + operazione.getPdd() + "] oggetto[" + operazione.getOggetto() + "]");
                if (operazione.getOperazione() == null) {
                    log.error("Smistatore: Ricevuta richiesta con parametri scorretti.");
                    qs.commit();
                    continue;
                }
                if (!(Operazione.change.equals((Object)operazione.getOperazione()) || Operazione.add.equals((Object)operazione.getOperazione()) || Operazione.del.equals((Object)operazione.getOperazione()))) {
                    log.error("Smistatore: Operazione [" + operazione.getOperazione() + "] non supportata dal gestore");
                    qs.commit();
                    continue;
                }
                if (operazione.getOggetto() == null || operazione.getIDTable() < 0L) {
                    log.error("Smistatore: Ricevuta richiesta con parametri scorretti.");
                    qs.commit();
                    continue;
                }
                this.con = this.dbm.getConnection();
                Operazione operazioneTipologia = operazione.getOperazione();
                String su = operazione.getSuperuser();
                TipoOggettoDaSmistare tipoOggettoDaSmistare = operazione.getOggetto();
                String pdd = operazione.getPdd();
                QueueOperation queueOperation = new QueueOperation();
                queueOperation.setTipoOperazione(TipoOperazione.webService);
                queueOperation.setOperazione(operazioneTipologia);
                queueOperation.setSuperuser(su);
                this.con.setAutoCommit(false);
                ClassQueue cq = null;
                try {
                    cq = new ClassQueue(this.con, tipoDatabase, (Session)qs);
                }
                catch (Exception e) {
                    log.error("Smistatore: Inizializzazione ClassQueue non effettuata: " + e.getMessage());
                    qs.rollback();
                    try {
                        this.dbm.releaseConnection(this.con);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (tipoOggettoDaSmistare != null) {
                    long idTable = operazione.getIDTable();
                    String filter = "[" + operazione.getIDTable() + "]";
                    filter = filter + "[" + tipoOggettoDaSmistare.name() + "]";
                    filter = filter + "[" + operazione.getOperazione() + "]";
                    queueOperation.addParametro(new QueueParameter("Oggetto", tipoOggettoDaSmistare.name()));
                    queueOperation.addParametro(new QueueParameter("IDTable", "" + idTable));
                    Map<OperationsParameter, List<String>> params = operazione.getParameters();
                    if (params != null && !params.isEmpty()) {
                        for (OperationsParameter key : params.keySet()) {
                            List<String> values = params.get((Object)key);
                            for (String value : values) {
                                queueOperation.addParametro(new QueueParameter(key.getNome(), value));
                                filter = filter + "[" + value + "]";
                            }
                        }
                    }
                    if (tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.soggetto) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.servizio) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.ruolo) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.accordo) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.accordoCooperazione) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.pdd)) {
                        if (engineRegistro) {
                            QueueOperation queueOperationRegistro = (QueueOperation)queueOperation.clone();
                            queueOperationRegistro.setTipoOperazione(TipoOperazione.webService);
                            if (cq.insertQueue(registroServiziQueue, queueOperationRegistro, filter) == 0L) {
                                log.error("Smistatore: Si e' verificato un problema durante l'inserimento in coda.");
                                qs.rollback();
                                this.con.rollback();
                                this.dbm.releaseConnection(this.con);
                                continue;
                            }
                        } else {
                            log.info("Smistatore: sincronizzazione Registro Servizi non abilitata.");
                        }
                    }
                    if (pdd != null && !pdd.equals("") && !pdd.equals("-")) {
                        if (enginePDD) {
                            PddCore pddCore = new PddCore();
                            PdDControlStation myPdd = pddCore.getPdDControlStation(pdd);
                            String tipoPdd = myPdd.getTipo();
                            if (PddTipologia.OPERATIVO.toString().equals(tipoPdd)) {
                                QueueOperation queueOperationPdD = (QueueOperation)queueOperation.clone();
                                queueOperationPdD.setTipoOperazione(TipoOperazione.webService);
                                if (cq.insertQueue(pddQueuePrefix + pdd, queueOperationPdD, filter) == 0L) {
                                    log.error("Smistatore: Si e' verificato un problema durante l'inserimento in coda.");
                                    qs.rollback();
                                    this.con.rollback();
                                    this.dbm.releaseConnection(this.con);
                                    continue;
                                }
                            } else {
                                log.warn("Smistatore: Inserimento in coda non effettuato causa NAL [" + pdd + "] Tipo [" + tipoPdd + "] ");
                            }
                        } else {
                            log.info("Smistatore: sincronizzazione Nal non abilitata.");
                        }
                    }
                    if (gestoreEventiQueue != null && !gestoreEventiQueue.equals("") && (tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.soggetto) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.servizio) || tipoOggettoDaSmistare.equals((Object)TipoOggettoDaSmistare.mappingFruizionePD))) {
                        if (engineGestoreEventi) {
                            QueueOperation queueOperationGestoreEventi = (QueueOperation)queueOperation.clone();
                            queueOperationGestoreEventi.setTipoOperazione(TipoOperazione.webService);
                            if (cq.insertQueue(gestoreEventiQueue, queueOperationGestoreEventi, filter) == 0L) {
                                log.error("Smistatore: Si e' verificato un problema durante l'inserimento in coda.");
                                qs.rollback();
                                this.con.rollback();
                                this.dbm.releaseConnection(this.con);
                                continue;
                            }
                        } else {
                            log.info("Smistatore: sincronizzazione Gestore Eventi non abilitata.");
                        }
                    }
                }
                this.con.commit();
                this.con.setAutoCommit(true);
                this.dbm.releaseConnection(this.con);
                qs.commit();
                log.info("Smistatore: Operazione [" + idOperazione + "] completata.");
            }
            catch (JMSException e) {
                try {
                    qs.rollback();
                    this.con.rollback();
                    this.dbm.releaseConnection(this.con);
                }
                catch (Exception operazione) {
                    // empty catch block
                }
                log.error("Smistatore: Riscontrato erroreJMS durante la gestione di una richiesta: " + e.toString());
                try {
                    Utilities.sleep((long)5000L);
                    log.debug("Smistatore: Re-Inizializzazione Receiver ...");
                    try {
                        receiver.close();
                    }
                    catch (Exception operazione) {
                        // empty catch block
                    }
                    try {
                        qs.close();
                    }
                    catch (Exception operazione) {
                        // empty catch block
                    }
                    try {
                        qc.close();
                    }
                    catch (Exception operazione) {
                        // empty catch block
                    }
                    qc = qcf.createQueueConnection();
                    if (this.exceptionListenerJMS.isConnessioneCorrotta()) {
                        this.exceptionListenerJMS.setConnessioneCorrotta(false);
                        this.exceptionListenerJMS.setException(null);
                    }
                    qc.setExceptionListener((ExceptionListener)this.exceptionListenerJMS);
                    qs = qc.createQueueSession(true, -1);
                    receiver = qs.createReceiver(queue);
                    qc.start();
                    log.debug("Smistatore: Re-Inizializzazione Receiver effettuata.");
                    riconnessioneConErrore = false;
                }
                catch (Exception er) {
                    log.error("Smistatore: Re-Inizializzazione Receiver non effettuata:" + er.toString());
                    riconnessioneConErrore = true;
                }
            }
            catch (Exception e) {
                try {
                    qs.rollback();
                    this.con.rollback();
                    this.dbm.releaseConnection(this.con);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.error("Smistatore: Riscontrato errore durante la gestione di una richiesta: " + e.toString(), (Throwable)e);
            }
            finally {
                try {
                    this.dbm.releaseConnection(this.con);
                }
                catch (Exception e) {}
            }
        }
        try {
            if (receiver != null) {
                receiver.close();
            }
            if (qs != null) {
                qs.rollback();
                qs.close();
            }
            if (qc != null) {
                qc.stop();
                qc.close();
            }
        }
        catch (Exception e) {
            try {
                log.error("Smistatore: Riscontrato errore durante la chiusura del Thread: " + e.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isRunning = false;
        log.debug("Thread terminato");
    }

    public void stopGestore() {
        this.stop = true;
        log.debug("Fermo il thread ...");
        int timeout = 60;
        for (int i = 0; i < timeout && this.isRunning(); ++i) {
            Utilities.sleep((long)1000L);
        }
        if (this.isRunning) {
            log.debug("Sono trascorsi 60 secondi ed il thread non \u00e8 ancora terminato??");
        }
    }
}

