/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.plugins;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettoreItem;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedException;

public class ExtendedConnettoreConverter {
    public static void readExtendedInfoFromConnettore(List<ExtendedConnettore> list, Connettore connettore) throws ExtendedException {
        Properties properties = new Properties();
        if (connettore != null) {
            for (org.openspcoop2.core.config.Property property : connettore.getPropertyList()) {
                if (!property.getNome().startsWith("-#ext#-")) continue;
                properties.put(property.getNome().substring("-#ext#-".length()), property.getValore());
            }
        }
        if (properties.size() > 0) {
            ExtendedConnettoreConverter.readExtendedInfoFromConnettore(list, properties);
        }
    }

    public static void fillExtendedInfoIntoConnettore(List<ExtendedConnettore> list, Connettore connettore) throws ExtendedException {
        if (list != null && list.size() > 0) {
            ArrayList<String> pDaEliminare = new ArrayList<String>();
            for (org.openspcoop2.core.config.Property property : connettore.getPropertyList()) {
                if (!property.getNome().startsWith("-#ext#-")) continue;
                pDaEliminare.add(property.getNome());
            }
            while (pDaEliminare.size() > 0) {
                int i;
                String pNameDaEliminare = (String)pDaEliminare.remove(0);
                boolean found = false;
                for (i = 0; i < connettore.sizePropertyList(); ++i) {
                    if (!connettore.getProperty(i).getNome().equals(pNameDaEliminare)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                connettore.removeProperty(i);
            }
            Properties properties = ExtendedConnettoreConverter.toProperties(list);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                if (("-#ext#-" + key).length() > 255) {
                    throw new ExtendedException("Property [" + key + "] troppo lunga (max-length:" + (255 - "-#ext#-".length()) + ")");
                }
                org.openspcoop2.core.config.Property property = new org.openspcoop2.core.config.Property();
                property.setNome("-#ext#-" + key);
                property.setValore(value);
                connettore.addProperty(property);
            }
        }
    }

    public static void readExtendedInfoFromConnettore(List<ExtendedConnettore> list, org.openspcoop2.core.registry.Connettore connettore) throws ExtendedException {
        Properties properties = new Properties();
        if (connettore != null) {
            for (Property property : connettore.getPropertyList()) {
                if (!property.getNome().startsWith("-#ext#-")) continue;
                properties.put(property.getNome().substring("-#ext#-".length()), property.getValore());
            }
        }
        if (properties.size() > 0) {
            ExtendedConnettoreConverter.readExtendedInfoFromConnettore(list, properties);
        }
    }

    public static void fillExtendedInfoIntoConnettore(List<ExtendedConnettore> list, org.openspcoop2.core.registry.Connettore connettore) throws ExtendedException {
        if (list != null && list.size() > 0) {
            ArrayList<String> pDaEliminare = new ArrayList<String>();
            for (Property property : connettore.getPropertyList()) {
                if (!property.getNome().startsWith("-#ext#-")) continue;
                pDaEliminare.add(property.getNome());
            }
            while (pDaEliminare.size() > 0) {
                int i;
                String pNameDaEliminare = (String)pDaEliminare.remove(0);
                boolean found = false;
                for (i = 0; i < connettore.sizePropertyList(); ++i) {
                    if (!connettore.getProperty(i).getNome().equals(pNameDaEliminare)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                connettore.removeProperty(i);
            }
            Properties properties = ExtendedConnettoreConverter.toProperties(list);
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                if (("-#ext#-" + key).length() > 255) {
                    throw new ExtendedException("Property [" + key + "] troppo lunga (max-length:" + (255 - "-#ext#-".length()) + ")");
                }
                Property property = new Property();
                property.setNome("-#ext#-" + key);
                property.setValore(value);
                connettore.addProperty(property);
            }
        }
    }

    public static String buildId(String idExtended, String idExtendedItem) {
        return idExtended + "_" + idExtendedItem;
    }

    private static void readExtendedInfoFromConnettore(List<ExtendedConnettore> list, Properties properties) throws ExtendedException {
        try {
            if (list != null) {
                for (ExtendedConnettore extendedConnettore : list) {
                    if (!properties.containsKey(extendedConnettore.getId())) continue;
                    String v = properties.getProperty(extendedConnettore.getId());
                    extendedConnettore.setEnabled("true".equals(v));
                    if (!extendedConnettore.isEnabled() || extendedConnettore.getListItem() == null || extendedConnettore.getListItem().size() <= 0) continue;
                    for (ExtendedConnettoreItem extendedConnettoreItem : extendedConnettore.getListItem()) {
                        String id = ExtendedConnettoreConverter.buildId(extendedConnettore.getId(), extendedConnettoreItem.getId());
                        if (!properties.containsKey(id)) continue;
                        String vProperty = properties.getProperty(id);
                        extendedConnettoreItem.setValue(vProperty);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e.getMessage(), e);
        }
    }

    private static Properties toProperties(List<ExtendedConnettore> list) throws ExtendedException {
        try {
            Properties properties = new Properties();
            if (list != null) {
                for (ExtendedConnettore extendedConnettore : list) {
                    properties.put(extendedConnettore.getId(), "" + extendedConnettore.isEnabled());
                    if (!extendedConnettore.isEnabled() || extendedConnettore.getListItem() == null || extendedConnettore.getListItem().size() <= 0) continue;
                    for (ExtendedConnettoreItem extendedConnettoreItem : extendedConnettore.getListItem()) {
                        String v = extendedConnettoreItem.getValue();
                        if (v == null || "".equals(v)) continue;
                        properties.put(ExtendedConnettoreConverter.buildId(extendedConnettore.getId(), extendedConnettoreItem.getId()), extendedConnettoreItem.getValue());
                    }
                }
            }
            return properties;
        }
        catch (Exception e) {
            throw new ExtendedException(e.getMessage(), e);
        }
    }
}

