/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCostanti;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteSpecificaAllegatiView
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
            String idAllegato = apsHelper.getParameter("idAllegato");
            String idServizio = apsHelper.getParameter("id");
            String nomeDocumento = apsHelper.getParameter("nomeDoc");
            long idAllegatoLong = Long.parseLong(idAllegato);
            long idServizioLong = Long.parseLong(idServizio);
            String modificaAPI = apsHelper.getParameter("modificaAPI");
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            ArchiviCore archiviCore = new ArchiviCore(apsCore);
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            if (tipologia != null && "fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            }
            apsHelper.makeMenu();
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idServizioLong);
            String tipoSoggettoFruitore = null;
            String nomeSoggettoFruitore = null;
            IDSoggetto idSoggettoFruitore = null;
            if (gestioneFruitori) {
                tipoSoggettoFruitore = apsHelper.getParameter("tipoSoggFru");
                nomeSoggettoFruitore = apsHelper.getParameter("nomeSoggFru");
                idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
            }
            String tipoProtocollo = apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
            String tmpTitle = apsHelper.getLabelServizio(idSoggettoFruitore, gestioneFruitori, asps, tipoProtocollo);
            Documento doc = archiviCore.getDocumento(idAllegatoLong, true);
            StringBuilder contenutoAllegato = new StringBuilder();
            String errore = Utilities.getTestoVisualizzabile(doc.getByteContenuto(), contenutoAllegato);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)session, (HttpServletRequest)request).getValue();
            if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
                }
                ArrayList<Parameter> listErogazioniChange = new ArrayList<Parameter>();
                Parameter pIdServizio = new Parameter("id", "" + asps.getId());
                Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
                Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
                listErogazioniChange.add(pIdServizio);
                listErogazioniChange.add(pNomeServizio);
                listErogazioniChange.add(pTipoServizio);
                if (gestioneFruitori) {
                    Parameter pNomeSoggettoFruitore = new Parameter("nomeSoggFru", nomeSoggettoFruitore);
                    Parameter pTipoSoggettoFruitore = new Parameter("tipoSoggFru", tipoSoggettoFruitore);
                    listErogazioniChange.add(pNomeSoggettoFruitore);
                    listErogazioniChange.add(pTipoSoggettoFruitore);
                }
                if (modificaAPI != null) {
                    Parameter pModificaAPI = new Parameter("modificaAPI", modificaAPI);
                    listErogazioniChange.add(pModificaAPI);
                }
                lstParam.add(new Parameter(tmpTitle, "aspsErogazioniChange.do", listErogazioniChange.toArray(new Parameter[1])));
                lstParam.add(new Parameter("Informazioni Generali", "accordiServizioParteSpecificaChange.do", listErogazioniChange.toArray(new Parameter[1])));
                lstParam.add(new Parameter("Allegati", "accordiServizioParteSpecificaAllegatiList.do", listErogazioniChange.toArray(new Parameter[1])));
            } else {
                if (gestioneFruitori) {
                    lstParam.add(new Parameter("Fruizioni", "accordiServizioParteSpecificaList.do"));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                }
                lstParam.add(new Parameter("Allegati di " + tmpTitle, "accordiServizioParteSpecificaAllegatiList.do", new Parameter[]{new Parameter("id", idServizio)}));
            }
            lstParam.add(new Parameter(nomeDocumento, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati = apsHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, idServizio, null, null, null, null, tipoSoggettoFruitore, nomeSoggettoFruitore, dati);
            dati = apsHelper.addViewAllegatiToDati(TipoOperazione.OTHER, idAllegato, idServizio, doc, contenutoAllegato, errore, dati, modificaAPI);
            pd.setMode("view-noeditbutton");
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_VIEW);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteSpecificaAllegati", (ForwardParams)AccordiServizioParteSpecificaCostanti.TIPO_OPERAZIONE_VIEW);
        }
    }
}

