/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortType;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.DBMappingUtils;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaServizi;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.registro.GestoreRegistroServiziRemoto;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class AccordiServizioParteSpecificaCore
extends ControlStationCore {
    public AccordiServizioParteSpecificaCore() throws DriverControlStationException {
    }

    public AccordiServizioParteSpecificaCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public boolean isConnettoreStatic(String protocollo) throws ProtocolException {
        return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolVersionManager(null).isStaticRoute();
    }

    public boolean isSupportatoVersionamentoAccordiServizioParteSpecifica(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoVersionamentoAccordiServizioParteSpecifica";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoVersionamentoAccordiParteSpecifica();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public List<String> getTipiServiziGestitiProtocollo(String protocollo, ServiceBinding serviceBinding) throws DriverRegistroServiziException {
        String nomeMetodo = "getTipiServiziGestitiProtocollo";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().getTipiServizi(serviceBinding);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getTipoServizioDefaultProtocollo(String protocollo, ServiceBinding serviceBinding) throws DriverRegistroServiziException {
        String getTipoServizioDefault = "getTipoServizioDefaultProtocollo";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().getTipoServizioDefault(serviceBinding);
        }
        catch (Exception e) {
            String error = this.getPrefixError(getTipoServizioDefault, e);
            ControlStationCore.logError(error, e);
            throw new DriverRegistroServiziException(error, (Throwable)e);
        }
    }

    public String getProtocolloAssociatoTipoServizio(String tipoServizio) throws DriverRegistroServiziException {
        String nomeMetodo = "getProtocolloAssociatoTipoServizio";
        try {
            return this.protocolFactoryManager.getProtocolByServiceType(tipoServizio);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public void controlloUnicitaImplementazioneAccordoPerSoggetto(String portType, IDSoggetto idSoggettoErogatore, long idSoggettoErogatoreLong, IDAccordo idAccordoServizioParteComune, long idAccordoServizioParteComuneLong, IDServizio idAccordoServizioParteSpecifica, long idAccordoServizioParteSpecificaLong, TipoOperazione tipoOperazione, boolean servizioCorrelato) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "controlloUnicitaImplementazioneAccordoPerSoggetto";
        try {
            con = ControlStationCore.dbM.getConnection();
            DriverRegistroServiziDB driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            driver.controlloUnicitaImplementazioneAccordoPerSoggetto(portType, idSoggettoErogatore, idSoggettoErogatoreLong, idAccordoServizioParteComune, idAccordoServizioParteComuneLong, idAccordoServizioParteSpecifica, idAccordoServizioParteSpecificaLong, TipoOperazione.CHANGE.equals((Object)tipoOperazione), servizioCorrelato, this.isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto(), this.isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto());
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
        String tmpServCorr = CostantiRegistroServizi.DISABILITATO.toString();
        if (servizioCorrelato) {
            tmpServCorr = CostantiRegistroServizi.ABILITATO.toString();
        }
        String s = "servizio";
        if (servizioCorrelato) {
            s = "servizio correlato";
        }
        if (portType == null || "-".equals(portType)) {
            if (this.isAbilitatoControlloUnicitaImplementazioneAccordoPerSoggetto()) {
                long idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorr(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, tmpServCorr);
                boolean addError = tipoOperazione.equals((Object)TipoOperazione.ADD) && idAccordoServizioParteSpecificaAlreadyExists > 0L;
                boolean changeError = false;
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && idAccordoServizioParteSpecificaAlreadyExists > 0L) {
                    boolean bl = changeError = idAccordoServizioParteSpecificaLong != idAccordoServizioParteSpecificaAlreadyExists;
                }
                if (addError || changeError) {
                    throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa l'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
                }
            }
        } else if (this.isAbilitatoControlloUnicitaImplementazionePortTypePerSoggetto()) {
            long idAccordoServizioParteSpecificaAlreadyExists = this.getServizioWithSoggettoAccordoServCorrPt(idSoggettoErogatoreLong, idAccordoServizioParteComuneLong, tmpServCorr, portType);
            boolean addError = tipoOperazione.equals((Object)TipoOperazione.ADD) && idAccordoServizioParteSpecificaAlreadyExists > 0L;
            boolean changeError = false;
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && idAccordoServizioParteSpecificaAlreadyExists > 0L) {
                boolean bl = changeError = idAccordoServizioParteSpecificaLong != idAccordoServizioParteSpecificaAlreadyExists;
            }
            if (addError || changeError) {
                throw new DriverRegistroServiziException("Esiste gi&agrave; un " + s + " del Soggetto " + idSoggettoErogatore + " che implementa il servizio " + portType + " dell'accordo selezionato [" + IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordoServizioParteComune) + "]");
            }
        }
    }

    public long getIdAccordoServizioParteSpecifica(IDServizio idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoServizioParteSpecifica(id)";
        try {
            con = ControlStationCore.dbM.getConnection();
            long l = DBUtils.getIdServizio((String)idAccordo.getNome(), (String)idAccordo.getTipo(), (Integer)idAccordo.getVersione(), (String)idAccordo.getSoggettoErogatore().getNome(), (String)idAccordo.getSoggettoErogatore().getTipo(), (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getIdAccordoServizioParteSpecifica(Connection con, IDServizio idAccordo) throws DriverRegistroServiziException {
        String nomeMetodo = "getIdAccordoServizioParteSpecifica(con,id)";
        try {
            return DBUtils.getIdServizio((String)idAccordo.getNome(), (String)idAccordo.getTipo(), (Integer)idAccordo.getVersione(), (String)idAccordo.getSoggettoErogatore().getNome(), (String)idAccordo.getSoggettoErogatore().getTipo(), (Connection)con, (String)this.tipoDB);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public long getIdFruizioneAccordoServizioParteSpecifica(IDSoggetto idFruitore, IDServizio idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdFruizioneAccordoServizioParteSpecifica";
        try {
            con = ControlStationCore.dbM.getConnection();
            long l = DBUtils.getIdFruizioneServizio((IDServizio)idAccordo, (IDSoggetto)idFruitore, (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteComune> findAccordiParteComuneBySoggettoAndNome(String nomeAccordoParteComune, IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "findAccordiParteComuneBySoggettoAndNome(" + nomeAccordoParteComune + ", " + idSoggetto.toString() + ")";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Object driverRegistro = null;
            driverRegistro = this.isRegistroServiziLocale() ? driver.getDriverRegistroServiziDB() : GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log);
            FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
            filtroRicerca.setNomeAccordo(nomeAccordoParteComune);
            filtroRicerca.setTipoSoggettoReferente(idSoggetto.getTipo());
            filtroRicerca.setNomeSoggettoReferente(idSoggetto.getNome());
            List idAccordi = null;
            ArrayList<AccordoServizioParteComune> accordi = new ArrayList<AccordoServizioParteComune>();
            try {
                idAccordi = driverRegistro.getAllIdAccordiServizioParteComune(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            if (idAccordi != null && !idAccordi.isEmpty()) {
                for (IDAccordo idAccordo : idAccordi) {
                    accordi.add(driverRegistro.getAccordoServizioParteComune(idAccordo));
                }
            }
            ArrayList<AccordoServizioParteComune> arrayList = accordi;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteSpecifica> serviziByAccordoFilterList(IDAccordo idAccordo) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziByAccordoFilterList(" + idAccordo + ")";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            DriverRegistroServiziDB driverRegistro = driver.getDriverRegistroServiziDB();
            FiltroRicercaServizi filtroRicerca = new FiltroRicercaServizi();
            filtroRicerca.setIdAccordoServizioParteComune(idAccordo);
            List idServizi = null;
            try {
                idServizi = driverRegistro.getAllIdServizi(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                // empty catch block
            }
            ArrayList<AccordoServizioParteSpecifica> lista = new ArrayList<AccordoServizioParteSpecifica>();
            if (idServizi != null && !idServizi.isEmpty()) {
                for (int i = 0; i < idServizi.size(); ++i) {
                    lista.add(driverRegistro.getAccordoServizioParteSpecifica((IDServizio)idServizi.get(i)));
                }
            }
            ArrayList<AccordoServizioParteSpecifica> arrayList = lista;
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isAccordoServizioParteSpecificaInUso(AccordoServizioParteSpecifica as, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, List<IDPortaDelegata> nomePDGenerateAutomaticamente, List<IDPortaApplicativa> nomePAGenerateAutomaticamente, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isAccordoServizioPArteSpecificaInUso";
        try {
            con = ControlStationCore.dbM.getConnection();
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(as);
            boolean bl = DBOggettiInUsoUtils.isAccordoServizioParteSpecificaInUso((Connection)con, (String)this.tipoDB, (IDServizio)idServizio, whereIsInUso, nomePDGenerateAutomaticamente, nomePAGenerateAutomaticamente, (boolean)normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void validaStatoAccordoServizioParteSpecifica(AccordoServizioParteSpecifica serv, boolean gestioneWsdlImplementativo, boolean checkConnettore) throws DriverRegistroServiziException, ValidazioneStatoPackageException {
        Connection con = null;
        String nomeMetodo = "validaStatoAccordoServizioParteSpecifica";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            driver.validaStatoAccordoServizioParteSpecifica(serv, gestioneWsdlImplementativo, checkConnettore);
        }
        catch (ValidazioneStatoPackageException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] ValidazioneStatoPackageException :" + e.getMessage(), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void validaStatoFruitoreAccordoServizioParteSpecifica(Fruitore fruitore, AccordoServizioParteSpecifica serv) throws DriverRegistroServiziException, ValidazioneStatoPackageException {
        Connection con = null;
        String nomeMetodo = "validaStatoFruitoreAccordoServizioParteSpecifica";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            driver.validaStatoFruitoreServizio(fruitore, serv);
        }
        catch (ValidazioneStatoPackageException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] validaStatoFruitoreAccordoServizioParteSpecifica :" + e.getMessage(), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IDServizio> getAllIdServizi(FiltroRicercaServizi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAllIdServizi";
        DriverControlStationDB driver = null;
        try {
            if (this.isRegistroServiziLocale()) {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                List list = driver.getDriverRegistroServiziDB().getAllIdServizi(filtroRicerca);
                ControlStationCore.dbM.releaseConnection(con);
                return list;
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
                throw de;
                catch (Exception e) {
                    ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                    throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ControlStationCore.dbM.releaseConnection(con);
                throw throwable;
            }
        }
        {
            List list = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getAllIdServizi(filtroRicerca);
            ControlStationCore.dbM.releaseConnection(con);
            return list;
        }
    }

    public List<AccordoServizioParteSpecifica> servizioWithSoggettoFruitore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "servizioWithSoggettoFruitore";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.servizioWithSoggettoFruitore(idSoggetto);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteSpecifica> serviziWithIdAccordoList(long idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "serviziWithIdAccordoList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().serviziWithIdAccordoList(idAccordo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Fruitore> getSoggettiWithServizioNotFruitori(long idServizio, boolean escludiSoggettiEsterni, CredenzialeTipo credenzialeTipo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getSoggettiWithServizioNotFruitori";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getSoggettiWithServizioNotFruitori(idServizio, escludiSoggettiEsterni, credenzialeTipo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Fruitore getErogatoreFruitore(long id) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getErogatoreFruitore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Fruitore fruitore = driver.getDriverRegistroServiziDB().getErogatoreFruitore(id);
            return fruitore;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getServizioWithSoggettoAccordoServCorr(long idSoggetto, long idAccordo, String servizioCorrelato) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioWithSoggettoAccordoServCorr";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverRegistroServiziDB().getServizioWithSoggettoAccordoServCorr(idSoggetto, idAccordo, servizioCorrelato);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getServizioWithSoggettoAccordoServCorrPt(long idSoggetto, long idAccordo, String servizioCorrelato, String portType) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioWithSoggettoAccordoServCorrPt";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverRegistroServiziDB().getServizioWithSoggettoAccordoServCorrPt(idSoggetto, idAccordo, servizioCorrelato, portType);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Fruitore getServizioFruitore(long idServFru) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioFruitore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Fruitore fruitore = driver.getDriverRegistroServiziDB().getServizioFruitore(idServFru);
            return fruitore;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getServizioFruitore(IDServizio idServizio, long idSogg) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioFruitore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverRegistroServiziDB().getServizioFruitore(idServizio, idSogg);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getServizioFruitoreSoggettoFruitoreID(long idServFru) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioFruitoreSoggettoFruitoreID";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverRegistroServiziDB().getServizioFruitoreSoggettoFruitoreID(idServFru);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getServizioFruitoreServizioID(long idServFru) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioFruitoreServizioID";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.getDriverRegistroServiziDB().getServizioFruitoreServizioID(idServFru);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsServizio(long idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsAccordoServizioParteSpecifica(idServizio);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsServizio(IDServizio idSE) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsAccordoServizioParteSpecifica(idSE);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsAccordoServizioParteSpecifica(IDServizio idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsAccordoServizioParteSpecifica";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsAccordoServizioParteSpecifica(idAccordo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccordoServizioParteSpecifica getServizio(IDServizio idService) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizio";
        DriverControlStationDB driver = null;
        try {
            if (this.isRegistroServiziLocale()) {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idService);
                ControlStationCore.dbM.releaseConnection(con);
                return accordoServizioParteSpecifica;
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
                throw de;
                catch (Exception e) {
                    ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                    throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ControlStationCore.dbM.releaseConnection(con);
                throw throwable;
            }
        }
        {
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getAccordoServizioParteSpecifica(idService);
            ControlStationCore.dbM.releaseConnection(con);
            return accordoServizioParteSpecifica;
        }
    }

    public AccordoServizioParteSpecifica getServizio(IDServizio idService, boolean deepRead) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idService, deepRead);
            return accordoServizioParteSpecifica;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoServizioParteSpecifica getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServizioCorrelato";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica_ServizioCorrelato(idSoggetto, idAccordo);
            return accordoServizioParteSpecifica;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(String superuser, ISearch ricerca, boolean[] permessiUtente, HttpSession session, HttpServletRequest request) throws DriverRegistroServiziException {
        boolean gestioneFruitori = false;
        boolean gestioneErogatori = false;
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
        if (tipologia != null) {
            if ("fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            } else if ("erogazione".equals(tipologia)) {
                gestioneErogatori = true;
            }
        }
        return this.soggettiServizioList(superuser, ricerca, permessiUtente, gestioneFruitori, gestioneErogatori);
    }

    public List<AccordoServizioParteSpecifica> soggettiServizioList(String superuser, ISearch ricerca, boolean[] permessiUtente, boolean gestioneFruitori, boolean gestioneErogatori) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "soggettiServizioList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().soggettiServizioList(superuser, ricerca, permessiUtente, gestioneFruitori, gestioneErogatori);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizio> getIdServiziWithPortType(IDPortType idPT) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getIdServiziWithPortType";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getIdServiziWithPortType(idPT);
            return list;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizio> getIdServiziWithAccordo(IDAccordo idAccordo, boolean checkPTisNull) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getIdServiziWithAccordo";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getIdServiziWithAccordo(idAccordo, checkPTisNull);
            return list;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteSpecifica> serviziList(ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "serviziList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().serviziList(null, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteSpecifica> serviziList(String superUser, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "serviziList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().serviziList(superUser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long existServizio(String nomeServizio, String tipoServizio, int versioneServizio, long idSoggettoErogatore) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "existServizio(nome,tipo,versione,idErogatore)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            long l = driver.existServizio(nomeServizio, tipoServizio, versioneServizio, idSoggettoErogatore);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ValidazioneResult validazione(AccordoServizioParteSpecifica as, SoggettiCore soggettiCore) throws DriverRegistroServiziException {
        String nomeMetodo = "validazione";
        try {
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getTipoSoggettoErogatore());
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneAccordi().valida(as);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public ValidazioneResult validaInterfacciaWsdlParteSpecifica(AccordoServizioParteSpecifica as, AccordoServizioParteComune apc, SoggettiCore soggettiCore) throws DriverRegistroServiziException {
        String nomeMetodo = "validaInterfacciaWsdlParteSpecifica";
        try {
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getTipoSoggettoErogatore());
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneDocumenti().validaSpecificaInterfaccia(as, apc);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public ValidazioneResult validaInterfacciaWsdlParteSpecifica(Fruitore fruitore, AccordoServizioParteSpecifica as, AccordoServizioParteComune apc, SoggettiCore soggettiCore) throws DriverRegistroServiziException {
        String nomeMetodo = "validaInterfacciaWsdlParteSpecifica_Fruitore";
        try {
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(as.getTipoSoggettoErogatore());
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneDocumenti().validaSpecificaInterfaccia(fruitore, as, apc);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public long getIdAccordoServizioParteSpecifica(String nomeServizio, String tipoServizio, Integer versioneServizio, String nomeProprietario, String tipoProprietario) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoServizioParteSpecifica";
        long idServizio = -1L;
        try {
            con = ControlStationCore.dbM.getConnection();
            idServizio = DBUtils.getIdServizio((String)nomeServizio, (String)tipoServizio, (Integer)versioneServizio, (String)nomeProprietario, (String)tipoProprietario, (Connection)con, (String)this.tipoDB);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
        return idServizio;
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioParteSpecifica";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idServizio);
            return accordoServizioParteSpecifica;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(IDServizio idServizio) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioParteSpecifica(IDServizio)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idServizio);
            return accordoServizioParteSpecifica;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaApplicativa> serviziPorteAppList(String tipoServizio, String nomeServizio, Integer versioneServizio, long idServizio, long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "serviziPorteAppList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().serviziPorteAppList(tipoServizio, nomeServizio, versioneServizio, idServizio, idSoggettoErogatore, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingErogazionePortaApplicativa> mappingServiziPorteAppList(IDServizio idAccordoServizioParteSpecifica, ISearch ricerca) throws DriverConfigurazioneException, DriverRegistroServiziException {
        return this.mappingServiziPorteAppListEngine(idAccordoServizioParteSpecifica, this.getIdAccordoServizioParteSpecifica(idAccordoServizioParteSpecifica), ricerca);
    }

    public List<MappingErogazionePortaApplicativa> mappingServiziPorteAppList(IDServizio idAccordoServizioParteSpecifica, Long idServizio, ISearch ricerca) throws DriverConfigurazioneException {
        return this.mappingServiziPorteAppListEngine(idAccordoServizioParteSpecifica, idServizio, ricerca);
    }

    private List<MappingErogazionePortaApplicativa> mappingServiziPorteAppListEngine(IDServizio idAccordoServizioParteSpecifica, Long idServizio, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "mappingServiziPorteAppList";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean orderByDescrizione = true;
            boolean ricercaUseOffsetLimit = false;
            List list = DBMappingUtils.mappingErogazionePortaApplicativaList((Connection)con, (String)this.tipoDB, (IDServizio)idAccordoServizioParteSpecifica, (long)idServizio, (ISearch)ricerca, (boolean)ricercaUseOffsetLimit, (boolean)orderByDescrizione);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void deleteMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativaByNome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "deleteMappingErogazione";
        try {
            con = ControlStationCore.dbM.getConnection();
            DBMappingUtils.deleteMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativaByNome, (Connection)con, (String)this.tipoDB);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isDefaultMappingErogazione(IDServizio idServizio, IDPortaApplicativa idPortaApplicativaByNome) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isDefaultMappingErogazione";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean bl = DBMappingUtils.checkMappingErogazione((IDServizio)idServizio, (IDPortaApplicativa)idPortaApplicativaByNome, (boolean)true, (Connection)con, (String)this.tipoDB);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoServizioParteSpecifica getAccordoServizioParteSpecifica(long idServizio, boolean readContenutoAllegati) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getAccordoServizioParteSpecifica";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoServizioParteSpecifica accordoServizioParteSpecifica = driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idServizio, readContenutoAllegati);
            return accordoServizioParteSpecifica;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Fruitore> serviziFruitoriList(long idServizi, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "serviziFruitoriList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().serviziFruitoriList(idServizi, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Fruitore> serviziFruitoriList(Connection con, long idServizi, ISearch ricerca) throws DriverRegistroServiziException {
        String nomeMetodo = "serviziFruitoriList";
        DriverControlStationDB driver = null;
        try {
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            return driver.getDriverRegistroServiziDB().serviziFruitoriList(idServizi, ricerca);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public IDServizio getIdAccordoServizioParteSpecifica(long idAccordo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoServizioParteSpecifica";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDServizio iDServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(driver.getDriverRegistroServiziDB().getAccordoServizioParteSpecifica(idAccordo, con));
            return iDServizio;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Fruitore> getServiziFruitoriWithServizio(long idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getServiziFruitoriWithServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getServiziFruitoriWithServizio(idServizio);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Documento> serviziAllegatiList(long idServizio, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "serviziAllegatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().serviziAllegatiList(idServizio, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<PortaDelegata> serviziFruitoriPorteDelegateList(Long idSoggetto, String tipoServizio, String nomeServizio, Long idServizio, String tipoSoggettoErogatore, String nomeSoggettoErogatore, Long idSoggettoErogatore, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "serviziPorteAppList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().serviziFruitoriPorteDelegateList(idSoggetto.longValue(), tipoServizio, nomeServizio, idServizio, tipoSoggettoErogatore, nomeSoggettoErogatore, idSoggettoErogatore, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingFruizionePortaDelegata> serviziFruitoriMappingList(Long idFru, IDSoggetto idSoggettoFruitore, IDServizio idAccordoServizio, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "serviziFruitoriMappingList";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean orderByDescrizione = true;
            boolean ricercaUseOffsetLimit = false;
            List list = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)this.tipoDB, (long)idFru, (IDSoggetto)idSoggettoFruitore, (IDServizio)idAccordoServizio, (ISearch)ricerca, (boolean)ricercaUseOffsetLimit, (boolean)orderByDescrizione);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<MappingFruizionePortaDelegata> serviziFruitoriMappingList(IDSoggetto idSoggettoFruitore, IDServizio idAccordoServizio, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "serviziFruitoriMappingList";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean orderByDescrizione = true;
            boolean ricercaUseOffsetLimit = false;
            List list = DBMappingUtils.mappingFruizionePortaDelegataList((Connection)con, (String)this.tipoDB, (IDSoggetto)idSoggettoFruitore, (IDServizio)idAccordoServizio, (ISearch)ricerca, (boolean)ricercaUseOffsetLimit, (boolean)orderByDescrizione);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void deleteMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "deleteMappingFruizione";
        try {
            con = ControlStationCore.dbM.getConnection();
            DBMappingUtils.deleteMappingFruizione((IDServizio)idServizio, (IDSoggetto)idFruitore, (IDPortaDelegata)idPortaDelegata, (Connection)con, (String)this.tipoDB);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isDefaultMappingFruizione(IDServizio idServizio, IDSoggetto idFruitore, IDPortaDelegata idPortaDelegata) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "isDefaultMappingFruizione";
        try {
            con = ControlStationCore.dbM.getConnection();
            boolean bl = DBMappingUtils.checkMappingFruizione((IDServizio)idServizio, (IDSoggetto)idFruitore, (IDPortaDelegata)idPortaDelegata, (boolean)true, (Connection)con, (String)this.tipoDB);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existFruizioniServizioWithoutConnettore(long idServizio, boolean escludiSoggettiEsterni) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "existServizio";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existFruizioniServizioWithoutConnettore(idServizio, escludiSoggettiEsterni);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean filterFruitoriRispettoAutenticazione(AccordoServizioParteSpecifica asps) throws DriverConfigurazioneException {
        List<PortaApplicativa> lista = this.serviziPorteAppList(asps.getTipo(), asps.getNome(), asps.getVersione(), asps.getId().intValue(), asps.getIdSoggetto(), (ISearch)new ConsoleSearch(true));
        return lista.size() == 1;
    }

    public boolean filterFruitoriRispettoAutenticazione(IDServizio idSE) throws DriverConfigurazioneException, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        AccordoServizioParteSpecifica asps = this.getServizio(idSE);
        return this.filterFruitoriRispettoAutenticazione(asps);
    }

    public List<IDServizio> getErogazioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws DriverControlStationException {
        String nomeMetodo = "getErogazioni";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDServizio> list = driver.getErogazioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizio> getErogazioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws DriverControlStationException {
        String nomeMetodo = "getErogazioni";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDServizio> list = driver.getErogazioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto, tipoServizio, nomeServizio, versioneServizio, nomeAzione);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDFruizione> getFruizioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto) throws DriverControlStationException {
        String nomeMetodo = "getFruizioni";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDFruizione> list = driver.getFruizioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDFruizione> getFruizioni(List<String> protocolli, String gruppo, String tipoSoggetto, String nomeSoggetto, String tipoErogatore, String nomeErogatore, String tipoServizio, String nomeServizio, Integer versioneServizio, String nomeAzione) throws DriverControlStationException {
        String nomeMetodo = "getFruizioni";
        Connection con = null;
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List<IDFruizione> list = driver.getFruizioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto, tipoErogatore, nomeErogatore, tipoServizio, nomeServizio, versioneServizio, nomeAzione);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

