/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProprietaOggetto;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.GruppoSintetico;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.pdd.config.UrlInvocazioneAPI;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.pdd.core.connettori.ConnettoreUtils;
import org.openspcoop2.pdd.core.token.PolicyGestioneToken;
import org.openspcoop2.pdd.core.token.PolicyNegoziazioneToken;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.AttributeAuthorityUtilities;
import org.openspcoop2.pdd.core.token.attribute_authority.PolicyAttributeAuthority;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.security.message.utils.SecurityUtils;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.web.ctrlstat.core.CertificateChecker;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCostanti;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniCostanti;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniUtilities;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementImage;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TargetType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ErogazioniHelper
extends AccordiServizioParteSpecificaHelper {
    public ErogazioniHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public ErogazioniHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public void checkGestione(HttpServletRequest request, HttpSession session, ConsoleSearch ricerca, int idLista, String tipologiaParameterName) throws Exception {
        this.checkGestione(request, session, ricerca, idLista, tipologiaParameterName, false);
    }

    public void checkGestione(HttpServletRequest request, HttpSession session, ConsoleSearch ricerca, int idLista, String tipologiaParameterName, boolean addFilterToRicerca) throws Exception {
        String tipologia = this.getParameter(tipologiaParameterName);
        if (tipologia == null) {
            tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
        }
        if (tipologia != null) {
            if ("erogazione".equals(tipologia)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)"erogazione", (String)"_tabKey_tipologiaErogazione");
                if (addFilterToRicerca) {
                    ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
                }
            } else if ("fruizione".equals(tipologia)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)"fruizione", (String)"_tabKey_tipologiaErogazione");
                boolean filtraSoloEsterni = true;
                if (addFilterToRicerca && this.apsCore.isMultitenant() && this.apsCore.getMultitenantSoggettiFruizioni() != null) {
                    switch (this.apsCore.getMultitenantSoggettiFruizioni()) {
                        case SOLO_SOGGETTI_ESTERNI: {
                            filtraSoloEsterni = true;
                            break;
                        }
                        case ESCLUDI_SOGGETTO_FRUITORE: 
                        case TUTTI: {
                            filtraSoloEsterni = false;
                        }
                    }
                }
                if (addFilterToRicerca && filtraSoloEsterni) {
                    ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
                }
            } else if ("completa".equals(tipologia)) {
                ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"_tabKey_tipologiaErogazione");
            }
            if (addFilterToRicerca && this.isSoggettoMultitenantSelezionato()) {
                ricerca.addFilter(idLista, "filtroSoggetto", this.getSoggettoMultitenantSelezionato());
            }
        }
    }

    public boolean isGestioneFruitori(String tipologia) throws Exception {
        boolean gestioneFruitori = false;
        if (tipologia == null) {
            tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        }
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        return gestioneFruitori;
    }

    public DataElement newDataElementStatoApiErogazione(DataElement de, boolean setWidthPx, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico apc, String nomePortaDefault, List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa, List<PortaApplicativa> listaPorteApplicativeAssociate) throws Exception {
        int numeroAbilitate = 0;
        int numeroConfigurazioni = 0;
        int numeroConfigurazioniSchedulingDisabilitato = 0;
        boolean allActionRedefined = false;
        Object msgControlloAccessiMalConfigurato = null;
        numeroConfigurazioni = listaMappingErogazionePortaApplicativa.size();
        if (listaMappingErogazionePortaApplicativa.size() > 1) {
            ArrayList<String> azioniL = new ArrayList<String>();
            Map<String, String> azioni = this.apsCore.getAzioniConLabel(asps, apc, false, true, new ArrayList<String>());
            if (azioni != null && azioni.size() > 0) {
                azioniL.addAll(azioni.keySet());
            }
            allActionRedefined = this.allActionsRedefinedMappingErogazione(azioniL, listaMappingErogazionePortaApplicativa);
        }
        for (PortaApplicativa paAssociata : listaPorteApplicativeAssociate) {
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(paAssociata.getTipoSoggettoProprietario());
            boolean modipa = this.isProfiloModIPA(protocollo);
            boolean statoPA = paAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
            if (!(!statoPA || allActionRedefined && paAssociata.getNome().equals(nomePortaDefault))) {
                ++numeroAbilitate;
            }
            if (allActionRedefined && paAssociata.getNome().equals(nomePortaDefault) || !StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getStato()) || msgControlloAccessiMalConfigurato != null) continue;
            if (!(!TipoAutorizzazione.isAuthenticationRequired((String)paAssociata.getAutorizzazione()) || paAssociata.getSoggetti() != null && paAssociata.getSoggetti().sizeSoggettoList() > 0 || paAssociata.getServiziApplicativiAutorizzati() != null && paAssociata.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0)) {
                msgControlloAccessiMalConfigurato = !modipa ? ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_FRUITORI : ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_CANALE_NO_FRUITORI;
                if (listaMappingErogazionePortaApplicativa.size() > 1) {
                    for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                        if (!mappinErogazione.getIdPortaApplicativa().getNome().equals(paAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappinErogazione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && TipoAutorizzazione.isRolesRequired((String)paAssociata.getAutorizzazione()) && (paAssociata.getRuoli() == null || paAssociata.getRuoli().sizeRuoloList() <= 0)) {
                msgControlloAccessiMalConfigurato = !modipa ? ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_RUOLI : ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_CANALE_NO_RUOLI;
                if (listaMappingErogazionePortaApplicativa.size() > 1) {
                    for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                        if (!mappinErogazione.getIdPortaApplicativa().getNome().equals(paAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappinErogazione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && paAssociata.getGestioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getStato()) && paAssociata.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getAutorizzazioneToken().getAutorizzazioneApplicativi())) {
                if (modipa) {
                    if (paAssociata.getServiziApplicativiAutorizzati() == null || paAssociata.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() <= 0) {
                        msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_MESSAGGIO_NO_FRUITORI;
                    }
                } else if (paAssociata.getAutorizzazioneToken().getServiziApplicativi() == null || paAssociata.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() <= 0) {
                    msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_FRUITORI;
                }
                if (msgControlloAccessiMalConfigurato != null && listaMappingErogazionePortaApplicativa.size() > 1) {
                    for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                        if (!mappinErogazione.getIdPortaApplicativa().getNome().equals(paAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappinErogazione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && paAssociata.getGestioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getStato()) && paAssociata.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getAutorizzazioneToken().getAutorizzazioneRuoli()) && (paAssociata.getAutorizzazioneToken().getRuoli() == null || paAssociata.getAutorizzazioneToken().getRuoli().sizeRuoloList() <= 0)) {
                msgControlloAccessiMalConfigurato = !modipa ? ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_RUOLI : ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_MESSAGGIO_NO_RUOLI;
                if (listaMappingErogazionePortaApplicativa.size() > 1) {
                    for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                        if (!mappinErogazione.getIdPortaApplicativa().getNome().equals(paAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappinErogazione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && paAssociata.getGestioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getStato()) && paAssociata.getScope() != null && StatoFunzionalita.ABILITATO.equals((Object)paAssociata.getScope().getStato()) && paAssociata.getScope().sizeScopeList() <= 0) {
                msgControlloAccessiMalConfigurato = "Rilevato 'Controllo degli Accessi', con autorizzazione token per scope, senza alcun scope registrato";
                if (listaMappingErogazionePortaApplicativa.size() > 1) {
                    for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                        if (!mappinErogazione.getIdPortaApplicativa().getNome().equals(paAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappinErogazione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (paAssociata.getBehaviour() == null || paAssociata.sizeServizioApplicativoList() <= 0) continue;
            for (PortaApplicativaServizioApplicativo paSA : paAssociata.getServizioApplicativoList()) {
                if (paSA == null || paSA.getDatiConnettore() == null || !StatoFunzionalita.DISABILITATO.equals((Object)paSA.getDatiConnettore().getScheduling()) || StatoFunzionalita.DISABILITATO.equals((Object)paSA.getDatiConnettore().getStato())) continue;
                ++numeroConfigurazioniSchedulingDisabilitato;
            }
        }
        return this.newDataElementStatoApi(de, setWidthPx, (String)msgControlloAccessiMalConfigurato, null, numeroAbilitate, numeroConfigurazioni, numeroConfigurazioniSchedulingDisabilitato, allActionRedefined);
    }

    public DataElement newDataElementStatoApiFruizione(DataElement de, boolean setWidthPx, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico apc, String nomePortaDefault, List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata, List<PortaDelegata> listaPorteDelegateAssociate) throws Exception {
        int numeroAbilitate = 0;
        int numeroConfigurazioni = 0;
        boolean allActionRedefined = false;
        Object msgControlloAccessiMalConfigurato = null;
        numeroConfigurazioni = listaMappingFruzionePortaDelegata.size();
        if (listaMappingFruzionePortaDelegata.size() > 1) {
            ArrayList<String> azioniL = new ArrayList<String>();
            Map<String, String> azioni = this.porteDelegateCore.getAzioniConLabel(asps, apc, false, true, new ArrayList<String>());
            if (azioni != null && azioni.size() > 0) {
                azioniL.addAll(azioni.keySet());
            }
            allActionRedefined = this.allActionsRedefinedMappingFruizione(azioniL, listaMappingFruzionePortaDelegata);
        }
        block0: for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
            boolean statoPD = pdAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
            if (!(!statoPD || allActionRedefined && pdAssociata.getNome().equals(nomePortaDefault))) {
                ++numeroAbilitate;
            }
            if (allActionRedefined && pdAssociata.getNome().equals(nomePortaDefault) || !StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getStato()) || msgControlloAccessiMalConfigurato != null) continue;
            if (TipoAutorizzazione.isAuthenticationRequired((String)pdAssociata.getAutorizzazione()) && pdAssociata.sizeServizioApplicativoList() <= 0) {
                msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_FRUITORI;
                if (listaMappingFruzionePortaDelegata.size() > 1) {
                    for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                        if (!mappingFruizione.getIdPortaDelegata().getNome().equals(pdAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappingFruizione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && TipoAutorizzazione.isRolesRequired((String)pdAssociata.getAutorizzazione()) && (pdAssociata.getRuoli() == null || pdAssociata.getRuoli().sizeRuoloList() <= 0)) {
                msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_RUOLI;
                if (listaMappingFruzionePortaDelegata.size() > 1) {
                    for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                        if (!mappingFruizione.getIdPortaDelegata().getNome().equals(pdAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappingFruizione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && pdAssociata.getGestioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getStato()) && pdAssociata.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getAutorizzazioneToken().getAutorizzazioneApplicativi()) && (pdAssociata.getAutorizzazioneToken().getServiziApplicativi() == null || pdAssociata.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() <= 0)) {
                msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_FRUITORI;
                if (listaMappingFruzionePortaDelegata.size() > 1) {
                    for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                        if (!mappingFruizione.getIdPortaDelegata().getNome().equals(pdAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappingFruizione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato == null && pdAssociata.getGestioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getStato()) && pdAssociata.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getAutorizzazioneToken().getAutorizzazioneRuoli()) && (pdAssociata.getAutorizzazioneToken().getRuoli() == null || pdAssociata.getAutorizzazioneToken().getRuoli().sizeRuoloList() <= 0)) {
                msgControlloAccessiMalConfigurato = ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_RUOLI;
                if (listaMappingFruzionePortaDelegata.size() > 1) {
                    for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                        if (!mappingFruizione.getIdPortaDelegata().getNome().equals(pdAssociata.getNome())) continue;
                        msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappingFruizione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                        break;
                    }
                }
            }
            if (msgControlloAccessiMalConfigurato != null || pdAssociata.getGestioneToken() == null || !StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getStato()) || pdAssociata.getScope() == null || !StatoFunzionalita.ABILITATO.equals((Object)pdAssociata.getScope().getStato()) || pdAssociata.getScope().sizeScopeList() > 0) continue;
            msgControlloAccessiMalConfigurato = "Rilevato 'Controllo degli Accessi', con autorizzazione token per scope, senza alcun scope registrato";
            if (listaMappingFruzionePortaDelegata.size() <= 1) continue;
            for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                if (!mappingFruizione.getIdPortaDelegata().getNome().equals(pdAssociata.getNome())) continue;
                msgControlloAccessiMalConfigurato = "(Gruppo: '" + mappingFruizione.getDescrizione() + "') " + (String)msgControlloAccessiMalConfigurato;
                continue block0;
            }
        }
        return this.newDataElementStatoApi(de, setWidthPx, (String)msgControlloAccessiMalConfigurato, null, numeroAbilitate, numeroConfigurazioni, -1, allActionRedefined);
    }

    private DataElement newDataElementStatoApi(DataElement deParam, boolean setWidthPx, String msgControlloAccessiMalConfiguratoError, String msgControlloAccessiMalConfiguratoWarning, int numeroAbilitate, int numeroConfigurazioni, int numeroConfigurazioniSchedulingDisabilitato, boolean allActionRedefined) {
        DataElement de = deParam;
        boolean list = false;
        if (de == null) {
            de = new DataElement();
            list = true;
        }
        if (list) {
            de.setName("statoConf");
        }
        de.setType(DataElementType.CHECKBOX);
        if (msgControlloAccessiMalConfiguratoError != null) {
            de.setStatusType(CheckboxStatusType.DISABILITATO);
            de.setStatusToolTip(msgControlloAccessiMalConfiguratoError);
        } else if (msgControlloAccessiMalConfiguratoWarning != null) {
            de.setStatusType(CheckboxStatusType.WARNING_ONLY);
            de.setStatusToolTip(msgControlloAccessiMalConfiguratoWarning);
        } else if (numeroAbilitate == 0) {
            de.setStatusType(CheckboxStatusType.DISABILITATO);
            de.setStatusToolTip("API disabilitata");
        } else if (!allActionRedefined && numeroAbilitate == numeroConfigurazioni || allActionRedefined && numeroAbilitate == numeroConfigurazioni - 1) {
            if (numeroConfigurazioniSchedulingDisabilitato > 0) {
                de.setStatusType(CheckboxStatusType.WARNING_ONLY);
                de.setStatusToolTip("Rilevati connettori multipli dell'API in cui \u00e8 stato disabilitato lo scheduling della consegna");
            } else {
                de.setStatusType(CheckboxStatusType.ABILITATO);
                de.setStatusToolTip("API attiva");
            }
        } else {
            de.setStatusType(CheckboxStatusType.WARNING_ONLY);
            de.setStatusToolTip("Alcuni gruppi dell'API sono disabilitati");
        }
        if (setWidthPx) {
            de.setWidthPx(16);
        }
        return de;
    }

    public void prepareErogazioniList(ISearch ricerca, List<AccordoServizioParteSpecifica> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            String protocollo;
            CanaleConfigurazione canaleConfigurazioneDefault;
            CanaliConfigurazione canali;
            String protocolloPerFiltroProprieta;
            List<String> protocolli;
            IProtocolFactory p;
            List<String> l;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"aspsErogazioni", (Parameter[])new Parameter[0]);
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = this.isGestioneFruitori(tipologia);
            boolean visualizzaGruppi = false;
            if (gestioneFruitori) {
                this.pd.setCustomListViewName("fruizioni");
            } else {
                this.pd.setCustomListViewName("erogazioni");
            }
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            boolean showServiceBinding = true;
            if (!(showProtocolli || (l = this.core.getProtocolli(this.request, this.session)).isEmpty() || (p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(l.get(0))).getManifest().getBinding().getRest() != null && p.getManifest().getBinding().getSoap() != null)) {
                showServiceBinding = false;
            }
            int idLista = Liste.SERVIZI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
            boolean profiloSelezionato = false;
            String protocolloS = filterProtocollo;
            if (protocolloS == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                protocolloS = protocolli.get(0);
            }
            if (filterProtocollo != null && !"".equals(filterProtocollo) || filterProtocollo == null && protocolloS != null) {
                profiloSelezionato = true;
            }
            if ((protocolloPerFiltroProprieta = protocolloS) == null) {
                protocolloPerFiltroProprieta = "".equals(filterProtocollo) ? null : filterProtocollo;
            }
            String soggettoPerFiltroProprieta = null;
            if (profiloSelezionato) {
                if (!this.isSoggettoMultitenantSelezionato()) {
                    soggettoPerFiltroProprieta = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    if ("".equals(soggettoPerFiltroProprieta)) {
                        soggettoPerFiltroProprieta = null;
                    }
                } else {
                    soggettoPerFiltroProprieta = this.getSoggettoMultitenantSelezionato();
                }
            }
            boolean profiloModipaSelezionato = false;
            if (this.core.getProtocolli().contains("modipa")) {
                ArrayList<String> profiloModipaSelezionatoOpzioniAccettate = new ArrayList<String>();
                profiloModipaSelezionatoOpzioniAccettate.add("modipa");
                if (this.core.isModipaFiltroRicercaProfiloQualsiasiVisualizzaDatiModi()) {
                    profiloModipaSelezionatoOpzioniAccettate.add("");
                }
                if (filterProtocollo != null && profiloModipaSelezionatoOpzioniAccettate.contains(filterProtocollo) || filterProtocollo == null && protocolloS != null && profiloModipaSelezionatoOpzioniAccettate.contains(protocolloS)) {
                    profiloModipaSelezionato = true;
                }
            }
            if (profiloSelezionato && !this.isSoggettoMultitenantSelezionato()) {
                String filterSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                this.addFilterSoggetto(filterSoggetto, protocolloS, true, true);
            }
            String filterTipoAccordo = null;
            if (showServiceBinding) {
                filterTipoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroServiceBinding");
                boolean postBackServiceBinding = profiloSelezionato || profiloModipaSelezionato;
                this.addFilterServiceBinding(filterTipoAccordo, postBackServiceBinding, true);
            }
            String filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            boolean postBackGruppo = profiloSelezionato;
            this.addFilterGruppo(filterProtocollo, filterGruppo, postBackGruppo);
            if (profiloSelezionato) {
                String filterApi = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApi");
                this.addFilterApi(filterProtocollo, filterTipoAccordo, filterGruppo, filterApi, false);
            }
            if ((canali = this.confCore.getCanaliConfigurazione(false)) != null && StatoFunzionalita.ABILITATO.equals((Object)canali.getStato())) {
                String filterCanale = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCanale");
                this.addFilterCanale(canali, filterCanale, false);
            }
            if (this.isShowGestioneWorkflowStatoDocumenti() && this.core.isGestioneWorkflowStatoDocumentiVisualizzaStatoLista()) {
                String filterStatoAccordo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroStatoAccordo");
                this.addFilterStatoAccordo(filterStatoAccordo, false);
            }
            if (gestioneFruitori) {
                this.addFilterSoggettoErogatoreStringaLiberaContains(ricerca, idLista);
            }
            this.addFilterSubtitle("subtDatiConn", "Dati Connettore", false);
            String filterTipoConnettore = this.addFilterTipoConnettore(ricerca, idLista, !gestioneFruitori);
            this.addFilterConnettorePlugin(ricerca, idLista, filterTipoConnettore);
            if (!this.isModalitaStandard()) {
                this.addFilterConnettoreDebug(ricerca, idLista, filterTipoConnettore);
            }
            this.addFilterConnettoreTokenPolicy(ricerca, idLista, filterTipoConnettore);
            this.addFilterConnettoreEndpoint(ricerca, idLista, filterTipoConnettore);
            this.addFilterConnettoreKeystore(ricerca, idLista, filterTipoConnettore);
            this.impostaAperturaSubtitle("subtDatiConn");
            if (profiloModipaSelezionato) {
                this.addFilterSubtitle("subtDatiProfiloModI", "Dati Profilo ModI", false);
                this.addFilterModISicurezzaCanale(ricerca, idLista);
                this.addFilterModISicurezzaMessaggio(ricerca, idLista, filterTipoAccordo);
                this.addFilterModIGenerazioneToken(ricerca, idLista);
                this.addFilterModIDigestRichiesta(ricerca, idLista);
                this.addFilterModIDPoP(ricerca, idLista);
                this.addFilterModIInfoUtente(ricerca, idLista);
                if (!gestioneFruitori) {
                    this.addFilterModISignalHub(ricerca, idLista);
                    this.addFilterModIServiceId(ricerca, idLista);
                    this.addFilterModIDescriptorId(ricerca, idLista);
                }
                this.addFilterModIKeystorePath(ricerca, idLista);
                this.addFilterModIAudience(ricerca, idLista, false, filterTipoAccordo, null);
                this.impostaAperturaSubtitle("subtDatiProfiloModI");
            }
            this.addFilterSubtitle("subtDatiConf", "Dati Configurazione", false);
            this.addFilterStatoImplementazioneAPI(ricerca, idLista);
            this.addFilterTipoAutenticazioneToken(ricerca, idLista);
            boolean modiErogazione = profiloModipaSelezionato && !gestioneFruitori;
            Boolean confPers = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ConfigurazioniPersonalizzate");
            String filterTipoAutenticazioneTrasporto = this.addFilterTipoAutenticazioneTrasporto(ricerca, idLista, true, modiErogazione, confPers);
            this.addFilterTipoAutenticazioneTrasportoPlugin(ricerca, idLista, filterTipoAutenticazioneTrasporto, gestioneFruitori);
            this.addFilterConfigurazioneRateLimiting(ricerca, idLista);
            this.addFilterConfigurazioneValidazione(ricerca, idLista);
            this.addFilterConfigurazioneCacheRisposta(ricerca, idLista);
            this.addFilterConfigurazioneMessageSecurity(ricerca, idLista);
            this.addFilterConfigurazioneMTOM(ricerca, idLista, filterTipoAccordo);
            this.addFilterConfigurazioneTrasformazione(ricerca, idLista);
            this.addFilterConfigurazioneTransazioni(ricerca, idLista, false);
            this.addFilterConfigurazioneCorrelazioneApplicativa(ricerca, idLista);
            this.addFilterConfigurazioneTipoDump(ricerca, idLista, false);
            String filterCORS = this.addFilterConfigurazioneCORS(ricerca, idLista);
            this.addFilterConfigurazioneCORSOrigin(ricerca, idLista, filterCORS);
            this.impostaAperturaSubtitle("subtDatiConf");
            List<String> nomiProprieta = null;
            nomiProprieta = gestioneFruitori ? this.nomiProprietaPD(protocolloPerFiltroProprieta, soggettoPerFiltroProprieta) : this.nomiProprietaPA(protocolloPerFiltroProprieta, soggettoPerFiltroProprieta);
            if (nomiProprieta != null && !nomiProprieta.isEmpty()) {
                this.addFilterSubtitle("subtDatiProp", "Dati Propriet&agrave;", false);
                this.addFilterProprietaNome(ricerca, idLista, nomiProprieta);
                this.addFilterProprietaValore(ricerca, idLista, nomiProprieta);
                this.impostaAperturaSubtitle("subtDatiProp");
            }
            boolean showConfigurazionePA = false;
            boolean showConfigurazionePD = false;
            if (tipologia == null) {
                throw new DriverControlStationException("Parametro TipologiaErogazione non puo' essere vuoto");
            }
            if ("erogazione".equals(tipologia)) {
                showConfigurazionePA = true;
            }
            if ("fruizione".equals(tipologia)) {
                showConfigurazionePD = true;
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            ArrayList<String> labelLst = new ArrayList<String>();
            labelLst.add("");
            if (gestioneFruitori) {
                labelLst.add("Fruizioni");
            } else {
                labelLst.add("Erogazioni");
            }
            if (visualizzaGruppi) {
                labelLst.add("Configurazione");
            }
            String[] labels = labelLst.toArray(new String[labelLst.size()]);
            this.pd.setLabels(labels);
            ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
            if (gestioneFruitori) {
                lstParm.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
            } else {
                lstParm.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
            }
            if (gestioneFruitori) {
                this.pd.setSearchLabel("Fruizione");
            } else {
                this.pd.setSearchLabel("Erogazione");
            }
            if (search.equals("")) {
                this.pd.setSearchDescription("");
            } else {
                lstParm.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Erogazioni", (String)search);
            }
            ArrayList<AccordoServizioParteComuneSintetico> listApc = new ArrayList<AccordoServizioParteComuneSintetico>();
            ArrayList<String> protocolli2 = new ArrayList<String>();
            List<String> tagsDisponibili = this.gruppiCore.getAllGruppiOrdinatiPerDataRegistrazione();
            CanaliConfigurazione gestioneCanali = this.confCore.getCanaliConfigurazione(false);
            boolean gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
            CanaleConfigurazione canaleConfigurazione = canaleConfigurazioneDefault = gestioneCanaliEnabled ? this.getCanaleDefault(canaleList) : null;
            if (lista != null) {
                for (AccordoServizioParteSpecifica asps : lista) {
                    AccordoServizioParteComuneSintetico apc = this.apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
                    String tipoSoggetto = asps.getTipoSoggettoErogatore();
                    protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoSoggetto);
                    listApc.add(apc);
                    protocolli2.add(protocollo);
                }
            }
            ArrayList<ArrayList<DataElement>> dati = new ArrayList<ArrayList<DataElement>>();
            if (lista != null) {
                for (int i = 0; i < lista.size(); ++i) {
                    String labelProtocollo;
                    String nomePortaDefault;
                    AccordoServizioParteSpecifica asps = lista.get(i);
                    IDServizio idServizio = this.idServizioFactory.getIDServizioFromAccordo(asps);
                    protocollo = (String)protocolli2.get(i);
                    Fruitore fruitore = null;
                    IDSoggetto idSoggettoFruitore = null;
                    if (showConfigurazionePD || gestioneFruitori) {
                        fruitore = asps.getFruitore(0);
                        idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    }
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pIdsoggErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
                    Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
                    Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
                    Parameter pTipoSoggettoFruitore = null;
                    Parameter pNomeSoggettoFruitore = null;
                    if (gestioneFruitori) {
                        pTipoSoggettoFruitore = new Parameter("tipoSoggFru", fruitore.getTipo());
                        pNomeSoggettoFruitore = new Parameter("nomeSoggFru", fruitore.getNome());
                    }
                    String uriASPS = this.idServizioFactory.getUriFromAccordo(asps);
                    boolean showVerificaCertificati = false;
                    showVerificaCertificati = gestioneFruitori ? this.core.isFruizioniVerificaCertificati() : this.core.isErogazioniVerificaCertificati();
                    DataElement de = new DataElement();
                    String labelServizio = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, protocollo);
                    de.setLabel("Nome Servizio");
                    ArrayList<Parameter> listParameters = new ArrayList<Parameter>();
                    listParameters.add(new Parameter("id", "" + asps.getId()));
                    listParameters.add(pNomeServizio);
                    listParameters.add(pTipoServizio);
                    listParameters.add(pIdsoggErogatore);
                    if (gestioneFruitori) {
                        listParameters.add(pTipoSoggettoFruitore);
                        listParameters.add(pNomeSoggettoFruitore);
                    }
                    de.setUrl("aspsErogazioniChange.do", listParameters.toArray(new Parameter[1]));
                    de.setValue(labelServizio);
                    if (gestioneFruitori) {
                        de.setIdToRemove(uriASPS + "@" + fruitore.getTipo() + "/" + fruitore.getNome());
                    } else {
                        de.setIdToRemove(uriASPS);
                    }
                    de.setType(DataElementType.TITLE);
                    e.add(de);
                    AccordoServizioParteComuneSintetico apc = (AccordoServizioParteComuneSintetico)listApc.get(i);
                    org.openspcoop2.message.constants.ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(apc.getServiceBinding());
                    DataElement dataElementStatoApi = null;
                    String labelCanalePorta = null;
                    if (showConfigurazionePA) {
                        List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
                        ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
                        nomePortaDefault = null;
                        for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                            PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(mappinErogazione.getIdPortaApplicativa());
                            if (mappinErogazione.isDefault()) {
                                nomePortaDefault = mappinErogazione.getIdPortaApplicativa().getNome();
                                labelCanalePorta = pa.getCanale();
                            }
                            listaPorteApplicativeAssociate.add(pa);
                        }
                        dataElementStatoApi = this.newDataElementStatoApiErogazione(null, true, asps, apc, nomePortaDefault, listaMappingErogazionePortaApplicativa, listaPorteApplicativeAssociate);
                    }
                    if (showConfigurazionePD) {
                        List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata = this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                        ArrayList<PortaDelegata> listaPorteDelegateAssociate = new ArrayList<PortaDelegata>();
                        nomePortaDefault = null;
                        for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                            PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata());
                            if (mappingFruizione.isDefault()) {
                                nomePortaDefault = mappingFruizione.getIdPortaDelegata().getNome();
                                labelCanalePorta = pd.getCanale();
                            }
                            listaPorteDelegateAssociate.add(pd);
                        }
                        dataElementStatoApi = this.newDataElementStatoApiFruizione(null, true, asps, apc, nomePortaDefault, listaMappingFruzionePortaDelegata, listaPorteDelegateAssociate);
                    }
                    de = new DataElement();
                    String labelAPI = this.getLabelIdAccordo(apc);
                    String labelServiceBinding = null;
                    switch (serviceBinding) {
                        case REST: {
                            labelServiceBinding = "Rest";
                            break;
                        }
                        default: {
                            labelServiceBinding = "Soap";
                        }
                    }
                    if (gestioneCanaliEnabled) {
                        if (labelCanalePorta == null) {
                            labelCanalePorta = apc.getCanale();
                        }
                        if (labelCanalePorta == null) {
                            String string = labelCanalePorta = canaleConfigurazioneDefault != null ? canaleConfigurazioneDefault.getNome() : null;
                        }
                        if (showProtocolli) {
                            labelProtocollo = this.getLabelProtocollo(protocollo);
                            de.setValue(MessageFormat.format("API {0}: {1}, Canale: {2}, Profilo Interoperabilit&agrave;: {3}", labelServiceBinding, labelAPI, labelCanalePorta, labelProtocollo));
                        } else {
                            de.setValue(MessageFormat.format("API {0}: {1}, Canale: {2}", labelServiceBinding, labelAPI, labelCanalePorta));
                        }
                    } else if (showProtocolli) {
                        labelProtocollo = this.getLabelProtocollo(protocollo);
                        de.setValue(MessageFormat.format("API {0}: {1}, Profilo Interoperabilit&agrave;: {2}", labelServiceBinding, labelAPI, labelProtocollo));
                    } else {
                        de.setValue(MessageFormat.format("API {0}: {1}", labelServiceBinding, labelAPI));
                    }
                    de.setType(DataElementType.SUBTITLE);
                    e.add(de);
                    List gruppo = apc.getGruppo();
                    if (gruppo != null && !gruppo.isEmpty()) {
                        for (int j = 0; j < gruppo.size(); ++j) {
                            GruppoSintetico gruppoSintetico = (GruppoSintetico)gruppo.get(j);
                            de = new DataElement();
                            de.setName("gruppo_" + j);
                            de.setType(DataElementType.BUTTON);
                            de.setLabel(gruppoSintetico.getNome());
                            int indexOf = tagsDisponibili.indexOf(gruppoSintetico.getNome());
                            if (indexOf == -1) {
                                indexOf = 0;
                            }
                            de.setStyleClass("label-info-" + (indexOf %= CostantiControlStation.NUMERO_GRUPPI_CSS.intValue()));
                            e.add(de);
                        }
                    }
                    if (dataElementStatoApi != null) {
                        e.add(dataElementStatoApi);
                    }
                    if (visualizzaGruppi) {
                        String statoDump;
                        boolean controlloDumpAbilitato;
                        String statoTracciamento;
                        String statoMTOM;
                        String statoMessageSecurity;
                        String statoValidazione;
                        boolean autorizzazioneAbilitato;
                        boolean gestioneTokenAbilitato;
                        if (showConfigurazionePA) {
                            boolean bl;
                            Object paAssociata42;
                            boolean bl2;
                            Object paAssociata32;
                            boolean visualizzaMTOM = true;
                            boolean visualizzaSicurezza = true;
                            boolean visualizzaCorrelazione = true;
                            switch (serviceBinding) {
                                case REST: {
                                    visualizzaMTOM = false;
                                    visualizzaSicurezza = true;
                                    visualizzaCorrelazione = true;
                                    break;
                                }
                                default: {
                                    visualizzaMTOM = true;
                                    visualizzaSicurezza = true;
                                    visualizzaCorrelazione = true;
                                }
                            }
                            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
                            List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
                            ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
                            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaMappingErogazionePortaApplicativa) {
                                listaPorteApplicativeAssociate.add(this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa()));
                            }
                            gestioneTokenAbilitato = false;
                            for (Object paAssociata32 : listaPorteApplicativeAssociate) {
                                String string = this.getStatoGestioneTokenPortaApplicativa((PortaApplicativa)paAssociata32);
                                if (!string.equals("abilitato")) continue;
                                gestioneTokenAbilitato = true;
                                break;
                            }
                            if (gestioneTokenAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autenticazione Token");
                                e.add(de);
                            }
                            boolean bl3 = false;
                            paAssociata32 = listaPorteApplicativeAssociate.iterator();
                            while (paAssociata32.hasNext()) {
                                PortaApplicativa portaApplicativa = (PortaApplicativa)paAssociata32.next();
                                String statoAutenticazione = this.getStatoAutenticazionePortaApplicativa(portaApplicativa);
                                if (!statoAutenticazione.equals("abilitato")) continue;
                                bl2 = true;
                                break;
                            }
                            if (bl2) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autenticazione");
                                e.add(de);
                            }
                            autorizzazioneAbilitato = false;
                            for (Object paAssociata42 : listaPorteApplicativeAssociate) {
                                String string = this.getStatoAutorizzazionePortaApplicativa((PortaApplicativa)paAssociata42);
                                if (!string.equals("abilitato")) continue;
                                autorizzazioneAbilitato = true;
                                break;
                            }
                            if (autorizzazioneAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autorizzazione");
                                e.add(de);
                            }
                            boolean bl4 = false;
                            paAssociata42 = listaPorteApplicativeAssociate.iterator();
                            while (paAssociata42.hasNext()) {
                                PortaApplicativa portaApplicativa = (PortaApplicativa)paAssociata42.next();
                                statoValidazione = this.getStatoValidazionePortaApplicativa(portaApplicativa);
                                if (statoValidazione.equals(PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Validazione");
                                e.add(de);
                            }
                            if (visualizzaSicurezza) {
                                boolean controlloMessageSecurityAbilitato = false;
                                for (PortaApplicativa paAssociata6 : listaPorteApplicativeAssociate) {
                                    statoMessageSecurity = this.getStatoMessageSecurityPortaApplicativa(paAssociata6);
                                    if (!statoMessageSecurity.equals(CostantiConfigurazione.ABILITATO.toString())) continue;
                                    controlloMessageSecurityAbilitato = true;
                                    break;
                                }
                                if (controlloMessageSecurityAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("Sicurezza Messaggio");
                                    e.add(de);
                                }
                            }
                            if (visualizzaMTOM) {
                                boolean controlloMTOMAbilitato = false;
                                for (PortaApplicativa paAssociata : listaPorteApplicativeAssociate) {
                                    statoMTOM = this.getStatoMTOMPortaApplicativa(paAssociata);
                                    if (!"abilitato".equals(statoMTOM)) continue;
                                    controlloMTOMAbilitato = true;
                                    break;
                                }
                                if (controlloMTOMAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("MTOM");
                                    e.add(de);
                                }
                            }
                            if (visualizzaCorrelazione) {
                                boolean controlloCorrelazioneApplicativaAbilitato = false;
                                for (PortaApplicativa paAssociata : listaPorteApplicativeAssociate) {
                                    statoTracciamento = this.getStatoTracciamentoPortaApplicativa(paAssociata);
                                    if (!"abilitato".equals(statoTracciamento)) continue;
                                    controlloCorrelazioneApplicativaAbilitato = true;
                                    break;
                                }
                                if (controlloCorrelazioneApplicativaAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("Tracciamento");
                                    e.add(de);
                                }
                            }
                            controlloDumpAbilitato = false;
                            for (PortaApplicativa paAssociata : listaPorteApplicativeAssociate) {
                                statoDump = this.getStatoDumpPortaApplicativa(paAssociata, true);
                                if (statoDump.startsWith("default")) continue;
                                controlloDumpAbilitato = true;
                                break;
                            }
                            if (controlloDumpAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Registrazione Messaggi");
                                e.add(de);
                            }
                        } else if (showConfigurazionePD) {
                            boolean bl;
                            boolean bl5;
                            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
                            List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata = this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                            ArrayList<PortaDelegata> listaPorteDelegateAssociate = new ArrayList<PortaDelegata>();
                            for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                                listaPorteDelegateAssociate.add(this.porteDelegateCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata()));
                            }
                            boolean visualizzaMTOM = true;
                            boolean visualizzaSicurezza = true;
                            boolean visualizzaCorrelazione = true;
                            switch (serviceBinding) {
                                case REST: {
                                    visualizzaMTOM = false;
                                    visualizzaSicurezza = true;
                                    visualizzaCorrelazione = true;
                                    break;
                                }
                                default: {
                                    visualizzaMTOM = true;
                                    visualizzaSicurezza = true;
                                    visualizzaCorrelazione = true;
                                }
                            }
                            gestioneTokenAbilitato = false;
                            for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                String string = this.getStatoGestioneTokenPortaDelegata(pdAssociata);
                                if (!string.equals("abilitato")) continue;
                                gestioneTokenAbilitato = true;
                                break;
                            }
                            if (gestioneTokenAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autenticazione Token");
                                e.add(de);
                            }
                            boolean bl6 = false;
                            for (PortaDelegata portaDelegata : listaPorteDelegateAssociate) {
                                String statoAutenticazione = this.getStatoAutenticazionePortaDelegata(portaDelegata);
                                if (!statoAutenticazione.equals("abilitato")) continue;
                                bl5 = true;
                                break;
                            }
                            if (bl5) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autenticazione");
                                e.add(de);
                            }
                            autorizzazioneAbilitato = false;
                            for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                String string = this.getStatoAutorizzazionePortaDelegata(pdAssociata);
                                if (!string.equals("abilitato")) continue;
                                autorizzazioneAbilitato = true;
                                break;
                            }
                            if (autorizzazioneAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Autorizzazione");
                                e.add(de);
                            }
                            boolean bl7 = false;
                            for (PortaDelegata portaDelegata : listaPorteDelegateAssociate) {
                                statoValidazione = this.getStatoValidazionePortaDelegata(portaDelegata);
                                if (statoValidazione.equals(PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO)) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Validazione");
                                e.add(de);
                            }
                            if (visualizzaSicurezza) {
                                boolean controlloMessageSecurityAbilitato = false;
                                for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                    statoMessageSecurity = this.getStatoMessageSecurityPortaDelegata(pdAssociata);
                                    if (!statoMessageSecurity.equals(CostantiConfigurazione.ABILITATO.toString())) continue;
                                    controlloMessageSecurityAbilitato = true;
                                    break;
                                }
                                if (controlloMessageSecurityAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("Sicurezza Messaggio");
                                    e.add(de);
                                }
                            }
                            if (visualizzaMTOM) {
                                boolean controlloMTOMAbilitato = false;
                                for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                    statoMTOM = this.getStatoMTOMPortaDelegata(pdAssociata);
                                    if (!"abilitato".equals(statoMTOM)) continue;
                                    controlloMTOMAbilitato = true;
                                    break;
                                }
                                if (controlloMTOMAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("MTOM");
                                    e.add(de);
                                }
                            }
                            if (visualizzaCorrelazione) {
                                boolean controlloCorrelazioneApplicativaAbilitato = false;
                                for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                    statoTracciamento = this.getStatoTracciamentoPortaDelegata(pdAssociata);
                                    if (!"abilitato".equals(statoTracciamento)) continue;
                                    controlloCorrelazioneApplicativaAbilitato = true;
                                    break;
                                }
                                if (controlloCorrelazioneApplicativaAbilitato) {
                                    de = new DataElement();
                                    de.setType(DataElementType.IMAGE);
                                    de.setValue("Correlazione Applicativa");
                                    e.add(de);
                                }
                            }
                            controlloDumpAbilitato = false;
                            for (PortaDelegata pdAssociata : listaPorteDelegateAssociate) {
                                statoDump = this.getStatoDumpPortaDelegata(pdAssociata, true);
                                if (statoDump.startsWith("default")) continue;
                                controlloDumpAbilitato = true;
                                break;
                            }
                            if (controlloDumpAbilitato) {
                                de = new DataElement();
                                de.setType(DataElementType.IMAGE);
                                de.setValue("Registrazione Messaggi");
                                e.add(de);
                            }
                        }
                    }
                    String idServizioButton = gestioneFruitori ? uriASPS + "@" + fruitore.getTipo() + "/" + fruitore.getNome() : uriASPS;
                    this.addInUsoInfoButton(e, labelServizio, idServizioButton, gestioneFruitori ? InUsoType.FRUIZIONE_INFO : InUsoType.EROGAZIONE_INFO);
                    if (showVerificaCertificati) {
                        ArrayList<Parameter> listParametersServizioModificaProfilo = null;
                        ArrayList<Parameter> listParametersServizioFruitoriModificaProfilo = null;
                        listParametersServizioModificaProfilo = new ArrayList<Parameter>();
                        listParametersServizioModificaProfilo.addAll(listParameters);
                        listParametersServizioModificaProfilo.add(new Parameter("modificaProfilo", "true"));
                        listParametersServizioModificaProfilo.add(new Parameter("certVerFromLista", "true"));
                        if (gestioneFruitori) {
                            listParametersServizioFruitoriModificaProfilo = new ArrayList<Parameter>();
                            listParametersServizioFruitoriModificaProfilo.addAll(listParametersServizioModificaProfilo);
                            Parameter pIdFruitore = new Parameter("myId", "" + fruitore.getId());
                            listParametersServizioFruitoriModificaProfilo.add(pIdFruitore);
                        }
                        if (gestioneFruitori) {
                            this.addComandoVerificaCertificatiButton(e, labelServizio, "aspsErogazioniVerificaCertificati.do", listParametersServizioFruitoriModificaProfilo);
                        } else {
                            this.addComandoVerificaCertificatiButton(e, labelServizio, "aspsErogazioniVerificaCertificati.do", listParametersServizioModificaProfilo);
                        }
                    }
                    if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                        ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
                        listaParametriChange.addAll(listParameters);
                        this.addComandoResetCacheButton(e, labelServizio, "aspsErogazioniChange.do", listaParametriChange);
                    }
                    if (gestioneFruitori) {
                        this.addProprietaOggettoButton(e, labelServizio, idServizioButton, InUsoType.FRUIZIONE);
                    } else if (!gestioneFruitori) {
                        this.addProprietaOggettoButton(e, labelServizio, idServizioButton, InUsoType.EROGAZIONE);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.ACCORDO_SERVIZIO_PARTE_SPECIFICA, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                if (gestioneFruitori) {
                    de.setOnClick(AccordiServizioParteSpecificaCostanti.LABEL_FRUIZIONI_ESPORTA_SELEZIONATI_ONCLICK);
                } else {
                    de.setOnClick(AccordiServizioParteSpecificaCostanti.LABEL_EROGAZIONI_ESPORTA_SELEZIONATI_ONCLICK);
                }
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<List<DataElement>> addErogazioneToDati(List<List<DataElement>> datiPagina, TipoOperazione tipoOp, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as, String protocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, boolean gestioneErogatori, boolean gestioneFruitori, List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa, List<PortaApplicativa> listaPorteApplicativeAssociate, List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata, List<PortaDelegata> listaPorteDelegateAssociate, Fruitore fruitore) throws Exception {
        ArrayList<AccordoServizioParteComune> asParteComuneCompatibili;
        Parameter pTipoAccordo;
        boolean descrizioneEmpty;
        DataElement de;
        ProprietaOggetto pOggetto;
        List<DataElement> dati;
        ArrayList<Parameter> listParametersServizioFruitoriModificaProfiloOrVerificaCertificati;
        ArrayList<Parameter> listParametersServizioModificaProfiloOrVerificaCertificati;
        ArrayList<Parameter> listaParametriChange;
        boolean showVerificaCertificatiModi;
        boolean modificaDatiProfilo;
        IDServizio idServizio;
        boolean showSoggettoFruitoreInFruizioni;
        boolean isPddEsterna;
        Parameter pIdProviderFruitore;
        Parameter pNomeSoggettoFruitore;
        Parameter pTipoSoggettoFruitore;
        Parameter pIdSogg;
        Parameter pIdFruitore;
        Parameter pIdSoggettoErogatore;
        Parameter pId;
        Parameter pIdAsps;
        Parameter pTipoServizio;
        Parameter pNomeServizio;
        boolean showProtocolli;
        boolean visualizzaGruppi;
        block101: {
            String statoMapping;
            Parameter pAbilita;
            Parameter pFromApi;
            String nomePortaDefault;
            visualizzaGruppi = false;
            if (gestioneFruitori) {
                this.pd.setCustomListViewName("fruizione");
            } else {
                this.pd.setCustomListViewName("erogazione");
            }
            if (asps == null) {
                throw new DriverControlStationException("Param asps is null");
            }
            showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            pNomeServizio = new Parameter("nomeservizio", asps.getNome());
            pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
            pIdAsps = new Parameter("idAsps", "" + asps.getId());
            pId = new Parameter("id", "" + asps.getId());
            pIdSoggettoErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
            pIdFruitore = null;
            pIdSogg = null;
            pTipoSoggettoFruitore = null;
            pNomeSoggettoFruitore = null;
            pIdProviderFruitore = null;
            if (gestioneFruitori) {
                pIdFruitore = new Parameter("myId", "" + fruitore.getId());
                pIdSogg = new Parameter("idsogg", "" + fruitore.getIdSoggetto());
                pTipoSoggettoFruitore = new Parameter("tipoSoggFru", fruitore.getTipo());
                pNomeSoggettoFruitore = new Parameter("nomeSoggFru", fruitore.getNome());
                Long idSoggettoLong = fruitore.getIdSoggetto();
                if (idSoggettoLong == null) {
                    idSoggettoLong = this.soggettiCore.getIdSoggetto(fruitore.getNome(), fruitore.getTipo());
                    pIdSogg = new Parameter("idsogg", "" + idSoggettoLong);
                }
                pIdProviderFruitore = new Parameter("providerFruitore", "" + idSoggettoLong);
            }
            Soggetto sog = this.soggettiCore.getSoggettoRegistro(asps.getIdSoggetto());
            isPddEsterna = this.pddCore.isPddEsterna(sog.getPortaDominio());
            boolean showSoggettoErogatoreInErogazioni = this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
            showSoggettoFruitoreInFruizioni = gestioneFruitori && this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
            idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            IDSoggetto idSoggettoFruitore = null;
            if (gestioneFruitori) {
                idSoggettoFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
            }
            IDServizio idAps = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            idAps.setPortType(asps.getPortType());
            idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
            IRegistryReader registryReader = this.apcCore.getRegistryReader(protocolFactory);
            IConfigIntegrationReader configRegistryReader = this.apcCore.getConfigIntegrationReader(protocolFactory);
            ConsoleConfiguration consoleConfiguration = null;
            if (gestioneErogatori) {
                consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, configRegistryReader, idAps);
            } else {
                IDFruizione idFruizione = new IDFruizione();
                idFruizione.setIdServizio(idAps);
                idFruizione.setIdFruitore(new IDSoggetto(fruitore.getTipo(), fruitore.getNome()));
                consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, configRegistryReader, idFruizione);
            }
            modificaDatiProfilo = false;
            if (consoleConfiguration != null && consoleConfiguration.getConsoleItem() != null && !consoleConfiguration.getConsoleItem().isEmpty()) {
                modificaDatiProfilo = true;
            }
            boolean modi = this.core.isProfiloModIPA(protocollo);
            boolean showVerificaCertificati = false;
            showVerificaCertificati = gestioneFruitori ? this.core.isFruizioniVerificaCertificati() : this.core.isErogazioniVerificaCertificati();
            showVerificaCertificatiModi = false;
            if (modi && modificaDatiProfilo) {
                showVerificaCertificatiModi = gestioneFruitori ? this.core.isModipaFruizioniVerificaCertificati() : this.core.isModipaErogazioniVerificaCertificati();
            }
            listaParametriChange = new ArrayList<Parameter>();
            listaParametriChange.add(new Parameter("id", "" + asps.getId()));
            listaParametriChange.add(pNomeServizio);
            listaParametriChange.add(pTipoServizio);
            listaParametriChange.add(pIdSoggettoErogatore);
            if (gestioneFruitori) {
                listaParametriChange.add(pTipoSoggettoFruitore);
                listaParametriChange.add(pNomeSoggettoFruitore);
                listaParametriChange.add(pIdProviderFruitore);
            }
            listParametersServizioModificaProfiloOrVerificaCertificati = null;
            listParametersServizioFruitoriModificaProfiloOrVerificaCertificati = null;
            if (modificaDatiProfilo || showVerificaCertificati) {
                listParametersServizioModificaProfiloOrVerificaCertificati = new ArrayList<Parameter>();
                listParametersServizioModificaProfiloOrVerificaCertificati.addAll(listaParametriChange);
                if (gestioneFruitori) {
                    listParametersServizioFruitoriModificaProfiloOrVerificaCertificati = new ArrayList<Parameter>();
                    listParametersServizioFruitoriModificaProfiloOrVerificaCertificati.addAll(listParametersServizioModificaProfiloOrVerificaCertificati);
                    listParametersServizioFruitoriModificaProfiloOrVerificaCertificati.add(pIdFruitore);
                }
            }
            dati = datiPagina.get(0);
            pOggetto = this.creaProprietaOggetto(asps, gestioneFruitori, fruitore, idServizio, idSoggettoFruitore);
            this.impostaComandiMenuContestuale(asps, protocollo, gestioneFruitori, fruitore, showVerificaCertificati, listaParametriChange, listParametersServizioModificaProfiloOrVerificaCertificati, listParametersServizioFruitoriModificaProfiloOrVerificaCertificati, pOggetto, true, false);
            de = new DataElement();
            String labelServizio = this.getLabelIdServizioSenzaErogatore(idServizio);
            Object labelServizioConPortType = labelServizio;
            if (asps.getPortType() != null && !"".equals(asps.getPortType()) && !asps.getNome().equals(asps.getPortType())) {
                labelServizioConPortType = (String)labelServizioConPortType + " (" + asps.getPortType() + ")";
            }
            de.setLabel("Nome");
            de.setValue((String)labelServizioConPortType);
            de.setStatusValue((String)labelServizioConPortType);
            de.setType(DataElementType.TEXT);
            ArrayList<Parameter> listParametersServizioModifica = new ArrayList<Parameter>();
            listParametersServizioModifica.addAll(listaParametriChange);
            listParametersServizioModifica.add(new Parameter("modificaAPI", "false"));
            DataElementImage imageChangeStato = null;
            if (gestioneErogatori) {
                nomePortaDefault = null;
                for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                    if (!mappinErogazione.isDefault()) continue;
                    nomePortaDefault = mappinErogazione.getIdPortaApplicativa().getNome();
                }
                this.newDataElementStatoApiErogazione(de, false, asps, as, nomePortaDefault, listaMappingErogazionePortaApplicativa, listaPorteApplicativeAssociate);
                if (listaMappingErogazionePortaApplicativa.size() == 1) {
                    PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(listaMappingErogazionePortaApplicativa.get(0).getIdPortaApplicativa());
                    Parameter pIdPorta = new Parameter("id", "" + pa.getId());
                    Parameter pNomePorta = new Parameter("nomePorta", pa.getNome());
                    Parameter pIdSoggPA = new Parameter("idsogg", "" + pa.getIdSoggetto());
                    pFromApi = new Parameter("fromApiPageInfo", "true");
                    boolean statoPA = pa.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    pAbilita = new Parameter("abilita", statoPA ? "no" : "true");
                    imageChangeStato = new DataElementImage();
                    imageChangeStato.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSoggPA, pNomePorta, pIdPorta, pIdAsps, pAbilita, pFromApi});
                    statoMapping = statoPA ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                    imageChangeStato.setToolTip(statoMapping);
                    imageChangeStato.setImage(statoPA ? "&#xE9F6;" : "&#xE9F5;");
                }
            }
            if (gestioneFruitori) {
                nomePortaDefault = null;
                for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                    if (!mappingFruizione.isDefault()) continue;
                    nomePortaDefault = mappingFruizione.getIdPortaDelegata().getNome();
                }
                this.newDataElementStatoApiFruizione(de, false, asps, as, nomePortaDefault, listaMappingFruzionePortaDelegata, listaPorteDelegateAssociate);
                if (listaMappingFruzionePortaDelegata.size() == 1) {
                    PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(listaMappingFruzionePortaDelegata.get(0).getIdPortaDelegata());
                    Parameter pIdPD = new Parameter("id", "" + pd.getId());
                    Parameter pNomePD = new Parameter("nomePorta", pd.getNome());
                    Parameter pIdSoggPD = new Parameter("idsogg", "" + pd.getIdSoggetto());
                    pFromApi = new Parameter("fromApiPageInfo", "true");
                    boolean statoPD = pd.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    pAbilita = new Parameter("abilita", statoPD ? "no" : "true");
                    imageChangeStato = new DataElementImage();
                    imageChangeStato.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita, pFromApi});
                    statoMapping = statoPD ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                    imageChangeStato.setToolTip(statoMapping);
                    imageChangeStato.setImage(statoPD ? "&#xE9F6;" : "&#xE9F5;");
                }
            }
            DataElementImage imageChangeName = new DataElementImage();
            imageChangeName.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModifica.toArray(new Parameter[1]));
            imageChangeName.setToolTip(MessageFormat.format("Modifica {0}", "Informazioni Generali"));
            imageChangeName.setImage("&#xE3C9;");
            if (imageChangeStato != null) {
                de.addImage(imageChangeName);
            } else {
                de.setImage(imageChangeName);
            }
            descrizioneEmpty = false;
            if (gestioneFruitori && (fruitore.getDescrizione() == null || StringUtils.isEmpty((String)fruitore.getDescrizione())) || !gestioneFruitori && (asps.getDescrizione() == null || StringUtils.isEmpty((String)asps.getDescrizione()))) {
                descrizioneEmpty = true;
            }
            if (descrizioneEmpty) {
                DataElementImage image = new DataElementImage();
                ArrayList<Parameter> listParametersServizioModificaDescrizione = new ArrayList<Parameter>();
                listParametersServizioModificaDescrizione.addAll(listaParametriChange);
                listParametersServizioModificaDescrizione.add(new Parameter("modificaDescrizione", "true"));
                image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaDescrizione.toArray(new Parameter[1]));
                image.setToolTip(MessageFormat.format("Aggiungi {0}", "Descrizione"));
                image.setImage("&#xE873;");
                de.addImage(image);
            }
            if (imageChangeStato != null) {
                de.addImage(imageChangeStato);
            }
            dati.add(de);
            if (gestioneFruitori || showSoggettoErogatoreInErogazioni) {
                de = new DataElement();
                de.setLabel("Soggetto Erogatore");
                de.setValue(this.getLabelNomeSoggetto(protocollo, asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore()));
                de.setType(DataElementType.TEXT);
                dati.add(de);
                ArrayList<Parameter> listParametersServizioModificaSoggettoErogatore = new ArrayList<Parameter>();
                listParametersServizioModificaSoggettoErogatore.addAll(listaParametriChange);
                listParametersServizioModificaSoggettoErogatore.add(new Parameter("cambiaErogatore", "true"));
                DataElementImage image = new DataElementImage();
                image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaSoggettoErogatore.toArray(new Parameter[1]));
                image.setToolTip(MessageFormat.format("Cambia {0}", "Soggetto Erogatore"));
                image.setImage("&#xE3C9;");
                image.setTarget(TargetType.SELF);
                de.addImage(image);
            }
            de = new DataElement();
            pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(as);
            String labelAPI = this.getLabelIdAccordo(as);
            String labelServiceBinding = null;
            switch (serviceBinding) {
                case REST: {
                    labelServiceBinding = "Rest";
                    break;
                }
                default: {
                    labelServiceBinding = "Soap";
                }
            }
            de.setLabel("API");
            de.setValue(MessageFormat.format("{1} ({0})", labelServiceBinding, labelAPI));
            de.setType(DataElementType.BUTTON);
            ArrayList<String> labelsGruppi = new ArrayList<String>();
            ArrayList<CallSite> valuesGruppi = new ArrayList<CallSite>();
            List gruppi = as.getGruppo();
            if (gruppi != null) {
                List<String> tagsDisponibili = this.gruppiCore.getAllGruppiOrdinatiPerDataRegistrazione();
                for (int i = 0; i < gruppi.size(); ++i) {
                    GruppoSintetico gruppo = (GruppoSintetico)gruppi.get(i);
                    int indexOf = tagsDisponibili.indexOf(gruppo.getNome());
                    if (indexOf == -1) {
                        indexOf = 0;
                    }
                    labelsGruppi.add(gruppo.getNome());
                    valuesGruppi.add((CallSite)((Object)("label-info-" + (indexOf %= CostantiControlStation.NUMERO_GRUPPI_CSS.intValue()))));
                }
            }
            de.setLabels(labelsGruppi);
            de.setValues(valuesGruppi);
            asParteComuneCompatibili = null;
            try {
                List<AccordoServizioParteComune> asParteComuneCompatibiliTmp;
                boolean soloAccordiConsistentiRest = false;
                boolean soloAccordiConsistentiSoap = false;
                if (!this.isModalitaCompleta()) {
                    soloAccordiConsistentiRest = true;
                    soloAccordiConsistentiSoap = true;
                }
                if ((asParteComuneCompatibiliTmp = this.apsCore.findAccordiParteComuneBySoggettoAndNome(as.getNome(), new IDSoggetto(as.getSoggettoReferente().getTipo(), as.getSoggettoReferente().getNome()))) == null || asParteComuneCompatibiliTmp.isEmpty()) break block101;
                for (AccordoServizioParteComune accordoServizioParteComune : asParteComuneCompatibiliTmp) {
                    boolean isValid = false;
                    if (ServiceBinding.REST.equals((Object)accordoServizioParteComune.getServiceBinding())) {
                        if (soloAccordiConsistentiRest) {
                            isValid = accordoServizioParteComune.sizeResourceList() > 0;
                        }
                    } else if (soloAccordiConsistentiSoap) {
                        if (asps != null && asps.getPortType() != null) {
                            for (int i = 0; i < accordoServizioParteComune.sizePortTypeList(); ++i) {
                                if (!accordoServizioParteComune.getPortType(i).getNome().equals(asps.getPortType()) || accordoServizioParteComune.getPortType(i).sizeAzioneList() <= 0) continue;
                                isValid = true;
                                break;
                            }
                        } else {
                            boolean bl = isValid = accordoServizioParteComune.sizeAzioneList() > 0;
                        }
                    }
                    if (!isValid) continue;
                    if (asParteComuneCompatibili == null) {
                        asParteComuneCompatibili = new ArrayList<AccordoServizioParteComune>();
                    }
                    asParteComuneCompatibili.add(accordoServizioParteComune);
                }
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la ricerca degli accordi parte comune compatibili", e);
            }
        }
        boolean apiImplementataCambiabile = ErogazioniUtilities.isChangeAPIEnabled(asps, this.apsCore);
        if (apiImplementataCambiabile) {
            ArrayList<Parameter> listParametersServizioModificaApi = new ArrayList<Parameter>();
            listParametersServizioModificaApi.addAll(listaParametriChange);
            listParametersServizioModificaApi.add(new Parameter("cambiaAPI", "true"));
            DataElementImage image = new DataElementImage();
            image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Cambia {0}", "API"));
            image.setImage("&#xE3C9;");
            image.setTarget(TargetType.SELF);
            de.addImage(image);
        }
        if (asParteComuneCompatibili != null && asParteComuneCompatibili.size() > 1) {
            ArrayList<Parameter> listParametersServizioModificaApi = new ArrayList<Parameter>();
            listParametersServizioModificaApi.addAll(listaParametriChange);
            listParametersServizioModificaApi.add(new Parameter("modificaAPI", "true"));
            DataElementImage image = new DataElementImage();
            image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaApi.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Aggiorna {0}", "Versione API"));
            image.setImage("&#xE3CA;");
            image.setTarget(TargetType.SELF);
            de.addImage(image);
        }
        DataElementImage image = new DataElementImage();
        image.setUrl("accordiServizioParteComuneApiChange.do", new Parameter[]{new Parameter("id", "" + asps.getIdAccordo()), new Parameter("nome", as.getNome()), pTipoAccordo});
        image.setToolTip(MessageFormat.format("Visualizza {0}", "API"));
        image.setImage("&#xE89E;");
        image.setTarget(TargetType.BLANK);
        image.setDisabilitaAjaxStatus();
        de.addImage(image);
        dati.add(de);
        if (showProtocolli || modificaDatiProfilo) {
            de = new DataElement();
            String labelProtocollo = this.getLabelProtocollo(protocollo);
            de.setLabel("Profilo Interoperabilit\u00e0");
            de.setValue(labelProtocollo);
            de.setType(DataElementType.TEXT);
            ArrayList<Parameter> listParametersServizioModificaProfilo = new ArrayList<Parameter>();
            if (gestioneFruitori) {
                listParametersServizioModificaProfilo.addAll(listParametersServizioFruitoriModificaProfiloOrVerificaCertificati);
            } else {
                listParametersServizioModificaProfilo.addAll(listParametersServizioModificaProfiloOrVerificaCertificati);
            }
            listParametersServizioModificaProfilo.add(new Parameter("modificaProfilo", "true"));
            if (modificaDatiProfilo) {
                image = new DataElementImage();
                if (gestioneFruitori) {
                    image.setUrl("accordiServizioParteSpecificaFruitoriChange.do", listParametersServizioModificaProfilo.toArray(new Parameter[1]));
                } else {
                    image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaProfilo.toArray(new Parameter[1]));
                }
                image.setToolTip(MessageFormat.format("Modifica {0}", "Profilo Interoperabilit\u00e0"));
                image.setImage("&#xE3C9;");
                de.addImage(image);
            }
            if (showVerificaCertificatiModi) {
                image = new DataElementImage();
                image.setUrl("aspsErogazioniVerificaCertificati.do", listParametersServizioModificaProfilo.toArray(new Parameter[1]));
                image.setToolTip(MessageFormat.format("Verifica {0}", "Profilo Interoperabilit\u00e0"));
                image.setImage("&#xEA17;");
                de.addImage(image);
            }
            dati.add(de);
        }
        if (showSoggettoFruitoreInFruizioni) {
            de = new DataElement();
            de.setLabel("Soggetto Fruitore");
            de.setValue(this.getLabelNomeSoggetto(protocollo, fruitore.getTipo(), fruitore.getNome()));
            de.setType(DataElementType.TEXT);
            dati.add(de);
        }
        if (!descrizioneEmpty) {
            Object descrizione;
            de = new DataElement();
            de.setLabel("Descrizione");
            int length = 150;
            Object object = descrizione = gestioneFruitori ? fruitore.getDescrizione() : asps.getDescrizione();
            if (descrizione != null && ((String)descrizione).length() > length) {
                descrizione = ((String)descrizione).substring(0, length - 4) + " ...";
            }
            de.setValue((String)descrizione);
            de.setToolTip(gestioneFruitori ? fruitore.getDescrizione() : asps.getDescrizione());
            de.setCopyToClipboard(gestioneFruitori ? fruitore.getDescrizione() : asps.getDescrizione());
            ArrayList<Parameter> listParametersServizioModificaDescrizione = new ArrayList<Parameter>();
            listParametersServizioModificaDescrizione.addAll(listaParametriChange);
            listParametersServizioModificaDescrizione.add(new Parameter("modificaDescrizione", "true"));
            image = new DataElementImage();
            image.setUrl("accordiServizioParteSpecificaChange.do", listParametersServizioModificaDescrizione.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Modifica {0}", "Descrizione"));
            image.setImage("&#xE3C9;");
            de.setImage(image);
            dati.add(de);
        }
        Parameter paIdSogg = null;
        Parameter paNomePorta = null;
        Parameter paIdPorta = null;
        Parameter paIdAsps = null;
        Parameter paConfigurazioneDati = null;
        Parameter paIdProvider = null;
        Parameter paIdPortaPerSA = null;
        Parameter paConnettoreDaListaAPS = null;
        Parameter paConfigurazioneAltroApi = null;
        IDPortaApplicativa idPA = null;
        PortaApplicativa paDefault = null;
        PortaApplicativaServizioApplicativo paSADefault = null;
        String canalePorta = null;
        if (gestioneErogatori) {
            boolean gestioneCanaliEnabled;
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
            de = new DataElement();
            de.setLabel("URL Invocazione");
            de.setType(DataElementType.TEXT);
            String urlInvocazione = "";
            String urlInvocazioneTooltip = null;
            if (!isPddEsterna) {
                idPA = this.porteApplicativeCore.getIDPortaApplicativaAssociataDefault(idServizio);
                paDefault = this.porteApplicativeCore.getPortaApplicativa(idPA);
                paSADefault = (PortaApplicativaServizioApplicativo)paDefault.getServizioApplicativoList().get(0);
                paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                paNomePorta = new Parameter("nomePorta", paDefault.getNome());
                paIdPorta = new Parameter("id", "" + paDefault.getId());
                paIdAsps = new Parameter("idAsps", "" + asps.getId());
                paConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
                paIdProvider = new Parameter("provider", "" + paDefault.getIdSoggetto());
                paIdPortaPerSA = new Parameter("idPorta", "" + paDefault.getId());
                paConnettoreDaListaAPS = new Parameter("connettoreDaListaAps", "true");
                paConfigurazioneAltroApi = new Parameter("configurazioneAltroApi", "true");
                boolean analizeProxyPassRules = true;
                UrlInvocazioneAPI urlInvocazioneConfig = this.confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_APPLICATIVA, serviceBinding, paDefault.getNome(), new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()), as, paDefault.getCanale(), analizeProxyPassRules);
                urlInvocazione = urlInvocazioneConfig.getUrl();
                UrlInvocazioneAPI urlInvocazioneConfigDefault = this.confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_APPLICATIVA, serviceBinding, paDefault.getNome(), new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()), as, paDefault.getCanale(), !analizeProxyPassRules);
                if (urlInvocazioneConfigDefault != null && urlInvocazioneConfigDefault.getUrl() != null && !urlInvocazioneConfigDefault.getUrl().equals(urlInvocazione)) {
                    urlInvocazioneTooltip = "Base URL interna: " + urlInvocazioneConfigDefault.getUrl();
                }
            } else {
                urlInvocazione = "-";
            }
            de.setValue(urlInvocazione);
            if (urlInvocazioneTooltip != null) {
                de.setToolTip(urlInvocazioneTooltip);
            }
            ArrayList<Parameter> listParametersUrlInvocazione = new ArrayList<Parameter>();
            listParametersUrlInvocazione.add(paIdSogg);
            listParametersUrlInvocazione.add(paNomePorta);
            listParametersUrlInvocazione.add(paIdPorta);
            listParametersUrlInvocazione.add(paIdAsps);
            listParametersUrlInvocazione.add(paConfigurazioneDati);
            image = new DataElementImage();
            image.setToolTip(MessageFormat.format("Modifica {0}", "URL Invocazione"));
            image.setImage("&#xE3C9;");
            image.setUrl("porteApplicativeChange.do", listParametersUrlInvocazione.toArray(new Parameter[1]));
            de.setImage(image);
            if (!urlInvocazione.equals("-")) {
                de.setCopyToClipboard(urlInvocazione);
            }
            dati.add(de);
            boolean visualizzaConnettore = true;
            boolean checkConnettore = false;
            boolean connettoreMultiploEnabled = false;
            long idConnettore = 1L;
            for (int i = 0; i < listaPorteApplicativeAssociate.size(); ++i) {
                PortaApplicativa paAssociata = listaPorteApplicativeAssociate.get(i);
                MappingErogazionePortaApplicativa mapping = listaMappingErogazionePortaApplicativa.get(i);
                if (!mapping.isDefault()) {
                    PortaApplicativaServizioApplicativo portaApplicativaAssociataServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0);
                    boolean connettoreConfigurazioneRidefinito = this.isConnettoreRidefinito(paDefault, paSADefault, paAssociata, portaApplicativaAssociataServizioApplicativo, paAssociata.getServizioApplicativoList());
                    if (!connettoreConfigurazioneRidefinito) continue;
                    visualizzaConnettore = false;
                    break;
                }
                canalePorta = paAssociata.getCanale();
            }
            if (visualizzaConnettore) {
                boolean visualizzaLinkCheckConnettore;
                boolean visualizzaLinkConfigurazioneConnettore;
                IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(paDefault.getTipoSoggettoProprietario(), paDefault.getNomeSoggettoProprietario()));
                idServizioApplicativo.setNome(paSADefault.getNome());
                ServizioApplicativo sa = this.saCore.getServizioApplicativo(idServizioApplicativo);
                org.openspcoop2.core.config.Connettore connettore = sa.getInvocazioneServizio().getConnettore();
                idConnettore = connettore.getId();
                checkConnettore = ConnettoreCheck.checkSupported((org.openspcoop2.core.config.Connettore)connettore);
                connettoreMultiploEnabled = paDefault.getBehaviour() != null;
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                InvocazioneServizio is = sa.getInvocazioneServizio();
                String urlConnettore = this.getLabelConnettore(sa, is, true);
                if (!connettoreMultiploEnabled) {
                    de.setLabel("Connettore");
                    de.setValue(this.formatInfoForView(urlConnettore));
                    String tooltipConnettore = this.getTooltipConnettore(sa, is, true);
                    de.setToolTip(tooltipConnettore);
                } else {
                    de.setLabel("Connettori");
                    de.setValue(this.getNomiConnettoriMultipliPortaApplicativa(paDefault));
                    de.setToolTip(this.getToolTipConnettoriMultipliPortaApplicativa(paDefault));
                }
                boolean bl = visualizzaLinkConfigurazioneConnettore = !this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled;
                if (visualizzaLinkConfigurazioneConnettore) {
                    ArrayList<Parameter> listParametersConnettore = new ArrayList<Parameter>();
                    listParametersConnettore.add(paIdProvider);
                    listParametersConnettore.add(paIdPortaPerSA);
                    listParametersConnettore.add(paIdAsps);
                    listParametersConnettore.add(new Parameter("nomeservizioApplicativo", paSADefault.getNome()));
                    listParametersConnettore.add(new Parameter("idsil", "" + paSADefault.getIdServizioApplicativo()));
                    listParametersConnettore.add(paConnettoreDaListaAPS);
                    image = new DataElementImage();
                    image.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                    image.setImage("&#xE3C9;");
                    image.setUrl("serviziApplicativiEndPointInvocazioneServizio.do", listParametersConnettore.toArray(new Parameter[1]));
                    de.addImage(image);
                }
                boolean bl2 = visualizzaLinkCheckConnettore = checkConnettore && (!this.core.isConnettoriMultipliEnabled() || !connettoreMultiploEnabled);
                if (visualizzaLinkCheckConnettore) {
                    ArrayList<Parameter> listParametersVerificaConnettore = new ArrayList<Parameter>();
                    paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                    listParametersVerificaConnettore.add(paIdSogg);
                    listParametersVerificaConnettore.add(paIdPorta);
                    listParametersVerificaConnettore.add(paIdAsps);
                    listParametersVerificaConnettore.add(paConnettoreDaListaAPS);
                    listParametersVerificaConnettore.add(new Parameter("connettoreId", "" + idConnettore));
                    listParametersVerificaConnettore.add(new Parameter("connettoreAccessoDaGruppi", "false"));
                    listParametersVerificaConnettore.add(new Parameter("connettoreRegistro", "false"));
                    image = new DataElementImage();
                    image.setToolTip(MessageFormat.format("Verifica {0}", "Connettivit\u00e0"));
                    image.setImage("&#xE8BE;");
                    image.setUrl("porteApplicativeVerificaConnettore.do", listParametersVerificaConnettore.toArray(new Parameter[1]));
                    de.addImage(image);
                }
                if (this.core.isConnettoriMultipliEnabled()) {
                    ArrayList<Parameter> listParametersConfigutazioneConnettoriMultipli = new ArrayList<Parameter>();
                    paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                    listParametersConfigutazioneConnettoriMultipli.add(paIdSogg);
                    listParametersConfigutazioneConnettoriMultipli.add(paIdPorta);
                    listParametersConfigutazioneConnettoriMultipli.add(paIdAsps);
                    listParametersConfigutazioneConnettoriMultipli.add(paConnettoreDaListaAPS);
                    listParametersConfigutazioneConnettoriMultipli.add(new Parameter("connettoreAccessoDaGruppi", "false"));
                    listParametersConfigutazioneConnettoriMultipli.add(new Parameter("connettoreRegistro", "false"));
                    listParametersConfigutazioneConnettoriMultipli.add(new Parameter("idConnTab", "0"));
                    image = new DataElementImage();
                    image.setToolTip("Configurazione Connettori Multipli");
                    image.setImage("&#xE8B8;");
                    image.setUrl("porteApplicativeConnettoriMultipliConfig.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                    de.addImage(image);
                    if (connettoreMultiploEnabled) {
                        image = new DataElementImage();
                        image.setToolTip("Elenco Connettori");
                        image.setImage("&#xE0EE;");
                        image.setUrl("porteApplicativeConnettoriMultipliList.do", listParametersConfigutazioneConnettoriMultipli.toArray(new Parameter[1]));
                        de.addImage(image);
                    }
                }
                de.setCopyToClipboard(this.getClipBoardUrlConnettore(sa, is));
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Gestione CORS");
            de.setType(DataElementType.TEXT);
            de.setValue(this.getStatoGestioneCorsPortaApplicativa(paDefault, false));
            if (!this.isModalitaCompleta()) {
                this.setStatoGestioneCORS(de, paDefault.getGestioneCors(), this.confCore.getConfigurazioneGenerale());
            }
            paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
            image = new DataElementImage();
            image.setToolTip(MessageFormat.format("Modifica {0}", "Gestione CORS"));
            image.setImage("&#xE3C9;");
            image.setUrl("porteApplicativeGestioneCors.do", new Parameter[]{paIdSogg, paIdPorta, pIdAsps});
            de.setImage(image);
            dati.add(de);
            CanaliConfigurazione gestioneCanali = this.confCore.getCanaliConfigurazione(false);
            boolean bl = gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            if (gestioneCanaliEnabled) {
                List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setLabel("Canale");
                this.setStatoCanalePorta(de, canalePorta, as.getCanale(), canaleList, true);
                image = new DataElementImage();
                image.setToolTip(MessageFormat.format("Modifica {0}", "Canale"));
                image.setImage("&#xE3C9;");
                image.setUrl("porteApplicativeGestioneCanale.do", new Parameter[]{paIdSogg, paIdPorta, pIdAsps});
                de.setImage(image);
                dati.add(de);
            }
            if (!this.isModalitaStandard() && this.apsCore.getMessageEngines() != null && !this.apsCore.getMessageEngines().isEmpty()) {
                de = new DataElement();
                de.setLabel("Opzioni Avanzate");
                de.setType(DataElementType.TEXT);
                de.setValue(this.getStatoOpzioniAvanzatePortaApplicativaDefault(paDefault));
                if (!this.isModalitaCompleta()) {
                    this.setStatoOpzioniAvanzatePortaApplicativaDefault(de, paDefault.getOptions());
                }
                paIdSogg = new Parameter("idsogg", "" + asps.getIdSoggetto());
                image = new DataElementImage();
                image.setToolTip(MessageFormat.format("Modifica {0}", "Opzioni Avanzate"));
                image.setImage("&#xE3C9;");
                image.setUrl("porteApplicativeChange.do", new Parameter[]{paIdSogg, paNomePorta, paIdPorta, pIdAsps, paConfigurazioneAltroApi});
                de.setImage(image);
                dati.add(de);
            }
            this.addProprietaOggetto(dati, pOggetto);
        }
        if (gestioneFruitori) {
            boolean gestioneCanaliEnabled;
            ServletUtils.setObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (Object)2, (String)"_tabKey_portaPar");
            IDSoggetto idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
            IDPortaDelegata idPD = this.porteDelegateCore.getIDPortaDelegataAssociataDefault(idServizio, idFruitore);
            PortaDelegata pdDefault = this.porteDelegateCore.getPortaDelegata(idPD);
            canalePorta = pdDefault.getCanale();
            Parameter pIdPD = new Parameter("id", "" + pdDefault.getId());
            Parameter pNomePD = new Parameter("nomePorta", pdDefault.getNome());
            Parameter pIdSoggPD = new Parameter("idsogg", "" + pdDefault.getIdSoggetto());
            Parameter pConfigurazioneDati = new Parameter("configurazioneDatiInvocazione", "true");
            Parameter pConnettoreDaListaAPS = new Parameter("connettoreDaListaAps", "true");
            Parameter pdConfigurazioneAltroApi = new Parameter("configurazioneAltroApi", "true");
            de = new DataElement();
            de.setLabel("URL Invocazione");
            de.setType(DataElementType.TEXT);
            boolean analizeProxyPassRules = true;
            UrlInvocazioneAPI urlInvocazione = this.confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_DELEGATA, serviceBinding, pdDefault.getNome(), idFruitore, as, pdDefault.getCanale(), analizeProxyPassRules);
            String urlInvocazioneAPI = urlInvocazione.getUrl();
            de.setValue(urlInvocazioneAPI);
            UrlInvocazioneAPI urlInvocazioneDefault = this.confCore.getConfigurazioneUrlInvocazione(protocollo, RuoloContesto.PORTA_DELEGATA, serviceBinding, pdDefault.getNome(), idFruitore, as, pdDefault.getCanale(), !analizeProxyPassRules);
            if (urlInvocazioneDefault != null && urlInvocazioneDefault.getUrl() != null && !urlInvocazioneDefault.getUrl().equals(urlInvocazioneAPI)) {
                de.setToolTip("Base URL interna: " + urlInvocazioneDefault.getUrl());
            }
            ArrayList<Parameter> listParametersUrlInvocazione = new ArrayList<Parameter>();
            listParametersUrlInvocazione.add(pIdPD);
            listParametersUrlInvocazione.add(pNomePD);
            listParametersUrlInvocazione.add(pIdSoggPD);
            listParametersUrlInvocazione.add(pIdAsps);
            listParametersUrlInvocazione.add(pIdFruitore);
            listParametersUrlInvocazione.add(pConfigurazioneDati);
            listParametersUrlInvocazione.add(pTipoSoggettoFruitore);
            listParametersUrlInvocazione.add(pNomeSoggettoFruitore);
            image = new DataElementImage();
            image.setUrl("porteDelegateChange.do", listParametersUrlInvocazione.toArray(new Parameter[1]));
            image.setToolTip(MessageFormat.format("Modifica {0}", "URL Invocazione"));
            image.setImage("&#xE3C9;");
            de.setImage(image);
            if (!urlInvocazioneAPI.equals("-")) {
                de.setCopyToClipboard(urlInvocazioneAPI);
            }
            dati.add(de);
            boolean visualizzaConnettore = true;
            boolean checkConnettore = false;
            long idConnettore = 1L;
            for (int i = 0; i < listaPorteDelegateAssociate.size(); ++i) {
                PortaDelegata pdAssociata = listaPorteDelegateAssociate.get(i);
                MappingFruizionePortaDelegata mapping = listaMappingFruzionePortaDelegata.get(i);
                List listaAzioni = null;
                if (!mapping.isDefault()) {
                    listaAzioni = pdAssociata.getAzione().getAzioneDelegataList();
                }
                String azioneConnettore = null;
                if (listaAzioni != null && !listaAzioni.isEmpty()) {
                    azioneConnettore = (String)listaAzioni.get(0);
                }
                boolean connettoreConfigurazioneRidefinito = false;
                if (azioneConnettore != null && !"".equals(azioneConnettore)) {
                    for (ConfigurazioneServizioAzione check : fruitore.getConfigurazioneAzioneList()) {
                        if (!check.getAzioneList().contains(azioneConnettore)) continue;
                        connettoreConfigurazioneRidefinito = true;
                        break;
                    }
                }
                if (!connettoreConfigurazioneRidefinito) continue;
                visualizzaConnettore = false;
                break;
            }
            if (visualizzaConnettore) {
                Connettore connettore = fruitore.getConnettore();
                idConnettore = connettore.getId();
                checkConnettore = ConnettoreCheck.checkSupported((Connettore)connettore);
            }
            if (visualizzaConnettore) {
                de = new DataElement();
                de.setLabel("Connettore");
                de.setType(DataElementType.TEXT);
                Connettore connettore = fruitore.getConnettore();
                String urlConnettore = this.getLabelConnettore(connettore, true, false);
                String tooltipConnettore = this.getLabelConnettore(connettore, true, true);
                boolean connettoreStatic = false;
                if (gestioneFruitori) {
                    connettoreStatic = this.apsCore.isConnettoreStatic(protocollo);
                }
                if (!connettoreStatic) {
                    de.setValue(this.formatInfoForView(urlConnettore));
                    de.setToolTip(tooltipConnettore);
                    de.setCopyToClipboard(this.getClipBoardUrlConnettore(connettore));
                    ArrayList<Parameter> listParametersConnettore = new ArrayList<Parameter>();
                    listParametersConnettore.add(pId);
                    listParametersConnettore.add(pIdFruitore);
                    listParametersConnettore.add(pIdSoggettoErogatore);
                    listParametersConnettore.add(pIdProviderFruitore);
                    listParametersConnettore.add(pConnettoreDaListaAPS);
                    listParametersConnettore.add(pTipoSoggettoFruitore);
                    listParametersConnettore.add(pNomeSoggettoFruitore);
                    image = new DataElementImage();
                    image.setToolTip(MessageFormat.format("Modifica {0}", "Connettore"));
                    image.setImage("&#xE3C9;");
                    image.setUrl("accordiServizioParteSpecificaFruitoriChange.do", listParametersConnettore.toArray(new Parameter[1]));
                    de.addImage(image);
                    if (checkConnettore) {
                        ArrayList<Parameter> listParametersVerificaConnettore = new ArrayList<Parameter>();
                        listParametersVerificaConnettore.add(pIdPD);
                        listParametersVerificaConnettore.add(pIdFruitore);
                        listParametersVerificaConnettore.add(pIdSoggettoErogatore);
                        listParametersVerificaConnettore.add(pIdProviderFruitore);
                        listParametersVerificaConnettore.add(pConnettoreDaListaAPS);
                        listParametersVerificaConnettore.add(pTipoSoggettoFruitore);
                        listParametersVerificaConnettore.add(pNomeSoggettoFruitore);
                        listParametersVerificaConnettore.add(pIdSoggPD);
                        listParametersVerificaConnettore.add(pIdAsps);
                        listParametersVerificaConnettore.add(new Parameter("connettoreId", "" + idConnettore));
                        listParametersVerificaConnettore.add(new Parameter("connettoreAccessoDaGruppi", "false"));
                        listParametersVerificaConnettore.add(new Parameter("connettoreRegistro", "true"));
                        image = new DataElementImage();
                        image.setToolTip(MessageFormat.format("Verifica {0}", "Connettivit\u00e0"));
                        image.setImage("&#xE8BE;");
                        image.setUrl("porteDelegateVerificaConnettore.do", listParametersVerificaConnettore.toArray(new Parameter[1]));
                        de.addImage(image);
                    }
                } else {
                    de.setValue("-");
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Gestione CORS");
            de.setType(DataElementType.TEXT);
            de.setValue(this.getStatoGestioneCorsPortaDelegata(pdDefault, false));
            if (!this.isModalitaCompleta()) {
                this.setStatoGestioneCORS(de, pdDefault.getGestioneCors(), this.confCore.getConfigurazioneGenerale());
            }
            image = new DataElementImage();
            image.setToolTip(MessageFormat.format("Modifica {0}", "Gestione CORS"));
            image.setImage("&#xE3C9;");
            image.setUrl("porteDelegateGestioneCors.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore});
            de.setImage(image);
            dati.add(de);
            CanaliConfigurazione gestioneCanali = this.confCore.getCanaliConfigurazione(false);
            boolean bl = gestioneCanaliEnabled = gestioneCanali != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneCanali.getStato());
            if (gestioneCanaliEnabled) {
                List canaleList = gestioneCanali != null ? gestioneCanali.getCanaleList() : new ArrayList();
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setLabel("Canale");
                this.setStatoCanalePorta(de, canalePorta, as.getCanale(), canaleList, false);
                image = new DataElementImage();
                image.setToolTip(MessageFormat.format("Modifica {0}", "Canale"));
                image.setImage("&#xE3C9;");
                image.setUrl("porteDelegateGestioneCanale.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore});
                de.setImage(image);
                dati.add(de);
            }
            if (!this.isModalitaStandard() && this.apsCore.getMessageEngines() != null && !this.apsCore.getMessageEngines().isEmpty()) {
                de = new DataElement();
                de.setLabel("Opzioni Avanzate");
                de.setType(DataElementType.TEXT);
                de.setValue(this.getStatoOpzioniAvanzatePortaDelegataDefault(pdDefault));
                if (!this.isModalitaCompleta()) {
                    this.setStatoOpzioniAvanzatePortaDelegataDefault(de, pdDefault.getOptions());
                }
                image = new DataElementImage();
                image.setToolTip(MessageFormat.format("Modifica {0}", "Opzioni Avanzate"));
                image.setImage("&#xE3C9;");
                image.setUrl("porteDelegateChange.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pdConfigurazioneAltroApi});
                de.setImage(image);
                dati.add(de);
            }
            this.addProprietaOggetto(dati, pOggetto);
        }
        Parameter pGruppiTrue = new Parameter("gestioneGruppi", "true");
        Parameter pGruppiFalse = new Parameter("gestioneGruppi", "false");
        Parameter pConfigurazioneTrue = new Parameter("gestioneConfigurazioni", "true");
        Parameter pConfigurazioneFalse = new Parameter("gestioneConfigurazioni", "false");
        boolean visualizzazioneTabs = !this.isModalitaCompleta();
        Parameter pIdTab = new Parameter("idTab", "0");
        de = new DataElement();
        de.setType(DataElementType.LINK);
        if (gestioneErogatori) {
            de.setUrl("accordiServizioParteSpecificaPorteApplicativeList.do", new Parameter[]{pId, pNomeServizio, pTipoServizio, pIdSoggettoErogatore, pConfigurazioneTrue, pGruppiFalse, pIdTab});
        }
        if (gestioneFruitori) {
            de.setUrl("accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{pId, pIdSogg, pIdSoggettoErogatore, pNomeServizio, pTipoServizio, pIdFruitore, pConfigurazioneTrue, pGruppiFalse, pTipoSoggettoFruitore, pNomeSoggettoFruitore, pIdTab});
        }
        if (visualizzazioneTabs) {
            de.setValue("Configura");
        } else {
            de.setValue("Configurazione");
        }
        de.setIcon("&#xE8B8;");
        dati.add(de);
        if (!visualizzazioneTabs) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            if (gestioneErogatori) {
                de.setUrl("accordiServizioParteSpecificaPorteApplicativeList.do", new Parameter[]{pId, pNomeServizio, pTipoServizio, pIdSoggettoErogatore, pConfigurazioneFalse, pGruppiTrue});
            }
            if (gestioneFruitori) {
                de.setUrl("accordiServizioParteSpecificaFruitoriPorteDelegateList.do", new Parameter[]{pId, pIdSogg, pIdSoggettoErogatore, pNomeServizio, pTipoServizio, pIdFruitore, pConfigurazioneFalse, pGruppiTrue, pTipoSoggettoFruitore, pNomeSoggettoFruitore});
            }
            de.setValue(MessageFormat.format("Gruppi", this.getLabelAzioni(serviceBinding)));
            de.setIcon("&#xE02F;");
            dati.add(de);
        }
        if (visualizzaGruppi) {
            this.aggiungiListaConfigurazioni(datiPagina, serviceBinding, gestioneErogatori, listaMappingErogazionePortaApplicativa, listaPorteApplicativeAssociate, listaMappingFruzionePortaDelegata, listaPorteDelegateAssociate, pIdAsps, pIdFruitore, asps, as);
        }
        return datiPagina;
    }

    private void aggiungiListaConfigurazioni(List<List<DataElement>> datiPagina, org.openspcoop2.message.constants.ServiceBinding serviceBinding, boolean gestioneErogatori, List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa, List<PortaApplicativa> listaPorteApplicativeAssociate, List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata, List<PortaDelegata> listaPorteDelegateAssociate, Parameter pIdAsps, Parameter pIdFruitore, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as) throws Exception {
        Map<String, String> azioni = this.core.getAzioniConLabel(asps, as, false, true, new ArrayList<String>());
        boolean allActionRedefined = false;
        PropertiesSourceConfiguration propertiesSourceConfiguration = this.core.getMessageSecurityPropertiesSourceConfiguration();
        ConfigManager configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
        configManager.leggiConfigurazioni(propertiesSourceConfiguration, true);
        DataElement de = null;
        if (gestioneErogatori) {
            boolean visualizzaMTOM = true;
            boolean visualizzaSicurezza = true;
            boolean visualizzaCorrelazione = true;
            switch (serviceBinding) {
                case REST: {
                    visualizzaMTOM = false;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                    break;
                }
                default: {
                    visualizzaMTOM = true;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                }
            }
            if (azioni != null && azioni.size() > 1) {
                ArrayList<String> azioniL = new ArrayList<String>();
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                allActionRedefined = this.allActionsRedefinedMappingErogazionePaAssociate(azioniL, listaPorteApplicativeAssociate);
            }
            for (int d = 0; d < listaMappingErogazionePortaApplicativa.size(); ++d) {
                DataElement deTmp;
                MappingErogazionePortaApplicativa mapping = listaMappingErogazionePortaApplicativa.get(d);
                PortaApplicativa paAssociata = listaPorteApplicativeAssociate.get(d);
                boolean showConfigurazione = !mapping.isDefault() || !allActionRedefined;
                int numeroConfigurazioniAttive = 0;
                ArrayList<String> labelDisponibili = new ArrayList<String>();
                ArrayList<String> urlDisponibili = new ArrayList<String>();
                if (!showConfigurazione) continue;
                ArrayList<DataElement> gruppoList = new ArrayList<DataElement>();
                Parameter pNomePorta = new Parameter("nomePorta", paAssociata.getNome());
                Parameter pIdNome = new Parameter("nome", paAssociata.getNome());
                Parameter pIdSoggPA = new Parameter("idsogg", "" + paAssociata.getIdSoggetto());
                Parameter pIdPorta = new Parameter("id", "" + paAssociata.getId());
                Parameter pIdProvider = new Parameter("provider", "" + paAssociata.getIdSoggetto());
                Parameter pIdPortaPerSA = new Parameter("idPorta", "" + paAssociata.getId());
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel(mapping.getDescrizione());
                gruppoList.add(de);
                boolean controlloAccessiAbilitato = false;
                String statoControlloAccessi = this.getStatoControlloAccessiPortaApplicativa(this.apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo()), paAssociata);
                if (statoControlloAccessi.equals("abilitato")) {
                    controlloAccessiAbilitato = true;
                    ++numeroConfigurazioniAttive;
                } else {
                    labelDisponibili.add("Controllo Accessi");
                    DataElement deTmp2 = new DataElement();
                    deTmp2.setUrl("porteApplicativeControlloAccessi.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    urlDisponibili.add(deTmp2.getUrl());
                }
                if (controlloAccessiAbilitato) {
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Controllo Accessi");
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Autenticazione Token");
                    de.setValue(this.getStatoGestioneTokenPortaApplicativa(paAssociata));
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Autenticazione");
                    de.setValue(this.getStatoAutenticazionePortaApplicativa(paAssociata));
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Autorizzazione");
                    de.setValue(this.getStatoAutorizzazionePortaApplicativa(paAssociata));
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.BUTTON);
                    de.setUrl("porteApplicativeControlloAccessi.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    de.setValue("&#xE3C9;");
                    de.setToolTip("Modifica");
                    gruppoList.add(de);
                }
                boolean validazioneContenutiAbilitato = false;
                String statoValidazione = this.getStatoValidazionePortaApplicativa(paAssociata);
                if (!statoValidazione.equals(PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO)) {
                    validazioneContenutiAbilitato = true;
                    ++numeroConfigurazioniAttive;
                } else {
                    labelDisponibili.add("Validazione");
                    DataElement deTmp3 = new DataElement();
                    deTmp3.setUrl("porteApplicativeValidazioneContenuti.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    urlDisponibili.add(deTmp3.getUrl());
                }
                if (validazioneContenutiAbilitato) {
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Validazione");
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Stato");
                    de.setValue(statoValidazione);
                    gruppoList.add(de);
                    String tipoValidazione = this.getTipoValidazionePortaApplicativa(paAssociata);
                    if (tipoValidazione != null) {
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Tipo");
                        de.setValue(tipoValidazione);
                        gruppoList.add(de);
                    }
                    de = new DataElement();
                    de.setType(DataElementType.BUTTON);
                    de.setUrl("porteApplicativeValidazioneContenuti.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    de.setValue("&#xE3C9;");
                    de.setToolTip("Modifica");
                    gruppoList.add(de);
                }
                if (visualizzaSicurezza) {
                    boolean controlloMessageSecurityAbilitato = false;
                    String statoMessageSecurity = this.getStatoMessageSecurityPortaApplicativa(paAssociata);
                    if (statoMessageSecurity.equals(CostantiConfigurazione.ABILITATO.toString())) {
                        controlloMessageSecurityAbilitato = true;
                        ++numeroConfigurazioniAttive;
                    } else {
                        labelDisponibili.add("Sicurezza Messaggio");
                        deTmp = new DataElement();
                        deTmp.setUrl("porteApplicativeWS.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                        urlDisponibili.add(deTmp.getUrl());
                    }
                    if (controlloMessageSecurityAbilitato) {
                        Config configurazione;
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Sicurezza Messaggio");
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Stato");
                        de.setValue(statoMessageSecurity);
                        gruppoList.add(de);
                        MessageSecurity messageSecurity = paAssociata.getMessageSecurity();
                        String requestMode = null;
                        String responseMode = null;
                        if (messageSecurity != null) {
                            if (messageSecurity.getRequestFlow() != null) {
                                requestMode = messageSecurity.getRequestFlow().getMode();
                            }
                            if (messageSecurity.getResponseFlow() != null) {
                                responseMode = messageSecurity.getResponseFlow().getMode();
                            }
                        }
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Richiesta");
                        if (StringUtils.isNotEmpty((String)requestMode)) {
                            if (requestMode.equals("default")) {
                                de.setValue("Configurazione Manuale");
                            } else {
                                configurazione = configManager.getConfigurazione(propertiesSourceConfiguration, requestMode);
                                de.setValue(configurazione.getLabel());
                            }
                        } else {
                            de.setValue("Nessuno");
                        }
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Risposta");
                        if (StringUtils.isNotEmpty((String)responseMode)) {
                            if (responseMode.equals("default")) {
                                de.setValue("Configurazione Manuale");
                            } else {
                                configurazione = configManager.getConfigurazione(propertiesSourceConfiguration, responseMode);
                                de.setValue(configurazione.getLabel());
                            }
                        } else {
                            de.setValue("Nessuno");
                        }
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.BUTTON);
                        de.setUrl("porteApplicativeWS.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                        de.setValue("&#xE3C9;");
                        de.setToolTip("Modifica");
                        gruppoList.add(de);
                    }
                }
                if (visualizzaMTOM) {
                    boolean controlloMTOMAbilitato = false;
                    String statoMTOM = this.getStatoMTOMPortaApplicativa(paAssociata);
                    if ("abilitato".equals(statoMTOM)) {
                        controlloMTOMAbilitato = true;
                        ++numeroConfigurazioniAttive;
                    } else {
                        labelDisponibili.add("MTOM");
                        deTmp = new DataElement();
                        deTmp.setUrl("porteApplicativeMTOM.do", new Parameter[]{pIdPorta, pIdSoggPA, pIdAsps});
                        urlDisponibili.add(deTmp.getUrl());
                    }
                    if (controlloMTOMAbilitato) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("MTOM");
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Stato");
                        de.setValue("abilitato");
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Richiesta");
                        MTOMProcessorType modeReq = this.getProcessorTypeRequestMTOMPortaApplicativa(paAssociata);
                        if (modeReq != null) {
                            de.setValue(modeReq.getValue());
                        } else {
                            de.setValue(MTOMProcessorType.DISABLE.getValue());
                        }
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.TEXT);
                        de.setLabel("Risposta");
                        MTOMProcessorType modeRes = this.getProcessorTypeResponseMTOMPortaApplicativa(paAssociata);
                        if (modeRes != null) {
                            de.setValue(modeRes.getValue());
                        } else {
                            de.setValue(MTOMProcessorType.DISABLE.getValue());
                        }
                        gruppoList.add(de);
                        de = new DataElement();
                        de.setType(DataElementType.BUTTON);
                        de.setUrl("porteApplicativeMTOM.do", new Parameter[]{pIdPorta, pIdSoggPA, pIdAsps});
                        de.setValue("&#xE3C9;");
                        de.setToolTip("Modifica");
                        gruppoList.add(de);
                    }
                }
                if (visualizzaCorrelazione) {
                    boolean tracciamentoAbilitato = false;
                    String statoTracciamento = this.getStatoTracciamentoPortaApplicativa(paAssociata);
                    if ("abilitato".equals(statoTracciamento)) {
                        tracciamentoAbilitato = true;
                        ++numeroConfigurazioniAttive;
                    } else {
                        labelDisponibili.add("Tracciamento");
                        deTmp = new DataElement();
                        deTmp.setUrl("porteApplicativeCorrelazioneApplicativa.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdNome, pIdAsps});
                        urlDisponibili.add(deTmp.getUrl());
                    }
                    if (tracciamentoAbilitato) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Tracciamento");
                        gruppoList.add(de);
                        if (this.isRidefinitoTransazioniRegistratePortaApplicativa(paAssociata)) {
                            de = new DataElement();
                            de.setType(DataElementType.TEXT);
                            de.setLabel("Transazioni Registrate");
                            de.setValue(this.getStatoTransazioniRegistratePortaApplicativa(paAssociata));
                            gruppoList.add(de);
                        }
                        if (this.isRidefinitoMessaggiDiagnosticiPortaApplicativa(paAssociata)) {
                            de = new DataElement();
                            de.setType(DataElementType.TEXT);
                            de.setLabel("Messaggi Diagnostici");
                            de.setValue(this.getStatoMessaggiDiagnosticiPortaApplicativa(paAssociata));
                            gruppoList.add(de);
                        }
                        if (this.isEnabledCorrelazioneApplicativaPortaApplicativa(paAssociata)) {
                            de = new DataElement();
                            de.setType(DataElementType.TEXT);
                            de.setLabel("Correlazione Applicativa");
                            de.setValue(this.getStatoCorrelazioneApplicativaPortaApplicativa(paAssociata));
                            gruppoList.add(de);
                        }
                        de = new DataElement();
                        de.setType(DataElementType.BUTTON);
                        de.setUrl("porteApplicativeCorrelazioneApplicativa.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdNome, pIdAsps});
                        de.setValue("&#xE3C9;");
                        de.setToolTip("Modifica");
                        gruppoList.add(de);
                    }
                }
                boolean controlloDumpAbilitato = false;
                String statoDump = this.getStatoDumpPortaApplicativa(paAssociata, true);
                if (!statoDump.startsWith("default")) {
                    controlloDumpAbilitato = true;
                    ++numeroConfigurazioniAttive;
                } else {
                    labelDisponibili.add("Registrazione Messaggi");
                    deTmp = new DataElement();
                    deTmp.setUrl("porteApplicativeDumpConfigurazione.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    urlDisponibili.add(deTmp.getUrl());
                }
                if (controlloDumpAbilitato) {
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Registrazione Messaggi");
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Richiesta");
                    de.setValue(this.getStatoDumpRichiestaPortaApplicativa(paAssociata, true));
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setLabel("Risposta");
                    de.setValue(this.getStatoDumpRispostaPortaApplicativa(paAssociata, true));
                    gruppoList.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.BUTTON);
                    de.setUrl("porteApplicativeDumpConfigurazione.do", new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                    de.setValue("&#xE3C9;");
                    de.setToolTip("Modifica");
                    gruppoList.add(de);
                }
                if (!mapping.isDefault()) {
                    PortaApplicativaServizioApplicativo portaApplicativaAssociataServizioApplicativo = (PortaApplicativaServizioApplicativo)paAssociata.getServizioApplicativoList().get(0);
                    boolean connettoreConfigurazioneRidefinito = portaApplicativaAssociataServizioApplicativo.getNome().equals(paAssociata.getNome());
                    String servletConnettore = "porteApplicativeConnettoreDefault.do";
                    if (connettoreConfigurazioneRidefinito) {
                        servletConnettore = "porteApplicativeConnettoreRidefinito.do";
                        ++numeroConfigurazioniAttive;
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Connettore");
                        gruppoList.add(de);
                        ServizioApplicativo sa = this.saCore.getServizioApplicativo(portaApplicativaAssociataServizioApplicativo.getIdServizioApplicativo());
                        InvocazioneServizio is = sa.getInvocazioneServizio();
                        org.openspcoop2.core.config.Connettore connis = is.getConnettore();
                        String endpointtype = "";
                        endpointtype = connis.getCustom() != null && connis.getCustom() != false && !connis.getTipo().equals(TipiConnettore.HTTPS.toString()) && !connis.getTipo().equals(TipiConnettore.FILE.toString()) && !connis.getTipo().equals(TipiConnettore.STATUS.toString()) ? TipiConnettore.CUSTOM.toString() : connis.getTipo();
                        if (StringUtils.isNotEmpty((String)endpointtype)) {
                            de = new DataElement();
                            de.setType(DataElementType.TEXT);
                            de.setLabel("Tipo");
                            de.setValue(endpointtype);
                            gruppoList.add(de);
                        }
                        List cp = connis.getPropertyList();
                        String urlConnettore = "";
                        for (int i = 0; i < connis.sizePropertyList(); ++i) {
                            Property singlecp = (Property)cp.get(i);
                            if (!singlecp.getNome().equals("location")) continue;
                            urlConnettore = singlecp.getValore();
                            break;
                        }
                        if (StringUtils.isNotEmpty((String)urlConnettore)) {
                            de = new DataElement();
                            de.setType(DataElementType.TEXT);
                            de.setLabel("Endpoint");
                            de.setValue((String)(urlConnettore.length() > 20 ? urlConnettore.substring(0, 17) + "..." : urlConnettore));
                            de.setToolTip(urlConnettore);
                            gruppoList.add(de);
                        }
                        de = new DataElement();
                        de.setType(DataElementType.BUTTON);
                        de.setUrl(servletConnettore, new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                        de.setValue("&#xE3C9;");
                        de.setToolTip("Modifica");
                        gruppoList.add(de);
                    } else {
                        labelDisponibili.add("Connettore");
                        DataElement deTmp4 = new DataElement();
                        deTmp4.setUrl(servletConnettore, new Parameter[]{pIdSoggPA, pIdPorta, pIdAsps});
                        urlDisponibili.add(deTmp4.getUrl());
                    }
                }
                if (this.isModalitaAvanzata()) {
                    // empty if block
                }
                de = new DataElement();
                de.setType(DataElementType.CHECKBOX);
                boolean statoPA = paAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                String statoMapping = statoPA ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                de.setToolTip(statoMapping);
                de.setSelected(statoPA);
                de.setIcon("Abilita Configurazione");
                Parameter pAbilita = new Parameter("abilita", statoPA ? "no" : "true");
                de.setUrl("porteApplicativeAbilitazione.do", new Parameter[]{pIdSoggPA, pNomePorta, pIdPorta, pIdAsps, pAbilita});
                gruppoList.add(de);
                de = new DataElement();
                de.setName("nuovaConf_" + d);
                de.setLabel("Configurazione");
                if (!labelDisponibili.isEmpty()) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(urlDisponibili);
                    de.setLabels(labelDisponibili);
                    de.setSelected((String)urlDisponibili.get(0));
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                gruppoList.add(de);
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("nConfAttive");
                de.setValue("" + numeroConfigurazioniAttive);
                gruppoList.add(0, de);
                int numeroConfigurazioniDisponibili = labelDisponibili.size();
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("nConfDisponibili");
                de.setValue("" + numeroConfigurazioniDisponibili);
                gruppoList.add(0, de);
                datiPagina.add(gruppoList);
            }
        } else {
            boolean visualizzaMTOM = true;
            boolean visualizzaSicurezza = true;
            boolean visualizzaCorrelazione = true;
            switch (serviceBinding) {
                case REST: {
                    visualizzaMTOM = false;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                    break;
                }
                default: {
                    visualizzaMTOM = true;
                    visualizzaSicurezza = true;
                    visualizzaCorrelazione = true;
                }
            }
            if (azioni != null && azioni.size() > 1) {
                ArrayList<String> azioniL = new ArrayList<String>();
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                allActionRedefined = this.allActionsRedefinedMappingFruizionePdAssociate(azioniL, listaPorteDelegateAssociate);
            }
            for (int d = 0; d < listaMappingFruzionePortaDelegata.size(); ++d) {
                MappingFruizionePortaDelegata mapping = listaMappingFruzionePortaDelegata.get(d);
                PortaDelegata pdAssociata = listaPorteDelegateAssociate.get(d);
                boolean showConfigurazione = !mapping.isDefault() || !allActionRedefined;
                int numeroConfigurazioniDisponibili = 1;
                int numeroConfigurazioniAttive = 0;
                if (!showConfigurazione) continue;
                ArrayList<DataElement> gruppoList = new ArrayList<DataElement>();
                Parameter pIdPD = new Parameter("id", "" + pdAssociata.getId());
                Parameter pNomePD = new Parameter("nomePorta", pdAssociata.getNome());
                Parameter pIdSoggPD = new Parameter("idsogg", "" + pdAssociata.getIdSoggetto());
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel(mapping.getDescrizione());
                gruppoList.add(de);
                de = new DataElement();
                de.setType(DataElementType.CHECKBOX);
                boolean statoPD = pdAssociata.getStato().equals((Object)StatoFunzionalita.ABILITATO);
                String statoMapping = statoPD ? "Configurazione abilitata (Clicca per disabilitare)" : "Configurazione disabilitata (Clicca per abilitare)";
                de.setToolTip(statoMapping);
                de.setSelected(statoPD);
                de.setIcon("Abilita Configurazione");
                Parameter pAbilita = new Parameter("abilita", statoPD ? "no" : "true");
                de.setUrl("porteDelegateAbilitazione.do", new Parameter[]{pIdPD, pNomePD, pIdSoggPD, pIdAsps, pIdFruitore, pAbilita});
                gruppoList.add(de);
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("nConfAttive");
                de.setValue("" + numeroConfigurazioniAttive);
                gruppoList.add(0, de);
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("nConfDisponibili");
                de.setValue("" + numeroConfigurazioniDisponibili);
                gruppoList.add(0, de);
                datiPagina.add(gruppoList);
            }
        }
    }

    public void prepareErogazioneChange(TipoOperazione tipoOp, AccordoServizioParteSpecifica asps, IDSoggetto idSoggettoFruitore) throws Exception {
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        boolean gestioneErogatori = false;
        if (tipologia != null) {
            if ("fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            } else if ("erogazione".equals(tipologia)) {
                gestioneErogatori = true;
            }
        }
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        String tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
        AccordoServizioParteComuneSintetico as = this.apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
        org.openspcoop2.message.constants.ServiceBinding serviceBinding = this.apcCore.toMessageServiceBinding(as.getServiceBinding());
        String tmpTitle = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        List<Object> listaMappingErogazionePortaApplicativa = new ArrayList();
        ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
        if (gestioneErogatori) {
            listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : listaMappingErogazionePortaApplicativa) {
                listaPorteApplicativeAssociate.add(this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa()));
            }
        }
        List<Object> listaMappingFruzionePortaDelegata = new ArrayList();
        ArrayList<PortaDelegata> arrayList = new ArrayList<PortaDelegata>();
        Fruitore fruitore = null;
        if (gestioneFruitori) {
            for (Fruitore fruitore2 : asps.getFruitoreList()) {
                if (!fruitore2.getTipo().equals(idSoggettoFruitore.getTipo()) || !fruitore2.getNome().equals(idSoggettoFruitore.getNome())) continue;
                fruitore = fruitore2;
                break;
            }
            if (fruitore != null) {
                listaMappingFruzionePortaDelegata = this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : listaMappingFruzionePortaDelegata) {
                    arrayList.add(this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata()));
                }
            }
        }
        this.makeMenu();
        ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
        if (gestioneFruitori) {
            lstParm.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
        } else {
            lstParm.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
        }
        lstParm.add(new Parameter(tmpTitle, null));
        ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
        ArrayList<List<DataElement>> arrayList2 = new ArrayList<List<DataElement>>();
        ArrayList<DataElement> dati = new ArrayList<DataElement>();
        arrayList2.add(dati);
        dati.add(ServletUtils.getDataElementForEditModeFinished());
        String fromAPIPageInfo = this.getParameter("fromApiPageInfo");
        boolean fromApi = "true".equalsIgnoreCase(fromAPIPageInfo);
        if (fromApi) {
            DataElement de = new DataElement();
            de.setValue(fromAPIPageInfo);
            de.setType(DataElementType.HIDDEN);
            de.setName("fromApiPageInfo");
            dati.add(de);
            String nomePorta = this.getParameter("nomePorta");
            de = new DataElement();
            de.setValue(nomePorta);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomePorta");
            dati.add(de);
            String abilita = this.getParameter("abilita");
            de = new DataElement();
            de.setValue(abilita);
            de.setType(DataElementType.HIDDEN);
            de.setName("abilita");
            dati.add(de);
            String idsogg = this.getParameter("idsogg");
            String id = this.getParameter("id");
            String idFruizione = null;
            String tipoSoggettoFruitore = null;
            String nomeSoggettoFruitore = null;
            if (fruitore != null) {
                idFruizione = "" + fruitore.getId();
                tipoSoggettoFruitore = fruitore.getTipo();
                nomeSoggettoFruitore = fruitore.getNome();
            }
            this.addHiddenFieldsToDati(tipoOp, id, idsogg, id, "" + asps.getId(), idFruizione, tipoSoggettoFruitore, nomeSoggettoFruitore, dati);
        } else {
            this.addHiddenFieldsToDati(tipoOp, "" + asps.getId(), null, null, dati);
        }
        List<List<DataElement>> list = this.addErogazioneToDati(arrayList2, tipoOp, asps, as, tipoProtocollo, serviceBinding, gestioneErogatori, gestioneFruitori, listaMappingErogazionePortaApplicativa, listaPorteApplicativeAssociate, listaMappingFruzionePortaDelegata, arrayList, fruitore);
        this.pd.setDati(list);
        this.pd.disableEditMode();
    }

    public ActionForward prepareErogazioneChangeResetCache(ActionMapping mapping, GeneralData gd, ConsoleSearch ricerca, TipoOperazione tipoOp, AccordoServizioParteSpecifica asps, IDSoggetto idSoggettoFruitore) throws Exception {
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        boolean gestioneErogatori = false;
        if (tipologia != null) {
            if ("fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            } else if ("erogazione".equals(tipologia)) {
                gestioneErogatori = true;
            }
        }
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        String tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
        String tmpTitle = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        ArrayList<PortaApplicativa> listaPorteApplicativeAssociate = new ArrayList<PortaApplicativa>();
        if (gestioneErogatori) {
            List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            for (MappingErogazionePortaApplicativa mappinErogazione : listaMappingErogazionePortaApplicativa) {
                listaPorteApplicativeAssociate.add(this.porteApplicativeCore.getPortaApplicativa(mappinErogazione.getIdPortaApplicativa()));
            }
        }
        ArrayList<PortaDelegata> listaPorteDelegateAssociate = new ArrayList<PortaDelegata>();
        Object fruitore = null;
        if (gestioneFruitori) {
            for (Object check : asps.getFruitoreList()) {
                if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                fruitore = check;
                break;
            }
            if (fruitore != null) {
                List<MappingFruizionePortaDelegata> listaMappingFruzionePortaDelegata = this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruzionePortaDelegata) {
                    listaPorteDelegateAssociate.add(this.porteDelegateCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata()));
                }
            }
        }
        this.makeMenu();
        ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
        if (gestioneFruitori) {
            lstParm.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
        } else {
            lstParm.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
        }
        lstParm.add(new Parameter(tmpTitle, null));
        ServletUtils.setPageDataTitle((PageData)this.pd, lstParm);
        String labelServizio = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        this.eseguiResetCacheAspsOFruitore(asps, gestioneFruitori, (Fruitore)fruitore, labelServizio);
        String resetElementoCacheS = this.getParameter("rmElFromCache");
        boolean resetElementoCache = ServletUtils.isCheckBoxEnabled((String)resetElementoCacheS);
        if (resetElementoCache) {
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
            int idLista = Liste.SERVIZI;
            List<AccordoServizioParteSpecifica> lista = null;
            if (!ServletUtils.isSearchDone((IConsoleHelper)this)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)this.request, (HttpSession)this.session, (int)idLista, AccordoServizioParteSpecifica.class);
            }
            ricerca = this.checkSearchParameters(idLista, ricerca);
            this.clearFiltroSoggettoByPostBackProtocollo(0, (ISearch)ricerca, idLista);
            this.checkGestione(this.request, this.session, ricerca, idLista, tipologia, true);
            boolean[] permessi = AccordiServizioParteSpecificaUtilities.getPermessiUtente(this);
            if (lista == null) {
                lista = this.apsCore.isVisioneOggettiGlobale(userLogin) ? this.apsCore.soggettiServizioList(null, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori) : this.apsCore.soggettiServizioList(userLogin, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori);
            }
            if (!this.isPostBackFilterElement()) {
                ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (int)idLista, (List)lista);
            }
            this.prepareErogazioniList((ISearch)ricerca, lista);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (GeneralData)gd, (PageData)this.pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"aspsErogazioni", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_RESET_CACHE_ELEMENTO);
        }
        this.prepareErogazioneChange(tipoOp, asps, idSoggettoFruitore);
        ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (GeneralData)gd, (PageData)this.pd);
        return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"aspsErogazioni", (ForwardParams)ForwardParams.CHANGE());
    }

    public void eseguiResetCacheAspsOFruitore(AccordoServizioParteSpecifica asps, boolean gestioneFruitori, Fruitore fruitore, String labelServizio) throws DriverControlStationException, DriverControlStationNotFound {
        List<String> aliases = this.apcCore.getJmxPdDAliases();
        String alias = null;
        if (aliases != null && !aliases.isEmpty()) {
            alias = aliases.get(0);
        }
        long idOjectLong = -1L;
        if (gestioneFruitori) {
            if (fruitore == null) {
                throw new DriverControlStationException("Fruitore non trovato");
            }
            idOjectLong = fruitore.getId();
        } else {
            idOjectLong = asps.getId();
        }
        this.apcCore.invokeJmxMethodAllNodesAndSetResult(this.pd, this.apcCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), gestioneFruitori ? this.apcCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheFruizione(alias) : this.apcCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheErogazione(alias), MessageFormat.format("{0} eliminato dalla cache", labelServizio), MessageFormat.format("Eliminazione {0} dalla cache non riuscita: ", labelServizio), idOjectLong);
    }

    public void eseguiResetCacheAspsOFruitore() throws DriverControlStationException, DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverControlStationNotFound {
        String id = this.getParameter("id");
        long idInt = Long.parseLong(id);
        AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(idInt);
        String tipoSoggettoFruitore = this.getParameter("tipoSoggFru");
        String nomeSoggettoFruitore = this.getParameter("nomeSoggFru");
        IDSoggetto idSoggettoFruitore = null;
        if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
            idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
        }
        String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
        boolean gestioneFruitori = false;
        if (tipologia != null && "fruizione".equals(tipologia)) {
            gestioneFruitori = true;
        }
        Fruitore fruitore = null;
        if (gestioneFruitori && idSoggettoFruitore != null) {
            for (Fruitore check : asps.getFruitoreList()) {
                if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                fruitore = check;
                break;
            }
        }
        IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        String tipoProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
        String labelServizio = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        this.eseguiResetCacheAspsOFruitore(asps, gestioneFruitori, fruitore, labelServizio);
    }

    public boolean estraiElencoInvocazioni(boolean soloModI, AccordoServizioParteSpecifica asps, IDSoggetto idSoggettoFruitore, boolean gestioneFruitori, Fruitore fruitore, IDServizio idServizio, String tipoProtocollo, String nomeApiImpl, List<String> listConnettoriRegistrati, List<String> listPosizioneConnettoriRegistrati, List<Connettore> listConnettoriRegistry, List<org.openspcoop2.core.config.Connettore> listConnettoriConfig, List<String> listTokenPolicyValidazione, List<GestioneToken> listTokenPolicyValidazioneConf, List<String> listPosizioneTokenPolicyValidazione, List<String> listTokenPolicyNegoziazione, List<String> listPosizioneTokenPolicyNegoziazione, List<String> listAttributeAuthority, List<String> listPosizioneAttributeAuthority) throws ProtocolException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean findConnettoreHttpConPrefissoHttps;
        block23: {
            findConnettoreHttpConPrefissoHttps = false;
            if (soloModI) break block23;
            if (gestioneFruitori) {
                boolean connettoreStatic = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo).createProtocolVersionManager(null).isStaticRoute();
                List<MappingFruizionePortaDelegata> listaMappingFruizionePortaDelegata = this.apsCore.serviziFruitoriMappingList(fruitore.getId(), idSoggettoFruitore, idServizio, null);
                for (MappingFruizionePortaDelegata mappingFruizione : listaMappingFruizionePortaDelegata) {
                    String nomeConnettore;
                    PortaDelegata porta = this.porteDelegateCore.getPortaDelegata(mappingFruizione.getIdPortaDelegata());
                    if (StatoFunzionalita.DISABILITATO.equals((Object)porta.getStato())) continue;
                    Object suffixGruppo = "";
                    if (!mappingFruizione.isDefault()) {
                        suffixGruppo = "<br/>Gruppo: " + mappingFruizione.getDescrizione();
                    }
                    String nomeFruizione = nomeApiImpl + (String)suffixGruppo;
                    if (porta.getGestioneToken() != null && porta.getGestioneToken().getPolicy() != null && !listTokenPolicyValidazione.contains(porta.getGestioneToken().getPolicy())) {
                        listTokenPolicyValidazione.add(porta.getGestioneToken().getPolicy());
                        listTokenPolicyValidazioneConf.add(porta.getGestioneToken());
                        listPosizioneTokenPolicyValidazione.add(nomeFruizione + "<br/>Token Policy Validazione: " + porta.getGestioneToken().getPolicy());
                    }
                    if (porta.sizeAttributeAuthorityList() > 0) {
                        for (Object aa : porta.getAttributeAuthorityList()) {
                            if (listAttributeAuthority.contains(aa.getNome())) continue;
                            listAttributeAuthority.add(aa.getNome());
                            listPosizioneAttributeAuthority.add(nomeFruizione + "<br/>Attribute Authority: " + aa.getNome());
                        }
                    }
                    if (connettoreStatic) continue;
                    Connettore connettore = null;
                    if (mappingFruizione.isDefault()) {
                        connettore = fruitore.getConnettore();
                    } else if (porta.getAzione() != null && porta.getAzione().sizeAzioneDelegataList() > 0) {
                        Object aa;
                        aa = porta.getAzione().getAzioneDelegataList().iterator();
                        while (aa.hasNext()) {
                            String az = (String)aa.next();
                            for (ConfigurazioneServizioAzione config : fruitore.getConfigurazioneAzioneList()) {
                                if (!config.getAzioneList().contains(az)) continue;
                                connettore = config.getConnettore();
                                break;
                            }
                            if (connettore == null) continue;
                            break;
                        }
                    }
                    if (connettore == null) continue;
                    TipiConnettore tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo());
                    if ((findConnettoreHttpConPrefissoHttps || !TipiConnettore.HTTP.equals((Object)tipo)) && !TipiConnettore.HTTPS.equals((Object)tipo) || listConnettoriRegistrati.contains(nomeConnettore = connettore.getNome())) continue;
                    String tokenPolicy = ConnettoreUtils.getNegoziazioneTokenPolicyConnettore((Connettore)connettore);
                    if (tokenPolicy != null && StringUtils.isNotEmpty((String)tokenPolicy) && !listTokenPolicyNegoziazione.contains(tokenPolicy)) {
                        listTokenPolicyNegoziazione.add(tokenPolicy);
                        listPosizioneTokenPolicyNegoziazione.add(nomeFruizione + "<br/>Token Policy Negoziazione: " + tokenPolicy);
                    }
                    if (TipiConnettore.HTTP.equals((Object)tipo)) {
                        String endpoint = ConnettoreUtils.getEndpointConnettore((Connettore)connettore, (boolean)false);
                        if (endpoint == null) continue;
                        findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        continue;
                    }
                    listConnettoriRegistry.add(connettore);
                    listConnettoriRegistrati.add(nomeConnettore);
                    listPosizioneConnettoriRegistrati.add(nomeFruizione);
                }
            } else {
                List<MappingErogazionePortaApplicativa> listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
                for (MappingErogazionePortaApplicativa mappingErogazione : listaMappingErogazionePortaApplicativa) {
                    PortaApplicativa porta = this.porteApplicativeCore.getPortaApplicativa(mappingErogazione.getIdPortaApplicativa());
                    if (StatoFunzionalita.DISABILITATO.equals((Object)porta.getStato())) continue;
                    Object suffixGruppo = "";
                    if (!mappingErogazione.isDefault()) {
                        suffixGruppo = "<br/>Gruppo: " + mappingErogazione.getDescrizione();
                    }
                    String nomeErogazione = nomeApiImpl + (String)suffixGruppo;
                    if (porta.getGestioneToken() != null && porta.getGestioneToken().getPolicy() != null && !listTokenPolicyValidazione.contains(porta.getGestioneToken().getPolicy())) {
                        listTokenPolicyValidazione.add(porta.getGestioneToken().getPolicy());
                        listTokenPolicyValidazioneConf.add(porta.getGestioneToken());
                        listPosizioneTokenPolicyValidazione.add(nomeErogazione + "<br/>Token Policy Validazione: " + porta.getGestioneToken().getPolicy());
                    }
                    if (porta.sizeAttributeAuthorityList() > 0) {
                        for (AttributeAuthority aa : porta.getAttributeAuthorityList()) {
                            if (listAttributeAuthority.contains(aa.getNome())) continue;
                            listAttributeAuthority.add(aa.getNome());
                            listPosizioneAttributeAuthority.add(nomeErogazione + "<br/>Attribute Authority: " + aa.getNome());
                        }
                    }
                    boolean connettoreMultiploEnabled = porta.getBehaviour() != null;
                    for (PortaApplicativaServizioApplicativo paSA : porta.getServizioApplicativoList()) {
                        String tokenPolicy;
                        String nomeConnettore;
                        org.openspcoop2.core.config.Connettore connettore;
                        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
                        idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(porta.getTipoSoggettoProprietario(), porta.getNomeSoggettoProprietario()));
                        idServizioApplicativo.setNome(paSA.getNome());
                        ServizioApplicativo sa = this.saCore.getServizioApplicativo(idServizioApplicativo);
                        InvocazioneServizio is = sa.getInvocazioneServizio();
                        if (is == null || (connettore = is.getConnettore()) == null) continue;
                        TipiConnettore tipo = TipiConnettore.toEnumFromName((String)connettore.getTipo());
                        if ((findConnettoreHttpConPrefissoHttps || !TipiConnettore.HTTP.equals((Object)tipo)) && !TipiConnettore.HTTPS.equals((Object)tipo) || listConnettoriRegistrati.contains(nomeConnettore = connettore.getNome()) || connettoreMultiploEnabled && paSA.getDatiConnettore() != null && StatoFunzionalita.DISABILITATO.equals((Object)paSA.getDatiConnettore().getStato())) continue;
                        String nomeErogazioneConnettore = nomeErogazione;
                        if (connettoreMultiploEnabled && paSA.getDatiConnettore() != null && paSA.getDatiConnettore().getNome() != null) {
                            nomeErogazioneConnettore = nomeErogazioneConnettore + "<br/>Connettore Multiplo: " + paSA.getDatiConnettore().getNome();
                        }
                        if ((tokenPolicy = ConnettoreUtils.getNegoziazioneTokenPolicyConnettore((org.openspcoop2.core.config.Connettore)connettore)) != null && StringUtils.isNotEmpty((String)tokenPolicy) && !listTokenPolicyNegoziazione.contains(tokenPolicy)) {
                            listTokenPolicyNegoziazione.add(tokenPolicy);
                            listPosizioneTokenPolicyNegoziazione.add(nomeErogazioneConnettore + "<br/>Token Policy Negoziazione: " + tokenPolicy);
                        }
                        if (TipiConnettore.HTTP.equals((Object)tipo)) {
                            String endpoint = ConnettoreUtils.getEndpointConnettore((org.openspcoop2.core.config.Connettore)connettore, (boolean)false);
                            if (endpoint == null) continue;
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                            continue;
                        }
                        listConnettoriConfig.add(connettore);
                        listConnettoriRegistrati.add(nomeConnettore);
                        listPosizioneConnettoriRegistrati.add(nomeErogazioneConnettore);
                    }
                }
            }
        }
        return findConnettoreHttpConPrefissoHttps;
    }

    public void eseguiVerificaCertificati(AccordoServizioParteSpecifica asps, String alias, boolean gestioneFruitori, Fruitore fruitore, List<String> aliases, String nomeApiImpl, boolean sicurezzaModi, boolean messageSecurity, List<String> listConnettoriRegistrati, List<String> listPosizioneConnettoriRegistrati, List<Connettore> listConnettoriRegistry, List<org.openspcoop2.core.config.Connettore> listConnettoriConfig, List<String> listTokenPolicyValidazione, List<GestioneToken> listTokenPolicyValidazioneConf, List<String> listPosizioneTokenPolicyValidazione, List<String> listTokenPolicyNegoziazione, List<String> listPosizioneTokenPolicyNegoziazione, List<String> listAttributeAuthority, List<String> listPosizioneAttributeAuthority, boolean findConnettoreHttpConPrefissoHttps, boolean sceltaClusterId) throws Exception {
        boolean connettoreSsl;
        if (alias == null && !sceltaClusterId) {
            alias = "Verifica su tutti i nodi";
        }
        ArrayList<String> aliasesForCheck = new ArrayList<String>();
        boolean all = false;
        if (aliases.size() == 1) {
            aliasesForCheck.add(aliases.get(0));
        } else if ("Verifica su tutti i nodi".equals(alias)) {
            aliasesForCheck.addAll(aliases);
            all = true;
        } else {
            aliasesForCheck.add(alias);
        }
        CertificateChecker certificateChecker = null;
        certificateChecker = all ? this.apsCore.getJmxPdDCertificateChecker() : this.apsCore.newJmxPdDCertificateChecker(aliasesForCheck);
        StringBuilder sbDetailsError = new StringBuilder();
        int sogliaWarningGiorni = this.apsCore.getVerificaCertificatiWarningExpirationDays();
        String posizioneErrore = null;
        String extraErrore = null;
        StringBuilder sbDetailsWarningModi = new StringBuilder();
        String posizioneWarningModi = null;
        if (sicurezzaModi) {
            Connettore connettore;
            if (gestioneFruitori) {
                connettore = null;
                certificateChecker.checkFruizione(sbDetailsError, sbDetailsWarningModi, false, connettore, sicurezzaModi, false, asps, fruitore, sogliaWarningGiorni);
            } else {
                connettore = null;
                certificateChecker.checkErogazione(sbDetailsError, sbDetailsWarningModi, false, (org.openspcoop2.core.config.Connettore)connettore, sicurezzaModi, false, asps, sogliaWarningGiorni);
            }
            if (sbDetailsError.length() > 0) {
                posizioneErrore = nomeApiImpl;
            } else if (sbDetailsWarningModi.length() > 0) {
                posizioneWarningModi = nomeApiImpl;
            }
        }
        StringBuilder sbDetailsWarningConnettoriHttps = new StringBuilder();
        Object posizioneWarningConnettoriHttps = null;
        boolean bl = connettoreSsl = !listConnettoriRegistrati.isEmpty();
        if (sbDetailsError.length() <= 0 && connettoreSsl) {
            StringBuilder sbDetailsWarningConnettoriHttpsSecured;
            String posizione;
            Connettore connettore;
            int i;
            if (gestioneFruitori) {
                for (i = 0; i < listConnettoriRegistry.size(); ++i) {
                    connettore = listConnettoriRegistry.get(i);
                    posizione = listPosizioneConnettoriRegistrati.get(i);
                    sbDetailsWarningConnettoriHttpsSecured = new StringBuilder();
                    certificateChecker.checkFruizione(sbDetailsError, sbDetailsWarningConnettoriHttpsSecured, connettoreSsl, connettore, false, false, asps, fruitore, sogliaWarningGiorni);
                    if (sbDetailsError.length() > 0) {
                        posizioneErrore = posizione;
                        break;
                    }
                    if (sbDetailsWarningConnettoriHttps.length() > 0 || sbDetailsWarningConnettoriHttpsSecured.length() <= 0) continue;
                    posizioneWarningModi = nomeApiImpl;
                    sbDetailsWarningConnettoriHttps.append(sbDetailsWarningConnettoriHttpsSecured.toString());
                }
            } else {
                for (i = 0; i < listConnettoriConfig.size(); ++i) {
                    connettore = listConnettoriConfig.get(i);
                    posizione = listPosizioneConnettoriRegistrati.get(i);
                    sbDetailsWarningConnettoriHttpsSecured = new StringBuilder();
                    certificateChecker.checkErogazione(sbDetailsError, sbDetailsWarningConnettoriHttpsSecured, connettoreSsl, (org.openspcoop2.core.config.Connettore)connettore, false, false, asps, sogliaWarningGiorni);
                    if (sbDetailsError.length() > 0) {
                        posizioneErrore = posizione;
                        break;
                    }
                    if (sbDetailsWarningConnettoriHttps.length() > 0 || sbDetailsWarningConnettoriHttpsSecured.length() <= 0) continue;
                    posizioneWarningModi = nomeApiImpl;
                    sbDetailsWarningConnettoriHttps.append(sbDetailsWarningConnettoriHttpsSecured.toString());
                }
            }
        }
        StringBuilder sbDetailsWarningTokenPolicyValidazione = new StringBuilder();
        String posizioneWarningTokenPolicyValidazione = null;
        if (sbDetailsError.length() <= 0 && listTokenPolicyValidazione != null && !listTokenPolicyValidazione.isEmpty()) {
            for (int j = 0; j < listTokenPolicyValidazione.size(); ++j) {
                GestioneToken policy = listTokenPolicyValidazioneConf.get(j);
                String posizione = listPosizioneTokenPolicyValidazione.get(j);
                GenericProperties gp = this.confCore.getGenericProperties(policy.getPolicy(), "gestionePolicyToken", false);
                if (gp != null) {
                    String endpoint;
                    PolicyGestioneToken policyToken = TokenUtilities.convertTo((GenericProperties)gp, (GestioneToken)policy);
                    boolean httpsDynamicDiscovery = policyToken.isDynamicDiscovery();
                    boolean httpsValidazioneJwt = false;
                    boolean httpsIntrospection = false;
                    boolean httpsUserInfo = false;
                    boolean validazioneJwt = false;
                    if (!policyToken.isDynamicDiscovery()) {
                        httpsValidazioneJwt = policyToken.isValidazioneJWT() && policyToken.isValidazioneJWTLocationHttp();
                        httpsIntrospection = policyToken.isIntrospection();
                        httpsUserInfo = policyToken.isUserInfo();
                        validazioneJwt = policyToken.isValidazioneJWT();
                    }
                    boolean forwardToJwt = policyToken.isForwardToken();
                    if (httpsDynamicDiscovery && !policyToken.isEndpointHttps(false, false)) {
                        httpsDynamicDiscovery = false;
                        endpoint = policyToken.getDynamicDiscoveryEndpoint();
                        if (endpoint != null && StringUtils.isNotEmpty((String)endpoint) && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    if (httpsValidazioneJwt && !policyToken.isEndpointHttps(false, false)) {
                        httpsValidazioneJwt = false;
                        endpoint = policyToken.getValidazioneJWTLocation();
                        if (endpoint != null && StringUtils.isNotEmpty((String)endpoint) && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    if (httpsIntrospection && !policyToken.isEndpointHttps(true, false)) {
                        httpsIntrospection = false;
                        endpoint = policyToken.getIntrospectionEndpoint();
                        if (endpoint != null && StringUtils.isNotEmpty((String)endpoint) && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    if (httpsUserInfo && !policyToken.isEndpointHttps(false, true)) {
                        httpsUserInfo = false;
                        endpoint = policyToken.getUserInfoEndpoint();
                        if (endpoint != null && StringUtils.isNotEmpty((String)endpoint) && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    if (validazioneJwt) {
                        try {
                            String tokenType = policyToken.getTipoToken();
                            KeystoreParams keystoreParams = null;
                            if ("jws".equals(tokenType) || "jwe".equals(tokenType)) {
                                keystoreParams = TokenUtilities.getValidazioneJwtKeystoreParams((PolicyGestioneToken)policyToken);
                            }
                            if (keystoreParams == null) {
                                validazioneJwt = false;
                            }
                        }
                        catch (Exception t) {
                            throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                        }
                    }
                    if (forwardToJwt) {
                        try {
                            String forwardInformazioniRaccolteMode;
                            KeystoreParams keystoreParams = null;
                            if (policyToken.isForwardTokenInformazioniRaccolte() && ("op2jws".equals(forwardInformazioniRaccolteMode = policyToken.getForwardTokenInformazioniRaccolteMode()) || "jws".equals(forwardInformazioniRaccolteMode) || "jwe".equals(forwardInformazioniRaccolteMode))) {
                                keystoreParams = TokenUtilities.getForwardToJwtKeystoreParams((PolicyGestioneToken)policyToken);
                            }
                            if (keystoreParams == null) {
                                forwardToJwt = false;
                            }
                        }
                        catch (Exception t) {
                            throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                        }
                    }
                    if (httpsIntrospection || httpsUserInfo || validazioneJwt || forwardToJwt) {
                        StringBuilder sbDetailsWarningTokenPolicyValidazioneSecured = new StringBuilder();
                        certificateChecker.checkTokenPolicyValidazione(sbDetailsError, sbDetailsWarningTokenPolicyValidazioneSecured, httpsDynamicDiscovery, httpsValidazioneJwt, httpsIntrospection, httpsUserInfo, validazioneJwt, forwardToJwt, gp, sogliaWarningGiorni);
                        if (sbDetailsWarningTokenPolicyValidazione.length() <= 0 && sbDetailsWarningTokenPolicyValidazioneSecured.length() > 0) {
                            posizioneWarningTokenPolicyValidazione = posizione;
                            sbDetailsWarningTokenPolicyValidazione.append(sbDetailsWarningTokenPolicyValidazioneSecured.toString());
                        }
                    }
                }
                if (sbDetailsError.length() <= 0) continue;
                posizioneErrore = posizione;
                break;
            }
        }
        StringBuilder sbDetailsWarningTokenPolicyNegoziazione = new StringBuilder();
        String posizioneWarningTokenPolicyNegoziazione = null;
        if (sbDetailsError.length() <= 0 && listTokenPolicyNegoziazione != null && !listTokenPolicyNegoziazione.isEmpty()) {
            for (int j = 0; j < listTokenPolicyNegoziazione.size(); ++j) {
                String policy = listTokenPolicyNegoziazione.get(j);
                String posizione = listPosizioneTokenPolicyNegoziazione.get(j);
                GenericProperties gp = this.confCore.getGenericProperties(policy, "retrievePolicyToken", false);
                if (gp != null) {
                    boolean riferimentoFruizioneModi;
                    PolicyNegoziazioneToken policyNegoziazione = TokenUtilities.convertTo((GenericProperties)gp);
                    boolean https = false;
                    String endpoint = policyNegoziazione.getEndpoint();
                    if (StringUtils.isNotEmpty((String)endpoint)) {
                        if (policyNegoziazione.isEndpointHttps()) {
                            https = true;
                        } else if (endpoint != null && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    boolean signedJwt = false;
                    KeystoreParams keystoreParams = null;
                    try {
                        if (policyNegoziazione.isRfc7523x509Grant()) {
                            keystoreParams = TokenUtilities.getSignedJwtKeystoreParams((PolicyNegoziazioneToken)policyNegoziazione);
                        }
                    }
                    catch (Exception t) {
                        throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                    }
                    boolean riferimentoApplicativoModi = keystoreParams != null && "applicativoModi".equalsIgnoreCase(keystoreParams.getPath());
                    boolean bl2 = riferimentoFruizioneModi = keystoreParams != null && "fruizioneModi".equalsIgnoreCase(keystoreParams.getPath());
                    if (keystoreParams != null && !riferimentoApplicativoModi && !riferimentoFruizioneModi) {
                        signedJwt = true;
                    }
                    boolean dpopJwt = false;
                    KeystoreParams keystoreParamsDpop = null;
                    boolean riferimentoApplicativoModiDpop = false;
                    boolean riferimentoFruizioneModiDpop = false;
                    try {
                        if (policyNegoziazione.isDpop()) {
                            keystoreParamsDpop = TokenUtilities.getDpopKeystoreParams((PolicyNegoziazioneToken)policyNegoziazione);
                        }
                    }
                    catch (Exception t) {
                        throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                    }
                    riferimentoApplicativoModiDpop = keystoreParamsDpop != null && "applicativoModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                    boolean bl3 = riferimentoFruizioneModiDpop = keystoreParamsDpop != null && "fruizioneModi".equalsIgnoreCase(keystoreParamsDpop.getPath());
                    if (keystoreParamsDpop != null && !riferimentoApplicativoModiDpop && !riferimentoFruizioneModiDpop) {
                        dpopJwt = true;
                    }
                    if (https || signedJwt || dpopJwt) {
                        StringBuilder sbDetailsWarningTokenPolicyNegoziazioneSecured = new StringBuilder();
                        certificateChecker.checkTokenPolicyNegoziazione(sbDetailsError, sbDetailsWarningTokenPolicyNegoziazioneSecured, https, signedJwt, dpopJwt, gp, sogliaWarningGiorni);
                        if (sbDetailsWarningTokenPolicyNegoziazione.length() <= 0 && sbDetailsWarningTokenPolicyNegoziazioneSecured.length() > 0) {
                            posizioneWarningTokenPolicyNegoziazione = posizione;
                            sbDetailsWarningTokenPolicyNegoziazione.append(sbDetailsWarningTokenPolicyNegoziazioneSecured.toString());
                        }
                    }
                }
                if (sbDetailsError.length() <= 0) continue;
                posizioneErrore = posizione;
                break;
            }
        }
        StringBuilder sbDetailsWarningAttributeAuthority = new StringBuilder();
        String posizioneWarningAttributeAuthority = null;
        if (sbDetailsError.length() <= 0 && listAttributeAuthority != null && !listAttributeAuthority.isEmpty()) {
            for (int j = 0; j < listAttributeAuthority.size(); ++j) {
                String aa = listAttributeAuthority.get(j);
                String posizione = listPosizioneAttributeAuthority.get(j);
                GenericProperties gp = this.confCore.getGenericProperties(aa, "attributeAuthority", false);
                if (gp != null) {
                    PolicyAttributeAuthority policyAA = AttributeAuthorityUtilities.convertTo((GenericProperties)gp);
                    boolean https = false;
                    String endpoint = policyAA.getEndpoint();
                    if (StringUtils.isNotEmpty((String)endpoint)) {
                        if (policyAA.isEndpointHttps()) {
                            https = true;
                        } else if (endpoint != null && !findConnettoreHttpConPrefissoHttps) {
                            findConnettoreHttpConPrefissoHttps = endpoint.trim().startsWith("https");
                        }
                    }
                    boolean jwtRichiesta = false;
                    try {
                        KeystoreParams keystoreParams = null;
                        if (policyAA.isRequestJws()) {
                            keystoreParams = AttributeAuthorityUtilities.getRequestJwsKeystoreParams((PolicyAttributeAuthority)policyAA);
                        }
                        if (keystoreParams != null) {
                            jwtRichiesta = true;
                        }
                    }
                    catch (Exception t) {
                        throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                    }
                    boolean jwtRisposta = false;
                    try {
                        KeystoreParams truststoreParams = null;
                        if (policyAA.isResponseJws()) {
                            truststoreParams = AttributeAuthorityUtilities.getResponseJwsKeystoreParams((PolicyAttributeAuthority)policyAA);
                        }
                        if (truststoreParams != null) {
                            jwtRisposta = true;
                        }
                    }
                    catch (Exception t) {
                        throw new DriverConfigurazioneException(t.getMessage(), (Throwable)t);
                    }
                    if (https || jwtRichiesta || jwtRisposta) {
                        StringBuilder sbDetailsWarningAttributeAuthorityDebug = new StringBuilder();
                        certificateChecker.checkAttributeAuthority(sbDetailsError, sbDetailsWarningAttributeAuthorityDebug, https, jwtRichiesta, jwtRisposta, gp, sogliaWarningGiorni);
                        if (sbDetailsWarningAttributeAuthority.length() <= 0 && sbDetailsWarningAttributeAuthorityDebug.length() > 0) {
                            posizioneWarningAttributeAuthority = posizione;
                            sbDetailsWarningAttributeAuthority.append(sbDetailsWarningAttributeAuthorityDebug.toString());
                        }
                    }
                }
                if (sbDetailsError.length() <= 0) continue;
                posizioneErrore = posizione;
                break;
            }
        }
        StringBuilder sbDetailsWarningCertificatiJvm = new StringBuilder();
        String posizioneWarningCertificatiJvm = null;
        String extraWarningCertificatiJvm = null;
        if (sbDetailsError.length() <= 0 && findConnettoreHttpConPrefissoHttps) {
            certificateChecker.checkConfigurazioneJvm(sbDetailsError, sbDetailsWarningCertificatiJvm, sogliaWarningGiorni);
            if (sbDetailsError.length() > 0) {
                posizioneErrore = nomeApiImpl;
                extraErrore = "Configurazione https nella JVM";
            } else if (sbDetailsWarningCertificatiJvm.length() > 0) {
                posizioneWarningCertificatiJvm = nomeApiImpl;
                extraWarningCertificatiJvm = "Configurazione https nella JVM";
            }
        }
        StringBuilder sbDetailsWarningMessageSecurity = new StringBuilder();
        String posizioneWarningMessageSecurity = null;
        if (sbDetailsError.length() <= 0 && messageSecurity) {
            Connettore connettore;
            if (gestioneFruitori) {
                connettore = null;
                certificateChecker.checkFruizione(sbDetailsError, sbDetailsWarningMessageSecurity, false, connettore, false, messageSecurity, asps, fruitore, sogliaWarningGiorni);
            } else {
                connettore = null;
                certificateChecker.checkErogazione(sbDetailsError, sbDetailsWarningMessageSecurity, false, (org.openspcoop2.core.config.Connettore)connettore, false, messageSecurity, asps, sogliaWarningGiorni);
            }
            if (sbDetailsError.length() > 0) {
                posizioneErrore = nomeApiImpl;
            } else if (sbDetailsWarningMessageSecurity.length() > 0) {
                posizioneWarningMessageSecurity = nomeApiImpl;
            }
        }
        String warning = null;
        String posizioneWarning = null;
        String extraWarning = null;
        if (sbDetailsError.length() <= 0) {
            if (sbDetailsWarningModi.length() > 0) {
                warning = sbDetailsWarningModi.toString();
                posizioneWarning = posizioneWarningModi;
            } else if (sbDetailsWarningConnettoriHttps.length() > 0) {
                warning = sbDetailsWarningConnettoriHttps.toString();
                posizioneWarning = posizioneWarningConnettoriHttps;
            } else if (sbDetailsWarningTokenPolicyValidazione.length() > 0) {
                warning = sbDetailsWarningTokenPolicyValidazione.toString();
                posizioneWarning = posizioneWarningTokenPolicyValidazione;
            } else if (sbDetailsWarningTokenPolicyNegoziazione.length() > 0) {
                warning = sbDetailsWarningTokenPolicyNegoziazione.toString();
                posizioneWarning = posizioneWarningTokenPolicyNegoziazione;
            } else if (sbDetailsWarningAttributeAuthority.length() > 0) {
                warning = sbDetailsWarningAttributeAuthority.toString();
                posizioneWarning = posizioneWarningAttributeAuthority;
            } else if (sbDetailsWarningCertificatiJvm.length() > 0) {
                warning = sbDetailsWarningCertificatiJvm.toString();
                posizioneWarning = posizioneWarningCertificatiJvm;
                extraWarning = extraWarningCertificatiJvm;
            } else if (sbDetailsWarningMessageSecurity.length() > 0) {
                warning = sbDetailsWarningMessageSecurity.toString();
                posizioneWarning = posizioneWarningMessageSecurity;
            }
        }
        ArrayList<String> formatIds = new ArrayList<String>();
        formatIds.add("Configurazione connettore https");
        formatIds.add("Configurazione della firma ModI");
        formatIds.add("Configurazione Validazione JWT");
        formatIds.add("Configurazione ForwardTo JWT");
        formatIds.add("Configurazione SignedJWT");
        formatIds.add("Configurazione JWS Richiesta");
        formatIds.add("Configurazione JWS Risposta");
        this.apsCore.formatVerificaCertificatiEsito(this.pd, formatIds, sbDetailsError.length() > 0 ? sbDetailsError.toString() : null, extraErrore, posizioneErrore, warning, extraWarning, posizioneWarning, false);
    }

    public boolean eseguiVerificaCertificati(boolean soloModI, AccordoServizioParteSpecifica asps, IDSoggetto idSoggettoFruitore, String alias, boolean gestioneFruitori, boolean gestioneErogatori, Fruitore fruitore, IDServizio idServizio, String tipoProtocollo, List<DataElement> dati) throws Exception {
        List listKeystoreParams;
        List<MappingErogazionePortaApplicativa> list;
        List<String> aliases = this.apsCore.getJmxPdDAliases();
        if (aliases == null || aliases.isEmpty()) {
            throw new CoreException("Pagina non prevista, la sezione configurazione non permette di accedere a questa pagina, se la configurazione non e' corretta");
        }
        String nomeApiImpl = this.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        IDServizio idAps = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        IDSoggetto idFruitore = null;
        if (gestioneFruitori) {
            idFruitore = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
        }
        boolean modi = this.apsCore.isProfiloModIPA(tipoProtocollo);
        boolean sicurezzaModi = false;
        if (modi) {
            idAps.setPortType(asps.getPortType());
            idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
            IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
            IRegistryReader registryReader = this.apsCore.getRegistryReader(protocolFactory);
            IConfigIntegrationReader iConfigIntegrationReader = this.apsCore.getConfigIntegrationReader(protocolFactory);
            ConsoleConfiguration consoleConfiguration = null;
            if (!gestioneFruitori) {
                consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, iConfigIntegrationReader, idAps);
            } else {
                IDFruizione idFruizioneObject = new IDFruizione();
                idFruizioneObject.setIdServizio(idAps);
                idFruizioneObject.setIdFruitore(idFruitore);
                consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigFruizioneAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, iConfigIntegrationReader, idFruizioneObject);
            }
            if (consoleConfiguration != null && consoleConfiguration.getConsoleItem() != null && !consoleConfiguration.getConsoleItem().isEmpty()) {
                sicurezzaModi = true;
            }
            if (sicurezzaModi) {
                boolean includeRemoteStore = false;
                boolean checkModeFruizioneKeystoreId = gestioneFruitori;
                if (gestioneFruitori && fruitore.sizeProtocolPropertyList() > 0) {
                    sicurezzaModi = ModIUtils.existsStoreConfig((List)fruitore.getProtocolPropertyList(), (boolean)includeRemoteStore, (boolean)checkModeFruizioneKeystoreId);
                } else if (gestioneErogatori && asps.sizeProtocolPropertyList() > 0) {
                    sicurezzaModi = ModIUtils.existsStoreConfig((List)asps.getProtocolPropertyList(), (boolean)includeRemoteStore, (boolean)checkModeFruizioneKeystoreId);
                }
            }
        }
        boolean messageSecurity = false;
        if (gestioneFruitori) {
            list = this.apsCore.serviziFruitoriMappingList(idFruitore, idServizio, (ISearch)new Search(true));
            if (list != null && !list.isEmpty()) {
                for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : list) {
                    PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                    listKeystoreParams = SecurityUtils.readRequestKeystoreParams((PortaDelegata)pd);
                    if (listKeystoreParams != null && !listKeystoreParams.isEmpty()) {
                        messageSecurity = true;
                    } else {
                        listKeystoreParams = SecurityUtils.readResponseKeystoreParams((PortaDelegata)pd);
                        if (listKeystoreParams == null || listKeystoreParams.isEmpty()) continue;
                        messageSecurity = true;
                    }
                    break;
                }
            }
        } else {
            list = this.apsCore.mappingServiziPorteAppList(idServizio, (ISearch)new Search(true));
            if (list != null && !list.isEmpty()) {
                for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : list) {
                    PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                    listKeystoreParams = SecurityUtils.readRequestKeystoreParams((PortaApplicativa)pa);
                    if (listKeystoreParams != null && !listKeystoreParams.isEmpty()) {
                        messageSecurity = true;
                    } else {
                        listKeystoreParams = SecurityUtils.readResponseKeystoreParams((PortaApplicativa)pa);
                        if (listKeystoreParams == null || listKeystoreParams.isEmpty()) continue;
                        messageSecurity = true;
                    }
                    break;
                }
            }
        }
        ArrayList<String> listConnettoriRegistrati = new ArrayList<String>();
        ArrayList<String> listPosizioneConnettoriRegistrati = new ArrayList<String>();
        ArrayList<Connettore> arrayList = new ArrayList<Connettore>();
        ArrayList<org.openspcoop2.core.config.Connettore> listConnettoriConfig = new ArrayList<org.openspcoop2.core.config.Connettore>();
        ArrayList<String> listTokenPolicyValidazione = new ArrayList<String>();
        ArrayList<GestioneToken> listTokenPolicyValidazioneConf = new ArrayList<GestioneToken>();
        ArrayList<String> listPosizioneTokenPolicyValidazione = new ArrayList<String>();
        ArrayList<String> listTokenPolicyNegoziazione = new ArrayList<String>();
        ArrayList<String> listPosizioneTokenPolicyNegoziazione = new ArrayList<String>();
        ArrayList<String> listAttributeAuthority = new ArrayList<String>();
        ArrayList<String> listPosizioneAttributeAuthority = new ArrayList<String>();
        boolean findConnettoreHttpConPrefissoHttps = this.estraiElencoInvocazioni(soloModI, asps, idSoggettoFruitore, gestioneFruitori, fruitore, idServizio, tipoProtocollo, nomeApiImpl, listConnettoriRegistrati, listPosizioneConnettoriRegistrati, arrayList, listConnettoriConfig, listTokenPolicyValidazione, listTokenPolicyValidazioneConf, listPosizioneTokenPolicyValidazione, listTokenPolicyNegoziazione, listPosizioneTokenPolicyNegoziazione, listAttributeAuthority, listPosizioneAttributeAuthority);
        boolean verificaCertificatiEffettuata = false;
        if (listConnettoriRegistrati.isEmpty() && listTokenPolicyValidazione.isEmpty() && listTokenPolicyNegoziazione.isEmpty() && listAttributeAuthority.isEmpty() && !findConnettoreHttpConPrefissoHttps && !sicurezzaModi && !messageSecurity) {
            this.pd.setMessage("Non sono state rilevate configurazioni che utilizzano certificati", Costanti.MESSAGE_TYPE_INFO);
            this.pd.disableEditMode();
            verificaCertificatiEffettuata = true;
        } else {
            boolean sceltaClusterId = this.apsCore.isVerificaCertificatiSceltaClusterId();
            if (aliases.size() == 1 || alias != null || !sceltaClusterId) {
                this.eseguiVerificaCertificati(asps, alias, gestioneFruitori, fruitore, aliases, nomeApiImpl, sicurezzaModi, messageSecurity, listConnettoriRegistrati, listPosizioneConnettoriRegistrati, arrayList, listConnettoriConfig, listTokenPolicyValidazione, listTokenPolicyValidazioneConf, listPosizioneTokenPolicyValidazione, listTokenPolicyNegoziazione, listPosizioneTokenPolicyNegoziazione, listAttributeAuthority, listPosizioneAttributeAuthority, findConnettoreHttpConPrefissoHttps, sceltaClusterId);
                this.pd.disableEditMode();
                verificaCertificatiEffettuata = true;
            } else {
                DataElement deTestConnettivita = new DataElement();
                deTestConnettivita.setType(DataElementType.TITLE);
                deTestConnettivita.setLabel("Verifica Certificati");
                dati.add(deTestConnettivita);
                this.addVerificaCertificatoSceltaAlias(aliases, dati);
            }
        }
        return verificaCertificatiEffettuata;
    }
}

