/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ErogazioniVerificaCertificati
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        TipoOperazione tipoOp = TipoOperazione.OTHER;
        try {
            ErogazioniHelper apsHelper = new ErogazioniHelper(request, pd, session);
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            SoggettiCore soggettiCore = new SoggettiCore(apsCore);
            String verificaCertificatiFromLista = apsHelper.getParameter("certVerFromLista");
            boolean arrivoDaLista = "true".equalsIgnoreCase(verificaCertificatiFromLista);
            boolean soloModI = false;
            if (!arrivoDaLista) {
                String par = apsHelper.getParameter("modificaProfilo");
                soloModI = "true".equalsIgnoreCase(par);
            }
            String id = apsHelper.getParameter("id");
            long idInt = Long.parseLong(id);
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idInt);
            String idsogg = apsHelper.getParameter("idsogg");
            String tipoSoggettoFruitore = apsHelper.getParameter("tipoSoggFru");
            String nomeSoggettoFruitore = apsHelper.getParameter("nomeSoggFru");
            IDSoggetto idSoggettoFruitore = null;
            if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
                idSoggettoFruitore = new IDSoggetto(tipoSoggettoFruitore, nomeSoggettoFruitore);
            }
            String alias = apsHelper.getParameter("aliasNodo");
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            boolean gestioneErogatori = false;
            if (tipologia != null) {
                if ("fruizione".equals(tipologia)) {
                    gestioneFruitori = true;
                } else if ("erogazione".equals(tipologia)) {
                    gestioneErogatori = true;
                }
            }
            Fruitore fruitore = null;
            String idFruizione = null;
            if (gestioneFruitori) {
                for (Fruitore check : asps.getFruitoreList()) {
                    if (!check.getTipo().equals(idSoggettoFruitore.getTipo()) || !check.getNome().equals(idSoggettoFruitore.getNome())) continue;
                    fruitore = check;
                    break;
                }
            }
            if (fruitore != null) {
                idFruizione = "" + fruitore.getId();
            }
            apsHelper.makeMenu();
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            String tipoProtocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(asps.getTipoSoggettoErogatore());
            ErogazioniVerificaCertificati.impostaBarraDelTitolo(pd, apsHelper, arrivoDaLista, asps, tipoSoggettoFruitore, nomeSoggettoFruitore, idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
            List<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            boolean verificaCertificatiEffettuata = apsHelper.eseguiVerificaCertificati(soloModI, asps, idSoggettoFruitore, alias, gestioneFruitori, gestioneErogatori, fruitore, idServizio, tipoProtocollo, dati);
            pd.setLabelBottoneInvia("Verifica");
            dati = idSoggettoFruitore != null ? apsHelper.addHiddenFieldsToDati(tipoOp, id, idsogg, id, "" + asps.getId(), idFruizione, tipoSoggettoFruitore, nomeSoggettoFruitore, dati) : apsHelper.addHiddenFieldsToDati(TipoOperazione.OTHER, "" + asps.getId(), null, null, dati);
            DataElement de = new DataElement();
            de.setValue("" + arrivoDaLista);
            de.setType(DataElementType.HIDDEN);
            de.setName("certVerFromLista");
            dati.add(de);
            if (soloModI) {
                de = new DataElement();
                de.setValue("" + soloModI);
                de.setType(DataElementType.HIDDEN);
                de.setName("modificaProfilo");
                dati.add(de);
            }
            pd.setDati(dati);
            if (verificaCertificatiEffettuata) {
                if (arrivoDaLista) {
                    String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = Liste.SERVIZI;
                    List<AccordoServizioParteSpecifica> lista = null;
                    if (!ServletUtils.isSearchDone((IConsoleHelper)apsHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, AccordoServizioParteSpecifica.class);
                    }
                    ricerca = apsHelper.checkSearchParameters(idLista, ricerca);
                    apsHelper.clearFiltroSoggettoByPostBackProtocollo(0, (ISearch)ricerca, idLista);
                    apsHelper.checkGestione(request, session, ricerca, idLista, tipologia, true);
                    boolean[] permessi = AccordiServizioParteSpecificaUtilities.getPermessiUtente(apsHelper);
                    if (lista == null) {
                        lista = apsCore.isVisioneOggettiGlobale(userLogin) ? apsCore.soggettiServizioList(null, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori) : apsCore.soggettiServizioList(userLogin, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori);
                    }
                    if (!apsHelper.isPostBackFilterElement()) {
                        ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                    }
                    apsHelper.prepareErogazioniList((ISearch)ricerca, lista);
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"aspsErogazioniVerificaCertificati", (ForwardParams)CostantiControlStation.TIPO_OPERAZIONE_VERIFICA_CERTIFICATI);
                }
                apsHelper.prepareErogazioneChange(tipoOp, asps, idSoggettoFruitore);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"aspsErogazioni", (ForwardParams)ForwardParams.CHANGE());
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"aspsErogazioniVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"aspsErogazioniVerificaCertificati", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }

    public static void impostaBarraDelTitolo(PageData pd, ErogazioniHelper apsHelper, boolean arrivoDaLista, AccordoServizioParteSpecifica asps, String tipoSoggettoFruitore, String nomeSoggettoFruitore, IDSoggetto idSoggettoFruitore, boolean gestioneFruitori, IDServizio idServizio, String tipoProtocollo) throws DriverControlStationException {
        String tmpTitle = apsHelper.getLabelServizio(idSoggettoFruitore, gestioneFruitori, idServizio, tipoProtocollo);
        ArrayList<Parameter> listParameterChange = new ArrayList<Parameter>();
        Parameter pIdsoggErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
        Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
        Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
        Parameter pTipoSoggettoFruitore = null;
        Parameter pNomeSoggettoFruitore = null;
        if (gestioneFruitori) {
            pTipoSoggettoFruitore = new Parameter("tipoSoggFru", tipoSoggettoFruitore);
            pNomeSoggettoFruitore = new Parameter("nomeSoggFru", nomeSoggettoFruitore);
        }
        listParameterChange.add(new Parameter("id", "" + asps.getId()));
        listParameterChange.add(pNomeServizio);
        listParameterChange.add(pTipoServizio);
        listParameterChange.add(pIdsoggErogatore);
        ArrayList<Parameter> lstParm = new ArrayList<Parameter>();
        if (gestioneFruitori) {
            lstParm.add(new Parameter("Fruizioni", "aspsErogazioniList.do"));
            listParameterChange.add(pTipoSoggettoFruitore);
            listParameterChange.add(pNomeSoggettoFruitore);
        } else {
            lstParm.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
        }
        if (arrivoDaLista) {
            String labelVerifica = "Verifica Certificati di " + tmpTitle;
            lstParm.add(new Parameter(labelVerifica, null));
        } else {
            lstParm.add(new Parameter(tmpTitle, "aspsErogazioniChange.do", listParameterChange.toArray(new Parameter[listParameterChange.size()])));
            lstParm.add(new Parameter("Verifica Certificati", null));
        }
        ServletUtils.setPageDataTitle((PageData)pd, lstParm);
    }
}

