/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.information_missing.Wizard;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.ImportMode;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ImporterStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ImporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class Importer
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ArrayList<DataElement> dati;
            Map<String, String> importModesMapRispettoATuttiIProtocolli;
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            ArchiviHelper archiviHelper = new ArchiviHelper(request, pd, session);
            ArchiviCore archiviCore = new ArchiviCore();
            PddCore pddCore = new PddCore(archiviCore);
            if (!pddCore.existsPddOperativa()) {
                archiviHelper.makeMenu();
                pd.setMessage("Non \u00e8 possibile completare l'operazione: non \u00e8 stata rilevata una Porta di Dominio operativa");
                pd.disableEditMode();
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"import", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_IMPORT);
            }
            String nomePddOperativa = pddCore.getNomePddOperativa();
            ImporterUtils importerUtils = new ImporterUtils(archiviCore);
            String postBackElementName = archiviHelper.getPostBackElementName();
            boolean deleter = false;
            String parametroModalitaFunzionamento = archiviHelper.getParameter("modalita");
            if (parametroModalitaFunzionamento != null) {
                deleter = "elimina".equals(parametroModalitaFunzionamento.trim());
            } else {
                parametroModalitaFunzionamento = "import";
            }
            DataElement modalitaDataElement = new DataElement();
            modalitaDataElement.setLabel("modalita");
            modalitaDataElement.setValue(parametroModalitaFunzionamento);
            modalitaDataElement.setType(DataElementType.HIDDEN);
            modalitaDataElement.setName("modalita");
            String labelBottone = "Importa";
            if (deleter) {
                labelBottone = "Elimina";
            }
            ImporterStrutsBean strutsBean = null;
            String f = archiviHelper.getParameter("filePath");
            if (f == null || "".equals(f)) {
                strutsBean = new ImporterStrutsBean(request, session, true);
            } else {
                strutsBean = new ImporterStrutsBean(request, session, false);
                strutsBean.filePath = f;
            }
            List<String> protocolli = archiviCore.getProtocolli(request, session);
            if (protocolli.size() > 1) {
                protocolli = new ArrayList<String>();
                protocolli.add("-");
                protocolli.addAll(archiviCore.getProtocolli(request, session));
            }
            strutsBean.protocollo = archiviHelper.getParameter("protocollo");
            if ("".equals(strutsBean.protocollo) || "-".equals(strutsBean.protocollo)) {
                strutsBean.protocollo = null;
            }
            boolean showProtocols = (importModesMapRispettoATuttiIProtocolli = importerUtils.getImportModesWithProtocol(protocolli)) != null && importModesMapRispettoATuttiIProtocolli.size() > 1;
            ArrayList<String> protocolliForModes = new ArrayList<String>();
            if (strutsBean.protocollo != null) {
                protocolliForModes.add(strutsBean.protocollo);
            } else {
                protocolliForModes.addAll(protocolli);
            }
            Map<String, String> importModesMap = importerUtils.getImportModesWithProtocol(protocolliForModes);
            ArrayList<ImportMode> importModes = new ArrayList<ImportMode>();
            for (String imp : importModesMap.keySet()) {
                importModes.add(new ImportMode(imp));
            }
            strutsBean.importMode = archiviHelper.getParameter("tipologiaArchivio");
            if (strutsBean.importMode != null && !importModes.contains(new ImportMode(strutsBean.importMode))) {
                strutsBean.importMode = null;
            }
            if (strutsBean.importMode == null) {
                strutsBean.importMode = importModes.contains(Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE) ? Costanti.OPENSPCOOP_IMPORT_ARCHIVE_MODE.toString() : ((ImportMode)importModes.get(0)).toString();
            }
            ImportMode archiveMode = null;
            if (strutsBean.importMode != null) {
                archiveMode = new ImportMode(strutsBean.importMode);
            }
            String protocolloEffettivo = importModesMap.get(strutsBean.importMode);
            List<ArchiveModeType> importTypes = null;
            if (strutsBean.importMode != null) {
                importTypes = importerUtils.getImportModeTypes((ArchiveMode)archiveMode, protocolloEffettivo);
            }
            strutsBean.importType = archiviHelper.getParameter("tipoArchivio");
            if (strutsBean.importType != null && !importTypes.contains(new ArchiveModeType(strutsBean.importType))) {
                strutsBean.importType = null;
            }
            if (strutsBean.importType == null) {
                strutsBean.importType = importTypes.get(0).toString();
            }
            ArchiveModeType archiveModeType = null;
            if (strutsBean.importType != null) {
                archiveModeType = new ArchiveModeType(strutsBean.importType);
            }
            String tmpValidazioneDocumenti = archiviHelper.getParameter("validazioneDocumenti");
            strutsBean.validazioneDocumenti = archiviHelper.isEditModeInProgress() && tmpValidazioneDocumenti == null ? true : ServletUtils.isCheckBoxEnabled((String)tmpValidazioneDocumenti);
            String tmpUpdateEnabled = archiviHelper.getParameter("updateEnabled");
            strutsBean.updateEnabled = archiviHelper.isEditModeInProgress() && tmpUpdateEnabled == null ? false : ServletUtils.isCheckBoxEnabled((String)tmpUpdateEnabled);
            String tmpImportDeletePolicyConfig = archiviHelper.getParameter("policyConfigEnabled");
            strutsBean.importDeletePolicyConfig = archiviHelper.isEditModeInProgress() && tmpImportDeletePolicyConfig == null ? false : ServletUtils.isCheckBoxEnabled((String)tmpImportDeletePolicyConfig);
            String tmpImportDeletePluginConfig = archiviHelper.getParameter("pluginConfigEnabled");
            strutsBean.importDeletePluginConfig = archiviHelper.isEditModeInProgress() && tmpImportDeletePluginConfig == null ? false : ServletUtils.isCheckBoxEnabled((String)tmpImportDeletePluginConfig);
            String tmpImportConfig = archiviHelper.getParameter("configEnabled");
            strutsBean.importConfig = archiviHelper.isEditModeInProgress() && tmpImportConfig == null ? false : ServletUtils.isCheckBoxEnabled((String)tmpImportConfig);
            String tmpClass = archiviHelper.getParameter("importInformationMissingClassObject");
            if (tmpClass != null && !"".equals(tmpClass)) {
                strutsBean.importInformationMissingClassObject = Class.forName(tmpClass);
                String absolutePath = archiviHelper.getParameter("importInformationMissingObjectFilePath");
                if (absolutePath == null || "".equals(absolutePath)) {
                    throw new ControlStationCoreException("Parametro [importInformationMissingObjectFilePath] non trovato, nonostante sia presente il parametro [importInformationMissingClassObject] con valore: " + tmpClass);
                }
                strutsBean.importInformationMissingObject = importerUtils.readImportInformationMissingObjectFile(absolutePath, strutsBean.importInformationMissingClassObject);
            } else {
                strutsBean.importInformationMissingClassObject = null;
                strutsBean.importInformationMissingObject = null;
            }
            strutsBean.importInformationMissingSoggettoInput = archiviHelper.getParameter("soggetto");
            strutsBean.importInformationMissingVersioneInput = archiviHelper.getParameter("versione");
            strutsBean.importInformationMissingCollectionFilePath = archiviHelper.getParameter("importInformationMissingCollectionFilePath");
            strutsBean.importInformationMissingObjectId = archiviHelper.getParameter("importInformationMissingObjectId");
            strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo = archiviHelper.getParameter("modalitaAcquisizione");
            strutsBean.importInformationMissingPortTypeImplementedInput = archiviHelper.getParameter("portTypeImplemented");
            strutsBean.importInformationMissingAccordoServizioParteComuneInput = archiviHelper.getParameter("accordoServizioParteComune");
            strutsBean.importInformationMissingAccordoCooperazioneInput = archiviHelper.getParameter("accordoCooperazione");
            FormFile ff = importerUtils.readFormFile(strutsBean.filePath, form);
            archiviHelper.makeMenu();
            if (archiviHelper.isEditModeInProgress() && strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo == null) {
                String nomeFunzionalita = "Importa";
                if (deleter) {
                    nomeFunzionalita = "Elimina";
                }
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter(nomeFunzionalita, null)});
                ArrayList<DataElement> dati2 = new ArrayList<DataElement>();
                dati2.add(modalitaDataElement);
                dati2.add(ServletUtils.getDataElementForEditModeFinished());
                archiviHelper.addImportToDati(dati2, strutsBean.validazioneDocumenti, strutsBean.updateEnabled, strutsBean.importDeletePolicyConfig, strutsBean.importDeletePluginConfig, strutsBean.importConfig, showProtocols, protocolli, strutsBean.protocollo, importModes, strutsBean.importMode, importTypes, strutsBean.importType, deleter);
                pd.setDati(dati2);
                pd.setLabelBottoneInvia(labelBottone);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"import", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_IMPORT);
            }
            boolean isOk = archiviHelper.importCheckData(ff, importerUtils, protocolloEffettivo, (ArchiveMode)archiveMode, archiveModeType);
            boolean convertForGetException = false;
            if (isOk && strutsBean.importInformationMissingObjectId != null && !(isOk = archiviHelper.importInformationMissingCheckData(strutsBean.importInformationMissingSoggettoInput, strutsBean.importInformationMissingVersioneInput, strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo, postBackElementName, strutsBean.importInformationMissingPortTypeImplementedInput, strutsBean.importInformationMissingAccordoServizioParteComuneInput, strutsBean.importInformationMissingAccordoCooperazioneInput))) {
                convertForGetException = true;
            }
            if (strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo != null && !"".equals(strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo)) {
                try {
                    strutsBean.importInformationMissingPortTypes = archiviHelper.readInformazioniProtocolloServiziAzioni(strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo, protocolloEffettivo, strutsBean.importInformationMissingObject);
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.importInformationMissingInvocazioneServizio = !archiviHelper.isEditModeInProgress() ? archiviHelper.readInvocazioneServizio() : null;
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.importInformationMissingConnettore = !archiviHelper.isEditModeInProgress() ? archiviHelper.readConnettore() : null;
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.importInformationMissingCredenziali = !archiviHelper.isEditModeInProgress() ? archiviHelper.readCredenzialiSA() : null;
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            MapPlaceholder importInformationMissingPlaceholder = null;
            if (isOk) {
                try {
                    if (!archiviHelper.isEditModeInProgress() && (importInformationMissingPlaceholder = archiviHelper.readPlaceholder()) != null) {
                        strutsBean.importInformationMissingGlobalPlaceholder.putAll(importInformationMissingPlaceholder);
                    }
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            HashMap<String, String> mapRequisitiInput = null;
            HashMap<String, String> mapRequisitiInputStepIncrement = null;
            if (isOk) {
                try {
                    if (!archiviHelper.isEditModeInProgress()) {
                        mapRequisitiInput = archiviHelper.readRequisitiInput();
                        mapRequisitiInputStepIncrement = archiviHelper.readRequisitiStepIncrementInput();
                    }
                }
                catch (Exception e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                    convertForGetException = false;
                }
            }
            ImportInformationMissingCollection importInformationMissingCollection = null;
            if (strutsBean.importInformationMissingCollectionFilePath != null) {
                importInformationMissingCollection = importerUtils.readImportInformationMissingCollectionFile(strutsBean.importInformationMissingCollectionFilePath);
            }
            if (isOk) {
                importInformationMissingCollection = importerUtils.updateInformationMissingCheckData(mapRequisitiInput, mapRequisitiInputStepIncrement, strutsBean.importInformationMissingSoggettoInput, strutsBean.importInformationMissingVersioneInput, strutsBean.importInformationMissingPortTypes, strutsBean.importInformationMissingPortTypeImplementedInput, strutsBean.importInformationMissingAccordoServizioParteComuneInput, strutsBean.importInformationMissingAccordoCooperazioneInput, strutsBean.importInformationMissingInvocazioneServizio, strutsBean.importInformationMissingConnettore, strutsBean.importInformationMissingCredenziali, importInformationMissingPlaceholder, strutsBean.importInformationMissingCollectionFilePath, strutsBean.importInformationMissingObjectId, importInformationMissingCollection);
            }
            if (!archiviHelper.isEditModeInProgress() && isOk) {
                strutsBean.stepCounter.increment();
            }
            Archive archive = null;
            if (isOk || convertForGetException) {
                try {
                    archive = archiviCore.convert(ff.getFileData(), archiveModeType, (ArchiveMode)archiveMode, protocolloEffettivo, strutsBean.validazioneDocumenti, strutsBean.importInformationMissingGlobalPlaceholder);
                }
                catch (Exception e) {
                    ControlStationCore.logError(e.getMessage(), e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk && archive != null && archive.getInformationMissing() != null && archive.getInformationMissing().getWizard() != null) {
                try {
                    isOk = archiviHelper.checkRequiisitiWizard(archive.getInformationMissing().getWizard());
                }
                catch (Exception e) {
                    ControlStationCore.logError(e.getMessage(), e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            ImportInformationMissingException importInformationMissingException = null;
            if (isOk || convertForGetException) {
                try {
                    archiviCore.validateArchive(archive, protocolloEffettivo, strutsBean.validazioneDocumenti, importInformationMissingCollection, userLogin, deleter);
                }
                catch (ImportInformationMissingException e) {
                    importInformationMissingException = e;
                    isOk = false;
                }
                catch (Exception e) {
                    ControlStationCore.logError(e.getMessage(), e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk && archive != null) {
                try {
                    archiviCore.finalizeArchive(archive, archiveModeType, (ArchiveMode)archiveMode, protocolloEffettivo, strutsBean.validazioneDocumenti, strutsBean.importInformationMissingGlobalPlaceholder);
                }
                catch (Exception e) {
                    ControlStationCore.logError(e.getMessage(), e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Importa", null)});
                dati = new ArrayList();
                dati.add(modalitaDataElement);
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (importInformationMissingException != null) {
                    boolean readedDatiConnettori = strutsBean.importInformationMissingInvocazioneServizio != null || strutsBean.importInformationMissingConnettore != null || strutsBean.importInformationMissingCredenziali != null;
                    Wizard wizard = null;
                    if (archive != null && archive.getInformationMissing() != null) {
                        wizard = archive.getInformationMissing().getWizard();
                    }
                    archiviHelper.addImportInformationMissingToDati(dati, importerUtils, ff, strutsBean.protocollo, strutsBean.importMode, protocolloEffettivo, strutsBean.importType, strutsBean.validazioneDocumenti, strutsBean.updateEnabled, strutsBean.importDeletePolicyConfig, strutsBean.importDeletePluginConfig, strutsBean.importConfig, importInformationMissingCollection, importInformationMissingException, strutsBean.importInformationMissingModalitaAcquisizioneInformazioniProtocollo, strutsBean.importInformationMissingPortTypes, protocolliForModes, readedDatiConnettori, wizard, strutsBean.stepCounter.getStep(), deleter);
                    pd.setLabelBottoneInvia("Avanti");
                } else {
                    archiviHelper.addImportToDati(dati, strutsBean.validazioneDocumenti, strutsBean.updateEnabled, strutsBean.importDeletePolicyConfig, strutsBean.importDeletePluginConfig, strutsBean.importConfig, showProtocols, protocolli, strutsBean.protocollo, importModes, strutsBean.importMode, importTypes, strutsBean.importType, deleter);
                    pd.setLabelBottoneInvia(labelBottone);
                }
                pd.setDati(dati);
                if (pd.getMessage() != null && importInformationMissingException == null) {
                    pd.setMessage("Rilevato un errore durante l'import dell'archivio: <BR>" + StringEscapeUtils.escapeHtml((String)pd.getMessage()));
                }
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"import", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_IMPORT);
            }
            dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            String esito = null;
            esito = deleter ? archiviCore.deleteArchive(archive, (ArchiveMode)archiveMode, protocolloEffettivo, userLogin, archiviHelper.smista(), strutsBean.importDeletePolicyConfig, strutsBean.importDeletePluginConfig) : archiviCore.importArchive(archive, (ArchiveMode)archiveMode, protocolloEffettivo, userLogin, archiviHelper.smista(), strutsBean.updateEnabled, strutsBean.importDeletePolicyConfig, strutsBean.importDeletePluginConfig, archiviCore.isConfigurazionePluginsEnabled(), strutsBean.importConfig, nomePddOperativa, archiviHelper);
            dati.add(modalitaDataElement);
            DataElement de = new DataElement();
            de.setLabel("Riepilogo Configurazioni Effettuate");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("");
            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
            de.setValue(esito);
            de.setName("Resoconto");
            de.setRows(30);
            de.setCols(130);
            dati.add(de);
            if (esito != null && !"".equals(esito)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)esito, (String)"DownloadResocontoValore");
                DataElement saveAs = new DataElement();
                saveAs.setValue("Download");
                saveAs.setType(DataElementType.LINK);
                saveAs.setUrl("downloadResoconto");
                saveAs.setDisabilitaAjaxStatus();
                dati.add(saveAs);
            }
            pd.disableEditMode();
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"import", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_IMPORT);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"import", (ForwardParams)ArchiviCostanti.TIPO_OPERAZIONE_IMPORT);
        }
    }
}

