/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;

public class ResocontoExporter
extends HttpServlet {
    private static final long serialVersionUID = -7341279067126334095L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        ControlStationCore.logDebug("Ricevuta Richiesta di esportazione resoconto...");
        try {
            Object valore = request.getSession().getAttribute("DownloadResocontoValore");
            if (valore == null) {
                throw new Exception("Resoconto da esportare non presente");
            }
            if (!(valore instanceof String)) {
                throw new Exception("Resoconto da esportare non valido");
            }
            String contenuto = (String)valore;
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)"Resoconto.txt");
            ServletOutputStream out = response.getOutputStream();
            out.write(contenuto.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il download del resoconto: " + e.getMessage(), e);
        }
    }
}

