/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.controllo_traffico.utils.PolicyUtilities;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneControlloTrafficoAttivazionePolicyChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOperazione = TipoOperazione.CHANGE;
        try {
            String errorAttivazione;
            StringBuilder sbParsingError = new StringBuilder();
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            PorteDelegateCore pdCore = new PorteDelegateCore(confCore);
            PorteApplicativeCore paCore = new PorteApplicativeCore(confCore);
            ConfigurazioneGenerale configurazioneControlloTraffico = confCore.getConfigurazioneControlloTraffico();
            boolean first = confHelper.isFirstTimeFromHttpParameters("CTFirstTime");
            String ruoloPortaParam = confHelper.getParameter("CTPolicyRuoloPorta");
            RuoloPolicy ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPolicy.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("CTPolicyNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParameter("CTPolicyServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String id = confHelper.getParameter("CTPolicyId");
            long idPolicyL = Long.parseLong(id);
            AttivazionePolicy policy = confCore.getAttivazionePolicy(idPolicyL);
            policy.setAlias(PolicyUtilities.getNomeActivePolicy((String)policy.getAlias(), (String)policy.getIdActivePolicy()));
            String idPolicy = confHelper.getParameter("CTPolicyActiveId");
            if (idPolicy != null && !"".equals(idPolicy) && !"-".equals(idPolicy)) {
                policy.setIdPolicy(idPolicy);
            } else if (!first) {
                policy.setIdPolicy(null);
            }
            InfoPolicy infoPolicy = null;
            if (policy.getIdPolicy() != null) {
                infoPolicy = confCore.getInfoPolicy(policy.getIdPolicy());
            }
            if ((errorAttivazione = confHelper.readDatiAttivazionePolicyFromHttpParameters(policy, first, tipoOperazione, infoPolicy)) != null) {
                confHelper.addParsingError(sbParsingError, errorAttivazione);
            }
            PolicyGroupByActiveThreadsType type = null;
            if (ruoloPorta != null) {
                PolicyConfiguration config;
                PortaDelegata porta;
                if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(nomePorta);
                    porta = pdCore.getPortaDelegata(idPD);
                    config = new PolicyConfiguration(porta.getProprietaRateLimitingList(), confCore.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
                    type = config.getType();
                } else {
                    IDPortaApplicativa idPA = new IDPortaApplicativa();
                    idPA.setNome(nomePorta);
                    porta = paCore.getPortaApplicativa(idPA);
                    config = new PolicyConfiguration(porta.getProprietaRateLimitingList(), confCore.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
                    type = config.getType();
                }
            }
            confHelper.makeMenu();
            List<Parameter> lstParamPorta = null;
            if (ruoloPorta != null) {
                lstParamPorta = confHelper.getTitleListAttivazionePolicy(ruoloPorta, nomePorta, serviceBinding, PolicyUtilities.getNomeActivePolicy((String)policy.getAlias(), (String)policy.getIdPolicy()));
            }
            ArrayList<Parameter> lstParam = null;
            if (lstParamPorta != null) {
                lstParam = lstParamPorta;
            } else {
                lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Controllo del Traffico", "configurazioneControlloTraffico.do"));
                lstParam.add(new Parameter("Policy Globali", "configurazioneControlloTrafficoAttivazionePolicyList.do"));
                lstParam.add(new Parameter(PolicyUtilities.getNomeActivePolicy((String)policy.getAlias(), (String)policy.getIdPolicy()), null));
            }
            ArrayList<InfoPolicy> infoPolicies = new ArrayList<InfoPolicy>();
            infoPolicies.add(infoPolicy);
            if (confHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAttivazionePolicyToDati(dati, tipoOperazione, policy, "Policy", infoPolicies, ruoloPorta, nomePorta, serviceBinding, null, type);
                confHelper.addToDatiFirstTimeDisabled(dati, "CTFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.CHANGE());
            }
            String modalitaCheck = infoPolicy.isBuiltIn() ? "Scegli criteri" : "Selezione dal registro";
            boolean isOk = confHelper.attivazionePolicyCheckData(sbParsingError, tipoOperazione, configurazioneControlloTraffico, policy, infoPolicy, ruoloPorta, nomePorta, serviceBinding, modalitaCheck);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addAttivazionePolicyToDati(dati, tipoOperazione, policy, "Policy", infoPolicies, ruoloPorta, nomePorta, serviceBinding, null, type);
                confHelper.addToDatiFirstTimeDisabled(dati, "CTFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.CHANGE());
            }
            if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                String tipoSoggettoProprietario = null;
                String nomeSoggettoProprietario = null;
                if (RuoloPolicy.DELEGATA.equals((Object)ruoloPorta)) {
                    IDPortaDelegata idPD = new IDPortaDelegata();
                    idPD.setNome(nomePorta);
                    PortaDelegata porta = pdCore.getPortaDelegata(idPD);
                    tipoSoggettoProprietario = porta.getTipoSoggettoProprietario();
                    nomeSoggettoProprietario = porta.getNomeSoggettoProprietario();
                }
                policy.getFiltro().setTipoFruitore(tipoSoggettoProprietario);
                policy.getFiltro().setNomeFruitore(nomeSoggettoProprietario);
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), policy);
            String msgCompletato = confHelper.eseguiResetJmx(TipoOperazione.CHANGE, ruoloPorta, nomePorta);
            if (msgCompletato != null && !"".equals(msgCompletato)) {
                pd.setMessage(msgCompletato, Costanti.MESSAGE_TYPE_INFO);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<TipoRisorsaPolicyAttiva> listaTipoRisorsa = confHelper.gestisciCriteriFiltroRisorsaPolicy(ricerca, ruoloPorta, nomePorta);
            List<AttivazionePolicy> lista = confCore.attivazionePolicyList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAttivazionePolicyList(ricerca, lista, listaTipoRisorsa, idLista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

