/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.constants.PluginCostanti;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazionePluginsTipoPluginUtils;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazionePluginsClassiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            String idPluginS = confHelper.getParameter("pcId");
            String descrizione = confHelper.getParameter("pcDescr");
            String stato = confHelper.getParameter("pcStato");
            String tipo = confHelper.getParameter("pcTipo");
            String tipoPluginS = confHelper.getParameter("pcTipoPlugin");
            TipoPlugin tipoPlugin = null;
            if (tipoPluginS != null) {
                tipoPlugin = TipoPlugin.toEnumConstant((String)tipoPluginS);
            }
            String label = confHelper.getParameter("pcLabel");
            String className = confHelper.getParameter("pcClassName");
            String ruolo = confHelper.getParameter("pcFRuolo");
            String shTipo = confHelper.getParameter("pcFSH");
            String mhTipo = confHelper.getParameter("pcFFMH");
            String mhRuolo = confHelper.getParameter("pcFRMH");
            String applicabilita = confHelper.getParameter("pcFAppl");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            confHelper.makeMenu();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro Classi", "configurazionePluginsClassiList.do"));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (stato == null) {
                    tipoPlugin = ConfigurazionePluginsTipoPluginUtils.getTipoPluginDefault();
                    if (tipoPlugin != null) {
                        tipoPluginS = tipoPlugin.toString();
                    }
                    descrizione = "";
                    stato = StatoFunzionalita.ABILITATO.toString();
                    tipo = "";
                    label = "";
                    className = "";
                    ruolo = "Erogazione";
                    shTipo = PluginCostanti.FILTRO_SERVICE_HANDLER_VALORE_INIT;
                    mhTipo = PluginCostanti.FILTRO_FASE_MESSAGE_HANDLER_VALORE_PRE_IN;
                    mhRuolo = PluginCostanti.FILTRO_RUOLO_MESSAGE_HANDLER_VALORE_RICHIESTA;
                    applicabilita = "Configurazione";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addPluginClassiToDati(TipoOperazione.ADD, dati, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.pluginClassiCheckData(TipoOperazione.ADD, null, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addPluginClassiToDati(TipoOperazione.ADD, dati, idPluginS, tipoPlugin, tipo, label, className, stato, descrizione, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.ADD());
            }
            Plugin plugin = new Plugin();
            plugin.setLabel(label);
            plugin.setTipo(tipo);
            plugin.setTipoPlugin(tipoPluginS);
            plugin.setDescrizione(descrizione);
            plugin.setStato(stato.equals(StatoFunzionalita.ABILITATO.getValue()));
            plugin.setClassName(className);
            List<PluginProprietaCompatibilita> listaProprieta = ConfigurazionePluginsTipoPluginUtils.getApplicabilitaClassePlugin(tipoPlugin, ruolo, shTipo, mhTipo, mhRuolo, applicabilita);
            if (!listaProprieta.isEmpty()) {
                plugin.getPluginProprietaCompatibilitaList().addAll(listaProprieta);
            }
            confCore.performCreateOperation(userLogin, confHelper.smista(), plugin);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_CLASSI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<Plugin> lista = confCore.pluginsClassiList((ISearch)ricerca);
            confHelper.preparePluginsClassiList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePluginsClassi", (ForwardParams)ForwardParams.ADD());
        }
    }
}

