/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openspcoop2.pdd.core.jmx.InformazioniStatoPoolThreads;
import org.openspcoop2.pdd.core.jmx.InformazioniStatoPorta;
import org.openspcoop2.pdd.core.jmx.InformazioniStatoPortaCache;
import org.openspcoop2.pdd.timers.TimerState;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.PageData;

public class ConfigurazioneSistemaExporter
extends HttpServlet {
    private static final long serialVersionUID = -7341279067126334095L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        ConfigurazioneHelper confHelper = null;
        try {
            confHelper = new ConfigurazioneHelper(request, pd, session);
            ControlStationCore.logDebug("Ricevuta Richiesta di esportazione configurazione di Sistema...");
            Enumeration<?> en = confHelper.getParameterNames();
            ControlStationCore.logDebug("Parametri (nome = valore):\n-----------------");
            while (en.hasMoreElements()) {
                String param = (String)en.nextElement();
                String value = confHelper.getParameter(param);
                ControlStationCore.logDebug(param + " = " + value);
            }
            ControlStationCore.logDebug("-----------------");
            String alias = confHelper.getParameter("aliasNodo");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)"ConfigurazioneSistema.txt");
            ServletOutputStream out = response.getOutputStream();
            out.write(this.getInformazioniStatoPorta(alias, confCore).getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante l'export della configurazione di sistema: " + e.getMessage(), e);
        }
    }

    private String getInformazioniStatoPorta(String alias, ConfigurazioneCore confCore) throws Exception {
        HashMap<String, String> statoConnessioniAltriDB;
        HashMap<String, String> infoConnessioneAltriDB;
        String infoDatabase;
        String errorGenerateHttpErrorCodeInSoap;
        String errorInstanceId;
        String errorSpecificDetails;
        String errorStatusInSoapFaultCode;
        String errorStatus;
        String errorSpecificTypeInternalError;
        Object errorSpecificTypeProcessResponse;
        String errorSpecificTypeProcessRequest;
        String fileTraceGovWayState;
        String log4j_dump;
        String log4j_tracciamento;
        String dumpPA;
        String dumpPD;
        String tracciamento;
        String log4jIntegrationManager;
        String log4jOpenspcoop;
        String log4jDiagnostica;
        String livelloSeveritaDiagnosticiLog4j;
        String livelloSeveritaDiagnostici;
        String statoServizioIM;
        String statoServizioPA_disabilitazioni;
        String statoServizioPA_abilitazioni;
        String statoServizioPA;
        String statoServizioPD_disabilitazioni;
        String statoServizioPD_abilitazioni;
        String statoServizioPD;
        String messageFactory;
        String vendorJava;
        String versioneJava;
        String confDir;
        String versioneBaseDati;
        String versionePdD;
        InformazioniStatoPorta infoStatoPorta;
        block189: {
            infoStatoPorta = new InformazioniStatoPorta();
            versionePdD = null;
            try {
                versionePdD = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersionePdD(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura della versione della PdD (jmxResourcePdD): " + e.getMessage(), e);
                versionePdD = "Informazione non disponibile";
            }
            versioneBaseDati = null;
            try {
                versioneBaseDati = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersioneBaseDati(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura della versione della base dati (jmxResourcePdD): " + e.getMessage(), e);
                versioneBaseDati = "Informazione non disponibile";
            }
            confDir = null;
            try {
                confDir = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoDirectoryConfigurazione(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura della directory di configurazione (jmxResourcePdD): " + e.getMessage(), e);
                confDir = "Informazione non disponibile";
            }
            versioneJava = null;
            try {
                versioneJava = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVersioneJava(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura della versione di java (jmxResourcePdD): " + e.getMessage(), e);
                versioneJava = "Informazione non disponibile";
            }
            vendorJava = null;
            try {
                vendorJava = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoVendorJava(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura delle informazioni sul vendor di java (jmxResourcePdD): " + e.getMessage(), e);
                vendorJava = "Informazione non disponibile";
            }
            messageFactory = null;
            try {
                messageFactory = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoMessageFactory(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura della message factory (jmxResourcePdD): " + e.getMessage(), e);
                messageFactory = "Informazione non disponibile";
            }
            statoServizioPD = null;
            try {
                statoServizioPD = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaDelegata(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Delegata (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPD = "Informazione non disponibile";
            }
            statoServizioPD_abilitazioni = null;
            try {
                statoServizioPD_abilitazioni = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaDelegataAbilitazioniPuntuali(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Delegata 'Abilitazioni Puntuali' (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPD_abilitazioni = "Informazione non disponibile";
            }
            statoServizioPD_disabilitazioni = null;
            try {
                statoServizioPD_disabilitazioni = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaDelegataDisabilitazioniPuntuali(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Delegata 'Disabilitazioni Puntuali' (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPD_disabilitazioni = "Informazione non disponibile";
            }
            statoServizioPA = null;
            try {
                statoServizioPA = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaApplicativa(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Applicativa (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPA = "Informazione non disponibile";
            }
            statoServizioPA_abilitazioni = null;
            try {
                statoServizioPA_abilitazioni = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaApplicativaAbilitazioniPuntuali(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Applicativa 'Abilitazioni Puntuali' (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPA_abilitazioni = "Informazione non disponibile";
            }
            statoServizioPA_disabilitazioni = null;
            try {
                statoServizioPA_disabilitazioni = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaApplicativaDisabilitazioniPuntuali(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Porta Applicativa 'Disabilitazioni Puntuali' (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioPA_disabilitazioni = "Informazione non disponibile";
            }
            statoServizioIM = null;
            try {
                statoServizioIM = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaStatoServiziPdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoStatoServizioPortaApplicativa(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del servizio Integration Manager (jmxResourcePdD): " + e.getMessage(), e);
                statoServizioIM = "Informazione non disponibile";
            }
            livelloSeveritaDiagnostici = null;
            try {
                livelloSeveritaDiagnostici = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnostici(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura del livello di severit\u00e0 dei diagnostici (jmxResourcePdD): " + e.getMessage(), e);
                livelloSeveritaDiagnostici = "Informazione non disponibile";
            }
            livelloSeveritaDiagnosticiLog4j = null;
            try {
                livelloSeveritaDiagnosticiLog4j = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoSeveritaDiagnosticiLog4j(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura del livello di severit\u00e0 log4j dei diagnostici (jmxResourcePdD): " + e.getMessage(), e);
                livelloSeveritaDiagnosticiLog4j = "Informazione non disponibile";
            }
            log4jDiagnostica = null;
            try {
                log4jDiagnostica = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jDiagnostica(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del file di log Log4j govway_diagnostici.log (jmxResourcePdD): " + e.getMessage(), e);
                log4jDiagnostica = "Informazione non disponibile";
            }
            log4jOpenspcoop = null;
            try {
                log4jOpenspcoop = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jOpenspcoop(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del file di log Log4j govway.log (jmxResourcePdD): " + e.getMessage(), e);
                log4jOpenspcoop = "Informazione non disponibile";
            }
            log4jIntegrationManager = null;
            try {
                log4jIntegrationManager = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jIntegrationManager(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del file di log Log4j govway_integrationManager.log (jmxResourcePdD): " + e.getMessage(), e);
                log4jIntegrationManager = "Informazione non disponibile";
            }
            tracciamento = null;
            try {
                tracciamento = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTracciamento(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del tracciamento buste (jmxResourcePdD): " + e.getMessage(), e);
                tracciamento = "Informazione non disponibile";
            }
            dumpPD = null;
            try {
                dumpPD = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPD(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del dump binario della Porta Delegata (jmxResourcePdD): " + e.getMessage(), e);
                dumpPD = "Informazione non disponibile";
            }
            dumpPA = null;
            try {
                dumpPA = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoDumpPA(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del dump binario della Porta Applicativa (jmxResourcePdD): " + e.getMessage(), e);
                dumpPA = "Informazione non disponibile";
            }
            log4j_tracciamento = null;
            try {
                log4j_tracciamento = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jTracciamento(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del file di log Log4j govway_tracciamento.log (jmxResourcePdD): " + e.getMessage(), e);
                log4j_tracciamento = "Informazione non disponibile";
            }
            log4j_dump = null;
            try {
                log4j_dump = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoLog4jDump(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato del file di log Log4j govway_dump.log (jmxResourcePdD): " + e.getMessage(), e);
                log4j_dump = "Informazione non disponibile";
            }
            fileTraceGovWayState = null;
            try {
                fileTraceGovWayState = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetFileTrace(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato di configurazione del file trace (jmxResourcePdD): " + e.getMessage(), e);
                log4j_dump = "Informazione non disponibile";
            }
            errorSpecificTypeProcessRequest = null;
            try {
                errorSpecificTypeProcessRequest = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalRequestError(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Richiesta)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorSpecificTypeProcessRequest = "Informazione non disponibile";
            }
            String errorSpecificTypeProcessResponse_1 = null;
            try {
                errorSpecificTypeProcessResponse_1 = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeBadResponse(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Risposta)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorSpecificTypeProcessResponse_1 = "Informazione non disponibile";
            }
            String errorSpecificTypeProcessResponse_2 = null;
            try {
                errorSpecificTypeProcessResponse_2 = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalResponseError(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Risposta)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorSpecificTypeProcessResponse_2 = "Informazione non disponibile";
            }
            errorSpecificTypeProcessResponse = null;
            errorSpecificTypeProcessResponse = "Informazione non disponibile".contentEquals(errorSpecificTypeProcessResponse_1) ? errorSpecificTypeProcessResponse_1 : ("Informazione non disponibile".contentEquals(errorSpecificTypeProcessResponse_2) ? errorSpecificTypeProcessResponse_2 : "" + ("true".equals(errorSpecificTypeProcessResponse_1) && "true".equals(errorSpecificTypeProcessResponse_2)));
            errorSpecificTypeInternalError = null;
            try {
                errorSpecificTypeInternalError = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorTypeInternalError(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore 'GovWay-Transaction-ErrorType' (Errori Interni)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorSpecificTypeInternalError = "Informazione non disponibile";
            }
            errorStatus = null;
            try {
                errorStatus = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorStatusCode(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore specifici 'GovWay-Transaction-ErrorStatus' (Http Header / Problem Detail)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorStatus = "Informazione non disponibile";
            }
            errorStatusInSoapFaultCode = null;
            try {
                errorStatusInSoapFaultCode = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorUseStatusCodeAsFaultCode(alias));
            }
            catch (Exception e) {
                String tipo = "Codici di errore specifici 'GovWay-Transaction-ErrorStatus' (SOAP Fault Code)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorStatusInSoapFaultCode = "Informazione non disponibile";
            }
            errorSpecificDetails = null;
            try {
                errorSpecificDetails = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionSpecificErrorDetails(alias));
            }
            catch (Exception e) {
                String tipo = "Dettagli di errore puntuali (Stato)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorSpecificDetails = "Informazione non disponibile";
            }
            errorInstanceId = null;
            try {
                errorInstanceId = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorInstanceId(alias));
            }
            catch (Exception e) {
                String tipo = "Claim 'instance' nei Problem (Stato)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorInstanceId = "Informazione non disponibile";
            }
            errorGenerateHttpErrorCodeInSoap = null;
            try {
                errorGenerateHttpErrorCodeInSoap = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTransactionErrorGenerateHttpHeaderGovWayCode(alias));
            }
            catch (Exception e) {
                String tipo = "Header http 'GovWay-Transaction-ErrorCode' su protocollo SOAP (Stato)";
                ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
                errorGenerateHttpErrorCodeInSoap = "Informazione non disponibile";
            }
            infoDatabase = null;
            try {
                infoDatabase = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniDatabase(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura delle informazioni sul database (jmxResourcePdD): " + e.getMessage(), e);
                infoDatabase = "Informazione non disponibile";
            }
            infoConnessioneAltriDB = null;
            statoConnessioniAltriDB = null;
            try {
                String[] lines;
                String nomiDatasource;
                int numeroDatasource = 0;
                try {
                    String stato = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoNumeroDatasourceGW(alias));
                    if (stato != null && !"".equals(stato)) {
                        numeroDatasource = Integer.valueOf(stato);
                    }
                }
                catch (Exception e) {
                    ControlStationCore.logDebug("Numero di datasource attivi non ottenibili: " + e.getMessage());
                }
                if (numeroDatasource > 0 && (nomiDatasource = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetDatasourcesGW(alias))) != null && !"".equals(nomiDatasource) && (lines = nomiDatasource.split("\n")) != null && lines.length > 0) {
                    for (String line : lines) {
                        String[] tmp;
                        if (!line.startsWith("(") || (tmp = line.split(" ")) == null || tmp.length <= 3) continue;
                        String nomeDS = tmp[2] + " " + tmp[1];
                        try {
                            String idDS = tmp[1].split(":")[1];
                            String statoInfo = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetInformazioniDatabaseDatasourcesGW(alias), idDS);
                            if (infoConnessioneAltriDB == null) {
                                infoConnessioneAltriDB = new HashMap();
                            }
                            infoConnessioneAltriDB.put(nomeDS, statoInfo);
                            if (confCore.isClusterAsyncUpdate()) continue;
                            String statoConnessioni = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaDatasourceGW(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetUsedConnectionsDatasourcesGW(alias), idDS);
                            if (statoConnessioniAltriDB == null) {
                                statoConnessioniAltriDB = new HashMap();
                            }
                            statoConnessioniAltriDB.put(nomeDS, statoConnessioni);
                        }
                        catch (Exception e) {
                            ControlStationCore.logError("Errore durante la lettura delle informazioni verso il database " + nomeDS + " (jmxResourcePdD): " + e.getMessage(), e);
                            if (infoConnessioneAltriDB == null) {
                                infoConnessioneAltriDB = new HashMap();
                            }
                            infoConnessioneAltriDB.put(nomeDS, "Informazione non disponibile");
                            if (confCore.isClusterAsyncUpdate()) continue;
                            if (statoConnessioniAltriDB == null) {
                                statoConnessioniAltriDB = new HashMap();
                            }
                            statoConnessioniAltriDB.put(nomeDS, "Informazione non disponibile");
                        }
                    }
                }
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura delle informazioni verso altri database (jmxResourcePdD): " + e.getMessage(), e);
                if (infoConnessioneAltriDB == null) {
                    infoConnessioneAltriDB = new HashMap<String, String>();
                }
                infoConnessioneAltriDB.put("GovWayDatasources", "Informazione non disponibile");
                if (confCore.isClusterAsyncUpdate()) break block189;
                if (statoConnessioniAltriDB == null) {
                    statoConnessioniAltriDB = new HashMap();
                }
                statoConnessioniAltriDB.put("GovWayDatasources", "Informazione non disponibile");
            }
        }
        if (confCore.isClusterAsyncUpdate()) {
            if (statoConnessioniAltriDB == null) {
                statoConnessioniAltriDB = new HashMap<String, String>();
            }
            statoConnessioniAltriDB.put("GovWayDatasources", "Informazione non disponibile in modalit\u00e0 cluster con async update");
        }
        String infoSSL = null;
        try {
            infoSSL = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCompleteSSL(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni SSL (jmxResourcePdD): " + e.getMessage(), e);
            infoSSL = "Informazione non disponibile";
        }
        String infoCryptographyKeyLength = null;
        try {
            infoCryptographyKeyLength = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCryptographyKeyLength(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sulla lunghezza delle chiavi di cifratura (jmxResourcePdD): " + e.getMessage(), e);
            infoCryptographyKeyLength = "Informazione non disponibile";
        }
        String infoCharset = null;
        try {
            infoCharset = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCharset(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sul charset (jmxResourcePdD): " + e.getMessage(), e);
            infoCharset = "Informazione non disponibile";
        }
        String infoInternazionalizzazione = null;
        try {
            infoInternazionalizzazione = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCompleteInternazionalizzazione(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sull'internazionalizzazione (jmxResourcePdD): " + e.getMessage(), e);
            infoInternazionalizzazione = "Informazione non disponibile";
        }
        String infoTimeZone = null;
        try {
            infoTimeZone = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCompleteTimeZone(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sul TimeZone (jmxResourcePdD): " + e.getMessage(), e);
            infoTimeZone = "Informazione non disponibile";
        }
        String infoProprietaJavaNetworking = null;
        try {
            infoProprietaJavaNetworking = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniCompleteProprietaJavaNetworking(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sulle propriet\u00e0 java di networking (jmxResourcePdD): " + e.getMessage(), e);
            infoProprietaJavaNetworking = "Informazione non disponibile";
        }
        String infoProprietaJavaAltro = null;
        try {
            infoProprietaJavaAltro = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniProprietaJavaAltro(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sulle propriet\u00e0 java (escluse quelle di networking) (jmxResourcePdD): " + e.getMessage(), e);
            infoProprietaJavaAltro = "Informazione non disponibile";
        }
        String infoProprietaSistema = null;
        try {
            infoProprietaSistema = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniProprietaSistema(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sulle propriet\u00e0 di sistema (jmxResourcePdD): " + e.getMessage(), e);
            infoProprietaSistema = "Informazione non disponibile";
        }
        String infoProtocolli = null;
        try {
            infoProtocolli = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoPluginProtocols(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sui protocolli (jmxResourcePdD): " + e.getMessage(), e);
            infoProtocolli = "Informazione non disponibile";
        }
        InformazioniStatoPortaCache[] cacheArray = null;
        List<String> caches = confCore.getJmxPdDCaches(alias);
        if (caches != null && caches.size() > 0) {
            cacheArray = new InformazioniStatoPortaCache[caches.size()];
            int i = 0;
            for (String cacheName : caches) {
                boolean enabled = false;
                try {
                    String stato = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), cacheName, confCore.getJmxPdDCacheNomeAttributoCacheAbilitata(alias));
                    if (stato.equalsIgnoreCase("true")) {
                        enabled = true;
                    }
                }
                catch (Exception e) {
                    ControlStationCore.logError("Errore durante la lettura dello stato della cache [" + cacheName + "](jmxResourcePdD): " + e.getMessage(), e);
                }
                cacheArray[i] = new InformazioniStatoPortaCache(cacheName, enabled);
                if (enabled) {
                    String params = null;
                    try {
                        params = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDCacheType(alias), cacheName, confCore.getJmxPdDCacheNomeMetodoStatoCache(alias));
                    }
                    catch (Exception e) {
                        ControlStationCore.logError("Errore durante la lettura dello stato della cache [" + cacheName + "](jmxResourcePdD): " + e.getMessage(), e);
                        params = "Informazione non disponibile";
                    }
                    cacheArray[i].setStatoCache(params);
                }
                ++i;
            }
        }
        String statsDPoPJti = null;
        try {
            statsDPoPJti = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaGestioneToken(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoPrintStatsDPoPJtiCaches(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle statistiche cache DPoP JTI (jmxResourcePdD): " + e.getMessage(), e);
            statsDPoPJti = null;
        }
        String statoConnessioniDB = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoConnessioniDB = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniDB(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato delle connessioni al database (jmxResourcePdD): " + e.getMessage(), e);
                statoConnessioniDB = "Informazione non disponibile";
            }
        } else {
            statoConnessioniDB = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoConnessioniJMS = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoConnessioniJMS = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniJMS(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato delle connessioni al broker JMS (jmxResourcePdD): " + e.getMessage(), e);
                statoConnessioniJMS = "Informazione non disponibile";
            }
        } else {
            statoConnessioniJMS = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoTransazioniId = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoTransazioniId = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoIdTransazioniAttive(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura degli identificativi delle transazioni attive (jmxResourcePdD): " + e.getMessage(), e);
                statoTransazioniId = "Informazione non disponibile";
            }
        } else {
            statoTransazioniId = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoTransazioniIdProtocollo = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoTransazioniIdProtocollo = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoIdProtocolloTransazioniAttive(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura degli identificativi di protocollo delle transazioni attive (jmxResourcePdD): " + e.getMessage(), e);
                statoTransazioniIdProtocollo = "Informazione non disponibile";
            }
        } else {
            statoTransazioniIdProtocollo = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoTimerVerificaConnessioni = null;
        try {
            statoTimerVerificaConnessioni = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiVerificaConnessioniAttive(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Verifica Connessioni Attive'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerVerificaConnessioni = "Informazione non disponibile";
        }
        String statoConnessioniPD = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoConnessioniPD = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniPD(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato delle connessioni al servizio PD (jmxResourcePdD): " + e.getMessage(), e);
                statoConnessioniPD = "Informazione non disponibile";
            }
        } else {
            statoConnessioniPD = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoConnessioniPA = null;
        if (!confCore.isClusterAsyncUpdate()) {
            try {
                statoConnessioniPA = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaMonitoraggio(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoConnessioniPA(alias));
            }
            catch (Exception e) {
                ControlStationCore.logError("Errore durante la lettura dello stato delle connessioni al servizio PA (jmxResourcePdD): " + e.getMessage(), e);
                statoConnessioniPA = "Informazione non disponibile";
            }
        } else {
            statoConnessioniPA = "Informazione non disponibile in modalit\u00e0 cluster con async update";
        }
        String statoTimerConsegnaAsincrona = null;
        try {
            statoTimerConsegnaAsincrona = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerConsegnaContenutiApplicativi(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Consegna Notifiche'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerConsegnaAsincrona = "Informazione non disponibile";
        }
        TimerState timerState = null;
        try {
            timerState = TimerState.valueOf((String)statoTimerConsegnaAsincrona);
        }
        catch (Throwable tipo) {
            // empty catch block
        }
        boolean timerAttivo = timerState != null && TimerState.ENABLED.equals((Object)timerState);
        ArrayList<InformazioniStatoPoolThreads> statoPoolThread = null;
        if (timerAttivo) {
            statoPoolThread = new ArrayList<InformazioniStatoPoolThreads>();
            List<String> code = confCore.getConsegnaNotificaCode();
            for (String coda : code) {
                String stato = null;
                try {
                    stato = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetThreadPoolStatus(alias), coda);
                }
                catch (Exception e) {
                    ControlStationCore.logError("Errore durante la lettura dello stato del thread pool della coda '" + coda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    stato = "Informazione non disponibile";
                }
                String configurazione = null;
                try {
                    configurazione = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetQueueConfig(alias), coda);
                }
                catch (Exception e) {
                    ControlStationCore.logError("Errore durante la lettura della configurazione del thread pool della coda '" + coda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    configurazione = "Informazione non disponibile";
                }
                String connettoriPrioritari = null;
                try {
                    connettoriPrioritari = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetConnettoriPrioritari(alias), coda);
                }
                catch (Exception e) {
                    ControlStationCore.logError("Errore durante la lettura della configurazione (connettori prioritari) del thread pool della coda '" + coda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    connettoriPrioritari = "Informazione non disponibile";
                }
                String applicativiPrioritari = null;
                try {
                    applicativiPrioritari = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConsegnaContenutiApplicativi(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetApplicativiPrioritari(alias), coda);
                }
                catch (Exception e) {
                    ControlStationCore.logError("Errore durante la lettura della configurazione (applicativi prioritari) del thread pool della coda '" + coda + "' per la consegna agli applicativi (jmxResourcePdD): " + e.getMessage(), e);
                    applicativiPrioritari = "Informazione non disponibile";
                }
                InformazioniStatoPoolThreads info = new InformazioniStatoPoolThreads(coda, stato, configurazione, connettoriPrioritari);
                info.setApplicativiPrioritari(applicativiPrioritari);
                statoPoolThread.add(info);
            }
        }
        String statoTimerGenerazioneStatisticheOrarie = null;
        try {
            statoTimerGenerazioneStatisticheOrarie = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheOrarie(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Statistiche Orarie'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerGenerazioneStatisticheOrarie = "Informazione non disponibile";
        }
        String statoTimerGenerazioneStatisticheGiornaliere = null;
        try {
            statoTimerGenerazioneStatisticheGiornaliere = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheGiornaliere(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Statistiche Giornaliere'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerGenerazioneStatisticheGiornaliere = "Informazione non disponibile";
        }
        String statoTimerGenerazioneStatisticheSettimanali = null;
        try {
            statoTimerGenerazioneStatisticheSettimanali = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheSettimanali(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Statistiche Settimanali'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerGenerazioneStatisticheSettimanali = "Informazione non disponibile";
        }
        String statoTimerGenerazioneStatisticheMensili = null;
        try {
            statoTimerGenerazioneStatisticheMensili = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerStatisticheMensili(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Statistiche Mensili'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerGenerazioneStatisticheMensili = "Informazione non disponibile";
        }
        String statoTimerMessaggiEliminati = null;
        try {
            statoTimerMessaggiEliminati = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiEliminati(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Messaggi Gestiti'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerMessaggiEliminati = "Informazione non disponibile";
        }
        String statoTimerMessaggiScaduti = null;
        try {
            statoTimerMessaggiScaduti = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiScaduti(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Messaggi Scaduti'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerMessaggiScaduti = "Informazione non disponibile";
        }
        String statoTimerBuste = null;
        try {
            statoTimerBuste = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreRepositoryBuste(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Buste Gestite/Scadute'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerBuste = "Informazione non disponibile";
        }
        String statoTimerCorrelazioneApplicativa = null;
        try {
            statoTimerCorrelazioneApplicativa = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaCorrelazioneApplicativa(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Correlazioni Applicative Scadute'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerCorrelazioneApplicativa = "Informazione non disponibile";
        }
        String statoTimerMessaggiNonGestiti = null;
        try {
            statoTimerMessaggiNonGestiti = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreMessaggiPuliziaMessaggiNonGestiti(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Richieste Parziali'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerMessaggiNonGestiti = "Informazione non disponibile";
        }
        String statoTimerMessaggiAnomali = null;
        try {
            statoTimerMessaggiAnomali = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestorePuliziaMessaggiAnomali(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Messaggi Inconsistenti'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerMessaggiAnomali = "Informazione non disponibile";
        }
        String statoTimerMonitoraggioRisorse = null;
        try {
            statoTimerMonitoraggioRisorse = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerMonitoraggioRisorseThread(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Risorse di Sistema'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerMonitoraggioRisorse = "Informazione non disponibile";
        }
        String statoTimerThreshold = null;
        try {
            statoTimerThreshold = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerThresholdThread(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Spazio Disco'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerThreshold = "Informazione non disponibile";
        }
        String statoTimerEventi = null;
        try {
            statoTimerEventi = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerEventi(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Generazione Eventi'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerEventi = "Informazione non disponibile";
        }
        String statoTimerFileSystemRecovery = null;
        try {
            statoTimerFileSystemRecovery = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerFileSystemRecovery(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'FileSystem Recovery'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerFileSystemRecovery = "Informazione non disponibile";
        }
        String statoTimerBusteOneway = null;
        try {
            statoTimerBusteOneway = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteOnewayNonRiscontrate(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Rispedizione Ack Oneway'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerBusteOneway = "Informazione non disponibile";
        }
        String statoTimerBusteAsincrone = null;
        try {
            statoTimerBusteAsincrone = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerGestoreBusteAsincroneNonRiscontrate(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Rispedizione Ack Asincroni'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerBusteAsincrone = "Informazione non disponibile";
        }
        String statoTimerRepositoryStateful = null;
        try {
            statoTimerRepositoryStateful = confCore.getInvoker().readJMXAttribute(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), confCore.getJmxPdDConfigurazioneSistemaNomeAttributoTimerRepositoryStatefulThread(alias));
        }
        catch (Exception e) {
            String tipo = "stato timer 'Repository Stateful'";
            ControlStationCore.logError("Errore durante la lettura dello stato (jmxResourcePdD) [" + tipo + "]: " + e.getMessage(), e);
            statoTimerRepositoryStateful = "Informazione non disponibile";
        }
        String infoInstallazione = null;
        try {
            infoInstallazione = confCore.getInvoker().invokeJMXMethod(alias, confCore.getJmxPdDConfigurazioneSistemaType(alias), confCore.getJmxPdDConfigurazioneSistemaNomeRisorsa(alias), confCore.getJmxPdDConfigurazioneSistemaNomeMetodoInformazioniInstallazione(alias));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante la lettura delle informazioni sull'installazione (jmxResourcePdD): " + e.getMessage(), e);
            infoInstallazione = "Informazione non disponibile";
        }
        return infoStatoPorta.formatStatoPorta(versionePdD, versioneBaseDati, confDir, versioneJava, vendorJava, messageFactory, statoServizioPD, statoServizioPD_abilitazioni, statoServizioPD_disabilitazioni, statoServizioPA, statoServizioPA_abilitazioni, statoServizioPA_disabilitazioni, statoServizioIM, livelloSeveritaDiagnostici, livelloSeveritaDiagnosticiLog4j, "true".equals(log4jDiagnostica), "true".equals(log4jOpenspcoop), "true".equals(log4jIntegrationManager), "true".equals(tracciamento), "true".equals(dumpPD), "true".equals(dumpPA), "true".equals(log4j_tracciamento), "true".equals(log4j_dump), fileTraceGovWayState, "true".equals(errorSpecificTypeProcessRequest), "true".equals(errorSpecificTypeProcessResponse), "true".equals(errorSpecificTypeInternalError), "true".equals(errorStatus), "true".equals(errorStatusInSoapFaultCode), "true".equals(errorSpecificDetails), "true".equals(errorInstanceId), "true".equals(errorGenerateHttpErrorCodeInSoap), infoDatabase, infoConnessioneAltriDB, infoSSL, infoCryptographyKeyLength, infoCharset, infoInternazionalizzazione, infoTimeZone, infoProprietaJavaNetworking, infoProprietaJavaAltro, infoProprietaSistema, infoProtocolli, statoConnessioniDB, statoConnessioniAltriDB, statoConnessioniJMS, statoTransazioniId, statoTransazioniIdProtocollo, statoTimerVerificaConnessioni, statoConnessioniPD, statoConnessioniPA, statoTimerConsegnaAsincrona, statoPoolThread, statoTimerGenerazioneStatisticheOrarie, statoTimerGenerazioneStatisticheGiornaliere, statoTimerGenerazioneStatisticheSettimanali, statoTimerGenerazioneStatisticheMensili, statoTimerMessaggiEliminati, statoTimerMessaggiScaduti, statoTimerBuste, statoTimerCorrelazioneApplicativa, statoTimerMessaggiNonGestiti, statoTimerMessaggiAnomali, statoTimerMonitoraggioRisorse, statoTimerThreshold, statoTimerEventi, statoTimerFileSystemRecovery, statoTimerBusteOneway, statoTimerBusteAsincrone, statoTimerRepositoryStateful, infoInstallazione, statsDPoPJti, cacheArray);
    }
}

