/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.connettori;

import java.io.File;
import java.net.InetSocketAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.constants.CostantiConnettori;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TransferLengthModes;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mvc.properties.provider.InputValidationUtils;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.core.autenticazione.ApiKeyUtilities;
import org.openspcoop2.pdd.core.connettori.ConnettoreFILE;
import org.openspcoop2.pdd.core.connettori.ConnettoreFile_outputConfig;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.PasswordGenerator;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.transport.http.SSLUtilities;
import org.openspcoop2.web.ctrlstat.core.Connettori;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.costanti.TipologiaConnettori;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettoreConverter;
import org.openspcoop2.web.ctrlstat.plugins.servlet.ServletExtendedConnettoreUtils;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreFileUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreHTTPSUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreJMSUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ConnettoriHelper
extends ConsoleHelper {
    private SimpleDateFormat sdfCredenziali = new SimpleDateFormat("dd/MM/yyyy HH:mm:SS");

    public ConnettoriHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        super(request, pd, session);
    }

    public ConnettoriHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        super(core, request, pd, session);
    }

    public SimpleDateFormat getSdfCredenziali() {
        return this.sdfCredenziali;
    }

    public String getAutenticazioneHttp(String autenticazioneHttp, String endpointtype, String user) {
        if (endpointtype != null && (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString()))) {
            if (autenticazioneHttp == null && user != null && !"".equals(user)) {
                autenticazioneHttp = "yes";
            }
        } else {
            autenticazioneHttp = null;
        }
        return autenticazioneHttp;
    }

    public String getAutenticazioneApiKey(String autenticazioneApiKey, String endpointtype, String apiKeyValue) {
        if (endpointtype != null && (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString()))) {
            if (autenticazioneApiKey == null && apiKeyValue != null && !"".equals(apiKeyValue)) {
                autenticazioneApiKey = "yes";
            }
        } else {
            autenticazioneApiKey = null;
        }
        return autenticazioneApiKey;
    }

    public boolean isAutenticazioneApiKey(String apiKeyValue) {
        return apiKeyValue != null && StringUtils.isNotEmpty((String)apiKeyValue);
    }

    public boolean isAutenticazioneApiKeyUseAppId(String appIdValue) {
        return appIdValue != null && StringUtils.isNotEmpty((String)appIdValue);
    }

    public boolean isAutenticazioneApiKeyUseOAS3Names(String apiKeyHeader, String appIdHeader) {
        if (apiKeyHeader == null || "X-API-KEY".equals(apiKeyHeader)) {
            if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                return true;
            }
            return "X-APP-ID".equals(appIdHeader);
        }
        return false;
    }

    public void setTitleProprietaConnettoriCustom(PageData pd, TipoOperazione tipoOperazione, String servlet, String id, String nomeprov, String tipoprov, String nomeservizio, String tiposervizio, String myId, String correlato, String idSoggErogatore, String nomeservizioApplicativo, String idsil, String tipoAccordo, String provider, String idPorta) throws Exception {
        String azioneConnettoreIdPorta;
        if (tipoAccordo != null) {
            // empty if block
        }
        boolean isModalitaCompleta = this.isModalitaCompleta();
        Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
        boolean accessoDaListaAPS = false;
        String accessoDaAPSParametro = null;
        accessoDaAPSParametro = this.getParameter("connettoreDaListaAps");
        if ("true".equals(accessoDaAPSParametro)) {
            accessoDaListaAPS = true;
        }
        if ((azioneConnettoreIdPorta = this.getParameter("fruitoreViewConnettoreAzioneIdPorta")) == null) {
            azioneConnettoreIdPorta = "";
        }
        if ("accordiServizioParteSpecificaChange.do".equals(servlet)) {
            int idServizioInt = Integer.parseInt(id);
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(idServizioInt);
            ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"), new Parameter("Connettore del servizio " + IDServizioFactory.getInstance().getUriFromAccordo(asps), "accordiServizioParteSpecificaChange.do?id=" + id + "&nomeservizio=" + nomeservizio + "&tiposervizio=" + tiposervizio)});
        } else if ("accordiServizioParteSpecificaFruitoriChange.do".equals(servlet)) {
            int idServizioInt = Integer.parseInt(id);
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(idServizioInt);
            int idServizioFruitoreInt = Integer.parseInt(myId);
            Fruitore servFru = this.apsCore.getServizioFruitore(idServizioFruitoreInt);
            String nomefru = servFru.getNome();
            String tipofru = servFru.getTipo();
            Long idSoggettoFruitore = servFru.getIdSoggetto();
            Integer parentPD = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentPD == null) {
                parentPD = 0;
            }
            String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, String.class, (String)"_tabKey_tipologiaErogazione");
            boolean gestioneFruitori = false;
            if (tipologia != null && "fruizione".equals(tipologia)) {
                gestioneFruitori = true;
            }
            boolean viewOnlyConnettore = gestioneFruitori || 2 == parentPD;
            PorteDelegateHelper porteDelegateHelper = new PorteDelegateHelper(this.request, this.pd, this.session);
            List<Parameter> lstParm = porteDelegateHelper.getTitoloPD(2, "" + idSoggettoFruitore, id, myId);
            String protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(asps.getTipo());
            String fruitoreLabel = this.getLabelNomeSoggetto(protocollo, tipofru, nomefru);
            ArrayList<Parameter> lstParameteriASPSFruitoriChange = new ArrayList<Parameter>();
            Parameter pId = new Parameter("id", "" + asps.getId());
            Parameter pIdSoggettoErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
            Parameter pIdFruitore = new Parameter("myId", myId);
            Parameter pConnettoreDaListaAPS = new Parameter("connettoreDaListaAps", accessoDaAPSParametro);
            Parameter pIdProviderFruitore = new Parameter("providerFruitore", "" + idSoggettoFruitore);
            Parameter pAzioneConnettoreIdPorta = new Parameter("fruitoreViewConnettoreAzioneIdPorta", azioneConnettoreIdPorta);
            lstParameteriASPSFruitoriChange.add(pId);
            lstParameteriASPSFruitoriChange.add(pIdFruitore);
            lstParameteriASPSFruitoriChange.add(pIdSoggettoErogatore);
            lstParameteriASPSFruitoriChange.add(pIdProviderFruitore);
            lstParameteriASPSFruitoriChange.add(pConnettoreDaListaAPS);
            lstParameteriASPSFruitoriChange.add(pAzioneConnettoreIdPorta);
            if (viewOnlyConnettore) {
                Object labelPerPorta = null;
                if (accessoDaListaAPS) {
                    labelPerPorta = !isModalitaCompleta ? (vistaErogazioni != null && vistaErogazioni.booleanValue() ? "Connettore" : "Connettore di " + porteDelegateHelper.getLabelIdServizio(asps)) : "Connettore";
                } else {
                    PortaDelegata portaDelegata = this.porteDelegateCore.getPortaDelegata(Long.parseLong(azioneConnettoreIdPorta));
                    labelPerPorta = this.porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata("Connettore di ", "Connettore", portaDelegata);
                }
                Parameter pConnettore = new Parameter((String)labelPerPorta, "accordiServizioParteSpecificaFruitoriChange.do", lstParameteriASPSFruitoriChange.toArray(new Parameter[lstParameteriASPSFruitoriChange.size()]));
                if (accessoDaListaAPS) {
                    lstParm.set(lstParm.size() - 1, pConnettore);
                } else {
                    lstParm.add(pConnettore);
                }
            } else {
                lstParm.set(lstParm.size() - 1, new Parameter(fruitoreLabel, "accordiServizioParteSpecificaFruitoriChange.do", lstParameteriASPSFruitoriChange.toArray(new Parameter[lstParameteriASPSFruitoriChange.size()])));
            }
            ServletUtils.setPageDataTitle((PageData)pd, lstParm);
        } else if ("serviziApplicativiEndPointInvocazioneServizio.do".equals(servlet)) {
            int idInt = Integer.parseInt(idsil);
            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idInt);
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentSA == null) {
                parentSA = 0;
            }
            ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(this.request, this.pd, this.session);
            List<Parameter> lstParm = saHelper.getTitoloSA(parentSA, provider, id, idPorta);
            Object labelPerPorta = null;
            if (parentSA != null && parentSA == 2) {
                AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(id));
                if (accessoDaListaAPS) {
                    labelPerPorta = !isModalitaCompleta ? (vistaErogazioni != null && vistaErogazioni.booleanValue() ? "Connettore" : "Connettore di " + saHelper.getLabelIdServizio(asps)) : "Connettore";
                } else {
                    PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(Long.parseLong(idPorta));
                    labelPerPorta = this.porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Connettore di ", "Connettore", pa);
                }
            } else {
                labelPerPorta = "Connettore del servizio applicativo (InvocazioneServizio) " + nomeservizioApplicativo + " del soggetto " + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario();
            }
            if (accessoDaListaAPS) {
                lstParm.remove(lstParm.size() - 1);
            }
            ArrayList<Parameter> lstParameteriSAEndpoint = new ArrayList<Parameter>();
            lstParameteriSAEndpoint.add(new Parameter("idAsps", id));
            lstParameteriSAEndpoint.add(new Parameter("provider", provider));
            lstParameteriSAEndpoint.add(new Parameter("idsil", idsil));
            lstParameteriSAEndpoint.add(new Parameter("nomeservizioApplicativo", nomeservizioApplicativo));
            lstParameteriSAEndpoint.add(new Parameter("idPorta", idPorta));
            lstParameteriSAEndpoint.add(new Parameter("configurazioneDatiInvocazione", "true"));
            lstParameteriSAEndpoint.add(new Parameter("connettoreDaListaAps", accessoDaAPSParametro));
            lstParm.add(new Parameter((String)labelPerPorta, "serviziApplicativiEndPointInvocazioneServizio.do", lstParameteriSAEndpoint.toArray(new Parameter[lstParameteriSAEndpoint.size()])));
            ServletUtils.setPageDataTitle((PageData)pd, lstParm);
        } else if ("serviziApplicativiEndPointRispostaAsincrona.do".equals(servlet)) {
            int idInt = Integer.parseInt(idsil);
            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idInt);
            if (!this.isModalitaCompleta()) {
                IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
                Soggetto soggettoProprietario = this.soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
                String dominio = this.pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
                ArrayList<Parameter> parametersServletSAChange = new ArrayList<Parameter>();
                Parameter pIdSA = new Parameter("id", "" + sa.getId());
                parametersServletSAChange.add(pIdSA);
                Parameter pIdSoggettoSA = new Parameter("provider", "" + sa.getIdSoggetto());
                parametersServletSAChange.add(pIdSoggettoSA);
                if (dominio != null) {
                    Parameter pDominio = new Parameter("dominio", dominio);
                    parametersServletSAChange.add(pDominio);
                }
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Applicativi", "serviziApplicativiList.do"), new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])), new Parameter("Risposta Asincrona", "serviziApplicativiEndPointRispostaAsincrona.do?nomeservizioApplicativo=" + nomeservizioApplicativo + "&idsil=" + idsil + "&provider=" + provider)});
            } else {
                ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Servizio Applicativo", "serviziApplicativiList.do"), new Parameter("Connettore del servizio applicativo (RispostaAsincrona) " + nomeservizioApplicativo + " del soggetto " + sa.getTipoSoggettoProprietario() + "/" + sa.getNomeSoggettoProprietario(), "serviziApplicativiEndPointRispostaAsincrona.do?nomeservizioApplicativo=" + nomeservizioApplicativo + "&idsil=" + idsil + "&provider=" + provider)});
            }
        } else if ("porteApplicativeConnettoriMultipliChange.do".equals(servlet)) {
            String oldNomeConnettore;
            PortaApplicativa pa;
            int idInt = Integer.parseInt(idsil);
            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idInt);
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentPA == null) {
                parentPA = 0;
            }
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(this.request, this.pd, this.session);
            List<Parameter> lstParam = porteApplicativeHelper.getTitoloPA(parentPA, "" + sa.getIdSoggetto(), id);
            Object labelPerPorta = null;
            if (parentPA != null && parentPA == 2) {
                AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(id));
                if (accessoDaListaAPS) {
                    labelPerPorta = !isModalitaCompleta ? (vistaErogazioni != null && vistaErogazioni.booleanValue() ? "Connettori Multipli" : "Connettori Multipli di " + porteApplicativeHelper.getLabelIdServizio(asps)) : "Connettori Multipli";
                } else {
                    PortaApplicativa pa2 = this.porteApplicativeCore.getPortaApplicativa(Long.parseLong(idPorta));
                    labelPerPorta = this.porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa("Connettori Multipli di ", "Connettori Multipli", pa2);
                }
            } else {
                pa = this.porteApplicativeCore.getPortaApplicativa(Long.parseLong(idPorta));
                labelPerPorta = "Connettori Multipli di " + pa.getNome();
            }
            if (accessoDaListaAPS) {
                lstParam.remove(lstParam.size() - 1);
            }
            pa = this.porteApplicativeCore.getPortaApplicativa(Long.parseLong(idPorta));
            ArrayList<Parameter> lstParamsPA = new ArrayList<Parameter>();
            lstParamsPA.add(new Parameter("idsogg", provider));
            lstParamsPA.add(new Parameter("nome", pa.getNome()));
            lstParamsPA.add(new Parameter("id", idPorta));
            lstParamsPA.add(new Parameter("idAsps", id));
            lstParamsPA.add(new Parameter("paCMNomeSA", sa.getNome()));
            String idTabP = this.getParameter("idConnTab");
            lstParamsPA.add(new Parameter("idConnTab", idTabP));
            String connettoreAccessoGruppi = this.getParameter("connettoreAccessoDaGruppi");
            String connettoreRegistro = this.getParameter("connettoreRegistro");
            lstParamsPA.add(new Parameter("connettoreDaListaAps", accessoDaAPSParametro != null ? accessoDaAPSParametro : ""));
            lstParamsPA.add(new Parameter("connettoreAccessoDaGruppi", connettoreAccessoGruppi));
            lstParamsPA.add(new Parameter("connettoreRegistro", connettoreRegistro));
            lstParamsPA.add(new Parameter("connettoreAccessoDaCM", "true"));
            ArrayList<Parameter> lstParamsPAlist = new ArrayList<Parameter>();
            lstParamsPAlist.addAll(lstParamsPA);
            lstParamsPAlist.add(new Parameter("paCMVDatiG", "true"));
            lstParam.add(new Parameter((String)labelPerPorta, "porteApplicativeConnettoriMultipliList.do", lstParamsPAlist.toArray(new Parameter[lstParamsPAlist.size()])));
            PortaApplicativaServizioApplicativo oldPaSA = null;
            for (PortaApplicativaServizioApplicativo paSATmp : pa.getServizioApplicativoList()) {
                if (!paSATmp.getNome().equals(sa.getNome())) continue;
                oldPaSA = paSATmp;
            }
            String labelPagina = oldNomeConnettore = porteApplicativeHelper.getLabelNomePortaApplicativaServizioApplicativo(oldPaSA);
            ArrayList<Parameter> lstParamsPAchange = new ArrayList<Parameter>();
            lstParamsPAchange.addAll(lstParamsPA);
            lstParamsPAchange.add(new Parameter("paCMVConn", "true"));
            lstParam.add(new Parameter(labelPagina, "porteApplicativeConnettoriMultipliChange.do", lstParamsPAchange.toArray(new Parameter[lstParamsPAchange.size()])));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
        } else if (SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT.equals(servlet)) {
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoprov);
            String label = this.getLabelNomeSoggetto(protocollo, tipoprov, nomeprov);
            ServletUtils.setPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do"), new Parameter("Connettore di " + label, SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT + "?id=" + id + "&nomeprov=" + nomeprov + "&tipoprov=" + tipoprov)});
        }
        if (!TipoOperazione.LIST.equals((Object)tipoOperazione)) {
            ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Propriet&agrave;", "connettoriCustomProprietaList.do", new Parameter[]{new Parameter("servlet", servlet), new Parameter("id", id), new Parameter("nomeprov", nomeprov), new Parameter("tipoprov", tipoprov), new Parameter("nomeservizio", nomeservizio), new Parameter("tiposervizio", tiposervizio), new Parameter("correlato", correlato), new Parameter("myId", myId), new Parameter("idSoggErogatore", idSoggErogatore), new Parameter("nomeservizioApplicativo", nomeservizioApplicativo), new Parameter("idsil", idsil), new Parameter("idPorta", idPorta), new Parameter("connettoreDaListaAps", accessoDaAPSParametro), new Parameter("provider", provider), new Parameter("fruitoreViewConnettoreAzioneIdPorta", azioneConnettoreIdPorta)})});
            ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{ServletUtils.getParameterAggiungi()});
        } else {
            ServletUtils.appendPageDataTitle((PageData)pd, (Parameter[])new Parameter[]{new Parameter("Propriet&agrave;", null)});
        }
    }

    public void prepareConnettorePropList(List<?> lista, ISearch ricerca, int newMyId, String tipoAccordo) throws Exception {
        try {
            String azioneConnettoreIdPorta;
            String accessoDaAPSParametro;
            if (ricerca != null) {
                // empty if block
            }
            String servlet = this.getParameter("servlet");
            String id = this.getParameter("id");
            String nomeprov = this.getParameter("nomeprov");
            String tipoprov = this.getParameter("tipoprov");
            String nomeservizio = this.getParameter("nomeservizio");
            String tiposervizio = this.getParameter("tiposervizio");
            Object myId = this.getParameter("myId");
            if (newMyId != 0) {
                myId = "" + newMyId;
            }
            String correlato = this.getParameter("correlato");
            String idSoggErogatore = this.getParameter("idSoggErogatore");
            String nomeservizioApplicativo = this.getParameter("nomeservizioApplicativo");
            String idsil = this.getParameter("idsil");
            String provider = this.getParameter("provider");
            String idPorta = this.getParameter("idPorta");
            if (idPorta == null) {
                idPorta = "";
            }
            if ((accessoDaAPSParametro = this.getParameter("connettoreDaListaAps")) == null) {
                accessoDaAPSParametro = "";
            }
            if ((azioneConnettoreIdPorta = this.getParameter("fruitoreViewConnettoreAzioneIdPorta")) == null) {
                azioneConnettoreIdPorta = "";
            }
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"connettoriCustomProprieta", (Parameter[])new Parameter[]{new Parameter("servlet", servlet), new Parameter("id", id), new Parameter("nomeprov", nomeprov), new Parameter("tipoprov", tipoprov), new Parameter("nomeservizio", nomeservizio), new Parameter("tiposervizio", tiposervizio), new Parameter("myId", (String)myId), new Parameter("correlato", correlato), new Parameter("idSoggErogatore", idSoggErogatore), new Parameter("nomeservizioApplicativo", nomeservizioApplicativo), new Parameter("idsil", idsil), new Parameter("provider", provider), new Parameter("idPorta", idPorta), new Parameter("connettoreDaListaAps", accessoDaAPSParametro), new Parameter("fruitoreViewConnettoreAzioneIdPorta", azioneConnettoreIdPorta)});
            this.pd.setNumEntries(lista != null ? lista.size() : 0);
            this.setTitleProprietaConnettoriCustom(this.pd, TipoOperazione.LIST, servlet, id, nomeprov, tipoprov, nomeservizio, tiposervizio, (String)myId, correlato, idSoggErogatore, nomeservizioApplicativo, idsil, tipoAccordo, provider, idPorta);
            ServletUtils.disabledPageDataSearch((PageData)this.pd);
            String[] labels = new String[]{"Nome", "Valore"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                Iterator<?> it = lista.iterator();
                while (it.hasNext()) {
                    org.openspcoop2.core.config.Property cp;
                    String nome = "";
                    String valore = "";
                    if (servlet.equals("serviziApplicativiEndPointInvocazioneServizio.do") || servlet.equals("serviziApplicativiEndPointRispostaAsincrona.do") || servlet.equals("porteApplicativeConnettoriMultipliChange.do")) {
                        cp = (org.openspcoop2.core.config.Property)it.next();
                        nome = cp.getNome();
                        valore = cp.getValore();
                    } else {
                        cp = (Property)it.next();
                        nome = cp.getNome();
                        valore = cp.getValore();
                    }
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue(nome);
                    de.setIdToRemove(nome);
                    e.add(de);
                    de = new DataElement();
                    de.setValue(valore);
                    e.add(de);
                    dati.add(e);
                }
            }
            HashMap<String, Object> hidden = new HashMap<String, Object>();
            hidden.put("servlet", servlet);
            hidden.put("id", id != null ? id : "");
            hidden.put("nomeprov", nomeprov != null ? nomeprov : "");
            hidden.put("tipoprov", tipoprov != null ? tipoprov : "");
            hidden.put("nomeservizio", nomeservizio != null ? nomeservizio : "");
            hidden.put("tiposervizio", tiposervizio != null ? tiposervizio : "");
            hidden.put("myId", myId != null ? myId : "");
            hidden.put("correlato", correlato != null ? correlato : "");
            hidden.put("idSoggErogatore", idSoggErogatore != null ? idSoggErogatore : "");
            hidden.put("nomeservizioApplicativo", nomeservizioApplicativo != null ? nomeservizioApplicativo : "");
            hidden.put("idsil", idsil != null ? idsil : "");
            hidden.put("idPorta", idPorta != null ? idPorta : "");
            hidden.put("connettoreDaListaAps", accessoDaAPSParametro != null ? accessoDaAPSParametro : "");
            hidden.put("fruitoreViewConnettoreAzioneIdPorta", azioneConnettoreIdPorta != null ? azioneConnettoreIdPorta : "");
            this.pd.setHidden(hidden);
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("prepareConnettorePropList failed: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public List<DataElement> addEndPointToDati(List<DataElement> dati, ServiceBinding serviceBinding, String connettoreDebug, String endpointtype, String autenticazioneHttp, String prefix, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String objectName, TipoOperazione tipoOperazione, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String servletChiamante, String elem1, String elem2, String elem3, String elem4, String elem5, String elem6, String elem7, String elem8, boolean showSectionTitle, Boolean isConnettoreCustomUltimaImmagineSalvata, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, boolean forcePDND, boolean forceOAuth, boolean forceDPoP, List<ExtendedConnettore> listExtendedConnettore, boolean forceEnabled, String protocollo, boolean forceHttps, boolean forceHttpsClient, boolean visualizzaSezioneSAServer, boolean servizioApplicativoServerEnabled, String servizioApplicativoServer, String[] listaSAServer, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams, boolean postBackViaPost) throws Exception {
        return this.addEndPointToDati(dati, serviceBinding, connettoreDebug, endpointtype, autenticazioneHttp, prefix, url, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, objectName, tipoOperazione, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, servletChiamante, elem1, elem2, elem3, elem4, elem5, elem6, elem7, elem8, null, showSectionTitle, isConnettoreCustomUltimaImmagineSalvata, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, forcePDND, forceOAuth, forceDPoP, listExtendedConnettore, forceEnabled, protocollo, forceHttps, forceHttpsClient, visualizzaSezioneSAServer, servizioApplicativoServerEnabled, servizioApplicativoServer, listaSAServer, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, postBackViaPost);
    }

    boolean connettorePropCheckData() throws CoreException {
        try {
            org.openspcoop2.core.config.Property tmpProp;
            org.openspcoop2.core.config.Connettore connettore;
            ServizioApplicativo sa;
            String servlet = this.getParameter("servlet");
            String id = this.getParameter("id");
            String myId = this.getParameter("myId");
            String idsil = this.getParameter("idsil");
            String nome = this.getParameter("nome");
            String valore = this.getParameter("valore");
            if (nome.equals("") || valore.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (valore.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Valore" : (String)tmpElenco + ", Valore";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1 || valore.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength4000(valore, "Valore")) {
                return false;
            }
            boolean giaRegistratoProprietaNormale = false;
            boolean giaRegistratoProprietaDebug = false;
            if (servlet.equals("accordiServizioParteSpecificaChange.do")) {
                AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Long.parseLong(id));
                Connettore connettore2 = asps.getConfigurazioneServizio().getConnettore();
                for (int j = 0; j < connettore2.sizePropertyList(); ++j) {
                    Property tmpProp2 = connettore2.getProperty(j);
                    if (!tmpProp2.getNome().equals(nome)) continue;
                    if ("debug".equals(nome)) {
                        giaRegistratoProprietaDebug = true;
                        break;
                    }
                    giaRegistratoProprietaNormale = true;
                    break;
                }
            }
            if (servlet.equals("accordiServizioParteSpecificaFruitoriChange.do")) {
                int idServizioFruitoreInt = Integer.parseInt(myId);
                Fruitore servFru = this.apsCore.getServizioFruitore(idServizioFruitoreInt);
                Connettore connettore3 = servFru.getConnettore();
                for (int j = 0; j < connettore3.sizePropertyList(); ++j) {
                    Property tmpProp3 = connettore3.getProperty(j);
                    if (!tmpProp3.getNome().equals(nome)) continue;
                    if ("debug".equals(nome)) {
                        giaRegistratoProprietaDebug = true;
                        break;
                    }
                    giaRegistratoProprietaNormale = true;
                    break;
                }
            }
            if (servlet.equals("serviziApplicativiEndPointInvocazioneServizio.do")) {
                int idSilInt = Integer.parseInt(idsil);
                sa = this.saCore.getServizioApplicativo(idSilInt);
                InvocazioneServizio is = sa.getInvocazioneServizio();
                connettore = is.getConnettore();
                for (int j = 0; j < connettore.sizePropertyList(); ++j) {
                    tmpProp = connettore.getProperty(j);
                    if (!tmpProp.getNome().equals(nome)) continue;
                    if ("debug".equals(nome)) {
                        giaRegistratoProprietaDebug = true;
                        break;
                    }
                    giaRegistratoProprietaNormale = true;
                    break;
                }
            }
            if (servlet.equals("serviziApplicativiEndPointRispostaAsincrona.do")) {
                int idSilInt = Integer.parseInt(idsil);
                sa = this.saCore.getServizioApplicativo(idSilInt);
                RispostaAsincrona ra = sa.getRispostaAsincrona();
                connettore = ra.getConnettore();
                for (int j = 0; j < connettore.sizePropertyList(); ++j) {
                    tmpProp = connettore.getProperty(j);
                    if (!tmpProp.getNome().equals(nome)) continue;
                    if ("debug".equals(nome)) {
                        giaRegistratoProprietaDebug = true;
                        break;
                    }
                    giaRegistratoProprietaNormale = true;
                    break;
                }
            }
            if (servlet.equals(SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT)) {
                int idInt = Integer.parseInt(id);
                SoggettoCtrlStat scs = this.soggettiCore.getSoggettoCtrlStat(idInt);
                Soggetto ss = scs.getSoggettoReg();
                connettore = ss.getConnettore();
                for (int j = 0; j < connettore.sizePropertyList(); ++j) {
                    tmpProp = connettore.getProperty(j);
                    if (!tmpProp.getNome().equals(nome)) continue;
                    if ("debug".equals(nome)) {
                        giaRegistratoProprietaDebug = true;
                        break;
                    }
                    giaRegistratoProprietaNormale = true;
                    break;
                }
            }
            if (giaRegistratoProprietaNormale) {
                this.pd.setMessage("La propriet&agrave; '" + nome + "' &egrave; gi&agrave; stata associata al connettore");
                return false;
            }
            if (giaRegistratoProprietaDebug) {
                this.pd.setMessage("La keyword '" + nome + "' non &egrave; associabile come nome ad una propriet&agrave; del connettore");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("connettorePropCheckData failed: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public String readEndPointType() throws CoreException {
        String endpointtype = this.getParameter("endpointtype");
        String endpointtypeCheck = this.getParameter("endpointtype_ckb");
        String endpointtypeSsl = this.getParameter("endpointtype_https");
        return this.readEndPointType(endpointtype, endpointtypeCheck, endpointtypeSsl);
    }

    public String readEndPointType(String endpointtype, String endpointtypeCheck, String endpointtypeSsl) {
        TipologiaConnettori tipologiaConnettori = null;
        try {
            tipologiaConnettori = Utilities.getTipologiaConnettori(this.core);
        }
        catch (Exception e) {
            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
        }
        if (endpointtypeCheck != null && !"".equals(endpointtypeCheck) && TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP.equals(tipologiaConnettori)) {
            endpointtype = ServletUtils.isCheckBoxEnabled((String)endpointtypeCheck) ? (ServletUtils.isCheckBoxEnabled((String)endpointtypeSsl) ? TipiConnettore.HTTPS.toString() : TipiConnettore.HTTP.toString()) : TipiConnettore.DISABILITATO.toString();
        }
        return endpointtype;
    }

    public List<DataElement> addOpzioniAvanzateHttpToDati(List<DataElement> dati, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, boolean postBackViaPost) {
        DataElement de;
        boolean showOpzioniAvanzate;
        boolean bl = showOpzioniAvanzate = this.isModalitaAvanzata() && ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate);
        if (showOpzioniAvanzate) {
            de = new DataElement();
            de.setLabel("Opzioni Avanzate");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        } else if (this.isModalitaAvanzata() && !ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
            transferMode = null;
            transferModeChunkSize = null;
            redirectMode = null;
            redirectMaxHop = null;
        }
        de = new DataElement();
        de.setName("transfer_mode");
        de.setLabel("Modalit\u00e0 Data Transfer");
        if (showOpzioniAvanzate) {
            if (transferMode == null || "".equals(transferMode)) {
                transferMode = "default";
            }
            de.setType(DataElementType.SELECT);
            de.setValues(ConnettoriCostanti.TIPI_DATA_TRANSFER);
            if (postBackViaPost) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
            de.setSelected(transferMode);
            de.setSize(this.getSize());
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(transferMode);
        dati.add(de);
        de = new DataElement();
        de.setName("transfer_chunk_size");
        de.setLabel("Chunk Length (Bytes)");
        if (showOpzioniAvanzate && TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setSize(this.getSize());
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(transferModeChunkSize);
        dati.add(de);
        de = new DataElement();
        de.setName("redirect_mode");
        de.setLabel("Gestione Redirect");
        if (showOpzioniAvanzate) {
            if (redirectMode == null || "".equals(redirectMode)) {
                redirectMode = "default";
            }
            de.setType(DataElementType.SELECT);
            de.setValues(ConnettoriCostanti.TIPI_GESTIONE_REDIRECT);
            if (postBackViaPost) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
            de.setSelected(redirectMode);
            de.setSize(this.getSize());
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(redirectMode);
        dati.add(de);
        de = new DataElement();
        de.setName("redirect_max_hop");
        de.setLabel("Max Numero di Redirect");
        if (showOpzioniAvanzate && CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setSize(this.getSize());
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(redirectMaxHop);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addOpzioniAvanzateHttpToDatiAsHidden(List<DataElement> dati, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop) {
        boolean showOpzioniAvanzate;
        boolean bl = showOpzioniAvanzate = this.isModalitaAvanzata() && ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate);
        if (!showOpzioniAvanzate && this.isModalitaAvanzata() && !ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
            transferMode = null;
            transferModeChunkSize = null;
            redirectMode = null;
            redirectMaxHop = null;
        }
        DataElement de = new DataElement();
        de.setName("transfer_mode");
        de.setType(DataElementType.HIDDEN);
        de.setValue(transferMode);
        dati.add(de);
        de = new DataElement();
        de.setName("transfer_chunk_size");
        de.setType(DataElementType.HIDDEN);
        de.setValue(transferModeChunkSize);
        dati.add(de);
        de = new DataElement();
        de.setName("redirect_mode");
        de.setType(DataElementType.HIDDEN);
        de.setValue(redirectMode);
        dati.add(de);
        de = new DataElement();
        de.setName("redirect_max_hop");
        de.setType(DataElementType.HIDDEN);
        de.setValue(redirectMaxHop);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTokenPolicyToDatiAsHidden(List<DataElement> dati, boolean autenticazioneToken, String tokenPolicy) {
        DataElement de = new DataElement();
        de.setLabel("Autenticazione Token");
        de.setName("connettore_token_policy_stat");
        de.setType(DataElementType.HIDDEN);
        de.setValue(autenticazioneToken ? "yes" : "no");
        dati.add(de);
        if (autenticazioneToken) {
            de = new DataElement();
            de.setLabel("Policy");
            de.setType(DataElementType.HIDDEN);
            de.setName("connettore_token_policy");
            de.setValue(tokenPolicy);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addProxyToDati(List<DataElement> dati, String proxyHostname, String proxyPort, String proxyUsername, String proxyPassword, boolean postBackViaPost) throws UtilsException {
        if (postBackViaPost) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Proxy");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Hostname");
        de.setValue(proxyHostname);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_proxy_host");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Porta");
        de.setValue(proxyPort);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_proxy_port");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Username");
        de.setValue(StringEscapeUtils.escapeHtml((String)proxyUsername));
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_proxy_username");
        de.setSize(this.getSize());
        de.setRequired(false);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_proxy_password");
        this.core.getLockUtilities().lock(de, proxyPassword);
        de.setSize(this.getSize());
        de.setRequired(false);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addProxyToDatiAsHidden(List<DataElement> dati, String proxyEnabled, String proxyHostname, String proxyPort, String proxyUsername, String proxyPassword) throws UtilsException {
        DataElement de = new DataElement();
        de.setValue(proxyEnabled);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_proxy_enabled");
        dati.add(de);
        de = new DataElement();
        de.setValue(proxyHostname);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_proxy_host");
        dati.add(de);
        de = new DataElement();
        de.setValue(proxyPort);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_proxy_port");
        dati.add(de);
        de = new DataElement();
        de.setValue(StringEscapeUtils.escapeHtml((String)proxyUsername));
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_proxy_username");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_proxy_password");
        this.core.getLockUtilities().lockHidden(de, proxyPassword);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTokenPolicy(List<DataElement> dati, String tokenPolicy, boolean forcePDND, boolean forceOAuth, boolean forceDPoP, TipoOperazione tipoOperazione, boolean postBackViaPost) throws DriverConfigurazioneException {
        List<String> policyFiltered = this.getTokenPolicyNegoziazione(forcePDND, forceOAuth, forceDPoP, true, tokenPolicy, tipoOperazione);
        if (!policyFiltered.contains(tokenPolicy)) {
            tokenPolicy = null;
        }
        DataElement de = new DataElement();
        de.setLabel("Autenticazione Token");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Policy");
        de.setType(DataElementType.SELECT);
        de.setName("connettore_token_policy");
        de.setValues(policyFiltered);
        de.setLabels(policyFiltered);
        de.setSelected(tokenPolicy);
        de.setRequired(true);
        if (postBackViaPost) {
            de.setPostBack_viaPOST(true);
        } else {
            de.setPostBack(true);
        }
        dati.add(de);
        return dati;
    }

    public List<DataElement> addApiKeyToDati(List<DataElement> dati, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, boolean postBackViaPost) throws UtilsException {
        DataElement de = new DataElement();
        de.setLabel("Autenticazione API Key");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        boolean useSubSections = !useOAS3Names && useAppId;
        de = new DataElement();
        de.setName("connettore_apikey_nomi_oas");
        de.setLabel("Nomi Standard OAS3");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(useOAS3Names);
        if (postBackViaPost) {
            de.setPostBack_viaPOST(true);
        } else {
            de.setPostBack(true);
        }
        dati.add(de);
        de = new DataElement();
        de.setName("connettore_appid_use");
        de.setLabel("App ID");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(useAppId);
        if (postBackViaPost) {
            de.setPostBack_viaPOST(true);
        } else {
            de.setPostBack(true);
        }
        dati.add(de);
        if (useSubSections) {
            de = new DataElement();
            de.setLabel("API Key");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        if (!useOAS3Names) {
            de = new DataElement();
            de.setLabel("Header HTTP");
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("connettore_apikey_hdr");
            de.setValue(apiKeyHeader);
            de.setRequired(true);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel(!useSubSections ? "API Key" : "Valore");
        de.setName("connettore_apikey_value");
        this.core.getLockUtilities().lock(de, apiKeyValue);
        de.setRequired(true);
        dati.add(de);
        if (useSubSections) {
            de = new DataElement();
            de.setLabel("App ID");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        if (!useOAS3Names && useAppId) {
            de = new DataElement();
            de.setLabel("Header HTTP");
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("connettore_appid_header");
            de.setValue(appIdHeader);
            de.setRequired(true);
            dati.add(de);
        }
        if (useAppId) {
            de = new DataElement();
            de.setLabel(!useSubSections ? "App ID" : "Valore");
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("connettore_appid_value");
            de.setValue(appIdValue);
            de.setRequired(true);
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addApiKeyToDatiHidden(List<DataElement> dati, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue) throws UtilsException {
        DataElement de = new DataElement();
        de.setName("connettore_apikey_nomi_oas");
        de.setType(DataElementType.HIDDEN);
        de.setValue("" + useOAS3Names);
        dati.add(de);
        de = new DataElement();
        de.setName("connettore_appid_use");
        de.setType(DataElementType.HIDDEN);
        de.setValue("" + useAppId);
        dati.add(de);
        if (!useOAS3Names) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("connettore_apikey_hdr");
            de.setValue(apiKeyHeader);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("connettore_apikey_value");
        this.core.getLockUtilities().lockHidden(de, apiKeyValue);
        dati.add(de);
        if (!useOAS3Names) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("connettore_appid_header");
            de.setValue(appIdHeader);
            dati.add(de);
        }
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_appid_value");
        de.setValue(appIdValue);
        dati.add(de);
        return dati;
    }

    public boolean isTokenPolicyModeUseAuthorizationHeader(String tokenPolicy) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (tokenPolicy == null || "".equals(tokenPolicy) || "-".equals(tokenPolicy)) {
            return false;
        }
        GenericProperties gestorePolicyToken = this.confCore.getGenericProperties(tokenPolicy, "retrievePolicyToken", true);
        for (org.openspcoop2.core.config.Property p : gestorePolicyToken.getPropertyList()) {
            if (!"policy.tokenForward.mode".equals(p.getNome()) || !"RFC6750_header".equals(p.getValore())) continue;
            return true;
        }
        return false;
    }

    public List<DataElement> addTempiRispostaToDati(List<DataElement> dati, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, boolean postBackViaPost) {
        if (postBackViaPost) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Tempi Risposta");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Connection Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setValue(tempiRispostaConnectionTimeout);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_tempi_ct");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Read Timeout");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setValue(tempiRispostaReadTimeout);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_tempi_rt");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tempo Medio di Risposta");
        de.setNote("Indicazione in millisecondi (ms)");
        de.setValue(tempiRispostaTempoMedioRisposta);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("connettore_tempi_avg");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTempiRispostaToDatiAsHidden(List<DataElement> dati, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta) {
        DataElement de = new DataElement();
        de.setValue(tempiRispostaEnabled);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_tempi_redefine");
        dati.add(de);
        de = new DataElement();
        de.setValue(tempiRispostaConnectionTimeout);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_tempi_ct");
        dati.add(de);
        de = new DataElement();
        de.setValue(tempiRispostaReadTimeout);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_tempi_rt");
        dati.add(de);
        de = new DataElement();
        de.setValue(tempiRispostaTempoMedioRisposta);
        de.setType(DataElementType.HIDDEN);
        de.setName("connettore_tempi_avg");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addCredenzialiToDati(List<DataElement> dati, String tipoauth, String utente, String password, String subject, String principal, String toCall, boolean showLabelCredenzialiAccesso, String endpointtype, boolean connettore, boolean visualizzaTipoAutenticazione, String prefix, boolean autenticazioneNessunaAbilitata, boolean postBackViaPost) throws Exception {
        return this.addCredenzialiToDati(null, dati, tipoauth, null, utente, password, subject, principal, toCall, showLabelCredenzialiAccesso, endpointtype, connettore, visualizzaTipoAutenticazione, prefix, autenticazioneNessunaAbilitata, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, false, null, null, null, null, false, null, null, false, false, null, postBackViaPost);
    }

    public List<DataElement> addCredenzialiToDati(List<DataElement> dati, String tipoauth, String utente, String password, String subject, String principal, String toCall, boolean showLabelCredenzialiAccesso, String endpointtype, boolean connettore, boolean visualizzaTipoAutenticazione, String prefix, boolean autenticazioneNessunaAbilitata, String subtitleConfigurazione, boolean postBackViaPost) throws Exception {
        return this.addCredenzialiToDati(null, dati, tipoauth, null, utente, password, subject, principal, toCall, showLabelCredenzialiAccesso, endpointtype, connettore, visualizzaTipoAutenticazione, prefix, autenticazioneNessunaAbilitata, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, subtitleConfigurazione, false, false, null, null, null, null, false, null, null, false, false, null, postBackViaPost);
    }

    public List<DataElement> addCredenzialiToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String tipoauth, String oldtipoauth, String utente, String password, String subject, String principal, String toCall, boolean showLabelCredenzialiAccesso, String endpointtype, boolean connettore, boolean visualizzaTipoAutenticazione, String prefix, boolean autenticazioneNessunaAbilitata, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String changepwd, String multipleApiKey, String appId, String apiKey, boolean visualizzaModificaCertificato, boolean visualizzaAddCertificato, String servletCredenzialiList, List<Parameter> parametersServletCredenzialiList, Integer numeroCertificati, String servletCredenzialiAdd, boolean credenzialiToken, String tokenPolicySA, String tokenClientIdSA, boolean tokenWithHttpsEnabledByConfigSA, boolean dominioEsterno, String protocollo, boolean postBackViaPost) throws Exception {
        return this.addCredenzialiToDati(tipoOperazione, dati, tipoauth, oldtipoauth, utente, password, subject, principal, toCall, showLabelCredenzialiAccesso, endpointtype, connettore, visualizzaTipoAutenticazione, prefix, autenticazioneNessunaAbilitata, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, null, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, credenzialiToken, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, dominioEsterno, protocollo, postBackViaPost);
    }

    public List<DataElement> addCredenzialiToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String tipoauth, String oldtipoauth, String utente, String password, String subject, String principal, String toCall, boolean showLabelCredenzialiAccesso, String endpointtype, boolean connettore, boolean visualizzaTipoAutenticazione, String prefix, boolean autenticazioneNessunaAbilitata, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String changepwd, String multipleApiKey, String appId, String apiKey, String subtitleConfigurazione, boolean visualizzaModificaCertificato, boolean visualizzaAddCertificato, String servletCredenzialiList, List<Parameter> parametersServletCredenzialiList, Integer numeroCertificati, String servletCredenzialiAdd, boolean credenzialiToken, String tokenPolicySA, String tokenClientIdSA, boolean tokenWithHttpsEnabledByConfigSA, boolean dominioEsterno, String protocollo, boolean postBackViaPost) throws Exception {
        if (visualizzaModificaCertificato) {
            // empty if block
        }
        if (dati == null) {
            throw new CoreException("Param dati is null");
        }
        if (subtitleConfigurazione == null) {
            subtitleConfigurazione = "Configurazione";
        }
        DataElement de = null;
        if (prefix == null) {
            prefix = "";
        }
        boolean tokenWithHttsSupportato = false;
        boolean tokenModIPDND = false;
        if (!connettore && dominioEsterno && protocollo != null) {
            ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
            tokenWithHttsSupportato = protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken();
            if (tokenPolicySA != null && StringUtils.isNotEmpty((String)tokenPolicySA)) {
                tokenModIPDND = this.saCore.isPolicyGestioneTokenPDND(tokenPolicySA);
            }
        }
        if (tokenWithHttsSupportato) {
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauth) && tokenWithHttpsEnabledByConfigSA) {
                tipoauth = tokenModIPDND ? ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND : ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH;
            } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoauth)) {
                tipoauth = tokenModIPDND ? ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND : ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH;
            }
        }
        String[] tipoA = null;
        String[] labelTipoA = null;
        if (visualizzaTipoAutenticazione) {
            if ("serviziApplicativiEndPointInvocazioneServizio.do".equals(toCall) || "serviziApplicativiEndPointRispostaAsincrona.do".equals(toCall)) {
                if (TipiConnettore.HTTPS.toString().equals(endpointtype) || TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.JMS.toString().equals(endpointtype) || TipiConnettore.CUSTOM.toString().equals(endpointtype)) {
                    tipoA = new String[]{"nessuna", ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC};
                    labelTipoA = TipiConnettore.HTTPS.toString().equals(endpointtype) || TipiConnettore.HTTP.toString().equals(endpointtype) ? new String[]{CostantiConfigurazione.DISABILITATO.toString(), ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC} : new String[]{CostantiConfigurazione.DISABILITATO.toString(), CostantiConfigurazione.ABILITATO.toString()};
                } else {
                    tipoA = new String[]{"nessuna"};
                    labelTipoA = new String[]{CostantiConfigurazione.DISABILITATO.toString()};
                    tipoauth = "nessuna";
                }
            } else {
                boolean autenticazioneNessuna = autenticazioneNessunaAbilitata;
                if (!"soggettiAdd.do".equals(toCall) && !"soggettiChange.do".equals(toCall)) {
                    boolean creazioneModificaSA;
                    boolean bl = creazioneModificaSA = "serviziApplicativiAdd.do".equals(toCall) || "serviziApplicativiChange.do".equals(toCall);
                    if (this.isModalitaStandard() || !this.isModalitaCompleta() && creazioneModificaSA) {
                        autenticazioneNessuna = false;
                    }
                }
                if (autenticazioneNessuna) {
                    tipoA = ConnettoriCostanti.CREDENZIALI_CON_NESSUNA_VALUES;
                    labelTipoA = ConnettoriCostanti.CREDENZIALI_CON_NESSUNA_LABELS;
                } else {
                    tipoA = ConnettoriCostanti.CREDENZIALI_VALUES;
                    labelTipoA = ConnettoriCostanti.CREDENZIALI_LABELS;
                    if (credenzialiToken) {
                        tipoA = ConnettoriCostanti.CREDENZIALI_CON_TOKEN_VALUES;
                        labelTipoA = ConnettoriCostanti.CREDENZIALI_CON_TOKEN_LABELS;
                    }
                    if (tipoauth == null) {
                        tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
                    }
                }
            }
        } else if (tokenWithHttsSupportato && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo)) {
            visualizzaTipoAutenticazione = true;
            tipoA = ConnettoriCostanti.CREDENZIALI_MODI_ESTERNO_VALUES;
            labelTipoA = ConnettoriCostanti.CREDENZIALI_MODI_ESTERNO_LABELS;
        }
        boolean showSezioneCredenziali = true;
        if (!visualizzaTipoAutenticazione) {
            showSezioneCredenziali = true;
        } else if (tipoA.length == 1) {
            showSezioneCredenziali = false;
        }
        if (showSezioneCredenziali) {
            if (showLabelCredenzialiAccesso) {
                de = new DataElement();
                if (connettore) {
                    if (TipiConnettore.HTTPS.toString().equals(endpointtype) || TipiConnettore.HTTP.toString().equals(endpointtype)) {
                        de.setLabel(prefix + "Autenticazione Http");
                    } else {
                        de.setLabel(prefix + "Autenticazione");
                    }
                } else {
                    de.setLabel(prefix + "Modalit&agrave; di Accesso");
                }
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            if (tokenWithHttsSupportato && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo)) {
                de.setLabel("Sicurezza Messaggio");
            } else if (showLabelCredenzialiAccesso) {
                de.setLabel("Tipo");
            } else {
                de.setLabel("Modalit&agrave; di Accesso");
            }
            if (connettore) {
                de.setName("tipoauthInv");
            } else {
                de.setName("tipoauthCredenziali");
            }
            if (visualizzaTipoAutenticazione) {
                de.setType(DataElementType.SELECT);
                de.setLabels(labelTipoA);
                de.setValues(tipoA);
                de.setSelected(tipoauth);
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setPostBack(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoauth);
            }
            dati.add(de);
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(tipoauth)) {
                de = new DataElement();
                de.setLabel("Utente");
                de.setValue(StringEscapeUtils.escapeHtml((String)utente));
                de.setType(DataElementType.TEXT_EDIT);
                if (connettore) {
                    de.setName("utenteInv");
                } else {
                    de.setName("utenteCredenziali");
                }
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Password");
                de.setValue(StringEscapeUtils.escapeHtml((String)password));
                de.setType(DataElementType.TEXT_EDIT);
                if (connettore) {
                    de.setName("passwordInv");
                    this.core.getLockUtilities().lock(de, password);
                } else {
                    boolean change = "serviziApplicativiChange.do".equals(toCall) || "soggettiChange.do".equals(toCall);
                    boolean soggetti = "soggettiAdd.do".equals(toCall) || "soggettiChange.do".equals(toCall);
                    boolean passwordCifrata = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                    if (change && passwordCifrata) {
                        DataElement deCifratura = new DataElement();
                        deCifratura.setName("confSSLCredVerifTutti");
                        deCifratura.setType(DataElementType.HIDDEN);
                        deCifratura.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                        dati.add(deCifratura);
                    }
                    if (change && !tipoauth.equals(oldtipoauth)) {
                        change = false;
                    }
                    if (change && passwordCifrata) {
                        DataElement deModifica = new DataElement();
                        deModifica.setLabel("Modifica Password");
                        deModifica.setType(DataElementType.CHECKBOX);
                        deModifica.setName("changepwd");
                        if (postBackViaPost) {
                            deModifica.setPostBack_viaPOST(true);
                        } else {
                            deModifica.setPostBack(true);
                        }
                        deModifica.setSelected(changepwd);
                        deModifica.setSize(this.getSize());
                        dati.add(deModifica);
                        de.setType(DataElementType.HIDDEN);
                        de.setName("passwordCredenziali");
                    }
                    if (!change || !passwordCifrata || ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                        int lunghezzaPasswordGenerate;
                        if (change && passwordCifrata && ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                            de.setValue(null);
                            de.setLabel("Nuova Password");
                        }
                        de.setType(DataElementType.CRYPT);
                        de.getPassword().setVisualizzaPasswordChiaro(true);
                        de.getPassword().setVisualizzaBottoneGeneraPassword(true);
                        PasswordVerifier passwordVerifier = null;
                        boolean isBasicPasswordEnableConstraints = false;
                        if (soggetti) {
                            lunghezzaPasswordGenerate = this.connettoriCore.getSoggettiBasicLunghezzaPasswordGenerate();
                            isBasicPasswordEnableConstraints = this.connettoriCore.isSoggettiBasicPasswordEnableConstraints();
                            if (isBasicPasswordEnableConstraints) {
                                passwordVerifier = this.connettoriCore.getSoggettiPasswordVerifier();
                            }
                        } else {
                            lunghezzaPasswordGenerate = this.connettoriCore.getApplicativiBasicLunghezzaPasswordGenerate();
                            isBasicPasswordEnableConstraints = this.connettoriCore.isApplicativiBasicPasswordEnableConstraints();
                            if (isBasicPasswordEnableConstraints) {
                                passwordVerifier = this.connettoriCore.getApplicativiPasswordVerifier();
                            }
                        }
                        if (passwordVerifier != null) {
                            PasswordGenerator passwordGenerator = new PasswordGenerator(passwordVerifier);
                            de.getPassword().setPasswordGenerator(passwordGenerator);
                            de.setNote(passwordVerifier.help("<br/>"));
                        }
                        de.getPassword().getPasswordGenerator().setDefaultLength(lunghezzaPasswordGenerate);
                        de.setName("passwordCredenziali");
                    }
                }
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
            }
            if ((ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth)) && !connettore) {
                boolean add = "soggettiAdd.do".equals(toCall) || "serviziApplicativiAdd.do".equals(toCall);
                boolean visualizzaFieldCert = false;
                boolean visualizzaDownload = false;
                if (add) {
                    visualizzaFieldCert = StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject);
                } else {
                    visualizzaFieldCert = !tipoCredenzialiSSLStatoElaborazioneCertificato.equals("0") && StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject);
                    visualizzaDownload = tipoCredenzialiSSLStatoElaborazioneCertificato.equals("0");
                }
                boolean aggiuntoWizardStep = false;
                if (!add && visualizzaDownload) {
                    de = new DataElement();
                    de.setName("confSSLCredWizStep");
                    de.setValue(tipoCredenzialiSSLStatoElaborazioneCertificato);
                    de.setType(DataElementType.HIDDEN);
                    dati.add(de);
                    aggiuntoWizardStep = true;
                }
                boolean visualizzaSceltaConfigurazione = (visualizzaFieldCert || !tipoCredenzialiSSLSorgente.equals("uploadCert")) && !tipoCredenzialiSSLStatoElaborazioneCertificato.equals("-1");
                de = new DataElement();
                if (dominioEsterno && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo)) {
                    de.setLabel("Certificato");
                } else {
                    de.setLabel(subtitleConfigurazione);
                }
                de.setType(DataElementType.SUBTITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Modalit\u00e0");
                de.setName("confSSLCredenziali");
                if (visualizzaSceltaConfigurazione) {
                    de.setType(DataElementType.SELECT);
                    de.setLabels(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_LABELS);
                    de.setValues(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_VALUES);
                    de.setSelected(tipoCredenzialiSSLSorgente);
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    de.setSize(this.getSize());
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(tipoCredenzialiSSLSorgente);
                }
                dati.add(de);
                if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                    de = new DataElement();
                    de.setLabel("Formato");
                    de.setName("confSSLCredTipoArch");
                    if (visualizzaFieldCert) {
                        de.setType(DataElementType.SELECT);
                        de.setLabels(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_LABELS);
                        de.setValues(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_VALUES);
                        de.setSelected(tipoCredenzialiSSLTipoArchivio.name());
                        de.setSize(this.getSize());
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                        if (ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio) || ArchiveType.JKS.equals((Object)tipoCredenzialiSSLTipoArchivio)) {
                            DataElementInfo dInfo = new DataElementInfo("Formato");
                            if (ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio)) {
                                dInfo.setHeaderBody("&Egrave; possibile caricare un certificato in uno dei seguenti formati:");
                                dInfo.setListBody(ConnettoriCostanti.LABEL_PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_INFO_CER_VALUES);
                            } else {
                                dInfo.setHeaderBody("Se il keystore contiene pi&ugrave; certificati verr&agrave; richiesto di sceglierne uno attraverso la selezione del corrispettivo 'alias'");
                            }
                            de.setInfo(dInfo);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(tipoCredenzialiSSLTipoArchivio.name());
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredFileCertPwd");
                    de.setLabel("Password");
                    de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLFileCertificatoPassword));
                    if (visualizzaFieldCert && (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.JKS) || tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.PKCS12))) {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setSize(this.getSize());
                        if (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.JKS)) {
                            de.setRequired(this.core.isLoadCertificateWizardJksPasswordRequiredRequired());
                        } else if (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.PKCS12)) {
                            de.setRequired(this.core.isLoadCertificateWizardPkcs12PasswordRequiredRequired());
                        } else {
                            de.setRequired(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    dati.add(de);
                    String labelCertificato = null;
                    labelCertificato = ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio) ? "Certificato" : "Archivio";
                    DataElement fileDataElement = tipoCredenzialiSSLFileCertificato.getFileDataElement(labelCertificato, "", this.getSize());
                    fileDataElement.setRequired(true);
                    fileDataElement.setPostBack(false);
                    fileDataElement.setPostBack_viaPOST(false);
                    if (!visualizzaFieldCert) {
                        fileDataElement.setType(DataElementType.HIDDEN);
                    }
                    dati.add(fileDataElement);
                    dati.addAll(tipoCredenzialiSSLFileCertificato.getFileNameDataElement());
                    dati.add(tipoCredenzialiSSLFileCertificato.getFileIdDataElement());
                    if (!visualizzaFieldCert && numeroCertificati <= 1) {
                        de = new DataElement();
                        de.setName("confSSLCredFileModificaCertLink");
                        de.setValue("Cambia " + labelCertificato);
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                        de.setUrl("#");
                        de.setType(DataElementType.LINK);
                        dati.add(de);
                    }
                    if (visualizzaDownload && visualizzaAddCertificato) {
                        de = new DataElement();
                        if (numeroCertificati == 1) {
                            de.setValue("Aggiungi Certificato");
                            de.setUrl(servletCredenzialiAdd, parametersServletCredenzialiList.toArray(new Parameter[parametersServletCredenzialiList.size()]));
                        } else {
                            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
                            if (contaListe != null && contaListe.booleanValue()) {
                                de.setValue("Elenco Certificati (" + numeroCertificati + ")");
                            } else {
                                de.setValue("Elenco Certificati");
                            }
                            de.setUrl(servletCredenzialiList, parametersServletCredenzialiList.toArray(new Parameter[parametersServletCredenzialiList.size()]));
                        }
                        de.setType(DataElementType.LINK);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setLabel("Alias");
                    de.setName("confSSLCredAliasCert");
                    if (listaAliasEstrattiCertificato.size() > 1) {
                        de.setType(DataElementType.SELECT);
                        ArrayList<String> listaLabels = new ArrayList<String>();
                        listaLabels.addAll(listaAliasEstrattiCertificato);
                        listaLabels.add(0, "--");
                        ArrayList<String> listaValues = new ArrayList<String>();
                        listaValues.addAll(listaAliasEstrattiCertificato);
                        listaValues.add(0, "");
                        de.setLabels(listaLabels);
                        de.setValues(listaValues);
                        de.setSelected(tipoCredenzialiSSLAliasCertificato);
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                        de.setSize(this.getSize());
                        de.setRequired(true);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(tipoCredenzialiSSLAliasCertificato);
                    }
                    dati.add(de);
                    if (!(!StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject) || dominioEsterno && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo))) {
                        de = new DataElement();
                        de.setLabel("Certificato " + tipoCredenzialiSSLAliasCertificatoType + " v" + tipoCredenzialiSSLAliasCertificatoVersion);
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                    }
                    if (visualizzaDownload) {
                        de = new DataElement();
                        String idOggetto = null;
                        String tipoOggetto = "";
                        if ("soggettiChange.do".equals(toCall)) {
                            tipoOggetto = "sogg";
                            idOggetto = this.getParameter("id");
                        }
                        if ("serviziApplicativiChange.do".equals(toCall)) {
                            tipoOggetto = "sa";
                            idOggetto = this.getParameter("id");
                        }
                        de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", idOggetto), new Parameter("tipoDocumento", tipoOggetto), new Parameter("tipoDocumentoDaScaricare", "sslCert")});
                        de.setValue("Download");
                        de.setType(DataElementType.LINK);
                        de.setDisabilitaAjaxStatus();
                        dati.add(de);
                    }
                    boolean verificaCompleta = false;
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                        verificaCompleta = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                    }
                    de = new DataElement();
                    de.setName("confSSLCredVerifTutti");
                    de.setLabel("Verifica");
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(verificaCompleta);
                        de.setSize(this.getSize());
                        de.setLabelAffiancata(true);
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                    }
                    dati.add(de);
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject) && !verificaCompleta) {
                        de = new DataElement();
                        de.setName("confSSLCredVerifTuttiNoteDisable");
                        de.setType(DataElementType.NOTE);
                        de.setBold(true);
                        de.setLabel("Attenzione");
                        de.setValue("Con verifica disabilitata l'identificazione avviene analizzando solamente i campi Subject e Issuer");
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertSub");
                    de.setLabel("Subject");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoSubject);
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setRows(3);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertIss");
                    de.setLabel("Issuer");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoIssuer);
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoIssuer)) {
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                        de.setRows(3);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertType");
                    de.setLabel("Type");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoType);
                    de.setType(DataElementType.HIDDEN);
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertVers");
                    de.setLabel("Version");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoVersion);
                    de.setType(DataElementType.HIDDEN);
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertSN");
                    de.setLabel("Serial Number");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoSerialNumber);
                    if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSerialNumber)) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSerialNumber)) {
                        String hexValue = null;
                        try {
                            hexValue = CertificateInfo.formatSerialNumberHex((String)tipoCredenzialiSSLAliasCertificatoSerialNumber, (String)":");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (hexValue != null && StringUtils.isNotEmpty((String)hexValue)) {
                            de = new DataElement();
                            de.setName("confSSLCredAliasCertSNhex");
                            de.setLabel("");
                            de.setValue("(Hex) " + hexValue);
                            de.setType(DataElementType.TEXT);
                            de.setSize(this.getSize());
                            dati.add(de);
                        }
                    }
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertSS");
                    de.setLabel("Self Signed");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoSelfSigned);
                    if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSelfSigned)) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertNB");
                    de.setLabel("Not Before");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoNotBefore);
                    if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoNotBefore)) {
                        de.setType(DataElementType.TEXT);
                        if (this.getSdfCredenziali().parse(tipoCredenzialiSSLAliasCertificatoNotBefore).after(new Date())) {
                            de.setValoreBold();
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName("confSSLCredAliasCertNA");
                    de.setLabel("Not After");
                    de.setValue(tipoCredenzialiSSLAliasCertificatoNotAfter);
                    if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoNotAfter)) {
                        de.setType(DataElementType.TEXT);
                        if (this.getSdfCredenziali().parse(tipoCredenzialiSSLAliasCertificatoNotAfter).before(new Date())) {
                            de.setValoreBoldRed();
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setSize(this.getSize());
                    dati.add(de);
                    if (!aggiuntoWizardStep) {
                        de = new DataElement();
                        de.setName("confSSLCredWizStep");
                        de.setLabel("");
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(tipoCredenzialiSSLStatoElaborazioneCertificato);
                        dati.add(de);
                    }
                } else {
                    de = new DataElement();
                    de.setName("confSSLManSS");
                    de.setLabel("Self Signed");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned));
                    de.setSize(this.getSize());
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Subject");
                    de.setValue(subject);
                    de.setType(DataElementType.TEXT_AREA);
                    de.setName("subjectCredenziali");
                    de.setRows(3);
                    de.setSize(this.getSize());
                    de.setRequired(true);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Issuer");
                    de.setName("subjectIssuer");
                    if (!ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned)) {
                        de.setType(DataElementType.TEXT_AREA);
                        de.setValue(issuer);
                        de.setRows(3);
                        de.setSize(this.getSize());
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("");
                    }
                    dati.add(de);
                }
            }
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(tipoauth) && !connettore) {
                boolean multipleApiKeysEnabled = ServletUtils.isCheckBoxEnabled((String)multipleApiKey);
                boolean appIdModificabile = false;
                boolean change = "serviziApplicativiChange.do".equals(toCall) || "soggettiChange.do".equals(toCall);
                boolean soggetti = "soggettiChange.do".equals(toCall);
                boolean encryptPassword = soggetti ? this.connettoriCore.isSoggettiPasswordEncryptEnabled() : this.connettoriCore.isApplicativiPasswordEncryptEnabled();
                boolean modificaApiKey = ServletUtils.isCheckBoxEnabled((String)changepwd);
                String suffixOld = "";
                if (modificaApiKey) {
                    suffixOld = "__OLD";
                }
                boolean passwordCifrata = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                if (change && passwordCifrata) {
                    DataElement deCifratura = new DataElement();
                    deCifratura.setName("confSSLCredVerifTutti");
                    deCifratura.setType(DataElementType.HIDDEN);
                    deCifratura.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                    dati.add(deCifratura);
                }
                if (change && !tipoauth.equals(oldtipoauth)) {
                    change = false;
                }
                de = new DataElement();
                de.setName("apiKeyMultipleCred" + suffixOld);
                de.setLabel("App ID");
                if (change) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(multipleApiKey);
                    if (!modificaApiKey) {
                        DataElement deLabel = new DataElement();
                        deLabel.setLabel("App ID");
                        deLabel.setName("apiKeyMultipleCred__label");
                        if (!multipleApiKeysEnabled) {
                            deLabel.setType(DataElementType.TEXT);
                        } else {
                            deLabel.setType(DataElementType.HIDDEN);
                        }
                        deLabel.setValue(multipleApiKeysEnabled ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
                        dati.add(deLabel);
                    }
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(multipleApiKeysEnabled);
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                }
                dati.add(de);
                de = new DataElement();
                de.setName("appIdCred" + suffixOld);
                de.setLabel("");
                if (change) {
                    de.setLabel("App ID");
                }
                de.setValue(StringEscapeUtils.escapeHtml((String)appId));
                if (multipleApiKeysEnabled) {
                    if (appIdModificabile) {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setSize(this.getSize());
                        de.setRequired(true);
                    } else if (change && !modificaApiKey) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
                if (change && !modificaApiKey && !encryptPassword && !passwordCifrata) {
                    de = new DataElement();
                    de.setName("apiKeyCred__label");
                    de.setLabel("Api Key");
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setRows(3);
                    if (multipleApiKeysEnabled) {
                        de.setValue(ApiKeyUtilities.encodeMultipleApiKey((String)password));
                    } else {
                        de.setValue(ApiKeyUtilities.encodeApiKey((String)utente, (String)password));
                    }
                    dati.add(de);
                }
                if (change) {
                    DataElement deModifica = new DataElement();
                    deModifica.setLabel("Aggiorna Api Key");
                    deModifica.setType(DataElementType.CHECKBOX);
                    deModifica.setName("changepwd");
                    if (postBackViaPost) {
                        deModifica.setPostBack_viaPOST(true);
                    } else {
                        deModifica.setPostBack(true);
                    }
                    deModifica.setSelected(changepwd);
                    deModifica.setSize(this.getSize());
                    dati.add(deModifica);
                }
                if (modificaApiKey) {
                    de = new DataElement();
                    de.setLabel("Nuova Api Key");
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                    de = new DataElement();
                    de.setName("apiKeyMultipleCred");
                    de.setLabel("App ID");
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(multipleApiKeysEnabled);
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("appIdCred");
                    de.setLabel("");
                    de.setValue(StringEscapeUtils.escapeHtml((String)appId));
                    if (multipleApiKeysEnabled) {
                        if (appIdModificabile) {
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setSize(this.getSize());
                            de.setRequired(true);
                        } else {
                            de.setType(DataElementType.HIDDEN);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("apiKeyCred");
                de.setValue(StringEscapeUtils.escapeHtml((String)apiKey));
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            }
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL.equals(tipoauth) && !connettore) {
                de = new DataElement();
                de.setLabel("UserId");
                de.setValue(StringEscapeUtils.escapeHtml((String)principal));
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("principalCredenziali");
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
            }
            if (!connettore && credenzialiToken && (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth))) {
                if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || dominioEsterno && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo)) {
                    de = new DataElement();
                    if (dominioEsterno && StringUtils.isNotEmpty((String)protocollo) && this.isProfiloModIPA(protocollo)) {
                        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth)) {
                            de.setLabel("ClientId registrato sulla PDND");
                        } else {
                            de.setLabel("Identificativo registrato sull'Authorization Server");
                        }
                    } else {
                        de.setLabel("Credenziali Token");
                    }
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                }
                List<GenericProperties> gestorePolicyTokenListTmp = this.confCore.gestorePolicyTokenList(null, "gestionePolicyToken", null);
                List<Object> gestorePolicyTokenList = null;
                boolean valoreNonSelezionato = true;
                if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth)) {
                    gestorePolicyTokenList = new ArrayList();
                    for (GenericProperties gp : gestorePolicyTokenListTmp) {
                        if (!this.confCore.isPolicyGestioneTokenPDND(gp.getNome())) continue;
                        gestorePolicyTokenList.add(gp);
                    }
                    if (!gestorePolicyTokenList.isEmpty()) {
                        valoreNonSelezionato = false;
                    }
                } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth)) {
                    gestorePolicyTokenList = new ArrayList();
                    for (GenericProperties gp : gestorePolicyTokenListTmp) {
                        if (this.confCore.isPolicyGestioneTokenPDND(gp.getNome())) continue;
                        gestorePolicyTokenList.add(gp);
                    }
                } else {
                    gestorePolicyTokenList = gestorePolicyTokenListTmp;
                }
                String[] policyLabels = null;
                String[] policyValues = null;
                if (!TipoOperazione.CHANGE.equals((Object)tipoOperazione) && valoreNonSelezionato) {
                    policyLabels = new String[gestorePolicyTokenList.size() + 1];
                    policyValues = new String[gestorePolicyTokenList.size() + 1];
                    policyLabels[0] = "-";
                    policyValues[0] = "-";
                } else {
                    policyLabels = new String[gestorePolicyTokenList.size()];
                    policyValues = new String[gestorePolicyTokenList.size()];
                }
                for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                    GenericProperties genericProperties = (GenericProperties)gestorePolicyTokenList.get(i);
                    if (!TipoOperazione.CHANGE.equals((Object)tipoOperazione) && valoreNonSelezionato) {
                        policyLabels[i + 1] = genericProperties.getNome();
                        policyValues[i + 1] = genericProperties.getNome();
                        continue;
                    }
                    policyLabels[i] = genericProperties.getNome();
                    policyValues[i] = genericProperties.getNome();
                }
                de = new DataElement();
                de.setLabel("Token Policy");
                de.setType(DataElementType.SELECT);
                de.setName("tokenPolicyCred");
                de.setSelected(tokenPolicySA);
                de.setValues(policyValues);
                de.setLabels(policyLabels);
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Identificativo");
                de.setValue(StringEscapeUtils.escapeHtml((String)tokenClientIdSA));
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("tokenClientIdCred");
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
            }
        } else {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoauthInv");
            de.setValue("nessuna");
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addEndPointToDati(List<DataElement> dati, ServiceBinding serviceBinding, String connettoreDebug, String endpointtype, String autenticazioneHttp, String prefix, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String objectName, TipoOperazione tipoOperazione, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String servletChiamante, String elem1, String elem2, String elem3, String elem4, String elem5, String elem6, String elem7, String elem8, String stato, boolean showSectionTitle, Boolean isConnettoreCustomUltimaImmagineSalvata, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, boolean forcePDND, boolean forceOAuth, boolean forceDPoP, List<ExtendedConnettore> listExtendedConnettore, boolean forceEnabled, String protocollo, boolean forceHttps, boolean forceHttpsClient, boolean visualizzaSezioneSAServer, boolean servizioApplicativoServerEnabled, String servizioApplicativoServer, String[] listaSAServer, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams, boolean postBackViaPost) throws Exception {
        if (forcePDND || forceOAuth) {
            autenticazioneToken = true;
        }
        if (elem8 == null) {
            // empty if block
        }
        if (dati == null) {
            throw new CoreException("Param dati is null");
        }
        Boolean confPers = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ConfigurazioniPersonalizzate");
        TipologiaConnettori tipologiaConnettori = null;
        try {
            tipologiaConnettori = Utilities.getTipologiaConnettori(this.core);
        }
        catch (Exception e) {
            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
        }
        boolean modi = this.isProfiloModIPA(protocollo);
        boolean fruizione = false;
        boolean forceNoSec = false;
        if (servletChiamante != null) {
            if (servletChiamante.equals("accordiServizioParteSpecificaChange.do") || servletChiamante.equals(SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT)) {
                fruizione = false;
                forceNoSec = true;
            } else if (servletChiamante.equals("accordiServizioParteSpecificaFruitoriChange.do")) {
                fruizione = true;
            } else if (servletChiamante.equals("serviziApplicativiEndPointInvocazioneServizio.do") || servletChiamante.equals("serviziApplicativiEndPointRispostaAsincrona.do") || servletChiamante.equals("porteApplicativeConnettoriMultipliChange.do")) {
                fruizione = false;
            }
        }
        if (this.isModalitaStandard()) {
            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (showSectionTitle) {
            DataElement de = new DataElement();
            de.setLabel(prefix + "Connettore");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        boolean soloConnettoriHttp = false;
        if (forceHttps) {
            if (!this.isProfiloModIPA(protocollo)) {
                endpointtype = TipiConnettore.HTTPS.toString();
            } else if (!TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP.equals(tipologiaConnettori)) {
                soloConnettoriHttp = true;
            }
        }
        if (visualizzaSezioneSAServer && listaSAServer != null && listaSAServer.length > 0) {
            DataElement de = new DataElement();
            de.setLabel("Utilizza Applicativo Server");
            de.setName("saServerEnabled");
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(servizioApplicativoServerEnabled);
            if (postBackViaPost) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Applicativo");
            de.setName("saServer");
            if (servizioApplicativoServerEnabled) {
                de.setSelected(servizioApplicativoServer);
                de.setValues(listaSAServer);
                de.setType(DataElementType.SELECT);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(servizioApplicativoServer);
            }
            dati.add(de);
            if (servizioApplicativoServerEnabled) {
                dati = this.addEndPointToDatiAsHidden(dati, serviceBinding, connettoreDebug, endpointtype, autenticazioneHttp, url, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, objectName, tipoOperazione, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, servletChiamante, elem1, elem2, elem3, elem4, elem5, elem6, elem7, stato, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams);
            }
        }
        if (!servizioApplicativoServerEnabled) {
            if (TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP.equals(tipologiaConnettori)) {
                boolean configurazioneNonVisualizzabile = false;
                DataElement de = new DataElement();
                de.setLabel("Abilitato");
                de.setName("endpointtype_ckb");
                if (!TipiConnettore.HTTP.toString().equals(endpointtype) && !TipiConnettore.HTTPS.toString().equals(endpointtype) && (!TipiConnettore.DISABILITATO.toString().equals(endpointtype) || TipiConnettore.DISABILITATO.toString().equals(endpointtype) && forceEnabled)) {
                    de.setLabel(null);
                    de.setValue("Configurazione non visualizzabile");
                    de.setType(DataElementType.TEXT);
                    configurazioneNonVisualizzabile = true;
                    this.pd.disableEditMode();
                    this.pd.setMessage("Attenzione: Configurazione non standard (Utilizzare l'interfaccia avanzata)", Costanti.MESSAGE_TYPE_INFO);
                    for (int i = 0; i < dati.size(); ++i) {
                        DataElement deCheck = dati.get(i);
                        if (!"saServerEnabled".equals(deCheck.getName())) continue;
                        dati.remove(i);
                        break;
                    }
                } else if (("accordiServizioParteSpecifica".equals(objectName) && TipoOperazione.CHANGE.equals((Object)tipoOperazione) || "accordiServizioParteSpecificaFruitori".equals(objectName) && TipoOperazione.CHANGE.equals((Object)tipoOperazione)) && StatiAccordo.finale.toString().equals(stato) && this.isShowGestioneWorkflowStatoDocumenti()) {
                    if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("yes");
                    } else {
                        de.setLabel(null);
                        de.setType(DataElementType.TEXT);
                        de.setValue(TipiConnettore.DISABILITATO.toString());
                    }
                } else {
                    if (forceEnabled) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("yes");
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                            de.setSelected(true);
                        }
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                }
                dati.add(de);
                de = new DataElement();
                de.setName("endpointtype");
                if (endpointtype.equals(TipiConnettore.HTTP.toString())) {
                    de.setValue(TipiConnettore.HTTP.toString());
                } else if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    de.setValue(TipiConnettore.HTTPS.toString());
                } else {
                    de.setValue(TipiConnettore.DISABILITATO.toString());
                }
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Debug");
                de.setName("connettore_debug");
                de.setType(DataElementType.HIDDEN);
                if (ServletUtils.isCheckBoxEnabled((String)connettoreDebug)) {
                    de.setValue("true");
                } else {
                    de.setValue("false");
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Endpoint");
                Object tmpUrl = url;
                if ((url == null || "".equals(url) || "http://".equals(url) || "https://".equals(url)) && (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString()))) {
                    tmpUrl = this.isProfiloModIPA(protocollo) ? TipiConnettore.HTTPS.toString() + "://" : endpointtype + "://";
                }
                de.setValue((String)tmpUrl);
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    if (!this.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                        de.setType(DataElementType.TEXT_AREA);
                        de.setRequired(true);
                        DataElementInfo dInfoPatternFileName = new DataElementInfo("Endpoint");
                        dInfoPatternFileName.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                        dInfoPatternFileName.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_CONNETTORE_VALORI((boolean)modi, (boolean)fruizione, (boolean)forceNoSec));
                        de.setInfo(dInfoPatternFileName);
                    } else {
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    }
                    de.setRows(3);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setName("url");
                de.setSize(this.getSize());
                dati.add(de);
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    boolean showAutenticazioneHttpBasic = true;
                    if (autenticazioneToken) {
                        showAutenticazioneHttpBasic = forcePDND || forceOAuth ? (tokenPolicy != null && !"".equals(tokenPolicy) && !"-".equals(tokenPolicy) ? !this.isTokenPolicyModeUseAuthorizationHeader(tokenPolicy) : false) : !this.isTokenPolicyModeUseAuthorizationHeader(tokenPolicy);
                    }
                    de = new DataElement();
                    de.setLabel("Autenticazione Http");
                    de.setName("endpointtype_http");
                    if (showAutenticazioneHttpBasic) {
                        de.setType(DataElementType.CHECKBOX);
                        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                            de.setSelected(true);
                        }
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("no");
                        autenticazioneHttp = "no";
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Autenticazione Token");
                    de.setName("connettore_token_policy_stat");
                    if (forcePDND || forceOAuth) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autenticazioneToken);
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                    }
                    dati.add(de);
                    if (forcePDND || forceOAuth) {
                        Object labelBearer;
                        de = new DataElement();
                        de.setLabel("Autenticazione Token");
                        de.setName("connettore_token_policy_stat__label");
                        de.setType(DataElementType.TEXT);
                        Object object = labelBearer = forcePDND ? "Negoziazione Token tramite PDND" : "Negoziazione Token tramite Authorization Server OAuth";
                        if (forceDPoP) {
                            labelBearer = (String)labelBearer + " (DPoP)";
                        }
                        de.setValue((String)labelBearer);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setLabel("Autenticazione API Key");
                    de.setName("endpointtype_apikey");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Autenticazione Https");
                    de.setName("endpointtype_https");
                    de.setType(DataElementType.CHECKBOX);
                    if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Proxy");
                    de.setName("connettore_proxy_enabled");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Ridefinisci Tempi Risposta");
                    de.setName("connettore_tempi_redefine");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                }
                if (!configurazioneNonVisualizzabile && listExtendedConnettore != null && !listExtendedConnettore.isEmpty()) {
                    ServletExtendedConnettoreUtils.addToDatiEnabled(dati, listExtendedConnettore);
                }
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    de = new DataElement();
                    de.setLabel("Opzioni Avanzate");
                    de.setName("opzioni_avanzate");
                    if (this.isModalitaAvanzata()) {
                        de.setType(DataElementType.CHECKBOX);
                        de.setValue(opzioniAvanzate);
                        if (ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
                            de.setSelected(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("no");
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                }
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                    this.addCredenzialiToDati(dati, CostantiConfigurazione.CREDENZIALE_BASIC.getValue(), user, password, password, null, servletChiamante, true, endpointtype, true, false, prefix, true, postBackViaPost);
                }
                if (autenticazioneToken) {
                    this.addTokenPolicy(dati, tokenPolicy, forcePDND, forceOAuth, forceDPoP, tipoOperazione, postBackViaPost);
                }
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                    this.addApiKeyToDati(dati, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, postBackViaPost);
                }
                if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    ConnettoreHTTPSUtils.addHTTPSDati(dati, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, stato, this.core, this, this.getSize(), false, prefix, forceHttpsClient, modi, fruizione, forceNoSec, postBackViaPost);
                }
                if ((endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) && ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                    this.addProxyToDati(dati, proxyHost, proxyPort, proxyUsername, proxyPassword, postBackViaPost);
                }
                if ((endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) && ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                    this.addTempiRispostaToDati(dati, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, postBackViaPost);
                }
                if (listExtendedConnettore != null && !listExtendedConnettore.isEmpty()) {
                    ServletExtendedConnettoreUtils.addToDatiExtendedInfo(dati, listExtendedConnettore);
                }
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    this.addOpzioniAvanzateHttpToDati(dati, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, postBackViaPost);
                }
            } else {
                List<String> connettoriList = Connettori.getList();
                if (forceEnabled) {
                    int indexDisabled = -1;
                    for (int i = 0; i < connettoriList.size(); ++i) {
                        if (!TipiConnettore.DISABILITATO.getNome().equals(connettoriList.get(i))) continue;
                        indexDisabled = i;
                        break;
                    }
                    if (indexDisabled >= 0) {
                        connettoriList.remove(indexDisabled);
                    }
                }
                int sizeEP = connettoriList.size();
                if (!connettoriList.contains(TipiConnettore.HTTPS.toString())) {
                    ++sizeEP;
                }
                if (confPers != null && confPers.booleanValue() && TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL.equals(tipologiaConnettori)) {
                    ++sizeEP;
                }
                String[] tipoEP = new String[sizeEP];
                connettoriList.toArray(tipoEP);
                int newCount = connettoriList.size();
                if (!connettoriList.contains(TipiConnettore.HTTPS.toString())) {
                    tipoEP[newCount] = TipiConnettore.HTTPS.toString();
                    ++newCount;
                }
                if (confPers != null && confPers.booleanValue() && TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL.equals(tipologiaConnettori)) {
                    tipoEP[newCount] = TipiConnettore.CUSTOM.toString();
                }
                DataElement de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setName("endpointtype");
                if (soloConnettoriHttp) {
                    ArrayList<String> connettoriListHttp = new ArrayList<String>();
                    connettoriListHttp.add(TipiConnettore.HTTP.toString());
                    connettoriListHttp.add(TipiConnettore.HTTPS.toString());
                    de.setValues(connettoriListHttp);
                    ArrayList connettoriListHttpLabels = new ArrayList();
                    connettoriListHttpLabels.add(TipiConnettore.HTTP.getLabel());
                    connettoriListHttpLabels.add(TipiConnettore.HTTPS.getLabel());
                    de.setLabels((List)connettoriListHttpLabels);
                } else {
                    de.setValues(tipoEP);
                    ArrayList<String> connettoriListLabels = new ArrayList<String>();
                    for (String tipoConnettore : tipoEP) {
                        TipiConnettore tipoC = TipiConnettore.toEnumFromName((String)tipoConnettore);
                        if (tipoC != null) {
                            connettoriListLabels.add(tipoC.getLabel());
                            continue;
                        }
                        connettoriListLabels.add(tipoConnettore);
                    }
                    de.setLabels(connettoriListLabels);
                }
                de.setSelected(endpointtype);
                TipiConnettore tipoC = TipiConnettore.toEnumFromName((String)endpointtype);
                if (tipoC != null) {
                    de.setNote(tipoC.getNote());
                }
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setPostBack(true);
                }
                dati.add(de);
                boolean connettoreCustomHidden = endpointtype == null || !endpointtype.equals(TipiConnettore.CUSTOM.toString());
                this.addCustomField(TipoPlugin.CONNETTORE, null, null, "endpointtype", "tipoconn", "Tipo Personalizzato", tipoconn, connettoreCustomHidden, dati, false);
                de = new DataElement();
                de.setLabel("Endpoint");
                Object tmpUrl = url;
                if ((url == null || "".equals(url) || "http://".equals(url) || "https://".equals(url)) && (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString()))) {
                    tmpUrl = this.isProfiloModIPA(protocollo) ? TipiConnettore.HTTPS.toString() + "://" : endpointtype + "://";
                }
                de.setValue((String)tmpUrl);
                if (TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                    if (!this.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
                        de.setType(DataElementType.TEXT_AREA);
                        de.setRequired(true);
                        DataElementInfo dInfoPatternFileName = new DataElementInfo("Endpoint");
                        dInfoPatternFileName.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                        dInfoPatternFileName.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_CONNETTORE_VALORI((boolean)modi, (boolean)fruizione, (boolean)forceNoSec));
                        de.setInfo(dInfoPatternFileName);
                    } else {
                        de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    }
                    de.setRows(3);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setName("url");
                de.setSize(this.getSize());
                dati.add(de);
                if (TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                    boolean showAutenticazioneHttpBasic = true;
                    if (autenticazioneToken) {
                        showAutenticazioneHttpBasic = forcePDND || forceOAuth ? (tokenPolicy != null && !"".equals(tokenPolicy) && !"-".equals(tokenPolicy) ? !this.isTokenPolicyModeUseAuthorizationHeader(tokenPolicy) : false) : !this.isTokenPolicyModeUseAuthorizationHeader(tokenPolicy);
                    }
                    de = new DataElement();
                    de.setLabel("Autenticazione Http");
                    de.setName("endpointtype_http");
                    if (showAutenticazioneHttpBasic) {
                        de.setType(DataElementType.CHECKBOX);
                        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                            de.setSelected(true);
                        }
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("no");
                        autenticazioneHttp = "no";
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Autenticazione Token");
                    de.setName("connettore_token_policy_stat");
                    if (forcePDND || forceOAuth) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autenticazioneToken);
                        if (postBackViaPost) {
                            de.setPostBack_viaPOST(true);
                        } else {
                            de.setPostBack(true);
                        }
                    }
                    dati.add(de);
                    if (forcePDND || forceOAuth) {
                        Object labelBearer;
                        de = new DataElement();
                        de.setLabel("Autenticazione Token");
                        de.setName("connettore_token_policy_stat__label");
                        de.setType(DataElementType.TEXT);
                        Object object = labelBearer = forcePDND ? "Negoziazione Token tramite PDND" : "Negoziazione Token tramite Authorization Server OAuth";
                        if (forceDPoP) {
                            labelBearer = (String)labelBearer + " (DPoP)";
                        }
                        de.setValue((String)labelBearer);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setLabel("Autenticazione API Key");
                    de.setName("endpointtype_apikey");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Proxy");
                    de.setName("connettore_proxy_enabled");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Ridefinisci Tempi Risposta");
                    de.setName("connettore_tempi_redefine");
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                        de.setSelected(true);
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                }
                if (listExtendedConnettore != null && !listExtendedConnettore.isEmpty()) {
                    ServletExtendedConnettoreUtils.addToDatiEnabled(dati, listExtendedConnettore);
                }
                if (TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                    de = new DataElement();
                    de.setLabel("Opzioni Avanzate");
                    de.setName("opzioni_avanzate");
                    if (this.isModalitaAvanzata()) {
                        de.setType(DataElementType.CHECKBOX);
                        de.setValue(opzioniAvanzate);
                        if (ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
                            de.setSelected(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("no");
                    }
                    if (postBackViaPost) {
                        de.setPostBack_viaPOST(true);
                    } else {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Debug");
                de.setName("connettore_debug");
                if (this.core.isShowDebugOptionConnettore() && !TipiConnettore.DISABILITATO.toString().equals(endpointtype)) {
                    de.setType(DataElementType.CHECKBOX);
                    if (ServletUtils.isCheckBoxEnabled((String)connettoreDebug)) {
                        de.setSelected(true);
                    }
                    de.setInfo("Debug", "Se viene abilitata l'opzione, l'intera comunicazione viene registrata nel file govway_connettori.log. La registrazione comprende i payload dei messaggi scambiati, gli headers di trasporto, le informazioni sull'handshake tls, eventuali token oauth negoziati etc ... ");
                    de.setNote("govway_connettori.log");
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                if (ServletUtils.isCheckBoxEnabled((String)connettoreDebug)) {
                    de.setValue("true");
                } else {
                    de.setValue("false");
                }
                dati.add(de);
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                    this.addCredenzialiToDati(dati, CostantiConfigurazione.CREDENZIALE_BASIC.getValue(), user, password, password, null, servletChiamante, true, endpointtype, true, false, prefix, true, postBackViaPost);
                }
                if (autenticazioneToken) {
                    this.addTokenPolicy(dati, tokenPolicy, forcePDND, forceOAuth, forceDPoP, tipoOperazione, postBackViaPost);
                }
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                    this.addApiKeyToDati(dati, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, postBackViaPost);
                }
                boolean showProprietaCustom = false;
                if (endpointtype != null && endpointtype.equals(TipiConnettore.CUSTOM.toString()) && !servletChiamante.equals("accordiServizioParteSpecificaAdd.do") && !servletChiamante.equals("accordiServizioParteSpecificaFruitoriAdd.do") && isConnettoreCustomUltimaImmagineSalvata != null && isConnettoreCustomUltimaImmagineSalvata.booleanValue()) {
                    showProprietaCustom = true;
                    String postBack = this.getPostBackElementName();
                    if ("endpointtype".equals(postBack) || "tipoconn".equals(postBack)) {
                        showProprietaCustom = false;
                    }
                }
                if (showProprietaCustom) {
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setName("proprietaConnettoreCustom");
                    int numProp = 0;
                    try {
                        if (servletChiamante.equals("accordiServizioParteSpecificaChange.do")) {
                            de.setUrl("connettoriCustomProprietaList.do", new Parameter[]{new Parameter("servlet", servletChiamante), new Parameter("id", elem1), new Parameter("nomeservizio", elem2), new Parameter("tiposervizio", elem3), new Parameter("versioneservizio", elem4)});
                            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Long.parseLong(elem1));
                            Connettore connettore = asps.getConfigurazioneServizio().getConnettore();
                            if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                    if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                    ++numProp;
                                }
                            }
                        } else if (servletChiamante.equals("accordiServizioParteSpecificaFruitoriChange.do")) {
                            ArrayList<Parameter> lstParams = new ArrayList<Parameter>();
                            String accessoDaAPSParametro = this.getParameter("connettoreDaListaAps");
                            if (accessoDaAPSParametro != null) {
                                lstParams.add(new Parameter("connettoreDaListaAps", accessoDaAPSParametro));
                            }
                            lstParams.add(new Parameter("servlet", servletChiamante));
                            lstParams.add(new Parameter("id", elem1));
                            lstParams.add(new Parameter("myId", elem2));
                            lstParams.add(new Parameter("idSoggErogatore", elem3));
                            lstParams.add(new Parameter("fruitoreViewConnettoreAzioneIdPorta", elem4));
                            de.setUrl("connettoriCustomProprietaList.do", lstParams.toArray(new Parameter[lstParams.size()]));
                            int idServizioFruitoreInt = Integer.parseInt(elem2);
                            Fruitore servFru = this.apsCore.getServizioFruitore(idServizioFruitoreInt);
                            Connettore connettore = servFru.getConnettore();
                            if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                    if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                    ++numProp;
                                }
                            }
                        } else if (servletChiamante.equals("serviziApplicativiEndPointInvocazioneServizio.do") || servletChiamante.equals("serviziApplicativiEndPointRispostaAsincrona.do")) {
                            int idSilInt = Integer.parseInt(elem2);
                            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idSilInt);
                            Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                            ArrayList<Parameter> lstParams = new ArrayList<Parameter>();
                            lstParams.add(new Parameter("servlet", servletChiamante));
                            lstParams.add(new Parameter("nomeservizioApplicativo", elem1));
                            lstParams.add(new Parameter("idsil", elem2));
                            if (elem3 != null) {
                                lstParams.add(new Parameter("id", elem3));
                            }
                            if (elem4 != null) {
                                lstParams.add(new Parameter("idPorta", elem4));
                            }
                            lstParams.add(new Parameter("provider", "" + soggetto.getId()));
                            String accessoDaAPSParametro = this.getParameter("connettoreDaListaAps");
                            if (accessoDaAPSParametro != null) {
                                lstParams.add(new Parameter("connettoreDaListaAps", accessoDaAPSParametro));
                            }
                            de.setUrl("connettoriCustomProprietaList.do", lstParams.toArray(new Parameter[lstParams.size()]));
                            if (servletChiamante.equals("serviziApplicativiEndPointInvocazioneServizio.do")) {
                                InvocazioneServizio is = sa.getInvocazioneServizio();
                                org.openspcoop2.core.config.Connettore connettore = is.getConnettore();
                                if (!(connettore == null || connettore.getCustom() != null && connettore.getCustom().booleanValue())) {
                                    de.setType(DataElementType.HIDDEN);
                                }
                                if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                        if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                        ++numProp;
                                    }
                                }
                            } else {
                                RispostaAsincrona ra = sa.getRispostaAsincrona();
                                org.openspcoop2.core.config.Connettore connettore = ra.getConnettore();
                                if (!(connettore == null || connettore.getCustom() != null && connettore.getCustom().booleanValue())) {
                                    de.setType(DataElementType.HIDDEN);
                                }
                                if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                    for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                        if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                        ++numProp;
                                    }
                                }
                            }
                        } else if (servletChiamante.equals("porteApplicativeConnettoriMultipliChange.do")) {
                            int idSilInt = Integer.parseInt(elem6);
                            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idSilInt);
                            Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                            ArrayList<Parameter> lstParams = new ArrayList<Parameter>();
                            lstParams.add(new Parameter("servlet", servletChiamante));
                            lstParams.add(new Parameter("nomeservizioApplicativo", sa.getNome()));
                            lstParams.add(new Parameter("idsil", elem6));
                            if (elem3 != null) {
                                lstParams.add(new Parameter("id", elem3));
                            }
                            if (elem1 != null) {
                                lstParams.add(new Parameter("idPorta", elem1));
                            }
                            lstParams.add(new Parameter("provider", "" + soggetto.getId()));
                            String accessoDaAPSParametro = this.getParameter("connettoreDaListaAps");
                            String connettoreAccessoGruppi = this.getParameter("connettoreAccessoDaGruppi");
                            String connettoreRegistro = this.getParameter("connettoreRegistro");
                            lstParams.add(new Parameter("idConnTab", elem7));
                            lstParams.add(new Parameter("paCMVDatiG", "true"));
                            lstParams.add(new Parameter("connettoreDaListaAps", accessoDaAPSParametro != null ? accessoDaAPSParametro : ""));
                            lstParams.add(new Parameter("connettoreAccessoDaGruppi", connettoreAccessoGruppi));
                            lstParams.add(new Parameter("connettoreRegistro", connettoreRegistro));
                            lstParams.add(new Parameter("connettoreAccessoDaCM", "true"));
                            de.setUrl("connettoriCustomProprietaList.do", lstParams.toArray(new Parameter[lstParams.size()]));
                            InvocazioneServizio is = sa.getInvocazioneServizio();
                            org.openspcoop2.core.config.Connettore connettore = is.getConnettore();
                            if (connettore == null || connettore.getCustom() == null || !connettore.getCustom().booleanValue()) {
                                de.setType(DataElementType.HIDDEN);
                            }
                            if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                    if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                    ++numProp;
                                }
                            }
                        } else if (servletChiamante.equals(SoggettiCostanti.SERVLET_NAME_SOGGETTI_ENDPOINT)) {
                            de.setUrl("connettoriCustomProprietaList.do", new Parameter[]{new Parameter("servlet", servletChiamante), new Parameter("id", elem1), new Parameter("nomeprov", elem2), new Parameter("tipoprov", elem3)});
                            int idInt = Integer.parseInt(elem1);
                            SoggettoCtrlStat scs = this.soggettiCore.getSoggettoCtrlStat(idInt);
                            Soggetto ss = scs.getSoggettoReg();
                            Connettore connettore = ss.getConnettore();
                            if (connettore != null && connettore.getCustom() != null && connettore.getCustom().booleanValue()) {
                                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                                    if ("debug".equals(connettore.getProperty(i).getNome()) || connettore.getProperty(i).getNome().startsWith("-#ext#-")) continue;
                                    ++numProp;
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        this.logError("Custom Property Exception: " + ex.getMessage(), ex);
                    }
                    de.setValue("Propriet&agrave;(" + numProp + ")");
                    dati.add(de);
                }
                if (TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                    ConnettoreHTTPSUtils.addHTTPSDati(dati, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, stato, this.core, this, this.getSize(), false, prefix, forceHttpsClient, modi, fruizione, forceNoSec, postBackViaPost);
                }
                if (TipiConnettore.JMS.getNome().equals(endpointtype)) {
                    ConnettoreJMSUtils.addJMSDati(dati, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, objectName, tipoOperazione, stato, this.core, this, this.getSize(), postBackViaPost);
                }
                if (TipiConnettore.STATUS.toString().equals(endpointtype)) {
                    connettoreStatusParams.addDati(dati, serviceBinding, postBackViaPost);
                }
                if (TipiConnettore.FILE.toString().equals(endpointtype)) {
                    ConnettoreFileUtils.addFileDati(dati, this.getSize(), this, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, modi, fruizione, forceNoSec, postBackViaPost);
                }
                if ((TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) && ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                    this.addProxyToDati(dati, proxyHost, proxyPort, proxyUsername, proxyPassword, postBackViaPost);
                }
                if ((TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) && ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                    this.addTempiRispostaToDati(dati, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, postBackViaPost);
                }
                if (listExtendedConnettore != null && !listExtendedConnettore.isEmpty()) {
                    ServletExtendedConnettoreUtils.addToDatiExtendedInfo(dati, listExtendedConnettore);
                }
                if (TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                    this.addOpzioniAvanzateHttpToDati(dati, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, postBackViaPost);
                }
            }
        }
        return dati;
    }

    public List<DataElement> addEndPointSAServerToDatiAsHidden(List<DataElement> dati, boolean servizioApplicativoServerEnabled, String servizioApplicativoServer) {
        DataElement de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("saServerEnabled");
        de.setValue("" + servizioApplicativoServerEnabled);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("saServer");
        de.setValue(servizioApplicativoServer);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addEndPointToDatiAsHidden(List<DataElement> dati, ServiceBinding serviceBinding, String connettoreDebug, String endpointtype, String autenticazioneHttp, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String objectName, TipoOperazione tipoOperazione, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String servletChiamante, String elem1, String elem2, String elem3, String elem4, String elem5, String elem6, String elem7, String stato, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams) throws DriverControlStationException, UtilsException {
        if (tipo != null || servletChiamante != null) {
            // empty if block
        }
        if (elem1 != null || elem2 != null || elem3 != null || elem4 != null || elem5 != null || elem6 != null || elem7 != null) {
            // empty if block
        }
        Boolean confPers = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ConfigurazioniPersonalizzate");
        TipologiaConnettori tipologiaConnettori = null;
        try {
            tipologiaConnettori = Utilities.getTipologiaConnettori(this.core);
        }
        catch (Exception e) {
            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
        }
        if (this.isModalitaStandard()) {
            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP;
        }
        DataElement de = new DataElement();
        de.setLabel("Debug");
        de.setName("connettore_debug");
        de.setType(DataElementType.HIDDEN);
        if (ServletUtils.isCheckBoxEnabled((String)connettoreDebug)) {
            de.setValue("true");
        } else {
            de.setValue("false");
        }
        dati.add(de);
        if (TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP.equals(tipologiaConnettori)) {
            de = new DataElement();
            de.setLabel("Abilitato");
            de.setName("endpointtype_ckb");
            if (!(TipiConnettore.HTTP.toString().equals(endpointtype) || TipiConnettore.HTTPS.toString().equals(endpointtype) || TipiConnettore.DISABILITATO.toString().equals(endpointtype))) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("no");
            } else if (("accordiServizioParteSpecifica".equals(objectName) && TipoOperazione.CHANGE.equals((Object)tipoOperazione) || "accordiServizioParteSpecificaFruitori".equals(objectName) && TipoOperazione.CHANGE.equals((Object)tipoOperazione)) && StatiAccordo.finale.toString().equals(stato) && this.isShowGestioneWorkflowStatoDocumenti()) {
                if (endpointtype.equals(TipiConnettore.HTTP.toString())) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("yes");
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setLabel(TipiConnettore.DISABILITATO.toString());
                    de.setValue("no");
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                if (endpointtype.equals(TipiConnettore.HTTP.toString())) {
                    de.setValue("yes");
                }
            }
            dati.add(de);
            de = new DataElement();
            de.setName("endpointtype");
            if (endpointtype.equals(TipiConnettore.HTTP.toString())) {
                de.setValue(TipiConnettore.HTTP.toString());
            } else if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                de.setValue(TipiConnettore.HTTPS.toString());
            } else {
                de.setValue(TipiConnettore.DISABILITATO.toString());
            }
            de.setType(DataElementType.HIDDEN);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Endpoint");
            String defaultPrefixValue = "http://";
            if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                defaultPrefixValue = "https://";
            }
            de.setValue(url != null && !"".equals(url) && !"http://".equals(url) && !"https://".equals(url) ? url : defaultPrefixValue);
            de.setType(DataElementType.HIDDEN);
            de.setName("url");
            dati.add(de);
        } else {
            int sizeEP = Connettori.getList().size();
            if (!Connettori.getList().contains(TipiConnettore.HTTPS.toString())) {
                ++sizeEP;
            }
            if (confPers != null && confPers.booleanValue() && TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL.equals(tipologiaConnettori)) {
                ++sizeEP;
            }
            String[] tipoEP = new String[sizeEP];
            Connettori.getList().toArray(tipoEP);
            int newCount = Connettori.getList().size();
            if (!Connettori.getList().contains(TipiConnettore.HTTPS.toString())) {
                tipoEP[newCount] = TipiConnettore.HTTPS.toString();
                ++newCount;
            }
            if (confPers != null && confPers.booleanValue() && TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL.equals(tipologiaConnettori)) {
                tipoEP[newCount] = TipiConnettore.CUSTOM.toString();
            }
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.HIDDEN);
            de.setName("endpointtype");
            de.setValue(endpointtype);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Endpoint");
            de.setValue(url);
            de.setType(DataElementType.HIDDEN);
            de.setName("url");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Tipo Personalizzato");
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoconn");
            de.setValue(tipoconn);
            dati.add(de);
        }
        if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            ConnettoreHTTPSUtils.addHTTPSDatiAsHidden(dati, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, stato, this.core, this.getSize());
        }
        if (endpointtype.equals(TipiConnettore.JMS.getNome())) {
            ConnettoreJMSUtils.addJMSDatiAsHidden(dati, nome, tipoconn, user, password, initcont, urlpgk, provurl, connfact, sendas, objectName, tipoOperazione, stato, this.core, this.getSize());
        }
        if (endpointtype.equals(TipiConnettore.FILE.toString())) {
            ConnettoreFileUtils.addFileDatiAsHidden(dati, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime);
        }
        if (endpointtype.equals(TipiConnettore.STATUS.toString())) {
            connettoreStatusParams.addDatiHidden(dati, serviceBinding);
        }
        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            this.addProxyToDatiAsHidden(dati, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword);
        }
        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            this.addTempiRispostaToDatiAsHidden(dati, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta);
        }
        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            this.addOpzioniAvanzateHttpToDatiAsHidden(dati, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop);
        }
        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            this.addTokenPolicyToDatiAsHidden(dati, autenticazioneToken, tokenPolicy);
        }
        if (endpointtype.equals(TipiConnettore.HTTP.toString()) || endpointtype.equals(TipiConnettore.HTTPS.toString())) {
            de = new DataElement();
            de.setName("endpointtype_http");
            de.setType(DataElementType.HIDDEN);
            de.setValue(autenticazioneHttp);
            dati.add(de);
            if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                de = new DataElement();
                de.setName("utenteInv");
                de.setType(DataElementType.HIDDEN);
                de.setValue(StringEscapeUtils.escapeHtml((String)user));
                dati.add(de);
                de = new DataElement();
                de.setName("passwordInv");
                de.setType(DataElementType.HIDDEN);
                this.core.getLockUtilities().lockHidden(de, password);
                dati.add(de);
            }
        }
        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
            this.addApiKeyToDatiHidden(dati, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue);
        }
        return dati;
    }

    public boolean endPointCheckData(ServiceBinding serviceBinding, String protocollo, boolean servizioApplicativo, List<ExtendedConnettore> listExtendedConnettore) throws Exception {
        try {
            String endpointtype = this.readEndPointType();
            String tipoconn = this.getParameter("tipoconn");
            String autenticazioneHttp = this.getParameter("endpointtype_http");
            String autenticazioneTokenS = this.getParameter("connettore_token_policy_stat");
            boolean autenticazioneToken = ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenS);
            String tokenPolicy = this.getParameter("connettore_token_policy");
            String proxyEnabled = this.getParameter("connettore_proxy_enabled");
            String proxyHostname = this.getParameter("connettore_proxy_host");
            String proxyPort = this.getParameter("connettore_proxy_port");
            String proxyUsername = this.getParameter("connettore_proxy_username");
            String proxyPassword = this.getLockedParameter("connettore_proxy_password");
            String tempiRispostaEnabled = this.getParameter("connettore_tempi_redefine");
            String tempiRispostaConnectionTimeout = this.getParameter("connettore_tempi_ct");
            String tempiRispostaReadTimeout = this.getParameter("connettore_tempi_rt");
            String tempiRispostaTempoMedioRisposta = this.getParameter("connettore_tempi_avg");
            String transferMode = this.getParameter("transfer_mode");
            String transferModeChunkSize = this.getParameter("transfer_chunk_size");
            String redirectMode = this.getParameter("redirect_mode");
            String redirectMaxHop = this.getParameter("redirect_max_hop");
            String opzioniAvanzate = ConnettoriHelper.getOpzioniAvanzate(this, transferMode, redirectMode);
            String url = this.getParameter("url");
            String autenticazioneApiKey = this.getParameter("endpointtype_apikey");
            String useOAS3NamesTmp = this.getParameter("connettore_apikey_nomi_oas");
            boolean useOAS3Names = true;
            if (useOAS3NamesTmp != null && StringUtils.isNotEmpty((String)useOAS3NamesTmp)) {
                useOAS3Names = ServletUtils.isCheckBoxEnabled((String)useOAS3NamesTmp);
            }
            String useAppIdTmp = this.getParameter("connettore_appid_use");
            boolean useAppId = false;
            if (useAppIdTmp != null && StringUtils.isNotEmpty((String)useAppIdTmp)) {
                useAppId = ServletUtils.isCheckBoxEnabled((String)useAppIdTmp);
            }
            String apiKeyHeader = this.getParameter("connettore_apikey_hdr");
            String apiKeyValue = this.getLockedParameter("connettore_apikey_value");
            String appIdHeader = this.getParameter("connettore_appid_header");
            String appIdValue = this.getParameter("connettore_appid_value");
            String nome = this.getParameter("nomeJms");
            String tipo = this.getParameter("tipoJms");
            String user = this.getParameter("userJms");
            String password = this.getLockedParameter("passwordJms");
            String initcont = this.getParameter("initcont");
            String urlpgk = this.getParameter("urlpgk");
            String provurl = this.getParameter("provurl");
            String connfact = this.getParameter("connfact");
            String sendas = this.getParameter("sendas");
            String httpsurl = url;
            String httpstipologia = this.getParameter("httpstipologia");
            String httpshostverifyS = this.getParameter("httpshostverify");
            boolean httpshostverify = ServletUtils.isCheckBoxEnabled((String)httpshostverifyS);
            String httpsTrustVerifyCertS = this.getParameter("httpstrustverify");
            boolean httpsTrustVerifyCert = ServletUtils.isCheckBoxEnabled((String)httpsTrustVerifyCertS);
            String httpspath = this.getParameter("httpspath");
            String httpstipo = this.getParameter("httpstipo");
            String httpspwd = this.getLockedParameter("httpspwd");
            String httpsalgoritmo = this.getParameter("httpsalgoritmo");
            String httpsstatoS = this.getParameter("httpsstato");
            boolean httpsstato = ServletUtils.isCheckBoxEnabled((String)httpsstatoS);
            String httpskeystore = this.getParameter("httpskeystore");
            String httpspwdprivatekeytrust = this.getLockedParameter("httpspwdprivatekeytrust");
            String httpspathkey = this.getParameter("httpspathkey");
            String httpstipokey = this.getParameter("httpstipokey");
            String httpspwdkey = this.getLockedParameter("httpspwdkey");
            String httpspwdprivatekey = this.getLockedParameter("httpspwdprivatekey");
            String httpsalgoritmokey = this.getParameter("httpsalgoritmokey");
            String httpsKeyAlias = this.getParameter("httpsaliasprivatekey");
            String httpsTrustStoreCRLs = this.getParameter("httpscrl");
            String httpsTrustStoreOCSPPolicy = this.getParameter("httpsocsp");
            String httpsKeyStoreBYOKPolicy = this.getParameter("httpsbyok");
            if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                user = this.getParameter("utenteInv");
                password = this.getLockedParameter("passwordInv");
            }
            String requestOutputFileName = this.getParameter("requestOutputFileName");
            String requestOutputFileNamePermissions = this.getParameter("requestOutputFileNameP");
            String requestOutputFileNameHeaders = this.getParameter("requestOutputFileNameHeaders");
            String requestOutputFileNameHeadersPermissions = this.getParameter("requestOutputFileNameHeadersP");
            String requestOutputParentDirCreateIfNotExists = this.getParameter("requestOutputDirectoryAutoCreate");
            String requestOutputOverwriteIfExists = this.getParameter("requestOutputOverwriteFileName");
            String responseInputMode = this.getParameter("responseInputMode");
            String responseInputFileName = this.getParameter("responseInputFileName");
            String responseInputFileNameHeaders = this.getParameter("responseInputFileNameHeaders");
            String responseInputDeleteAfterRead = this.getParameter("responseInputFileNameDelete");
            String responseInputWaitTime = this.getParameter("responseInputWaitTime");
            String servizioApplicativoServerEnabledS = this.getParameter("saServerEnabled");
            boolean servizioApplicativoServerEnabled = ServletUtils.isCheckBoxEnabled((String)servizioApplicativoServerEnabledS);
            String servizioApplicativoServer = this.getParameter("saServer");
            return this.endPointCheckData(serviceBinding, protocollo, servizioApplicativo, endpointtype, url, nome, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, autenticazioneHttp, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, listExtendedConnettore, servizioApplicativoServerEnabled, servizioApplicativoServer);
        }
        catch (Exception e) {
            this.logError("endPointCheckData failed: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public boolean endPointCheckData(ServiceBinding serviceBinding, String protocollo, boolean servizioApplicativo, String endpointtype, String url, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String autenticazioneHttp, String proxyEnabled, String proxyHostname, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, List<ExtendedConnettore> listExtendedConnettore, boolean servizioApplicativoServerEnabled, String servizioApplicativoServer) throws CoreException {
        if (requestOutputParentDirCreateIfNotExists == null || requestOutputOverwriteIfExists == null || responseInputDeleteAfterRead == null) {
            // empty if block
        }
        try {
            if (!servizioApplicativoServerEnabled) {
                int value;
                int indexOfParameterSeparator;
                int indexOfSpace;
                if (url == null) {
                    url = "";
                }
                if (nome == null) {
                    nome = "";
                }
                if (tipo == null) {
                    tipo = "";
                }
                if (user == null) {
                    user = "";
                }
                if (password == null) {
                    password = "";
                }
                if (initcont == null) {
                    initcont = "";
                }
                if (urlpgk == null) {
                    urlpgk = "";
                }
                if (provurl == null) {
                    provurl = "";
                }
                if (connfact == null) {
                    connfact = "";
                }
                if (sendas == null) {
                    sendas = "";
                }
                if (httpsurl == null) {
                    httpsurl = "";
                }
                if (httpstipologia == null) {
                    httpstipologia = "";
                }
                if (httpspath == null) {
                    httpspath = "";
                }
                if (httpstipo == null) {
                    httpstipo = "";
                }
                if (httpspwd == null) {
                    httpspwd = "";
                }
                if (httpsalgoritmo == null) {
                    httpsalgoritmo = "";
                }
                if (httpskeystore == null) {
                    httpskeystore = "";
                }
                if (httpspwdprivatekeytrust == null) {
                    httpspwdprivatekeytrust = "";
                }
                if (httpspathkey == null) {
                    httpspathkey = "";
                }
                if (httpstipokey == null) {
                    httpstipokey = "";
                }
                if (httpspwdkey == null) {
                    httpspwdkey = "";
                }
                if (httpspwdprivatekey == null) {
                    httpspwdprivatekey = "";
                }
                if (httpsalgoritmokey == null) {
                    httpsalgoritmokey = "";
                }
                if (httpsKeyAlias == null) {
                    httpsKeyAlias = "";
                }
                if (httpsTrustStoreCRLs == null) {
                    httpsTrustStoreCRLs = "";
                }
                if (httpsTrustStoreOCSPPolicy == null) {
                    httpsTrustStoreOCSPPolicy = "";
                }
                if (httpsKeyStoreBYOKPolicy == null) {
                    httpsKeyStoreBYOKPolicy = "";
                }
                if (tipoconn == null) {
                    tipoconn = "";
                }
                if (proxyEnabled == null) {
                    proxyEnabled = "";
                }
                if (proxyHostname == null) {
                    proxyHostname = "";
                }
                if (proxyPort == null) {
                    proxyPort = "";
                }
                if (proxyUsername == null) {
                    proxyUsername = "";
                }
                if (proxyPassword == null) {
                    proxyPassword = "";
                }
                if (tempiRispostaEnabled == null) {
                    tempiRispostaEnabled = "";
                }
                if (tempiRispostaConnectionTimeout == null) {
                    tempiRispostaConnectionTimeout = "";
                }
                if (tempiRispostaReadTimeout == null) {
                    tempiRispostaReadTimeout = "";
                }
                if (tempiRispostaTempoMedioRisposta == null) {
                    tempiRispostaTempoMedioRisposta = "";
                }
                if (transferMode == null) {
                    transferMode = "";
                }
                if (transferModeChunkSize == null) {
                    transferModeChunkSize = "";
                }
                if (redirectMode == null) {
                    redirectMode = "";
                }
                if (redirectMaxHop == null) {
                    redirectMaxHop = "";
                }
                if (requestOutputFileName == null) {
                    requestOutputFileName = "";
                }
                if (requestOutputFileNamePermissions == null) {
                    requestOutputFileNamePermissions = "";
                }
                if (requestOutputFileNameHeaders == null) {
                    requestOutputFileNameHeaders = "";
                }
                if (requestOutputFileNameHeadersPermissions == null) {
                    requestOutputFileNameHeadersPermissions = "";
                }
                if (responseInputFileName == null) {
                    responseInputFileName = "";
                }
                if (responseInputFileNameHeaders == null) {
                    responseInputFileNameHeaders = "";
                }
                if (responseInputWaitTime == null) {
                    responseInputWaitTime = "";
                }
                if (nome.indexOf(" ") != -1 || user.indexOf(" ") != -1 || password.indexOf(" ") != -1 || initcont.indexOf(" ") != -1 || urlpgk.indexOf(" ") != -1 || provurl.indexOf(" ") != -1 || connfact.indexOf(" ") != -1 || httpspath.indexOf(" ") != -1 || httpspwd.indexOf(" ") != -1 || httpsalgoritmo.indexOf(" ") != -1 || httpskeystore.indexOf(" ") != -1 || httpspwdprivatekeytrust.indexOf(" ") != -1 || httpspathkey.indexOf(" ") != -1 || httpspwdkey.indexOf(" ") != -1 || httpspwdprivatekey.indexOf(" ") != -1 || httpsalgoritmokey.indexOf(" ") != -1 || httpsKeyAlias.indexOf(" ") != -1 || tipoconn.indexOf(" ") != -1 || proxyHostname.indexOf(" ") != -1 || proxyPort.indexOf(" ") != -1 || proxyUsername.indexOf(" ") != -1 || proxyPassword.indexOf(" ") != -1 || tempiRispostaConnectionTimeout.indexOf(" ") != -1 || tempiRispostaReadTimeout.indexOf(" ") != -1 || tempiRispostaTempoMedioRisposta.indexOf(" ") != -1 || transferMode.indexOf(" ") != -1 || transferModeChunkSize.indexOf(" ") != -1 || redirectMode.indexOf(" ") != -1 || redirectMaxHop.indexOf(" ") != -1 || requestOutputFileName.indexOf(" ") != -1 || requestOutputFileNameHeaders.indexOf(" ") != -1 || requestOutputFileNamePermissions.indexOf(" ") != -1 || requestOutputFileNameHeadersPermissions.indexOf(" ") != -1 || responseInputFileName.indexOf(" ") != -1 || responseInputFileNameHeaders.indexOf(" ") != -1 || responseInputWaitTime.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (url.startsWith(" ") || url.endsWith(" ")) {
                    this.pd.setMessage("Endpoint non deve iniziare o terminare con uno spazio");
                    return false;
                }
                if (httpsurl.startsWith(" ") || httpsurl.endsWith(" ")) {
                    this.pd.setMessage("Endpoint non deve iniziare o terminare con uno spazio");
                    return false;
                }
                if (httpshostverify) {
                    // empty if block
                }
                if (url.indexOf(" ") != -1) {
                    indexOfSpace = url.indexOf(" ");
                    indexOfParameterSeparator = url.indexOf("?");
                    if (indexOfParameterSeparator <= 0) {
                        this.pd.setMessage("Endpoint non pu\u00f2 contenere degli spazi");
                        return false;
                    }
                    if (indexOfSpace < indexOfParameterSeparator) {
                        this.pd.setMessage("Endpoint pu\u00f2 contenere degli spazi solamente nei parametri");
                        return false;
                    }
                }
                if (httpsurl.indexOf(" ") != -1) {
                    indexOfSpace = httpsurl.indexOf(" ");
                    indexOfParameterSeparator = httpsurl.indexOf("?");
                    if (indexOfParameterSeparator <= 0) {
                        this.pd.setMessage("Endpoint non pu\u00f2 contenere degli spazi");
                        return false;
                    }
                    if (indexOfSpace < indexOfParameterSeparator) {
                        this.pd.setMessage("Endpoint pu\u00f2 contenere degli spazi solamente nei parametri");
                        return false;
                    }
                }
                if (ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                    if (proxyHostname == null || "".equals(proxyHostname)) {
                        this.pd.setMessage("Hostname obbligatorio se si seleziona la comunicazione tramite Proxy");
                        return false;
                    }
                    if (proxyPort == null || "".equals(proxyPort)) {
                        this.pd.setMessage("Porta obbligatorio se si seleziona la comunicazione tramite Proxy");
                        return false;
                    }
                    value = -1;
                    try {
                        value = Integer.parseInt(proxyPort);
                        if (value < 1 || value > 65535) {
                            this.pd.setMessage("Porta indicata per il Proxy deve essere un intero compreso tra 1 e  65.535");
                            return false;
                        }
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Porta indicata per il Proxy deve essere un numero intero: " + e.getMessage());
                        return false;
                    }
                    try {
                        new InetSocketAddress(proxyHostname, value);
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Hostname e Porta indicati per il Proxy non sono corretti: " + e.getMessage());
                        return false;
                    }
                    if (!this.checkLength255(proxyHostname, "Hostname")) {
                        return false;
                    }
                    if (proxyUsername != null && !"".equals(proxyUsername) && !this.checkLength255(proxyUsername, "Username")) {
                        return false;
                    }
                    if (!(proxyPassword == null || "".equals(proxyPassword) || this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(proxyPassword) || this.checkLength255(proxyPassword, "Password"))) {
                        return false;
                    }
                }
                if (ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                    int v;
                    try {
                        v = Integer.parseInt(tempiRispostaConnectionTimeout);
                        if (v <= 0) {
                            throw new CoreException("fornire un valore maggiore di zero");
                        }
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Connection Timeout indicato nella sezione 'Tempi Risposta' deve essere un numero intero maggiore di zero");
                        return false;
                    }
                    try {
                        v = Integer.parseInt(tempiRispostaReadTimeout);
                        if (v <= 0) {
                            throw new CoreException("fornire un valore maggiore di zero");
                        }
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Read Timeout indicato nella sezione 'Tempi Risposta' deve essere un numero intero maggiore di zero");
                        return false;
                    }
                    try {
                        v = Integer.parseInt(tempiRispostaTempoMedioRisposta);
                        if (v <= 0) {
                            throw new CoreException("fornire un valore maggiore di zero");
                        }
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Tempo Medio di Risposta indicato nella sezione 'Tempi Risposta' deve essere un numero intero maggiore di zero");
                        return false;
                    }
                }
                if (ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
                    if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode) && transferModeChunkSize != null && !"".equals(transferModeChunkSize)) {
                        value = -1;
                        try {
                            value = Integer.parseInt(transferModeChunkSize);
                            if (value < 1) {
                                this.pd.setMessage("Il valore indicato nel parametro 'Chunk Length (Bytes)' indicato per la modalit\u00e0 " + TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome() + " deve essere un numero maggiore di zero.");
                                return false;
                            }
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel parametro 'Chunk Length (Bytes)' indicato per la modalit\u00e0 " + TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome() + " deve essere un numero intero: " + e.getMessage());
                            return false;
                        }
                    }
                    if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) && redirectMaxHop != null && !"".equals(redirectMaxHop)) {
                        value = -1;
                        try {
                            value = Integer.parseInt(redirectMaxHop);
                            if (value < 1) {
                                this.pd.setMessage("Il valore indicato nel parametro 'Max Numero di Redirect' deve essere un numero maggiore di zero.");
                                return false;
                            }
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel parametro 'Max Numero di Redirect' deve essere un numero intero: " + e.getMessage());
                            return false;
                        }
                    }
                }
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                    if (user == null || "".equals(user)) {
                        this.pd.setMessage("Username obbligatoria per l'autenticazione http");
                        return false;
                    }
                    if (password == null || "".equals(password)) {
                        this.pd.setMessage("Password obbligatoria per l'autenticazione http");
                        return false;
                    }
                    if (!this.checkLength255(user, "Utente")) {
                        return false;
                    }
                    if (!this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(password) && !this.checkLength255(password, "Password")) {
                        return false;
                    }
                }
                if (autenticazioneToken) {
                    if (tokenPolicy == null || "".equals(tokenPolicy) || "-".equals(tokenPolicy)) {
                        this.pd.setMessage("Policy obbligatoria per l'autenticazione basata su token");
                        return false;
                    }
                    List<GenericProperties> gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, "retrievePolicyToken", null);
                    ArrayList<String> policyValues = new ArrayList<String>();
                    for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                        GenericProperties genericProperties = gestorePolicyTokenList.get(i);
                        policyValues.add(genericProperties.getNome());
                    }
                    if (!policyValues.contains(tokenPolicy)) {
                        this.pd.setMessage("Policy indicata per l'autenticazione basata su token, non esiste");
                        return false;
                    }
                }
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneApiKey)) {
                    String prefix = "Autenticazione API Key: ";
                    if (apiKeyValue == null || "".equals(apiKeyValue)) {
                        this.pd.setMessage(prefix + "valore non fornito");
                        return false;
                    }
                    if (apiKeyValue.startsWith(" ")) {
                        this.pd.setMessage(prefix + "valore inizia con uno spazio");
                        return false;
                    }
                    if (apiKeyValue.endsWith(" ")) {
                        this.pd.setMessage(prefix + "valore termina con uno spazio");
                        return false;
                    }
                    if (apiKeyValue.contains("\n") || apiKeyValue.contains("\r")) {
                        this.pd.setMessage(prefix + "valore contiene ritorni a capo");
                        return false;
                    }
                    if (!useOAS3Names && (apiKeyHeader == null || "".equals(apiKeyHeader))) {
                        this.pd.setMessage(prefix + "header http non fornito");
                        return false;
                    }
                    if (apiKeyHeader != null && StringUtils.isNotEmpty((String)apiKeyHeader)) {
                        if (apiKeyHeader.contains(" ") || apiKeyHeader.contains("\n") || apiKeyHeader.contains("\r")) {
                            this.pd.setMessage(prefix + "Header HTTP contiene spazi");
                            return false;
                        }
                        if (!this.checkLength255(apiKeyHeader, "Header HTTP API Key")) {
                            return false;
                        }
                    }
                    if (useAppId) {
                        if (appIdValue == null || "".equals(appIdValue)) {
                            this.pd.setMessage(prefix + "App ID non fornito");
                            return false;
                        }
                        if (appIdValue.contains(" ") || appIdValue.contains("\n") || appIdValue.contains("\r")) {
                            this.pd.setMessage(prefix + "App ID fornito contiene spazi");
                            return false;
                        }
                        if (!useOAS3Names && (appIdHeader == null || "".equals(appIdHeader))) {
                            this.pd.setMessage(prefix + "Header HTTP App ID non fornito");
                            return false;
                        }
                        if (appIdHeader != null && StringUtils.isNotEmpty((String)appIdHeader)) {
                            if (appIdHeader.contains(" ") || appIdHeader.contains("\n") || appIdHeader.contains("\r")) {
                                this.pd.setMessage(prefix + "Header HTTP App ID contiene spazi");
                                return false;
                            }
                            if (!this.checkLength255(appIdHeader, "Header HTTP App ID")) {
                                return false;
                            }
                        }
                    }
                }
                if (!Connettori.contains(endpointtype) && !endpointtype.equals(TipiConnettore.CUSTOM.toString())) {
                    this.pd.setMessage("Tipo Connettore dev'essere uno tra : " + Connettori.getList());
                    return false;
                }
                List tipologie = null;
                try {
                    tipologie = SSLUtilities.getSSLSupportedProtocols();
                }
                catch (Exception e) {
                    ControlStationCore.logError(e.getMessage(), e);
                    tipologie = SSLUtilities.getAllSslProtocol();
                }
                if (!tipologie.contains("TLS")) {
                    tipologie.add("TLS");
                }
                if (!tipologie.contains("SSL")) {
                    tipologie.add("SSL");
                }
                if (!httpstipologia.equals("") && !tipologie.contains(httpstipologia)) {
                    this.pd.setMessage("Il campo Tipologia pu\u00f2 assumere uno tra i seguenti valori: " + tipologie);
                    return false;
                }
                if (this.core.isConnettoriAllTypesEnabled()) {
                    if (!httpstipo.equals("") && !Utilities.contains(httpstipo, ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD)) {
                        this.pd.setMessage("Il campo Tipo per l'Autenticazione Server pu\u00f2 assumere uno tra i seguenti valori: " + Utilities.toString(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD, ","));
                        return false;
                    }
                    if (!httpstipokey.equals("") && !Utilities.contains(httpstipokey, ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD)) {
                        this.pd.setMessage("Il campo Tipo per l'Autenticazione Client pu\u00f2 assumere uno tra i seguenti valori: " + Utilities.toString(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD, ","));
                        return false;
                    }
                } else {
                    if (!httpstipo.equals("") && !Utilities.contains(httpstipo, ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(true, false).toArray(new String[1]))) {
                        this.pd.setMessage("Il campo Tipo per l'Autenticazione Server pu\u00f2 assumere uno tra i seguenti valori: " + Utilities.toString(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD, ","));
                        return false;
                    }
                    if (!httpstipokey.equals("") && !Utilities.contains(httpstipokey, ConnettoriCostanti.getTIPOLOGIE_KEYSTORE(false, false).toArray(new String[1]))) {
                        this.pd.setMessage("Il campo Tipo per l'Autenticazione Client pu\u00f2 assumere uno tra i seguenti valori: " + Utilities.toString(ConnettoriCostanti.TIPOLOGIE_KEYSTORE_OLD, ","));
                        return false;
                    }
                }
                if (endpointtype.equals(TipiConnettore.CUSTOM.toString()) && (tipoconn == null || "".equals(tipoconn) || "--".equals(tipoconn))) {
                    if (this.connettoriCore.isConfigurazionePluginsEnabled()) {
                        this.pd.setMessage("Non \u00e8 stato selezionato un plugin");
                    } else {
                        this.pd.setMessage("Tipo Personalizzato obbligatorio per il tipo di connettore selezionato");
                    }
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.CUSTOM.toString()) && !this.checkLength255(tipoconn, "Tipo Personalizzato")) {
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) && (url == null || "".equals(url))) {
                    this.pd.setMessage("Url obbligatoria per il tipo di connettore http");
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.CUSTOM.toString()) && (tipoconn.equals(TipiConnettore.HTTP.toString()) || tipoconn.equals(TipiConnettore.HTTPS.toString()) || tipoconn.equals(TipiConnettore.STATUS.toString()) || tipoconn.equals(TipiConnettore.JMS.toString()) || tipoconn.equals(TipiConnettore.NULL.toString()) || tipoconn.equals(TipiConnettore.NULLECHO.toString()) || tipoconn.equals(TipiConnettore.DISABILITATO.toString()))) {
                    this.pd.setMessage("Tipo Personalizzato non pu\u00f2 assumere i valori: disabilitato,http,https,jms,null,nullEcho,status");
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.HTTP.toString()) && !url.equals("")) {
                    try {
                        RegExpUtilities.validateUrl((String)url, (boolean)true);
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Url non correttamente formata: " + e.getMessage());
                        return false;
                    }
                    if (!this.checkLength4000(url, "Endpoint")) {
                        return false;
                    }
                    try {
                        InputValidationUtils.validateTextAreaInput((String)url, (String)"Endpoint");
                    }
                    catch (Exception e) {
                        this.pd.setMessage(e.getMessage());
                        return false;
                    }
                    if (this.isProfiloModIPA(protocollo) && !servizioApplicativo && this.connettoriCore.isModipaFruizioniConnettoreCheckHttps() && !httpsurl.toLowerCase().trim().startsWith("https://")) {
                        this.pd.setMessage("Il profilo richiede una url con prefisso https://");
                        return false;
                    }
                }
                if (endpointtype.equals(TipiConnettore.JMS.toString())) {
                    if (nome == null || "".equals(nome)) {
                        this.pd.setMessage("Nome della coda/topic obbligatorio per il tipo di connettore jms");
                        return false;
                    }
                    if (tipo == null || "".equals(tipo)) {
                        this.pd.setMessage("Tipo di coda obbligatorio per il tipo di connettore jms");
                        return false;
                    }
                    if (sendas == null || "".equals(sendas)) {
                        this.pd.setMessage("Tipo di messaggio (SendAs) obbligatorio per il tipo di connettore jms");
                        return false;
                    }
                    if (connfact == null || "".equals(connfact)) {
                        this.pd.setMessage("Connection Factory obbligatoria per il tipo di connettore jms");
                        return false;
                    }
                    if (!this.checkLength255(nome, "Nome")) {
                        return false;
                    }
                    if (!this.checkLength255(connfact, "Connection Factory")) {
                        return false;
                    }
                    if (user != null && !"".equals(user) && !this.checkLength255(user, "Utente")) {
                        return false;
                    }
                    if (password != null && !"".equals(password) && !this.checkLength255(password, "Password")) {
                        return false;
                    }
                    if (initcont != null && !"".equals(initcont) && !this.checkLength255(initcont, "Initial Context Factory")) {
                        return false;
                    }
                    if (urlpgk != null && !"".equals(urlpgk) && !this.checkLength255(urlpgk, "Url Pgk Prefixes")) {
                        return false;
                    }
                    if (provurl != null && !"".equals(provurl) && !this.checkLength255(provurl, "Provider Url")) {
                        return false;
                    }
                }
                if (endpointtype.equals(TipiConnettore.JMS.toString()) && !Utilities.contains(tipo, ConnettoriCostanti.TIPI_CODE_JMS)) {
                    this.pd.setMessage("Tipo Jms dev'essere: " + Utilities.toString(ConnettoriCostanti.TIPI_CODE_JMS, ","));
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.JMS.toString()) && !Utilities.contains(sendas, ConnettoriCostanti.TIPO_SEND_AS)) {
                    this.pd.setMessage("Send As dev'essere: " + Utilities.toString(ConnettoriCostanti.TIPO_SEND_AS, ","));
                    return false;
                }
                if (endpointtype.equals(TipiConnettore.HTTPS.toString())) {
                    if ("".equals(httpsurl)) {
                        this.pd.setMessage("Url obbligatorio per il tipo di connettore https");
                        return false;
                    }
                    try {
                        RegExpUtilities.validateUrl((String)httpsurl, (boolean)true);
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Url non correttamente formata: " + e.getMessage());
                        return false;
                    }
                    if (!this.checkLength4000(httpsurl, "Endpoint")) {
                        return false;
                    }
                    try {
                        InputValidationUtils.validateTextAreaInput((String)httpsurl, (String)"Endpoint");
                    }
                    catch (Exception e) {
                        this.pd.setMessage(e.getMessage());
                        return false;
                    }
                    if (!httpsurl.toLowerCase().trim().startsWith("https://")) {
                        if (this.isProfiloModIPA(protocollo) && this.connettoriCore.isModipaFruizioniConnettoreCheckHttps()) {
                            this.pd.setMessage("Il profilo richiede una url con prefisso https://");
                            return false;
                        }
                        this.pd.setMessage("Url deve possedere il prefisso https://");
                        return false;
                    }
                    if (httpsTrustVerifyCert) {
                        if ("".equals(httpspath)) {
                            this.pd.setMessage("Il campo 'Path' \u00e8 obbligatorio per l'Autenticazione Server");
                            return false;
                        }
                        try {
                            File f = new File(httpspath);
                            f.getAbsolutePath();
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il campo 'Path', obbligatorio per l'Autenticazione Server, non \u00e8 correttamente definito: " + e.getMessage());
                            return false;
                        }
                        if (!this.checkLength4000(httpspath, "Path")) {
                            return false;
                        }
                        try {
                            InputValidationUtils.validateTextAreaInput((String)httpspath, (String)"Autenticazione Server - Path");
                        }
                        catch (Exception e) {
                            this.pd.setMessage(e.getMessage());
                            return false;
                        }
                        boolean isRequired = true;
                        if (KeystoreType.JKS.isType(httpstipo)) {
                            isRequired = this.core.isTruststoreJksPasswordRequired();
                        } else if (KeystoreType.PKCS12.isType(httpstipo)) {
                            isRequired = this.core.isTruststorePkcs12PasswordRequired();
                        }
                        if ("".equals(httpspwd) && isRequired) {
                            this.pd.setMessage("La password del TrustStore \u00e8 necessaria per l'Autenticazione Server");
                            return false;
                        }
                        if (!this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(httpspwd) && !this.checkLength255(httpspwd, "Password")) {
                            return false;
                        }
                        if ("".equals(httpsalgoritmo)) {
                            this.pd.setMessage("Il campo 'Algoritmo' \u00e8 obbligatorio per l'Autenticazione Server");
                            return false;
                        }
                        if (!this.checkLength255(httpsalgoritmo, "Algoritmo")) {
                            return false;
                        }
                        if (httpsTrustStoreCRLs != null && !"".equals(httpsTrustStoreCRLs)) {
                            if (!this.checkLength4000(httpsTrustStoreCRLs, "CRL File(s)")) {
                                return false;
                            }
                            try {
                                InputValidationUtils.validateTextAreaInput((String)httpsTrustStoreCRLs, (String)"Autenticazione Server - CRL File(s)");
                            }
                            catch (Exception e) {
                                this.pd.setMessage(e.getMessage());
                                return false;
                            }
                            httpsTrustStoreCRLs = httpsTrustStoreCRLs.trim();
                            String[] tmp = httpsTrustStoreCRLs.split(",");
                            if (tmp != null && tmp.length > 0) {
                                for (String crl : tmp) {
                                    if (crl == null || "".equals(crl = crl.trim()) || !crl.contains(" ")) continue;
                                    this.pd.setMessage("I path inseriti nel campo 'CRL File(s)' non devono contenere spazi");
                                    return false;
                                }
                            }
                        }
                    }
                    if (httpsstato) {
                        if ("default".equals(httpskeystore)) {
                            boolean isRequired = true;
                            if (KeystoreType.JKS.isType(httpstipo)) {
                                isRequired = this.core.isKeystoreJksKeyPasswordRequired();
                            } else if (KeystoreType.PKCS12.isType(httpstipo)) {
                                isRequired = this.core.isKeystorePkcs12KeyPasswordRequired();
                            }
                            if ("".equals(httpspwdprivatekeytrust) && isRequired) {
                                this.pd.setMessage("La password della chiave privata \u00e8 necessaria in caso di Autenticazione Client abilitata");
                                return false;
                            }
                            if (!this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(httpspwdprivatekeytrust) && !this.checkLength255(httpspwdprivatekeytrust, "Password Chiave Privata")) {
                                return false;
                            }
                            if ("".equals(httpsalgoritmokey)) {
                                this.pd.setMessage("Il campo 'Algoritmo' \u00e8 obbligatorio in caso di Autenticazione Client abilitata");
                                return false;
                            }
                            if (!this.checkLength255(httpsalgoritmokey, "Algoritmo")) {
                                return false;
                            }
                        } else {
                            if ("".equals(httpspathkey)) {
                                this.pd.setMessage("Il campo 'Path' \u00e8 obbligatorio per l'Autenticazione Client, in caso di dati di accesso al KeyStore ridefiniti");
                                return false;
                            }
                            try {
                                File f = new File(httpspathkey);
                                f.getAbsolutePath();
                            }
                            catch (Exception e) {
                                this.pd.setMessage("Il campo 'Path', obbligatorio per l'Autenticazione Client in caso di dati di accesso al KeyStore ridefiniti, non \u00e8 correttamente definito: " + e.getMessage());
                                return false;
                            }
                            if (!this.checkLength4000(httpspathkey, "Path")) {
                                return false;
                            }
                            try {
                                InputValidationUtils.validateTextAreaInput((String)httpspathkey, (String)"Autenticazione Client - Path");
                            }
                            catch (Exception e) {
                                this.pd.setMessage(e.getMessage());
                                return false;
                            }
                            boolean isRequired = true;
                            if (KeystoreType.JKS.isType(httpstipokey)) {
                                isRequired = this.core.isKeystoreJksPasswordRequired();
                            } else if (KeystoreType.PKCS12.isType(httpstipokey)) {
                                isRequired = this.core.isKeystorePkcs12PasswordRequired();
                            }
                            if ("".equals(httpspwdkey) && isRequired) {
                                this.pd.setMessage("La password del KeyStore \u00e8 necessaria per l'Autenticazione Client, in caso di dati di accesso al KeyStore ridefiniti");
                                return false;
                            }
                            if (!this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(httpspwdkey) && !this.checkLength255(httpspwdkey, "Password")) {
                                return false;
                            }
                            isRequired = true;
                            if (KeystoreType.JKS.isType(httpstipokey)) {
                                isRequired = this.core.isKeystoreJksKeyPasswordRequired();
                            } else if (KeystoreType.PKCS12.isType(httpstipokey)) {
                                isRequired = this.core.isKeystorePkcs12KeyPasswordRequired();
                            }
                            if ("".equals(httpspwdprivatekey) && isRequired) {
                                this.pd.setMessage("La password della chiave privata \u00e8 necessaria in caso di Autenticazione Client abilitata");
                                return false;
                            }
                            if (!this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(httpspwdprivatekey) && !this.checkLength255(httpspwdprivatekey, "Password Chiave Privata")) {
                                return false;
                            }
                            if ("".equals(httpsalgoritmokey)) {
                                this.pd.setMessage("Il campo 'Algoritmo' \u00e8 obbligatorio per l'Autenticazione Client, in caso di dati di accesso al KeyStore ridefiniti");
                                return false;
                            }
                            if (!this.checkLength255(httpsalgoritmokey, "Algoritmo")) {
                                return false;
                            }
                        }
                    }
                }
                if (endpointtype.equals(TipiConnettore.FILE.toString())) {
                    if ("".equals(requestOutputFileName)) {
                        this.pd.setMessage("'File' (Richiesta) obbligatorio per il tipo di connettore file");
                        return false;
                    }
                    try {
                        DynamicUtils.validate((String)"File", (String)requestOutputFileName, (boolean)false, (boolean)false);
                    }
                    catch (Exception e) {
                        this.pd.setMessage("Il valore indicato nel parametro 'File' (Richiesta) non risulta corretto: " + e.getMessage());
                        return false;
                    }
                    if (!this.checkLength4000(requestOutputFileName, "File")) {
                        return false;
                    }
                    try {
                        InputValidationUtils.validateTextAreaInput((String)requestOutputFileName, (String)"File' (Richiesta)");
                    }
                    catch (Exception e) {
                        this.pd.setMessage(e.getMessage());
                        return false;
                    }
                    if (StringUtils.isNotEmpty((String)requestOutputFileNamePermissions)) {
                        try {
                            ConnettoreFILE.validatePermission((String)requestOutputFileNamePermissions, (ConnettoreFile_outputConfig)new ConnettoreFile_outputConfig());
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel parametro 'File (Permessi)' (Richiesta) non risulta corretto: " + e.getMessage());
                            return false;
                        }
                        if (!this.checkLength255(requestOutputFileNamePermissions, "File (Permessi)")) {
                            return false;
                        }
                    }
                    if (requestOutputFileNameHeaders != null && !"".equals(requestOutputFileNameHeaders)) {
                        try {
                            DynamicUtils.validate((String)"File Headers", (String)requestOutputFileNameHeaders, (boolean)false, (boolean)false);
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel parametro 'File Headers' (Richiesta) non risulta corretto: " + e.getMessage());
                            return false;
                        }
                        if (!this.checkLength4000(requestOutputFileNameHeaders, "File Headers")) {
                            return false;
                        }
                        try {
                            InputValidationUtils.validateTextAreaInput((String)requestOutputFileNameHeaders, (String)"File Headers' (Richiesta)");
                        }
                        catch (Exception e) {
                            this.pd.setMessage(e.getMessage());
                            return false;
                        }
                    }
                    if (StringUtils.isNotEmpty((String)requestOutputFileNameHeadersPermissions)) {
                        if (requestOutputFileNameHeaders != null && !"".equals(requestOutputFileNameHeaders)) {
                            try {
                                ConnettoreFILE.validatePermission((String)requestOutputFileNameHeadersPermissions, (ConnettoreFile_outputConfig)new ConnettoreFile_outputConfig());
                            }
                            catch (Exception e) {
                                this.pd.setMessage("Il valore indicato nel parametro 'File Headers (Permessi)' (Richiesta) non risulta corretto: " + e.getMessage());
                                return false;
                            }
                            if (!this.checkLength255(requestOutputFileNameHeadersPermissions, "File Headers (Permessi)")) {
                                return false;
                            }
                        } else {
                            this.pd.setMessage("Non \u00e8 possibile configurare il parametro 'File Headers (Permessi)' senza configurare anche il parametro 'File Headers' (Richiesta)");
                            return false;
                        }
                    }
                    if (CostantiConfigurazione.ABILITATO.getValue().equals(responseInputMode)) {
                        if ("".equals(responseInputFileName)) {
                            this.pd.setMessage("'File' (Risposta) obbligatorio per il tipo di connettore file");
                            return false;
                        }
                        try {
                            DynamicUtils.validate((String)"File", (String)responseInputFileName, (boolean)false, (boolean)false);
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il valore indicato nel parametro 'File' (Risposta) non risulta corretto: " + e.getMessage());
                            return false;
                        }
                        if (!this.checkLength4000(responseInputFileName, "File")) {
                            return false;
                        }
                        try {
                            InputValidationUtils.validateTextAreaInput((String)responseInputFileName, (String)"File' (Risposta)");
                        }
                        catch (Exception e) {
                            this.pd.setMessage(e.getMessage());
                            return false;
                        }
                        if (responseInputFileNameHeaders != null && !"".equals(responseInputFileNameHeaders)) {
                            try {
                                DynamicUtils.validate((String)"File Headers", (String)responseInputFileNameHeaders, (boolean)false, (boolean)false);
                            }
                            catch (Exception e) {
                                this.pd.setMessage("Il valore indicato nel parametro 'File Headers' (Risposta) non risulta corretto: " + e.getMessage());
                                return false;
                            }
                            if (!this.checkLength4000(responseInputFileNameHeaders, "File Headers")) {
                                return false;
                            }
                            try {
                                InputValidationUtils.validateTextAreaInput((String)responseInputFileNameHeaders, (String)"File Headers' (Risposta)");
                            }
                            catch (Exception e) {
                                this.pd.setMessage(e.getMessage());
                                return false;
                            }
                        }
                        if (responseInputWaitTime != null && !"".equals(responseInputWaitTime)) {
                            int value2 = -1;
                            try {
                                value2 = Integer.parseInt(responseInputWaitTime);
                                if (value2 < 1) {
                                    this.pd.setMessage("Il valore indicato nel parametro 'WaitTime ifNotExists (ms)' (Risposta) deve essere un numero maggiore di zero.");
                                    return false;
                                }
                            }
                            catch (Exception e) {
                                this.pd.setMessage("Il valore indicato nel parametro 'WaitTime ifNotExists (ms)' (Risposta) deve essere un numero intero: " + e.getMessage());
                                return false;
                            }
                        }
                    }
                }
                if (endpointtype.equals(TipiConnettore.STATUS.toString()) && ConnettoreStatusParams.check(this, serviceBinding, this.pd).getParsingErrors()) {
                    return false;
                }
                try {
                    ServletExtendedConnettoreUtils.checkInfo(listExtendedConnettore);
                }
                catch (Exception e) {
                    this.pd.setMessage(e.getMessage());
                    return false;
                }
            }
            if (StringUtils.isBlank((String)servizioApplicativoServer)) {
                this.pd.setMessage("Il campo 'Applicativo' &egrave; quando si abilita il campo 'Utilizza Applicativo Server'.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("endPointCheckData failed: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public void fillConnettore(Connettore connettore, String connettoreDebug, String tipoConnettore, String oldtipo, String tipoconn, String httpUrl, String jmsNome, String jmsTipo, String user, String pwd, String jmsNfInitial, String jmsNfUrlPkg, String jmsNpUrl, String jmsConnectionFactory, String jmsSendAs, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, String tokenPolicy, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams, List<ExtendedConnettore> listExtendedConnettore) throws CoreException {
        try {
            if (!tipoConnettore.equals(TipiConnettore.CUSTOM.toString()) || !tipoConnettore.equals(oldtipo)) {
                while (connettore.sizePropertyList() > 0) {
                    connettore.removeProperty(0);
                }
            }
            String debugValue = null;
            debugValue = ServletUtils.isCheckBoxEnabled((String)connettoreDebug) ? "true" : "false";
            boolean found = false;
            for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                Property pCheck = connettore.getProperty(i);
                if (!"debug".equals(pCheck.getNome())) continue;
                pCheck.setValore(debugValue);
                found = true;
                break;
            }
            if (!found) {
                Property p = new Property();
                p.setNome("debug");
                p.setValore(debugValue);
                connettore.addProperty(p);
            }
            Property prop = null;
            if (tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                connettore.setTipo(tipoconn);
            } else {
                connettore.setTipo(tipoConnettore);
            }
            connettore.setCustom(Boolean.valueOf(false));
            if (tipoConnettore.equals(TipiConnettore.HTTP.getNome())) {
                prop = new Property();
                prop.setNome("location");
                prop.setValore(httpUrl);
                connettore.addProperty(prop);
                if (user != null) {
                    prop = new Property();
                    prop.setNome("user");
                    prop.setValore(user);
                    connettore.addProperty(prop);
                }
                if (pwd != null) {
                    prop = new Property();
                    prop.setNome("password");
                    prop.setValore(pwd);
                    connettore.addProperty(prop);
                }
            } else if (tipoConnettore.equals(TipiConnettore.JMS.getNome())) {
                ConnettoreJMSUtils.fillConnettoreRegistry(connettore, jmsNome, jmsTipo, user, pwd, jmsNfInitial, jmsNfUrlPkg, jmsNpUrl, jmsConnectionFactory, jmsSendAs);
            } else if (!tipoConnettore.equals(TipiConnettore.NULL.getNome()) && !tipoConnettore.equals(TipiConnettore.NULLECHO.getNome())) {
                if (tipoConnettore.equals(TipiConnettore.STATUS.getNome())) {
                    connettoreStatusParams.fillConnettoreRegistry(connettore);
                } else if (tipoConnettore.equals(TipiConnettore.HTTPS.getNome())) {
                    ConnettoreHTTPSUtils.fillConnettoreRegistry(connettore, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, user, pwd);
                } else if (tipoConnettore.equals(TipiConnettore.FILE.getNome())) {
                    ConnettoreFileUtils.fillConnettoreRegistry(connettore, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime);
                } else if (tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                    connettore.setCustom(Boolean.valueOf(true));
                } else if (!tipoConnettore.equals(TipiConnettore.DISABILITATO.getNome()) && !tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                    Property[] cp = this.connettoriCore.getPropertiesConnettore(tipoConnettore);
                    ArrayList<Property> cps = new ArrayList<Property>();
                    if (cp != null && cp.length > 0) {
                        cps.addAll(Arrays.asList(cp));
                    }
                    connettore.setPropertyList(cps);
                }
            }
            this.addAutenticazioneApiKey(connettore, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue);
            if (ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                prop = new Property();
                prop.setNome("proxyType");
                prop.setValore(CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP);
                connettore.addProperty(prop);
                if (proxyHost != null && !"".equals(proxyHost)) {
                    prop = new Property();
                    prop.setNome("proxyHostname");
                    prop.setValore(proxyHost);
                    connettore.addProperty(prop);
                }
                if (proxyPort != null && !"".equals(proxyPort)) {
                    prop = new Property();
                    prop.setNome("proxyPort");
                    prop.setValore(proxyPort);
                    connettore.addProperty(prop);
                }
                if (proxyUsername != null && !"".equals(proxyUsername)) {
                    prop = new Property();
                    prop.setNome("proxyUsername");
                    prop.setValore(proxyUsername);
                    connettore.addProperty(prop);
                }
                if (proxyPassword != null && !"".equals(proxyPassword)) {
                    prop = new Property();
                    prop.setNome("proxyPassword");
                    prop.setValore(proxyPassword);
                    connettore.addProperty(prop);
                }
            }
            if (ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                if (tempiRispostaConnectionTimeout != null && !"".equals(tempiRispostaConnectionTimeout)) {
                    prop = new Property();
                    prop.setNome("connectionTimeout");
                    prop.setValore(tempiRispostaConnectionTimeout);
                    connettore.addProperty(prop);
                }
                if (tempiRispostaReadTimeout != null && !"".equals(tempiRispostaReadTimeout)) {
                    prop = new Property();
                    prop.setNome("readConnectionTimeout");
                    prop.setValore(tempiRispostaReadTimeout);
                    connettore.addProperty(prop);
                }
                if (tempiRispostaTempoMedioRisposta != null && !"".equals(tempiRispostaTempoMedioRisposta)) {
                    prop = new Property();
                    prop.setNome("avgResponseTime");
                    prop.setValore(tempiRispostaTempoMedioRisposta);
                    connettore.addProperty(prop);
                }
            }
            if (ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
                // empty if block
            }
            if (TransferLengthModes.CONTENT_LENGTH.getNome().equals(transferMode) || TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode)) {
                prop = new Property();
                prop.setNome("dataTransferMode");
                prop.setValore(transferMode);
                connettore.addProperty(prop);
            }
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode) && transferModeChunkSize != null && !"".equals(transferModeChunkSize)) {
                prop = new Property();
                prop.setNome("transferChunkSize");
                prop.setValore(transferModeChunkSize);
                connettore.addProperty(prop);
            }
            if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) || CostantiConfigurazione.DISABILITATO.getValue().equals(redirectMode)) {
                prop = new Property();
                prop.setNome("followRedirects");
                prop.setValore(redirectMode);
                connettore.addProperty(prop);
            }
            if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) && redirectMaxHop != null && !"".equals(redirectMaxHop)) {
                prop = new Property();
                prop.setNome("maxHopRedirect");
                prop.setValore(redirectMaxHop);
                connettore.addProperty(prop);
            }
            if (tokenPolicy != null && !"".equals(tokenPolicy) && !"-".equals(tokenPolicy)) {
                prop = new Property();
                prop.setNome("tokenPolicy");
                prop.setValore(tokenPolicy);
                connettore.addProperty(prop);
            }
            ExtendedConnettoreConverter.fillExtendedInfoIntoConnettore(listExtendedConnettore, connettore);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public void addAutenticazioneApiKey(Connettore connettore, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue) {
        if (this.isAutenticazioneApiKey(apiKeyValue)) {
            Property prop = new Property();
            prop.setNome("apiKey");
            prop.setValore(apiKeyValue);
            connettore.addProperty(prop);
            if (apiKeyHeader != null && !"".equals(apiKeyHeader)) {
                prop = new Property();
                prop.setNome("apiKeyHeader");
                prop.setValore(apiKeyHeader);
                connettore.addProperty(prop);
            }
            if (this.isAutenticazioneApiKeyUseAppId(appIdValue)) {
                prop = new Property();
                prop.setNome("appId");
                prop.setValore(appIdValue);
                connettore.addProperty(prop);
                if (appIdHeader != null && !"".equals(appIdHeader)) {
                    prop = new Property();
                    prop.setNome("appIdHeader");
                    prop.setValore(appIdHeader);
                    connettore.addProperty(prop);
                }
            }
        }
    }

    public void fillConnettore(org.openspcoop2.core.config.Connettore connettore, String connettoreDebug, String tipoConnettore, String oldtipo, String tipoconn, String httpUrl, String jmsNome, String jmsTipo, String jmsUser, String jmsPwd, String jmsNfInitial, String jmsNfUrlPkg, String jmsNpUrl, String jmsConnectionFactory, String jmsSendAs, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, String tokenPolicy, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams, List<ExtendedConnettore> listExtendedConnettore) throws CoreException {
        try {
            if (!tipoConnettore.equals(TipiConnettore.CUSTOM.toString()) || !tipoConnettore.equals(oldtipo)) {
                while (connettore.sizePropertyList() > 0) {
                    connettore.removeProperty(0);
                }
            }
            String debugValue = null;
            debugValue = ServletUtils.isCheckBoxEnabled((String)connettoreDebug) ? "true" : "false";
            boolean found = false;
            for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                org.openspcoop2.core.config.Property pCheck = connettore.getProperty(i);
                if (!"debug".equals(pCheck.getNome())) continue;
                pCheck.setValore(debugValue);
                found = true;
                break;
            }
            if (!found) {
                org.openspcoop2.core.config.Property p = new org.openspcoop2.core.config.Property();
                p.setNome("debug");
                p.setValore(debugValue);
                connettore.addProperty(p);
            }
            org.openspcoop2.core.config.Property prop = null;
            if (tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                connettore.setTipo(tipoconn);
            } else {
                connettore.setTipo(tipoConnettore);
            }
            connettore.setCustom(Boolean.valueOf(false));
            if (tipoConnettore.equals(TipiConnettore.HTTP.getNome())) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("location");
                prop.setValore(httpUrl);
                connettore.addProperty(prop);
            } else if (tipoConnettore.equals(TipiConnettore.JMS.getNome())) {
                ConnettoreJMSUtils.fillConnettoreConfig(connettore, jmsNome, jmsTipo, jmsUser, jmsPwd, jmsNfInitial, jmsNfUrlPkg, jmsNpUrl, jmsConnectionFactory, jmsSendAs);
            } else if (!tipoConnettore.equals(TipiConnettore.NULL.getNome()) && !tipoConnettore.equals(TipiConnettore.NULLECHO.getNome())) {
                if (tipoConnettore.equals(TipiConnettore.STATUS.getNome())) {
                    connettoreStatusParams.fillConnettoreConfig(connettore);
                } else if (tipoConnettore.equals(TipiConnettore.HTTPS.getNome())) {
                    ConnettoreHTTPSUtils.fillConnettoreConfig(connettore, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy);
                } else if (tipoConnettore.equals(TipiConnettore.FILE.getNome())) {
                    ConnettoreFileUtils.fillConnettoreConfig(connettore, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime);
                } else if (tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                    connettore.setCustom(Boolean.valueOf(true));
                } else if (!tipoConnettore.equals(TipiConnettore.DISABILITATO.getNome()) && !tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                    org.openspcoop2.core.config.Property[] cp = this.connettoriCore.getPropertiesConnettoreConfig(tipoConnettore);
                    ArrayList<org.openspcoop2.core.config.Property> cps = new ArrayList<org.openspcoop2.core.config.Property>();
                    if (cp != null && cp.length > 0) {
                        cps.addAll(Arrays.asList(cp));
                    }
                    connettore.setPropertyList(cps);
                }
            }
            this.addAutenticazioneApiKey(connettore, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue);
            if (ServletUtils.isCheckBoxEnabled((String)proxyEnabled)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("proxyType");
                prop.setValore(CostantiConnettori.CONNETTORE_HTTP_PROXY_TYPE_VALUE_HTTP);
                connettore.addProperty(prop);
                if (proxyHost != null && !"".equals(proxyHost)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("proxyHostname");
                    prop.setValore(proxyHost);
                    connettore.addProperty(prop);
                }
                if (proxyPort != null && !"".equals(proxyPort)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("proxyPort");
                    prop.setValore(proxyPort);
                    connettore.addProperty(prop);
                }
                if (proxyUsername != null && !"".equals(proxyUsername)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("proxyUsername");
                    prop.setValore(proxyUsername);
                    connettore.addProperty(prop);
                }
                if (proxyPassword != null && !"".equals(proxyPassword)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("proxyPassword");
                    prop.setValore(proxyPassword);
                    connettore.addProperty(prop);
                }
            }
            if (ServletUtils.isCheckBoxEnabled((String)tempiRispostaEnabled)) {
                if (tempiRispostaConnectionTimeout != null && !"".equals(tempiRispostaConnectionTimeout)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("connectionTimeout");
                    prop.setValore(tempiRispostaConnectionTimeout);
                    connettore.addProperty(prop);
                }
                if (tempiRispostaReadTimeout != null && !"".equals(tempiRispostaReadTimeout)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("readConnectionTimeout");
                    prop.setValore(tempiRispostaReadTimeout);
                    connettore.addProperty(prop);
                }
                if (tempiRispostaTempoMedioRisposta != null && !"".equals(tempiRispostaTempoMedioRisposta)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("avgResponseTime");
                    prop.setValore(tempiRispostaTempoMedioRisposta);
                    connettore.addProperty(prop);
                }
            }
            if (ServletUtils.isCheckBoxEnabled((String)opzioniAvanzate)) {
                // empty if block
            }
            if (TransferLengthModes.CONTENT_LENGTH.getNome().equals(transferMode) || TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("dataTransferMode");
                prop.setValore(transferMode);
                connettore.addProperty(prop);
            }
            if (TransferLengthModes.TRANSFER_ENCODING_CHUNKED.getNome().equals(transferMode) && transferModeChunkSize != null && !"".equals(transferModeChunkSize)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("transferChunkSize");
                prop.setValore(transferModeChunkSize);
                connettore.addProperty(prop);
            }
            if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) || CostantiConfigurazione.DISABILITATO.getValue().equals(redirectMode)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("followRedirects");
                prop.setValore(redirectMode);
                connettore.addProperty(prop);
            }
            if (CostantiConfigurazione.ABILITATO.getValue().equals(redirectMode) && redirectMaxHop != null && !"".equals(redirectMaxHop)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("maxHopRedirect");
                prop.setValore(redirectMaxHop);
                connettore.addProperty(prop);
            }
            if (tokenPolicy != null && !"".equals(tokenPolicy) && !"-".equals(tokenPolicy)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("tokenPolicy");
                prop.setValore(tokenPolicy);
                connettore.addProperty(prop);
            }
            ExtendedConnettoreConverter.fillExtendedInfoIntoConnettore(listExtendedConnettore, connettore);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new CoreException((Throwable)e);
        }
    }

    public void addAutenticazioneApiKey(org.openspcoop2.core.config.Connettore connettore, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue) {
        if (this.isAutenticazioneApiKey(apiKeyValue)) {
            org.openspcoop2.core.config.Property prop = new org.openspcoop2.core.config.Property();
            prop.setNome("apiKey");
            prop.setValore(apiKeyValue);
            connettore.addProperty(prop);
            if (apiKeyHeader != null && !"".equals(apiKeyHeader)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("apiKeyHeader");
                prop.setValore(apiKeyHeader);
                connettore.addProperty(prop);
            }
            if (this.isAutenticazioneApiKeyUseAppId(appIdValue)) {
                prop = new org.openspcoop2.core.config.Property();
                prop.setNome("appId");
                prop.setValore(appIdValue);
                connettore.addProperty(prop);
                if (appIdHeader != null && !"".equals(appIdHeader)) {
                    prop = new org.openspcoop2.core.config.Property();
                    prop.setNome("appIdHeader");
                    prop.setValore(appIdHeader);
                    connettore.addProperty(prop);
                }
            }
        }
    }

    public static String getOpzioniAvanzate(ConsoleHelper helper, String transfer_mode, String redirect_mode) throws Exception {
        String opzioniAvanzate = helper.getParameter("opzioni_avanzate");
        return ConnettoriHelper.getOpzioniAvanzate(opzioniAvanzate, transfer_mode, redirect_mode);
    }

    public static String getOpzioniAvanzate(String opzioniAvanzate, String transfer_mode, String redirect_mode) {
        if (opzioniAvanzate != null && !"".equals(opzioniAvanzate)) {
            return opzioniAvanzate;
        }
        if (opzioniAvanzate == null || "".equals(opzioniAvanzate)) {
            opzioniAvanzate = "no";
        }
        if (transfer_mode != null && !"".equals(transfer_mode) || redirect_mode != null && !"".equals(redirect_mode)) {
            opzioniAvanzate = "yes";
        }
        return opzioniAvanzate;
    }

    public boolean credenzialiCheckData(TipoOperazione tipoOp, boolean oldPasswordCifrata, boolean encryptEnabled, PasswordVerifier passwordVerifier) throws CoreException {
        boolean appIdModificabile;
        boolean tokenModiPDNDOauth;
        boolean tokenWithHttpsEnabledByConfigSA;
        String tipoauth;
        if (oldPasswordCifrata) {
            // empty if block
        }
        if ((tipoauth = this.getParameter("tipoauthCredenziali")) == null) {
            tipoauth = "nessuna";
        }
        String utente = this.getParameter("utenteCredenziali");
        String password = this.getParameter("passwordCredenziali");
        String subject = this.getParameter("subjectCredenziali");
        String principal = this.getParameter("principalCredenziali");
        String appId = this.getParameter("appIdCred");
        String tokenPolicy = this.getParameter("tokenPolicyCred");
        String tokenClientId = this.getParameter("tokenClientIdCred");
        boolean tokenByPDND = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth);
        boolean bl = tokenWithHttpsEnabledByConfigSA = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth);
        if (tokenWithHttpsEnabledByConfigSA) {
            tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
        }
        boolean bl2 = tokenModiPDNDOauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth);
        if (tokenModiPDNDOauth) {
            tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN;
        }
        if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC)) {
            StringBuilder motivazioneErrore;
            boolean validaPassword = false;
            if (TipoOperazione.ADD.equals((Object)tipoOp) || !encryptEnabled) {
                validaPassword = true;
            } else {
                String changePwd = this.getParameter("changepwd");
                if (ServletUtils.isCheckBoxEnabled((String)changePwd)) {
                    validaPassword = true;
                }
            }
            boolean passwordEmpty = false;
            if (validaPassword && (password == null || password.equals(""))) {
                passwordEmpty = true;
            }
            if (utente.equals("") || passwordEmpty) {
                Object tmpElenco = "";
                if (utente.equals("")) {
                    tmpElenco = "Utente";
                }
                if (passwordEmpty) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Password" : (String)tmpElenco + ", Password";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (!this.checkLength255(utente, "Utente")) {
                return false;
            }
            if (!this.checkLength255(password, "Password")) {
                return false;
            }
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC) && (utente.indexOf(" ") != -1 || validaPassword && password.indexOf(" ") != -1)) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (validaPassword && passwordVerifier != null && !passwordVerifier.validate(utente, password, motivazioneErrore = new StringBuilder())) {
                this.pd.setMessage(motivazioneErrore.toString());
                return false;
            }
        }
        if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
            String tipoCredenzialiSSLSorgente = this.getParameter("confSSLCredenziali");
            if (tipoCredenzialiSSLSorgente == null) {
                tipoCredenzialiSSLSorgente = "confMan";
            }
            String tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter("confSSLManSS");
            if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                if (subject.equals("")) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Subject");
                    return false;
                }
                if (!this.checkLengthSubject_SSL_Principal(subject, "Subject")) {
                    return false;
                }
                try {
                    CertificateUtils.validaPrincipal((String)subject, (PrincipalType)PrincipalType.SUBJECT);
                }
                catch (Exception e) {
                    this.pd.setMessage("Le credenziali di tipo ssl  possiedono un subject non valido: " + e.getMessage());
                    return false;
                }
                if (!ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned)) {
                    String issuer = this.getParameter("subjectIssuer");
                    if (!this.checkLengthSubject_SSL_Principal(issuer, "Issuer")) {
                        return false;
                    }
                    if (StringUtils.isNotEmpty((String)issuer)) {
                        try {
                            CertificateUtils.validaPrincipal((String)issuer, (PrincipalType)PrincipalType.ISSUER);
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Le credenziali di tipo ssl possiedono un issuer non valido: " + e.getMessage());
                            return false;
                        }
                    }
                }
            } else {
                String tipoCredenzialiSSLWizardStep = this.getParameter("confSSLCredWizStep");
                boolean validaFieldCert = tipoOp.equals((Object)TipoOperazione.ADD) || !tipoCredenzialiSSLWizardStep.equals("0");
                String tipoCredenzialiSSLTipoArchivioS = this.getParameter("confSSLCredTipoArch");
                ArchiveType tipoCredenzialiSSLTipoArchivio = null;
                tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
                BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter("confSSLCredFileCert");
                if (validaFieldCert) {
                    if (tipoCredenzialiSSLFileCertificato.getValue() == null || tipoCredenzialiSSLFileCertificato.getValue().length == 0) {
                        this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Certificato");
                        return false;
                    }
                    if (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER)) {
                        try {
                            ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                        }
                        catch (UtilsException e) {
                            this.pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                            return false;
                        }
                    }
                    String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter("confSSLCredFileCertPwd");
                    if (StringUtils.isEmpty((String)tipoCredenzialiSSLFileCertificatoPassword)) {
                        boolean required = true;
                        if (KeystoreType.JKS.isType(tipoCredenzialiSSLTipoArchivio.name())) {
                            required = this.core.isLoadCertificateWizardJksPasswordRequiredRequired();
                        } else if (KeystoreType.PKCS12.isType(tipoCredenzialiSSLTipoArchivio.name())) {
                            required = this.core.isLoadCertificateWizardPkcs12PasswordRequiredRequired();
                        }
                        if (required) {
                            this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare la Password");
                            return false;
                        }
                    }
                    List listaAliasEstrattiCertificato = new ArrayList();
                    try {
                        listaAliasEstrattiCertificato = ArchiveLoader.readAliases((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLFileCertificatoPassword);
                    }
                    catch (UtilsException e) {
                        this.pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                        return false;
                    }
                    String tipoCredenzialiSSLAliasCertificato = this.getParameter("confSSLCredAliasCert");
                    if (StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificato)) {
                        this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare un Alias");
                        return false;
                    }
                    if (!listaAliasEstrattiCertificato.contains(tipoCredenzialiSSLAliasCertificato)) {
                        this.pd.setMessage("L'Alias indicato non &egrave; presente all'interno del file caricato.");
                        return false;
                    }
                    try {
                        ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                    }
                    catch (UtilsException e) {
                        this.pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                        return false;
                    }
                }
            }
        }
        if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY) && (appIdModificabile = false) && ServletUtils.isCheckBoxEnabled((String)appId)) {
            if (utente.equals("")) {
                String tmpElenco = "";
                if (utente.equals("")) {
                    tmpElenco = "App ID";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                return false;
            }
            if (!this.checkLengthSubject_SSL_Principal(utente, "App ID")) {
                return false;
            }
        }
        if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL)) {
            if (principal.equals("")) {
                String tmpElenco = "";
                if (principal.equals("")) {
                    tmpElenco = "UserId";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                return false;
            }
            if (!this.checkLengthSubject_SSL_Principal(principal, "UserId")) {
                return false;
            }
        }
        if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN) || tokenWithHttpsEnabledByConfigSA) {
            StringBuilder sb = new StringBuilder();
            if (tokenPolicy == null || StringUtils.isEmpty((String)tokenPolicy) || "-".equals(tokenPolicy)) {
                sb.append("Token Policy");
            }
            if (tokenClientId == null || StringUtils.isEmpty((String)tokenClientId)) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("Identificativo");
            }
            if (sb.length() > 0) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + sb.toString());
                return false;
            }
            if (!this.checkLengthSubject_SSL_Principal(tokenClientId, "Identificativo")) {
                return false;
            }
        }
        if (!(tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC) || tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL) || tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL) || tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY) || tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN) || tipoauth.equals("nessuna"))) {
            this.pd.setMessage("Tipo dev'essere " + ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC + ", " + ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL + " o " + ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL + " o " + ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY + " o " + ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN + " o nessuna");
            return false;
        }
        return true;
    }

    public List<DataElement> addConnettoreDefaultRidefinitoToDati(List<DataElement> dati, TipoOperazione tipoOp, String modalita, String[] modalitaValues, String[] modalitaLabels, boolean servletRidefinito, String servletConnettore, Parameter[] parametriServletConnettore) {
        if (tipoOp != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Connettore");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("modCon");
        de.setLabel("Modalit&agrave;");
        de.setType(DataElementType.SELECT);
        de.setValues(modalitaValues);
        de.setLabels(modalitaLabels);
        de.setPostBack(true);
        de.setSelected(modalita);
        dati.add(de);
        if (servletRidefinito && modalita.equals("ridefinito")) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setName("proprietaConnettoreCustom");
            de.setUrl(servletConnettore, parametriServletConnettore);
            ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            dati.add(de);
        }
        return dati;
    }

    public boolean connettoreDefaultRidefinitoCheckData(TipoOperazione tipoOp, String modalita) {
        if (tipoOp != null) {
            // empty if block
        }
        if (StringUtils.isEmpty((String)modalita)) {
            this.pd.setMessage("Il campo Modalit&agrave; non pu&ograve; essere vuoto");
            return false;
        }
        return true;
    }

    public List<DataElement> addCredenzialiCertificatiToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String idCredenziale, String tipoauth, String subject, String toCall, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String promuoviCertificato, boolean visualizzaPromuoviCertificato, String aggiornaCertificatoCaricato, String servletCredenzialiChange, List<Parameter> parametersServletCredenzialiChange) throws DriverControlStationException, ParseException {
        if (servletCredenzialiChange == null || parametersServletCredenzialiChange != null) {
            // empty if block
        }
        DataElement de = null;
        de = new DataElement();
        de.setName("idCred");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idCredenziale);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Certificato");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("tipoauthCredenziali");
        de.setType(DataElementType.HIDDEN);
        de.setValue(tipoauth);
        dati.add(de);
        de = new DataElement();
        de.setName("confSSLCredFileCertUpdate");
        de.setType(DataElementType.HIDDEN);
        de.setValue(aggiornaCertificatoCaricato);
        dati.add(de);
        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauth)) {
            boolean add = "soggettiCredenzialiAdd.do".equals(toCall) || "serviziApplicativiCredenzialiAdd.do".equals(toCall);
            boolean visualizzaFieldCert = false;
            boolean visualizzaDownload = false;
            if (add) {
                visualizzaFieldCert = StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject);
            } else {
                visualizzaFieldCert = !tipoCredenzialiSSLStatoElaborazioneCertificato.equals("0") && StringUtils.isEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject);
                visualizzaDownload = tipoCredenzialiSSLStatoElaborazioneCertificato.equals("0");
            }
            boolean aggiuntoWizardStep = false;
            if (!add && visualizzaDownload) {
                de = new DataElement();
                de.setName("confSSLCredWizStep");
                de.setValue(tipoCredenzialiSSLStatoElaborazioneCertificato);
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                aggiuntoWizardStep = true;
            }
            String subtitleConfigurazione = "Configurazione";
            de = new DataElement();
            de.setLabel(subtitleConfigurazione);
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Modalit\u00e0");
            de.setName("confSSLCredenziali");
            de.setType(DataElementType.HIDDEN);
            de.setValue(tipoCredenzialiSSLSorgente);
            dati.add(de);
            if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                de = new DataElement();
                de.setLabel("Formato");
                de.setName("confSSLCredTipoArch");
                if (visualizzaFieldCert) {
                    de.setType(DataElementType.SELECT);
                    de.setLabels(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_LABELS);
                    de.setValues(ConnettoriCostanti.PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_VALUES);
                    de.setSelected(tipoCredenzialiSSLTipoArchivio.name());
                    de.setSize(this.getSize());
                    de.setPostBack(true);
                    if (ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio) || ArchiveType.JKS.equals((Object)tipoCredenzialiSSLTipoArchivio)) {
                        DataElementInfo dInfo = new DataElementInfo("Formato");
                        if (ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio)) {
                            dInfo.setHeaderBody("&Egrave; possibile caricare un certificato in uno dei seguenti formati:");
                            dInfo.setListBody(ConnettoriCostanti.LABEL_PARAMETRO_CREDENZIALI_AUTENTICAZIONE_CONFIGURAZIONE_SSL_TIPO_ARCHIVIO_INFO_CER_VALUES);
                        } else {
                            dInfo.setHeaderBody("Se il keystore contiene pi&ugrave; certificati verr&agrave; richiesto di sceglierne uno attraverso la selezione del corrispettivo 'alias'");
                        }
                        de.setInfo(dInfo);
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(tipoCredenzialiSSLTipoArchivio.name());
                }
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredFileCertPwd");
                de.setLabel("Password");
                de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLFileCertificatoPassword));
                if (visualizzaFieldCert && (tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.JKS) || tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.PKCS12))) {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.setSize(this.getSize());
                    de.setRequired(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                dati.add(de);
                String labelCertificato = null;
                labelCertificato = ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio) ? "Certificato" : "Archivio";
                DataElement fileDataElement = tipoCredenzialiSSLFileCertificato.getFileDataElement(labelCertificato, "", this.getSize());
                fileDataElement.setRequired(true);
                fileDataElement.setPostBack(false);
                if (!visualizzaFieldCert) {
                    fileDataElement.setType(DataElementType.HIDDEN);
                }
                dati.add(fileDataElement);
                dati.addAll(tipoCredenzialiSSLFileCertificato.getFileNameDataElement());
                dati.add(tipoCredenzialiSSLFileCertificato.getFileIdDataElement());
                if (!visualizzaFieldCert) {
                    de = new DataElement();
                    de.setName("confSSLCredFileModificaCertLink");
                    de.setValue("Cambia " + labelCertificato);
                    de.setPostBack(true);
                    de.setUrl("#");
                    de.setType(DataElementType.LINK);
                    dati.add(de);
                }
                if (!visualizzaFieldCert && visualizzaPromuoviCertificato && tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                    de = new DataElement();
                    de.setName("confSSLCredFileCertPromLink");
                    de.setValue("Promuovi come Certificato Principale");
                    de.setPostBack(true);
                    de.setUrl("#");
                    de.setType(DataElementType.LINK);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Alias");
                de.setName("confSSLCredAliasCert");
                if (listaAliasEstrattiCertificato.size() > 1) {
                    de.setType(DataElementType.SELECT);
                    ArrayList<String> listaLabels = new ArrayList<String>();
                    listaLabels.addAll(listaAliasEstrattiCertificato);
                    listaLabels.add(0, "--");
                    ArrayList<String> listaValues = new ArrayList<String>();
                    listaValues.addAll(listaAliasEstrattiCertificato);
                    listaValues.add(0, "");
                    de.setLabels(listaLabels);
                    de.setValues(listaValues);
                    de.setSelected(tipoCredenzialiSSLAliasCertificato);
                    de.setPostBack(true);
                    de.setSize(this.getSize());
                    de.setRequired(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(tipoCredenzialiSSLAliasCertificato);
                }
                dati.add(de);
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                    de = new DataElement();
                    de.setLabel("Certificato " + tipoCredenzialiSSLAliasCertificatoType + " v" + tipoCredenzialiSSLAliasCertificatoVersion);
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                }
                if (visualizzaDownload) {
                    de = new DataElement();
                    String idOggetto = null;
                    String tipoOggetto = "";
                    if ("soggettiCredenzialiChange.do".equals(toCall)) {
                        tipoOggetto = "sogg";
                        idOggetto = this.getParameter("id");
                    }
                    if ("serviziApplicativiCredenzialiChange.do".equals(toCall)) {
                        tipoOggetto = "sa";
                        idOggetto = this.getParameter("id");
                    }
                    de.setUrl("downloadDocumento", new Parameter[]{new Parameter("idAccordo", idOggetto), new Parameter("tipoDocumento", tipoOggetto), new Parameter("tipoDocumentoDaScaricare", "sslCert"), new Parameter("idCred", idCredenziale)});
                    de.setValue("Download");
                    de.setType(DataElementType.LINK);
                    de.setDisabilitaAjaxStatus();
                    dati.add(de);
                }
                boolean verificaCompleta = false;
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                    verificaCompleta = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                }
                de = new DataElement();
                de.setName("confSSLCredVerifTutti");
                de.setLabel("Verifica");
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(verificaCompleta);
                    de.setSize(this.getSize());
                    de.setLabelAffiancata(true);
                    de.setPostBack(true);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                }
                dati.add(de);
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject) && !verificaCompleta) {
                    de = new DataElement();
                    de.setName("confSSLCredVerifTuttiNoteDisable");
                    de.setType(DataElementType.NOTE);
                    de.setBold(true);
                    de.setLabel("Attenzione");
                    de.setValue("Con verifica disabilitata l'identificazione avviene analizzando solamente i campi Subject e Issuer");
                    dati.add(de);
                }
                de = new DataElement();
                de.setName("confSSLCredAliasCertSub");
                de.setLabel("Subject");
                de.setValue(tipoCredenzialiSSLAliasCertificatoSubject);
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSubject)) {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setRows(3);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertIss");
                de.setLabel("Issuer");
                de.setValue(tipoCredenzialiSSLAliasCertificatoIssuer);
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoIssuer)) {
                    de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                    de.setRows(3);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertType");
                de.setLabel("Type");
                de.setValue(tipoCredenzialiSSLAliasCertificatoType);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertVers");
                de.setLabel("Version");
                de.setValue(tipoCredenzialiSSLAliasCertificatoVersion);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertSN");
                de.setLabel("Serial Number");
                de.setValue(tipoCredenzialiSSLAliasCertificatoSerialNumber);
                if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSerialNumber)) {
                    de.setType(DataElementType.TEXT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSerialNumber)) {
                    String hexValue = null;
                    try {
                        hexValue = CertificateInfo.formatSerialNumberHex((String)tipoCredenzialiSSLAliasCertificatoSerialNumber, (String)":");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (hexValue != null && StringUtils.isNotEmpty((String)hexValue)) {
                        de = new DataElement();
                        de.setName("confSSLCredAliasCertSNhex");
                        de.setLabel("");
                        de.setValue("(Hex) " + hexValue);
                        de.setType(DataElementType.TEXT);
                        de.setSize(this.getSize());
                        dati.add(de);
                    }
                }
                de = new DataElement();
                de.setName("confSSLCredAliasCertSS");
                de.setLabel("Self Signed");
                de.setValue(tipoCredenzialiSSLAliasCertificatoSelfSigned);
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoSelfSigned)) {
                    de.setType(DataElementType.TEXT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertNB");
                de.setLabel("Not Before");
                de.setValue(tipoCredenzialiSSLAliasCertificatoNotBefore);
                if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoNotBefore)) {
                    de.setType(DataElementType.TEXT);
                    if (this.getSdfCredenziali().parse(tipoCredenzialiSSLAliasCertificatoNotBefore).after(new Date())) {
                        de.setValoreBold();
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertNA");
                de.setLabel("Not After");
                de.setValue(tipoCredenzialiSSLAliasCertificatoNotAfter);
                if (verificaCompleta && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificatoNotAfter)) {
                    de.setType(DataElementType.TEXT);
                    if (this.getSdfCredenziali().parse(tipoCredenzialiSSLAliasCertificatoNotAfter).before(new Date())) {
                        de.setValoreBoldRed();
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
                dati.add(de);
                if (!visualizzaFieldCert && visualizzaPromuoviCertificato && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                    de = new DataElement();
                    de.setLabelAffiancata(true);
                    de.setLabel("");
                    de.setNote("Promuovi come Certificato Principale");
                    de.setName("confSSLCredFileCertProm");
                    de.setValue(promuoviCertificato);
                    de.setType(DataElementType.CHECKBOX);
                    dati.add(de);
                }
                if (!aggiuntoWizardStep) {
                    de = new DataElement();
                    de.setName("confSSLCredWizStep");
                    de.setLabel("");
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(tipoCredenzialiSSLStatoElaborazioneCertificato);
                    dati.add(de);
                }
            } else {
                de = new DataElement();
                de.setName("confSSLManSS");
                de.setLabel("Self Signed");
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned));
                de.setSize(this.getSize());
                de.setPostBack(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Subject");
                de.setValue(subject);
                de.setType(DataElementType.TEXT_AREA);
                de.setName("subjectCredenziali");
                de.setRows(3);
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Issuer");
                de.setName("subjectIssuer");
                if (!ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned)) {
                    de.setType(DataElementType.TEXT_AREA);
                    de.setValue(issuer);
                    de.setRows(3);
                    de.setSize(this.getSize());
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("");
                }
                dati.add(de);
            }
        }
        return dati;
    }

    public List<DataElement> addCredenzialiCertificatiToDatiAsHidden(List<DataElement> dati, TipoOperazione tipoOperazione, String idCredenziale, String tipoauth, String subject, String toCall, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String promuoviCertificato, boolean visualizzaPromuoviCertificato, String servletCredenzialiChange, List<Parameter> parametersServletCredenzialiChange) {
        if (tipoOperazione != null || toCall != null || listaAliasEstrattiCertificato != null || promuoviCertificato != null || visualizzaPromuoviCertificato || servletCredenzialiChange != null || parametersServletCredenzialiChange != null) {
            // empty if block
        }
        DataElement de = null;
        de = new DataElement();
        de.setName("idCred");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idCredenziale);
        dati.add(de);
        de = new DataElement();
        de.setName("tipoauthCredenziali");
        de.setType(DataElementType.HIDDEN);
        de.setValue(tipoauth);
        dati.add(de);
        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoauth)) {
            de = new DataElement();
            de.setLabel("Modalit\u00e0");
            de.setName("confSSLCredenziali");
            de.setType(DataElementType.HIDDEN);
            de.setValue(tipoCredenzialiSSLSorgente);
            dati.add(de);
            if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                de = new DataElement();
                de.setLabel("Formato");
                de.setName("confSSLCredTipoArch");
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoCredenzialiSSLTipoArchivio.name());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredFileCertPwd");
                de.setLabel("Password");
                de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLFileCertificatoPassword));
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                String labelCertificato = null;
                labelCertificato = ArchiveType.CER.equals((Object)tipoCredenzialiSSLTipoArchivio) ? "Certificato" : "Archivio";
                DataElement fileDataElement = tipoCredenzialiSSLFileCertificato.getFileDataElement(labelCertificato, "", this.getSize());
                fileDataElement.setRequired(true);
                fileDataElement.setPostBack(false);
                fileDataElement.setType(DataElementType.HIDDEN);
                dati.add(fileDataElement);
                dati.addAll(tipoCredenzialiSSLFileCertificato.getFileNameDataElement());
                dati.add(tipoCredenzialiSSLFileCertificato.getFileIdDataElement());
                de = new DataElement();
                de.setLabel("Alias");
                de.setName("confSSLCredAliasCert");
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoCredenzialiSSLAliasCertificato);
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredVerifTutti");
                de.setLabel("Verifica");
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertSub");
                de.setLabel("Subject");
                de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoSubject));
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertIss");
                de.setLabel("Issuer");
                de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoIssuer));
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertType");
                de.setLabel("Type");
                de.setValue(tipoCredenzialiSSLAliasCertificatoType);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertVers");
                de.setLabel("Version");
                de.setValue(tipoCredenzialiSSLAliasCertificatoVersion);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertSN");
                de.setLabel("Serial Number");
                de.setValue(tipoCredenzialiSSLAliasCertificatoSerialNumber);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertSS");
                de.setLabel("Self Signed");
                de.setValue(tipoCredenzialiSSLAliasCertificatoSelfSigned);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertNB");
                de.setLabel("Not Before");
                de.setValue(tipoCredenzialiSSLAliasCertificatoNotBefore);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredAliasCertNA");
                de.setLabel("Not After");
                de.setValue(tipoCredenzialiSSLAliasCertificatoNotAfter);
                de.setType(DataElementType.HIDDEN);
                de.setSize(this.getSize());
                dati.add(de);
                de = new DataElement();
                de.setName("confSSLCredWizStep");
                de.setLabel("");
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoCredenzialiSSLStatoElaborazioneCertificato);
                dati.add(de);
            } else {
                de = new DataElement();
                de.setName("confSSLManSS");
                de.setLabel("Self Signed");
                de.setType(DataElementType.HIDDEN);
                de.setSelected(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned));
                de.setSize(this.getSize());
                de.setPostBack(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Subject");
                de.setValue(StringEscapeUtils.escapeHtml((String)subject));
                de.setType(DataElementType.HIDDEN);
                de.setName("subjectCredenziali");
                de.setRows(3);
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Issuer");
                de.setName("subjectIssuer");
                de.setValue(StringEscapeUtils.escapeHtml((String)issuer));
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
            }
        }
        return dati;
    }

    public String getLabelCredenzialeCertificato(String subject) {
        if (subject != null) {
            int length = 60;
            if (((String)subject).length() > length) {
                subject = ((String)subject).substring(0, length - 3) + "...";
            }
        }
        return subject;
    }
}

