/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.gruppi;

import java.util.HashMap;
import java.util.List;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.GruppoAccordo;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiHelper;

public class GruppiUtilities {
    public static void findOggettiDaAggiornare(IDGruppo oldIdGruppo, Gruppo gruppoNEW, GruppiCore gruppiCore, List<Object> listOggettiDaAggiornare) throws Exception {
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(gruppiCore);
        FiltroRicercaAccordi filtroRicercaAccordi = new FiltroRicercaAccordi();
        filtroRicercaAccordi.setIdGruppo(oldIdGruppo);
        List<IDAccordo> listAccordi = apcCore.getAllIdAccordiServizio(filtroRicercaAccordi);
        if (listAccordi != null && listAccordi.size() > 0) {
            for (IDAccordo idAccordoWithGruppo : listAccordi) {
                AccordoServizioParteComune accordoServizio = apcCore.getAccordoServizioFull(idAccordoWithGruppo, false);
                if (accordoServizio.getGruppi() != null && accordoServizio.getGruppi().sizeGruppoList() > 0) {
                    for (GruppoAccordo gruppoAccordo : accordoServizio.getGruppi().getGruppoList()) {
                        if (!gruppoAccordo.getNome().equals(oldIdGruppo.getNome())) continue;
                        gruppoAccordo.setNome(gruppoNEW.getNome());
                    }
                }
                listOggettiDaAggiornare.add(accordoServizio);
            }
        }
    }

    public static void deleteGruppo(Gruppo gruppo, String userLogin, GruppiCore gruppiCore, GruppiHelper gruppiHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !gruppiHelper.isModalitaCompleta();
        boolean gruppoInUso = gruppiCore.isGruppoInUso(gruppo.getNome(), whereIsInUso, normalizeObjectIds);
        if (gruppoInUso) {
            inUsoMessage.append(DBOggettiInUsoUtils.toString((IDGruppo)new IDGruppo(gruppo.getNome()), whereIsInUso, (boolean)true, (String)newLine));
            inUsoMessage.append(newLine);
        } else {
            gruppiCore.performDeleteOperation(userLogin, gruppiHelper.smista(), gruppo);
        }
    }
}

