/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import java.text.MessageFormat;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.AuthorizationFilter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;

public class HeadersFilter
implements Filter {
    private FilterConfig filterConfig = null;
    private ControlStationCore core = null;
    private static Logger log = ControlStationLogger.getPddConsoleCoreLogger();

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        try {
            this.core = new ControlStationCore();
        }
        catch (Exception e) {
            log.error("Errore durante il caricamento iniziale: " + e.getMessage(), (Throwable)e);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            this.gestioneContentSecurityPolicy(request, response);
            HeadersFilter.gestioneCacheControl(request, response, log);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore rilevato durante l'headersFilter", e);
            try {
                HttpSession session = request.getSession();
                GeneralHelper generalHelper = null;
                try {
                    generalHelper = new GeneralHelper(session);
                }
                catch (Exception eClose) {
                    ControlStationCore.logError("Errore rilevato durante l'headersFilter (reInit General Helper)", e);
                }
                AuthorizationFilter.setErrorMsg(generalHelper, session, request, response, "/jsplib/info.jsp", "L'ultima operazione effettuata ha provocato un errore che ha reso l'interfaccia non utilizzabile.<BR><BR>Effettuare nuovamente il login", this.filterConfig.getServletContext(), HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Exception eClose) {
                ControlStationCore.logError("Errore rilevato durante l'headersFilter (segnalazione errore)", e);
            }
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }

    private void gestioneContentSecurityPolicy(HttpServletRequest request, HttpServletResponse response) {
        String uuId = UUID.randomUUID().toString().replace("-", "");
        request.setAttribute("_csp_random_nonce", (Object)uuId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.core.getCspHeaderValue()})) {
            response.setHeader("Content-Security-Policy", MessageFormat.format(this.core.getCspHeaderValue(), uuId, uuId));
        }
    }

    private static void gestioneCacheControl(HttpServletRequest request, HttpServletResponse response, Logger log) {
        String[] staticResourceDirs;
        String requestUri = request.getRequestURI();
        if (requestUri != null && ServletUtils.isStaticResource((String)requestUri, (String[])(staticResourceDirs = new String[]{"images", "css", "fonts", "js"}))) {
            log.debug("Impostazione header Cache-Control per risorsa statica: {}", (Object)requestUri);
            response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            response.setDateHeader("Expires", 0L);
        }
    }
}

