/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.monitor;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.cxf.transport.http.HTTPException;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.pdd.monitor.Busta;
import org.openspcoop2.pdd.monitor.BustaServizio;
import org.openspcoop2.pdd.monitor.BustaSoggetto;
import org.openspcoop2.pdd.monitor.Dettaglio;
import org.openspcoop2.pdd.monitor.Messaggio;
import org.openspcoop2.pdd.monitor.Proprieta;
import org.openspcoop2.pdd.monitor.ServizioApplicativoConsegna;
import org.openspcoop2.pdd.monitor.StatoPdd;
import org.openspcoop2.pdd.monitor.constants.StatoMessaggio;
import org.openspcoop2.pdd.monitor.driver.DriverMonitoraggio;
import org.openspcoop2.pdd.monitor.driver.FilterSearch;
import org.openspcoop2.pdd.monitor.driver.FiltroStatoConsegnaAsincrona;
import org.openspcoop2.pdd.monitor.driver.StatoConsegnaAsincrona;
import org.openspcoop2.pdd.monitor.driver.StatoConsegneAsincrone;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateTimeFormatterWrapper;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.config.DatasourceProperties;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorCore;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorCostanti;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorFormBean;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorHelper;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorMethods;
import org.openspcoop2.web.ctrlstat.servlet.monitor.MonitorUtilities;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.audit.appender.AuditDisabilitatoException;
import org.openspcoop2.web.lib.audit.appender.IDOperazione;
import org.openspcoop2.web.lib.audit.log.constants.Tipologia;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.GeneralLink;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class Monitor
extends Action {
    private static Boolean initialized = null;
    protected static MonitorCore monitorCore = null;
    protected static PddCore pddCore = null;
    protected static Boolean singlePdD = false;
    protected static ConsoleProperties consoleProperties = null;
    protected static Map<String, DriverMonitoraggio> driverMonitoraggioLocale = null;
    protected static List<String> sorgentiDriverMonitoraggioLocale = null;
    protected static List<String> labelSorgentiDriverMonitoraggioLocale = null;

    private static synchronized void initMonitoraggio() throws Exception {
        if (initialized == null) {
            monitorCore = new MonitorCore();
            pddCore = new PddCore(monitorCore);
            if (monitorCore.isSinglePdD()) {
                DatasourceProperties datasourceProperties = null;
                try {
                    datasourceProperties = DatasourceProperties.getInstance();
                    sorgentiDriverMonitoraggioLocale = datasourceProperties.getSinglePddMonitorSorgentiDati();
                    if (sorgentiDriverMonitoraggioLocale == null || sorgentiDriverMonitoraggioLocale.isEmpty()) {
                        throw new Exception("Nessuna sorgente dati definita");
                    }
                }
                catch (Exception e) {
                    ControlStationLogger.getPddConsoleCoreLogger().error("[govwayConsole] Lettura proprieta' non riuscita : " + e.getMessage());
                    throw new Exception("[govwayConsole] Lettura proprieta' non riuscita : " + e.getMessage());
                }
                labelSorgentiDriverMonitoraggioLocale = new ArrayList<String>();
                driverMonitoraggioLocale = new HashMap<String, DriverMonitoraggio>();
                for (String sorgente : sorgentiDriverMonitoraggioLocale) {
                    String label = null;
                    String jndiName = "";
                    Properties jndiProp = null;
                    String tipoDatabase = null;
                    try {
                        label = datasourceProperties.getSinglePddMonitorLabel(sorgente);
                        jndiName = datasourceProperties.getSinglePddMonitorDataSource(sorgente);
                        jndiProp = datasourceProperties.getSinglePddMonitorDataSourceContext(sorgente);
                        tipoDatabase = datasourceProperties.getSinglePddMonitorTipoDatabase(sorgente);
                    }
                    catch (Exception e) {
                        ControlStationLogger.getPddConsoleCoreLogger().error("[govwayConsole] Lettura proprieta' non riuscita per la sorgente dati '" + sorgente + "' : " + e.getMessage());
                        throw new Exception("[govwayConsole] Lettura proprieta' non riuscita  per la sorgente dati '" + sorgente + "' : " + e.getMessage());
                    }
                    try {
                        labelSorgentiDriverMonitoraggioLocale.add(label);
                        driverMonitoraggioLocale.put(sorgente, new DriverMonitoraggio(jndiName, tipoDatabase, jndiProp));
                    }
                    catch (Exception e) {
                        ControlStationLogger.getPddConsoleCoreLogger().error("[govwayConsole] Inizializzazione DriverMonitoraggio non riuscita  per la sorgente dati '" + sorgente + "' : " + e.getMessage());
                        throw new Exception("[govwayConsole] Inizializzazione DriverMonitoraggio non riuscita  per la sorgente dati '" + sorgente + "' : " + e.getMessage());
                    }
                }
            }
            singlePdD = monitorCore.isSinglePdD();
            consoleProperties = ConsoleProperties.getInstance();
            initialized = true;
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pdold = ServletUtils.getPageDataFromSession((HttpServletRequest)request, (HttpSession)session);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        if (initialized == null) {
            Monitor.initMonitoraggio();
        }
        ConsoleHelper monitorHelper = null;
        try {
            int idLista;
            String newSearch;
            ConsoleSearch ricerca;
            FilterSearch filter;
            MonitorCore monitorCore = new MonitorCore();
            monitorHelper = new MonitorHelper(request, pd, session);
            ArrayList<String> errors = new ArrayList<String>();
            String metodo = monitorHelper.getParameter("method");
            String ns = monitorHelper.getParameter("newSearch");
            String[] tipoProfcoll = MonitorCostanti.getDefaultValuesParametroTipoProfiloCollaborazione();
            String actionConfirm = monitorHelper.getParameter("actionConfirm");
            if (!(!monitorHelper.isEditModeInProgress() || metodo != null && metodo.equals("details") || actionConfirm != null || ns != null && ns.equals("false"))) {
                MonitorFormBean mb = this.getBeanForm(errors, (MonitorHelper)monitorHelper);
                this.showForm(request, session, (MonitorHelper)monitorHelper, pd, tipoProfcoll, MonitorMethods.getMethodsNames(), "", "", mb, monitorCore);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            String pageSize = monitorHelper.getParameter("pageSize");
            MonitorFormBean formBean = null;
            if ((pageSize == null || pageSize.equals("")) && actionConfirm == null) {
                formBean = this.getBeanForm(errors, (MonitorHelper)monitorHelper);
            } else {
                formBean = (MonitorFormBean)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, MonitorFormBean.class, (String)"formBean");
                errors.add("Dati form non validi. I dati non sono presenti in sessione.");
            }
            if (formBean == null) {
                Object errMsg = "";
                ListIterator<String> it = errors.listIterator();
                while (it.hasNext()) {
                    String err = (String)it.next();
                    errMsg = (String)errMsg + err + "<br>";
                }
                pd.setMessage((String)errMsg);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            if (formBean.getMethod().equals("details")) {
                Messaggio messaggio;
                MonitorFormBean oldFormBeanRicerca = (MonitorFormBean)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, MonitorFormBean.class, (String)"formBean");
                String idMessaggio = formBean.getIdMessaggio();
                FilterSearch filter2 = new FilterSearch();
                filter2.setIdMessaggio(idMessaggio);
                filter2.setBusta(new Busta());
                filter2.setTipo(formBean.getTipo());
                ControlStationCore core = new ControlStationCore();
                SoggettiCore soggettiCore = new SoggettiCore(core);
                ArrayList<BustaSoggetto> filtroSoggetti = null;
                if (!core.isVisioneOggettiGlobale(userLogin)) {
                    List<IDSoggetto> filtroIds = soggettiCore.getSoggettiWithSuperuser(userLogin);
                    filtroSoggetti = new ArrayList<BustaSoggetto>();
                    for (IDSoggetto idSoggetto : filtroIds) {
                        BustaSoggetto sog = new BustaSoggetto();
                        sog.setTipo(idSoggetto.getTipo());
                        sog.setNome(idSoggetto.getNome());
                        filtroSoggetti.add(sog);
                    }
                }
                filter2.setSoggettoList(filtroSoggetti);
                long countMessaggi = MonitorUtilities.countListaRichiestePendenti(filter2, formBean.getPdd(), formBean.getSorgenteDati());
                List<Messaggio> listaMessaggi = MonitorUtilities.getListaRichiestePendenti(filter2, formBean.getPdd(), formBean.getSorgenteDati());
                if (countMessaggi > 0L) {
                    messaggio = listaMessaggi.get(0);
                    this.showDettagliMessaggio(pd, (MonitorHelper)monitorHelper, messaggio, oldFormBeanRicerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR_DETTAGLI);
                }
                filter2.setBusta(null);
                countMessaggi = MonitorUtilities.countListaRichiestePendenti(filter2, formBean.getPdd(), formBean.getSorgenteDati());
                listaMessaggi = MonitorUtilities.getListaRichiestePendenti(filter2, formBean.getPdd(), formBean.getSorgenteDati());
                if (countMessaggi > 0L) {
                    messaggio = listaMessaggi.get(0);
                    this.showDettagliMessaggio(pd, (MonitorHelper)monitorHelper, messaggio, oldFormBeanRicerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR_DETTAGLI);
                }
                pd.setMessage("Il messaggio [" + formBean.getIdMessaggio() + "] non e' piu presente. Impossibile visualizzare il dettaglio.");
                this.showForm(request, session, (MonitorHelper)monitorHelper, pd, tipoProfcoll, MonitorMethods.getMethodsNames(), "", "", formBean, monitorCore);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR_DETTAGLI);
            }
            String objToRemove = monitorHelper.getParameter("obj");
            String objToRemoveType = monitorHelper.getParameter("obj_t");
            if (objToRemove != null) {
                filter = new FilterSearch();
                ControlStationCore core = new ControlStationCore();
                SoggettiCore soggettiCore = new SoggettiCore(core);
                ArrayList<BustaSoggetto> filtroSoggetti = null;
                if (!core.isVisioneOggettiGlobale(userLogin)) {
                    List<IDSoggetto> filtroIds = soggettiCore.getSoggettiWithSuperuser(userLogin);
                    filtroSoggetti = new ArrayList<BustaSoggetto>();
                    for (IDSoggetto idSoggetto : filtroIds) {
                        BustaSoggetto sog = new BustaSoggetto();
                        sog.setTipo(idSoggetto.getTipo());
                        sog.setNome(idSoggetto.getNome());
                        filtroSoggetti.add(sog);
                    }
                }
                filter.setSoggettoList(filtroSoggetti);
                StringTokenizer objTok = new StringTokenizer(objToRemove, ",");
                int[] idToRemove = new int[objTok.countTokens()];
                Tipologia tipoOperazione = Tipologia.DEL;
                if (objToRemoveType != null && "resend".equals(objToRemoveType)) {
                    tipoOperazione = Tipologia.CHANGE;
                }
                long n = 0L;
                long nError = 0L;
                int k = 0;
                while (objTok.hasMoreElements()) {
                    idToRemove[k++] = Integer.parseInt(objTok.nextToken());
                }
                Object msgKO = "Impossibile cancellare Messaggio: <br>";
                Object msgOK = "Cancellato Messaggio : <br>";
                for (int i = 0; i < idToRemove.length; ++i) {
                    List dataElements = (List)pdold.getDati().get(idToRemove[i]);
                    DataElement de = (DataElement)dataElements.get(1);
                    String idMessaggio = de.getValue();
                    filter.setIdMessaggio(idMessaggio);
                    de = (DataElement)dataElements.get(2);
                    String tipo = de.getValue();
                    filter.setTipo(tipo);
                    IDOperazione[] idOperazione = null;
                    boolean auditDisabiltato = false;
                    try {
                        idOperazione = core.performAuditRequest(new Tipologia[]{tipoOperazione}, userLogin, filter);
                    }
                    catch (AuditDisabilitatoException disabilitato) {
                        auditDisabiltato = true;
                    }
                    try {
                        if (Tipologia.CHANGE.equals((Object)tipoOperazione)) {
                            long changeReali = MonitorUtilities.aggiornaDataRispedizioneRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                            if (changeReali > 0L) {
                                n += changeReali;
                            }
                        } else {
                            long deleteReali = MonitorUtilities.deleteRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                            if (deleteReali > 0L) {
                                n += deleteReali;
                            }
                        }
                        if (n > 0L) {
                            msgOK = (String)msgOK + " -" + idMessaggio + "<br>";
                        } else {
                            msgKO = (String)msgKO + " - " + idMessaggio + "<br>";
                        }
                        if (auditDisabiltato) continue;
                        core.performAuditComplete(idOperazione, new Tipologia[]{tipoOperazione}, userLogin, filter);
                        continue;
                    }
                    catch (Exception e) {
                        ++nError;
                        if (!auditDisabiltato) {
                            core.performAuditError(idOperazione, e.getMessage(), new Tipologia[]{tipoOperazione}, userLogin, filter);
                        }
                        msgKO = (String)msgKO + " - " + idMessaggio + "<br>";
                    }
                }
                if (Tipologia.CHANGE.equals((Object)tipoOperazione)) {
                    pd.setMessage("Aggiornata la data di rispedizione di " + n + " messaggi" + (n == 1L ? "o" : "") + (String)(nError > 0L ? "<br>L'aggiornamento \u00e8 fallito per " + nError + " messaggi" + (nError == 1L ? "o" : "") : ""), nError > 0L ? Costanti.MESSAGE_TYPE_ERROR : Costanti.MESSAGE_TYPE_INFO);
                } else {
                    pd.setMessage("Eliminat" + (n == 1L ? "o" : "i") + " " + n + " messaggi" + (n == 1L ? "o" : "") + (String)(nError > 0L ? "<br>L'eliminazione \u00e8 fallita per " + nError + " messaggi" + (nError == 1L ? "o" : "") : ""), nError > 0L ? Costanti.MESSAGE_TYPE_ERROR : Costanti.MESSAGE_TYPE_INFO);
                }
            }
            filter = new FilterSearch();
            FiltroStatoConsegnaAsincrona filterConsegnaAsincrona = new FiltroStatoConsegnaAsincrona();
            if (formBean.getOrderByConsegnaAsincrona() != null) {
                if ("In Coda".equals(formBean.getOrderByConsegnaAsincrona())) {
                    filterConsegnaAsincrona.setOrderByInCoda(true);
                } else if ("In Riconsegna".equals(formBean.getOrderByConsegnaAsincrona())) {
                    filterConsegnaAsincrona.setOrderByInRiconsegna(true);
                } else if ("In MessageBox".equals(formBean.getOrderByConsegnaAsincrona())) {
                    filterConsegnaAsincrona.setOrderByInMessageBox(true);
                }
            }
            BustaSoggetto mittente = formBean.getMittente();
            BustaSoggetto destinatario = formBean.getDestinatario();
            BustaServizio servizio = formBean.getServizio();
            String azione = formBean.getAzione();
            String profilo = formBean.getProfiloCollaborazione();
            boolean riscontro = formBean.isRiscontro();
            Busta busta = null;
            if (mittente != null || destinatario != null || servizio != null || azione != null || profilo != null || riscontro) {
                busta = new Busta();
                busta.setMittente(mittente);
                busta.setDestinatario(destinatario);
                busta.setAzione(azione);
                busta.setProfiloCollaborazione(profilo);
                busta.setServizio(servizio);
                busta.setAttesaRiscontro(riscontro);
                filter.setBusta(busta);
            }
            filter.setMessagePattern(formBean.getMessagePattern());
            filter.setIdMessaggio(formBean.getIdMessaggio());
            if (formBean.getSoglia() > 0L) {
                filter.setSoglia(formBean.getSoglia());
            }
            if (formBean.getStato() != null) {
                filter.setStato(StatoMessaggio.toEnumConstant((String)formBean.getStato()));
            }
            filter.setCorrelazioneApplicativa(formBean.getCorrelazioneApplicativa());
            ControlStationCore core = new ControlStationCore();
            SoggettiCore soggettiCore = new SoggettiCore(core);
            ArrayList<BustaSoggetto> filtroSoggetti = null;
            if (!core.isVisioneOggettiGlobale(userLogin)) {
                List<IDSoggetto> filtroIds = soggettiCore.getSoggettiWithSuperuser(userLogin);
                filtroSoggetti = new ArrayList<BustaSoggetto>();
                for (IDSoggetto idSoggetto : filtroIds) {
                    BustaSoggetto sog = new BustaSoggetto();
                    sog.setTipo(idSoggetto.getTipo());
                    sog.setNome(idSoggetto.getNome());
                    filtroSoggetti.add(sog);
                }
            }
            filter.setSoggettoList(filtroSoggetti);
            if (formBean.getMethod().equals(MonitorMethods.STATO_RICHIESTE.getNome())) {
                StatoPdd statoPdD = MonitorUtilities.getStatoRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                this.showStatoPdD(pd, (MonitorHelper)monitorHelper, statoPdD, MonitorMethods.STATO_RICHIESTE.getNome(), formBean);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR_STATO_PDD);
            }
            if (formBean.getMethod().equals(MonitorMethods.STATO_CONSEGNE_ASINCRONE.getNome())) {
                ricerca = new ConsoleSearch();
                newSearch = monitorHelper.getParameter("newSearch");
                if (newSearch != null && newSearch.equals("false")) {
                    Object oldfilter = ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"filterSearch");
                    if (oldfilter != null && oldfilter instanceof FiltroStatoConsegnaAsincrona) {
                        filterConsegnaAsincrona = (FiltroStatoConsegnaAsincrona)oldfilter;
                    }
                    ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                }
                idLista = Liste.MONITOR_MSG;
                ricerca = monitorHelper.checkSearchParameters(idLista, ricerca);
                ServletUtils.addListElementIntoSession((HttpServletRequest)request, (HttpSession)session, (String)"monitor", (Parameter[])new Parameter[0]);
                filter.setLimit((long)ricerca.getPageSize(idLista));
                filter.setOffset((long)ricerca.getIndexIniziale(idLista));
                StatoConsegneAsincrone statoConsegneAsincrone = MonitorUtilities.getStatoConsegneAsincrone(filterConsegnaAsincrona, formBean.getSorgenteDati());
                this.showStatoConsegneAsincrone(pd, (MonitorHelper)monitorHelper, statoConsegneAsincrone, MonitorMethods.STATO_CONSEGNE_ASINCRONE.getNome(), formBean);
                Parameter pMethod = new Parameter("method", MonitorMethods.STATO_CONSEGNE_ASINCRONE.getNome());
                Parameter pNewSearch = new Parameter("newSearch", "false");
                Parameter pSorgente = new Parameter("sorgente", formBean.getSorgenteDati());
                ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)formBean, (String)"formBean");
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)filterConsegnaAsincrona, (String)"filterSearch");
                ArrayList<Parameter> listRefresh = new ArrayList<Parameter>();
                listRefresh.add(pMethod);
                listRefresh.add(pNewSearch);
                listRefresh.add(pSorgente);
                pd.addComandoAggiornaRicercaButton("monitor.do", listRefresh);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            if (formBean.getMethod().equals(MonitorMethods.LISTA_RICHIESTE_PENDENTI.getNome())) {
                ricerca = new ConsoleSearch();
                newSearch = monitorHelper.getParameter("newSearch");
                if (newSearch != null && newSearch.equals("false")) {
                    Object oldfilter = ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"filterSearch");
                    if (oldfilter != null && oldfilter instanceof FilterSearch) {
                        filter = (FilterSearch)oldfilter;
                    }
                    ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                }
                idLista = Liste.MONITOR_MSG;
                ricerca = monitorHelper.checkSearchParameters(idLista, ricerca);
                ServletUtils.addListElementIntoSession((HttpServletRequest)request, (HttpSession)session, (String)"monitor", (Parameter[])new Parameter[0]);
                filter.setLimit((long)ricerca.getPageSize(idLista));
                filter.setOffset((long)ricerca.getIndexIniziale(idLista));
                long countMessaggi = MonitorUtilities.countListaRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                List<Messaggio> listaMessaggi = MonitorUtilities.getListaRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                this.showMessaggi(pd, (MonitorHelper)monitorHelper, countMessaggi, listaMessaggi, MonitorMethods.LISTA_RICHIESTE_PENDENTI.getNome(), ricerca, filter, formBean);
                Parameter pMethod = new Parameter("method", MonitorMethods.LISTA_RICHIESTE_PENDENTI.getNome());
                Parameter pNewSearch = new Parameter("newSearch", "false");
                Parameter pPdd = new Parameter("pdd", formBean.getPdd());
                Parameter pSorgente = new Parameter("sorgente", formBean.getSorgenteDati());
                ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)formBean, (String)"formBean");
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)filter, (String)"filterSearch");
                if (singlePdD.booleanValue()) {
                    request.setAttribute("params", (Object)ServletUtils.getParametersAsString((boolean)false, (Parameter[])new Parameter[]{pMethod, pNewSearch, pSorgente}));
                } else {
                    request.setAttribute("params", (Object)ServletUtils.getParametersAsString((boolean)false, (Parameter[])new Parameter[]{pMethod, pNewSearch, pPdd}));
                }
                ArrayList<Parameter> listRefresh = new ArrayList<Parameter>();
                listRefresh.add(pMethod);
                listRefresh.add(pNewSearch);
                listRefresh.add(pSorgente);
                pd.addComandoAggiornaRicercaButton("monitor.do", listRefresh);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            if (formBean.getMethod().equals(MonitorMethods.ELIMINAZIONE_RICHIESTE_PENDENTI.getNome()) || formBean.getMethod().equals(MonitorMethods.RICONSEGNA_IMMEDIATA_RICHIESTE_PENDENTI.getNome())) {
                boolean updateDataRispedizione = formBean.getMethod().equals(MonitorMethods.RICONSEGNA_IMMEDIATA_RICHIESTE_PENDENTI.getNome());
                if (actionConfirm == null) {
                    monitorHelper.makeMenu();
                    ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                    lstParam.add(new Parameter("Coda Messaggi", null));
                    ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                    Object msg = "";
                    if (filter != null) {
                        if (filter.getCorrelazioneApplicativa() != null && !"".equals(filter.getCorrelazioneApplicativa())) {
                            msg = (String)msg + "<br>ID Applicativo: " + filter.getCorrelazioneApplicativa();
                        }
                        if (filter.getMessagePattern() != null && !"".equals(filter.getMessagePattern())) {
                            msg = (String)msg + "<br>Contenuto Messaggio: " + filter.getMessagePattern();
                        }
                        if (filter.getSoglia() > 0L) {
                            msg = (String)msg + "<br>Messaggi piu' vecchi di (minuti): " + filter.getSoglia();
                        }
                        if (filter.getStato() != null && !"".equals(filter.getStato().getValue())) {
                            msg = (String)msg + "<br>Stato: " + filter.getStato();
                        }
                        if (filter.getIdMessaggio() != null && !"".equals(filter.getIdMessaggio())) {
                            msg = (String)msg + "<br>ID: " + filter.getIdMessaggio();
                        }
                        if (filter.getBusta() != null) {
                            if (filter.getBusta().getProfiloCollaborazione() != null && !"".equals(filter.getBusta().getProfiloCollaborazione())) {
                                msg = (String)msg + "<br>Profilo di collaborazione: " + filter.getBusta().getProfiloCollaborazione();
                            }
                            if (filter.getBusta().isAttesaRiscontro()) {
                                msg = (String)msg + "<br>In Attesa di Riscontro: " + filter.getBusta().isAttesaRiscontro();
                            }
                            if (filter.getBusta().getMittente() != null) {
                                if (filter.getBusta().getMittente().getTipo() != null && !"".equals(filter.getBusta().getMittente().getTipo())) {
                                    msg = (String)msg + "<br>Tipo Mittente: " + filter.getBusta().getMittente().getTipo();
                                }
                                if (filter.getBusta().getMittente().getNome() != null && !"".equals(filter.getBusta().getMittente().getNome())) {
                                    msg = (String)msg + "<br>Nome Mittente: " + filter.getBusta().getMittente().getNome();
                                }
                            }
                            if (filter.getBusta().getDestinatario() != null) {
                                if (filter.getBusta().getDestinatario().getTipo() != null && !"".equals(filter.getBusta().getDestinatario().getTipo())) {
                                    msg = (String)msg + "<br>Tipo Destinatario: " + filter.getBusta().getDestinatario().getTipo();
                                }
                                if (filter.getBusta().getDestinatario().getNome() != null && !"".equals(filter.getBusta().getDestinatario().getNome())) {
                                    msg = (String)msg + "<br>Nome Destinatario: " + filter.getBusta().getDestinatario().getNome();
                                }
                            }
                            if (filter.getBusta().getServizio() != null) {
                                if (filter.getBusta().getServizio().getTipo() != null && !"".equals(filter.getBusta().getServizio().getTipo())) {
                                    msg = (String)msg + "<br>Tipo Servizio: " + filter.getBusta().getServizio().getTipo();
                                }
                                if (filter.getBusta().getServizio().getNome() != null && !"".equals(filter.getBusta().getServizio().getNome())) {
                                    msg = (String)msg + "<br>Nome Servizio: " + filter.getBusta().getServizio().getNome();
                                }
                                if (filter.getBusta().getServizio().getVersione() != null && filter.getBusta().getServizio().getVersione() > 0) {
                                    msg = (String)msg + "<br>Versione Servizio: " + filter.getBusta().getServizio().getVersione();
                                }
                            }
                            if (filter.getBusta().getAzione() != null && !"".equals(filter.getBusta().getAzione())) {
                                msg = (String)msg + "<br>Azione: " + filter.getBusta().getAzione();
                            }
                        }
                    }
                    StatoPdd stato = MonitorUtilities.getStatoRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                    String prefixMsg = "Eliminare i";
                    if (updateDataRispedizione) {
                        prefixMsg = "Aggiornare la data di riconsegna dei";
                    }
                    if (stato.getTotMessaggi() > 0L) {
                        msg = ((String)msg).equals("") ? prefixMsg + " " + stato.getTotMessaggi() + " messaggi?" : prefixMsg + " " + stato.getTotMessaggi() + " messaggi corrispondenti ai filtri selezionati?<br>" + (String)msg;
                    } else {
                        msg = ((String)msg).equals("") ? "Non esistono messaggi" : "Non esistono messaggi corrispondenti ai filtri selezionati:<br>" + (String)msg;
                        pd.setMode("view-noeditbutton");
                    }
                    pd.setMessage((String)msg, Costanti.MESSAGE_TYPE_INFO);
                    Parameter pMethod = new Parameter("method", formBean.getMethod());
                    Parameter pActionconfirm = new Parameter("actionConfirm", "yes");
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)formBean, (String)"formBean");
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)filter, (String)"filterSearch");
                    request.setAttribute("params", (Object)ServletUtils.getParametersAsString((boolean)false, (Parameter[])new Parameter[]{pMethod, pActionconfirm}));
                    ServletUtils.addListElementIntoSession((HttpServletRequest)request, (HttpSession)session, (String)"monitor", (Parameter[])new Parameter[0]);
                    if (stato.getTotMessaggi() > 0L) {
                        String pre = "<p class=\"contenutoModal\"><span>";
                        String post = "</span></p>";
                        pd.setMessage(pre + (String)msg + post, Costanti.MESSAGE_TYPE_CONFIRM);
                        String[][] bottoni = new String[][]{{"Annulla", "AnnullaConferma()"}, {"Conferma", "EseguiConferma()"}};
                        pd.setBottoni(bottoni);
                        ArrayList<DataElement> dati = new ArrayList<DataElement>();
                        dati.add(ServletUtils.getDataElementForEditModeFinished());
                        pd.setDati(dati);
                        this.showForm(request, session, (MonitorHelper)monitorHelper, pd, tipoProfcoll, MonitorMethods.getMethodsNames(), "", "", formBean, monitorCore);
                    }
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
                }
                if (actionConfirm.equals("ok")) {
                    Tipologia tipoOperazione = Tipologia.DEL;
                    if (updateDataRispedizione) {
                        tipoOperazione = Tipologia.CHANGE;
                    }
                    IDOperazione[] idOperazione = null;
                    boolean auditDisabiltato = false;
                    try {
                        idOperazione = core.performAuditRequest(new Tipologia[]{tipoOperazione}, userLogin, filter);
                    }
                    catch (AuditDisabilitatoException disabilitato) {
                        auditDisabiltato = true;
                    }
                    try {
                        long n = -1L;
                        if (Tipologia.CHANGE.equals((Object)tipoOperazione)) {
                            pd.setMessage("Aggiornata la data di rispedizione di " + n + " messaggi" + ((n = MonitorUtilities.aggiornaDataRispedizioneRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati())) == 1L ? "o" : ""), Costanti.MESSAGE_TYPE_INFO);
                        } else {
                            n = MonitorUtilities.deleteRichiestePendenti(filter, formBean.getPdd(), formBean.getSorgenteDati());
                            pd.setMessage("Eliminat" + (n == 1L ? "o" : "i") + " " + n + " messaggi" + (n == 1L ? "o" : ""), Costanti.MESSAGE_TYPE_INFO);
                        }
                        if (!auditDisabiltato) {
                            core.performAuditComplete(idOperazione, new Tipologia[]{tipoOperazione}, userLogin, filter);
                        }
                    }
                    catch (Exception e) {
                        if (!auditDisabiltato) {
                            core.performAuditError(idOperazione, e.getMessage(), new Tipologia[]{tipoOperazione}, userLogin, filter);
                        }
                        throw e;
                    }
                }
                this.showForm(request, session, (MonitorHelper)monitorHelper, pd, tipoProfcoll, MonitorMethods.getMethodsNames(), "", "", formBean, monitorCore);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
        }
        catch (WebServiceException exception) {
            try {
                if (monitorHelper != null) {
                    monitorHelper.makeMenu();
                }
                ControlStationCore.getLog().error(exception.getMessage(), (Throwable)exception);
                Throwable e = exception;
                if (Utilities.existsInnerException((Throwable)e, HTTPException.class)) {
                    e = Utilities.getInnerException((Throwable)e, HTTPException.class);
                }
                pd.setMessage(e.getMessage());
                pd.disableEditMode();
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
            catch (Throwable e) {
                return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
            }
        }
        catch (Throwable e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"monitor", (ForwardParams)MonitorCostanti.TIPO_OPERAZIONE_MONITOR);
        }
    }

    private MonitorFormBean getBeanForm(ArrayList<String> errors, MonitorHelper monitorHelper) throws Exception {
        try {
            String versioneServizio;
            String profcoll;
            String tipo;
            String idMessaggio;
            MonitorFormBean form = null;
            String method = null;
            boolean trovato = false;
            method = monitorHelper.getParameter("method");
            if (method == null || method.equals("")) {
                return null;
            }
            MonitorMethods[] methods = MonitorMethods.values();
            for (int i = 0; i < methods.length && !trovato; ++i) {
                if (!method.equals(methods[i].getNome()) && !method.equals("details")) continue;
                trovato = true;
            }
            if (!trovato) {
                errors.add("Metodo selezionato sconosciuto. Selezionare un metodo tra:" + MonitorMethods.getMethodNames().toString());
                throw new Exception("Metodo selezionato SCONOSCIUTO.");
            }
            form = new MonitorFormBean();
            form.setMethod(method);
            String orderByConsegnaAsincrona = monitorHelper.getParameter("orderAsinc");
            if (orderByConsegnaAsincrona != null && !orderByConsegnaAsincrona.equals("")) {
                form.setOrderByConsegnaAsincrona(orderByConsegnaAsincrona);
            }
            if ((idMessaggio = monitorHelper.getParameter("idMessaggio")) != null && !idMessaggio.equals("")) {
                form.setIdMessaggio(idMessaggio);
            }
            if ((tipo = monitorHelper.getParameter("tipo")) != null && !tipo.equals("")) {
                form.setTipo(tipo);
            }
            if ((profcoll = monitorHelper.getParameter("profcoll")) == null || profcoll.equals("") || profcoll.equals("-")) {
                form.setProfiloCollaborazione(null);
            } else if (profcoll.equals("asincrono-asimmetrico")) {
                form.setProfiloCollaborazione(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO);
            } else if (profcoll.equals("asincrono-simmetrico")) {
                form.setProfiloCollaborazione(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO);
            } else if (profcoll.equals("sincrono")) {
                form.setProfiloCollaborazione(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINCRONO);
            } else if (profcoll.equals("oneway")) {
                form.setProfiloCollaborazione(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINGOLO_ONEWAY);
            }
            String tipoSogg = monitorHelper.getParameter("tipoMittente");
            String nomeSogg = monitorHelper.getParameter("nomeMittente");
            BustaSoggetto mittente = null;
            if (tipoSogg != null && !tipoSogg.equals("") || nomeSogg != null && !nomeSogg.equals("")) {
                mittente = new BustaSoggetto();
                mittente.setNome(nomeSogg);
                mittente.setTipo(tipoSogg);
            }
            form.setMittente(mittente);
            BustaSoggetto destinatario = null;
            tipoSogg = monitorHelper.getParameter("tipoDestinatario");
            nomeSogg = monitorHelper.getParameter("nomeDestinatario");
            if (tipoSogg != null && !tipoSogg.equals("") || nomeSogg != null && !nomeSogg.equals("")) {
                destinatario = new BustaSoggetto();
                destinatario.setNome(nomeSogg);
                destinatario.setTipo(tipoSogg);
            }
            form.setDestinatario(destinatario);
            BustaServizio servizio = null;
            String tipoServizio = monitorHelper.getParameter("tipoServizio");
            String nomeServizio = monitorHelper.getParameter("nomeServizio");
            if (tipoServizio != null && !tipoServizio.equals("") || nomeServizio != null && !nomeServizio.equals("")) {
                servizio = new BustaServizio();
                servizio.setNome(nomeServizio);
                servizio.setTipo(tipoServizio);
            }
            if ((versioneServizio = monitorHelper.getParameter("versioneServizio")) != null && !"".equals(versioneServizio)) {
                if (servizio == null) {
                    servizio = new BustaServizio();
                }
                servizio.setVersione(Integer.valueOf(versioneServizio));
            }
            form.setServizio(servizio);
            String azione = monitorHelper.getParameter("monitorAzione");
            if (azione != null && !azione.equals("")) {
                form.setAzione(azione);
            }
            String soglia = monitorHelper.getParameter("soglia");
            long sogliaLong = 0L;
            try {
                sogliaLong = Long.parseLong(soglia);
            }
            catch (Exception exception) {
                // empty catch block
            }
            form.setSoglia(sogliaLong);
            String riscontro = monitorHelper.getParameter("riscontro");
            if (riscontro != null && !riscontro.equals("")) {
                form.setRiscontro(true);
            }
            if (singlePdD.booleanValue()) {
                String sorgente = monitorHelper.getParameter("sorgente");
                if (sorgente != null && !sorgente.equals("")) {
                    form.setSorgenteDati(sorgente);
                }
            } else {
                String pdd = monitorHelper.getParameter("pdd");
                if (pdd != null && !pdd.equals("")) {
                    form.setPdd(pdd);
                }
            }
            String stato = monitorHelper.getParameter("stato");
            if (stato != null && (stato.equals("-") || stato.equals(""))) {
                stato = null;
            }
            form.setStato(stato);
            String correlazioneApplicativa = monitorHelper.getParameter("correlazioneApplicativa");
            if (correlazioneApplicativa != null && !correlazioneApplicativa.equals("")) {
                form.setCorrelazioneApplicativa(correlazioneApplicativa);
            }
            return form;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private List<Parameter> createSearchString(MonitorFormBean monitorFormBean) throws Exception {
        try {
            String profcoll;
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            if (monitorFormBean.getMethod() != null) {
                lstParam.add(new Parameter("method", monitorFormBean.getMethod()));
            }
            if (monitorFormBean.getPdd() != null) {
                lstParam.add(new Parameter("pdd", monitorFormBean.getPdd()));
            }
            if (monitorFormBean.getSorgenteDati() != null) {
                lstParam.add(new Parameter("sorgente", monitorFormBean.getSorgenteDati()));
            }
            if (monitorFormBean.getDestinatario() != null) {
                BustaSoggetto destinatario = monitorFormBean.getDestinatario();
                lstParam.add(new Parameter("tipoDestinatario", destinatario.getTipo()));
                lstParam.add(new Parameter("nomeDestinatario", destinatario.getNome()));
            }
            if (monitorFormBean.getMittente() != null) {
                BustaSoggetto mitt = monitorFormBean.getMittente();
                lstParam.add(new Parameter("tipoMittente", mitt.getTipo()));
                lstParam.add(new Parameter("nomeMittente", mitt.getNome()));
            }
            if (monitorFormBean.getServizio() != null) {
                BustaServizio serv = monitorFormBean.getServizio();
                lstParam.add(new Parameter("tipoServizio", serv.getTipo()));
                lstParam.add(new Parameter("nomeServizio", serv.getNome()));
                lstParam.add(new Parameter("versioneServizio", serv.getVersione() != null ? "" + serv.getVersione() : null));
            }
            if (monitorFormBean.getIdMessaggio() != null) {
                lstParam.add(new Parameter("idMessaggio", monitorFormBean.getIdMessaggio()));
            }
            if (monitorFormBean.getAzione() != null) {
                lstParam.add(new Parameter("monitorAzione", monitorFormBean.getAzione()));
            }
            if (monitorFormBean.getStato() != null) {
                lstParam.add(new Parameter("stato", monitorFormBean.getStato()));
            }
            if (monitorFormBean.getSoglia() > 0L) {
                lstParam.add(new Parameter("soglia", "" + monitorFormBean.getSoglia()));
            }
            if (monitorFormBean.isRiscontro()) {
                lstParam.add(new Parameter("riscontro", "" + monitorFormBean.isRiscontro()));
            }
            if ((profcoll = monitorFormBean.getProfiloCollaborazione()) == null) {
                lstParam.add(new Parameter("profcoll", "-"));
            } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO)) {
                lstParam.add(new Parameter("profcoll", "asincrono-asimmetrico"));
            } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)) {
                lstParam.add(new Parameter("profcoll", "asincrono-simmetrico"));
            } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINCRONO)) {
                lstParam.add(new Parameter("profcoll", "sincrono"));
            } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINGOLO_ONEWAY)) {
                lstParam.add(new Parameter("profcoll", "oneway"));
            } else {
                lstParam.add(new Parameter("profcoll", "-"));
            }
            if (monitorFormBean.getCorrelazioneApplicativa() != null) {
                lstParam.add(new Parameter("correlazioneApplicativa", monitorFormBean.getCorrelazioneApplicativa()));
            }
            return lstParam;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void showForm(HttpServletRequest request, HttpSession session, MonitorHelper monitorHelper, PageData pd, String[] profiliCollaborazione, String[] metodiMonitor, String azione, String soglia, MonitorFormBean mb, MonitorCore monitorCore) throws Exception {
        try {
            boolean showFilter;
            boolean showFilterConsegnaAsincrona;
            monitorHelper.makeMenu();
            ArrayList<GeneralLink> titlelist = new ArrayList<GeneralLink>();
            GeneralLink tl1 = new GeneralLink();
            tl1.setLabel("Coda Messaggi");
            titlelist.add(tl1);
            pd.setTitleList(titlelist);
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            dati.add(ServletUtils.getDataElementForEditModeFinished());
            DataElement de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Coda Messaggi");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Metodo");
            de.setType(DataElementType.SELECT);
            de.setName("method");
            de.setSelected(mb != null ? mb.getMethod() : "");
            de.setValues(metodiMonitor);
            de.setPostBack(true);
            dati.add(de);
            if (singlePdD.booleanValue()) {
                String sorgenteSelezionata;
                de = new DataElement();
                de.setLabel("Runtime");
                de.setName("sorgente");
                String string = sorgenteSelezionata = mb != null ? mb.getSorgenteDati() : sorgentiDriverMonitoraggioLocale.get(0);
                if (sorgentiDriverMonitoraggioLocale.size() > 1) {
                    de.setType(DataElementType.SELECT);
                    de.setValues(sorgentiDriverMonitoraggioLocale);
                    de.setLabels(labelSorgentiDriverMonitoraggioLocale);
                    de.setSelected(sorgenteSelezionata);
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(sorgenteSelezionata);
                }
                dati.add(de);
            } else {
                String user = ServletUtils.getUserLoginFromSession((HttpSession)session);
                List<PdDControlStation> pdds = pddCore.pddList(user, (ISearch)new ConsoleSearch(true));
                ArrayList<String> nomiPdD = new ArrayList<String>();
                for (PdDControlStation pdd : pdds) {
                    if (pdd.getTipo().equals(PddTipologia.ESTERNO.toString())) continue;
                    nomiPdD.add(pdd.getNome());
                }
                de = new DataElement();
                de.setLabel("Porta di Dominio");
                de.setType(DataElementType.SELECT);
                de.setName("pdd");
                de.setValues(nomiPdD.toArray(new String[nomiPdD.size()]));
                de.setSelected(mb != null ? mb.getPdd() : consoleProperties.getGestioneCentralizzataWSMonitorPddDefault());
                dati.add(de);
            }
            boolean bl = showFilterConsegnaAsincrona = mb == null || mb.getMethod() == null || mb.getMethod().equals(MonitorMethods.STATO_CONSEGNE_ASINCRONE.getNome());
            if (showFilterConsegnaAsincrona) {
                ArrayList<String> values = new ArrayList<String>();
                values.add("In Coda");
                values.add("In Riconsegna");
                values.add("In MessageBox");
                de = new DataElement();
                de.setLabel("Criterio di Ordinamento");
                de.setType(DataElementType.SELECT);
                de.setName("orderAsinc");
                de.setValues(values);
                de.setSelected(mb != null && mb.getOrderByConsegnaAsincrona() != null ? mb.getOrderByConsegnaAsincrona() : "In Coda");
                dati.add(de);
            }
            boolean bl2 = showFilter = mb != null && mb.getMethod() != null && !mb.getMethod().equals(MonitorMethods.STATO_CONSEGNE_ASINCRONE.getNome());
            if (showFilter) {
                String profcoll;
                de = new DataElement();
                de.setLabel("Filtro Ricerca");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("ID Applicativo");
                de.setName("correlazioneApplicativa");
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(mb != null ? mb.getCorrelazioneApplicativa() : "");
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Anzianit\u00e0 Messaggi (Minuti)");
                de.setNote("Permette di selezionare i messaggi pi\u00f9 vecchi dei minuti indicati");
                de.setType(DataElementType.TEXT_EDIT);
                de.setSize(monitorHelper.getSize());
                de.setName("soglia");
                de.setValue((String)(mb != null ? "" + mb.getSoglia() : soglia));
                dati.add(de);
                if (monitorCore.isShowJ2eeOptions()) {
                    String[] stati = MonitorCostanti.getDefaultValuesParametroStato();
                    de = new DataElement();
                    de.setLabel("Stato");
                    de.setType(DataElementType.SELECT);
                    de.setValues(stati);
                    de.setSelected(mb != null ? mb.getStato() : "-");
                    de.setName("stato");
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Informazioni Protocollo");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("ID");
                de.setName("idMessaggio");
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(mb != null ? mb.getIdMessaggio() : "");
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Profilo di collaborazione");
                de.setType(DataElementType.SELECT);
                de.setName("profcoll");
                de.setValues(profiliCollaborazione);
                String string = profcoll = mb != null ? mb.getProfiloCollaborazione() : "";
                if (profcoll == null || profcoll.equals("") || profcoll.equals("-")) {
                    de.setSelected("-");
                } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO)) {
                    de.setSelected("asincrono-asimmetrico");
                } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO)) {
                    de.setSelected("asincrono-simmetrico");
                } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINCRONO)) {
                    de.setSelected("sincrono");
                } else if (profcoll.equals(MonitorCostanti.LABEL_MONITOR_PROFILO_COLLABORAZIONE_SINGOLO_ONEWAY)) {
                    de.setSelected("oneway");
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("In Attesa di Riscontro");
                de.setType(DataElementType.CHECKBOX);
                de.setValue((String)(mb != null ? "" + mb.isRiscontro() : ""));
                de.setName("riscontro");
                dati.add(de);
                de = new DataElement();
                de.setLabel("Soggetto Mittente");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                SoggettiCore soggettiCore = new SoggettiCore(monitorCore);
                ArrayList<String> tipiSoggetti = new ArrayList<String>();
                ArrayList<String> tipiSoggetti_label = new ArrayList<String>();
                tipiSoggetti.add("");
                tipiSoggetti_label.add("-");
                tipiSoggetti.addAll(soggettiCore.getTipiSoggettiGestiti());
                tipiSoggetti_label.addAll(soggettiCore.getTipiSoggettiGestiti());
                de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setSize(monitorHelper.getSize());
                de.setName("tipoMittente");
                de.setSelected(mb != null ? (mb.getMittente() != null ? mb.getMittente().getTipo() : "") : "");
                de.setValues(tipiSoggetti);
                de.setLabels(tipiSoggetti_label);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT_EDIT);
                de.setSize(monitorHelper.getSize());
                de.setName("nomeMittente");
                de.setValue(mb != null ? (mb.getMittente() != null ? mb.getMittente().getNome() : "") : "");
                dati.add(de);
                de = new DataElement();
                de.setLabel("Soggetto Destinatario");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setSize(monitorHelper.getSize());
                de.setName("tipoDestinatario");
                de.setSelected(mb != null ? (mb.getDestinatario() != null ? mb.getDestinatario().getTipo() : "") : "");
                de.setValues(tipiSoggetti);
                de.setLabels(tipiSoggetti_label);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT_EDIT);
                de.setSize(monitorHelper.getSize());
                de.setName("nomeDestinatario");
                de.setValue(mb != null ? (mb.getDestinatario() != null ? mb.getDestinatario().getNome() : "") : "");
                dati.add(de);
                de = new DataElement();
                de.setLabel("Servizio");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                AccordiServizioParteSpecificaCore aspsCore = new AccordiServizioParteSpecificaCore(monitorCore);
                ArrayList<String> tipiServizi = new ArrayList<String>();
                ArrayList<String> tipiServizi_label = new ArrayList<String>();
                tipiServizi.add("");
                tipiServizi_label.add("-");
                List<String> list = monitorCore.getProtocolli(request, session);
                for (String protocolloL : list) {
                    tipiServizi.addAll(aspsCore.getTipiServiziGestitiProtocollo(protocolloL, ServiceBinding.SOAP));
                    tipiServizi_label.addAll(aspsCore.getTipiServiziGestitiProtocollo(protocolloL, ServiceBinding.SOAP));
                    List<String> l = aspsCore.getTipiServiziGestitiProtocollo(protocolloL, ServiceBinding.REST);
                    if (l == null || l.isEmpty()) continue;
                    for (String tipo : list) {
                        if (tipiServizi.contains(tipo)) continue;
                        tipiServizi.add(tipo);
                        tipiServizi_label.add(tipo);
                    }
                }
                de = new DataElement();
                de.setLabel("Tipo");
                de.setType(DataElementType.SELECT);
                de.setSize(monitorHelper.getSize());
                de.setName("tipoServizio");
                de.setSelected(mb != null ? (mb.getServizio() != null ? mb.getServizio().getTipo() : "") : "");
                de.setValues(tipiServizi);
                de.setLabels(tipiServizi_label);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.TEXT_EDIT);
                de.setSize(monitorHelper.getSize());
                de.setName("nomeServizio");
                de.setValue(mb != null ? (mb.getServizio() != null ? mb.getServizio().getNome() : "") : "");
                dati.add(de);
                String versione = null;
                if (mb != null && mb.getServizio() != null && mb.getServizio().getVersione() != null) {
                    versione = "" + mb.getServizio().getVersione();
                }
                de = monitorHelper.getVersionDataElement("Versione", "versioneServizio", versione, false);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Azione");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Azione");
                de.setType(DataElementType.TEXT_EDIT);
                de.setSize(monitorHelper.getSize());
                de.setName("monitorAzione");
                de.setValue(mb != null ? mb.getAzione() : azione);
                dati.add(de);
            }
            pd.setDati(dati);
            pd.setLabelBottoneInvia("Conferma");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void showStatoPdD(PageData pd, MonitorHelper monitorHelper, StatoPdd statoPdD, String methodName, MonitorFormBean monitorFormBean) throws Exception {
        try {
            pd.setIndex(0);
            pd.setPageSize(20);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Coda Messaggi", "monitor.do", this.createSearchString(monitorFormBean).toArray(new Parameter[lstParam.size()])));
            lstParam.add(new Parameter(methodName, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            monitorHelper.makeMenu();
            DataElement de = new DataElement();
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            if (statoPdD == null) {
                de = new DataElement();
                de.setLabel("Nessuna informazione presente!");
                de.setType(DataElementType.TEXT);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
            } else {
                de = new DataElement();
                de.setLabel("Stato Porta di Dominio");
                de.setType(DataElementType.TITLE);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Totale Messaggi");
                de.setType(DataElementType.TEXT);
                long totMsg = statoPdD.getTotMessaggi();
                de.setValue((String)(totMsg > 0L ? "" + totMsg : "Nessun Messaggio"));
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                if (totMsg > 0L) {
                    de = new DataElement();
                    de.setLabel("Tempo Massimo Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMaxAttesa() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tempo Medio Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMedioAttesa() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Messaggi in Consegna");
                de.setType(DataElementType.TITLE);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Totale Messaggi");
                de.setType(DataElementType.TEXT);
                long inConsegna = statoPdD.getNumMsgInConsegna();
                de.setValue((String)(inConsegna > 0L ? "" + inConsegna : "Nessun Messaggio in Consegna"));
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                if (inConsegna > 0L) {
                    de = new DataElement();
                    de.setLabel("Tempo Massimo Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMaxAttesaInConsegna() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tempo Medio Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMedioAttesaInConsegna() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Messaggi in Spedizione");
                de.setType(DataElementType.TITLE);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Totale Messaggi");
                de.setType(DataElementType.TEXT);
                long inSpedizione = statoPdD.getNumMsgInSpedizione();
                de.setValue((String)(inSpedizione > 0L ? "" + inSpedizione : "Nessun Messaggio in Spedizione"));
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                if (inSpedizione > 0L) {
                    de = new DataElement();
                    de.setLabel("Tempo Massimo Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMaxAttesaInSpedizione() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tempo Medio Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMedioAttesaInSpedizione() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Messaggi in Processamento");
                de.setType(DataElementType.TITLE);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Totale Messaggi");
                de.setType(DataElementType.TEXT);
                long inProcess = statoPdD.getNumMsgInProcessamento();
                de.setValue((String)(inProcess > 0L ? "" + inProcess : "Nessun Messaggio in Processamento"));
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                if (inProcess > 0L) {
                    de = new DataElement();
                    de.setLabel("Tempo Massimo Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMaxAttesaInProcessamento() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tempo Medio Attesa");
                    de.setType(DataElementType.TEXT);
                    de.setValue(Utilities.convertSystemTimeIntoStringMillisecondi((long)(statoPdD.getTempoMedioAttesaInProcessamento() * 1000L), (boolean)false));
                    de.setSize(monitorHelper.getSize());
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Messaggi Duplicati");
                de.setType(DataElementType.TITLE);
                de.setSize(monitorHelper.getSize());
                dati.add(de);
                de = new DataElement();
                de.setLabel("Totale Messaggi");
                de.setType(DataElementType.TEXT);
                long duplicati = statoPdD.getTotMessaggiDuplicati();
                de.setValue((String)(duplicati > 0L ? "" + duplicati : "Nessun Messaggio Duplicato"));
                de.setSize(monitorHelper.getSize());
                dati.add(de);
            }
            pd.setInserisciBottoni(false);
            pd.setMode("view-noeditbutton");
            pd.setDati(dati);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void showDettagliMessaggio(PageData pd, MonitorHelper monitorHelper, Messaggio messaggio, MonitorFormBean monitorFormBean) throws Exception {
        try {
            boolean riscontro;
            PorteApplicativeCore paCore = new PorteApplicativeCore(monitorCore);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore(monitorCore);
            SoggettiCore soggettiCore = new SoggettiCore(monitorCore);
            DateTimeFormatterWrapper formatterRispedizione = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
            List<Parameter> newSearchFalse = this.createSearchString(monitorFormBean);
            newSearchFalse.add(new Parameter("newSearch", "false"));
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Coda Messaggi", "monitor.do", this.createSearchString(monitorFormBean).toArray(new Parameter[lstParam.size()])));
            lstParam.add(new Parameter(MonitorMethods.LISTA_RICHIESTE_PENDENTI.getNome(), "monitor.do", newSearchFalse.toArray(new Parameter[lstParam.size()])));
            lstParam.add(new Parameter("Dettaglio Messaggio", null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            monitorHelper.makeMenu();
            ArrayList<DataElement> dati = new ArrayList<DataElement>();
            DataElement de = new DataElement();
            de.setLabel("Informazioni Protocollo");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("ID");
            de.setValue(messaggio.getIdMessaggio());
            de.setName("idMessaggio");
            dati.add(de);
            Busta busta = messaggio.getBustaInfo();
            BustaSoggetto mittente = busta != null ? busta.getMittente() : null;
            BustaSoggetto destinatario = busta != null ? busta.getDestinatario() : null;
            BustaServizio servizio = busta != null ? busta.getServizio() : null;
            String azione = busta != null ? busta.getAzione() : null;
            String profilo = busta != null ? busta.getProfiloCollaborazione() : null;
            String riferimento = busta != null ? busta.getRiferimentoMessaggio() : null;
            boolean bl = riscontro = busta != null ? busta.isAttesaRiscontro() : false;
            if (mittente != null && mittente.getTipo() != null && mittente.getNome() != null) {
                de = new DataElement();
                de.setLabel("Mittente");
                de.setType(DataElementType.TEXT);
                de.setValue(mittente.getTipo() + "/" + mittente.getNome());
                de.setName("mittente");
                dati.add(de);
            }
            if (destinatario != null) {
                de = new DataElement();
                de.setLabel("Destinatario");
                de.setType(DataElementType.TEXT);
                de.setValue(destinatario.getTipo() + "/" + destinatario.getNome());
                de.setName("destinatario");
                dati.add(de);
            }
            if (servizio != null) {
                de = new DataElement();
                de.setLabel("Servizio");
                de.setType(DataElementType.TEXT);
                de.setValue(servizio.getTipo() + "/" + servizio.getNome() + (String)(servizio.getVersione() != null ? " v" + servizio.getVersione() : ""));
                de.setName("servizio");
                dati.add(de);
            }
            if (azione != null) {
                de = new DataElement();
                de.setLabel("Azione");
                de.setType(DataElementType.TEXT);
                de.setValue(busta.getAzione());
                de.setName("monitorAzione");
                dati.add(de);
            }
            if (riferimento != null) {
                de = new DataElement();
                de.setLabel("Riferimento Messaggio");
                de.setType(DataElementType.TEXT);
                de.setValue(riferimento);
                de.setName("riferimento");
                dati.add(de);
            }
            if (profilo != null) {
                de = new DataElement();
                de.setLabel("Profilo Collaborazione");
                de.setType(DataElementType.TEXT);
                de.setValue(profilo);
                de.setName("profilo");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("In Attesa di Riscontro");
            de.setType(DataElementType.TEXT);
            de.setValue("" + riscontro);
            de.setName("riscontro");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dettaglio");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            Dettaglio dettaglio = messaggio.getDettaglio();
            de = new DataElement();
            de.setLabel("Tipo");
            de.setType(DataElementType.TEXT);
            de.setValue(dettaglio.getTipo());
            de.setName("tipo");
            dati.add(de);
            de = new DataElement();
            de.setLabel("ID Modulo");
            de.setType(DataElementType.TEXT);
            de.setValue(dettaglio.getIdModulo());
            de.setName("modulo");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.TEXT);
            if (messaggio.getStato() != null) {
                de.setValue(messaggio.getStato().getValue());
            }
            de.setName("stato");
            dati.add(de);
            if (dettaglio.getProprietaList() != null && dettaglio.getProprietaList().size() > 0) {
                for (int i = 0; i < dettaglio.getProprietaList().size(); ++i) {
                    de = new DataElement();
                    de.setLabel(((Proprieta)dettaglio.getProprietaList().get(i)).getNome());
                    de.setType(DataElementType.TEXT);
                    de.setValue(((Proprieta)dettaglio.getProprietaList().get(i)).getValore());
                    de.setName(((Proprieta)dettaglio.getProprietaList().get(i)).getNome());
                    dati.add(de);
                }
            }
            if (dettaglio.getIdCorrelazioneApplicativa() != null) {
                de = new DataElement();
                de.setLabel("ID Applicativo");
                de.setType(DataElementType.TEXT);
                de.setValue(dettaglio.getIdCorrelazioneApplicativa());
                de.setName("correlazioneApplicativa");
                dati.add(de);
            }
            DateTimeFormatterWrapper formatter = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss.SSS");
            de = new DataElement();
            de.setLabel("Ora Registrazione");
            de.setType(DataElementType.TEXT);
            de.setValue(formatter.format(messaggio.getOraRegistrazione().getTime()));
            de.setName("oraReg");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Ora Attuale");
            de.setType(DataElementType.TEXT);
            de.setValue(formatter.format(messaggio.getOraAttuale().getTime()));
            de.setName("oraAtt");
            dati.add(de);
            String erroreProcessamento = dettaglio.getErroreProcessamento();
            if (messaggio.getDettaglio().getServizioApplicativoConsegnaList().size() > 0) {
                for (int i = 0; i < messaggio.getDettaglio().getServizioApplicativoConsegnaList().size(); ++i) {
                    ServizioApplicativoConsegna sac1 = (ServizioApplicativoConsegna)messaggio.getDettaglio().getServizioApplicativoConsegnaList().get(i);
                    erroreProcessamento = sac1.getErroreProcessamento();
                    String labelSA = null;
                    String nomeConnettore = null;
                    String labelErogazione = null;
                    if (sac1.getNomePorta() != null && sac1.getNome() != null) {
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(sac1.getNomePorta());
                        if (paCore.existsPortaApplicativa(idPA)) {
                            PortaApplicativa pa = null;
                            try {
                                pa = paCore.getPortaApplicativa(idPA);
                            }
                            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                // empty catch block
                            }
                            if (pa != null) {
                                if (pa.getBehaviour() != null) {
                                    if (pa.sizeServizioApplicativoList() > 0) {
                                        for (int j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                                            PortaApplicativaServizioApplicativo pasa = pa.getServizioApplicativo(j);
                                            if (!pasa.getNome().equals(sac1.getNome())) continue;
                                            labelSA = pasa.getDatiConnettore() != null ? pasa.getDatiConnettore().getNome() : "Default";
                                            nomeConnettore = labelSA;
                                            break;
                                        }
                                    }
                                } else {
                                    IDServizioApplicativo idSA = new IDServizioApplicativo();
                                    idSA.setNome(sac1.getNome());
                                    idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                                    ServizioApplicativo sa = null;
                                    try {
                                        sa = saCore.getServizioApplicativo(idSA);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    if (sa != null && "server".equals(sa.getTipo())) {
                                        labelSA = sac1.getNome();
                                    }
                                }
                                if (labelErogazione == null) {
                                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                                    String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(pa.getTipoSoggettoProprietario());
                                    labelErogazione = monitorHelper.getLabelServizioErogazione(protocollo, idServizio);
                                }
                            }
                        }
                    }
                    de = new DataElement();
                    if (labelSA != null) {
                        de.setLabel("Dettagli Consegna [" + labelSA + "]");
                    } else {
                        de.setLabel("Dettagli Consegna");
                    }
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                    if (labelErogazione != null || sac1.getNomePorta() != null) {
                        de = new DataElement();
                        de.setLabel("Erogazione");
                        de.setType(DataElementType.TEXT);
                        if (labelErogazione != null) {
                            de.setValue(labelErogazione);
                        } else {
                            de.setValue(sac1.getNomePorta());
                        }
                        de.setName("nomeConsegnaPorta");
                        dati.add(de);
                    }
                    if (nomeConnettore != null) {
                        de = new DataElement();
                        de.setLabel("Connettore");
                        de.setType(DataElementType.TEXT);
                        de.setValue(nomeConnettore);
                        de.setName("nomeConsegnaConnettore");
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setLabel("Nome Applicativo");
                    de.setType(DataElementType.TEXT);
                    de.setValue(sac1.getNome());
                    de.setName("nomeConsegnaApp");
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Tipo");
                    de.setType(DataElementType.TEXT);
                    de.setValue(sac1.getTipoConsegna());
                    de.setName("tipoConsegna");
                    dati.add(de);
                    if (erroreProcessamento != null) {
                        de = new DataElement();
                        de.setLabel("Errore Processamento");
                        de.setValue(erroreProcessamento);
                        de.setName("errore");
                        if (erroreProcessamento != null && !"".equals(erroreProcessamento)) {
                            de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                            de.setRows(6);
                            de.setCols(80);
                        } else {
                            de.setType(DataElementType.TEXT);
                        }
                        dati.add(de);
                    }
                    if ("Connettore".equals(sac1.getTipoConsegna())) {
                        if (sac1.getDataRispedizione() != null) {
                            de = new DataElement();
                            de.setLabel("Prossima Consegna");
                            de.setType(DataElementType.TEXT);
                            de.setValue(formatterRispedizione.format(sac1.getDataRispedizione()));
                            de.setName("dataRispedizione");
                            dati.add(de);
                        }
                        de = new DataElement();
                        de.setLabel("Priorita");
                        de.setType(DataElementType.TEXT);
                        de.setValue(sac1.getPriorita());
                        de.setName("priorita");
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Coda");
                        de.setType(DataElementType.TEXT);
                        de.setValue(sac1.getCoda());
                        de.setName("coda");
                        dati.add(de);
                        if (sac1.isAttesaEsito()) {
                            de = new DataElement();
                            de.setLabel("Attesa Esito Sincrono");
                            de.setType(DataElementType.TEXT);
                            de.setValue("" + sac1.isAttesaEsito());
                            de.setName("attesaEsito");
                            dati.add(de);
                        }
                    }
                    de = new DataElement();
                    de.setLabel("Authz MessageBox");
                    de.setType(DataElementType.TEXT);
                    de.setValue("" + sac1.isAutorizzazioneIntegrationManager());
                    de.setName("autorizzazione");
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Sbustamento SOAP");
                    de.setType(DataElementType.TEXT);
                    de.setValue("" + sac1.isSbustamentoSoap());
                    de.setName("sbustamento");
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Sbustamento Protocollo");
                    de.setType(DataElementType.TEXT);
                    de.setValue("" + sac1.isSbustamentoInformazioniProtocollo());
                    de.setName("sbustamentoProtocollo");
                    dati.add(de);
                }
            } else if (erroreProcessamento != null && !"".equals(erroreProcessamento)) {
                de = new DataElement();
                de.setLabel("Errore Processamento");
                de.setValue(erroreProcessamento);
                de.setName("errore");
                de.setType(DataElementType.TEXT_AREA_NO_EDIT);
                de.setRows(6);
                de.setCols(80);
                dati.add(de);
            }
            pd.setDati(dati);
            pd.setMode("view-noeditbutton");
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void showStatoConsegneAsincrone(PageData pd, MonitorHelper monitorHelper, StatoConsegneAsincrone statoConsegneAsincrone, String methodName, MonitorFormBean monitorFormBean) throws Exception {
        try {
            pd.setPaginazione(false);
            pd.setSearch("off");
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Coda Messaggi", "monitor.do", this.createSearchString(monitorFormBean).toArray(new Parameter[lstParam.size()])));
            lstParam.add(new Parameter(methodName, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            monitorHelper.makeMenu();
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Servizio");
            labels.add("In Coda");
            labels.add("In Riconsegna");
            labels.add("In MessageBox");
            pd.setLabels(labels.toArray(new String[1]));
            ArrayList dati = new ArrayList();
            if (statoConsegneAsincrone != null && statoConsegneAsincrone.size() > 0) {
                DataElement de = null;
                DateTimeFormatterWrapper formatter = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm");
                SoggettiCore soggettiCore = new SoggettiCore(monitorCore);
                List servizi = statoConsegneAsincrone.getServiziApplicativi();
                for (String servizioApplicativo : servizi) {
                    StringBuilder sb;
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    StatoConsegnaAsincrona stato = statoConsegneAsincrone.getStato(servizioApplicativo);
                    de = new DataElement();
                    IDServizio idServizio = monitorCore.getLabelNomeServizioApplicativo(stato.getServizioApplicativo());
                    if (idServizio == null) {
                        de.setValue(stato.getServizioApplicativo());
                    } else {
                        String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(idServizio.getSoggettoErogatore().getTipo());
                        String nomeErogazione = monitorHelper.getLabelServizioErogazione(protocollo, idServizio);
                        if (idServizio.getAzione() != null) {
                            de.setValue(idServizio.getAzione() + " di " + nomeErogazione);
                        } else {
                            de.setValue(nomeErogazione);
                        }
                    }
                    de.setToolTip("Ora Attuale: " + formatter.format(stato.getNow()));
                    e.add(de);
                    de = new DataElement();
                    if (stato.getInCoda() > 0L) {
                        sb = new StringBuilder();
                        sb.append("<b>").append(stato.getInCoda()).append("</b> ");
                        if (stato.getVecchioInCoda() != null) {
                            sb.append(" (").append(formatter.format(stato.getVecchioInCoda()));
                        }
                        if (stato.getRecenteInCoda() != null) {
                            if (stato.getVecchioInCoda() != null) {
                                sb.append(" -");
                            }
                            sb.append(" ").append(formatter.format(stato.getRecenteInCoda())).append(")");
                        }
                        de.setValue(sb.toString());
                    } else {
                        de.setValue("" + stato.getInCoda());
                    }
                    e.add(de);
                    de = new DataElement();
                    if (stato.getInRiconsegna() > 0L) {
                        sb = new StringBuilder();
                        sb.append("<b>").append(stato.getInRiconsegna()).append("</b> ");
                        if (stato.getVecchioInRiconsegna() != null) {
                            sb.append(" (").append(formatter.format(stato.getVecchioInRiconsegna()));
                        }
                        if (stato.getRecenteInRiconsegna() != null) {
                            if (stato.getVecchioInRiconsegna() != null) {
                                sb.append(" -");
                            }
                            sb.append(" ").append(formatter.format(stato.getRecenteInRiconsegna())).append(")");
                        }
                        de.setValue(sb.toString());
                    } else {
                        de.setValue("" + stato.getInRiconsegna());
                    }
                    e.add(de);
                    de = new DataElement();
                    if (stato.getInMessageBox() > 0L) {
                        sb = new StringBuilder();
                        sb.append("<b>").append(stato.getInMessageBox()).append("</b> ");
                        if (stato.getVecchioInMessageBox() != null) {
                            sb.append(" (").append(formatter.format(stato.getVecchioInMessageBox()));
                        }
                        if (stato.getRecenteInMessageBox() != null) {
                            if (stato.getVecchioInMessageBox() != null) {
                                sb.append(" -");
                            }
                            sb.append(" ").append(formatter.format(stato.getRecenteInMessageBox())).append(")");
                        }
                        de.setValue(sb.toString());
                    } else {
                        de.setValue("" + stato.getInMessageBox());
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            pd.setSelect(false);
            pd.setRemoveButton(false);
            pd.setAddButton(false);
            pd.setDati(dati);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void showMessaggi(PageData pd, MonitorHelper monitorHelper, long countMessaggi, List<Messaggio> listaMessaggi, String methodName, ConsoleSearch ricerca, FilterSearch filterSearch, MonitorFormBean monitorFormBean) throws Exception {
        try {
            int idLista = Liste.MONITOR_MSG;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            pd.setIndex(offset);
            pd.setPageSize(limit);
            pd.setSearch("off");
            int totMsg = (int)countMessaggi;
            pd.setNumEntries(totMsg);
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Coda Messaggi", "monitor.do", this.createSearchString(monitorFormBean).toArray(new Parameter[lstParam.size()])));
            lstParam.add(new Parameter(methodName, null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            monitorHelper.makeMenu();
            Busta busta = filterSearch.getBusta();
            BustaServizio servizio = busta != null ? busta.getServizio() : null;
            BustaSoggetto mittente = busta != null ? busta.getMittente() : null;
            BustaSoggetto destinatario = busta != null ? busta.getDestinatario() : null;
            String profilo = busta != null ? busta.getProfiloCollaborazione() : null;
            String azione = busta != null ? busta.getAzione() : null;
            String idMessaggio = filterSearch.getIdMessaggio();
            String correlazioneApplicativa = filterSearch.getCorrelazioneApplicativa();
            long soglia = filterSearch.getSoglia();
            boolean riscontro = busta != null ? busta.isAttesaRiscontro() : false;
            String _mittente = null;
            if (mittente != null) {
                _mittente = this.getIntestazioneFiltroRicerca(mittente.getTipo(), mittente.getNome());
            }
            String _destinatario = null;
            if (destinatario != null) {
                _destinatario = this.getIntestazioneFiltroRicerca(destinatario.getTipo(), destinatario.getNome());
            }
            Object _servizio = null;
            if (servizio != null) {
                _servizio = this.getIntestazioneFiltroRicerca(servizio.getTipo(), servizio.getNome());
            }
            if (servizio != null && servizio.getVersione() != null) {
                _servizio = _servizio != null ? (String)_servizio + " v" + servizio.getVersione() : "v" + servizio.getVersione();
            }
            StringBuilder parametriFiltro = new StringBuilder();
            if (correlazioneApplicativa != null) {
                if (parametriFiltro.length() > 0) {
                    parametriFiltro.append(" and ");
                }
                parametriFiltro.append("ID Applicativo").append("=").append(correlazioneApplicativa);
            }
            if (soglia > 0L) {
                if (parametriFiltro.length() > 0) {
                    parametriFiltro.append(" and ");
                }
                parametriFiltro.append("Anzianit\u00e0 Messaggi (Minuti)").append("=").append("" + soglia);
            }
            if (monitorCore.isShowJ2eeOptions() && filterSearch.getStato() != null && !"".equals(filterSearch.getStato().getValue()) && !"-".equals(filterSearch.getStato().getValue())) {
                if (parametriFiltro.length() > 0) {
                    parametriFiltro.append(" and ");
                }
                parametriFiltro.append("Stato").append("=").append("" + filterSearch.getStato());
            }
            if (idMessaggio != null) {
                if (parametriFiltro.length() > 0) {
                    parametriFiltro.append(" and ");
                }
                parametriFiltro.append("ID").append("=").append(idMessaggio);
            }
            if (busta != null) {
                if (profilo != null) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("Profilo Collaborazione").append("=").append(profilo);
                }
                if (riscontro) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("In Attesa di Riscontro").append("=").append("" + riscontro);
                }
                if (_mittente != null) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("Mittente").append("=").append(_mittente);
                }
                if (_destinatario != null) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("Destinatario").append("=").append(_destinatario);
                }
                if (_servizio != null) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("Servizio").append("=").append((String)_servizio);
                }
                if (azione != null && !azione.equals("")) {
                    if (parametriFiltro.length() > 0) {
                        parametriFiltro.append(" and ");
                    }
                    parametriFiltro.append("Azione").append("=").append(azione);
                }
            }
            if (parametriFiltro.length() > 0) {
                StringBuilder sb = new StringBuilder("Filtro: ");
                sb.append(parametriFiltro.toString());
                pd.setMessage(sb.toString(), Costanti.MESSAGE_TYPE_INFO);
            }
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Ora Registrazione");
            if (monitorCore.isShowJ2eeOptions()) {
                labels.add("Stato");
            }
            labels.add("Erogazione");
            labels.add("Dettaglio");
            pd.setLabels(labels.toArray(new String[1]));
            ArrayList dati = new ArrayList();
            boolean existsMessaggioInConsegna = false;
            if (listaMessaggi != null) {
                DataElement de = null;
                DateTimeFormatterWrapper formatter = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm");
                DateTimeFormatterWrapper formatterRispedizione = DateUtils.getDefaultDateTimeFormatter((String)"yyyy-MM-dd HH:mm:ss");
                HashMap<String, PortaApplicativa> mapPA = new HashMap<String, PortaApplicativa>();
                HashMap<String, Boolean> mapConsegnaMultipla = new HashMap<String, Boolean>();
                HashMap<CallSite, Boolean> mapServer = new HashMap<CallSite, Boolean>();
                HashMap<CallSite, String> mapConnettori = new HashMap<CallSite, String>();
                HashMap<CallSite, String> mapEndpointConnettori = new HashMap<CallSite, String>();
                HashMap<String, String> mapErogazione = new HashMap<String, String>();
                PorteApplicativeCore paCore = new PorteApplicativeCore(monitorCore);
                ServiziApplicativiCore saCore = new ServiziApplicativiCore(monitorCore);
                SoggettiCore soggettiCore = new SoggettiCore(monitorCore);
                for (int i = 0; i < listaMessaggi.size(); ++i) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Messaggio messaggio = listaMessaggi.get(i);
                    String tipo = messaggio.getDettaglio() != null ? messaggio.getDettaglio().getTipo() : "";
                    de = new DataElement();
                    String pdd = "";
                    if (monitorFormBean.getPdd() != null && !"".equals(monitorFormBean.getPdd())) {
                        pdd = monitorFormBean.getPdd();
                    }
                    String sorgente = "";
                    if (monitorFormBean.getSorgenteDati() != null && !"".equals(monitorFormBean.getSorgenteDati())) {
                        sorgente = monitorFormBean.getSorgenteDati();
                    }
                    de.setUrl("monitor.do", new Parameter[]{new Parameter("idMessaggio", messaggio.getIdMessaggio()), new Parameter("method", "details"), new Parameter("tipo", tipo), new Parameter("pdd", pdd), new Parameter("sorgente", sorgente)});
                    de.setToolTip(messaggio.getIdMessaggio());
                    Date oraRegistrazione = messaggio.getOraRegistrazione();
                    de.setValue(formatter.format(oraRegistrazione));
                    e.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.HIDDEN);
                    de.setName("idMessaggio");
                    de.setValue(messaggio.getIdMessaggio());
                    e.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.HIDDEN);
                    de.setName("tipo");
                    de.setValue(tipo);
                    e.add(de);
                    if (monitorCore.isShowJ2eeOptions()) {
                        de = new DataElement();
                        StatoMessaggio stato = messaggio.getStato();
                        String statoS = "";
                        if (stato != null) {
                            statoS = stato.getValue();
                        }
                        de.setValue(statoS);
                        e.add(de);
                    }
                    Dettaglio dettaglio = messaggio.getDettaglio();
                    String nomeErogazione = null;
                    Boolean consegnaMultipla = null;
                    String nomePortaSac0 = null;
                    if (dettaglio != null && dettaglio.getServizioApplicativoConsegnaList().size() > 0) {
                        ServizioApplicativoConsegna sac0 = (ServizioApplicativoConsegna)messaggio.getDettaglio().getServizioApplicativoConsegnaList().get(0);
                        nomePortaSac0 = sac0.getNomePorta();
                        nomeErogazione = (String)mapErogazione.get(sac0.getNomePorta());
                        consegnaMultipla = (Boolean)mapConsegnaMultipla.get(sac0.getNomePorta());
                        if (nomeErogazione == null || consegnaMultipla == null) {
                            PortaApplicativa pa = (PortaApplicativa)mapPA.get(sac0.getNomePorta());
                            if (pa == null) {
                                IDPortaApplicativa idPA = new IDPortaApplicativa();
                                idPA.setNome(sac0.getNomePorta());
                                try {
                                    pa = paCore.getPortaApplicativa(idPA);
                                    mapPA.put(sac0.getNomePorta(), pa);
                                }
                                catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                    // empty catch block
                                }
                            }
                            if (pa != null) {
                                if (nomeErogazione == null) {
                                    IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                                    String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(pa.getTipoSoggettoProprietario());
                                    nomeErogazione = monitorHelper.getLabelServizioErogazione(protocollo, idServizio);
                                    if (nomeErogazione != null) {
                                        mapErogazione.put(sac0.getNomePorta(), nomeErogazione);
                                    }
                                }
                                if (consegnaMultipla == null) {
                                    consegnaMultipla = pa.getBehaviour() != null;
                                    mapConsegnaMultipla.put(sac0.getNomePorta(), consegnaMultipla);
                                }
                            }
                        }
                    }
                    de = new DataElement();
                    if (nomeErogazione != null) {
                        de.setValue(nomeErogazione);
                    } else if (nomePortaSac0 != null) {
                        de.setValue(nomePortaSac0);
                    } else {
                        de.setValue("-");
                    }
                    e.add(de);
                    StringBuilder sbDestinatari = new StringBuilder();
                    if (dettaglio != null && dettaglio.getServizioApplicativoConsegnaList().size() > 0) {
                        for (int j = 0; j < messaggio.getDettaglio().getServizioApplicativoConsegnaList().size(); ++j) {
                            ServizioApplicativoConsegna sac = (ServizioApplicativoConsegna)messaggio.getDettaglio().getServizioApplicativoConsegnaList().get(j);
                            String nome = sac.getNome();
                            Boolean isServer = null;
                            String nomeConnettore = null;
                            String endpointConnettore = null;
                            if (sac.getNomePorta() != null) {
                                ServizioApplicativo sa2;
                                PortaApplicativa pa;
                                String keyPorta = sac.getNomePorta() + "#" + nome;
                                isServer = (Boolean)mapServer.get(keyPorta);
                                nomeConnettore = (String)mapConnettori.get(keyPorta);
                                endpointConnettore = (String)mapEndpointConnettori.get(keyPorta);
                                if (nomeConnettore == null) {
                                    pa = (PortaApplicativa)mapPA.get(sac.getNomePorta());
                                    if (pa == null) {
                                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                                        idPA.setNome(sac.getNomePorta());
                                        try {
                                            pa = paCore.getPortaApplicativa(idPA);
                                            mapPA.put(sac.getNomePorta(), pa);
                                        }
                                        catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                                            // empty catch block
                                        }
                                    }
                                    if (pa != null && pa.getBehaviour() != null && pa.sizeServizioApplicativoList() > 0) {
                                        for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                                            PortaApplicativaServizioApplicativo pasa = pa.getServizioApplicativo(k);
                                            if (!pasa.getNome().equals(nome)) continue;
                                            if (pasa.getDatiConnettore() == null) break;
                                            nomeConnettore = pasa.getDatiConnettore().getNome();
                                            break;
                                        }
                                    }
                                    if (nomeConnettore != null) {
                                        mapConnettori.put((CallSite)((Object)keyPorta), nomeConnettore);
                                    }
                                }
                                if (nomeConnettore == null && isServer == null) {
                                    pa = (PortaApplicativa)mapPA.get(sac.getNomePorta());
                                    if (pa == null) {
                                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                                        idPA.setNome(sac.getNomePorta());
                                        try {
                                            pa = paCore.getPortaApplicativa(idPA);
                                            mapPA.put(sac.getNomePorta(), pa);
                                        }
                                        catch (DriverConfigurazioneNotFound pasa) {
                                            // empty catch block
                                        }
                                    }
                                    if (pa != null) {
                                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                                        idSA.setNome(nome);
                                        idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                                        sa2 = null;
                                        try {
                                            sa2 = saCore.getServizioApplicativo(idSA);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (sa2 != null) {
                                            isServer = "server".equals(sa2.getTipo());
                                            mapServer.put((CallSite)((Object)keyPorta), isServer);
                                        }
                                    }
                                }
                                if (endpointConnettore == null && "Connettore".equals(sac.getTipoConsegna())) {
                                    pa = (PortaApplicativa)mapPA.get(sac.getNomePorta());
                                    if (pa == null) {
                                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                                        idPA.setNome(sac.getNomePorta());
                                        try {
                                            pa = paCore.getPortaApplicativa(idPA);
                                            mapPA.put(sac.getNomePorta(), pa);
                                        }
                                        catch (DriverConfigurazioneNotFound sa2) {
                                            // empty catch block
                                        }
                                    }
                                    if (pa != null) {
                                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                                        idSA.setNome(nome);
                                        idSA.setIdSoggettoProprietario(new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()));
                                        sa2 = null;
                                        try {
                                            sa2 = saCore.getServizioApplicativo(idSA);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        if (sa2 != null) {
                                            endpointConnettore = monitorHelper.getLabelConnettore(sa2.getInvocazioneServizio(), false, false);
                                            mapEndpointConnettori.put((CallSite)((Object)keyPorta), endpointConnettore);
                                        }
                                    }
                                }
                            }
                            if (consegnaMultipla != null && consegnaMultipla.booleanValue()) {
                                if (j > 0) {
                                    sbDestinatari.append("<br/>");
                                }
                                sbDestinatari.append("<b>");
                                if (isServer != null && isServer.booleanValue()) {
                                    sbDestinatari.append(nome);
                                } else if (nomeConnettore != null) {
                                    sbDestinatari.append(nomeConnettore);
                                } else {
                                    sbDestinatari.append(nome);
                                }
                                sbDestinatari.append("</b>");
                                sbDestinatari.append(". ");
                            }
                            boolean appenaPresoInCarico = false;
                            if ("Connettore".equals(sac.getTipoConsegna())) {
                                existsMessaggioInConsegna = true;
                                if ("TimerConsegnaContenutiApplicativi".equals(sac.getErroreProcessamento())) {
                                    appenaPresoInCarico = true;
                                    sbDestinatari.append("In coda in attesa di essere gestito");
                                } else if (sac.getDataRispedizione() != null) {
                                    sbDestinatari.append("Prossima Consegna").append(": ").append(formatterRispedizione.format(sac.getDataRispedizione()));
                                }
                                if (endpointConnettore != null) {
                                    int maxLengthConnettore = 200;
                                    sbDestinatari.append("<BR/>- endpoint: ");
                                    if (endpointConnettore.length() > maxLengthConnettore) {
                                        sbDestinatari.append(endpointConnettore.substring(0, maxLengthConnettore - 2) + "...");
                                    } else {
                                        sbDestinatari.append(endpointConnettore);
                                    }
                                }
                            } else if ("IntegrationManager".equals(sac.getTipoConsegna())) {
                                sbDestinatari.append("Disponibile tramite Servizio IntegrationManager/MessageBox");
                            } else if ("ConnectionReply".equals(sac.getTipoConsegna())) {
                                sbDestinatari.append("ConnectionReply".toLowerCase());
                            }
                            if (appenaPresoInCarico || sac.getErroreProcessamento() == null) continue;
                            String erroreProcessamento = sac.getErroreProcessamento();
                            sbDestinatari.append("<BR/>- errore: ");
                            int maxLengthErroreProcessamento = 200;
                            if (erroreProcessamento.length() > maxLengthErroreProcessamento) {
                                sbDestinatari.append(erroreProcessamento.substring(0, maxLengthErroreProcessamento - 2) + "...");
                                continue;
                            }
                            sbDestinatari.append(erroreProcessamento);
                        }
                    }
                    de = new DataElement();
                    de.setValue(sbDestinatari.toString());
                    e.add(de);
                    dati.add(e);
                }
            }
            pd.setAddButton(false);
            if (listaMessaggi != null && !listaMessaggi.isEmpty() && existsMessaggioInConsegna) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Riconsegna Immediata");
                de.setOnClick("RemoveEntries('resend')");
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                pd.setAreaBottoni(bottoni);
            }
            pd.setDati(dati);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private String getIntestazioneFiltroRicerca(String tipo, String nome) {
        if (tipo != null && StringUtils.isNotEmpty((String)tipo) && nome != null && StringUtils.isNotEmpty((String)nome)) {
            return tipo + "/" + nome;
        }
        if (nome != null && StringUtils.isNotEmpty((String)nome)) {
            return nome;
        }
        if (tipo != null && StringUtils.isNotEmpty((String)tipo)) {
            return "tipo " + tipo;
        }
        return null;
    }
}

