/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pd;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.TracciamentoConfigurazione;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletrace;
import org.openspcoop2.core.config.TracciamentoConfigurazioneFiletraceConnector;
import org.openspcoop2.core.config.Transazioni;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.constants.Severita;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateHelper;

public class PorteDelegateUtilities {
    private PorteDelegateUtilities() {
    }

    public static void deletePortaDelegataAzioni(PortaDelegata portaDelegata, AccordoServizioParteSpecifica asps, PorteDelegateCore porteDelegateCore, PorteDelegateHelper porteDelegateHelper, StringBuilder inUsoMessage, List<String> azioni, String userLogin) throws Exception {
        String azioneGiaEsistente = portaDelegata.getAzione().getAzioneDelegata(0);
        ConfigurazioneServizioAzione configAzioni = null;
        boolean updateASPS = false;
        Fruitore fruitore = null;
        for (Fruitore fruitoreCheck : asps.getFruitoreList()) {
            if (!fruitoreCheck.getTipo().equals(portaDelegata.getTipoSoggettoProprietario()) || !fruitoreCheck.getNome().equals(portaDelegata.getNomeSoggettoProprietario())) continue;
            fruitore = fruitoreCheck;
            break;
        }
        if (fruitore == null) {
            throw new Exception("Fruitore con id '" + portaDelegata.getTipoSoggettoProprietario() + "/" + portaDelegata.getNomeSoggettoProprietario() + "' non trovata");
        }
        for (int j = 0; j < fruitore.sizeConfigurazioneAzioneList(); ++j) {
            ConfigurazioneServizioAzione config = fruitore.getConfigurazioneAzione(j);
            if (config == null || !config.getAzioneList().contains(azioneGiaEsistente)) continue;
            configAzioni = config;
            break;
        }
        ConfigurazioneCore confCore = new ConfigurazioneCore(porteDelegateCore);
        StringBuilder bfTrasformazioni = new StringBuilder();
        StringBuilder bfCT = new StringBuilder();
        block2: for (int i = 0; i < azioni.size(); ++i) {
            int j;
            String azione = azioni.get(i);
            boolean usedInTrasformazioni = false;
            if (portaDelegata.getTrasformazioni() != null && portaDelegata.getTrasformazioni().sizeRegolaList() > 0) {
                for (TrasformazioneRegola trasformazioneRegola : portaDelegata.getTrasformazioni().getRegolaList()) {
                    if (trasformazioneRegola.getApplicabilita() == null || trasformazioneRegola.getApplicabilita().getAzioneList() == null || !trasformazioneRegola.getApplicabilita().getAzioneList().contains(azione)) continue;
                    usedInTrasformazioni = true;
                    break;
                }
            }
            if (confCore.usedInConfigurazioneControlloTrafficoAttivazionePolicy(RuoloPolicy.DELEGATA, portaDelegata.getNome(), azione)) {
                if (bfCT.length() > 0) {
                    bfCT.append(",");
                }
                bfCT.append(azione);
                continue;
            }
            if (usedInTrasformazioni) {
                if (bfTrasformazioni.length() > 0) {
                    bfTrasformazioni.append(",");
                }
                bfTrasformazioni.append(azione);
                continue;
            }
            for (j = 0; j < portaDelegata.getAzione().sizeAzioneDelegataList(); ++j) {
                String azioneDelegata = portaDelegata.getAzione().getAzioneDelegata(j);
                if (!azione.equals(azioneDelegata)) continue;
                portaDelegata.getAzione().removeAzioneDelegata(j);
                break;
            }
            if (configAzioni == null) continue;
            for (j = 0; j < configAzioni.sizeAzioneList(); ++j) {
                if (!configAzioni.getAzione(j).equals(azione)) continue;
                configAzioni.removeAzione(j);
                updateASPS = true;
                continue block2;
            }
        }
        if (portaDelegata.getAzione().sizeAzioneDelegataList() == 0) {
            inUsoMessage.append("Non &egrave; possibile eliminare tutte le azioni associate alla configurazione");
        } else if (bfCT.length() > 0) {
            inUsoMessage.append("Non \u00e8 stato possibile procedere con l'eliminazione poich\u00e8 utilizzate in configurazione di Rate Limiting: " + bfCT.toString());
        } else if (bfTrasformazioni.length() > 0) {
            inUsoMessage.append("Non \u00e8 stato possibile procedere con l'eliminazione poich\u00e8 utilizzate in criteri di applicabilit\u00e0 di una Trasformazione: " + bfTrasformazioni.toString());
        } else {
            ArrayList<Object> listaOggettiDaModificare = new ArrayList<Object>();
            listaOggettiDaModificare.add(portaDelegata);
            if (updateASPS) {
                listaOggettiDaModificare.add(asps);
            }
            porteDelegateCore.performUpdateOperation(userLogin, porteDelegateHelper.smista(), listaOggettiDaModificare.toArray());
        }
    }

    public static void initTracciamento(PortaDelegata pde, PorteDelegateCore porteDelegateCore, Configurazione config, String tracciamentoStato, String statoDiagnostici, String severita) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        PortaTracciamento portaTracciamento = pde.getTracciamento();
        if (portaTracciamento == null) {
            portaTracciamento = new PortaTracciamento();
            pde.setTracciamento(portaTracciamento);
        }
        portaTracciamento.setStato("ridefinito".equals(tracciamentoStato) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        if ("ridefinito".equals(tracciamentoStato)) {
            if (config == null) {
                config = porteDelegateCore.getConfigurazioneGenerale();
            }
            if (config.getTracciamento() != null && config.getTracciamento().getPortaDelegata() != null) {
                portaTracciamento.setDatabase(config.getTracciamento().getPortaDelegata().getDatabase());
                portaTracciamento.setFiletrace(config.getTracciamento().getPortaDelegata().getFiletrace());
                if (portaTracciamento.getFiletrace() != null && StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.equals((Object)portaTracciamento.getFiletrace().getStato())) {
                    portaTracciamento.getFiletrace().setStato(StatoFunzionalitaConPersonalizzazione.DISABILITATO);
                }
                portaTracciamento.setFiletraceConfig(config.getTracciamento().getPortaDelegata().getFiletraceConfig());
                portaTracciamento.setEsiti(config.getTracciamento().getPortaDelegata().getEsiti());
                portaTracciamento.setTransazioni(config.getTracciamento().getPortaDelegata().getTransazioni());
            }
        }
        if ("ridefinito".equals(statoDiagnostici)) {
            portaTracciamento.setSeverita(Severita.toEnumConstant((String)severita));
        } else {
            portaTracciamento.setSeverita(null);
        }
    }

    public static void setTracciamentoTransazioni(PortaDelegata pde, PorteDelegateCore porteDelegateCore, String dbStato, String dbStatoReqIn, String dbStatoReqOut, String dbStatoResOut, String dbStatoResOutComplete, boolean dbFiltroEsiti, String fsStato, String fsStatoReqIn, String fsStatoReqOut, String fsStatoResOut, String fsStatoResOutComplete, boolean fsFiltroEsiti, String nuovaConfigurazioneEsiti, String transazioniTempiElaborazione, String transazioniToken, String fileTraceStato, String fileTraceConfigFile, String fileTraceClient, String fileTraceClientHdr, String fileTraceClientBody, String fileTraceServer, String fileTraceServerHdr, String fileTraceServerBody) {
        PortaTracciamento portaTracciamento = pde.getTracciamento();
        if (portaTracciamento == null) {
            portaTracciamento = new PortaTracciamento();
            pde.setTracciamento(portaTracciamento);
        }
        TracciamentoConfigurazione database = porteDelegateCore.buildTracciamentoConfigurazioneDatabase(dbStato, dbStatoReqIn, dbStatoReqOut, dbStatoResOut, dbStatoResOutComplete, dbFiltroEsiti);
        portaTracciamento.setDatabase(database);
        TracciamentoConfigurazione filetrace = porteDelegateCore.buildTracciamentoConfigurazioneFiletrace(fsStato, fsStatoReqIn, fsStatoReqOut, fsStatoResOut, fsStatoResOutComplete, fsFiltroEsiti);
        portaTracciamento.setFiletrace(filetrace);
        if (StringUtils.isEmpty((String)nuovaConfigurazioneEsiti)) {
            portaTracciamento.setEsiti("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI);
        } else {
            portaTracciamento.setEsiti(nuovaConfigurazioneEsiti);
        }
        if (portaTracciamento.getTransazioni() == null) {
            portaTracciamento.setTransazioni(new Transazioni());
        }
        portaTracciamento.getTransazioni().setTempiElaborazione(StatoFunzionalita.toEnumConstant((String)transazioniTempiElaborazione));
        portaTracciamento.getTransazioni().setToken(StatoFunzionalita.toEnumConstant((String)transazioniToken));
        if ("ridefinito".equals(fileTraceStato)) {
            portaTracciamento.setFiletraceConfig(new TracciamentoConfigurazioneFiletrace());
            portaTracciamento.getFiletraceConfig().setConfig(fileTraceConfigFile);
            portaTracciamento.getFiletraceConfig().setDumpIn(new TracciamentoConfigurazioneFiletraceConnector());
            portaTracciamento.getFiletraceConfig().getDumpIn().setStato(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClient) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpIn().setHeader(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClientHdr) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpIn().setPayload(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClientBody) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().setDumpOut(new TracciamentoConfigurazioneFiletraceConnector());
            portaTracciamento.getFiletraceConfig().getDumpOut().setStato(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServer) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpOut().setHeader(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServerHdr) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
            portaTracciamento.getFiletraceConfig().getDumpOut().setPayload(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServerBody) ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        } else {
            portaTracciamento.setFiletraceConfig(null);
        }
    }
}

