/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class PddAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            PddHelper pddHelper = new PddHelper(request, pd, session);
            PddCore pddCore = new PddCore();
            String nome = pddHelper.getParameter("nome");
            String tipo = pddHelper.getParameter("tipo");
            String descrizione = pddHelper.getParameter("descrizione");
            String ip = pddHelper.getParameter("ip");
            String ipGestione = pddHelper.getParameter("ip_gestione");
            Object porta = pddHelper.getParameter("porta");
            Object portaGestione = pddHelper.getParameter("porta_gestione");
            String implementazione = pddHelper.getParameter("implementazione");
            Object subject = pddHelper.getParameter("subject");
            String clientAuth = pddHelper.getParameter("client_auth");
            String protocollo = pddHelper.getParameter("protocollo");
            String protocolloGestione = pddHelper.getParameter("protocollo_gestione");
            int portaInt = 0;
            int portaGestioneInt = 0;
            try {
                portaInt = Integer.parseInt((String)porta);
            }
            catch (NumberFormatException e) {
                portaInt = pddCore.getPortaPubblica();
            }
            try {
                portaGestioneInt = Integer.parseInt((String)portaGestione);
            }
            catch (NumberFormatException e) {
                portaGestioneInt = pddCore.getPortaGestione();
            }
            pddHelper.makeMenu();
            if (pddHelper.isEditModeInProgress()) {
                if (porta == null || "".equals(porta)) {
                    porta = "" + pddCore.getPortaPubblica();
                }
                if (ip == null || "".equals(ip)) {
                    ip = pddCore.getIndirizzoPubblico();
                }
                if (portaGestione == null || "".equals(portaGestione)) {
                    portaGestione = "" + pddCore.getPortaGestione();
                }
                if (ipGestione == null || "".equals(ipGestione)) {
                    ipGestione = pddCore.getIndirizzoGestione();
                }
                if (implementazione == null || "".equals(implementazione)) {
                    implementazione = "standard";
                }
                ServletUtils.setPageDataTitle_ServletAdd((PageData)pd, (String)"Porte di Dominio", (String)"pddList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = nome == null ? pddHelper.addPddToDati(dati, "", null, ip, "", "", "", PddTipologia.OPERATIVO, TipoOperazione.ADD, PddCostanti.getDefaultPddProtocolli(), "http", "http", portaInt, descrizione, ipGestione, portaGestioneInt, implementazione, CostantiConfigurazione.DISABILITATO.toString(), false) : pddHelper.addPddToDati(dati, nome, null, ip, (String)subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.ADD, PddCostanti.getDefaultPddProtocolli(), protocollo, protocolloGestione, portaInt, descrizione, ipGestione, portaGestioneInt, implementazione, clientAuth, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = pddHelper.pddCheckData(TipoOperazione.ADD, false);
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletAdd((PageData)pd, (String)"Porte di Dominio", (String)"pddList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = pddHelper.addPddToDati(dati, nome, null, ip, (String)subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.ADD, PddCostanti.getDefaultPddProtocolli(), protocollo, protocolloGestione, portaInt, descrizione, ipGestione, portaGestioneInt, implementazione, clientAuth, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.ADD());
            }
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            if (subject == null || ((String)subject).trim().equals("")) {
                subject = "C=IT,O=" + nome;
                if (ip != null && !ip.equals("")) {
                    subject = (String)subject + ",OU=" + ip;
                }
            }
            PdDControlStation pdd = new PdDControlStation();
            pdd.setNome(nome);
            pdd.setTipo(tipo);
            if (subject != null && !"".equals(subject)) {
                pdd.setSubject((String)subject);
            } else {
                pdd.setSubject(null);
            }
            pdd.setDescrizione(descrizione);
            pdd.setImplementazione(implementazione);
            pdd.setClientAuth(StatoFunzionalita.toEnumConstant((String)clientAuth));
            if (tipo.equals(PddTipologia.OPERATIVO.toString()) || tipo.equals(PddTipologia.NONOPERATIVO.toString())) {
                pdd.setIp(ip);
                pdd.setProtocollo(protocollo);
                pdd.setPorta(portaInt);
                pdd.setIpGestione(ipGestione);
                pdd.setPortaGestione(portaGestioneInt);
                pdd.setProtocolloGestione(protocolloGestione);
            }
            pdd.setSuperUser(userLogin);
            pddCore.performCreateOperation(userLogin, pddHelper.smista(), pdd);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<PdDControlStation> lista = null;
            lista = pddCore.isVisioneOggettiGlobale(userLogin) ? pddCore.pddList(null, (ISearch)ricerca) : pddCore.pddList(userLogin, (ISearch)ricerca);
            pddHelper.preparePddList(lista, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.ADD());
        }
    }
}

