/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class PddChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            PddHelper pddHelper = new PddHelper(request, pd, session);
            PddCore pddCore = new PddCore();
            SoggettiCore soggettiCore = new SoggettiCore(pddCore);
            String id = pddHelper.getParameter("id");
            int idPdd = Integer.parseInt(id);
            String tipo = pddHelper.getParameter("tipo");
            String descrizione = pddHelper.getParameter("descrizione");
            String ip = pddHelper.getParameter("ip");
            String ipGestione = pddHelper.getParameter("ip_gestione");
            String porta = pddHelper.getParameter("porta");
            String portaGestione = pddHelper.getParameter("porta_gestione");
            String implementazione = pddHelper.getParameter("implementazione");
            String subject = pddHelper.getParameter("subject");
            String clientAuth = pddHelper.getParameter("client_auth");
            String protocollo = pddHelper.getParameter("protocollo");
            String protocolloGestione = pddHelper.getParameter("protocollo_gestione");
            int portaInt = 0;
            int portaGestioneInt = 0;
            try {
                portaInt = Integer.parseInt(porta);
            }
            catch (NumberFormatException e) {
                portaInt = pddCore.getPortaPubblica();
            }
            try {
                portaGestioneInt = Integer.parseInt(portaGestione);
            }
            catch (NumberFormatException e) {
                portaGestioneInt = pddCore.getPortaGestione();
            }
            String oldTipo = "";
            String oldProtocollo = "";
            String oldIp = "";
            int oldPortaGestione = 0;
            int oldPorta = 0;
            String oldProtocolloGestione = "";
            pddHelper.makeMenu();
            String nomePdd = "";
            PdDControlStation pdd = null;
            try {
                pdd = pddCore.getPdDControlStation(idPdd);
                nomePdd = pdd.getNome();
                oldTipo = pdd.getTipo();
                oldProtocollo = pdd.getProtocollo();
                oldPorta = pdd.getPorta();
                oldIp = pdd.getIp();
                oldProtocolloGestione = pdd.getProtocolloGestione();
                oldPortaGestione = pdd.getPortaGestione();
            }
            catch (Exception ex) {
                return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)ex, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
            }
            if (pddHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Porte di Dominio", (String)"pddList.do", (String)nomePdd);
                if (descrizione == null) {
                    ip = pdd.getIp();
                    tipo = pdd.getTipo();
                    protocollo = pdd.getProtocollo();
                    protocolloGestione = pdd.getProtocolloGestione();
                    subject = pdd.getSubject();
                    ipGestione = pdd.getIpGestione();
                    descrizione = pdd.getDescrizione();
                    if (pdd.getClientAuth() != null) {
                        clientAuth = pdd.getClientAuth().toString();
                    }
                    implementazione = pdd.getImplementazione();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                int portaPUBBLICA = oldPorta;
                int portaGESTIONE = oldPortaGestione;
                if (porta != null && !"".equals(porta)) {
                    try {
                        portaPUBBLICA = Integer.parseInt(porta);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (portaGestione != null && !"".equals(portaGestione)) {
                    try {
                        portaGESTIONE = Integer.parseInt(portaGestione);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                dati = pddHelper.addPddToDati(dati, nomePdd, id, ip, subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.CHANGE, PddCostanti.getDefaultPddProtocolli(), protocollo, protocolloGestione, portaPUBBLICA, descrizione, ipGestione, portaGESTIONE, implementazione, clientAuth, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = pddHelper.pddCheckData(TipoOperazione.CHANGE, false);
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Porte di Dominio", (String)"pddList.do", (String)nomePdd);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = pddHelper.addPddToDati(dati, nomePdd, id, ip, subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.CHANGE, PddCostanti.getDefaultPddProtocolli(), protocollo, protocolloGestione, portaInt, descrizione, ipGestione, portaGestioneInt, implementazione, clientAuth, false);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
            }
            pdd.setTipo(tipo);
            if (subject != null && !"".equals(subject)) {
                pdd.setSubject(subject);
            } else {
                pdd.setSubject(null);
            }
            pdd.setDescrizione(descrizione);
            pdd.setImplementazione(implementazione);
            pdd.setClientAuth(StatoFunzionalita.toEnumConstant((String)clientAuth));
            if (tipo.equals(PddTipologia.OPERATIVO.toString()) || tipo.equals(PddTipologia.NONOPERATIVO.toString())) {
                pdd.setIp(ip);
                pdd.setProtocollo(protocollo);
                pdd.setPorta(portaInt);
                pdd.setIpGestione(ipGestione);
                pdd.setPortaGestione(portaGestioneInt);
                pdd.setProtocolloGestione(protocolloGestione);
            }
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            if (!(tipo.equals(PddTipologia.ESTERNO.toString()) || protocollo.equals(oldProtocollo) && oldPorta == portaInt && ip.equals(oldIp))) {
                List<SoggettoCtrlStat> listaSoggetti = pddCore.soggettiWithServer(pdd.getNome());
                for (SoggettoCtrlStat soggetto : listaSoggetti) {
                    Soggetto soggReg = soggetto.getSoggettoReg();
                    Connettore connettore = soggReg.getConnettore();
                    if (!TipiConnettore.HTTP.getNome().equals(connettore.getTipo())) continue;
                    String msg = "[console] suffissoConnettoreAutomatico impostato al valore: " + pddCore.getSuffissoConnettoreAutomatico();
                    ControlStationLogger.getPddConsoleCoreLogger().info(msg);
                    Map properties = connettore.getProperties();
                    String oldHttpLocation = (String)properties.get("location");
                    String suffisso = pddCore.getSuffissoConnettoreAutomatico();
                    if (!oldHttpLocation.equals(oldProtocollo + "://" + oldIp + ":" + oldPorta + "/" + (suffisso = suffisso.replace("@protocol@", soggettiCore.getWebContextProtocolAssociatoTipoSoggetto(soggReg.getTipo()))))) continue;
                    String newHttpLocation = pdd.getProtocollo() + "://" + pdd.getIp() + ":" + pdd.getPorta() + "/" + suffisso;
                    HashMap<String, CallSite> newprop = new HashMap<String, CallSite>();
                    newprop.put("location", (CallSite)((Object)newHttpLocation));
                    connettore.setProperties(newprop);
                    pddCore.performUpdateOperation(userLogin, pddHelper.smista(), soggetto);
                }
            }
            if (oldTipo.equals(PddTipologia.NONOPERATIVO.toString()) && tipo.equals(PddTipologia.OPERATIVO.toString()) && pddCore.isSincronizzazionePddEngineEnabled()) {
                try {
                    ControlStationCore.logInfo("Avvio sincronizzazione causa passaggio Pdd non-operativo->operativo su Pdd [" + pdd.getNome() + "] da parte dell'utente [" + userLogin + "]");
                    pd.setMessage("Sincronizzazione Porta di Dominio " + pdd.getNome() + " Effettuata correttamente.", Costanti.MESSAGE_TYPE_INFO);
                }
                catch (Exception e) {
                    pd.setMessage("Sincronizzazione Porta di Dominio " + pdd.getNome() + " Non effettuata a causa di errori");
                    return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
                }
            }
            pddCore.performUpdateOperation(userLogin, pddHelper.smista(), pdd);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<PdDControlStation> lista = null;
            lista = pddCore.isVisioneOggettiGlobale(userLogin) ? pddCore.pddList(null, (ISearch)ricerca) : pddCore.pddList(userLogin, (ISearch)ricerca);
            pddHelper.preparePddList(lista, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"pdd", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

